/*
 * Decompiled with CFR 0.152.
 */
package com.beekeeper.xwd;

import com.beekeeper.util.ImageUtil;
import com.beekeeper.util.StringUtil;
import com.beekeeper.util.XmlUtil;
import com.beekeeper.xwd.GridState;
import com.beekeeper.xwd.WordGrid;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public final class CFPGrid {
    String title;
    String author;
    String copyright;
    String notePad;
    int width;
    int height;
    char[] chars;
    final BitSet circles;
    final StringUtil rebuses$6d32e3b8;
    Clue[] clues;
    private static final String TITLE_PATH = String.format("/CROSSFIRE/%s", "TITLE");
    private static final String AUTHOR_PATH = String.format("/CROSSFIRE/%s", "AUTHOR");
    private static final String COPYRIGHT_PATH = String.format("/CROSSFIRE/%s", "COPYRIGHT");
    private static final String GRID_PATH = String.format("/CROSSFIRE/%s", "GRID");
    private static final String CIRCLES_PATH = String.format("/CROSSFIRE/%s", "CIRCLES");
    private static final String REBUS_PATH = String.format("/CROSSFIRE/%s", "REBUSES/REBUS");
    private static final String WORD_PATH = String.format("/CROSSFIRE/%s", "WORDS/WORD");
    private static final String NOTES_PATH = String.format("/CROSSFIRE/%s", "NOTES");

    public CFPGrid(GridState gridState) {
        this.title = gridState.getTitle();
        this.author = gridState.getAuthor();
        this.copyright = gridState.getCopyright();
        this.notePad = gridState.getNotepad();
        WordGrid wordGrid = gridState.getGrid();
        this.width = wordGrid.getWidth();
        this.height = wordGrid.getHeight();
        this.chars = gridState.getChars();
        this.rebuses$6d32e3b8 = gridState.getRebuses$e04f0f9();
        this.circles = new BitSet(this.chars.length);
        this.circles.or(gridState.circles);
        this.clues = new Clue[gridState.getWordCount()];
        for (int i = 0; i < this.clues.length; ++i) {
            WordGrid.Word word = gridState.getWord(i);
            this.clues[i] = new Clue(word.getPrintNumber(), word.getDirection(), i, gridState.getClue(i), gridState.isTheme(i));
        }
        Arrays.sort(this.clues);
    }

    private CFPGrid(String string, String string2, String string3, String string4, int n, int n2, char[] cArray, Clue[] clueArray, BitSet bitSet, StringUtil stringUtil) {
        this.title = string;
        this.author = string2;
        this.copyright = string3;
        this.notePad = string4;
        this.width = n;
        this.height = n2;
        this.chars = cArray;
        this.clues = clueArray;
        this.circles = bitSet;
        this.rebuses$6d32e3b8 = stringUtil;
    }

    public final void write(OutputStream outputStream) {
        int n;
        Document document = XmlUtil.createDOMDocument();
        Element element = XmlUtil.appendElement(document, "CROSSFIRE");
        XmlUtil.appendTextElement(element, "VERSION", Integer.toString(1));
        XmlUtil.appendTextElement(element, "TITLE", this.title);
        XmlUtil.appendTextElement(element, "AUTHOR", this.author);
        XmlUtil.appendTextElement(element, "COPYRIGHT", this.copyright);
        Object object = new StringBuffer("\n");
        int n2 = 0;
        for (int i = 0; i < this.height; ++i) {
            n = 0;
            while (n < this.width) {
                char c = this.chars[n2];
                switch (c) {
                    case '\u0000': {
                        ((StringBuffer)object).append('-');
                        break;
                    }
                    case '\u007f': {
                        ((StringBuffer)object).append('.');
                        break;
                    }
                    default: {
                        ((StringBuffer)object).append(Character.toUpperCase(c));
                    }
                }
                ++n;
                ++n2;
            }
            ((StringBuffer)object).append("\n");
        }
        Element element2 = XmlUtil.appendElement(element, "GRID", "width", Integer.toString(this.width));
        XmlUtil.appendTextNode(element2, ((StringBuffer)object).toString());
        if (this.circles.length() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            n = this.circles.nextSetBit(0);
            while (n != -1) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(n);
                n = this.circles.nextSetBit(n + 1);
            }
            XmlUtil.appendTextElement(element, "CIRCLES", stringBuilder.toString());
        }
        if (this.rebuses$6d32e3b8.getRebusCount() > 0) {
            Element element3 = XmlUtil.appendElement(element, "REBUSES");
            for (ImageUtil imageUtil : this.rebuses$6d32e3b8.getRebuses()) {
                XmlUtil.appendElement(element3, "REBUS", "letters", imageUtil.letters, "input", Character.toString(imageUtil.inputChar), "display", Character.toString(imageUtil.displayChar));
            }
        }
        Element element4 = XmlUtil.appendElement(element, "WORDS");
        for (int i = 0; i < this.clues.length; ++i) {
            Clue clue = this.clues[i];
            object = XmlUtil.appendElement(element4, "WORD", "num", Integer.toString(clue.userNumber), "dir", WordGrid.DIR_NAMES[clue.direction], "id", Integer.toString(clue.cfNumber), "isTheme", Boolean.toString(clue.isTheme));
            XmlUtil.appendTextNode((Element)object, clue.text);
        }
        if (this.notePad != null) {
            XmlUtil.appendTextElement(element, "NOTES", this.notePad);
        }
        try {
            XmlUtil.printDOM(outputStream, document);
            outputStream.close();
            return;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private static String text(Node node) {
        if (node == null) {
            throw new RuntimeException("Missing expected element");
        }
        if ((node = node.getFirstChild()) == null) {
            return "";
        }
        if (!(node instanceof Text)) {
            throw new RuntimeException("Expected text value");
        }
        return node.getTextContent().trim();
    }

    /*
     * WARNING - void declaration
     */
    static CFPGrid read(InputStream object) {
        try {
            Object object2;
            int n;
            Clue[] clueArray;
            object = XmlUtil.parseToDOM((InputStream)object);
            String string = CFPGrid.text(XmlUtil.xpathFirst((Node)object, TITLE_PATH));
            String string2 = CFPGrid.text(XmlUtil.xpathFirst((Node)object, AUTHOR_PATH));
            String string3 = CFPGrid.text(XmlUtil.xpathFirst((Node)object, COPYRIGHT_PATH));
            Object object3 = XmlUtil.xpathFirst((Node)object, NOTES_PATH);
            object3 = object3 == null ? null : CFPGrid.text((Node)object3);
            Object object4 = XmlUtil.xpathFirst((Node)object, GRID_PATH);
            int n3 = Integer.parseInt(((Element)object4).getAttribute("width"));
            object4 = CFPGrid.text((Node)object4).replaceAll("\\s", "");
            int n4 = object4.length() / n3;
            char[] cArray = new char[object4.length()];
            int n5 = cArray.length;
            block9: for (int i = 0; i < n5; ++i) {
                char c = object4.charAt(i);
                switch (c) {
                    case '.': {
                        cArray[i] = 127;
                        continue block9;
                    }
                    case ':': {
                        cArray[i] = 127;
                        continue block9;
                    }
                    case '_': {
                        cArray[i] = '\u0000';
                        continue block9;
                    }
                    case '-': {
                        cArray[i] = '\u0000';
                        continue block9;
                    }
                    default: {
                        cArray[i] = Character.toLowerCase(c);
                    }
                }
            }
            BitSet bitSet = new BitSet(cArray.length);
            Node node = XmlUtil.xpathFirst((Node)object, CIRCLES_PATH);
            if (node != null) {
                void node2;
                String[] stringArray;
                object4 = stringArray = CFPGrid.text(node).split(",");
                int n6 = stringArray.length;
                boolean n2 = false;
                while (node2 < n6) {
                    clueArray = object4[node2];
                    bitSet.set(Integer.parseInt((String)clueArray));
                    ++node2;
                }
            }
            ArrayList<ImageUtil> arrayList = new ArrayList<ImageUtil>();
            object4 = XmlUtil.xpathMatches((Node)object, REBUS_PATH);
            for (Node node2 : object4) {
                clueArray = (Element)node2;
                object4 = clueArray.getAttribute("letters");
                char c = clueArray.getAttribute("input").charAt(0);
                n = clueArray.getAttribute("display").charAt(0);
                object2 = new ImageUtil((String)object4, c, (char)n);
                arrayList.add((ImageUtil)object2);
            }
            StringUtil stringUtil = new StringUtil(arrayList);
            List<Node> list = XmlUtil.xpathMatches((Node)object, WORD_PATH);
            clueArray = new Clue[list.size()];
            int n7 = 0;
            for (Node node3 : list) {
                object2 = CFPGrid.text(node3);
                Element element = (Element)node3;
                int n8 = Integer.parseInt(element.getAttribute("num"));
                n = WordGrid.parseDirection(element.getAttribute("dir"));
                int n2 = Integer.parseInt(element.getAttribute("id"));
                boolean bl = Boolean.parseBoolean(element.getAttribute("isTheme"));
                clueArray[n7++] = new Clue(n8, n, n2, (String)object2, bl);
            }
            return new CFPGrid(string, string2, string3, (String)object3, n3, n4, cArray, clueArray, bitSet, stringUtil);
        }
        catch (NumberFormatException numberFormatException) {
            throw new RuntimeException("Bad input file: badly formed 'circles' field");
        }
        catch (NullPointerException nullPointerException) {
            throw new RuntimeException("Bad input file: could not parse fields");
        }
    }

    public static final class Clue
    implements Comparable<Clue> {
        int userNumber;
        int direction;
        int cfNumber;
        String text;
        boolean isTheme;

        public Clue(int n, int n2, int n3, String string, boolean bl) {
            this.cfNumber = n3;
            this.direction = n2;
            this.text = string;
            this.userNumber = n;
            this.isTheme = bl;
        }
    }
}

