/*
 * Decompiled with CFR 0.152.
 */
package com.beekeeper.xwd;

import com.beekeeper.util.GridHelper;
import com.beekeeper.util.ImageUtil;
import com.beekeeper.util.PersistentComboBox;
import com.beekeeper.util.PersistentSpinner;
import com.beekeeper.util.StringUtil;
import com.beekeeper.xwd.BuffWordList;
import com.beekeeper.xwd.CCRebusPanel;
import com.beekeeper.xwd.CrossFire;
import com.beekeeper.xwd.GridState;
import com.beekeeper.xwd.Table15;
import com.beekeeper.xwd.WordGrid;
import com.beekeeper.xwd.WordList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;

public final class CCWordPanel
extends JPanel
implements CrossFire.CCTab {
    final String[] columns = new String[]{"Word", "Score", "XScore", "Length"};
    private final CrossFire cc;
    private final JLabel wordScoreLabel = new JLabel("");
    private final JLabel crossScoreLabel = new JLabel("");
    private Table15 table;
    private final MyModel model = new MyModel(this, new TableData[0]);
    private boolean onlyShowRepeatedLetters = true;
    private int minRepeat = 3;
    private ArrayList<List<SharedStringInfo>> sharedStrings;

    private List<SharedStringInfo> findSharedWords(int n, GridState gridState, int n2) {
        ArrayList<SharedStringInfo> arrayList = new ArrayList<SharedStringInfo>();
        String string = gridState.getCompleteWord(n);
        if (string == null) {
            return arrayList;
        }
        if (string.length() < n2) {
            return arrayList;
        }
        int n3 = gridState.getWordCount();
        for (int i = 0; i < n3; ++i) {
            String string2;
            if (i == n || (string2 = gridState.getCompleteWord(i)) == null || string2.length() < n2) continue;
            int n4 = string.length() - n2;
            for (int j = 0; j <= n4; ++j) {
                int n5 = string.length() - j;
                int n6 = string2.length() - n2;
                for (int k = 0; k <= n6; ++k) {
                    int n7;
                    int n8 = Math.min(string2.length() - k, n5);
                    for (n7 = 0; n7 < n8 && string.charAt(j + n7) == string2.charAt(k + n7); ++n7) {
                    }
                    if (n7 < n2) continue;
                    n8 = n7;
                    int n9 = j;
                    Iterator<ImageUtil> iterator = this.cc.getRebusPanel();
                    iterator = ((CCRebusPanel)((Object)iterator)).rebuses$6d32e3b8;
                    for (ImageUtil imageUtil : ((StringUtil)((Object)iterator)).getRebuses()) {
                        int n10 = string.lastIndexOf(imageUtil.inputChar, j - 1);
                        while (n10 != -1) {
                            n9 += imageUtil.letters.length() - 1;
                            n10 = string.lastIndexOf(imageUtil.inputChar, n10 - 1);
                        }
                        n10 = string.lastIndexOf(imageUtil.inputChar, j + n7 - 1);
                        while (n10 >= j) {
                            n8 += imageUtil.letters.length() - 1;
                            n10 = string.lastIndexOf(imageUtil.inputChar, n10 - 1);
                        }
                    }
                    arrayList.add(new SharedStringInfo(i, n7, k, n8, n9));
                }
            }
        }
        return arrayList;
    }

    protected final void doPopupMenu(MouseEvent mouseEvent) {
        Object object;
        int n = this.table.rowAtPoint(mouseEvent.getPoint());
        if (n < 0) {
            return;
        }
        n = this.table.convertRowIndexToModel(n);
        Object object2 = this.model;
        synchronized (object2) {
            object = this.model.getValueAt(n);
        }
        object2 = object;
        object = ((TableData)object2).word;
        object = this.cc.createWordPopup(this, (String)object);
        ((JPopupMenu)object).show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    private void doUpdate() {
        int n;
        int n2;
        int n3;
        int n4;
        GridState gridState = this.cc.getDisplay().getState();
        if (gridState == null) {
            return;
        }
        if (!this.isShowing()) {
            return;
        }
        int n5 = this.minRepeat;
        GridState gridState2 = gridState;
        Object object = this;
        ArrayList<List<SharedStringInfo>> arrayList = new ArrayList<List<SharedStringInfo>>(gridState2.getWordCount());
        int n6 = gridState2.getWordCount();
        for (n4 = 0; n4 < n6; ++n4) {
            arrayList.add(((CCWordPanel)object).findSharedWords(n4, gridState2, n5));
        }
        this.sharedStrings = arrayList;
        object = gridState.getGrid();
        int n7 = ((WordGrid)object).getWordCount();
        int[] nArray = new int[Math.max(((WordGrid)object).getWidth(), ((WordGrid)object).getHeight()) + 1];
        int n8 = 0;
        n4 = 0;
        n6 = 0;
        float[] fArray = new float[n7];
        for (int i = 0; i < n7; ++i) {
            float f;
            Object object2 = ((WordGrid)object).getWord(i);
            int n9 = n3 = ((WordGrid.Word)object2).letterIndices.length;
            nArray[n9] = nArray[n9] + 1;
            if (!gridState.isComplete(i)) continue;
            ++n8;
            object2 = gridState.getString(i);
            fArray[i] = f = this.cc.getWordList().getWordScore((String)object2);
            n6 = (int)((float)n6 + f);
            if (this.onlyShowRepeatedLetters && this.sharedStrings.get(i).isEmpty()) continue;
            ++n4;
        }
        this.wordScoreLabel.setText(n8 == 0 ? "N/A" : Float.toString((float)(n6 * 100 / n8) / 100.0f));
        char[] cArray = gridState.getChars();
        n3 = 0;
        float f = 0.0f;
        block2: for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c == '\u007f' || c == '\u0000') continue;
            float f2 = 1.0f;
            int n10 = ((WordGrid)object).getCrossWordCount(i);
            for (n6 = 0; n6 < n10; ++n6) {
                n2 = ((WordGrid)object).getCrossWord(i, n6);
                if (!gridState.isComplete(n2)) continue block2;
                f2 *= fArray[n2];
            }
            ++n3;
            f = (float)((double)f + Math.sqrt(f2));
        }
        this.crossScoreLabel.setText(n3 == 0 ? "N/A" : String.format("%4.2f", Float.valueOf(f / (float)n3)));
        TableData[] tableDataArray = new TableData[n4];
        int n11 = 0;
        for (n = 0; n < n7; ++n) {
            if (!gridState.isComplete(n) || this.onlyShowRepeatedLetters && this.sharedStrings.get(n).isEmpty()) continue;
            WordGrid.Word word = ((WordGrid)object).getWord(n);
            float f3 = fArray[n];
            n2 = 1;
            WordGrid.Word word2 = word;
            n3 = word2.letterIndices.length;
            block5: for (n4 = 0; n4 < n3; ++n4) {
                int n12 = n4;
                WordGrid.Word word3 = word;
                int n13 = word3.letterIndices[n12];
                if ((n12 = cArray[n13]) == 127 || n12 == 0) continue;
                float f4 = 1.0f;
                int n14 = ((WordGrid)object).getCrossWordCount(n13);
                for (int i = 0; i < n14; ++i) {
                    int n15 = ((WordGrid)object).getCrossWord(n13, i);
                    if (!gridState.isComplete(n15)) continue block5;
                    f4 *= fArray[n15];
                }
                f3 = (float)((double)f3 + Math.sqrt(f4));
                ++n2;
            }
            float f5 = (float)Math.rint(f3 / (float)n2 * 100.0f) / 100.0f;
            tableDataArray[n11++] = new TableData(this, gridState.getString(n), f5, n);
        }
        this.model.setData(tableDataArray);
        n = this.cc.getDisplay().getSelectedWord();
        int n16 = this.model.getRowCount();
        for (n6 = 0; n6 < n16; ++n6) {
            if (this.model.getRowObject((int)n6).wordNum != n || (n2 = this.table.getSelectedRow()) != -1 && this.table.convertRowIndexToModel(n2) == n6) continue;
            this.table.changeSelection(this.table.convertRowIndexToView(n6), 1, false, false);
        }
        this.updateHighlights();
    }

    public CCWordPanel(CrossFire crossFire) {
        this.cc = crossFire;
        this.setPreferredSize(new Dimension(10, 10));
        this.createTable(crossFire);
        Object object = new JPanel();
        ((JComponent)object).setBorder(BorderFactory.createTitledBorder("General"));
        Object object2 = new GridHelper((Container)object);
        ((GridHelper)object2).space().stretch().advance();
        ((GridHelper)object2).add(new JLabel("Avg. Word Score: ", 4)).add(this.wordScoreLabel).advance();
        ((GridHelper)object2).add(new JLabel("Avg. Cross Score: ", 4)).add(this.crossScoreLabel).advance();
        object2 = new String[]{"Highlight shared strings", "Show shared strings"};
        object2 = new PersistentComboBox((String[])object2, "/beekeeper labs/crossfire", "show shared option");
        PersistentSpinner persistentSpinner = new PersistentSpinner(3, 2, 99, "/beekeeper labs/crossfire", "show shared len");
        Object object3 = new ActionListener(){
            private /* synthetic */ PersistentComboBox val$combo;
            private /* synthetic */ CCWordPanel this$0;
            {
                this.this$0 = cCWordPanel;
                this.val$combo = persistentComboBox;
            }

            @Override
            public final void actionPerformed(ActionEvent actionEvent) {
                this.this$0.onlyShowRepeatedLetters = this.val$combo.getSelectedIndex() == 1;
                this.this$0.doUpdate();
            }
        };
        ((JComboBox)object2).addActionListener((ActionListener)object3);
        object3 = new ChangeListener(){
            private /* synthetic */ PersistentSpinner val$spin;
            private /* synthetic */ CCWordPanel this$0;
            {
                this.this$0 = cCWordPanel;
                this.val$spin = persistentSpinner;
            }

            @Override
            public final void stateChanged(ChangeEvent changeEvent) {
                this.this$0.minRepeat = (Integer)this.val$spin.getValue();
                this.this$0.doUpdate();
            }
        };
        persistentSpinner.addChangeListener((ChangeListener)object3);
        this.onlyShowRepeatedLetters = ((JComboBox)object2).getSelectedIndex() == 1;
        this.minRepeat = (Integer)persistentSpinner.getValue();
        object3 = new JPanel();
        ((JComponent)object3).setBorder(BorderFactory.createTitledBorder("Words"));
        GridHelper gridHelper = new GridHelper((Container)object3);
        gridHelper.stretch().space().space().space().advance();
        gridHelper.size(4, 1).add(new JScrollPane(this.table)).advance(0, 1.0);
        gridHelper.advance(4);
        gridHelper.add((Component)object2).add(new JLabel(" at least ")).add(persistentSpinner).add(new JLabel(" letters long")).advance();
        object2 = new GridHelper(this).motion(3);
        ((GridHelper)object2).add((Component)object).space(10).weight(1.0, 1.0).add((Component)object3);
        object = new Runnable(this){
            private /* synthetic */ CCWordPanel this$0;
            {
                this.this$0 = cCWordPanel;
            }

            @Override
            public final void run() {
                this.this$0.doUpdate();
            }
        };
        crossFire.addStateAction((Runnable)object);
        crossFire.getWordMonitor().addListener(new WordList.WordListListener(this){
            private /* synthetic */ CCWordPanel this$0;
            {
                this.this$0 = cCWordPanel;
            }

            @Override
            public final void spellingChanged(String string, String string2, boolean bl) {
                this.this$0.doUpdate();
            }

            @Override
            public final void scoreChanged(String string, float f, float f2) {
                this.this$0.doUpdate();
            }

            @Override
            public final void wordListChanged() {
                this.this$0.doUpdate();
            }
        });
        crossFire.getDisplay().addSelectionListener(new Runnable(){
            private /* synthetic */ CrossFire val$cc;
            private /* synthetic */ CCWordPanel this$0;
            {
                this.this$0 = cCWordPanel;
                this.val$cc = crossFire;
            }

            @Override
            public final void run() {
                int n = this.val$cc.getDisplay().getSelectedWord();
                int n2 = this.this$0.model.getRowCount();
                for (int i = 0; i < n2; ++i) {
                    int n3;
                    if (this.this$0.model.getRowObject((int)i).wordNum != n || (n3 = this.this$0.table.getSelectedRow()) != -1 && this.this$0.table.convertRowIndexToModel(n3) == i) continue;
                    this.this$0.table.changeSelection(this.this$0.table.convertRowIndexToView(i), 1, false, false);
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(this, crossFire){
            private /* synthetic */ CrossFire val$cc;
            private /* synthetic */ CCWordPanel this$0;
            {
                this.this$0 = cCWordPanel;
                this.val$cc = crossFire;
            }

            @Override
            public final void componentShown(ComponentEvent componentEvent) {
                this.val$cc.getLetterPanel().setVisible(false);
                this.this$0.doUpdate();
            }

            @Override
            public final void componentHidden(ComponentEvent componentEvent) {
                this.val$cc.getDisplay().removeDisplay("count3");
            }
        });
    }

    private void createTable(CrossFire crossFire) {
        Serializable serializable;
        this.table = new Table15(this.model);
        DefaultTableColumnModel defaultTableColumnModel = (DefaultTableColumnModel)this.table.getColumnModel();
        FontRenderContext fontRenderContext = new FontRenderContext(new AffineTransform(), false, false);
        Font font = UIManager.getDefaults().getFont("Table.font");
        Font font2 = font.deriveFont(1);
        for (int i = 0; i < defaultTableColumnModel.getColumnCount(); ++i) {
            serializable = defaultTableColumnModel.getColumn(i);
            String string = i > 0 ? this.model.getColumnName(i) : "ABCDEFGHIJKLMNOPQRST";
            int n = (int)font.getStringBounds(string, fontRenderContext).getWidth() + 12;
            serializable.setPreferredWidth(n);
        }
        this.table.setAutoCreateRowSorter(true);
        this.table.setUpdateSelectionOnSort(true);
        this.table.setSorting(new int[]{2, 1, 1, 1, 0, 1});
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(this){
            private /* synthetic */ CCWordPanel this$0;
            {
                this.this$0 = cCWordPanel;
            }

            @Override
            public final void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                if (this.this$0.isShowing()) {
                    this.this$0.updateHighlights();
                }
            }
        });
        this.table.addMouseListener(new MouseAdapter(this){
            private /* synthetic */ CCWordPanel this$0;
            {
                this.this$0 = cCWordPanel;
            }

            @Override
            public final void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    this.this$0.doPopupMenu(mouseEvent);
                }
            }

            @Override
            public final void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    this.this$0.doPopupMenu(mouseEvent);
                }
            }
        });
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        serializable = new DefaultTableCellRenderer();
        TableCellRenderer tableCellRenderer = new TableCellRenderer(){
            private /* synthetic */ CrossFire val$cc1;
            private /* synthetic */ DefaultTableCellRenderer val$selRenderer;
            private /* synthetic */ DefaultTableCellRenderer val$unselRenderer;
            private /* synthetic */ Font val$boldFont;
            private /* synthetic */ Font val$stdFont;
            private /* synthetic */ CCWordPanel this$0;
            {
                this.this$0 = cCWordPanel;
                this.val$cc1 = crossFire;
                this.val$selRenderer = defaultTableCellRenderer;
                this.val$unselRenderer = defaultTableCellRenderer2;
                this.val$boldFont = font;
                this.val$stdFont = font2;
            }

            @Override
            public final Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                int n3 = this.this$0.table.convertColumnIndexToModel(n2);
                int n4 = this.this$0.table.convertRowIndexToModel(n);
                int n5 = this.this$0.model.getValueAt((int)n4).wordNum;
                boolean bl3 = false;
                if (n3 == 0) {
                    bl3 = this.val$cc1.getDisplay().getState().isTheme(n5);
                    List<SharedStringInfo> list = this.this$0.sharedStrings.get(n5);
                    if (!list.isEmpty()) {
                        object = this.this$0.model.getHighlightedWord(n4, bl3);
                    }
                }
                Component component = bl ? this.val$selRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2) : this.val$unselRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (n3 == 0) {
                    component.setFont(bl3 ? this.val$boldFont : this.val$stdFont);
                }
                return component;
            }
        };
        this.table.setDefaultRenderer(Object.class, tableCellRenderer);
    }

    @Override
    public final String[] getSelectedWords() {
        int[] nArray = this.table.getSelectedRows();
        if (nArray.length == 0) {
            return new String[0];
        }
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            stringArray[i] = this.model.getWord(this.table.convertRowIndexToModel(nArray[i]));
        }
        return stringArray;
    }

    private void updateHighlights() {
        Object object;
        int n = this.table.getSelectedRow();
        this.cc.getDisplay().removeDisplay("count3");
        if (n == -1) {
            return;
        }
        TableData tableData = this.model.getRowObject(this.table.convertRowIndexToModel(n));
        int n2 = tableData.wordNum;
        if (this.cc.getDisplay().getSelectedWord() != n2) {
            this.cc.getDisplay().setSelectedWord(n2);
        }
        if (!(object = this.sharedStrings.get(n2)).isEmpty()) {
            HashMap<Integer, Character> hashMap = new HashMap<Integer, Character>();
            object = object.iterator();
            while (object.hasNext()) {
                SharedStringInfo sharedStringInfo = (SharedStringInfo)object.next();
                WordGrid.Word word = this.cc.getDisplay().getState().getWord(sharedStringInfo.secondWord);
                int n3 = sharedStringInfo.secondStart;
                int n4 = sharedStringInfo.secondStart + sharedStringInfo.len;
                while (n3 < n4) {
                    int n5 = n3++;
                    WordGrid.Word word2 = word;
                    hashMap.put(word2.letterIndices[n5], Character.valueOf(' '));
                }
            }
            this.cc.getDisplay().addCharDisplay("count3", hashMap, 1, new Color(0, true), new Color(0x77AAFFAA, true), null);
        }
    }

    static final class SharedStringInfo {
        int len;
        int secondWord;
        int secondStart;
        private final int rebusLen;
        private final int rebusFirst;

        public SharedStringInfo(int n, int n2, int n3, int n4, int n5) {
            this.len = n2;
            this.secondStart = n3;
            this.secondWord = n;
            this.rebusLen = n4;
            this.rebusFirst = n5;
        }
    }

    final class MyModel
    extends AbstractTableModel {
        private TableData[] data;
        private /* synthetic */ CCWordPanel this$0;

        protected MyModel(CCWordPanel cCWordPanel, TableData[] tableDataArray) {
            this.this$0 = cCWordPanel;
            this.data = tableDataArray;
        }

        @Override
        public final int getColumnCount() {
            return 4;
        }

        @Override
        public final String getColumnName(int n) {
            return this.this$0.columns[n];
        }

        @Override
        public final int getRowCount() {
            return this.data.length;
        }

        public final TableData getValueAt(int n) {
            return this.data[n];
        }

        @Override
        public final Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this.getWord(n);
                }
                case 1: {
                    n2 = n;
                    MyModel myModel = this;
                    return Float.valueOf(myModel.this$0.cc.getWordList().getWordScore(myModel.data[n2].word));
                }
                case 2: {
                    n2 = n;
                    MyModel myModel = this;
                    return Float.valueOf(myModel.data[n2].crossScore);
                }
                case 3: {
                    n2 = n;
                    Object object = this;
                    object = ((MyModel)object).data[n2].word;
                    return ((String)object).length();
                }
            }
            throw new IllegalStateException();
        }

        private String getWord(int n) {
            String string = this.data[n].word;
            string = this.this$0.cc.getWordList().getOrigWord(string);
            return string;
        }

        private String getHighlightedWord(int n, boolean bl) {
            String string = this.data[n].word;
            BuffWordList buffWordList = this.this$0.cc.getWordList();
            string = ((WordList)buffWordList).getOrigWord(string);
            String string2 = buffWordList.deleteNonLetters(string);
            if (string.length() < string2.length()) {
                return string2;
            }
            n = this.data[n].wordNum;
            List<SharedStringInfo> list = this.this$0.sharedStrings.get(n);
            if (!list.isEmpty()) {
                BitSet bitSet = new BitSet();
                for (SharedStringInfo sharedStringInfo : list) {
                    bitSet.set(sharedStringInfo.rebusFirst, sharedStringInfo.rebusFirst + sharedStringInfo.rebusLen);
                }
                list = new StringBuilder("<html>");
                if (bl) {
                    ((StringBuilder)((Object)list)).append("<B>");
                }
                int n2 = 0;
                boolean bl2 = false;
                for (int i = 0; i < string2.length(); ++i) {
                    char c = string2.charAt(i);
                    char c2 = string.charAt(n2);
                    while (buffWordList.translatedCharacter(c2) != c) {
                        ((StringBuilder)((Object)list)).append(c2);
                        c2 = string.charAt(++n2);
                    }
                    if (bitSet.get(i)) {
                        if (!bl2) {
                            ((StringBuilder)((Object)list)).append("<span color='#ff8800'>");
                            bl2 = true;
                        }
                    } else if (bl2) {
                        ((StringBuilder)((Object)list)).append("</span>");
                        bl2 = false;
                    }
                    ((StringBuilder)((Object)list)).append(c2);
                    ++n2;
                }
                if (bl2) {
                    ((StringBuilder)((Object)list)).append("</span>");
                }
                ((StringBuilder)((Object)list)).append(string.substring(n2));
                if (bl) {
                    ((StringBuilder)((Object)list)).append("</B>");
                }
                ((StringBuilder)((Object)list)).append("</html>");
                string = ((StringBuilder)((Object)list)).toString();
                return string;
            }
            if (bl) {
                return "<html><b>" + string + "</b></html>";
            }
            return string;
        }

        public final void setData(TableData[] tableDataArray) {
            this.data = tableDataArray;
            this.fireTableDataChanged();
        }

        public final TableData getRowObject(int n) {
            return this.data[n];
        }

        @Override
        public final boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public final Class<?> getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return String.class;
                }
                case 1: 
                case 2: {
                    return Float.class;
                }
                case 3: {
                    return Integer.class;
                }
            }
            throw new IllegalStateException();
        }
    }

    final class TableData {
        public String word;
        public float crossScore;
        public int wordNum;

        public TableData(CCWordPanel cCWordPanel, String string, float f, int n) {
            this.word = string;
            this.crossScore = f;
            this.wordNum = n;
        }
    }
}

