/*
 * Decompiled with CFR 0.152.
 */
package com.beekeeper.xwd;

import com.beekeeper.util.GUIUtil;
import com.beekeeper.util.GridHelper;
import com.beekeeper.util.NumberVerifier;
import com.beekeeper.xwd.BuffWordList;
import com.beekeeper.xwd.ClueData;
import com.beekeeper.xwd.ClueListPanel;
import com.beekeeper.xwd.CrossFire;
import com.beekeeper.xwd.Table15;
import com.beekeeper.xwd.WordList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.EventListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.text.JTextComponent;

public final class CCLookupPanel
extends JPanel
implements CrossFire.CCTab {
    final String[] columns = new String[]{"Word", "Score", "Length"};
    private final CrossFire cc;
    private final Table15 table;
    private final MyModel model = new MyModel(this, new String[0]);
    private final JPanel cluePanel;
    private final JSplitPane split;

    public CCLookupPanel(CrossFire crossFire) {
        Object object;
        Serializable serializable;
        this.cc = crossFire;
        this.setMinimumSize(new Dimension(10, 10));
        this.setPreferredSize(new Dimension(10, 10));
        Serializable serializable2 = new JPanel();
        ((JComponent)serializable2).setBorder(BorderFactory.createTitledBorder("Words"));
        Object object2 = new GridHelper((Container)serializable2);
        this.table = new Table15(this.model);
        EventListener eventListener = (DefaultTableColumnModel)this.table.getColumnModel();
        Object object3 = new FontRenderContext(new AffineTransform(), false, false);
        Serializable serializable3 = UIManager.getDefaults().getFont("Table.font");
        for (int i = 0; i < ((DefaultTableColumnModel)eventListener).getColumnCount(); ++i) {
            serializable = ((DefaultTableColumnModel)eventListener).getColumn(i);
            object = i > 0 ? this.model.getColumnName(i) : "ABCDEFGHIJKLMNOPQRST";
            int n = (int)serializable3.getStringBounds((String)object, (FontRenderContext)object3).getWidth() + 12;
            ((TableColumn)serializable).setPreferredWidth(n);
        }
        this.table.setAutoCreateRowSorter(true);
        this.table.setUpdateSelectionOnSort(true);
        this.table.setSortOnUpdate(true);
        this.table.setSorting(new int[]{2, 1});
        JTextField jTextField = new JTextField(20);
        serializable = new JTextField("0", 5);
        object = new JTextField("", 5);
        JComboBox<ContentType> jComboBox = new JComboBox<ContentType>(ContentType.values());
        eventListener = new JComboBox<Attachment>(Attachment.values());
        ((JComponent)serializable).setInputVerifier(new NumberVerifier("min score", true, true));
        ((JComponent)object).setInputVerifier(new RangeVerifier(true));
        object3 = new AbstractAction(this, "Search", jTextField, (JTextField)serializable, (JTextField)object, (JComboBox)eventListener, jComboBox){
            private /* synthetic */ JTextField val$searchField;
            private /* synthetic */ JTextField val$minScoreField;
            private /* synthetic */ JTextField val$lenField;
            private /* synthetic */ JComboBox val$attachChoice;
            private /* synthetic */ JComboBox val$contentChoice;
            private /* synthetic */ CCLookupPanel this$0;
            {
                this.this$0 = cCLookupPanel;
                this.val$searchField = jTextField;
                this.val$minScoreField = jTextField2;
                this.val$lenField = jTextField3;
                this.val$attachChoice = jComboBox;
                this.val$contentChoice = jComboBox2;
                super(string);
            }

            @Override
            public final void actionPerformed(ActionEvent actionEvent) {
                this.this$0.doSearch(this.val$searchField, this.val$minScoreField, this.val$lenField, this.val$attachChoice, this.val$contentChoice);
            }
        };
        serializable3 = new JButton((Action)object3);
        jTextField.addActionListener((ActionListener)object3);
        ((JTextField)object).addActionListener((ActionListener)object3);
        ((JComboBox)eventListener).addActionListener((ActionListener)object3);
        jComboBox.addActionListener((ActionListener)object3);
        ((JTextField)serializable).addActionListener((ActionListener)object3);
        ((GridHelper)object2).stretch().advance();
        ((GridHelper)object2).add(new JScrollPane(this.table)).advance(0, 1.0);
        this.cluePanel = new JPanel(new BorderLayout());
        this.cluePanel.setBorder(BorderFactory.createTitledBorder("Clue DB"));
        this.cluePanel.setPreferredSize(new Dimension(10, 120));
        this.cluePanel.setMinimumSize(new Dimension(10, 120));
        this.cluePanel.setMaximumSize(new Dimension(10, 120));
        this.cluePanel.setVisible(true);
        object2 = new ListSelectionListener(){
            private /* synthetic */ CrossFire val$cc;
            private /* synthetic */ CCLookupPanel this$0;
            {
                this.this$0 = cCLookupPanel;
                this.val$cc = crossFire;
            }

            @Override
            public final void valueChanged(ListSelectionEvent object) {
                if (((ListSelectionEvent)object).getValueIsAdjusting()) {
                    return;
                }
                object = this.val$cc.getClueData();
                this.this$0.updateClueVisibility();
                int n = this.this$0.table.getSelectedRow();
                if (n < 0 || n >= this.this$0.model.data.length) {
                    this.this$0.cluePanel.removeAll();
                    this.this$0.cluePanel.validate();
                    this.this$0.cluePanel.repaint();
                    return;
                }
                if (object == null) {
                    return;
                }
                n = this.this$0.table.convertRowIndexToModel(n);
                BuffWordList buffWordList = this.val$cc.getWordList();
                String string = buffWordList.getTrueLetters(buffWordList.getOrigWord(this.this$0.model.data[n]));
                object = new ClueListPanel(string, (ClueData)object);
                this.this$0.cluePanel.removeAll();
                object = new JScrollPane((Component)object);
                ((JScrollPane)object).getViewport().setBackground(Color.white);
                ((JComponent)object).setPreferredSize(new Dimension(10, 10));
                this.this$0.cluePanel.add((Component)object, "Center");
                ((Container)object).invalidate();
                this.this$0.cluePanel.validate();
                this.this$0.cluePanel.repaint();
            }
        };
        this.table.getSelectionModel().addListSelectionListener((ListSelectionListener)object2);
        this.table.addMouseListener(new MouseAdapter(this){
            private /* synthetic */ CCLookupPanel this$0;
            {
                this.this$0 = cCLookupPanel;
            }

            @Override
            public final void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    this.this$0.doPopupMenu(mouseEvent);
                }
            }

            @Override
            public final void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    this.this$0.doPopupMenu(mouseEvent);
                }
            }
        });
        this.split = new JSplitPane(0, (Component)serializable2, this.cluePanel);
        this.split.setResizeWeight(1.0);
        this.split.setOneTouchExpandable(true);
        this.split.setDividerSize(9);
        this.split.setContinuousLayout(true);
        this.split.setBorder(null);
        serializable2 = new GridHelper(this);
        ((GridHelper)serializable2).space().stretch().space().advance();
        ((GridHelper)serializable2).add(new GUIUtil.RightLabel("Pattern: ")).add(jTextField).advance();
        ((GridHelper)serializable2).add(new GUIUtil.RightLabel("Attach ends:")).add((Component)((Object)eventListener)).advance();
        ((GridHelper)serializable2).add(new GUIUtil.RightLabel("Content: ")).add(jComboBox).advance();
        ((GridHelper)serializable2).add(new GUIUtil.RightLabel("Length:")).add((Component)object).advance();
        ((GridHelper)serializable2).space().add(new JLabel("Examples: \"9\"; \"11-15\", \"8-9,15\"")).advance();
        ((GridHelper)serializable2).add(new GUIUtil.RightLabel("Min score: ")).add((Component)serializable).advance();
        ((GridHelper)serializable2).size(2, 1).add(GUIUtil.createButtonBox(new AbstractButton[]{serializable3})).advance();
        ((GridHelper)serializable2).advance(10);
        ((GridHelper)serializable2).size(3, 1).add(this.split).advance(0, 1.0);
        this.addComponentListener(new ComponentAdapter(this, crossFire){
            private /* synthetic */ CrossFire val$cc;
            private /* synthetic */ CCLookupPanel this$0;
            {
                this.this$0 = cCLookupPanel;
                this.val$cc = crossFire;
            }

            @Override
            public final void componentShown(ComponentEvent componentEvent) {
                this.val$cc.getLetterPanel().setVisible(false);
                this.this$0.updateClueVisibility();
            }
        });
        crossFire.getWordMonitor().addListener(new WordList.WordListListener(this, jTextField, (JTextField)serializable, (JTextField)object, (JComboBox)eventListener, jComboBox){
            private /* synthetic */ JTextField val$searchField;
            private /* synthetic */ JTextField val$minScoreField;
            private /* synthetic */ JTextField val$lenField;
            private /* synthetic */ JComboBox val$attachChoice;
            private /* synthetic */ JComboBox val$contentChoice;
            private /* synthetic */ CCLookupPanel this$0;
            {
                this.this$0 = cCLookupPanel;
                this.val$searchField = jTextField;
                this.val$minScoreField = jTextField2;
                this.val$lenField = jTextField3;
                this.val$attachChoice = jComboBox;
                this.val$contentChoice = jComboBox2;
            }

            private void doChange() {
                this.this$0.doSearch(this.val$searchField, this.val$minScoreField, this.val$lenField, this.val$attachChoice, this.val$contentChoice);
            }

            private void doChange(String string) {
                int n = this.this$0.model.getRowCount();
                for (int i = 0; i < n; ++i) {
                    String string2 = this.this$0.model.getRowObject(i);
                    if (!string.equals(string2)) continue;
                    int n2 = i;
                    this.this$0.model.fireTableRowsUpdated(n2, n2);
                    return;
                }
            }

            @Override
            public final void spellingChanged(String string, String string2, boolean bl) {
                if (bl) {
                    this.doChange();
                    return;
                }
                this.doChange(string);
            }

            @Override
            public final void scoreChanged(String object, float f, float f2) {
                block4: {
                    f = 0.0f;
                    try {
                        f = Float.parseFloat(this.val$minScoreField.getText());
                    }
                    catch (NumberFormatException numberFormatException) {}
                    if (f2 < f) {
                        String string = object;
                        object = this;
                        int n = object.this$0.model.getRowCount();
                        for (int i = 0; i < n; ++i) {
                            String string2 = object.this$0.model.getRowObject(i);
                            if (!string.equals(string2)) continue;
                            object.this$0.model.remove(i);
                            break block4;
                        }
                        return;
                    }
                    this.doChange((String)object);
                }
            }

            @Override
            public final void wordListChanged() {
                this.doChange();
            }
        });
    }

    @Override
    public final String[] getSelectedWords() {
        int[] nArray = this.table.getSelectedRows();
        if (nArray.length == 0) {
            return new String[0];
        }
        String[] stringArray = new String[nArray.length];
        int n = this.table.convertColumnIndexToView(0);
        for (int i = 0; i < nArray.length; ++i) {
            stringArray[i] = this.table.getValueAt(nArray[i], n).toString();
        }
        return stringArray;
    }

    private void doSearch(JTextField object, JTextField jTextField, JTextField object2, JComboBox<Attachment> object3, JComboBox<ContentType> object4) {
        object4 = (ContentType)((Object)((JComboBox)object4).getSelectedItem());
        if (((String)(object = ((JTextComponent)object).getText())).length() == 0) {
            return;
        }
        if (!((JComponent)object2).getInputVerifier().shouldYieldFocus((JComponent)object2)) {
            return;
        }
        if (!jTextField.getInputVerifier().shouldYieldFocus(jTextField)) {
            return;
        }
        try {
            float f = Float.parseFloat(jTextField.getText());
            object3 = ((JComboBox)object3).getSelectedItem();
            if (!(object3 != Attachment.Start && object3 != Attachment.Both || ((String)object).startsWith("^"))) {
                object = "^" + (String)object;
            }
            if (!(object3 != Attachment.End && object3 != Attachment.Both || ((String)object).startsWith("$"))) {
                object = (String)object + "$";
            }
            if (object4 == ContentType.LowercasePunctuated) {
                object = "(?i)" + (String)object;
            }
            object = Pattern.compile((String)object);
            object3 = this.cc.getWordList();
            object2 = ((JTextComponent)object2).getText().trim();
            BitSet bitSet = new BitSet();
            if (((String)object2).length() == 0) {
                bitSet.set(1, ((WordList)object3).getMaxLength() + 1);
            } else {
                for (String string : ((String)object2).split(", *+")) {
                    int n = string.indexOf(45);
                    if (n == -1) {
                        bitSet.set(Integer.parseInt(string));
                        continue;
                    }
                    int n2 = Integer.parseInt(string.substring(0, n));
                    int n3 = Math.min(((WordList)object3).getMaxLength(), Integer.parseInt(string.substring(n + 1)));
                    if (n3 < n2) continue;
                    bitSet.set(n2, n3 + 1);
                }
            }
            object2 = new ArrayList();
            int n = ((WordList)object3).getMaxLength() + 1;
            for (int i = 1; i < n; ++i) {
                if (!bitSet.get(i)) continue;
                StringBuilder stringBuilder = new StringBuilder();
                for (int j = 0; j < i; ++j) {
                    stringBuilder.append('_');
                }
                String string = stringBuilder.toString();
                WordList.MatchInfo matchInfo = ((WordList)object3).search(string);
                for (int j = 0; j < matchInfo.getMatchCount(); ++j) {
                    string = matchInfo.getMatch(j);
                    Object object5 = switch (6.$SwitchMap$com$beekeeper$xwd$CCLookupPanel$ContentType[((Enum)object4).ordinal()]) {
                        case 1 -> ((WordList)object3).getTrueLetters(matchInfo.getOrig(j));
                        case 2, 3 -> matchInfo.getOrig(j);
                        default -> throw new IllegalStateException();
                    };
                    if (matchInfo.getScore(j) < f || !((Matcher)(object5 = ((Pattern)object).matcher((CharSequence)object5))).find()) continue;
                    ((ArrayList)object2).add(string);
                }
            }
            Object object6 = object2;
            String[] stringArray = ((ArrayList)object6).toArray(new String[((ArrayList)object6).size()]);
            this.model.setData(stringArray);
            if (stringArray.length > 0) {
                this.table.changeSelection(0, 0, false, false);
            }
            return;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            JOptionPane.showMessageDialog(this, "Bad search string.\n  Searches should be PERL style regular expressions.");
            return;
        }
    }

    protected final void doPopupMenu(MouseEvent mouseEvent) {
        int n = this.table.rowAtPoint(mouseEvent.getPoint());
        if (n < 0) {
            return;
        }
        n = this.table.convertRowIndexToModel(n);
        Object object = this.model.getRowObject(n);
        object = this.cc.createWordPopup(this, (String)object);
        ((JPopupMenu)object).show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    private void updateClueVisibility() {
        ClueData clueData = this.cc.getClueData();
        this.cluePanel.setVisible(clueData != null);
        this.split.setDividerSize(clueData != null ? 9 : 0);
    }

    final class MyModel
    extends AbstractTableModel {
        private String[] data;
        private /* synthetic */ CCLookupPanel this$0;

        protected MyModel(CCLookupPanel cCLookupPanel, String[] stringArray) {
            this.this$0 = cCLookupPanel;
            this.data = stringArray;
        }

        @Override
        public final int getColumnCount() {
            return 3;
        }

        @Override
        public final String getColumnName(int n) {
            return this.this$0.columns[n];
        }

        @Override
        public final int getRowCount() {
            return this.data.length;
        }

        @Override
        public final Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this.this$0.cc.getWordList().getOrigWord(this.data[n]);
                }
                case 1: {
                    return Float.valueOf(this.this$0.cc.getWordList().getWordScore(this.data[n]));
                }
                case 2: {
                    return this.data[n].length();
                }
            }
            throw new IllegalStateException();
        }

        public final void setData(String[] stringArray) {
            this.data = stringArray;
            this.fireTableDataChanged();
        }

        public final String getRowObject(int n) {
            return this.data[n];
        }

        @Override
        public final boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public final Class<?> getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Float.class;
                }
                case 2: {
                    return Integer.class;
                }
            }
            throw new IllegalStateException();
        }

        public final void remove(int n) {
            String[] stringArray = new String[this.data.length - 1];
            System.arraycopy(this.data, 0, stringArray, 0, n);
            System.arraycopy(this.data, n + 1, stringArray, n, stringArray.length - n);
            this.data = stringArray;
            int n2 = n;
            this.fireTableRowsDeleted(n2, n2);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ContentType {
        Letters{

            public final String toString() {
                return "Lower case letters";
            }
        }
        ,
        LowercasePunctuated{

            public final String toString() {
                return "Lower case word(s) with punctuation";
            }
        }
        ,
        Punctuated{

            public final String toString() {
                return "Original word(s) with punctuation";
            }
        };

    }

    public static enum Attachment {
        None,
        Start,
        End,
        Both;

    }

    public static final class RangeVerifier
    extends InputVerifier {
        private boolean dingOnError = true;
        private Pattern pattern = Pattern.compile("[0-9]++(-[0-9]++)?(, *+[0-9]++(-[0-9]++)?)*+");

        public RangeVerifier(boolean bl) {
        }

        @Override
        public final boolean verify(JComponent object) {
            if (!(object instanceof JTextComponent)) {
                return false;
            }
            object = (JTextComponent)object;
            if (((String)(object = ((JTextComponent)object).getText())).length() == 0) {
                return true;
            }
            return this.pattern.matcher((CharSequence)object).matches();
        }

        @Override
        public final boolean shouldYieldFocus(JComponent jComponent) {
            boolean bl = this.verify(jComponent);
            if (this.dingOnError && !bl) {
                Toolkit.getDefaultToolkit().beep();
            }
            return bl;
        }
    }
}

