/*
 * Decompiled with CFR 0.152.
 */
package com.beekeeper.xwd;

import com.beekeeper.util.GUIUtil;
import com.beekeeper.util.GridHelper;
import com.beekeeper.util.IntSet;
import com.beekeeper.util.RecordTableModel;
import com.beekeeper.util.Starlog;
import com.beekeeper.xwd.BuffWordList;
import com.beekeeper.xwd.CCConfig;
import com.beekeeper.xwd.CrossFire;
import com.beekeeper.xwd.DepthFirstSearch;
import com.beekeeper.xwd.DepthPlusSearch;
import com.beekeeper.xwd.GreedyGridSearchNode;
import com.beekeeper.xwd.GridSearchNode;
import com.beekeeper.xwd.GridState;
import com.beekeeper.xwd.GridStrategies;
import com.beekeeper.xwd.SearchNode;
import com.beekeeper.xwd.SearchNodeProxy;
import com.beekeeper.xwd.Table15;
import com.beekeeper.xwd.WordGrid;
import com.beekeeper.xwd.WordList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class CCFillPanel
extends JPanel
implements CrossFire.CCTab {
    private static final Color[] STATUS_COLORS = new Color[]{new Color(0xFFFFFF), new Color(0xFFEEAA), new Color(0xBBFFBB), new Color(0xFFCCCC)};
    public static final Starlog VERBOSE = Starlog.get(4);
    public static final Starlog DEBUG = Starlog.get(5);
    private final JLabel fpCantFill;
    private Table15 fpTable;
    private RecordTableModel<TableData> fpModel;
    private final JLabel fpWorking;
    private final CrossFire cc;
    private int showLettersMode;
    private boolean showSampleFill;
    boolean showEliminated;
    private final FillUpdateThread updateThread = new FillUpdateThread();
    private final CandidateThread candidateThread = new CandidateThread(this);
    private UpdateTarget currentUpdate;
    private UpdateTarget pendingUpdate;
    private final LinkedList<WordTarget> currentWords = new LinkedList();
    private GridState currentDisplayedState;
    private boolean ignoreSelectionChanges = false;
    private final ListSelectionListener selectionListener = new ListSelectionListener(this){
        private /* synthetic */ CCFillPanel this$0;
        {
            this.this$0 = cCFillPanel;
        }

        @Override
        public final void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.this$0.updateGridDisplay(listSelectionEvent);
        }
    };
    private final Action selectAction = new AbstractAction(this, "Enter selected word"){
        private /* synthetic */ CCFillPanel this$0;
        {
            this.this$0 = cCFillPanel;
            super(string);
        }

        @Override
        public final void actionPerformed(ActionEvent actionEvent) {
            this.this$0.doSelectWord();
        }
    };
    public static final Starlog WARNINGS = Starlog.get(1);
    private int nextStateID = 0;
    Map<GridState, StateInfo> stateMap = new HashMap<GridState, StateInfo>();
    LinkedList<StateInfo> savedStates = new LinkedList();
    private final JTextField filterField;

    private static GridSearchNode.SharedOptions makeSolutionOpts(CrossFire crossFire, int n) {
        GridSearchNode.SharedOptions sharedOptions = new GridSearchNode.SharedOptions(100, crossFire.getWordList());
        new GridSearchNode.SharedOptions(100, crossFire.getWordList()).aggressiveBacktracking = false;
        sharedOptions.setBadWordsHeuristic(false);
        sharedOptions.longestSubstring = crossFire.getLongestSubstring();
        sharedOptions.minCandidateScore = crossFire.getMinAutofillScore();
        return sharedOptions;
    }

    public final void setShowLettersMode(int n) {
        this.showLettersMode = n;
        this.currentDisplayedState = null;
        this.updateGridDisplay(null);
    }

    public final void setShowSampleFill(boolean bl) {
        this.showSampleFill = bl;
        this.currentDisplayedState = null;
        this.updateGridDisplay(null);
    }

    public final void setShowEliminated(boolean bl) {
        boolean bl2 = this.showEliminated;
        this.showEliminated = bl;
        if (bl != bl2) {
            this.resetFillThread();
        }
    }

    private synchronized StateInfo getStateInfo(GridState object, BitSet bitSet) {
        StateInfo stateInfo = this.stateMap.get(object);
        if (stateInfo == null || bitSet == null && stateInfo.area != null || bitSet != null && !bitSet.equals(stateInfo.area)) {
            stateInfo = new StateInfo(this, (GridState)object, bitSet);
            this.stateMap.put((GridState)object, stateInfo);
            this.savedStates.addLast(stateInfo);
            while (this.savedStates.size() > 100000) {
                object = this.savedStates.removeFirst();
                this.stateMap.remove(((StateInfo)object).state);
            }
        }
        return stateInfo;
    }

    private static GridSearchNode doSearch(GridSearchNode object, int n, int n2) {
        if (n2 > 1) {
            object = new DepthPlusSearch((SearchNode)object, n2);
            object = (GridSearchNode)((DepthPlusSearch)object).search(n);
        } else {
            object = new DepthFirstSearch((SearchNode)object);
            object = (GridSearchNode)((DepthFirstSearch)object).search(n);
        }
        return object;
    }

    final int findModelIndex(GridState gridState) {
        RecordTableModel<TableData> recordTableModel = this.fpModel;
        synchronized (recordTableModel) {
            int n = this.fpModel.getRowCount();
            for (int i = 0; i < n; ++i) {
                if (!this.fpModel.getValueAt(i).getState().equals(gridState)) continue;
                return i;
            }
            return -1;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void addTableEntry(int n, StateInfo stateInfo, StateInfo stateInfo2) {
        void var3_3;
        void var2_2;
        GridState gridState = var2_2;
        // MONITORENTER : gridState
        if (var2_2.depthState == null && VERBOSE != null) {
            VERBOSE.log("null depthstate");
        }
        GridState gridState2 = var2_2.state;
        float f = var2_2.completeScore;
        GridState gridState3 = var2_2.completeState;
        int n2 = var2_2.completeBranch;
        // MONITOREXIT : gridState
        String string = var3_3;
        // MONITORENTER : string
        if (var3_3.completeScore == -1.0f && var2_2.completeScore != -1.0f) {
            var3_3.completeScore = f;
            var3_3.completeState = gridState3;
            var3_3.completeBranch = n2;
            var3_3.isBad = false;
            this.setCantFill(false);
        }
        gridState = var3_3.state;
        // MONITOREXIT : string
        if (GridStrategies.USE_1_1_STRATEGIES && gridState3 != null) {
            int n3 = gridState.getWordCount();
            for (int i = 0; i < n3; ++i) {
                if (gridState.isComplete(i)) continue;
                Object object = new GridState(gridState);
                Object object2 = gridState3.getCompleteWord(i);
                if (object2 == null) continue;
                ((GridState)object).setString(i, (String)object2);
                object2 = object = this.getStateInfo((GridState)object, var3_3.area);
                // MONITORENTER : object
                if (((StateInfo)object).completeScore == -1.0f) {
                    ((StateInfo)object).completeScore = f;
                    ((StateInfo)object).completeState = gridState3;
                    ((StateInfo)object).completeBranch = n2;
                }
                // MONITOREXIT : object2
            }
        }
        string = gridState2.getString(n);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){
                private /* synthetic */ GridState val$state;
                private /* synthetic */ String val$word;
                private /* synthetic */ StateInfo val$info;
                private /* synthetic */ StateInfo val$parentInfo;
                private /* synthetic */ CCFillPanel this$0;
                {
                    this.this$0 = cCFillPanel;
                    this.val$state = gridState;
                    this.val$word = string;
                    this.val$info = stateInfo;
                    this.val$parentInfo = stateInfo2;
                }

                @Override
                public final void run() {
                    int n;
                    int n2;
                    this.this$0.ignoreSelectionChanges = true;
                    RecordTableModel<TableData> recordTableModel = this.this$0.fpModel;
                    synchronized (recordTableModel) {
                        n2 = this.this$0.findModelIndex(this.val$state);
                        if (n2 == -1) {
                            this.this$0.fpModel.addRow(new TableData(this.this$0, this.val$word, this.val$info, this.val$parentInfo));
                        } else {
                            int n3 = n2;
                            this.this$0.fpModel.fireTableRowsUpdated(n3, n3);
                        }
                        this.this$0.fpModel.getRowCount();
                    }
                    this.this$0.ignoreSelectionChanges = false;
                    if (n2 != -1 && (n = this.this$0.fpTable.getSelectedRow()) != -1 && this.this$0.fpTable.convertRowIndexToModel(n) == n2) {
                        this.this$0.currentDisplayedState = null;
                        this.this$0.updateGridDisplayForced();
                    }
                    this.this$0.fpTable.repaint();
                }
            });
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    private void setCantFill(boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){
            private /* synthetic */ boolean val$value;
            private /* synthetic */ CCFillPanel this$0;
            {
                this.this$0 = cCFillPanel;
                this.val$value = bl;
            }

            @Override
            public final void run() {
                this.this$0.fpCantFill.setVisible(this.val$value);
            }
        });
    }

    public CCFillPanel(CrossFire crossFire) {
        this.cc = crossFire;
        this.setPreferredSize(new Dimension(10, 10));
        this.fpWorking = new JLabel("Ready", 0);
        this.fpWorking.setFont(UIManager.getDefaults().getFont("Table.font").deriveFont(1));
        Object object = new JButton(new AbstractAction(this, "Best location", crossFire){
            private /* synthetic */ CrossFire val$cc;
            private /* synthetic */ CCFillPanel this$0;
            {
                this.this$0 = cCFillPanel;
                this.val$cc = crossFire;
                super(string);
            }

            @Override
            public final void actionPerformed(ActionEvent object) {
                object = new FindSolutionNode(this.this$0, this.val$cc.getDisplay().getState());
                int n = ((GridSearchNode)object).chooseWordToFill();
                this.val$cc.getDisplay().setSelectedWord(n);
                this.this$0.fpTable.requestFocusInWindow();
            }
        });
        JPanel jPanel = new JPanel();
        Serializable serializable = new GridHelper(jPanel);
        serializable.add(new JLabel("Status: ")).add(this.fpWorking).stretch();
        serializable = new JPanel();
        GridHelper gridHelper = new GridHelper((Container)serializable);
        this.filterField = new JTextField("", 3);
        this.filterField.addActionListener(new ActionListener(){
            private /* synthetic */ CrossFire val$cc;
            private /* synthetic */ CCFillPanel this$0;
            {
                this.this$0 = cCFillPanel;
                this.val$cc = crossFire;
            }

            @Override
            public final void actionPerformed(ActionEvent actionEvent) {
                this.this$0.currentUpdate = null;
                this.this$0.updateFillStatus$23dd1cab(this.val$cc.getDisplay().getState(), this.val$cc.getDisplay().getSelectedWord(), this.val$cc.getDisplay().getAreaSelection());
            }
        });
        gridHelper.space().stretch().space().space().advance();
        gridHelper.add(new JLabel("Filter: ")).add(this.filterField).space(5).add((Component)object);
        this.fpCantFill = new JLabel("*** Unfillable Grid ***", 2);
        this.fpCantFill.setFont(UIManager.getDefaults().getFont("Table.font").deriveFont(1));
        this.fpCantFill.setForeground(Color.red);
        this.setCantFill(false);
        this.createTable();
        object = new GridHelper(this);
        ((GridHelper)object).stretch().advance();
        ((GridHelper)object).add(jPanel).advance().advance(5);
        ((GridHelper)object).add(this.fpCantFill).advance();
        ((GridHelper)object).add(new JScrollPane(this.fpTable)).advance(0, 1.0).advance(5);
        ((GridHelper)object).add((Component)serializable).advance();
        this.addComponentListener(new ComponentAdapter(this, crossFire){
            private /* synthetic */ CrossFire val$cc;
            private /* synthetic */ CCFillPanel this$0;
            {
                this.this$0 = cCFillPanel;
                this.val$cc = crossFire;
            }

            @Override
            public final void componentShown(ComponentEvent componentEvent) {
                this.this$0.updateFillStatus$23dd1cab(this.val$cc.getDisplay().getState(), this.val$cc.getDisplay().getSelectedWord(), this.val$cc.getDisplay().getAreaSelection());
                this.val$cc.getLetterPanel().setVisible(true);
            }

            @Override
            public final void componentHidden(ComponentEvent componentEvent) {
                this.this$0.stopUpdate();
            }
        });
        object = new Runnable(){
            private /* synthetic */ CrossFire val$cc;
            private /* synthetic */ CCFillPanel this$0;
            {
                this.this$0 = cCFillPanel;
                this.val$cc = crossFire;
            }

            @Override
            public final void run() {
                this.this$0.updateFillStatus$23dd1cab(this.val$cc.getDisplay().getState(), this.val$cc.getDisplay().getSelectedWord(), this.val$cc.getDisplay().getAreaSelection());
            }
        };
        crossFire.addStateAction((Runnable)object);
        crossFire.getWordMonitor().addListener(new WordList.WordListListener(this, crossFire){
            private /* synthetic */ CrossFire val$cc;
            private /* synthetic */ CCFillPanel this$0;
            {
                this.this$0 = cCFillPanel;
                this.val$cc = crossFire;
            }

            @Override
            public final void spellingChanged(String string, String object, boolean n) {
                if (!this.this$0.isShowing()) {
                    return;
                }
                object = this.this$0.fpModel;
                synchronized (object) {
                    if (this.this$0.fpModel.getRowCount() == 0) {
                        return;
                    }
                    for (n = 0; n < this.this$0.fpModel.getRowCount(); ++n) {
                        if (!this.this$0.fpModel.getValueAt((int)n).word.equals(string)) continue;
                        int n2 = n;
                        this.this$0.fpModel.fireTableRowsUpdated(n2, n2);
                        break;
                    }
                    return;
                }
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public final void scoreChanged(String string, float f, float f2) {
                Object object;
                void var3_4;
                void var2_2;
                int n = this.val$cc.getMinAutofillScore();
                if (var2_2 >= (float)n && var3_4 < (float)n) {
                    object = this.this$0.updateThread;
                    // MONITORENTER : object
                    this.this$0.currentWords.add(new WordTarget(this.this$0, string, false));
                    this.this$0.resetFillThread();
                    // MONITOREXIT : object
                } else if (var2_2 < (float)n && var3_4 >= (float)n) {
                    object = this.this$0.updateThread;
                    // MONITORENTER : object
                    this.this$0.currentWords.add(new WordTarget(this.this$0, string, true));
                    this.this$0.resetFillThread();
                    // MONITOREXIT : object
                } else {
                    if (!this.this$0.isShowing()) {
                        return;
                    }
                    object = this.this$0.fpModel;
                    // MONITORENTER : object
                    if (this.this$0.fpModel.getRowCount() == 0) {
                        // MONITOREXIT : object
                        return;
                    }
                    this.this$0.fpModel.fireTableRowsUpdated(0, this.this$0.fpModel.getRowCount() - 1);
                    // MONITOREXIT : object
                }
                if (var3_4 < var2_2) {
                    object = this.this$0;
                    // MONITORENTER : object
                    Iterator iterator = this.this$0.savedStates.iterator();
                    while (iterator.hasNext()) {
                        StateInfo stateInfo;
                        StateInfo stateInfo2 = stateInfo = (StateInfo)iterator.next();
                        // MONITORENTER : stateInfo
                        if (stateInfo.isExhaustive && stateInfo.completeState != null && CCFillPanel.hasWord(stateInfo.completeState, string)) {
                            stateInfo.isExhaustive = false;
                        }
                        // MONITOREXIT : stateInfo2
                    }
                    // MONITOREXIT : object
                }
                if (!this.this$0.isShowing()) {
                    return;
                }
                object = this.this$0.updateThread;
                // MONITORENTER : object
                this.this$0.resetFillThread();
                // MONITOREXIT : object
            }

            @Override
            public final void wordListChanged() {
                this.val$cc.getWordList();
                this.this$0.savedStates.clear();
                this.this$0.stateMap.clear();
                if (!this.this$0.isShowing()) {
                    return;
                }
                this.this$0.resetFillThread();
            }
        });
        crossFire.getDisplay().addSelectionListener((Runnable)object);
        this.fpTable.registerKeyboardAction(this.selectAction, KeyStroke.getKeyStroke("ENTER"), 1);
        this.updateThread.start();
        this.candidateThread.start();
    }

    protected static boolean hasWord(GridState gridState, String string) {
        int n = gridState.getWordCount();
        for (int i = 0; i < n; ++i) {
            if (!string.equals(gridState.getCompleteWord(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isAncestor(GridState gridState, GridState gridState2) {
        if (gridState.getGrid() != gridState2.getGrid()) {
            return false;
        }
        int n = gridState.getWordCount();
        for (int i = 0; i < n; ++i) {
            String string = gridState.getCompleteWord(i);
            if (string == null || string.equals(gridState2.getCompleteWord(i))) continue;
            return false;
        }
        return true;
    }

    private void createTable() {
        this.fpModel = RecordTableModel.create(TableData.class, new String[]{"Word", "Word Score", "Grid Score", "Final Score"});
        CCFillPanel cCFillPanel = this;
        this.fpTable = new Table15(cCFillPanel, cCFillPanel.fpModel){

            @Override
            public final boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        Serializable serializable = new DefaultTableCellRenderer(this){
            private Font boldFont;
            private Font stdFont;
            private /* synthetic */ CCFillPanel this$0;
            {
                this.this$0 = cCFillPanel;
            }

            @Override
            public final Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                object = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (this.stdFont == null) {
                    this.stdFont = ((Component)object).getFont().deriveFont(0);
                    this.boldFont = ((Component)object).getFont().deriveFont(1);
                }
                int n3 = jTable.convertColumnIndexToModel(n2);
                TableData tableData = this.this$0.fpModel.getValueAt(this.this$0.fpTable.convertRowIndexToModel(n));
                Color color = STATUS_COLORS[tableData.wordInfo.status.ordinal()];
                if (bl) {
                    ((Component)object).setForeground(color);
                } else {
                    ((Component)object).setBackground(color);
                    this.setForeground(Color.black);
                }
                if (n3 == 0) {
                    if (tableData.isBad()) {
                        Object object2 = object;
                        ((Component)object2).setFont(((Component)object2).getFont().deriveFont(Collections.singletonMap(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON)));
                    } else if (tableData.isComplete()) {
                        ((Component)object).setFont(this.boldFont);
                    } else {
                        ((Component)object).setFont(this.stdFont);
                    }
                } else if (n3 == 3) {
                    if (tableData.isExhaustive()) {
                        ((Component)object).setFont(this.boldFont);
                    } else {
                        ((Component)object).setFont(this.stdFont);
                    }
                }
                return object;
            }
        };
        this.fpTable.setDefaultRenderer(Object.class, (TableCellRenderer)((Object)serializable));
        this.fpTable.setDefaultRenderer(Number.class, (TableCellRenderer)((Object)serializable));
        this.fpTable.setDefaultRenderer(Float.class, (TableCellRenderer)((Object)serializable));
        serializable = (DefaultTableColumnModel)this.fpTable.getColumnModel();
        FontRenderContext fontRenderContext = new FontRenderContext(new AffineTransform(), false, false);
        Font font = UIManager.getDefaults().getFont("Table.font");
        for (int i = 0; i < ((DefaultTableColumnModel)serializable).getColumnCount(); ++i) {
            TableColumn tableColumn = ((DefaultTableColumnModel)serializable).getColumn(i);
            String string = i > 0 ? this.fpModel.getColumnName(i) : "ABCDEFGHIJKLMNOPQRST";
            int n = (int)font.getStringBounds(string, fontRenderContext).getWidth();
            tableColumn.setPreferredWidth(n + 10);
        }
        this.fpTable.setAutoCreateRowSorter(true);
        this.fpTable.setSortOnUpdate(true);
        this.fpTable.setUpdateSelectionOnSort(true);
        this.fpTable.setSorting(new int[]{3, -1, 2, -1, 1, -1});
        this.fpTable.addMouseListener(new MouseAdapter(this){
            private /* synthetic */ CCFillPanel this$0;
            {
                this.this$0 = cCFillPanel;
            }

            @Override
            public final void mouseClicked(MouseEvent mouseEvent) {
                mouseEvent.consume();
                if (mouseEvent.getClickCount() == 2) {
                    this.this$0.doSelectWord();
                }
            }

            @Override
            public final void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    this.this$0.doPopupMenu(mouseEvent);
                }
            }

            @Override
            public final void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    this.this$0.doPopupMenu(mouseEvent);
                }
            }
        });
        this.fpTable.getSelectionModel().addListSelectionListener(this.selectionListener);
    }

    protected final void doPopupMenu(MouseEvent mouseEvent) {
        Object object;
        int n = this.fpTable.rowAtPoint(mouseEvent.getPoint());
        if (n < 0) {
            return;
        }
        n = this.fpTable.convertRowIndexToModel(n);
        Object object2 = this.fpModel;
        synchronized (object2) {
            object = this.fpModel.getValueAt(n);
        }
        object2 = object;
        object = ((TableData)object2).word;
        object = this.cc.createWordPopup(this, (String)object);
        Object object3 = this.cc;
        if (!((CrossFire)object3).activeOperation) {
            ((JPopupMenu)object).add(new AbstractAction(this, "Insert word in grid", (TableData)object2){
                private /* synthetic */ TableData val$info;
                private /* synthetic */ CCFillPanel this$0;
                {
                    this.this$0 = cCFillPanel;
                    this.val$info = tableData;
                    super(string);
                    this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ENTER"));
                }

                @Override
                public final void actionPerformed(ActionEvent actionEvent) {
                    this.this$0.doSelectWord(this.val$info);
                }
            });
            if (((TableData)object2).isComplete()) {
                ((JPopupMenu)object).add(new AbstractAction(this, "Insert complete fill", (TableData)object2){
                    private /* synthetic */ TableData val$info;
                    private /* synthetic */ CCFillPanel this$0;
                    {
                        this.this$0 = cCFillPanel;
                        this.val$info = tableData;
                        super(string);
                    }

                    @Override
                    public final void actionPerformed(ActionEvent actionEvent) {
                        this.this$0.cc.pushUndo();
                        this.this$0.cc.setState(this.val$info.wordInfo.completeState, null);
                        this.this$0.filterField.setText("");
                    }
                });
            }
        }
        object3 = new JMenu("Mark as");
        int n2 = Status.BAD.ordinal();
        for (int i = Status.GOOD.ordinal(); i <= n2; ++i) {
            Status status = Status.values()[i];
            ((JMenu)object3).add(new JMenuItem(new AbstractAction(this, status.toString().toLowerCase(), (TableData)object2, status){
                private /* synthetic */ TableData val$info;
                private /* synthetic */ Status val$status;
                private /* synthetic */ CCFillPanel this$0;
                {
                    this.this$0 = cCFillPanel;
                    this.val$info = tableData;
                    this.val$status = status;
                    super(string);
                }

                @Override
                public final void actionPerformed(ActionEvent actionEvent) {
                    this.val$info.wordInfo.status = this.val$status;
                    this.this$0.fpTable.repaint();
                }
            }));
        }
        ((JPopupMenu)object).add((JMenuItem)object3);
        ((JPopupMenu)object).show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    private void updateFillStatus$23dd1cab(GridState gridState, int n, BitSet bitSet) {
        FillUpdateThread fillUpdateThread = this.updateThread;
        synchronized (fillUpdateThread) {
            if (this.isShowing()) {
                if (this.currentUpdate == null || gridState != this.currentUpdate.state || n != this.currentUpdate.selectedWord || !bitSet.equals(this.currentUpdate.area)) {
                    this.pendingUpdate = new UpdateTarget(this, gridState, n, bitSet);
                    if (VERBOSE != null) {
                        VERBOSE.log("Sending interrupt");
                    }
                    this.updateThread.setInterrupting();
                } else {
                    this.pendingUpdate = null;
                }
            }
            return;
        }
    }

    private void stopUpdate() {
        FillUpdateThread fillUpdateThread = this.updateThread;
        synchronized (fillUpdateThread) {
            CCFillPanel cCFillPanel = this;
            this.pendingUpdate = new UpdateTarget(cCFillPanel, cCFillPanel.cc.getDisplay().getState(), -1, null);
            if (VERBOSE != null) {
                VERBOSE.log("Sending interrupt");
            }
            this.updateThread.setInterrupting();
            return;
        }
    }

    private void doSelectWord() {
        TableData tableData;
        CrossFire crossFire = this.cc;
        if (crossFire.activeOperation) {
            return;
        }
        int n = this.fpTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        n = this.fpTable.convertRowIndexToModel(n);
        RecordTableModel<TableData> recordTableModel = this.fpModel;
        synchronized (recordTableModel) {
            tableData = this.fpModel.getValueAt(n);
        }
        this.doSelectWord(tableData);
    }

    private void doSelectWord(TableData object) {
        int n;
        Object object2;
        int n2;
        if (!EventQueue.isDispatchThread()) {
            throw new IllegalStateException();
        }
        if (((TableData)object).wordInfo.status == Status.NEW) {
            ((TableData)object).wordInfo.status = Status.VISITED;
        }
        object = ((TableData)object).getState();
        if (CCConfig.getAutoEnterComplete()) {
            Object object3 = object;
            object = new GridState((GridState)object3, ((GridState)object3).getChars());
        }
        if ((n2 = this.cc.getDisplay().getSelectedWord()) == -1) {
            return;
        }
        this.cc.pushUndo();
        GridSearchNode gridSearchNode = this.cc.getFillHistory();
        GridState gridState = this.cc.getDisplay().getState();
        BitSet bitSet = this.cc.getDisplay().getAreaSelection();
        BitSet bitSet2 = null;
        if (bitSet != null && bitSet.cardinality() > 1) {
            bitSet2 = new BitSet();
            object2 = gridState.getGrid();
            n = bitSet.nextSetBit(0);
            while (n != -1) {
                if (gridState.getChars()[n] != '\u007f') {
                    int n3 = ((WordGrid)object2).getCrossWordCount(n);
                    for (int i = 0; i < n3; ++i) {
                        bitSet2.set(((WordGrid)object2).getCrossWord(n, i));
                    }
                }
                n = bitSet.nextSetBit(n + 1);
            }
        }
        if (gridSearchNode == null || gridSearchNode.options.wordList != this.cc.getWordList() || gridSearchNode.options.minCandidateScore != this.cc.getMinAutofillScore() || gridSearchNode.chooseWordToFill() != n2 || bitSet2 == null && gridSearchNode.options.neighborhood != null || bitSet2 != null && !bitSet2.equals(gridSearchNode.options.neighborhood)) {
            gridSearchNode = new FindSolutionNode(this, gridState);
            new FindSolutionNode(this, gridState).options.neighborhood = bitSet2;
            gridSearchNode.options.softAdjacencyDepth = Integer.MAX_VALUE;
        }
        object2 = gridSearchNode.makeSuccessor((GridState)object);
        ((GridSearchNode)object2).setString(n2, ((GridState)object).getString(n2));
        this.cc.setState((GridState)object, (GridSearchNode)object2);
        n = ((GridSearchNode)object2).chooseWordToFill();
        if (n != -1 && (bitSet2 == null || bitSet2.get(n))) {
            this.cc.getDisplay().setSelectedWord(n, true);
        }
        this.filterField.setText("");
    }

    @Override
    public final String[] getSelectedWords() {
        int[] nArray = this.fpTable.getSelectedRows();
        if (nArray.length == 0) {
            return new String[0];
        }
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            Object object;
            int n = nArray[i];
            n = this.fpTable.convertRowIndexToModel(n);
            RecordTableModel<TableData> recordTableModel = this.fpModel;
            synchronized (recordTableModel) {
                object = this.fpModel.getValueAt(n).getState();
            }
            int n2 = this.cc.getDisplay().getSelectedWord();
            stringArray[i] = object = ((GridState)object).getString(n2);
        }
        return stringArray;
    }

    private static int findCompleteWord(String string, GridState gridState) {
        int n = -1;
        int n2 = gridState.getWordCount();
        for (int i = 0; i < n2; ++i) {
            if (!string.equals(gridState.getCompleteWord(i))) continue;
            n = i;
            break;
        }
        return n;
    }

    private void showForcedWords(int n, GridState gridState, char[] cArray, boolean n2) {
        Object object;
        int n3;
        int n4;
        Object object2;
        Iterator iterator;
        int n5;
        Object object3;
        Object object4;
        ArrayList<String> arrayList;
        Object object5;
        int n6;
        Object object6;
        n2 = n2 != 0 ? 9 : 1;
        FindSolutionNode findSolutionNode = new FindSolutionNode(this, gridState);
        if (gridState != this.currentDisplayedState) {
            return;
        }
        findSolutionNode.latestWord = n;
        findSolutionNode.options.beam = 200;
        findSolutionNode.options.beamMultiplier = 1;
        Object object7 = new ArrayList<Object>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ((ArrayList)object7).add(new ArrayList<FindSolutionNode>(Collections.singletonList(findSolutionNode)));
        arrayList2.add(n);
        int n7 = 0;
        int n8 = 0;
        block0: for (int i = 1; i < 200; ++i) {
            if (gridState != this.currentDisplayedState) {
                return;
            }
            object6 = (List)((ArrayList)object7).get(i - 1);
            n6 = ((GridSearchNode)object6.get(0)).chooseWordToFill();
            if (n6 == -1) break;
            object5 = new ArrayList();
            arrayList = object6.iterator();
            while (arrayList.hasNext()) {
                object4 = (GridSearchNode)arrayList.next();
                if (++n7 > 200) break block0;
                SearchNodeProxy[] searchNodeProxyArray = object3 = ((GridSearchNode)object4).generateSuccessors(n6);
                n5 = ((SearchNodeProxy[])object3).length;
                for (int j = 0; j < n5; ++j) {
                    iterator = searchNodeProxyArray[j];
                    if (gridState != this.currentDisplayedState) {
                        return;
                    }
                    object2 = (GridSearchNode)iterator.getNode();
                    object5.add(object2);
                    if (++n8 > 200) break block0;
                }
                ((SearchNode)object4).setLiveChildCount(((SearchNodeProxy[])object3).length);
                if (((SearchNode)object4).getLiveChildCount() != 0) continue;
                arrayList.remove();
                int n9 = i - 2;
                if (((GridSearchNode)object4).parent != null) {
                    ((GridSearchNode)object4).parent.setLiveChildCount(((GridSearchNode)object4).parent.getLiveChildCount() - 1);
                }
                GridSearchNode gridSearchNode = (GridSearchNode)((GridSearchNode)object4).parent;
                while (n9 >= 0 && gridSearchNode.getLiveChildCount() <= 0) {
                    ((List)((ArrayList)object7).get(n9)).remove(gridSearchNode);
                    if (gridSearchNode.parent != null) {
                        gridSearchNode.parent.setLiveChildCount(gridSearchNode.parent.getLiveChildCount() - 1);
                    } else if (VERBOSE != null) {
                        VERBOSE.log("selection dead-end node: depth = " + i);
                    }
                    gridSearchNode = (GridSearchNode)gridSearchNode.parent;
                    --n9;
                }
            }
            if (gridState != this.currentDisplayedState) {
                return;
            }
            if (object5.size() == 0) break;
            ((ArrayList)object7).add(object5);
            if (object5.size() >= 100) break;
        }
        if (gridState != this.currentDisplayedState) {
            return;
        }
        ArrayList<Collection<Object>> arrayList3 = new ArrayList<Collection<Object>>();
        object6 = gridState.getString(n);
        arrayList3.add(Collections.singleton(object6));
        for (n6 = 1; n6 < ((ArrayList)object7).size(); ++n6) {
            if (gridState != this.currentDisplayedState) {
                return;
            }
            object5 = (List)((ArrayList)object7).get(n6);
            arrayList = new HashSet();
            object4 = object5.iterator();
            while (object4.hasNext()) {
                object3 = (GridSearchNode)object4.next();
                ((HashSet)((Object)arrayList)).add(object3.state.getString(object3.latestWord));
            }
            arrayList3.add(arrayList);
        }
        if (gridState != this.currentDisplayedState) {
            return;
        }
        HashMap hashMap = new HashMap();
        object5 = new HashMap();
        arrayList = gridState.getWord(n);
        hashMap.put(n, new ArrayList<Object>(Collections.singletonList(object6)));
        iterator = arrayList;
        int n10 = ((WordGrid.Word)((Object)iterator)).letterIndices.length;
        for (n4 = 0; n4 < n10; ++n4) {
            if (gridState != this.currentDisplayedState) {
                return;
            }
            n3 = n4;
            iterator = arrayList;
            int n11 = ((WordGrid.Word)((Object)iterator)).letterIndices[n3];
            if (cArray[n11] != '\u0000') continue;
            IntSet intSet = new IntSet();
            intSet.add(((String)object6).charAt(n4));
            ((HashMap)object5).put(n11, intSet);
        }
        if (gridState != this.currentDisplayedState) {
            return;
        }
        if (!((ArrayList)object7).isEmpty() && !((List)((ArrayList)object7).get(0)).isEmpty()) {
            n10 = arrayList3.size();
            for (n4 = 1; n4 < n10; ++n4) {
                if (gridState != this.currentDisplayedState) {
                    return;
                }
                int n12 = ((GridSearchNode)((List)((ArrayList)object7).get((int)n4)).get((int)0)).latestWord;
                WordGrid.Word word = gridState.getWord(n12);
                object6 = (Set)arrayList3.get(n4);
                iterator = new ArrayList<String>((Collection<String>)object6);
                Collections.sort(iterator);
                hashMap.put(n12, iterator);
                if (object6.size() == 1) {
                    object2 = (String)object6.iterator().next();
                    iterator = word;
                    n8 = ((WordGrid.Word)((Object)iterator)).letterIndices.length;
                    for (n7 = 0; n7 < n8; ++n7) {
                        n3 = n7;
                        iterator = word;
                        n12 = ((WordGrid.Word)((Object)iterator)).letterIndices[n3];
                        if (cArray[n12] != '\u0000') continue;
                        iterator = new IntSet();
                        ((IntSet)((Object)iterator)).add(((String)object2).charAt(n7));
                        ((HashMap)object5).put(n12, iterator);
                    }
                    continue;
                }
                iterator = word;
                n7 = ((WordGrid.Word)((Object)iterator)).letterIndices.length;
                for (int i = 0; i < n7; ++i) {
                    n3 = i;
                    iterator = word;
                    n8 = ((WordGrid.Word)((Object)iterator)).letterIndices[n3];
                    if (cArray[n8] != '\u0000' || ((HashMap)object5).get(n8) != null) continue;
                    IntSet intSet = new IntSet();
                    iterator = object6.iterator();
                    while (iterator.hasNext()) {
                        object = (String)iterator.next();
                        intSet.add(((String)object).charAt(i));
                    }
                    if (intSet.size() > n2) continue;
                    ((HashMap)object5).put(n8, intSet);
                }
            }
        }
        if (gridState != this.currentDisplayedState) {
            return;
        }
        iterator = arrayList;
        n10 = ((WordGrid.Word)((Object)iterator)).letterIndices.length;
        for (n4 = 0; n4 < n10; ++n4) {
            if (gridState != this.currentDisplayedState) {
                return;
            }
            n3 = n4;
            iterator = arrayList;
            int n13 = ((WordGrid.Word)((Object)iterator)).letterIndices[n3];
            n5 = -1;
            object6 = gridState.getGrid();
            int n14 = ((WordGrid)object6).getCrossWordCount(n13);
            for (int i = 0; i < n14; ++i) {
                int n15 = ((WordGrid)object6).getCrossWord(n13, i);
                if (n15 == n) continue;
                n5 = n15;
                break;
            }
            if (n5 == -1 || gridState.isComplete(n5) || hashMap.containsKey(n5)) continue;
            Object object8 = findSolutionNode.generateSuccessors(n5);
            HashSet<String> hashSet = new HashSet<String>();
            n8 = ((SearchNodeProxy[])object8).length;
            for (int i = 0; i < n8; ++i) {
                if (gridState != this.currentDisplayedState) {
                    return;
                }
                GridSearchNode.GSNProxy gSNProxy = (GridSearchNode.GSNProxy)object8[i];
                hashSet.add(gSNProxy.word);
            }
            if (gridState != this.currentDisplayedState) {
                return;
            }
            ArrayList arrayList4 = new ArrayList(hashSet);
            Collections.sort(arrayList4);
            hashMap.put(n5, arrayList4);
            n13 = ((SearchNodeProxy[])object8).length;
            for (n8 = 0; n8 < n13; ++n8) {
                int n16;
                if (gridState != this.currentDisplayedState) {
                    return;
                }
                int n17 = n5;
                object = gridState.getWord(n17);
                if (hashSet.size() == 1) {
                    object7 = (String)hashSet.iterator().next();
                    object8 = object;
                    int n18 = ((WordGrid.Word)object8).letterIndices.length;
                    for (n16 = 0; n16 < n18; ++n16) {
                        int n19 = n16;
                        object8 = object;
                        int n20 = ((WordGrid.Word)object8).letterIndices[n19];
                        if (cArray[n20] != '\u0000') continue;
                        object8 = new IntSet();
                        ((IntSet)object8).add(((String)object7).charAt(n16));
                        ((HashMap)object5).put(n20, object8);
                    }
                    continue;
                }
                object8 = object;
                n16 = ((WordGrid.Word)object8).letterIndices.length;
                for (int i = 0; i < n16; ++i) {
                    int n21 = i;
                    object8 = object;
                    int n22 = ((WordGrid.Word)object8).letterIndices[n21];
                    if (cArray[n22] != '\u0000' || ((HashMap)object5).get(n22) != null) continue;
                    object6 = new IntSet();
                    for (String string : hashSet) {
                        ((IntSet)object6).add(string.charAt(i));
                    }
                    if (((IntSet)object6).size() > n2) continue;
                    ((HashMap)object5).put(n22, object6);
                }
            }
            if (gridState == this.currentDisplayedState) continue;
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){
            private /* synthetic */ GridState val$state;
            private /* synthetic */ HashMap val$forced;
            private /* synthetic */ HashMap val$words;
            private /* synthetic */ CCFillPanel this$0;
            {
                this.this$0 = cCFillPanel;
                this.val$state = gridState;
                this.val$forced = hashMap;
                this.val$words = hashMap2;
            }

            @Override
            public final void run() {
                ListSelectionListener listSelectionListener = this.this$0.selectionListener;
                synchronized (listSelectionListener) {
                    if (this.val$state != this.this$0.currentDisplayedState) {
                        return;
                    }
                    this.this$0.cc.getDisplay().addDisplay("candidate", this.val$forced, 4, Color.gray, new Color(0, true), this.val$words);
                    this.this$0.cc.getDisplay().repaint();
                    return;
                }
            }
        });
    }

    private void setWorkingText(String string) {
        SwingUtilities.invokeLater(new Runnable(){
            private /* synthetic */ String val$text;
            private /* synthetic */ CCFillPanel this$0;
            {
                this.this$0 = cCFillPanel;
                this.val$text = string;
            }

            @Override
            public final void run() {
                this.this$0.fpWorking.setText(this.val$text);
            }
        });
    }

    private void updateGridDisplay(ListSelectionEvent listSelectionEvent) {
        if (this.ignoreSelectionChanges) {
            return;
        }
        if (listSelectionEvent != null && listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        this.updateGridDisplayForced();
    }

    /*
     * Exception decompiling
     */
    private void updateGridDisplayForced() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void resetFillThread() {
        this.currentUpdate = null;
        CCFillPanel cCFillPanel = this;
        cCFillPanel.updateFillStatus$23dd1cab(cCFillPanel.cc.getDisplay().getState(), this.cc.getDisplay().getSelectedWord(), this.cc.getDisplay().getAreaSelection());
    }

    protected static int computeBranchCount(GridSearchNode gridSearchNode) {
        int n = 1;
        while (gridSearchNode != null) {
            if (n > Short.MAX_VALUE || gridSearchNode.childBranchCount > Short.MAX_VALUE) {
                n = 32768;
                break;
            }
            n *= gridSearchNode.childBranchCount;
            gridSearchNode = (GridSearchNode)gridSearchNode.parent;
        }
        return n;
    }

    private class StateInfo
    implements Comparable<StateInfo> {
        public int completeBranch;
        public final GridState state;
        public Status status = Status.NEW;
        private final BitSet area;
        public boolean isBad = false;
        public int reorderCount;
        public float depthScore = -1.0f;
        public int searchLevel = 0;
        public GridState depthState;
        public float completeScore = -1.0f;
        public GridState completeState;
        public boolean isExhaustive;
        private int id;
        public boolean shouldTrackBlocking;

        public StateInfo(CCFillPanel cCFillPanel, GridState object, BitSet bitSet) {
            this.state = object;
            this.area = bitSet;
            object = StateInfo.class;
            synchronized (StateInfo.class) {
                this.id = cCFillPanel.nextStateID++;
                // ** MonitorExit[var2_3] (shouldn't be in output)
                return;
            }
        }
    }

    public class TableData {
        String word;
        StateInfo wordInfo;
        private StateInfo parentInfo;
        private /* synthetic */ CCFillPanel this$0;

        public TableData(CCFillPanel cCFillPanel, String string, StateInfo stateInfo, StateInfo stateInfo2) {
            this.this$0 = cCFillPanel;
            this.word = string;
            this.wordInfo = stateInfo;
            this.parentInfo = stateInfo2;
        }

        public GridState getState() {
            StateInfo stateInfo = this.wordInfo;
            synchronized (stateInfo) {
                return this.wordInfo.state;
            }
        }

        public GridState getCompleteState() {
            StateInfo stateInfo = this.wordInfo;
            synchronized (stateInfo) {
                return this.wordInfo.completeState;
            }
        }

        public boolean isBad() {
            boolean bl = false;
            StateInfo stateInfo = this.wordInfo;
            synchronized (stateInfo) {
                if (this.wordInfo.isBad) {
                    bl = true;
                }
            }
            return bl;
        }

        public boolean isExhaustive() {
            boolean bl = false;
            StateInfo stateInfo = this.wordInfo;
            synchronized (stateInfo) {
                if (this.wordInfo.isExhaustive) {
                    bl = true;
                }
            }
            return bl;
        }

        public boolean isComplete() {
            boolean bl = false;
            StateInfo stateInfo = this.wordInfo;
            synchronized (stateInfo) {
                if (this.wordInfo.completeState != null) {
                    bl = true;
                }
            }
            return bl;
        }

        public String getWord() {
            String string = this.this$0.cc.getWordList().getOrigWord(this.word);
            return string;
        }

        public int getWordScore() {
            return (int)this.this$0.cc.getWordList().getWordScore(this.word);
        }

        public float getGridScore() {
            GridState gridState;
            GridState gridState2;
            StateInfo stateInfo = this.wordInfo;
            synchronized (stateInfo) {
                gridState2 = this.wordInfo.depthState;
            }
            stateInfo = this.parentInfo;
            synchronized (stateInfo) {
                gridState = this.parentInfo.state;
            }
            if (gridState2 == null || gridState == null) {
                return 0.0f;
            }
            float f = gridState2.getQuality(this.this$0.cc.getWordList());
            float f2 = gridState.getQuality(this.this$0.cc.getWordList());
            f2 = f / f2;
            f2 = (float)Math.rint(f2 * 1000.0f) / 1000.0f;
            return f2;
        }

        public float getFinalScore() {
            GridState gridState;
            GridState gridState2;
            StateInfo stateInfo = this.wordInfo;
            synchronized (stateInfo) {
                if (this.wordInfo.isBad) {
                    return -1.0f;
                }
                gridState2 = this.wordInfo.completeState;
            }
            stateInfo = this.parentInfo;
            synchronized (stateInfo) {
                gridState = this.parentInfo.completeState;
            }
            if (gridState2 == null || gridState == null) {
                return 0.0f;
            }
            float f = gridState2.getQuality(this.this$0.cc.getWordList());
            float f2 = gridState.getQuality(this.this$0.cc.getWordList());
            f2 = f / f2;
            f2 = (float)Math.rint(f2 * 1000.0f) / 1000.0f;
            return f2;
        }
    }

    final class FillUpdateThread
    extends Thread {
        private List<DepthTrackerSearchNode> depthNodes;
        private boolean isInterrupting;

        final synchronized void setInterrupting() {
            this.isInterrupting = true;
            this.interrupt();
        }

        private synchronized void checkInterrupting() throws InterruptedException {
            if (this.isInterrupting) {
                throw new InterruptedException();
            }
        }

        public FillUpdateThread() {
            super("Update fill info");
            this.depthNodes = new ArrayList<DepthTrackerSearchNode>();
            this.isInterrupting = false;
            this.setPriority(3);
            this.setDaemon(true);
        }

        @Override
        public final void run() {
            while (true) {
                try {
                    while (true) {
                        Object object = Collections.emptyList();
                        CCFillPanel.this.candidateThread.setCandidateInfo(null, 0, (List<String>)object, null, null, (SortedSet<GridSearchNode.GSNProxy>)new TreeSet<GridSearchNode.GSNProxy>());
                        CCFillPanel.this.setWorkingText("Ready");
                        object = null;
                        UpdateTarget updateTarget = null;
                        FillUpdateThread fillUpdateThread = CCFillPanel.this.updateThread;
                        synchronized (fillUpdateThread) {
                            while (CCFillPanel.this.currentWords.isEmpty() && CCFillPanel.this.pendingUpdate == null) {
                                try {
                                    CCFillPanel.this.updateThread.wait();
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                            FillUpdateThread.interrupted();
                            this.isInterrupting = false;
                            if (!CCFillPanel.this.currentWords.isEmpty()) {
                                object = CCFillPanel.this.currentWords.removeFirst();
                            } else {
                                updateTarget = CCFillPanel.this.currentUpdate = CCFillPanel.this.pendingUpdate;
                                CCFillPanel.this.pendingUpdate = null;
                            }
                        }
                        if (object != null) {
                            this.doUpdateWord((WordTarget)object);
                            continue;
                        }
                        this.doUpdateOp(updateTarget);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                catch (Throwable throwable) {
                    GUIUtil.showStackTraceDialog(CCFillPanel.this, throwable);
                    continue;
                }
                break;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private void doUpdateWord(WordTarget wordTarget) {
            if (wordTarget.wasAdded) {
                Iterator iterator = CCFillPanel.this.savedStates.iterator();
                while (iterator.hasNext()) {
                    StateInfo stateInfo;
                    StateInfo stateInfo2 = stateInfo = (StateInfo)iterator.next();
                    // MONITORENTER : stateInfo
                    if (stateInfo.isBad) {
                        stateInfo.isBad = false;
                    }
                    // MONITOREXIT : stateInfo2
                }
                return;
            }
            Iterator iterator = CCFillPanel.this.savedStates.iterator();
            while (iterator.hasNext()) {
                GridState gridState;
                int n;
                int n2;
                StateInfo stateInfo = (StateInfo)iterator.next();
                String string = wordTarget.word;
                GridState gridState2 = CCFillPanel.this.cc.getDisplay().getState();
                int n3 = CCFillPanel.findCompleteWord(string, gridState2);
                StateInfo stateInfo3 = stateInfo;
                // MONITORENTER : stateInfo3
                GridState gridState3 = stateInfo.completeState;
                if (gridState3 != null && (n2 = CCFillPanel.findCompleteWord(string, gridState3)) != -1) {
                    n = 1;
                    if (n3 != -1 && CCFillPanel.isAncestor(gridState2, gridState3)) {
                        n = 0;
                    }
                    if (n != 0) {
                        stateInfo.isExhaustive = false;
                        stateInfo.completeState = null;
                        stateInfo.completeScore = -1.0f;
                        stateInfo.completeBranch = -1;
                    }
                }
                if ((gridState = stateInfo.depthState) != null && (n = CCFillPanel.findCompleteWord(string, gridState)) != -1) {
                    boolean bl = true;
                    if (n3 != -1 && CCFillPanel.isAncestor(gridState2, gridState)) {
                        bl = false;
                    }
                    if (bl) {
                        stateInfo.depthState = null;
                        stateInfo.depthScore = -1.0f;
                    }
                }
                // MONITOREXIT : stateInfo3
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private void doUpdateOp(UpdateTarget object) throws InterruptedException {
            Object object2;
            ArrayList<String> arrayList;
            int n;
            Object object3;
            BuffWordList buffWordList;
            BitSet bitSet;
            DepthTrackerSearchNode depthTrackerSearchNode;
            BitSet bitSet2;
            Pattern[] patternArray;
            BitSet bitSet3;
            int n2;
            GridState gridState;
            block74: {
                Object object4;
                Cloneable cloneable;
                int n3;
                gridState = ((UpdateTarget)object).state;
                n2 = ((UpdateTarget)object).selectedWord;
                object = ((UpdateTarget)object).area;
                bitSet3 = null;
                if (object != null && ((BitSet)object).cardinality() > 1) {
                    bitSet3 = new BitSet();
                    WordGrid wordGrid = gridState.getGrid();
                    n3 = ((BitSet)object).nextSetBit(0);
                    while (n3 != -1) {
                        if (gridState.getChars()[n3] != '\u007f') {
                            int n4 = wordGrid.getCrossWordCount(n3);
                            for (int i = 0; i < n4; ++i) {
                                bitSet3.set(wordGrid.getCrossWord(n3, i));
                            }
                        }
                        n3 = ((BitSet)object).nextSetBit(n3 + 1);
                    }
                }
                object = this;
                ((FillUpdateThread)object).CCFillPanel.this.setWorkingText("*Preparing*");
                ((FillUpdateThread)object).CCFillPanel.this.setCantFill(false);
                try {
                    SwingUtilities.invokeAndWait(new Runnable((FillUpdateThread)object){
                        private /* synthetic */ FillUpdateThread this$1;
                        {
                            this.this$1 = fillUpdateThread;
                        }

                        @Override
                        public final void run() {
                            this.this$1.CCFillPanel.this.fpTable.clearSelection();
                            RecordTableModel<TableData> recordTableModel = this.this$1.CCFillPanel.this.fpModel;
                            synchronized (recordTableModel) {
                                this.this$1.CCFillPanel.this.fpModel.setData((TableData[])new TableData[0]);
                                return;
                            }
                        }
                    });
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {}
                this.checkInterrupting();
                if (n2 == -1) return;
                if (gridState.isComplete(n2)) {
                    return;
                }
                patternArray = CCFillPanel.this.getStateInfo(gridState, bitSet3);
                Object object5 = patternArray;
                // MONITORENTER : patternArray
                float f = patternArray.completeScore;
                n3 = patternArray.isBad ? 1 : 0;
                // MONITOREXIT : object5
                object5 = new Pattern[1];
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){
                        private /* synthetic */ Pattern[] val$filterHolder;
                        private /* synthetic */ FillUpdateThread this$1;
                        {
                            this.this$1 = fillUpdateThread;
                            this.val$filterHolder = patternArray;
                        }

                        @Override
                        public final void run() {
                            if (this.this$1.CCFillPanel.this.filterField.getText().length() != 0) {
                                try {
                                    this.val$filterHolder[0] = Pattern.compile(this.this$1.CCFillPanel.this.filterField.getText());
                                    return;
                                }
                                catch (PatternSyntaxException patternSyntaxException) {
                                    JOptionPane.showMessageDialog(this.this$1.CCFillPanel.this, "Invalid filter expression: " + this.this$1.CCFillPanel.this.filterField.getText());
                                }
                            }
                        }
                    });
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new RuntimeException(invocationTargetException);
                }
                object = object5[0];
                object5 = gridState.findIsland(n2);
                bitSet2 = new BitSet();
                int n5 = gridState.getWordCount();
                for (int i = 0; i < n5; ++i) {
                    if (gridState.isComplete(i) || ((BitSet)object5).get(i) || bitSet2.get(i)) continue;
                    bitSet2.or(gridState.findIsland(i));
                }
                if (bitSet3 != null) {
                    ((BitSet)object5).and(bitSet3);
                    bitSet2.and(bitSet3);
                }
                depthTrackerSearchNode = new DepthTrackerSearchNode(CCFillPanel.this, gridState, null);
                new DepthTrackerSearchNode(CCFillPanel.this, gridState, null).options.neighborhood = bitSet3;
                bitSet = new BitSet(gridState.getWordCount());
                object5 = depthTrackerSearchNode.generateCandidateWords(n2, (Pattern)object, bitSet);
                buffWordList = CCFillPanel.this.cc.getWordList();
                Collections.sort(object5, new Comparator<String>(){
                    private /* synthetic */ WordList val$wl;
                    {
                        this.val$wl = wordList;
                    }
                });
                object3 = new TreeSet<StateInfo>();
                CCFillPanel.this.setCantFill(n3 != 0);
                if (f != -1.0f) {
                    Object object6 = patternArray;
                    // MONITORENTER : patternArray
                    GridState gridState2 = patternArray.completeState;
                    n = patternArray.completeBranch;
                    // MONITOREXIT : object6
                    object6 = patternArray.completeState.getCompleteWord(n2);
                    if (object6 != null) {
                        arrayList = new GridState(gridState);
                        ((GridState)((Object)arrayList)).setString(n2, (String)object6);
                        cloneable = CCFillPanel.this.getStateInfo((GridState)((Object)arrayList), bitSet3);
                        if (((StateInfo)((Object)cloneable)).completeScore == -1.0f) {
                            ((StateInfo)((Object)cloneable)).completeScore = f;
                            ((StateInfo)((Object)cloneable)).completeState = gridState2;
                            ((StateInfo)((Object)cloneable)).completeBranch = n;
                            ((StateInfo)((Object)cloneable)).isBad = false;
                        }
                        if (((StateInfo)((Object)cloneable)).depthScore == -1.0f) {
                            DepthTrackerSearchNode depthTrackerSearchNode2 = new DepthTrackerSearchNode(CCFillPanel.this, (GridState)((Object)arrayList), this.depthNodes);
                            new DepthTrackerSearchNode(CCFillPanel.this, (GridState)((Object)arrayList), this.depthNodes).options.neighborhood = bitSet3;
                            depthTrackerSearchNode2.maxDepth = CCConfig.getCandidateQuality();
                            this.depthNodes.clear();
                            CCFillPanel.doSearch(depthTrackerSearchNode2, Integer.MAX_VALUE, CCFillPanel.this.cc.getOptWidth());
                            this.checkInterrupting();
                            depthTrackerSearchNode2.maxDepth = Integer.MAX_VALUE;
                            object4 = this.depthNodes.get(this.depthNodes.size() - 1);
                            ((StateInfo)((Object)cloneable)).depthState = ((DepthTrackerSearchNode)object4).state;
                            ((StateInfo)((Object)cloneable)).depthScore = ((GridSearchNode)object4).getQuality();
                        }
                        if ((object == null || ((Pattern)object).matcher((CharSequence)object6).matches()) && ((StateInfo)((Object)cloneable)).depthScore != -1.0f) {
                            CCFillPanel.this.addTableEntry(n2, (StateInfo)((Object)cloneable), (StateInfo)patternArray);
                        }
                    }
                }
                this.checkInterrupting();
                CCFillPanel.this.setWorkingText("*Generating candidates*");
                this.checkInterrupting();
                object2 = new TreeSet<GridSearchNode.GSNProxy>();
                CCFillPanel.this.candidateThread.setCandidateInfo(depthTrackerSearchNode, n2, (List<String>)object5, (SortedSet<StateInfo>)object3, (StateInfo)patternArray, (SortedSet<GridSearchNode.GSNProxy>)object2);
                n = 0;
                boolean bl = false;
                while (true) {
                    this.checkInterrupting();
                    cloneable = object3;
                    // MONITORENTER : cloneable
                    while (!((ArrayList)object5).isEmpty() && object3.isEmpty()) {
                        object3.wait();
                    }
                    this.checkInterrupting();
                    if (!bl && ((ArrayList)object5).isEmpty()) {
                        bl = true;
                        CCFillPanel.this.setWorkingText("*Evaluating candidates*");
                    }
                    if (object3.isEmpty()) {
                        object4 = CCFillPanel.this.fpModel;
                        // MONITORENTER : object4
                        boolean bl2 = CCFillPanel.this.fpModel.getRowCount() == 0;
                        // MONITOREXIT : object4
                        if (bl2 && object == null) {
                            n = 1;
                        }
                        // MONITOREXIT : cloneable
                        if (CCFillPanel.this.fpModel.getRowCount() < 100) {
                            break;
                        }
                        break block74;
                    }
                    arrayList = (StateInfo)object3.first();
                    object3.remove(arrayList);
                    // MONITOREXIT : cloneable
                    this.doSafeSearch(n2, (StateInfo)((Object)arrayList), (StateInfo)patternArray, bitSet2, bitSet3);
                    this.checkInterrupting();
                    if (((StateInfo)((Object)arrayList)).completeScore != -1.0f || ((StateInfo)((Object)arrayList)).isBad) continue;
                    cloneable = arrayList;
                    // MONITORENTER : cloneable
                    ++((StateInfo)((Object)arrayList)).searchLevel;
                    if (((StateInfo)((Object)arrayList)).searchLevel >= 5) {
                        ((StateInfo)((Object)arrayList)).shouldTrackBlocking = true;
                    }
                    ++((StateInfo)((Object)arrayList)).reorderCount;
                    // MONITOREXIT : cloneable
                    cloneable = object3;
                    // MONITORENTER : cloneable
                    object3.add(arrayList);
                    // MONITOREXIT : cloneable
                }
                if (!((TreeSet)object2).isEmpty()) {
                    CCFillPanel.this.setWorkingText("*Checking additional candidates*");
                    while (!((TreeSet)object2).isEmpty() && CCFillPanel.this.fpModel.getRowCount() < 100) {
                        arrayList = ((TreeSet)object2).first();
                        ((TreeSet)object2).remove(arrayList);
                        cloneable = (DepthTrackerSearchNode)((GridSearchNode.GSNProxy)((Object)arrayList)).getNode();
                        GridState gridState3 = ((DepthTrackerSearchNode)cloneable).state;
                        object4 = CCFillPanel.this.getStateInfo(gridState3, bitSet3);
                        boolean bl3 = false;
                        object3 = object4;
                        // MONITORENTER : object3
                        if (((StateInfo)object4).isBad) {
                            // MONITOREXIT : object3
                            continue;
                        }
                        if (((StateInfo)object4).completeState != null) {
                            bl3 = true;
                        } else {
                            if (((StateInfo)object4).searchLevel > 4) {
                                // MONITOREXIT : object3
                                continue;
                            }
                            ((StateInfo)object4).searchLevel = 4;
                        }
                        // MONITOREXIT : object3
                        this.checkInterrupting();
                        if (!bl3) {
                            this.doSafeSearch(n2, (StateInfo)object4, (StateInfo)patternArray, bitSet2, bitSet3);
                            this.checkInterrupting();
                            object3 = object4;
                            // MONITORENTER : object3
                            if (((StateInfo)object4).completeState != null) {
                                n = 0;
                            } else {
                                ++((StateInfo)object4).searchLevel;
                            }
                            // MONITOREXIT : object3
                            continue;
                        }
                        n = 0;
                        CCFillPanel.this.addTableEntry(n2, (StateInfo)object4, (StateInfo)patternArray);
                    }
                }
            }
            if (CCFillPanel.this.fpModel.getRowCount() < 100 && CCFillPanel.this.showEliminated) {
                CCFillPanel.this.setWorkingText("*Checking additional candidates*");
                arrayList = depthTrackerSearchNode.generateCandidateWords(n2, (Pattern)object, bitSet);
                Collections.sort(arrayList, new Comparator<String>(){
                    private /* synthetic */ WordList val$wl;
                    {
                        this.val$wl = wordList;
                    }
                });
                for (int i = 0; i < arrayList.size() && CCFillPanel.this.fpModel.getRowCount() < 100; ++i) {
                    GridState gridState4 = new GridState(gridState);
                    gridState4.setString(n2, arrayList.get(i));
                    int n6 = CCFillPanel.this.findModelIndex(gridState4);
                    if (n6 != -1) continue;
                    StateInfo stateInfo = CCFillPanel.this.getStateInfo(gridState4, bitSet3);
                    CCFillPanel.this.getStateInfo(gridState4, bitSet3).isBad = true;
                    stateInfo.depthScore = -1.0f;
                    stateInfo.completeScore = -1.0f;
                    CCFillPanel.this.addTableEntry(n2, stateInfo, (StateInfo)patternArray);
                }
            }
            int n7 = 0;
            int n8 = gridState.getWordCount();
            for (int i = 0; i < n8; ++i) {
                if (bitSet2.get(i) || bitSet3 != null && !bitSet3.get(i) || gridState.isComplete(i)) continue;
                ++n7;
            }
            if (n == 0 && n7 <= 10) {
                CCFillPanel.this.setWorkingText("*Finding best fills*");
                ArrayList<GridState> arrayList2 = new ArrayList<GridState>();
                GridState gridState5 = null;
                int n9 = CCFillPanel.this.fpModel.getRowCount();
                for (int i = 0; i < n9; ++i) {
                    this.checkInterrupting();
                    arrayList2.add(CCFillPanel.this.fpModel.getValueAt(i).getState());
                    if (gridState5 != null) continue;
                    gridState5 = CCFillPanel.this.fpModel.getValueAt(i).getCompleteState();
                }
                for (GridState gridState6 : arrayList2) {
                    float f;
                    this.checkInterrupting();
                    object = object3 = CCFillPanel.this.getStateInfo(gridState6, bitSet3);
                    // MONITORENTER : object3
                    if (((StateInfo)object3).isExhaustive) {
                        // MONITOREXIT : object
                        continue;
                    }
                    // MONITOREXIT : object
                    object = gridState6;
                    if (bitSet2.cardinality() > 0 && gridState5 != null) {
                        object = new GridState((GridState)object);
                        int n10 = bitSet2.nextSetBit(0);
                        while (n10 != -1) {
                            ((GridState)object).setString(n10, gridState5.getCompleteWord(n10));
                            n10 = bitSet2.nextSetBit(n10 + 1);
                        }
                    }
                    Object object7 = new FindSolutionNode(CCFillPanel.this, (GridState)object);
                    new FindSolutionNode(CCFillPanel.this, (GridState)object).options.beam = Integer.MAX_VALUE;
                    ((GridSearchNode)object7).options.beamMultiplier = 1;
                    ((GridSearchNode)object7).options.neighborhood = bitSet3;
                    if (CCFillPanel.this.cc.getOptWidth() > 1) {
                        object7 = new DepthPlusSearch((SearchNode)object7);
                        v2.maxWidth = Integer.MAX_VALUE;
                        ((DepthPlusSearch)object7).setExhaustive(true);
                        this.checkInterrupting();
                        object = object7;
                        object = (GridSearchNode)((DepthPlusSearch)object).search2(Integer.MAX_VALUE);
                    } else {
                        object7 = new DepthFirstSearch((SearchNode)object7);
                        v3.maxWidth = Integer.MAX_VALUE;
                        ((DepthFirstSearch)object7).setExhaustive(true);
                        this.checkInterrupting();
                        object = object7;
                        object = (GridSearchNode)((DepthFirstSearch)object).search2(Integer.MAX_VALUE);
                    }
                    if (object == null) continue;
                    this.checkInterrupting();
                    int n11 = CCFillPanel.computeBranchCount((GridSearchNode)object);
                    object2 = object3;
                    // MONITORENTER : object2
                    float f2 = ((GridSearchNode)object).getQuality();
                    if (f < ((StateInfo)object3).completeScore && WARNINGS != null) {
                        WARNINGS.log("Exhaustive search produced worse result.");
                    }
                    ((StateInfo)object3).completeScore = f2;
                    ((StateInfo)object3).completeState = ((GridSearchNode)object).state;
                    ((StateInfo)object3).completeBranch = n11;
                    ((StateInfo)object3).isExhaustive = true;
                    // MONITOREXIT : object2
                    CCFillPanel.this.addTableEntry(n2, (StateInfo)object3, (StateInfo)patternArray);
                }
            }
            if (n != 0) {
                CCFillPanel.this.setCantFill(true);
                Pattern[] patternArray2 = patternArray;
                // MONITORENTER : patternArray
                if (patternArray.completeState == null) {
                    patternArray.isBad = true;
                } else if (DEBUG != null) {
                    DEBUG.log("Good node gone bad");
                }
                // MONITOREXIT : patternArray2
            }
            try {
                SwingUtilities.invokeAndWait(new Runnable(this){
                    private /* synthetic */ FillUpdateThread this$1;
                    {
                        this.this$1 = fillUpdateThread;
                    }

                    @Override
                    public final void run() {
                        if (this.this$1.CCFillPanel.this.fpTable.getSelectedRow() == -1 && this.this$1.CCFillPanel.this.fpModel.getRowCount() > 0) {
                            this.this$1.CCFillPanel.this.fpTable.changeSelection(0, 0, false, false);
                        }
                    }
                });
                return;
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException);
            }
        }

        private boolean doSafeSearch(int n, StateInfo stateInfo, StateInfo stateInfo2, BitSet cloneable, BitSet bitSet) throws InterruptedException {
            boolean bl;
            int n2;
            int n3;
            int n4;
            Object object = stateInfo;
            synchronized (object) {
                n4 = CCFillPanel.this.cc.getOptWidth();
                n3 = (int)(600.0 * Math.pow(3.0, stateInfo.searchLevel));
                n2 = stateInfo.reorderCount;
                bl = stateInfo.shouldTrackBlocking;
            }
            Object object2 = stateInfo2;
            synchronized (object2) {
                object = stateInfo2.completeState;
            }
            if (VERBOSE != null) {
                VERBOSE.log("Searching " + stateInfo.state.getString(n) + " for " + n3 + " repeats");
            }
            object2 = stateInfo.state;
            if (((BitSet)cloneable).cardinality() > 0 && object != null) {
                object2 = new GridState(stateInfo.state);
                int n5 = ((BitSet)cloneable).nextSetBit(0);
                while (n5 != -1) {
                    ((GridState)object2).setString(n5, ((GridState)object).getCompleteWord(n5));
                    n5 = ((BitSet)cloneable).nextSetBit(n5 + 1);
                }
            }
            SafeSearchNode safeSearchNode = new SafeSearchNode(this, (GridState)object2, this.depthNodes, n2);
            new SafeSearchNode(this, (GridState)object2, this.depthNodes, n2).options.neighborhood = bitSet;
            safeSearchNode.options.trackBlockingWords = bl;
            this.depthNodes.clear();
            safeSearchNode.latestWord = n;
            cloneable = CCFillPanel.doSearch(safeSearchNode, n3, n4);
            this.checkInterrupting();
            boolean bl2 = cloneable == null;
            int n6 = n3 = cloneable != null && !((GridSearchNode)cloneable).isGoalNode() ? 1 : 0;
            if (bl2) {
                n3 = 0;
                StateInfo stateInfo3 = stateInfo;
                synchronized (stateInfo3) {
                    if (bl) {
                        stateInfo.isBad = true;
                        n3 = 1;
                    } else {
                        stateInfo.shouldTrackBlocking = true;
                    }
                }
                if (n3 != 0) {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){
                            private /* synthetic */ StateInfo val$info;
                            private /* synthetic */ FillUpdateThread this$1;
                            {
                                this.this$1 = fillUpdateThread;
                                this.val$info = stateInfo;
                            }

                            @Override
                            public final void run() {
                                RecordTableModel<TableData> recordTableModel = this.this$1.CCFillPanel.this.fpModel;
                                synchronized (recordTableModel) {
                                    int n = this.this$1.CCFillPanel.this.findModelIndex(this.val$info.state);
                                    if (n != -1) {
                                        if (this.this$1.CCFillPanel.this.showEliminated) {
                                            int n2 = n;
                                            this.this$1.CCFillPanel.this.fpModel.fireTableRowsUpdated(n2, n2);
                                        } else {
                                            this.this$1.CCFillPanel.this.fpModel.removeRow(n);
                                        }
                                        this.this$1.CCFillPanel.this.fpTable.repaint();
                                    }
                                    return;
                                }
                            }
                        });
                    }
                    catch (Exception exception) {}
                }
            } else if (n3 == 0 && cloneable != null) {
                n3 = CCFillPanel.computeBranchCount((GridSearchNode)cloneable);
                StateInfo stateInfo4 = stateInfo;
                synchronized (stateInfo4) {
                    stateInfo.completeScore = ((GridSearchNode)cloneable).getQuality();
                    stateInfo.completeState = ((GridSearchNode)cloneable).state;
                    stateInfo.completeBranch = n3;
                    if (stateInfo.depthState == null) {
                        cloneable = safeSearchNode.depthResults.get(Math.min(CCConfig.getCandidateQuality(), safeSearchNode.depthResults.size() - 1));
                        stateInfo.depthState = ((GridSearchNode)cloneable).state;
                        stateInfo.depthScore = ((GridSearchNode)cloneable).getQuality();
                    }
                    stateInfo.isBad = false;
                }
                CCFillPanel.this.addTableEntry(n, stateInfo, stateInfo2);
            }
            return !bl2;
        }

        final class SafeSearchNode
        extends DepthTrackerSearchNode {
            private final int rrCount;

            private SafeSearchNode(FillUpdateThread fillUpdateThread, GridState gridState, List<DepthTrackerSearchNode> list, int n) {
                super(fillUpdateThread.CCFillPanel.this, gridState, list);
                this.rrCount = n;
            }

            @Override
            public final SearchNodeProxy[] generateSuccessors(int n, int n2, float f, Pattern pattern, int n3) {
                SearchNodeProxy[] searchNodeProxyArray = super.generateSuccessors(n, n2, f, pattern, n3);
                if (GridStrategies.USE_1_1_STRATEGIES) {
                    n2 = this.rrCount - this.depth / 2;
                    int n4 = Math.min(n2, searchNodeProxyArray.length);
                    for (int i = 0; i < n4; ++i) {
                        ((GridSearchNode.GSNProxy)searchNodeProxyArray[i]).priority /= (float)(n2 - i + 1);
                    }
                }
                return searchNodeProxyArray;
            }
        }
    }

    final class CandidateThread
    extends Thread {
        private List<String> input;
        private SortedSet<StateInfo> output;
        private List<DepthTrackerSearchNode> depthNodes;
        private StateInfo parentInfo;
        private GridSearchNode parentNode;
        private int wordIndex;
        private SortedSet<GridSearchNode.GSNProxy> extraOut;
        private /* synthetic */ CCFillPanel this$0;

        public CandidateThread(CCFillPanel cCFillPanel) {
            this.this$0 = cCFillPanel;
            super("Generate candidates");
            this.depthNodes = new ArrayList<DepthTrackerSearchNode>();
            this.setPriority(3);
            this.setDaemon(true);
        }

        public final synchronized void setCandidateInfo(GridSearchNode gridSearchNode, int n, List<String> list, SortedSet<StateInfo> sortedSet, StateInfo stateInfo, SortedSet<GridSearchNode.GSNProxy> sortedSet2) {
            this.input = list;
            this.output = sortedSet;
            this.parentInfo = stateInfo;
            this.parentNode = gridSearchNode;
            this.wordIndex = n;
            this.extraOut = sortedSet2;
            this.notifyAll();
        }

        @Override
        public final void run() {
            while (true) {
                Object object;
                try {
                    while (true) {
                        SortedSet<GridSearchNode.GSNProxy> sortedSet;
                        int n;
                        GridSearchNode gridSearchNode;
                        StateInfo stateInfo;
                        SortedSet<StateInfo> sortedSet2;
                        CandidateThread candidateThread = this;
                        synchronized (candidateThread) {
                            while (this.input == null) {
                                try {
                                    this.wait();
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                            object = this.input;
                            sortedSet2 = this.output;
                            stateInfo = this.parentInfo;
                            gridSearchNode = this.parentNode;
                            n = this.wordIndex;
                            sortedSet = this.extraOut;
                            this.input = null;
                        }
                        this.generateCandidates(gridSearchNode, n, (List<String>)object, sortedSet2, stateInfo, sortedSet);
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throwable.printStackTrace();
                    continue;
                }
                break;
            }
        }

        private synchronized DepthTrackerSearchNode generateDepthNode(DepthTrackerSearchNode gridSearchNode, StateInfo stateInfo) {
            block6: {
                int n = CCConfig.getCandidateQuality();
                boolean bl = n == 0;
                if (bl) break block6;
                gridSearchNode = (DepthTrackerSearchNode)gridSearchNode.clone();
                v0.maxDepth = n;
                gridSearchNode.cloneOptions();
                ((DepthTrackerSearchNode)gridSearchNode).options.aggressiveBacktracking = false;
                this.depthNodes.clear();
                ((DepthTrackerSearchNode)gridSearchNode).depthResults = this.depthNodes;
                gridSearchNode = CCFillPanel.doSearch(gridSearchNode, Integer.MAX_VALUE, this.this$0.cc.getOptWidth());
                if (this.input != null) {
                    return null;
                }
                if (gridSearchNode == null) {
                    StateInfo stateInfo2 = stateInfo;
                    synchronized (stateInfo2) {
                        stateInfo.isBad = true;
                    }
                }
                if ((n = gridSearchNode == null || !gridSearchNode.isGoalNode() ? 1 : 0) != 0) {
                    return null;
                }
                gridSearchNode = this.depthNodes.get(this.depthNodes.size() - 1);
            }
            return gridSearchNode;
        }

        private void generateCandidates(GridSearchNode gridSearchNode, int n, List<String> list, SortedSet<StateInfo> sortedSet, StateInfo stateInfo, SortedSet<GridSearchNode.GSNProxy> sortedSet2) {
            Object object;
            Object object2;
            int n2 = this.this$0.cc.getMinAutofillScore();
            int n3 = 0;
            Iterator<String> iterator = list.iterator();
            int n4 = (list.size() + 100 - 1) / 100;
            n4 = Math.max(10, n4);
            if (gridSearchNode != null) {
                this.this$0.cc.getOptWidth();
            }
            while ((iterator.hasNext() || !sortedSet2.isEmpty()) && n3 < 100) {
                int n5;
                if (this.input != null) {
                    return;
                }
                for (int i = 0; i < n4 && iterator.hasNext(); ++i) {
                    object2 = gridSearchNode.conditionalSuccessor(n, iterator.next(), n2);
                    if (object2 == null) continue;
                    sortedSet2.add((GridSearchNode.GSNProxy)object2);
                }
                if (sortedSet2.isEmpty()) continue;
                SortedSet<StateInfo> sortedSet3 = sortedSet2.first();
                sortedSet2.remove(sortedSet3);
                object2 = (DepthTrackerSearchNode)((GridSearchNode.GSNProxy)((Object)sortedSet3)).getNode();
                int n6 = ((DepthTrackerSearchNode)object2).latestWord;
                GridState gridState = ((DepthTrackerSearchNode)object2).state;
                object = this.this$0.getStateInfo(gridState, ((DepthTrackerSearchNode)object2).options.neighborhood);
                RecordTableModel<TableData> recordTableModel = this.this$0.fpModel;
                synchronized (recordTableModel) {
                    n5 = this.this$0.fpModel.getRowCount();
                }
                int n7 = 1;
                if (n5 > 50) {
                    n7 = 5;
                } else if (n5 > 15) {
                    n7 = 3;
                }
                if (((StateInfo)object).isBad) {
                    if (((StateInfo)object).depthScore != -1.0f) {
                        ++n3;
                    }
                    if (!this.this$0.showEliminated) continue;
                    this.this$0.addTableEntry(n6, (StateInfo)object, stateInfo);
                    continue;
                }
                if (((StateInfo)object).depthScore == -1.0f) {
                    sortedSet3 = this.generateDepthNode((DepthTrackerSearchNode)object2, (StateInfo)object);
                    if (this.input != null) {
                        return;
                    }
                    if (sortedSet3 == null) continue;
                    object2 = object;
                    synchronized (object2) {
                        ((StateInfo)object).depthState = ((DepthTrackerSearchNode)((Object)sortedSet3)).state;
                        ((StateInfo)object).depthScore = ((GridSearchNode)((Object)sortedSet3)).getQuality();
                        ((StateInfo)object).searchLevel = n7 - 1;
                    }
                }
                ++n3;
                sortedSet3 = this;
                synchronized (sortedSet3) {
                    if (this.input != null) {
                        return;
                    }
                    this.this$0.addTableEntry(n6, (StateInfo)object, stateInfo);
                }
                if (((StateInfo)object).completeScore != -1.0f) continue;
                sortedSet3 = sortedSet;
                synchronized (sortedSet3) {
                    sortedSet.add((StateInfo)object);
                    sortedSet.notifyAll();
                }
            }
            if (GridStrategies.USE_1_1_STRATEGIES) {
                Iterator iterator2 = sortedSet2.iterator();
                while (iterator2.hasNext()) {
                    if (this.input != null) {
                        return;
                    }
                    object2 = (GridSearchNode.GSNProxy)iterator2.next();
                    DepthTrackerSearchNode depthTrackerSearchNode = (DepthTrackerSearchNode)((GridSearchNode.GSNProxy)object2).getNode();
                    int n8 = depthTrackerSearchNode.latestWord;
                    object = depthTrackerSearchNode.state;
                    StateInfo stateInfo2 = this.this$0.getStateInfo((GridState)object, depthTrackerSearchNode.options.neighborhood);
                    if (stateInfo2.completeScore == -1.0f) continue;
                    if (stateInfo2.depthState == null) {
                        DepthTrackerSearchNode depthTrackerSearchNode2 = this.generateDepthNode(depthTrackerSearchNode, stateInfo2);
                        if (this.input != null) {
                            return;
                        }
                        if (depthTrackerSearchNode2 == null) continue;
                        stateInfo2.depthState = depthTrackerSearchNode2.state;
                        stateInfo2.depthScore = depthTrackerSearchNode2.getQuality();
                    }
                    if (this.input != null) {
                        return;
                    }
                    this.this$0.addTableEntry(n8, stateInfo2, stateInfo);
                    iterator2.remove();
                }
            }
            list.clear();
            if (sortedSet != null) {
                SortedSet<StateInfo> sortedSet4 = sortedSet;
                synchronized (sortedSet4) {
                    sortedSet.notifyAll();
                    return;
                }
            }
        }
    }

    public static enum Status {
        NEW,
        VISITED,
        GOOD,
        BAD;

    }

    final class UpdateTarget {
        GridState state;
        int selectedWord;
        private final BitSet area;

        public UpdateTarget(CCFillPanel cCFillPanel, GridState gridState, int n, BitSet bitSet) {
            this.state = gridState;
            this.selectedWord = n;
            this.area = bitSet;
        }
    }

    public class FindSolutionNode
    extends GreedyGridSearchNode {
        public FindSolutionNode(CCFillPanel cCFillPanel, GridState gridState) {
            super(null, gridState, CCFillPanel.makeSolutionOpts(cCFillPanel.cc, 100), 1, 0.0f);
        }

        @Override
        public boolean isGoalNode() {
            return super.isGoalNode();
        }
    }

    class DepthTrackerSearchNode
    extends FindSolutionNode {
        private List<DepthTrackerSearchNode> depthResults;
        public int maxDepth = Integer.MAX_VALUE;

        public DepthTrackerSearchNode(CCFillPanel cCFillPanel, GridState gridState, List<DepthTrackerSearchNode> list) {
            super(cCFillPanel, gridState);
            this.depthResults = list;
        }

        @Override
        public final boolean isGoalNode() {
            if (this.depthResults != null && this.depth >= this.depthResults.size()) {
                this.depthResults.add(this);
            }
            if (this.depth >= this.maxDepth) {
                return true;
            }
            return super.isGoalNode();
        }
    }

    public final class WordTarget {
        String word;
        boolean wasAdded;

        public WordTarget(CCFillPanel cCFillPanel, String string, boolean bl) {
            this.word = string;
            this.wasAdded = bl;
        }
    }
}

