/*
 * Decompiled with CFR 0.152.
 */
package com.beekeeper.xwd;

import com.beekeeper.util.DPIUtil;
import com.beekeeper.util.IntSet;
import com.beekeeper.util.SystemUtil;
import com.beekeeper.xwd.BuffWordList;
import com.beekeeper.xwd.CrossFire;
import com.beekeeper.xwd.DepthFirstSearch;
import com.beekeeper.xwd.DepthPlusSearch;
import com.beekeeper.xwd.GreedyGridSearchNode;
import com.beekeeper.xwd.GridSearchNode;
import com.beekeeper.xwd.GridState;
import com.beekeeper.xwd.GridStrategies;
import com.beekeeper.xwd.SearchNode;
import com.beekeeper.xwd.SearchNodeProxy;
import com.beekeeper.xwd.WordGrid;
import com.beekeeper.xwd.WordList;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class CCFillAction
extends AbstractAction {
    private static final Timer timer = new Timer("Fill timer", true);
    Thread fillThread;
    private static Icon startIcon = new DPIUtil.ImageIcon(CCFillAction.class.getResource("resources/fill-icon.png"));
    private static Icon stopIcon = new DPIUtil.ImageIcon(CCFillAction.class.getResource("resources/stop-fill-icon.png"));
    private final CrossFire cc;
    private boolean runningFill;

    public CCFillAction(CrossFire crossFire) {
        super("Quick Fill");
        this.putValue("AcceleratorKey", SystemUtil.makeShortcut("control F"));
        this.putValue("ShortDescription", "Quick fill");
        this.putValue("SwingLargeIconKey", startIcon);
        this.cc = crossFire;
    }

    public final GridSearchNode triangulatedSearch(GridSearchNode gridSearchNode, int n, BitSet object) {
        if (gridSearchNode.isGoalNode()) {
            return gridSearchNode;
        }
        if (GridStrategies.simpleQuickFill) {
            SearchNode searchNode;
            Object object2;
            GridSearchNode.SharedOptions sharedOptions = this.basicFillOptions((BitSet)object);
            int n2 = this.cc.getOptWidth();
            WordGrid wordGrid = gridSearchNode.state.getGrid();
            boolean bl = true;
            if (object == null) {
                bl = wordGrid.getWordCount() == wordGrid.getWidth() + wordGrid.getHeight();
            } else {
                int n3 = ((BitSet)object).nextSetBit(0);
                while (bl && n3 != -1) {
                    int n4;
                    object2 = wordGrid.getWord(n3);
                    int n5 = ((WordGrid.Word)object2).getDirection();
                    IntSet intSet = new IntSet();
                    int n6 = 0;
                    WordGrid.Word word = object2;
                    int n7 = word.letterIndices.length;
                    while (n6 < n7) {
                        n4 = n6++;
                        word = object2;
                        intSet.add(word.letterIndices[n4]);
                    }
                    n6 = ((BitSet)object).nextSetBit(0);
                    while (n6 != -1) {
                        block36: {
                            WordGrid.Word word2 = wordGrid.getWord(n6);
                            if (word2.getDirection() != n5) {
                                int n8 = 0;
                                word = word2;
                                int n9 = word.letterIndices.length;
                                while (n8 < n9) {
                                    n4 = n8++;
                                    word = word2;
                                    if (!intSet.contains(word.letterIndices[n4])) {
                                        continue;
                                    }
                                    break block36;
                                }
                                bl = false;
                                break;
                            }
                        }
                        n6 = ((BitSet)object).nextSetBit(n6 + 1);
                    }
                    n3 = ((BitSet)object).nextSetBit(n3 + 1);
                }
            }
            if (bl) {
                sharedOptions.useForceWords = false;
                sharedOptions.crossOlderWords = true;
                sharedOptions.fillEdgesFirst = false;
            } else {
                sharedOptions.gentlerForceWords = false;
                sharedOptions.crossOlderWords = false;
            }
            GridSearchNode.SharedOptions sharedOptions2 = this.basicFillOptions((BitSet)object);
            this.basicFillOptions((BitSet)object).trackBlockingWords = false;
            if (bl) {
                sharedOptions2.rootBeam = 200;
                sharedOptions2.beam = 100;
                sharedOptions2.beamMultiplier = 2;
            } else {
                sharedOptions2.rootBeam = 30;
                sharedOptions2.beam = 10;
                sharedOptions2.beamMultiplier = 20;
            }
            gridSearchNode.setOptions(sharedOptions2);
            ((GreedyGridSearchNode)gridSearchNode).setVarietyFactor(1.0E-4f);
            if (n2 > 1) {
                object2 = new DepthPlusSearch(this, gridSearchNode, n2){

                    @Override
                    public final int getRandomizeCount$7f9542f1(SearchNode searchNode) {
                        if (searchNode.depth == 0) {
                            return 50;
                        }
                        return 5;
                    }
                };
                if (bl) {
                    ((DepthPlusSearch)object2).setMaxDeadStates(0);
                }
                searchNode = ((DepthPlusSearch)object2).search2(Integer.MAX_VALUE);
                if (Thread.currentThread().isInterrupted() || !this.runningFill) {
                    return null;
                }
                if (searchNode != null) {
                    return (GridSearchNode)searchNode;
                }
            } else {
                object2 = new DepthFirstSearch(this, gridSearchNode){

                    @Override
                    public final int getRandomizeCount$7f9542f1(SearchNode searchNode) {
                        if (searchNode.depth == 0) {
                            return 50;
                        }
                        return 5;
                    }
                };
                if (bl) {
                    ((DepthFirstSearch)object2).setMaxDeadStates(0);
                }
                searchNode = ((DepthFirstSearch)object2).search2(Integer.MAX_VALUE);
                if (Thread.currentThread().isInterrupted() || !this.runningFill) {
                    return null;
                }
                if (searchNode != null) {
                    return (GridSearchNode)searchNode;
                }
            }
            sharedOptions.beam = 2000;
            sharedOptions.aggressiveBacktracking = false;
            gridSearchNode.setOptions(sharedOptions);
            object2 = new DepthPlusSearch(gridSearchNode, n2);
            ((DepthPlusSearch)object2).setRandomizeCount(50);
            if (bl) {
                ((DepthPlusSearch)object2).setMaxDeadStates(0);
            }
            searchNode = ((DepthPlusSearch)object2).search2(Integer.MAX_VALUE);
            if (Thread.currentThread().isInterrupted() || !this.runningFill) {
                return null;
            }
            if (searchNode != null) {
                return (GridSearchNode)searchNode;
            }
        } else {
            Object object3;
            int n10;
            GridSearchNode.SharedOptions sharedOptions = new GridSearchNode.SharedOptions(10, this.cc.getWordList());
            sharedOptions.setBadWordsHeuristic(false);
            sharedOptions.aggressiveBacktracking = true;
            sharedOptions.minCandidateScore = this.cc.getMinAutofillScore();
            sharedOptions.longestSubstring = this.cc.getLongestSubstring();
            sharedOptions.neighborhood = object;
            sharedOptions.fastCount = true;
            BuffWordList buffWordList = this.cc.getWordList();
            GridSearchNode gridSearchNode2 = gridSearchNode;
            SearchNodeProxy[] searchNodeProxyArray = gridSearchNode2.generateSuccessors(gridSearchNode2.chooseWordToFill(), 500, Float.NEGATIVE_INFINITY, null, 5);
            float f = 0.0f;
            if (searchNodeProxyArray.length > 0) {
                String string = ((GridSearchNode.GSNProxy)searchNodeProxyArray[0]).word;
                f = ((WordList)buffWordList).getWordScore(string) / 2.0f;
            }
            Collections.shuffle(Arrays.asList(searchNodeProxyArray));
            SearchNode[] searchNodeArray = new SearchNode[Math.min(10, searchNodeProxyArray.length)];
            int n11 = searchNodeArray.length - 1;
            for (n10 = searchNodeProxyArray.length - 1; n10 >= 0 && n11 >= 0; --n10) {
                if (n11 >= searchNodeProxyArray.length / 2 && n10 > n11 && ((WordList)buffWordList).getWordScore(((GridSearchNode.GSNProxy)searchNodeProxyArray[n10]).word) < f) continue;
                GreedyGridSearchNode greedyGridSearchNode = (GreedyGridSearchNode)searchNodeProxyArray[n10].getNode();
                greedyGridSearchNode.setOptions(sharedOptions);
                greedyGridSearchNode.setVarietyFactor(1.0f);
                searchNodeArray[n11--] = greedyGridSearchNode;
            }
            Collections.shuffle(Arrays.asList(searchNodeArray));
            for (n10 = 600; n10 <= 24300; n10 *= 3) {
                for (int i = 0; i < searchNodeArray.length; ++i) {
                    if (searchNodeArray[i] == null) continue;
                    object3 = new DepthFirstSearch(searchNodeArray[i]);
                    SearchNode searchNode = ((DepthFirstSearch)object3).search2(n10);
                    if (Thread.currentThread().isInterrupted() || !this.runningFill) {
                        return null;
                    }
                    if (searchNode != null) {
                        return (GridSearchNode)searchNode;
                    }
                    object = object3;
                    if (((DepthFirstSearch)object).searchCount >= n10) continue;
                    searchNodeArray[i] = null;
                }
            }
            GridSearchNode.SharedOptions sharedOptions3 = sharedOptions.clone();
            sharedOptions.clone().rootBeam = 50;
            sharedOptions3.beam = 10;
            sharedOptions3.beamMultiplier = 15;
            gridSearchNode.setOptions(sharedOptions3);
            ((GreedyGridSearchNode)gridSearchNode).setVarietyFactor(1.0f);
            DepthFirstSearch depthFirstSearch = new DepthFirstSearch(this, gridSearchNode){

                @Override
                public final int getRandomizeCount$7f9542f1(SearchNode searchNode) {
                    if (searchNode.depth == 0) {
                        return 50;
                    }
                    return 5;
                }
            };
            depthFirstSearch.setRandomizeCount(50);
            object3 = depthFirstSearch.search2(Integer.MAX_VALUE);
            if (Thread.currentThread().isInterrupted() || !this.runningFill) {
                return null;
            }
            if (object3 != null) {
                return (GridSearchNode)object3;
            }
            sharedOptions.beam = 2000;
            sharedOptions.beamMultiplier = 1;
            sharedOptions.aggressiveBacktracking = false;
            gridSearchNode.setOptions(sharedOptions);
            depthFirstSearch = new DepthFirstSearch(gridSearchNode);
            depthFirstSearch.setRandomizeCount(50);
            object3 = depthFirstSearch.search2(Integer.MAX_VALUE);
            if (Thread.currentThread().isInterrupted() || !this.runningFill) {
                return null;
            }
            if (object3 != null) {
                return (GridSearchNode)object3;
            }
        }
        return null;
    }

    private GridSearchNode.SharedOptions basicFillOptions(BitSet bitSet) {
        GridSearchNode.SharedOptions sharedOptions = new GridSearchNode.SharedOptions(10, this.cc.getWordList());
        sharedOptions.setBadWordsHeuristic(false);
        sharedOptions.aggressiveBacktracking = false;
        sharedOptions.minCandidateScore = this.cc.getMinAutofillScore();
        sharedOptions.longestSubstring = this.cc.getLongestSubstring();
        sharedOptions.neighborhood = bitSet;
        sharedOptions.orderStrategy = GridSearchNode.FillOrder.QUALITY;
        return sharedOptions;
    }

    @Override
    public void actionPerformed(ActionEvent object) {
        if (this.fillThread != null) {
            this.runningFill = false;
            this.fillThread.interrupt();
            try {
                this.fillThread.join();
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
        object = new Runnable(){
            long lastDisplay = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public final void run() {
                CCFillAction.this.runningFill = true;
                boolean bl = true;
                try {
                    Object object;
                    Object object2;
                    Object object3;
                    CCFillAction.this.cc.getDisplay().setComputingToolTipInfo(true);
                    long l = System.currentTimeMillis();
                    BitSet bitSet = CCFillAction.this.cc.getDisplay().getAreaSelection();
                    if (bitSet.cardinality() > 1) {
                        object3 = new BitSet();
                        object2 = CCFillAction.this.cc.getDisplay().getState();
                        object = ((GridState)object2).getGrid();
                        int n = bitSet.nextSetBit(0);
                        while (n != -1) {
                            if (((GridState)object2).getChars()[n] == '\u0000') {
                                int n2 = ((WordGrid)object).getCrossWordCount(n);
                                for (int i = 0; i < n2; ++i) {
                                    ((BitSet)object3).set(((WordGrid)object).getCrossWord(n, i));
                                }
                            }
                            n = bitSet.nextSetBit(n + 1);
                        }
                    } else {
                        object3 = CCFillAction.this.computeDesiredNeighborhood();
                    }
                    if (object3 == null || !((BitSet)object3).isEmpty()) {
                        object2 = new TimerTask(this, l){
                            private /* synthetic */ long val$startTime;
                            private /* synthetic */ 4 this$1;
                            {
                                this.this$1 = var1_1;
                                this.val$startTime = l;
                            }

                            @Override
                            public final void run() {
                                CCFillAction cCFillAction = this.this$1.CCFillAction.this;
                                synchronized (cCFillAction) {
                                    long l = (System.currentTimeMillis() - this.val$startTime + 500L) / 1000L;
                                    this.this$1.CCFillAction.this.cc.status(String.format("Fill time: %d:%02d", l / 60L, l % 60L));
                                    return;
                                }
                            }
                        };
                        timer.scheduleAtFixedRate((TimerTask)object2, 0L, 1000L);
                        object = new GridSearchNode.SharedOptions(10, CCFillAction.this.cc.getWordList());
                        ((GridSearchNode.SharedOptions)object).setBadWordsHeuristic(false);
                        ((GridSearchNode.SharedOptions)object).aggressiveBacktracking = false;
                        ((GridSearchNode.SharedOptions)object).minCandidateScore = CCFillAction.this.cc.getMinAutofillScore();
                        ((GridSearchNode.SharedOptions)object).longestSubstring = CCFillAction.this.cc.getLongestSubstring();
                        ((GridSearchNode.SharedOptions)object).neighborhood = object3;
                        ((GridSearchNode.SharedOptions)object).orderStrategy = GridSearchNode.FillOrder.QUALITY;
                        GridState gridState = CCFillAction.this.cc.pushUndo();
                        CCFillAction.this.putValue("Name", "Stop");
                        CCFillAction.this.putValue("SwingLargeIconKey", stopIcon);
                        CCFillAction.this.putValue("ShortDescription", "Stop quick fill");
                        CCFillAction.this.cc.setActiveOperation(true);
                        GreedyGridSearchNode greedyGridSearchNode = new GreedyGridSearchNode(this, null, gridState, (GridSearchNode.SharedOptions)object, 10000000, 1.0f){
                            private /* synthetic */ 4 this$1;
                            {
                                this.this$1 = var1_1;
                                super(gridSearchNode, gridState, sharedOptions, 10000000, 1.0f);
                            }

                            @Override
                            public final boolean isGoalNode() {
                                long l = System.currentTimeMillis();
                                CCFillAction cCFillAction = this.this$1.CCFillAction.this;
                                synchronized (cCFillAction) {
                                    if (l > this.this$1.lastDisplay + 200L) {
                                        this.this$1.CCFillAction.this.cc.getDisplay().setState(this.state, true);
                                        this.this$1.lastDisplay = l;
                                    }
                                }
                                return super.isGoalNode();
                            }

                            @Override
                            public final GridSearchNode.GSNProxy conditionalSuccessor(int n, String string, float f) {
                                long l = System.currentTimeMillis();
                                CCFillAction cCFillAction = this.this$1.CCFillAction.this;
                                synchronized (cCFillAction) {
                                    if (l > this.this$1.lastDisplay + 200L) {
                                        this.this$1.CCFillAction.this.cc.getDisplay().setState(this.state, true);
                                        this.this$1.lastDisplay = l;
                                    }
                                }
                                return super.conditionalSuccessor(n, string, f);
                            }
                        };
                        ((GreedyGridSearchNode)greedyGridSearchNode).setQualityFactor(25);
                        GridSearchNode gridSearchNode = CCFillAction.this.triangulatedSearch(greedyGridSearchNode, 24300, (BitSet)object3);
                        long l2 = System.currentTimeMillis();
                        float f = (float)(l2 - l) / 1000.0f;
                        Object object4 = CCFillAction.this;
                        synchronized (object4) {
                            ((TimerTask)object2).cancel();
                        }
                        bl = false;
                        CCFillAction.this.cc.getDisplay().setComputingToolTipInfo(false);
                        if (Thread.currentThread().isInterrupted() || !CCFillAction.this.runningFill) {
                            CCFillAction.this.cc.setState(CCFillAction.this.cc.popUndo(false));
                        } else if (gridSearchNode == null) {
                            CCFillAction.this.showFailureLoc(greedyGridSearchNode);
                            SwingUtilities.invokeLater(new Runnable(this){
                                private /* synthetic */ 4 this$1;
                                {
                                    this.this$1 = var1_1;
                                }

                                @Override
                                public final void run() {
                                    JOptionPane.showMessageDialog(this.this$1.CCFillAction.this.cc.getPanel(), "Could not find fill for grid");
                                    this.this$1.CCFillAction.this.cc.setState(this.this$1.CCFillAction.this.cc.popUndo(false));
                                    this.this$1.CCFillAction.this.cc.getDisplay().removeDisplay("hot-spots");
                                }
                            });
                            CCFillAction.this.cc.status(String.format("Fill time: %d:%06.3f", (int)(f / 60.0f), Float.valueOf(f % 60.0f)));
                        } else {
                            object4 = gridSearchNode.state;
                            if (bitSet.cardinality() > 1) {
                                object3 = (char[])gridState.getChars().clone();
                                object4 = gridSearchNode.state.getChars();
                                for (int i = 0; i < ((Object)object4).length; ++i) {
                                    if (object4[i] == object3[i] || !bitSet.get(i)) continue;
                                    object3[i] = object4[i];
                                }
                                object4 = new GridState(gridState, (char[])object3);
                            }
                            CCFillAction.this.cc.setState((GridState)object4, null);
                            CCFillAction.this.cc.status(String.format("Fill time: %d:%06.3f", (int)(f / 60.0f), Float.valueOf(f % 60.0f)));
                        }
                    }
                    CCFillAction.this.putValue("Name", "Quick Fill");
                    CCFillAction.this.putValue("SwingLargeIconKey", startIcon);
                    CCFillAction.this.putValue("ShortDescription", "Quick fill");
                    CCFillAction.this.cc.setActiveOperation(false);
                    CCFillAction.this.fillThread = null;
                    if (!bl) return;
                }
                catch (Throwable throwable) {
                    if (!bl) throw throwable;
                    CCFillAction.this.cc.getDisplay().setComputingToolTipInfo(false);
                    throw throwable;
                }
                CCFillAction.this.cc.getDisplay().setComputingToolTipInfo(false);
            }
        };
        this.fillThread = new Thread((Runnable)object, "Trial fill");
        this.fillThread.start();
    }

    protected final void showFailureLoc(GridSearchNode cloneable) {
        int n;
        BitSet bitSet;
        Object object = ((GridSearchNode)cloneable).options.persistentFailureCounts;
        int[] nArray = ((GridSearchNode)cloneable).options.persistentSuccessCounts;
        int n2 = ((GridSearchNode)cloneable).options.forcedNext;
        if (n2 != -1) {
            int n3 = n2;
            object[n3] = object[n3] + 50;
        }
        if ((bitSet = new BitSet(((int[])object).length)).isEmpty()) {
            int n4;
            int n5 = 0;
            for (n4 = 0; n4 < ((int[])object).length; ++n4) {
                n = object[n4] / nArray[n4];
                if (n <= n5) continue;
                n5 = n;
            }
            for (n4 = 0; n4 < ((int[])object).length; ++n4) {
                if (object[n4] / nArray[n4] <= n5 / 2) continue;
                bitSet.set(n4);
            }
        }
        if (!bitSet.isEmpty()) {
            GridState gridState = ((GridSearchNode)cloneable).state;
            Cloneable cloneable2 = null;
            n = bitSet.nextSetBit(0);
            while (n != -1) {
                cloneable = gridState.allCrosses(n);
                if (cloneable2 == null) {
                    cloneable2 = cloneable;
                } else {
                    ((BitSet)cloneable2).or((BitSet)cloneable);
                }
                n = bitSet.nextSetBit(n + 1);
            }
            if (cloneable2 == null) {
                throw new IllegalStateException();
            }
            n = bitSet.nextSetBit(0);
            while (n != -1) {
                ((BitSet)cloneable2).set(n);
                n = bitSet.nextSetBit(n + 1);
            }
            HashMap<Integer, Character> hashMap = new HashMap<Integer, Character>();
            int n6 = ((BitSet)cloneable2).nextSetBit(0);
            while (n6 != -1) {
                object = gridState.getWord(n6);
                int n7 = 0;
                Object object2 = object;
                int n8 = object.letterIndices.length;
                while (n7 < n8) {
                    int n9 = n7++;
                    object2 = object;
                    hashMap.put(object.letterIndices[n9], Character.valueOf('a'));
                }
                n6 = ((BitSet)cloneable2).nextSetBit(n6 + 1);
            }
            this.cc.getDisplay().addCharDisplay("hot-spots", hashMap, 5, new Color(0, true), new Color(0x77FF0000, true), null);
        }
    }

    protected final BitSet computeDesiredNeighborhood() {
        int n;
        GridState gridState = this.cc.getDisplay().getState();
        WordGrid wordGrid = gridState.getGrid();
        char[] cArray = gridState.getChars();
        ArrayList<BitSet> arrayList = new ArrayList<BitSet>();
        int n2 = gridState.getWordCount();
        block0: for (n = 0; n < n2; ++n) {
            if (gridState.isComplete(n)) continue;
            for (BitSet bitSet : arrayList) {
                if (bitSet.get(n)) continue block0;
            }
            arrayList.add(gridState.findIsland(n));
        }
        if (arrayList.isEmpty()) {
            return new BitSet();
        }
        n = this.cc.getDisplay().getSelectedWord();
        if (n != -1) {
            for (BitSet bitSet : arrayList) {
                if (!bitSet.get(n)) continue;
                return bitSet;
            }
        }
        if ((n2 = this.cc.getDisplay().getSelection()) != -1) {
            int n3;
            int n4 = gridState.getGrid().getWidth();
            int n5 = n2 % n4;
            BitSet bitSet = CCFillAction.checkNeighborhood(n5, n = n2 / n4, n4, n3 = gridState.getGrid().getHeight(), arrayList, wordGrid, cArray);
            if (bitSet != null) {
                return bitSet;
            }
            int n6 = -1;
            for (int i = 1; i < n4 && i < n3; ++i) {
                int n7;
                for (n7 = 0; n7 < i; ++n7) {
                    bitSet = CCFillAction.checkNeighborhood(n5 += n6, n, n4, n3, arrayList, wordGrid, cArray);
                    if (bitSet == null) continue;
                    return bitSet;
                }
                for (n7 = 0; n7 < i; ++n7) {
                    bitSet = CCFillAction.checkNeighborhood(n5, n += n6, n4, n3, arrayList, wordGrid, cArray);
                    if (bitSet == null) continue;
                    return bitSet;
                }
                n6 = -n6;
            }
        }
        return (BitSet)arrayList.get(0);
    }

    private static BitSet checkNeighborhood(int n, int n2, int n3, int n4, List<BitSet> list, WordGrid wordGrid, char[] object) {
        if (n < 0 || n2 < 0 || n >= n3 || n2 >= n4) {
            return null;
        }
        if (object[n = n2 * n3 + n] != '\u0000') {
            return null;
        }
        n3 = wordGrid.getCrossWordCount(n);
        for (n2 = 0; n2 < n3; ++n2) {
            n4 = wordGrid.getCrossWord(n, n2);
            object = list.iterator();
            while (object.hasNext()) {
                BitSet bitSet = (BitSet)object.next();
                if (!bitSet.get(n4)) continue;
                return bitSet;
            }
        }
        return null;
    }
}

