/*
 * Decompiled with CFR 0.152.
 */
package com.beekeeper.xwd;

import com.beekeeper.util.FileUtil;
import com.beekeeper.util.FileUtil13;
import com.beekeeper.util.closedhash.GenericHash;
import com.beekeeper.xwd.BuffWordList;
import com.beekeeper.xwd.CCConfig;
import com.beekeeper.xwd.WordList;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;

public final class CCDictionaries {
    public static ArrayList<File> getDictionaries() {
        String[] stringArray = CCConfig.getRawDictionaries();
        Object object = System.getProperty("path.separator");
        stringArray = stringArray.split(Pattern.quote((String)object));
        object = new ArrayList(stringArray.length);
        for (String string : stringArray) {
            if (string.isEmpty() || string.startsWith("-")) continue;
            ((ArrayList)object).add(FileUtil13.fromCurrentDir(string.substring(1)));
        }
        return object;
    }

    public static int getPrimaryIndex() {
        String[] stringArray = CCConfig.getRawDictionaries();
        String string = System.getProperty("path.separator");
        stringArray = stringArray.split(Pattern.quote(string));
        int n = 0;
        for (String string2 : stringArray) {
            if (string2.startsWith("*")) {
                return n;
            }
            if (!string2.startsWith("+")) continue;
            ++n;
        }
        return 0;
    }

    public static char[] getPreserveChars() {
        String string = CCConfig.getPreservedChars();
        return string.toCharArray();
    }

    public static CCWordList loadDictionaries(List<File> object, char[] object2) throws BadDictionaryException, NoDictionaryWordsException {
        object2 = WordList.makeLetterConv((char[])object2);
        object2 = new WordList.UniqueWordMap((char[])object2);
        int n = -1;
        object = object.iterator();
        while (object.hasNext()) {
            File file = (File)object.next();
            ++n;
            if (!file.exists()) continue;
            try {
                ((WordList.UniqueWordMap)object2).extendUniqueMap(file, null, false, n);
            }
            catch (IOException iOException) {
                throw new BadDictionaryException(iOException, file);
            }
        }
        if (((GenericHash)object2).size() == 0) {
            throw new NoDictionaryWordsException();
        }
        return new CCWordList((WordList.UniqueWordMap)object2);
    }

    public static boolean saveDictionaryChanges$6000f212(List<File> list, Component component, CCWordList cCWordList) {
        if (!cCWordList.isDirty()) {
            return true;
        }
        ArrayList<WordList.UniqueWordMap> arrayList = cCWordList.changesByDict;
        ArrayList<File> arrayList2 = new ArrayList<File>();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Object object = arrayList.get(i);
            if (((GenericHash)object).size() == 0) continue;
            File file = list.get(i);
            if (file.exists() && !file.canWrite()) {
                arrayList2.add(file);
                continue;
            }
            try {
                Object object2 = object;
                object = file;
                try {
                    if (((File)object).exists()) {
                        ((WordList.UniqueWordMap)object2).extendUniqueMap((File)object, null, false, -1);
                    }
                    object2 = new BuffWordList((WordList.UniqueWordMap)object2);
                    FileUtil.createBackup((File)object, ".bak");
                    ((WordList)object2).writeTextFile(((File)object).getCanonicalPath());
                    continue;
                }
                catch (IOException iOException) {
                    throw new BadDictionaryException(iOException, (File)object);
                }
            }
            catch (BadDictionaryException badDictionaryException) {
                arrayList2.add(file);
            }
        }
        cCWordList.setDirty(false);
        if (!arrayList2.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<HTML>");
            stringBuilder.append("The following file(s) appear to be read-only and could not be updated.  As a result, some of your dictionary edits <br>may seem to disappear next time you reload your dictionaries:");
            stringBuilder.append("<UL>");
            int n2 = arrayList2.size();
            for (n = 0; n < n2; ++n) {
                stringBuilder.append("<LI>").append(((File)arrayList2.get(n)).getName());
            }
            stringBuilder.append("</UL></HTML>");
            JOptionPane.showMessageDialog(component, stringBuilder.toString(), "File(s) not written", 0);
        }
        return true;
    }

    public static final class BadDictionaryException
    extends Exception {
        private final File dict;

        public BadDictionaryException(IOException iOException, File file) {
            super("Could not load dictionary: " + file, iOException);
            this.dict = file;
        }

        public final File getDictionary() {
            return this.dict;
        }
    }

    public static final class NoDictionaryWordsException
    extends Exception {
    }

    public static final class CCWordList
    extends BuffWordList {
        ArrayList<WordList.UniqueWordMap> changesByDict = new ArrayList();

        public CCWordList(WordList.UniqueWordMap uniqueWordMap) {
            super(uniqueWordMap);
        }

        @Override
        public final void setDirty(boolean bl) {
            super.setDirty(bl);
            if (!bl) {
                this.changesByDict = new ArrayList();
            }
        }

        public final void change(String string, String string2, float f, BitSet bitSet) {
            this.setDirty(true);
            int n = bitSet.nextSetBit(0);
            while (n != -1) {
                int n2 = n;
                CCWordList cCWordList = this;
                int n3 = cCWordList.changesByDict.size();
                int n4 = n2;
                while (n3 <= n4) {
                    cCWordList.changesByDict.add(new WordList.UniqueWordMap(cCWordList.letterConv));
                    ++n3;
                }
                cCWordList.changesByDict.get(n2).put(string, string2, f);
                n = bitSet.nextSetBit(n + 1);
            }
        }

        @Override
        public final BitSet getWordDictionaries(String string) {
            BitSet bitSet = super.getWordDictionaries(string);
            int n = this.changesByDict.size();
            for (int i = 0; i < n; ++i) {
                float f = this.changesByDict.get(i).getScore(string, -5.0f);
                if (f == -1.0f) {
                    bitSet.clear(i);
                    continue;
                }
                if (!(f >= 0.0f)) continue;
                bitSet.set(i);
            }
            return bitSet;
        }

        public final WordList.WordInfo findWordInfo(int n, String string) throws IOException {
            Object object;
            String string2;
            if (n < this.changesByDict.size() && (string2 = ((WordList.UniqueWordMap)(object = this.changesByDict.get(n))).getOrig(string, null)) != null) {
                return new WordList.WordInfo(string, string2, ((WordList.UniqueWordMap)object).getScore(string, 5.0f));
            }
            object = CCDictionaries.getDictionaries().get(n);
            return WordList.UniqueWordMap.findWordInfo((File)object, string, this.letterConv);
        }
    }
}

