/*
 * Decompiled with CFR 0.152.
 */
package com.beekeeper.xwd;

import com.beekeeper.gui.FileEntryField;
import com.beekeeper.util.DPIUtil;
import com.beekeeper.util.GUIUtil;
import com.beekeeper.util.GridHelper;
import com.beekeeper.util.NumberVerifier;
import com.beekeeper.util.PersistentCheckBox;
import com.beekeeper.util.PersistentTextField;
import com.beekeeper.util.SystemUtil;
import com.beekeeper.xwd.CCRebusPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Dictionary;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public final class CCConfig
extends JDialog {
    private boolean cancelled = true;
    private final JPanel dictPanel;
    private static String clueFile;
    private static int longestSubstring;
    private static int minAutoScore;
    private static String webLookupURL;
    private static int candidateQuality;
    private static boolean autoEnterComplete;
    private static boolean showNumbers;
    private static boolean autoSelectClues;
    private static String rawDictList;
    private static String preservedChars;
    private static int fillQuality;
    private final Class<?>[] COLUMN_CLASSES = new Class[]{ImageIcon.class, Boolean.class, String.class};
    private final ArrayList<DictFileInfo> dictionaries = new ArrayList();
    private MyTableModel dictModel = new MyTableModel(this);
    private final DPIUtil.JTable dictTable;
    private static final Icon checkIcon;
    private static final Icon huhIcon;
    private final JLabel preserveLabel;

    private static void initValues() {
        String string;
        Preferences preferences = CCConfig.getPrefs();
        clueFile = preferences.get("clue file", "");
        minAutoScore = preferences.getInt("min autofill score", 1);
        longestSubstring = preferences.getInt("longest shared substring", 3);
        candidateQuality = preferences.getInt("candidate quality", 3);
        fillQuality = preferences.getInt("fill quality", 42);
        showNumbers = preferences.getBoolean("show numbers", false);
        autoEnterComplete = preferences.getBoolean("auto enter complete", false);
        autoSelectClues = preferences.getBoolean("auto select clues", true);
        webLookupURL = preferences.get("web lookup url", "http://www.google.com/search?&q=%s");
        rawDictList = preferences.get("dict file list", null);
        if ((rawDictList == null || rawDictList.isEmpty()) && (string = preferences.get("dict file", null)) != null) {
            rawDictList = "*" + string;
        }
        if (rawDictList == null || rawDictList.isEmpty()) {
            string = new File(System.getProperty("user.home"), "MyEdits.dict").getAbsolutePath();
            String string2 = SystemUtil.isMacintosh() ? new File("/Library/CrossFire/default.dict").getAbsolutePath() : new File(System.getProperty("user.path"), "default.dict").getAbsolutePath();
            rawDictList = "*" + string + System.getProperty("path.separator") + "+" + string2;
        }
        preservedChars = preferences.get("preserved chars", "");
    }

    private CCConfig(Component component) {
        super(JOptionPane.getFrameForComponent(component), "Configuration options", true);
        CCConfig cCConfig = this;
        this.dictTable = new DPIUtil.JTable(cCConfig, cCConfig.dictModel){
            private /* synthetic */ CCConfig this$0;
            {
                this.this$0 = cCConfig;
                super(tableModel);
            }

            @Override
            public final String getToolTipText(MouseEvent mouseEvent) {
                int n;
                Point point = mouseEvent.getPoint();
                int n2 = this.columnAtPoint(point);
                if (n2 == 2 && (n = this.rowAtPoint(point)) >= 0 && n < this.this$0.dictionaries.size()) {
                    return this.this$0.dictionaries.get((int)n).file.getAbsolutePath();
                }
                return super.getToolTipText(mouseEvent);
            }
        };
        this.preserveLabel = new JLabel();
        component = new JTabbedPane();
        Serializable serializable2 = new JPanel();
        PersistentTextField persistentTextField = new PersistentTextField("5", 3, "/beekeeper labs/crossfire", "min autofill score");
        persistentTextField.setInputVerifier(new NumberVerifier("min score", true, false, 1.0, 2.147483647E9));
        JComponent jComponent = new PersistentTextField("3", 3, "/beekeeper labs/crossfire", "longest shared substring");
        jComponent.setInputVerifier(new NumberVerifier("shared substring", true, false, 1.0, 2.147483647E9));
        JComponent jComponent2 = new PersistentTextField("3", 3, "/beekeeper labs/crossfire", "candidate quality");
        jComponent2.setInputVerifier(new NumberVerifier("candidate quality", true, false, 0.0, 5.0));
        JComponent jComponent3 = new JSlider(0, 100, fillQuality);
        Serializable serializable3 = new Hashtable<Integer, JLabel>();
        ((Dictionary)((Object)serializable3)).put(0, new JLabel("Speed"));
        ((Dictionary)((Object)serializable3)).put(100, new JLabel("Quality"));
        ((Dictionary)((Object)serializable3)).put(42, new JLabel("Default"));
        jComponent3.setLabelTable((Dictionary)((Object)serializable3));
        jComponent3.setPaintLabels(true);
        JSlider jSlider = jComponent3;
        jSlider.addChangeListener(changeEvent -> CCConfig.getPrefs().putInt("fill quality", jSlider.getValue()));
        GridHelper gridHelper = new GridHelper((Container)serializable2);
        gridHelper.space().stretch().space().advance();
        gridHelper.size(3, 1).add(new GUIUtil.DialogHeaderLabel("Fill Settings")).advance(30);
        gridHelper.add(new GUIUtil.RightLabel("Min fill word score: ")).add(persistentTextField).advance();
        gridHelper.add(new GUIUtil.RightLabel("Longest shared substring: ")).add(jComponent).advance();
        gridHelper.add(new GUIUtil.RightLabel("Candidate ranking quality (0-5, default=3): ")).add(jComponent2).advance().advance(20);
        gridHelper.advance(10);
        gridHelper.size(3, 1).add(new JSeparator()).advance();
        gridHelper.advance(10);
        gridHelper.size(3, 1).add(new GUIUtil.DialogHeaderLabel("Speed/Quality tradeoff")).advance();
        gridHelper.size(3, 1).add(jComponent3).advance();
        gridHelper.advance(0, 1.0);
        ((JComponent)serializable2).setBorder(BorderFactory.createEmptyBorder(5, 15, 15, 15));
        JPanel jPanel = serializable2;
        this.dictPanel = this.createDictPanel();
        serializable2 = new JPanel();
        persistentTextField = new PersistentTextField("", 40, "/beekeeper labs/crossfire", "clue file");
        jComponent = new PersistentCheckBox("Show word numbers in grid.", false, "/beekeeper labs/crossfire", "show numbers");
        jComponent2 = new PersistentCheckBox("Auto-add complete cross words.", false, "/beekeeper labs/crossfire", "auto enter complete");
        jComponent3 = new PersistentCheckBox("Auto-select definitions when in clue tab.", true, "/beekeeper labs/crossfire", "auto select clues");
        serializable3 = new PersistentTextField("http://www.google.com/search?&q=%s", 3, "/beekeeper labs/crossfire", "web lookup url");
        gridHelper = new GridHelper((Container)serializable2);
        gridHelper.space().stretch().space().advance();
        gridHelper.size(3, 1).add(new GUIUtil.DialogHeaderLabel("General Configuration")).advance(30);
        gridHelper.add(new GUIUtil.RightLabel("Web lookup URL: ")).add((Component)serializable3).advance();
        gridHelper.add(new GUIUtil.RightLabel("Clue database file (optional): ")).add(new FileEntryField(persistentTextField, false, "'cluedata' file", new String[0])).advance();
        gridHelper.advance(10);
        gridHelper.size(3, 1).add(new JSeparator()).advance();
        gridHelper.advance(10);
        gridHelper.size(2, 1).add(jComponent3).advance();
        gridHelper.size(2, 1).add(jComponent).advance();
        gridHelper.size(2, 1).add(jComponent2).advance();
        gridHelper.advance(0, 1.0);
        ((JComponent)serializable2).setBorder(BorderFactory.createEmptyBorder(5, 15, 15, 15));
        ((JTabbedPane)component).add("Fill", jPanel);
        ((JTabbedPane)component).add("Dictionary", this.dictPanel);
        ((JTabbedPane)component).add("General", (Component)serializable2);
        jPanel = new JPanel();
        serializable2 = new GridHelper(jPanel);
        ((GridHelper)serializable2).stretch().advance();
        ((GridHelper)serializable2).weight(1.0, 1.0).add(component).advance(1);
        ((GridHelper)serializable2).advance(10);
        component = GUIUtil.createButtonBox(GUIUtil.makeButton("OK", serializable -> {
            serializable = this;
            Object object = CCConfig.getPrefs();
            if ((object = ((Preferences)object).get("dict file list", null)) != null && ((String)object).length() == 0) {
                JOptionPane.showMessageDialog(((CCConfig)serializable).dictPanel, "At least one dictionary required.", "Dictionary required.", 0);
                return;
            }
            ((CCConfig)serializable).cancelled = false;
            CCConfig.initValues();
            ((Window)((Object)serializable)).dispose();
        }), GUIUtil.makeButton("Cancel", object -> {
            object = this;
            ((Window)((Object)object)).dispose();
            object = CCConfig.getPrefs();
            ((Preferences)((Object)object)).put("clue file", clueFile);
            ((Preferences)((Object)object)).putInt("min autofill score", minAutoScore);
            ((Preferences)((Object)object)).putInt("longest shared substring", longestSubstring);
            ((Preferences)((Object)object)).putInt("candidate quality", candidateQuality);
            ((Preferences)((Object)object)).putInt("fill quality", fillQuality);
            ((Preferences)((Object)object)).putBoolean("auto enter complete", autoEnterComplete);
            ((Preferences)((Object)object)).putBoolean("auto select clues", autoSelectClues);
            ((Preferences)((Object)object)).putBoolean("show numbers", showNumbers);
            ((Preferences)((Object)object)).put("web lookup url", webLookupURL);
            ((Preferences)((Object)object)).put("dict file list", rawDictList);
            ((Preferences)((Object)object)).put("preserved chars", preservedChars);
        }));
        ((JComponent)component).setBorder(BorderFactory.createEmptyBorder(0, 15, 0, 15));
        ((GridHelper)serializable2).add(component).advance();
        ((GridHelper)serializable2).advance(10);
        this.getContentPane().add(jPanel);
        jPanel.registerKeyboardAction(object -> {
            object = this;
            ((Window)((Object)object)).dispose();
            object = CCConfig.getPrefs();
            ((Preferences)((Object)object)).put("clue file", clueFile);
            ((Preferences)((Object)object)).putInt("min autofill score", minAutoScore);
            ((Preferences)((Object)object)).putInt("longest shared substring", longestSubstring);
            ((Preferences)((Object)object)).putInt("candidate quality", candidateQuality);
            ((Preferences)((Object)object)).putInt("fill quality", fillQuality);
            ((Preferences)((Object)object)).putBoolean("auto enter complete", autoEnterComplete);
            ((Preferences)((Object)object)).putBoolean("auto select clues", autoSelectClues);
            ((Preferences)((Object)object)).putBoolean("show numbers", showNumbers);
            ((Preferences)((Object)object)).put("web lookup url", webLookupURL);
            ((Preferences)((Object)object)).put("dict file list", rawDictList);
            ((Preferences)((Object)object)).put("preserved chars", preservedChars);
        }, SystemUtil.makeShortcut("ESCAPE"), 2);
        this.setDefaultCloseOperation(2);
        this.pack();
    }

    private int getPrimaryIndex() {
        int n = this.dictionaries.size();
        for (int i = 0; i < n; ++i) {
            if (!this.dictionaries.get((int)i).isPrimary) continue;
            return i;
        }
        return -1;
    }

    private void updateDictRegistry() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.dictionaries.size(); ++i) {
            DictFileInfo dictFileInfo = this.dictionaries.get(i);
            if (i > 0) {
                stringBuilder.append(System.getProperty("path.separator"));
            }
            stringBuilder.append((char)(dictFileInfo.isPrimary ? 42 : (dictFileInfo.isSelected ? 43 : 45)));
            stringBuilder.append(dictFileInfo.file.getAbsolutePath());
        }
        CCConfig.getPrefs().put("dict file list", stringBuilder.toString());
    }

    private void updateDictFiles(int[] nArray) {
        if (this.dictPanel != null && this.dictPanel.isVisible()) {
            this.dictPanel.requestFocusInWindow();
        }
        MyTableModel myTableModel = this.dictModel;
        myTableModel.fireTableDataChanged();
        if (nArray != null) {
            this.setTableSelection(nArray);
        }
        this.updateDictRegistry();
    }

    private void chooseNewPrimaryDict() {
        if (this.dictionaries.isEmpty()) {
            return;
        }
        for (DictFileInfo dictFileInfo : this.dictionaries) {
            if (!dictFileInfo.isSelected) continue;
            dictFileInfo.isPrimary = true;
            return;
        }
        this.dictionaries.get((int)0).isPrimary = true;
        this.dictionaries.get((int)0).isSelected = true;
    }

    private JPanel createDictPanel() {
        Object object;
        Object object2;
        Object object3;
        Object object4 = System.getProperty("path.separator");
        String[] stringArray = rawDictList.split((String)object4);
        object4 = stringArray;
        object4 = stringArray;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            object3 = object4[i];
            if (((String)object3).length() == 0) continue;
            object2 = new DictFileInfo(this);
            char c = ((String)object3).charAt(0);
            object = ((String)object3).substring(1);
            ((DictFileInfo)object2).file = new File((String)object).getAbsoluteFile();
            ((DictFileInfo)object2).simpleName = ((DictFileInfo)object2).file.getName();
            ((DictFileInfo)object2).isSelected = c == '+' || c == '*';
            ((DictFileInfo)object2).isPrimary = c == '*';
            this.dictionaries.add((DictFileInfo)object2);
        }
        object4 = new JPanel();
        GridHelper gridHelper = new GridHelper((Container)object4);
        gridHelper.stretch().advance();
        gridHelper.add(new GUIUtil.DialogHeaderLabel("Dictionary Settings")).advance(30);
        JComponent jComponent = new JPanel();
        gridHelper.add(jComponent).advance(0, 1.0);
        jComponent.setBorder(BorderFactory.createTitledBorder("Dictionary files"));
        object3 = new GridHelper(jComponent).fill(1);
        object2 = new JCheckBox();
        ((JComponent)object2).setBorder(BorderFactory.createEmptyBorder());
        this.dictTable.setSizeModels(new JComponent[]{new JLabel("Testing"), object2});
        this.dictTable.setShowGrid(false);
        Serializable serializable2 = new DefaultCellEditor(this, (JCheckBox)object2){
            {
                container = (JCheckBox)this.getComponent();
                ((AbstractButton)container).setHorizontalAlignment(0);
            }

            @Override
            public final boolean shouldSelectCell(EventObject eventObject) {
                return false;
            }
        };
        object = new MyBooleanRenderer(this);
        this.dictTable.setTableHeader(null);
        this.dictTable.getColumnModel().getColumn(1).setCellEditor((TableCellEditor)((Object)serializable2));
        this.dictTable.getColumnModel().getColumn(0).setMaxWidth(13);
        this.dictTable.getColumnModel().getColumn(1).setMaxWidth(((JComponent)object).getPreferredSize().width + 4);
        this.dictTable.setDefaultRenderer(ImageIcon.class, new MyIconRenderer(this));
        this.dictTable.setDefaultRenderer(Boolean.class, (TableCellRenderer)object);
        serializable2.addCellEditorListener(new CellEditorListener(this){
            private /* synthetic */ CCConfig this$0;
            {
                this.this$0 = cCConfig;
            }

            @Override
            public final void editingStopped(ChangeEvent changeEvent) {
                this.this$0.updateDictRegistry();
            }

            @Override
            public final void editingCanceled(ChangeEvent changeEvent) {
            }
        });
        jComponent = GUIUtil.makeButton("Up", serializable -> {
            serializable = this;
            int n = 0;
            int[] nArray = ((CCConfig)serializable).dictTable.getSelectedRows();
            int n2 = nArray.length;
            for (int i = 0; i < n2; ++i) {
                int n3 = nArray[i];
                if (n3 - n == 0) {
                    ++n;
                    continue;
                }
                Collections.swap(((CCConfig)serializable).dictionaries, n3 - 1, n3);
                int n4 = i;
                nArray[n4] = nArray[n4] - 1;
            }
            ((CCConfig)((Object)serializable)).updateDictFiles(nArray);
        });
        object2 = GUIUtil.makeButton("Down", serializable -> {
            serializable = this;
            int n = 1;
            int[] nArray = ((CCConfig)serializable).dictTable.getSelectedRows();
            for (int i = nArray.length - 1; i >= 0; --i) {
                int n2 = nArray[i];
                if (n2 + n == ((CCConfig)serializable).dictionaries.size()) {
                    ++n;
                    continue;
                }
                Collections.swap(((CCConfig)serializable).dictionaries, n2 + 1, n2);
                int n3 = i;
                nArray[n3] = nArray[n3] + 1;
            }
            ((CCConfig)((Object)serializable)).updateDictFiles(nArray);
        });
        serializable2 = GUIUtil.makeButton("Delete", serializable -> {
            serializable = this;
            int[] nArray = ((CCConfig)serializable).dictTable.getSelectedRows();
            boolean bl = false;
            for (int i = nArray.length - 1; i >= 0; --i) {
                int n = nArray[i];
                if (((CCConfig)serializable).dictionaries.get((int)n).isPrimary) {
                    bl = true;
                }
                ((CCConfig)serializable).dictionaries.remove(n);
            }
            if (bl) {
                ((CCConfig)((Object)serializable)).chooseNewPrimaryDict();
            }
            ((CCConfig)((Object)serializable)).updateDictFiles(null);
        });
        object = GUIUtil.makeButton("Make primary", serializable -> {
            serializable = this;
            int n = ((CCConfig)serializable).dictTable.getSelectedRow();
            if (n != -1) {
                int n2 = ((CCConfig)((Object)serializable)).getPrimaryIndex();
                if (n2 != -1) {
                    ((CCConfig)serializable).dictionaries.get((int)n2).isPrimary = false;
                }
                ((CCConfig)serializable).dictionaries.get((int)n).isPrimary = true;
                ((CCConfig)serializable).dictionaries.get((int)n).isSelected = true;
                ((CCConfig)((Object)serializable)).updateDictFiles(new int[]{n});
            }
        });
        Object object5 = new ListSelectionListener(){
            private /* synthetic */ JButton val$mDelButton;
            private /* synthetic */ JButton val$mUpButton;
            private /* synthetic */ JButton val$mDownButton;
            private /* synthetic */ JButton val$mPrimaryButton;
            private /* synthetic */ CCConfig this$0;
            {
                this.this$0 = cCConfig;
                this.val$mDelButton = jButton;
                this.val$mUpButton = jButton2;
                this.val$mDownButton = jButton3;
                this.val$mPrimaryButton = jButton4;
            }

            @Override
            public final void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                int n = this.this$0.dictTable.getSelectedRowCount();
                this.val$mDelButton.setEnabled(n > 0);
                this.val$mUpButton.setEnabled(n > 0);
                this.val$mDownButton.setEnabled(n > 0);
                this.val$mPrimaryButton.setEnabled(n == 1);
            }
        };
        object5.valueChanged(new ListSelectionEvent(this.dictTable, 0, 0, false));
        this.dictTable.getSelectionModel().addListSelectionListener((ListSelectionListener)object5);
        object5 = new JScrollPane(this.dictTable);
        ((JComponent)object5).setPreferredSize(new Dimension(100, 200));
        this.dictTable.setBackground(Color.WHITE);
        ((JScrollPane)object5).getViewport().setOpaque(true);
        ((JScrollPane)object5).getViewport().setBackground(Color.WHITE);
        Object object6 = object5;
        ((JComponent)object6).setBorder(BorderFactory.createCompoundBorder(((JComponent)object6).getBorder(), new EmptyBorder(3, 3, 3, 3)));
        ((GridHelper)object3).stretch().advance();
        ((GridHelper)object3).size(1, 40).add((Component)object5).advance(0, 1.0);
        ((GridHelper)object3).space().add(GUIUtil.makeButton("Add", arg_0 -> this.lambda$createDictPanel$10((JPanel)object4, arg_0))).advance();
        ((GridHelper)object3).space().add((Component)serializable2).advance().advance(8);
        ((GridHelper)object3).space().add(jComponent).advance();
        ((GridHelper)object3).space().add((Component)object2).advance().advance(8);
        ((GridHelper)object3).space().add((Component)object).advance();
        if (this.getPrimaryIndex() == -1) {
            this.chooseNewPrimaryDict();
        }
        this.updateDictFiles(null);
        gridHelper.advance(5);
        jComponent = new JPanel();
        object3 = new GridHelper(jComponent);
        jComponent.setBorder(BorderFactory.createTitledBorder("Preserve special/accented chars"));
        object2 = this;
        object2 = GUIUtil.makeButton("Change", new ActionListener((CCConfig)object2){
            private /* synthetic */ CCConfig this$0;
            {
                this.this$0 = cCConfig;
            }

            @Override
            public final void actionPerformed(ActionEvent serializable) {
                int n;
                serializable = new JPanel();
                GridHelper gridHelper = new GridHelper((Container)serializable);
                int n2 = 60;
                JCheckBox[] jCheckBoxArray = new JCheckBox[60];
                BitSet bitSet = new BitSet(256);
                Object object = CCConfig.getPreservedChars();
                int n3 = ((String)object).length();
                for (n = 0; n < n3; ++n) {
                    bitSet.set(((String)object).charAt(n));
                }
                for (n = 0; n < n2; ++n) {
                    int n4 = n;
                    jCheckBoxArray[n] = object = new JCheckBox("\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u00ff,.?!;:~@#$%^&|_=-+*/\\`'\"<>()[]{}".substring(n4, n4 + 1));
                    if (bitSet.get("\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u00ff,.?!;:~@#$%^&|_=-+*/\\`'\"<>()[]{}".charAt(n))) {
                        ((AbstractButton)object).setSelected(true);
                    }
                    gridHelper.add((Component)object);
                    if (n % 4 == 3) {
                        gridHelper.advance();
                        continue;
                    }
                    gridHelper.space(20);
                }
                gridHelper.advance().advance(10);
                ActionListener actionListener = arg_0 -> 5.lambda$actionPerformed$0((JPanel)serializable, arg_0);
                gridHelper.size(5, 1).add(GUIUtil.createButtonBox(GUIUtil.makeButton("OK", arg_0 -> this.lambda$actionPerformed$1((JPanel)serializable, jCheckBoxArray, arg_0)), GUIUtil.makeButton("Cancel", actionListener)));
                GUIUtil.showInDialog(this.this$0.preserveLabel, "Preserve dictionary characters", (Component)serializable, actionListener, false);
            }

            private /* synthetic */ void lambda$actionPerformed$1(JPanel jPanel, JCheckBox[] jCheckBoxArray, ActionEvent actionEvent) {
                this.this$0.doPreserveOk(jPanel, jCheckBoxArray);
            }

            private static /* synthetic */ void lambda$actionPerformed$0(JPanel jPanel, ActionEvent actionEvent) {
                jPanel.setVisible(false);
            }
        });
        this.showPreserveChars();
        ((GridHelper)object3).add((Component)object2).space(5).add(this.preserveLabel).stretch();
        gridHelper.add(jComponent).advance();
        ((JComponent)object4).setBorder(BorderFactory.createEmptyBorder(5, 15, 15, 15));
        return object4;
    }

    private void setTableSelection(int[] nArray) {
        ListSelectionModel listSelectionModel = this.dictTable.getSelectionModel();
        listSelectionModel.clearSelection();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = n2 = nArray[i];
            listSelectionModel.addSelectionInterval(n3, n3);
        }
    }

    private void doPreserveOk(JPanel jPanel, JCheckBox[] jCheckBoxArray) {
        int n = 0;
        int n2 = jCheckBoxArray.length;
        for (int i = 0; i < n2; ++i) {
            if (!jCheckBoxArray[i].isSelected()) continue;
            ++n;
        }
        char[] cArray = new char[n];
        n2 = 0;
        int n3 = jCheckBoxArray.length;
        for (n = 0; n < n3; ++n) {
            if (!jCheckBoxArray[n].isSelected()) continue;
            cArray[n2++] = "\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u00ff,.?!;:~@#$%^&|_=-+*/\\`'\"<>()[]{}".charAt(n);
        }
        CCConfig.getPrefs().put("preserved chars", new String(cArray));
        this.showPreserveChars();
        jPanel.setVisible(false);
    }

    private void showPreserveChars() {
        String string = CCConfig.getPrefs().get("preserved chars", "");
        this.preserveLabel.setText(string);
    }

    public static String getPreservedChars() {
        return preservedChars;
    }

    public static void setPreservedChars(String string) {
        CCConfig.getPrefs().put("preserved chars", string);
        preservedChars = string;
    }

    public static String getRawDictionaries() {
        return rawDictList;
    }

    public static void setRawDictionaries(String string) {
        CCConfig.getPrefs().put("dict file", string);
        rawDictList = string;
    }

    private static Preferences getPrefs() {
        return Preferences.userRoot().node("/beekeeper labs/crossfire");
    }

    public static boolean getConfiguredOnce() {
        return CCConfig.getPrefs().getBoolean("configured once", false);
    }

    public static void setConfiguredOnce(boolean bl) {
        CCConfig.getPrefs().putBoolean("configured once", true);
    }

    public static int getCandidateQuality() {
        return candidateQuality;
    }

    public static String getClueFile() {
        return clueFile;
    }

    public static String getWebLookupURL() {
        return webLookupURL;
    }

    public static boolean getShowWordNumbers() {
        return showNumbers;
    }

    public static boolean getAutoEnterComplete() {
        return autoEnterComplete;
    }

    public static boolean getAutoSelectClues() {
        return autoSelectClues;
    }

    public static int getMinAutoScore() {
        return minAutoScore;
    }

    public static int getLongestSubstring() {
        return longestSubstring;
    }

    public static boolean showDialog(Component component) {
        component = new CCConfig(component);
        ((Dialog)component).setVisible(true);
        return !((CCConfig)component).cancelled;
    }

    public static int getOptWidth() {
        return (int)(Math.pow(2.0, (double)fillQuality / 100.0 * 8.0) + 0.5);
    }

    private /* synthetic */ void lambda$createDictPanel$10(JPanel container, ActionEvent serializable) {
        container = this;
        serializable = new JDialog(JOptionPane.getFrameForComponent(((CCConfig)container).dictPanel), "New dictionary", true);
        JPanel jPanel = new JPanel();
        FileEntryField fileEntryField = new FileEntryField("", false, "Dictionaries", "dict", "txt");
        Vector<Object> vector = new Vector<Object>(((CCConfig)container).dictionaries.size() + 1);
        for (DictFileInfo object2 : ((CCConfig)container).dictionaries) {
            vector.add("Before " + object2.simpleName);
        }
        vector.add("End of list");
        JComboBox jComboBox = new JComboBox(vector);
        jComboBox.setSelectedIndex(vector.size() - 1);
        GridHelper gridHelper = new GridHelper(jPanel);
        gridHelper.space().stretch().advance();
        gridHelper.add(new GUIUtil.RightLabel("Dictionary file: ")).add(fileEntryField).advance();
        gridHelper.add(new GUIUtil.RightLabel("Position: ")).add(jComboBox).advance();
        gridHelper.advance(15);
        gridHelper.size(2, 1).add(GUIUtil.createButtonBox(GUIUtil.makeButton("Cancel", arg_0 -> CCConfig.lambda$doAddDict$3((JDialog)serializable, arg_0)), GUIUtil.makeButton("OK", arg_0 -> ((CCConfig)container).lambda$doAddDict$4((JDialog)serializable, fileEntryField, jComboBox, arg_0)))).advance();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        ((JDialog)serializable).getContentPane().add(jPanel);
        jPanel.registerKeyboardAction(arg_0 -> CCConfig.lambda$doAddDict$3((JDialog)serializable, arg_0), SystemUtil.makeShortcut("ESCAPE"), 2);
        ((JDialog)serializable).setDefaultCloseOperation(2);
        GUIUtil.packDialog((JDialog)serializable, ((CCConfig)container).dictPanel, false);
        ((Dialog)serializable).setVisible(true);
    }

    private /* synthetic */ void lambda$doAddDict$4(JDialog jDialog, FileEntryField container, JComboBox object, ActionEvent actionEvent) {
        int n = ((JComboBox)object).getSelectedIndex();
        object = ((FileEntryField)container).getText();
        container = jDialog;
        jDialog = this;
        if (((String)object).length() != 0) {
            DictFileInfo dictFileInfo = new DictFileInfo((CCConfig)jDialog);
            new DictFileInfo((CCConfig)jDialog).file = new File((String)object).getAbsoluteFile();
            dictFileInfo.simpleName = dictFileInfo.file.getName();
            dictFileInfo.isSelected = true;
            if (((CCConfig)jDialog).dictionaries.isEmpty()) {
                dictFileInfo.isPrimary = true;
            }
            ((CCConfig)jDialog).dictionaries.add(n, dictFileInfo);
            ((CCConfig)jDialog).updateDictFiles(null);
            ((Window)container).dispose();
        }
    }

    private static /* synthetic */ void lambda$doAddDict$3(JDialog jDialog, ActionEvent actionEvent) {
        jDialog.dispose();
    }

    static {
        CCConfig.initValues();
        checkIcon = new DPIUtil.ImageIcon(CCRebusPanel.class.getResource("resources/icon-check.png"));
        huhIcon = new DPIUtil.ImageIcon(CCRebusPanel.class.getResource("resources/icon-huh.png"));
    }

    final class MyTableModel
    extends AbstractTableModel {
        private /* synthetic */ CCConfig this$0;

        private MyTableModel(CCConfig cCConfig) {
            this.this$0 = cCConfig;
        }

        @Override
        public final int getColumnCount() {
            return 3;
        }

        @Override
        public final int getRowCount() {
            return this.this$0.dictionaries.size();
        }

        @Override
        public final void setValueAt(Object object, int n, int n2) {
            if (n2 == 1) {
                this.this$0.dictionaries.get((int)n).isSelected = (Boolean)object;
            }
        }

        @Override
        public final Class<?> getColumnClass(int n) {
            return this.this$0.COLUMN_CLASSES[n];
        }

        @Override
        public final boolean isCellEditable(int n, int n2) {
            return n2 == 1 && !this.this$0.dictionaries.get((int)n).isPrimary;
        }

        @Override
        public final Object getValueAt(int n, int n2) {
            DictFileInfo dictFileInfo = this.this$0.dictionaries.get(n);
            switch (n2) {
                case 0: {
                    if (dictFileInfo.file.exists()) {
                        return checkIcon;
                    }
                    return huhIcon;
                }
                case 1: {
                    return dictFileInfo.isSelected;
                }
                case 2: {
                    if (!dictFileInfo.isPrimary) {
                        return dictFileInfo.simpleName;
                    }
                    return "<HTML><B><I>" + dictFileInfo.simpleName + "</I></B></HTML>";
                }
            }
            return null;
        }
    }

    final class DictFileInfo {
        public File file;
        public String simpleName;
        public boolean isSelected;
        public boolean isPrimary;

        private DictFileInfo(CCConfig cCConfig) {
        }

        public final String toString() {
            return this.simpleName;
        }
    }

    public final class MyBooleanRenderer
    extends JCheckBox
    implements TableCellRenderer {
        public MyBooleanRenderer(CCConfig cCConfig) {
            this.setHorizontalAlignment(0);
        }

        @Override
        public final Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setSelected((Boolean)object);
            return this;
        }

        @Override
        public final boolean isOpaque() {
            return false;
        }
    }

    public final class MyIconRenderer
    extends DefaultTableCellRenderer {
        @Override
        public final Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return super.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
        }

        public MyIconRenderer(CCConfig cCConfig) {
            this.setHorizontalAlignment(0);
        }

        @Override
        public final void setValue(Object object) {
            this.setIcon(object instanceof Icon ? (Icon)object : null);
        }

        @Override
        public final boolean isOpaque() {
            return false;
        }
    }
}

