/*
 * Decompiled with CFR 0.152.
 */
package com.beekeeper.xwd;

import com.beekeeper.util.CompatibilityUtil;
import com.beekeeper.util.GUIUtil;
import com.beekeeper.util.GridHelper;
import com.beekeeper.xwd.CCConfig;
import com.beekeeper.xwd.ClueData;
import com.beekeeper.xwd.ClueListPanel;
import com.beekeeper.xwd.CrossFire;
import com.beekeeper.xwd.GridState;
import com.beekeeper.xwd.WordGrid;
import com.beekeeper.xwd.WordList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.DefaultCaret;
import javax.swing.text.JTextComponent;

public final class CCCluePanel
extends JPanel {
    protected boolean fullyShowing;
    protected int lastChanged;
    boolean roboFocusing;
    private Thread clueThread = new Thread("Clue update thread"){

        @Override
        public final void run() {
            String string = null;
            while (true) {
                int n;
                int n2;
                Object object;
                CCCluePanel cCCluePanel = CCCluePanel.this;
                synchronized (cCCluePanel) {
                    while (true) {
                        object = CCCluePanel.this.cc.getClueData();
                        n2 = CCCluePanel.this.cc.getDisplay().getSelectedWord();
                        String string2 = n2 == -1 ? null : CCCluePanel.this.cc.getDisplay().getState().getString(n2);
                        boolean bl = CCCluePanel.this.currentClues != null && object != null && !Objects.equals(string, string2);
                        n = n2;
                        string = string2;
                        if (bl) break;
                        try {
                            CCCluePanel.this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                int n3 = -1;
                for (n2 = 0; n2 < CCCluePanel.this.currentClues.length; ++n2) {
                    if (CCCluePanel.this.currentWords[n2].getWordIndex() != n) continue;
                    n3 = n2;
                    break;
                }
                if (n3 != -1) {
                    n2 = n;
                    int n4 = n3;
                    String string3 = CCCluePanel.this.cc.getDisplay().getState().getString(n2);
                    Object object2 = CCCluePanel.this.cc.getWordList().getOrigWord(string3);
                    object2 = new ClueListPanel(this, (String)object2, (ClueData)object, n4, n2){
                        private /* synthetic */ int val$clue;
                        private /* synthetic */ int val$index;
                        private /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$clue = n;
                            this.val$index = n2;
                            super(string, clueData);
                        }

                        @Override
                        protected final void clueClicked(String string) {
                            this.this$1.CCCluePanel.this.currentClues[this.val$clue].setText(string);
                            this.this$1.CCCluePanel.this.currentClues[(this.val$clue + 1) % this.this$1.CCCluePanel.this.currentClues.length].requestFocusInWindow();
                            GridState gridState = this.this$1.CCCluePanel.this.cc.getDisplay().getState();
                            String string2 = gridState.getClue(this.val$index);
                            if (this.val$clue != this.this$1.CCCluePanel.this.lastChanged && !string.equals(string2)) {
                                this.this$1.CCCluePanel.this.cc.pushUndo();
                                this.this$1.CCCluePanel.this.cc.cloneState();
                                gridState = this.this$1.CCCluePanel.this.cc.getDisplay().getState();
                                this.this$1.CCCluePanel.this.lastChanged = this.val$clue;
                            }
                            gridState.setClue(this.val$index, string);
                            this.this$1.CCCluePanel.this.updateClueCount(gridState);
                        }
                    };
                    object2 = new JScrollPane((Component)object2);
                    ((JScrollPane)object2).getViewport().setBackground(Color.white);
                    ((JComponent)object2).setPreferredSize(new Dimension(10, 10));
                    object = CCCluePanel.this;
                    synchronized (object) {
                        if (CCCluePanel.this.cc.getDisplay().getSelectedWord() == n2) {
                            CCCluePanel.this.cluePanel.removeAll();
                            CCCluePanel.this.cluePanel.add((Component)object2, "Center");
                            ((Container)object2).invalidate();
                            CCCluePanel.this.cluePanel.validate();
                            CCCluePanel.this.cluePanel.repaint();
                            CCCluePanel.this.cluePanel.setVisible(true);
                        }
                    }
                } else {
                    CCCluePanel.this.cluePanel.removeAll();
                    CCCluePanel.this.cluePanel.validate();
                    CCCluePanel.this.cluePanel.repaint();
                    CCCluePanel.this.cluePanel.setVisible(true);
                }
                CCCluePanel.this.updateClueVisibility();
            }
        }
    };
    private final CrossFire cc;
    private final JPanel wordPanel;
    private WordGrid currentGrid;
    private WordGrid.Word[] currentWords;
    private JLabel[] currentOrigs;
    private JTextArea[] currentClues;
    private final JPanel cluePanel;
    private final JSplitPane split;
    private final Runnable gridSelectionListener;
    private int currentSelection;
    private GUIUtil.RightLabel[] currentNums;
    private final JLabel uncluedLabel;

    private synchronized void doUpdate() {
        this.lastChanged = -1;
        if (!this.isShowing()) {
            return;
        }
        Object object = this.cc.getDisplay().getState();
        this.updateClueCount((GridState)object);
        JLabel[] jLabelArray = ((GridState)object).getGrid();
        Font font = UIManager.getDefaults().getFont("Label.font");
        Font font2 = font.deriveFont(1);
        if (jLabelArray != this.currentGrid) {
            int n;
            Serializable serializable;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            this.currentGrid = jLabelArray;
            this.currentSelection = -1;
            int n2 = jLabelArray.getWordCount();
            this.currentWords = new WordGrid.Word[n2];
            for (int i = 0; i < n2; ++i) {
                this.currentWords[i] = jLabelArray.getWord(i);
            }
            Arrays.sort(this.currentWords);
            this.currentOrigs = new JLabel[n2];
            this.currentClues = new JTextArea[n2];
            this.currentNums = new GUIUtil.RightLabel[n2];
            GUIUtil.RightLabel[] rightLabelArray = new GUIUtil.RightLabel[n2];
            jLabelArray = new JLabel[n2];
            JTextArea[] jTextAreaArray = new JTextArea[n2];
            boolean bl = !CompatibilityUtil.HAS_1_6_FEATURES;
            int n3 = 0;
            int n4 = 0;
            for (int i = 0; i < n2; ++i) {
                object5 = this.currentWords[i];
                int n5 = ((WordGrid.Word)object5).getWordIndex();
                object4 = ((GridState)object).getDebugString(n5);
                object3 = new MouseAdapter(this, (String)object4){
                    private /* synthetic */ String val$rawWord;
                    private /* synthetic */ CCCluePanel this$0;
                    {
                        this.this$0 = cCCluePanel;
                        this.val$rawWord = string;
                    }

                    @Override
                    public final void mousePressed(MouseEvent mouseEvent) {
                        if (mouseEvent.isPopupTrigger()) {
                            this.this$0.doPopupMenu(mouseEvent, this.val$rawWord);
                        }
                    }

                    @Override
                    public final void mouseReleased(MouseEvent mouseEvent) {
                        if (mouseEvent.isPopupTrigger()) {
                            this.this$0.doPopupMenu(mouseEvent, this.val$rawWord);
                        }
                    }
                };
                object2 = new RefocusListener(this, i);
                serializable = new GUIUtil.RightLabel(" " + ((WordGrid.Word)object5).getPrintNumber() + ". ");
                ((Component)serializable).addMouseListener((MouseListener)object2);
                ((JComponent)serializable).setBackground(Color.white);
                ((JComponent)serializable).setOpaque(true);
                if (bl) {
                    n3 = Math.max(n3, ((JComponent)serializable).getMinimumSize().width);
                }
                rightLabelArray[i] = serializable;
                object4 = new JLabel(this.cc.getWordList().getOrigWord((String)object4));
                ((Component)object4).addMouseListener((MouseListener)object2);
                ((JComponent)object4).setBackground(Color.white);
                ((JComponent)object4).setOpaque(true);
                if (((GridState)object).isTheme(n5)) {
                    ((JComponent)object4).setFont(font2);
                }
                if (bl) {
                    n4 = Math.max(n4, ((JComponent)object4).getMinimumSize().width);
                }
                jLabelArray[i] = object4;
                object2 = new MyTextArea(((GridState)object).getClue(n5), font, i);
                ((Component)serializable).addMouseListener((MouseListener)object3);
                ((Component)object4).addMouseListener((MouseListener)object3);
                ((Component)object2).addMouseListener((MouseListener)object3);
                jTextAreaArray[i] = object2;
                this.currentOrigs[i] = object4;
                this.currentClues[i] = object2;
                this.currentNums[i] = serializable;
            }
            SPanel sPanel = new SPanel();
            sPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            sPanel.setBackground(Color.white);
            object5 = new GridHelper(sPanel).anchor(CompatibilityUtil.GRID_BASELINE);
            Box box = Box.createVerticalBox();
            object4 = new JLabel("<html><b>Across</b></html>", 2);
            if (bl) {
                sPanel.setLayout(new BorderLayout());
                sPanel.add((Component)box, "Center");
                object3 = new GridHelper();
                ((GridHelper)object3).add((Component)object4).stretch();
                box.add(((GridHelper)object3).getContainer());
            } else {
                object5 = ((GridHelper)object5).space().space().space(5).stretch().advance();
                ((GridHelper)object5).size(4, 1).add((Component)object4).advance();
            }
            for (n = 0; n < n2 && ((WordGrid.Word)(object2 = this.currentWords[n])).getDirection() == 0; ++n) {
                serializable = rightLabelArray[n];
                object4 = jLabelArray[n];
                object2 = jTextAreaArray[n];
                if (bl) {
                    object = new GridHelper().anchor(12).fill(2).anchor(CompatibilityUtil.GRID_BASELINE);
                    ((GridHelper)object).space(n3).space(n4).space(5).stretch().advance();
                    ((GridHelper)object).add((Component)serializable).add((Component)object4).space().add((Component)object2).advance();
                    box.add(((GridHelper)object).getContainer());
                    continue;
                }
                ((GridHelper)object5).fill(2).add((Component)serializable);
                ((GridHelper)object5).fill(2).add((Component)object4);
                ((GridHelper)object5).space();
                ((GridHelper)object5).add((Component)object2).advance();
            }
            object2 = new JLabel("<html><b>Down</b></html>", 2);
            if (bl) {
                box.add(Box.createVerticalStrut(15));
                serializable = new GridHelper();
                ((GridHelper)serializable).add((Component)object2).stretch();
                box.add(((GridHelper)serializable).getContainer());
            } else {
                ((GridHelper)object5).advance(15);
                ((GridHelper)object5).size(4, 1).add((Component)object2).advance();
            }
            while (n < n2) {
                serializable = rightLabelArray[n];
                object4 = jLabelArray[n];
                object2 = jTextAreaArray[n];
                if (bl) {
                    object = new GridHelper();
                    ((GridHelper)object).space(n3).space(n4).space(5).stretch().advance();
                    ((GridHelper)object).add((Component)serializable).add((Component)object4).space().add((Component)object2).advance();
                    box.add(((GridHelper)object).getContainer());
                } else {
                    ((GridHelper)object5).fill(2).add((Component)serializable);
                    ((GridHelper)object5).fill(2).add((Component)object4);
                    ((GridHelper)object5).space();
                    ((GridHelper)object5).add((Component)object2).advance();
                }
                ++n;
            }
            if (bl) {
                box.add(Box.createVerticalGlue());
            } else {
                ((GridHelper)object5).advance(0, 1.0);
            }
            serializable = new JScrollPane(sPanel);
            ((JComponent)serializable).setPreferredSize(new Dimension(10, 10));
            this.wordPanel.removeAll();
            this.wordPanel.add((Component)serializable, "Center");
            ((Container)serializable).invalidate();
            this.wordPanel.validate();
            this.wordPanel.repaint();
            return;
        }
        for (int i = 0; i < this.currentWords.length; ++i) {
            WordGrid.Word word = this.currentWords[i];
            int n = word.getWordIndex();
            this.currentOrigs[i].setText(this.cc.getWordList().getOrigWord(((GridState)object).getDebugString(n)));
            this.currentOrigs[i].setFont(((GridState)object).isTheme(n) ? font2 : font);
            this.currentClues[i].setText(((GridState)object).getClue(n));
        }
    }

    private void updateClueCount(GridState gridState) {
        this.uncluedLabel.setText((gridState == null ? 0 : gridState.countUncluedWords()) + " unclued words.");
    }

    private void updateClueVisibility() {
        ClueData clueData = this.cc.getClueData();
        this.cluePanel.setVisible(clueData != null);
        this.split.setDividerSize(clueData != null ? 9 : 0);
    }

    protected final void doPopupMenu(MouseEvent mouseEvent, String object) {
        object = this.cc.createWordPopup(this, (String)object);
        ((JPopupMenu)object).show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    public final synchronized void showSelection(int n, boolean bl) {
        int n2 = this.currentWords.length;
        for (int i = 0; i < n2; ++i) {
            if (this.currentWords[i].getWordIndex() != n) continue;
            JTextArea jTextArea = this.currentClues[i];
            if (this.currentSelection != i) {
                if (this.currentSelection != -1) {
                    this.currentOrigs[this.currentSelection].setBackground(Color.white);
                    this.currentNums[this.currentSelection].setBackground(Color.white);
                }
                this.currentSelection = i;
                if (this.currentSelection != -1) {
                    Color color = new Color(0xDDEEFF);
                    this.currentOrigs[this.currentSelection].setBackground(color);
                    this.currentNums[this.currentSelection].setBackground(color);
                }
            }
            this.ensureSelectionVisible(i);
            if (bl || CCConfig.getAutoSelectClues() && !this.roboFocusing) {
                SwingUtilities.invokeLater(new Runnable(){
                    private /* synthetic */ JTextArea val$cl;
                    {
                        this.val$cl = jTextArea;
                    }

                    @Override
                    public final void run() {
                        this.val$cl.requestFocusInWindow();
                    }
                });
            }
            return;
        }
        if (this.currentSelection != -1) {
            this.currentOrigs[this.currentSelection].setBackground(Color.white);
            this.currentNums[this.currentSelection].setBackground(Color.white);
        }
        this.currentSelection = -1;
    }

    private void ensureSelectionVisible(int n) {
        JTextArea jTextArea = this.currentClues[n];
        Rectangle rectangle = new Rectangle(0, -20, jTextArea.getWidth(), jTextArea.getHeight() + 40);
        jTextArea.scrollRectToVisible(rectangle);
    }

    public CCCluePanel(CrossFire crossFire) {
        String[] stringArray = new String[]{"#", "Word", "Clue"};
        this.cc = crossFire;
        this.clueThread.setDaemon(true);
        this.clueThread.start();
        this.setPreferredSize(new Dimension(10, 10));
        this.uncluedLabel = new JLabel("0 unclued words.");
        this.uncluedLabel.setFont(this.uncluedLabel.getFont().deriveFont(1));
        this.wordPanel = new JPanel(new BorderLayout());
        this.wordPanel.setBorder(BorderFactory.createTitledBorder("Words"));
        this.cluePanel = new JPanel(new BorderLayout());
        this.cluePanel.setBorder(BorderFactory.createTitledBorder("DB"));
        this.cluePanel.setPreferredSize(new Dimension(10, 120));
        this.cluePanel.setMinimumSize(new Dimension(10, 120));
        this.cluePanel.setVisible(true);
        this.split = new JSplitPane(0, this.wordPanel, this.cluePanel);
        this.split.setResizeWeight(1.0);
        this.split.setOneTouchExpandable(true);
        this.split.setDividerSize(9);
        this.split.setContinuousLayout(true);
        this.split.setBorder(null);
        Object object = new GridHelper(this);
        ((GridHelper)object).size(2, 1).stretch().advance();
        ((GridHelper)object).space(5).add(this.uncluedLabel).advance();
        ((GridHelper)object).size(2, 1).add(this.split).advance(0, 1.0);
        object = new Runnable(this){
            private /* synthetic */ CCCluePanel this$0;
            {
                this.this$0 = cCCluePanel;
            }

            @Override
            public final void run() {
                this.this$0.doUpdate();
                CCCluePanel cCCluePanel = this.this$0;
                synchronized (cCCluePanel) {
                    this.this$0.notifyAll();
                    return;
                }
            }
        };
        crossFire.addStateAction((Runnable)object);
        crossFire.getWordMonitor().addListener(new WordList.WordListListener(this, crossFire){
            private /* synthetic */ CrossFire val$cc;
            private /* synthetic */ CCCluePanel this$0;
            {
                this.this$0 = cCCluePanel;
                this.val$cc = crossFire;
            }

            @Override
            public final void spellingChanged(String string, String string2, boolean bl) {
                if (!this.this$0.isShowing()) {
                    return;
                }
                GridState gridState = this.val$cc.getDisplay().getState();
                for (int i = 0; i < this.this$0.currentWords.length; ++i) {
                    String string3 = gridState.getDebugString(this.this$0.currentWords[i].getWordIndex());
                    if (!string.equals(string3)) continue;
                    this.this$0.currentOrigs[i].setText(string2);
                }
            }

            @Override
            public final void wordListChanged() {
                this.this$0.doUpdate();
            }
        });
        this.gridSelectionListener = new Runnable(){
            private /* synthetic */ CrossFire val$cc;
            private /* synthetic */ CCCluePanel this$0;
            {
                this.this$0 = cCCluePanel;
                this.val$cc = crossFire;
            }

            @Override
            public final void run() {
                if (!this.this$0.isShowing()) {
                    return;
                }
                int n = this.val$cc.getDisplay().getSelectedWord();
                this.this$0.showSelection(n, false);
                CCCluePanel cCCluePanel = this.this$0;
                synchronized (cCCluePanel) {
                    this.this$0.notifyAll();
                    return;
                }
            }
        };
        crossFire.getDisplay().addSelectionListener(this.gridSelectionListener);
        this.addComponentListener(new ComponentAdapter(this, crossFire){
            private /* synthetic */ CrossFire val$cc;
            private /* synthetic */ CCCluePanel this$0;
            {
                this.this$0 = cCCluePanel;
                this.val$cc = crossFire;
            }

            @Override
            public final void componentShown(ComponentEvent componentEvent) {
                this.val$cc.getLetterPanel().setVisible(false);
                this.this$0.updateClueVisibility();
                int n = this.val$cc.getDisplay().getSelectedWord();
                this.this$0.doUpdate();
                this.this$0.showSelection(n, false);
                CCCluePanel cCCluePanel = this.this$0;
                synchronized (cCCluePanel) {
                    this.this$0.notifyAll();
                }
                this.this$0.fullyShowing = true;
            }

            @Override
            public final void componentHidden(ComponentEvent componentEvent) {
                this.this$0.fullyShowing = false;
            }
        });
    }

    static {
        String[] stringArray = new String[]{null, "Mo", "Tu", "We", "Th", "Fr", "Sa"};
    }

    public final class RefocusListener
    extends MouseAdapter {
        private final int index;
        private /* synthetic */ CCCluePanel this$0;

        public RefocusListener(CCCluePanel cCCluePanel, int n) {
            this.this$0 = cCCluePanel;
            this.index = n;
        }

        @Override
        public final void mouseClicked(MouseEvent mouseEvent) {
            this.this$0.currentClues[this.index].requestFocusInWindow();
        }
    }

    public final class MyTextArea
    extends JTextArea
    implements ActionListener {
        private final int lineIndex;
        private final ActionListener upAction;
        private final int wordIndex;

        public MyTextArea(String object, Font font, int n) {
            super((String)object, 1, 20);
            this.upAction = new AbstractAction(this, "Move up"){
                private /* synthetic */ MyTextArea this$1;
                {
                    this.this$1 = myTextArea;
                    super(string);
                }

                @Override
                public final void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.CCCluePanel.this.currentClues[(this.this$1.lineIndex + this.this$1.CCCluePanel.this.currentClues.length - 1) % this.this$1.CCCluePanel.this.currentClues.length].requestFocusInWindow();
                }
            };
            object = object == null || ((String)object).length() == 0 ? Color.gray : Color.white;
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0), BorderFactory.createMatteBorder(0, 0, 1, 0, (Color)object)));
            this.lineIndex = n;
            this.wordIndex = CCCluePanel.this.currentWords[n].getWordIndex();
            this.setCaret(new DefaultCaret(this, CCCluePanel.this){

                @Override
                protected final void adjustVisibility(Rectangle rectangle) {
                }
            });
            this.setFont(font);
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
            MyTextArea myTextArea = this;
            myTextArea.registerKeyboardAction(myTextArea, KeyStroke.getKeyStroke("ENTER"), 0);
            MyTextArea myTextArea2 = this;
            myTextArea2.registerKeyboardAction(myTextArea2, KeyStroke.getKeyStroke("TAB"), 0);
            MyTextArea myTextArea3 = this;
            myTextArea3.registerKeyboardAction(myTextArea3.upAction, KeyStroke.getKeyStroke("shift TAB"), 0);
            MyTextArea myTextArea4 = this;
            myTextArea4.registerKeyboardAction(myTextArea4, KeyStroke.getKeyStroke("DOWN"), 0);
            MyTextArea myTextArea5 = this;
            myTextArea5.registerKeyboardAction(myTextArea5.upAction, KeyStroke.getKeyStroke("UP"), 0);
            this.addKeyListener(new KeyAdapter(CCCluePanel.this){

                @Override
                public final void keyReleased(KeyEvent object) {
                    GridState gridState = CCCluePanel.this.cc.getDisplay().getState();
                    String string = gridState.getClue(MyTextArea.this.wordIndex);
                    super.keyReleased((KeyEvent)object);
                    object = MyTextArea.this.getText();
                    if (string.length() == 0 != (((String)object).length() == 0)) {
                        object = ((String)object).length() == 0 ? Color.gray : Color.white;
                        MyTextArea.this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0), BorderFactory.createMatteBorder(0, 0, 1, 0, (Color)object)));
                    }
                    object = MyTextArea.this.getText();
                    string = gridState.getClue(MyTextArea.this.wordIndex);
                    if (MyTextArea.this.lineIndex != CCCluePanel.this.lastChanged && !((String)object).equals(string)) {
                        CCCluePanel.this.cc.pushUndo();
                        CCCluePanel.this.cc.cloneState();
                        gridState = CCCluePanel.this.cc.getDisplay().getState();
                        CCCluePanel.this.lastChanged = MyTextArea.this.lineIndex;
                    }
                    gridState.setClue(MyTextArea.this.wordIndex, (String)object);
                    boolean bl = string.length() == 0 != (((String)object).length() == 0);
                    if (bl) {
                        CCCluePanel.this.updateClueCount(gridState);
                    }
                    SwingUtilities.invokeLater(new Runnable(this){
                        private /* synthetic */ 3 this$2;
                        {
                            this.this$2 = var1_1;
                        }

                        @Override
                        public final void run() {
                            this.this$2.CCCluePanel.this.ensureSelectionVisible(this.this$2.MyTextArea.this.lineIndex);
                        }
                    });
                }
            });
            this.addFocusListener(new FocusAdapter(this, CCCluePanel.this){
                private /* synthetic */ MyTextArea this$1;
                {
                    this.this$1 = myTextArea;
                }

                @Override
                public final void focusGained(FocusEvent serializable) {
                    CCCluePanel cCCluePanel = this.this$1.CCCluePanel.this;
                    synchronized (cCCluePanel) {
                        serializable = serializable.getComponent();
                        ((JTextComponent)serializable).selectAll();
                        int n = this.this$1.CCCluePanel.this.currentWords[this.this$1.lineIndex].getWordIndex();
                        int n2 = this.this$1.CCCluePanel.this.cc.getDisplay().getSelectedWord();
                        if (this.this$1.CCCluePanel.this.fullyShowing && n2 != n) {
                            this.this$1.CCCluePanel.this.roboFocusing = true;
                            this.this$1.CCCluePanel.this.cc.getDisplay().setSelectedWord(n);
                            this.this$1.CCCluePanel.this.roboFocusing = false;
                        }
                        return;
                    }
                }
            });
        }

        @Override
        public final void setText(String object) {
            String string = this.getText();
            super.setText((String)object);
            object = this.getText();
            if (string.length() == 0 != (((String)object).length() == 0)) {
                object = ((String)object).length() == 0 ? Color.gray : Color.white;
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0), BorderFactory.createMatteBorder(0, 0, 1, 0, (Color)object)));
            }
        }

        @Override
        public final void actionPerformed(ActionEvent actionEvent) {
            CCCluePanel.this.currentClues[(this.lineIndex + 1) % CCCluePanel.this.currentClues.length].requestFocusInWindow();
        }
    }

    public static final class SPanel
    extends JPanel
    implements Scrollable {
        @Override
        public final Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public final int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            SPanel sPanel = this;
            return rectangle.height - (sPanel.getFontMetrics(sPanel.getFont()).getHeight() << 1);
        }

        @Override
        public final boolean getScrollableTracksViewportHeight() {
            return false;
        }

        @Override
        public final boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public final int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            SPanel sPanel = this;
            return sPanel.getFontMetrics(sPanel.getFont()).getHeight();
        }
    }
}

