/*
 * Decompiled with CFR 0.152.
 */
package com.beekeeper.xwd;

import com.beekeeper.util.Starlog;
import com.beekeeper.util.StringTable;
import com.beekeeper.util.closedhash.IntObjectHash;
import com.beekeeper.xwd.GridState;
import com.beekeeper.xwd.WordGrid;
import com.beekeeper.xwd.WordList;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class BuffWordList
extends WordList {
    private static final Starlog VERBOSE = Starlog.get(4);
    private boolean dirty;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private ByteBuffer[] origBuff = new ByteBuffer[128];
    private int origBuffNext = 0;
    private String[][] words;
    private int[][] origWords;
    private int[][] masks;
    private int[][] posMasks;
    private int[][][] byCharMasks;
    private float[][] scores;
    private final IntObjectHash<String> rebusMap;
    private String[] rebusStrings;
    private char[] rebusChars;
    private final int[][] lookupTable = new int[511][];
    private BuffWordList source;
    private byte[][] dictSets;
    private volatile int cacheHits = 0;
    private volatile int cacheTries = 0;
    private int searchBufferLen = -1;
    private final Cache[] caches = new Cache[31];
    private WordList.WordListChangeMonitor changeMonitor;
    private int dictSetChunk;

    public final boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    private int addToOrigBuff(String string) {
        int n;
        int n2;
        ByteBuffer byteBuffer;
        int n3;
        while (true) {
            n3 = string.length();
            byteBuffer = ByteBuffer.allocate(512);
            if (byteBuffer.capacity() >= n3 * 3) {
                byteBuffer.clear();
            } else {
                byteBuffer = ByteBuffer.allocate(n3 * 3);
            }
            for (n2 = 0; n2 < n3; ++n2) {
                char c = string.charAt(n2);
                ByteBuffer byteBuffer2 = byteBuffer;
                if (c < '\u0080') {
                    byteBuffer2.put((byte)c);
                    continue;
                }
                if (c < '\u0800') {
                    byteBuffer2.put((byte)(192 + c / 64));
                    byteBuffer2.put((byte)(128 + c % 64));
                    continue;
                }
                byteBuffer2.put((byte)(224 + c / 4096));
                byteBuffer2.put((byte)(128 + c / 64 % 64));
                byteBuffer2.put((byte)(128 + c % 64));
            }
            byteBuffer.flip();
            n2 = byteBuffer.remaining();
            n3 = this.origBuffNext / 32768;
            n = this.origBuffNext % 32768;
            if (n3 >= this.origBuff.length) {
                ByteBuffer[] byteBufferArray = new ByteBuffer[this.origBuff.length + 128];
                System.arraycopy(this.origBuff, 0, byteBufferArray, 0, this.origBuff.length);
                this.origBuff = byteBufferArray;
            }
            if (this.origBuff[n3] == null) {
                this.origBuff[n3] = ByteBuffer.allocate(32768);
            }
            if (n + n2 + 1 <= 32768) break;
            if (n2 > 32768) {
                throw new IllegalArgumentException("Max size for strings is 32768");
            }
            this.origBuffNext = n3 + 1 << 15;
        }
        int n4 = this.origBuffNext;
        this.origBuff[n3].position(n);
        this.origBuff[n3].put(byteBuffer);
        this.origBuff[n3].put((byte)0);
        this.origBuffNext += n2 + 1;
        return n4;
    }

    private ByteBuffer getOrigBuffer(int n) {
        int n2 = n / 32768;
        ByteBuffer byteBuffer = this.origBuff[n2];
        byteBuffer.limit(32768);
        byteBuffer.position(n %= 32768);
        return byteBuffer;
    }

    public final void addWord(String string, float f) {
        this.lock.writeLock().lock();
        try {
            Object[] objectArray;
            Object object;
            int n;
            int n2;
            String string2 = StringTable.getDefault().intern(this.getLetters(string), false);
            int n3 = string2.length();
            if (n3 >= this.words.length) {
                int n4 = this.words.length;
                this.words = (String[][])Arrays.copyOf(this.words, n3 + 1);
                for (n2 = n4; n2 <= n3; ++n2) {
                    this.words[n2] = new String[0];
                }
                this.origWords = (int[][])Arrays.copyOf(this.origWords, n3 + 1);
                for (n2 = n4; n2 <= n3; ++n2) {
                    this.origWords[n2] = new int[0];
                }
                this.scores = (float[][])Arrays.copyOf(this.scores, n3 + 1);
                for (n2 = n4; n2 <= n3; ++n2) {
                    this.scores[n2] = new float[0];
                }
                this.masks = (int[][])Arrays.copyOf(this.masks, n3 + 1);
                for (n2 = n4; n2 <= n3; ++n2) {
                    this.masks[n2] = new int[0];
                }
                this.byCharMasks = (int[][][])Arrays.copyOf(this.byCharMasks, n3 + 1);
                for (n2 = n4; n2 <= n3; ++n2) {
                    this.byCharMasks[n2] = new int[26][];
                    for (n = 0; n < 26; ++n) {
                        this.byCharMasks[n2][n] = new int[0];
                    }
                }
                this.posMasks = (int[][])Arrays.copyOf(this.posMasks, n3 + 1);
                for (n2 = n4; n2 <= n3; ++n2) {
                    this.posMasks[n2] = new int[0];
                }
                if (this.dictSets != null) {
                    this.dictSets = (byte[][])Arrays.copyOf(this.dictSets, n3 + 1);
                    for (n2 = n4; n2 <= n3; ++n2) {
                        this.dictSets[n2] = new byte[0];
                    }
                }
            }
            Object object2 = this.words[n3];
            n2 = ((String[])object2).length;
            String[] stringArray = Arrays.copyOf(object2, n2 + 1);
            object2 = stringArray;
            stringArray[n2] = string2;
            this.words[n3] = object2;
            if (((String[])object2).length > this.searchBufferLen) {
                this.searchBufferLen = ((String[])object2).length;
                for (n = 0; n < this.caches.length; ++n) {
                    this.caches[n] = new Cache(this);
                }
            }
            int[] nArray = this.origWords[n3];
            int[] nArray2 = Arrays.copyOf(nArray, n2 + 1);
            object2 = nArray2;
            nArray2[n2] = this.addToOrigBuff(string);
            this.origWords[n3] = (int[])object2;
            float[] fArray = this.scores[n3];
            object2 = fArray;
            float[] fArray2 = Arrays.copyOf(fArray, n2 + 1);
            object2 = fArray2;
            fArray2[n2] = f;
            this.scores[n3] = (float[])object2;
            int[] nArray3 = this.masks[n3];
            object2 = nArray3;
            object2 = Arrays.copyOf(nArray3, n2 + 1);
            int n5 = BuffWordList.computeMask(string2);
            object2[n2] = (String)n5;
            this.masks[n3] = (int[])object2;
            object2 = this.byCharMasks[n3];
            for (int i = 0; i < string2.length(); ++i) {
                char c = string2.charAt(i);
                if (c < 'a' || c > 'z') continue;
                object = object2[c - 97];
                if (((String)object).length > 0) {
                    String string3 = object;
                    if (string3[((String)string3).length - 1] == n2) continue;
                }
                String string4 = object;
                int[] nArray4 = Arrays.copyOf((int[])string4, ((String)string4).length + 1);
                objectArray = nArray4;
                nArray4[((String)object).length] = n2;
                object2[c - 97] = objectArray;
            }
            int[] nArray5 = this.posMasks[n3];
            int[] nArray6 = Arrays.copyOf(nArray5, n2 + 1);
            int[] nArray7 = nArray6;
            nArray6[n2] = BuffWordList.computePosMask(string2);
            this.posMasks[n3] = nArray7;
            if (this.dictSets != null) {
                byte[] byArray = this.dictSets[n3];
                object = byArray;
                objectArray = Arrays.copyOf(byArray, n2 * this.dictSetChunk + this.dictSetChunk);
                this.dictSets[n3] = (byte[])objectArray;
            }
            int n6 = n5 % 511;
            objectArray = this.lookupTable[n6];
            int[] nArray8 = Arrays.copyOf(objectArray, objectArray.length + 1);
            int[] nArray9 = nArray8;
            nArray8[objectArray.length] = n2;
            this.lookupTable[n6] = nArray9;
            this.dirty = true;
            for (int i = 0; i < this.caches.length; ++i) {
                this.caches[i].size = 0;
            }
            if (this.changeMonitor != null) {
                this.changeMonitor.announceScoreChange(string2, 0.0f, f);
                this.changeMonitor.announceSpellingChange(string2, string, true);
            }
            return;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public BuffWordList(BuffWordList buffWordList, String[] object, char[] cArray) {
        super(buffWordList.letterConv);
        int n;
        int n2;
        int n3;
        int n4;
        Object object2;
        int n5;
        new ThreadLocal();
        Object object3 = buffWordList;
        if (((BuffWordList)object3).source == null) {
            v0 = buffWordList;
        } else {
            object3 = buffWordList;
            v0 = this.source = ((BuffWordList)object3).source;
        }
        if (cArray.length != ((String[])object).length) {
            throw new IllegalArgumentException("Mismatched rebus info.");
        }
        this.rebusStrings = new String[((String[])object).length + buffWordList.rebusStrings.length];
        this.rebusChars = new char[((String[])object).length];
        int n6 = buffWordList.rebusStrings.length;
        System.arraycopy(buffWordList.rebusStrings, 0, this.rebusStrings, 0, n6);
        System.arraycopy(buffWordList.rebusChars, 0, this.rebusChars, 0, n6);
        int n7 = ((String[])object).length;
        for (n5 = 0; n5 < n7; ++n5) {
            object2 = object[n5];
            char c = cArray[n5];
            n4 = n5 + n6;
            for (n3 = 0; n3 < n4; ++n3) {
                if (object[n3].equals(object2)) {
                    throw new IllegalArgumentException("Duplicate rebus string:" + (String)object2);
                }
                if (cArray[n3] != c) continue;
                throw new IllegalArgumentException("Duplicate rebus char:" + c);
            }
            this.rebusStrings[n5 + n6] = object2;
            this.rebusChars[n5 + n6] = c;
        }
        this.rebusMap = new IntObjectHash(cArray.length, 1.5);
        for (n5 = 0; n5 < cArray.length; ++n5) {
            this.rebusMap.put(cArray[n5], object[n5]);
        }
        buffWordList.lock.readLock().lock();
        try {
            this.origBuffNext = buffWordList.origBuffNext;
            this.origBuff = new ByteBuffer[buffWordList.origBuff.length];
            n5 = this.origBuffNext / 32768;
            n7 = this.origBuffNext % 32768;
            if (n7 > 0) {
                for (int i = 0; i < n5; ++i) {
                    this.origBuff[i] = buffWordList.origBuff[i].duplicate();
                }
                object2 = ByteBuffer.allocate(32768);
                ByteBuffer byteBuffer = buffWordList.origBuff[n5];
                byteBuffer.clear();
                ((ByteBuffer)object2).put(byteBuffer);
                this.origBuff[n5] = object2;
            }
        }
        finally {
            buffWordList.lock.readLock().unlock();
        }
        ArrayList arrayList = new ArrayList(buffWordList.words.length);
        int n8 = buffWordList.words.length;
        for (n7 = 0; n7 < n8; ++n7) {
            arrayList.add(new ArrayList());
        }
        for (String[] stringArray : buffWordList.words) {
            n4 = stringArray.length;
            for (n3 = 0; n3 < n4; ++n3) {
                String string = stringArray[n3];
                object3 = string;
                object3 = BuffWordList.rebusReplace(string, (String[])object, cArray);
                if (!((String)object3).equals(string)) {
                    Object object4 = object3;
                    object3 = StringTable.getDefault();
                    object3 = ((StringTable)object3).intern((String)object4, true);
                }
                ((ArrayList)arrayList.get(((String)object3).length())).add(new RebusMapping(string, (String)object3, n3));
            }
        }
        if (VERBOSE != null) {
            VERBOSE.logf("strings...", new Object[0]);
        }
        n7 = 0;
        int n9 = arrayList.size();
        for (n8 = 0; n8 < n9; ++n8) {
            if (((ArrayList)arrayList.get(n8)).isEmpty()) continue;
            n7 = n8;
        }
        n8 = this.dictSetChunk = buffWordList.dictSetChunk;
        this.words = new String[n7 + 1][];
        this.origWords = new int[n7 + 1][];
        this.scores = new float[n7 + 1][];
        if (n8 > 0) {
            this.dictSets = new byte[n7 + 1][];
        }
        n9 = 0;
        for (n3 = 0; n3 < this.words.length; ++n3) {
            Object object5 = (ArrayList)arrayList.get(n3);
            int n10 = ((ArrayList)object5).size();
            this.words[n3] = new String[n10];
            this.origWords[n3] = new int[n10];
            this.scores[n3] = new float[n10];
            if (this.dictSets != null) {
                this.dictSets[n3] = new byte[n10 * n8];
            }
            if (n10 > n9) {
                n9 = n10;
            }
            int n11 = 0;
            object = ((ArrayList)object5).iterator();
            while (object.hasNext()) {
                RebusMapping rebusMapping = (RebusMapping)object.next();
                String string = rebusMapping.oldWord;
                this.words[n3][n11] = rebusMapping.newWord;
                int n12 = string.length();
                int n13 = rebusMapping.oldIndex;
                this.origWords[n3][n11] = buffWordList.origWords[n12][n13];
                this.scores[n3][n11] = buffWordList.scores[n12][n13];
                if (n8 == 1) {
                    this.dictSets[n3][n11] = buffWordList.dictSets[n12][n13];
                } else if (this.dictSets != null) {
                    byte[] byArray = buffWordList.dictSets[n12];
                    object5 = this.dictSets[n3];
                    int n14 = n11 * n8;
                    n13 *= n8;
                    for (int i = 0; i < n8; ++i) {
                        object5[n14 + i] = byArray[n13 + i];
                    }
                }
                ++n11;
            }
        }
        this.searchBufferLen = n9;
        int[] nArray = new int[this.searchBufferLen];
        if (VERBOSE != null) {
            VERBOSE.logf("chars...", new Object[0]);
        }
        this.masks = new int[n7 + 1][];
        for (n2 = 0; n2 < this.words.length; ++n2) {
            String[] stringArray = this.words[n2];
            this.masks[n2] = new int[stringArray.length];
            int[] nArray2 = this.masks[n2];
            for (int i = 0; i < stringArray.length; ++i) {
                nArray2[i] = BuffWordList.computeMask(stringArray[i]);
            }
        }
        this.byCharMasks = new int[n7 + 1][][];
        for (n2 = 0; n2 < this.words.length; ++n2) {
            int[][] nArrayArray = new int[26][];
            this.byCharMasks[n2] = nArrayArray;
            for (int i = 97; i <= 122; ++i) {
                int n15 = (n2 & 0xF) << 26 | MASK_BITS[i];
                int n16 = this.searchPrescan(n15, n2, nArray);
                int[] nArray3 = new int[n16];
                System.arraycopy(nArray, 0, nArray3, 0, n16);
                nArrayArray[i - 97] = nArray3;
            }
        }
        if (VERBOSE != null) {
            VERBOSE.logf("char pos...", new Object[0]);
        }
        this.posMasks = new int[n7 + 1][];
        for (n2 = 0; n2 < this.words.length; ++n2) {
            String[] stringArray = this.words[n2];
            this.posMasks[n2] = new int[stringArray.length];
            int[] nArray4 = this.posMasks[n2];
            for (int i = 0; i < stringArray.length; ++i) {
                nArray4[i] = BuffWordList.computePosMask(stringArray[i]);
            }
        }
        if (VERBOSE != null) {
            VERBOSE.logf("lookup....", new Object[0]);
        }
        int[] nArray5 = new int[511];
        for (n = 0; n < this.words.length; ++n) {
            int[] nArray6 = this.masks[n];
            for (int i = 0; i < nArray6.length; ++i) {
                int n17 = nArray6[i] % 511;
                nArray5[n17] = nArray5[n17] + 1;
            }
        }
        for (n = 0; n < 511; ++n) {
            this.lookupTable[n] = new int[nArray5[n]];
            nArray5[n] = 0;
        }
        for (n = 0; n < this.words.length; ++n) {
            int[] nArray7 = this.masks[n];
            int n18 = 0;
            while (n18 < nArray7.length) {
                int n19;
                int n20 = n19 = nArray7[n18] % 511;
                int n21 = nArray5[n20];
                nArray5[n20] = n21 + 1;
                this.lookupTable[n19][n21] = n18++;
            }
        }
        for (n = 0; n < this.caches.length; ++n) {
            this.caches[n] = new Cache(this);
        }
        if (VERBOSE != null) {
            VERBOSE.log("done.");
        }
    }

    private static String rebusReplace(String string, String[] stringArray, char[] cArray) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string2;
            char c = cArray[i];
            String string3 = stringArray[i];
            int n2 = string.indexOf(string3);
            if (n2 == -1) {
                string2 = string;
            } else {
                int n3;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(string, 0, n2).append(c);
                n2 += string3.length();
                while ((n3 = string.indexOf(string3, n2)) != -1) {
                    stringBuilder.append(string, n2, n3).append(c);
                    n2 = n3 + string3.length();
                }
                stringBuilder.append(string, n2, string.length());
                string2 = stringBuilder.toString();
            }
            string = string2;
        }
        return string;
    }

    public BuffWordList(WordList.UniqueWordMap stringArray) {
        super(stringArray.mLetterConv);
        int n;
        int n2;
        Object[] objectArray;
        new ThreadLocal();
        this.rebusStrings = new String[0];
        this.rebusChars = new char[0];
        this.rebusMap = new IntObjectHash(0, 1.5);
        if (VERBOSE != null) {
            VERBOSE.logf("Processing word list...", new Object[0]);
        }
        if (VERBOSE != null) {
            VERBOSE.logf("lengths...", new Object[0]);
        }
        int n3 = 0;
        Object object = stringArray.getIterator();
        while (((WordList.UniqueWordMap.Iter)object).advance()) {
            n3 = Math.max(n3, ((WordList.UniqueWordMap.Iter)object).getKey().length());
        }
        if (VERBOSE != null) {
            VERBOSE.logf("counts...", new Object[0]);
        }
        object = new int[n3 + 1];
        WordList.UniqueWordMap.Iter iter = stringArray.getIterator();
        while (iter.advance()) {
            Object object2 = object;
            int n4 = iter.getKey().length();
            object2[n4] = object2[n4] + true;
        }
        if (VERBOSE != null) {
            VERBOSE.logf("strings...", new Object[0]);
        }
        this.words = new String[n3 + 1][];
        this.origWords = new int[n3 + 1][];
        this.scores = new float[n3 + 1][];
        Object[] object3 = stringArray;
        int n5 = this.dictSetChunk = stringArray.idxBytes;
        object3 = stringArray;
        object3 = stringArray.dictSet;
        if (n5 > 0) {
            this.dictSets = new byte[n3 + 1][];
        }
        Object object4 = 0;
        for (int i = 0; i < ((Object)object).length; ++i) {
            Object object5 = object[i];
            this.words[i] = new String[object5];
            this.origWords[i] = new int[object5];
            this.scores[i] = new float[object5];
            if (object5 > object4) {
                object4 = object5;
            }
            object[i] = false;
            if (this.dictSets == null) continue;
            this.dictSets[i] = new byte[object5 * n5];
        }
        this.searchBufferLen = object4;
        int[] nArray = new int[this.searchBufferLen];
        WordList.UniqueWordMap.Iter iter2 = stringArray.getIterator();
        while (iter2.advance()) {
            Object object6;
            stringArray = iter2.getKey();
            String string = iter2.getOrig();
            float f = iter2.getScore();
            int n6 = stringArray.length();
            Object object5 = object;
            int n7 = n6;
            object5[n7] = object5[n7] + true;
            this.words[n6][object6] = stringArray;
            this.origWords[n6][object6] = this.addToOrigBuff(string);
            this.scores[n6][object6] = f;
            if (n5 == 1) {
                this.dictSets[n6][object6] = (byte)object3[iter2.getDictSetIndex()];
                continue;
            }
            if (this.dictSets == null) continue;
            objectArray = this.dictSets[n6];
            reference var13_39 = object6 * n5;
            int n8 = iter2.getDictSetIndex() * n5;
            for (int i = 0; i < n5; ++i) {
                objectArray[i + var13_39] = (float)object3[i + n8];
            }
        }
        for (n2 = 0; n2 < ((Object)object).length; ++n2) {
            stringArray = this.words[n2];
            if (stringArray.length == 0) continue;
            float[] fArray = this.scores[n2];
            int[] nArray2 = this.origWords[n2];
            Integer[] integerArray = new Integer[stringArray.length];
            int n9 = 0;
            int n10 = integerArray.length;
            while (n9 < n10) {
                int n8 = n9++;
                integerArray[n8] = n8;
            }
            Arrays.sort(integerArray, new Comparator<Integer>(){
                private /* synthetic */ float[] val$lenScores;
                private /* synthetic */ String[] val$lenWords;
                {
                    this.val$lenScores = fArray;
                    this.val$lenWords = stringArray;
                }
            });
            String[] stringArray2 = new String[stringArray.length];
            objectArray = new float[stringArray.length];
            int[] nArray3 = new int[stringArray.length];
            byte[] byArray = null;
            byte[] byArray2 = null;
            if (this.dictSets != null) {
                byArray2 = this.dictSets[n2];
                byArray = new byte[byArray2.length];
            }
            int n12 = stringArray.length;
            for (int i = 0; i < n12; ++i) {
                int n13 = integerArray[i];
                stringArray2[i] = stringArray[n13];
                objectArray[i] = fArray[n13];
                nArray3[i] = nArray2[n13];
                if (n5 == 1) {
                    byArray[i] = byArray2[n13];
                    continue;
                }
                if (byArray == null) continue;
                n13 *= n5;
                int n14 = i * n5;
                for (int j = 0; j < n5; ++j) {
                    byArray[n14 + j] = byArray2[n13 + j];
                }
            }
            this.words[n2] = stringArray2;
            this.scores[n2] = objectArray;
            this.origWords[n2] = nArray3;
            if (byArray2 == null) continue;
            this.dictSets[n2] = byArray;
        }
        if (VERBOSE != null) {
            VERBOSE.logf("chars...", new Object[0]);
        }
        this.masks = new int[n3 + 1][];
        for (n2 = 0; n2 < ((Object)object).length; ++n2) {
            stringArray = this.words[n2];
            this.masks[n2] = new int[stringArray.length];
            int[] nArray4 = this.masks[n2];
            for (int i = 0; i < stringArray.length; ++i) {
                nArray4[i] = BuffWordList.computeMask(stringArray[i]);
            }
        }
        this.byCharMasks = new int[n3 + 1][][];
        for (n2 = 0; n2 < this.words.length; ++n2) {
            stringArray = (String[])new int[26][];
            this.byCharMasks[n2] = (int[][])stringArray;
            for (object4 = 97; object4 <= 122; ++object4) {
                int n15 = (n2 & 0xF) << 26 | MASK_BITS[object4];
                int n16 = this.searchPrescan(n15, n2, nArray);
                int[] nArray5 = new int[n16];
                System.arraycopy(nArray, 0, nArray5, 0, n16);
                stringArray[object4 - 97] = nArray5;
            }
        }
        if (VERBOSE != null) {
            VERBOSE.logf("char pos...", new Object[0]);
        }
        this.posMasks = new int[n3 + 1][];
        for (n2 = 0; n2 < ((Object)object).length; ++n2) {
            stringArray = this.words[n2];
            this.posMasks[n2] = new int[stringArray.length];
            int[] nArray6 = this.posMasks[n2];
            for (int i = 0; i < stringArray.length; ++i) {
                nArray6[i] = BuffWordList.computePosMask(stringArray[i]);
            }
        }
        if (VERBOSE != null) {
            VERBOSE.logf("lookup....", new Object[0]);
        }
        int[] nArray7 = new int[511];
        for (n = 0; n < ((Object)object).length; ++n) {
            int[] nArray8 = this.masks[n];
            for (int i = 0; i < nArray8.length; ++i) {
                int n9 = nArray8[i] % 511;
                nArray7[n9] = nArray7[n9] + 1;
            }
        }
        for (n = 0; n < 511; ++n) {
            this.lookupTable[n] = new int[nArray7[n]];
            nArray7[n] = 0;
        }
        for (n = 0; n < ((Object)object).length; ++n) {
            int[] nArray9 = this.masks[n];
            int n18 = 0;
            while (n18 < nArray9.length) {
                int n19;
                int n10 = n19 = nArray9[n18] % 511;
                int n11 = nArray7[n10];
                nArray7[n10] = n11 + 1;
                this.lookupTable[n19][n11] = n18++;
            }
        }
        for (n = 0; n < this.caches.length; ++n) {
            this.caches[n] = new Cache(this);
        }
        if (VERBOSE != null) {
            VERBOSE.log("done.");
        }
    }

    @Override
    public final int getMaxLength() {
        return this.words.length - 1;
    }

    @Override
    public final MatchInfo search(GridState object, int n, float f) {
        WordGrid.Word word = ((GridState)object).getWord(n);
        object = ((GridState)object).getChars();
        return this.search((char[])object, word, f);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    private MatchInfo search(char[] cArray, WordGrid.Word word, float f) {
        String string;
        Object object;
        void var3_4;
        Object object2;
        int[] nArray;
        int n;
        this.lock.readLock().lock();
        try {
            void var2_3;
            ++this.cacheTries;
            Cache cache = var2_3;
            int n2 = ((WordGrid.Word)((Object)cache)).letterIndices.length;
            n = 0;
            for (int i = 0; i < n2; ++i) {
                char c = var2_3.getLetter(i, cArray);
                if (c >= '\u0080' || c == '\u0000') continue;
                n |= MASK_BITS[c];
            }
            Cache cache2 = cache = this.caches[(n |= (n2 & 0xF) << 26) % this.caches.length];
            synchronized (cache) {
                MatchInfo[] matchInfoArray = cache.cacheInfo;
                nArray = cache.searchBuffer;
                int n3 = cache.size;
                MatchInfo matchInfo = null;
                block7: for (int i = 0; i < n3; ++i) {
                    object2 = matchInfoArray[i];
                    matchInfoArray[i] = matchInfo;
                    matchInfo = object2;
                    if (((MatchInfo)object2).mask != n || ((MatchInfo)object2).pattern.length() != n2 || ((MatchInfo)object2).minScore != var3_4) continue;
                    object = ((MatchInfo)object2).pattern;
                    for (int j = 0; j < n2; ++j) {
                        void var16_23 = var2_3;
                        int n4 = j;
                        char[] cArray2 = cArray;
                        int n5 = var16_23.getLetter(n4, cArray2);
                        if (n5 == 0) {
                            n5 = 95;
                        } else if (n5 == 127) {
                            n5 = 35;
                        }
                        n4 = ((String)object).charAt(j);
                        if (n5 != n4) continue block7;
                    }
                    ++this.cacheHits;
                    matchInfoArray[0] = object2;
                    Object object3 = object2;
                    // ** MonitorExit[var7_9] (shouldn't be in output)
                    this.lock.readLock().unlock();
                    if (VERBOSE != null && this.cacheTries % 1000 == 0) {
                        VERBOSE.log("Cache hit rate: " + this.getCacheHitRate());
                    }
                    return object3;
                }
                if (n3 < 128) {
                    matchInfoArray[n3++] = matchInfo;
                    cache.size = n3;
                }
                string = var2_3.getDebugString(cArray);
            }
        }
        catch (Throwable throwable) {
            this.lock.readLock().unlock();
            if (VERBOSE != null && this.cacheTries % 1000 == 0) {
                VERBOSE.log("Cache hit rate: " + this.getCacheHitRate());
            }
            throw throwable;
        }
        {
            object2 = this.rawSearch(string, n, (float)var3_4, nArray);
            object = new MatchInfo(this, (int[])object2, string, n, (float)var3_4);
            matchInfoArray[0] = object;
            Object object4 = object;
            // ** MonitorExit[var7_9] (shouldn't be in output)
            this.lock.readLock().unlock();
            if (VERBOSE != null && this.cacheTries % 1000 == 0) {
                VERBOSE.log("Cache hit rate: " + this.getCacheHitRate());
            }
            return object4;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MatchInfo search(String string, float object) {
        Object object2;
        this.lock.readLock().lock();
        try {
            int n;
            ++this.cacheTries;
            int n2 = string.length();
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                n = string.charAt(i);
                if (n >= 128 || n == 95) continue;
                n3 |= MASK_BITS[n];
            }
            Cache cache = this.caches[(n3 |= (n2 & 0xF) << 26) % this.caches.length];
            object = cache;
            Cache cache2 = cache;
            synchronized (cache) {
                MatchInfo matchInfo;
                n = object.size;
                MatchInfo[] matchInfoArray = object.cacheInfo;
                int[] nArray = object.searchBuffer;
                int n4 = n3;
                MatchInfo matchInfo2 = null;
                block7: for (int i = 0; i < n; ++i) {
                    matchInfo = matchInfoArray[i];
                    matchInfoArray[i] = matchInfo2;
                    matchInfo2 = matchInfo;
                    if (matchInfo.mask != n3 || matchInfo.pattern.length() != n2 || matchInfo.minScore != 1.0f) continue;
                    object2 = matchInfo.pattern;
                    int n5 = 0;
                    while (true) {
                        if (n5 >= n2) {
                            ++this.cacheHits;
                            matchInfoArray[0] = matchInfo;
                            MatchInfo matchInfo3 = matchInfo;
                            // ** MonitorExit[var5_8] (shouldn't be in output)
                            this.lock.readLock().unlock();
                            return matchInfo3;
                        }
                        if (string.charAt(n5) != ((String)object2).charAt(n5)) continue block7;
                        ++n5;
                    }
                }
                if (n < 128) {
                    matchInfoArray[n++] = matchInfo2;
                    object.size = n;
                }
                int[] nArray2 = this.rawSearch(string, n4, 1.0f, nArray);
                matchInfoArray[0] = matchInfo = new MatchInfo(this, nArray2, string, n4, 1.0f);
                object2 = matchInfo;
            }
        }
        catch (Throwable throwable) {
            this.lock.readLock().unlock();
            throw throwable;
        }
        {
            // ** MonitorExit[var5_8] (shouldn't be in output)
            this.lock.readLock().unlock();
            return object2;
        }
    }

    private int[] rawSearch(String object, int n, float f, int[] nArray) {
        int n2;
        int n3;
        int n4;
        int n5 = ((String)object).length();
        if (n5 >= this.words.length) {
            return new int[0];
        }
        int n6 = Integer.MAX_VALUE;
        int[] nArray2 = null;
        int n7 = ((String)object).length();
        for (n4 = 0; n4 < n7; ++n4) {
            int[] nArray3;
            n3 = ((String)object).charAt(n4);
            if (n3 < 97 || n3 > 122 || (n2 = (nArray3 = this.byCharMasks[n5][n3 - 97]).length) >= n6) continue;
            n6 = n2;
            nArray2 = nArray3;
        }
        n4 = this.masks[n5].length;
        if (n6 > n4 / 2) {
            nArray2 = null;
        }
        n7 = nArray2 == null ? this.searchPrescan(n, n5, nArray) : this.searchPrescan(nArray2, n, n5, nArray);
        n3 = this.searchPosScan(BuffWordList.computePosMask((String)object), n5, n7, nArray);
        n3 = this.scoreFilter(n5, n3, f, nArray);
        n2 = this.searchCheckChars((String)object, n5, n3, nArray);
        object = new int[n2];
        System.arraycopy(nArray, 0, object, 0, n2);
        return object;
    }

    private int searchCheckChars(String string, int n, int n2, int[] nArray) {
        String[] stringArray = this.words[n];
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '_') continue;
            int n3 = 0;
            for (int j = 0; j < n2; ++j) {
                int n4 = nArray[j];
                String string2 = stringArray[n4];
                if (string2.charAt(i) != c) continue;
                nArray[n3++] = n4;
            }
            n2 = n3;
        }
        return n2;
    }

    private int scoreFilter(int n, int n2, float f, int[] nArray) {
        int n3 = 0;
        float[] fArray = this.scores[n];
        for (int i = 0; i < n2; ++i) {
            int n4 = nArray[i];
            if (!(fArray[n4] >= f)) continue;
            nArray[n3++] = n4;
        }
        return n3;
    }

    private int searchPrescan(int n, int n2, int[] nArray) {
        int[] nArray2 = this.masks[n2];
        int n3 = 0;
        int n4 = nArray2.length;
        for (int i = 0; i < n4; ++i) {
            nArray[n3] = i;
            int n5 = nArray2[i] & n;
            n5 ^= n;
            n5 = n5 >>> 31 | -n5 >>> 31;
            n3 = n3 + 1 - n5;
        }
        return n3;
    }

    private int searchPrescan(int[] nArray, int n, int n2, int[] nArray2) {
        int[] nArray3 = this.masks[n2];
        int n3 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n4 = nArray[i];
            if ((nArray3[n4] & n) != n) continue;
            nArray2[n3++] = n4;
        }
        return n3;
    }

    private int searchPosScan(int n, int n2, int n3, int[] nArray) {
        int[] nArray2 = this.posMasks[n2];
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            int n5 = nArray[i];
            int n6 = nArray2[n5];
            if ((n6 & n) != n) continue;
            nArray[n4++] = n5;
        }
        return n4;
    }

    private int getWordIndex(String string) {
        String[] stringArray;
        int[] nArray;
        int[] nArray2;
        int n;
        block6: {
            int n2;
            block5: {
                this.lock.readLock().lock();
                n2 = string.length();
                if (n2 < this.words.length) break block5;
                this.lock.readLock().unlock();
                return -1;
            }
            n = BuffWordList.computeMask(string);
            nArray2 = this.lookupTable[n % 511];
            nArray = this.masks[n2];
            stringArray = this.words[n2];
            if (nArray2.length != 0) break block6;
            this.lock.readLock().unlock();
            return -1;
        }
        try {
            for (int i = 0; i < nArray2.length; ++i) {
                int n3 = nArray2[i];
                if (n3 >= nArray.length || nArray[n3] != n || !stringArray[n3].equals(string)) continue;
                int n4 = n3;
                this.lock.readLock().unlock();
                return n4;
            }
            this.lock.readLock().unlock();
            return -1;
        }
        catch (Throwable throwable) {
            this.lock.readLock().unlock();
            throw throwable;
        }
    }

    public final void setChangeMonitor(WordList.WordListChangeMonitor wordListChangeMonitor) {
        this.changeMonitor = wordListChangeMonitor;
    }

    public final boolean hasWord(String string) {
        return this.getWordIndex(string) != -1;
    }

    @Override
    public final String getLetters(String string) {
        return BuffWordList.rebusReplace(this.deleteNonLetters(string), this.rebusStrings, this.rebusChars);
    }

    @Override
    public final String getTrueLetters(String string) {
        return super.getLetters(string);
    }

    @Override
    public final float getWordScore(String string) {
        float f;
        int n = this.getWordIndex(string);
        if (n == -1) {
            return 0.0f;
        }
        float f2 = this.scores[string.length()][n];
        if (f < 0.0f) {
            return 0.0f;
        }
        return f2;
    }

    public BitSet getWordDictionaries(String object) {
        BitSet bitSet = new BitSet();
        int n = this.getWordIndex((String)object);
        if (n != -1) {
            object = this.dictSets[((String)object).length()];
            n *= this.dictSetChunk;
            for (int i = 0; i < this.dictSetChunk; ++i) {
                int n2 = object[n + i] & 0xFF;
                int n3 = 0;
                int n4 = 1;
                while (n3 < 8) {
                    if ((n2 & n4) != 0) {
                        bitSet.set(i * 8 + n3);
                    }
                    ++n3;
                    n4 <<= 1;
                }
            }
        }
        return bitSet;
    }

    public final void setWordScore(String string, float f) {
        this.lock.writeLock().lock();
        try {
            int n = this.getWordIndex(string);
            if (n == -1) {
                throw new IllegalArgumentException("No such word: " + string);
            }
            float f2 = this.scores[string.length()][n];
            this.scores[string.length()][n] = f;
            for (n = 0; n < this.caches.length; ++n) {
                this.caches[n].size = 0;
            }
            this.dirty = true;
            if (this.changeMonitor != null) {
                this.changeMonitor.announceScoreChange(string, f2, f);
            }
            return;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public final String getOrigWord(String string) {
        int n = this.getWordIndex(string);
        int n2 = string.length();
        if (n == -1 || this.scores[n2][n] < 0.0f) {
            if (this.rebusChars.length > 0) {
                StringBuilder stringBuilder = null;
                for (n2 = 0; n2 < string.length(); ++n2) {
                    char c = string.charAt(n2);
                    String string2 = this.rebusMap.get(c);
                    if (string2 != null) {
                        if (stringBuilder == null) {
                            stringBuilder = new StringBuilder(string.substring(0, n2));
                        }
                        stringBuilder.append(string2);
                        continue;
                    }
                    if (stringBuilder == null) continue;
                    stringBuilder.append(c);
                }
                if (stringBuilder != null) {
                    return stringBuilder.toString();
                }
            }
            return string;
        }
        n = this.origWords[n2][n];
        return this.getOrigWord(n);
    }

    private String getOrigWord(int n) {
        BuffWordList buffWordList = this;
        synchronized (buffWordList) {
            ByteBuffer byteBuffer = this.getOrigBuffer(n);
            int n2 = byteBuffer.position();
            int n3 = 0;
            while (BuffWordList.readUTFChar(byteBuffer) != 0) {
                ++n3;
            }
            StringBuilder stringBuilder = new StringBuilder(n3);
            byteBuffer.position(n2);
            for (n2 = 0; n2 < n3; ++n2) {
                stringBuilder.append((char)BuffWordList.readUTFChar(byteBuffer));
            }
            return stringBuilder.toString();
        }
    }

    public final void setOrigWord(String string, String string2) {
        this.lock.writeLock().lock();
        try {
            String string3 = BuffWordList.rebusReplace(string, this.rebusStrings, this.rebusChars);
            if (!BuffWordList.rebusReplace(this.deleteNonLetters(string2), this.rebusStrings, this.rebusChars).equals(string3)) {
                throw new IllegalArgumentException(String.format("Original value '%s' doesn't match word '%s'", string2, string));
            }
            int n = this.getWordIndex(string3);
            if (n == -1) {
                throw new IllegalArgumentException("No such word: " + string3);
            }
            this.origWords[string3.length()][n] = this.addToOrigBuff(string2);
            for (n = 0; n < this.caches.length; ++n) {
                this.caches[n].size = 0;
            }
            this.dirty = true;
            if (this.changeMonitor != null) {
                this.changeMonitor.announceSpellingChange(string3, string2, false);
            }
            return;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private float getCacheHitRate() {
        return (float)this.cacheHits / (float)this.cacheTries;
    }

    @Override
    public final void writeTextFile(String object) throws IOException {
        object = new OutputStreamWriter((OutputStream)new FileOutputStream((String)object), "UTF-8");
        object = new PrintWriter(new BufferedWriter((Writer)object));
        for (int i = 0; i < this.words.length; ++i) {
            int[] nArray = this.origWords[i];
            float[] fArray = this.scores[i];
            for (int j = 0; j < nArray.length; ++j) {
                if (fArray[j] < 0.0f) continue;
                this.lock.readLock().lock();
                try {
                    int n;
                    ByteBuffer byteBuffer = this.getOrigBuffer(nArray[j]);
                    while ((n = BuffWordList.readUTFChar(byteBuffer)) != 0) {
                        ((PrintWriter)object).print((char)n);
                    }
                }
                finally {
                    this.lock.readLock().unlock();
                }
                ((PrintWriter)object).print(";");
                ((PrintWriter)object).print((int)fArray[j]);
                ((PrintWriter)object).println();
            }
        }
        ((PrintWriter)object).close();
        this.dirty = false;
    }

    public final BuffWordList getSource() {
        return this.source;
    }

    final class Cache {
        protected int size = 0;
        protected final MatchInfo[] cacheInfo = new MatchInfo[128];
        protected final int[] searchBuffer;
        private /* synthetic */ BuffWordList this$0;

        Cache(BuffWordList buffWordList) {
            this.this$0 = buffWordList;
            this.searchBuffer = new int[this.this$0.searchBufferLen];
        }
    }

    static final class RebusMapping {
        String oldWord;
        String newWord;
        int oldIndex;

        public RebusMapping(String string, String string2, int n) {
            this.oldWord = string;
            this.newWord = string2;
            this.oldIndex = n;
        }
    }

    public final class MatchInfo
    extends WordList.MatchInfo {
        private final int[] matches;
        private float highestMatchScore;
        private final String pattern;
        private final int mask;
        private final String[] lenWords;
        private final float minScore;
        private /* synthetic */ BuffWordList this$0;

        public MatchInfo(BuffWordList buffWordList, int[] nArray, String string, int n, float f) {
            this.this$0 = buffWordList;
            super(buffWordList);
            this.highestMatchScore = Float.NEGATIVE_INFINITY;
            this.matches = nArray;
            this.pattern = string;
            this.mask = n;
            this.minScore = f;
            int n2 = string.length();
            if (n2 >= buffWordList.words.length) {
                this.lenWords = new String[0];
                return;
            }
            this.lenWords = buffWordList.words[n2];
        }

        public final String toString() {
            StringBuilder stringBuilder = new StringBuilder("{");
            int n = this.pattern.length();
            int n2 = Math.min(this.matches.length, 10);
            for (int i = 0; i < n2; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                int n3 = this.matches[i];
                stringBuilder.append(this.lenWords[n3]);
                stringBuilder.append(":");
                stringBuilder.append((int)this.this$0.scores[n][n3]);
            }
            if (this.matches.length > 10) {
                stringBuilder.append("...");
            }
            stringBuilder.append("}");
            return stringBuilder.toString();
        }

        @Override
        public final int getMatchCount() {
            return this.matches.length;
        }

        @Override
        public final String getMatch(int n) {
            return this.lenWords[this.matches[n]];
        }

        @Override
        public final String getOrig(int n) {
            int n2 = this.pattern.length();
            this.this$0.lock.readLock().lock();
            try {
                ByteBuffer byteBuffer = this.this$0.getOrigBuffer(this.this$0.origWords[n2][this.matches[n]]);
                n = byteBuffer.position();
                int n3 = 0;
                while (WordList.readUTFChar(byteBuffer) != 0) {
                    ++n3;
                }
                StringBuilder stringBuilder = new StringBuilder(n3);
                byteBuffer.position(n);
                for (n = 0; n < n3; ++n) {
                    stringBuilder.append((char)WordList.readUTFChar(byteBuffer));
                }
                String string = stringBuilder.toString();
                return string;
            }
            finally {
                this.this$0.lock.readLock().unlock();
            }
        }

        @Override
        public final float getScore(int n) {
            return this.this$0.scores[this.pattern.length()][this.matches[n]];
        }

        @Override
        public final float highestMatchScore() {
            float f = this.highestMatchScore;
            if (f == Float.NEGATIVE_INFINITY) {
                f = 0.0f;
                float[] fArray = this.this$0.scores[this.pattern.length()];
                for (int i = 0; i < this.matches.length; ++i) {
                    f = Math.max(f, fArray[this.matches[i]]);
                }
                this.highestMatchScore = f;
            }
            return f;
        }
    }
}

