/*
 * Decompiled with CFR 0.152.
 */
package com.beekeeper.util.closedhash;

import com.beekeeper.util.ImageUtil;

public abstract class GenericHash {
    private int modMask;
    private int elementCount;
    private int rehashCountThreshold;
    private double loadFactor;
    private GenericHashCell[] cells;
    private boolean ensureHashQuality = true;
    private boolean exploitLocality = false;
    private static final GenericHashCell NULL_CELL = new GenericHashCell(0){};

    public GenericHash() {
        this(8, 1.5);
    }

    public GenericHash(int n, double d) {
        int n2;
        this.loadFactor = d;
        n = (int)((double)n / d);
        for (n2 = 4; n2 < n; n2 <<= 1) {
        }
        this.rehashCountThreshold = (int)(d * (double)n2);
        int n3 = n2;
        GenericHash genericHash = this;
        this.cells = new GenericHashCell[n3];
        genericHash.modMask = n3 - 1;
    }

    protected abstract boolean matchesCurrentKey(GenericHashCell var1);

    public abstract Iter getIterator();

    private void incrementSize(int n) {
        this.elementCount += n;
        if (this.elementCount > this.rehashCountThreshold) {
            n = this.cells.length;
            this.rehashCountThreshold = (int)(this.loadFactor * (double)(n <<= 1));
            int n2 = n;
            GenericHash genericHash = this;
            GenericHashCell[] genericHashCellArray = genericHash.cells;
            genericHash.cells = new GenericHashCell[n2];
            genericHash.modMask = n2 - 1;
            for (n2 = 0; n2 < genericHashCellArray.length; ++n2) {
                GenericHashCell genericHashCell = genericHashCellArray[n2];
                while (genericHashCell != null) {
                    GenericHashCell genericHashCell2 = genericHashCell.chain;
                    int n3 = genericHashCell.hash;
                    if (genericHash.ensureHashQuality) {
                        n3 = ImageUtil.rehash1(n3);
                    }
                    genericHashCell.chain = genericHash.cells[n3 &= genericHash.modMask];
                    genericHash.cells[n3] = genericHashCell;
                    genericHashCell = genericHashCell2;
                }
            }
        }
    }

    protected final GenericHashCell findCell(int n) {
        int n2 = n;
        if (this.ensureHashQuality) {
            n2 = ImageUtil.rehash1(n);
        }
        GenericHashCell genericHashCell = this.cells[n2 &= this.modMask];
        while (genericHashCell != null) {
            if (genericHashCell.hash == n && this.matchesCurrentKey(genericHashCell)) {
                return genericHashCell;
            }
            genericHashCell = genericHashCell.chain;
        }
        return null;
    }

    protected final void auxPut(GenericHashCell genericHashCell) {
        this.incrementSize(1);
        int n = genericHashCell.hash;
        if (this.ensureHashQuality) {
            n = ImageUtil.rehash1(n);
        }
        genericHashCell.chain = this.cells[n &= this.modMask];
        this.cells[n] = genericHashCell;
    }

    protected final boolean auxRemove(int n) {
        GenericHashCell genericHashCell;
        int n2 = n;
        if (this.ensureHashQuality) {
            n2 = ImageUtil.rehash1(n);
        }
        if ((genericHashCell = this.cells[n2 &= this.modMask]) == null) {
            return false;
        }
        if (genericHashCell.hash == n && this.matchesCurrentKey(genericHashCell)) {
            this.cells[n2] = genericHashCell.chain;
        } else {
            while (true) {
                GenericHashCell genericHashCell2;
                if ((genericHashCell2 = genericHashCell.chain) == null) {
                    return false;
                }
                if (genericHashCell2.hash == n && this.matchesCurrentKey(genericHashCell2)) {
                    genericHashCell.chain = genericHashCell2.chain;
                    break;
                }
                genericHashCell = genericHashCell2;
            }
        }
        this.incrementSize(-1);
        return true;
    }

    public final void clear() {
        for (int i = 0; i < this.cells.length; ++i) {
            this.cells[i] = null;
        }
        this.elementCount = 0;
    }

    public final int size() {
        return this.elementCount;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        Iter iter = this.getIterator();
        while (iter.advance()) {
            if (stringBuilder.length() > 1) {
                stringBuilder.append(", ");
            }
            iter.appendString(stringBuilder);
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public static abstract class GenericHashCell {
        private final int hash;
        private GenericHashCell chain;

        public GenericHashCell(int n) {
            this.hash = n;
            this.chain = null;
        }
    }

    public abstract class Iter {
        private int nextIndex = -1;
        private GenericHashCell currCell = NULL_CELL;
        private /* synthetic */ GenericHash this$0;

        protected Iter(GenericHash genericHash) {
            this.this$0 = genericHash;
        }

        public boolean advance() {
            this.currCell = this.currCell.chain;
            while (this.currCell == null) {
                ++this.nextIndex;
                if (this.nextIndex >= this.this$0.cells.length) {
                    return false;
                }
                this.currCell = this.this$0.cells[this.nextIndex];
            }
            return true;
        }

        protected final GenericHashCell getCell() {
            return this.currCell;
        }

        protected abstract void appendString(StringBuilder var1);
    }
}

