/*
 * Decompiled with CFR 0.152.
 */
package com.beekeeper.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public final class XmlUtil {
    private static final String[] EMPTY_STRINGS = new String[0];
    private static NamespaceContext DEFAULT_NAMESPACES = new NamespaceContext(){

        @Override
        public final String getNamespaceURI(String string) {
            if (string.equals("x")) {
                return "http://www.w3.org/1999/xhtml";
            }
            return null;
        }

        @Override
        public final String getPrefix(String string) {
            if (string.equals("http://www.w3.org/1999/xhtml")) {
                return "x";
            }
            return null;
        }

        @Override
        public final Iterator<String> getPrefixes(String string) {
            String[] stringArray = new String[]{};
            if (string.equals("http://www.w3.org/1999/xhtml")) {
                stringArray = new String[]{"x"};
            }
            return Arrays.asList(stringArray).iterator();
        }
    };

    public static void printDOM(OutputStream outputStream, Node object) {
        boolean bl = false;
        Object object2 = outputStream;
        try {
            Object object3 = TransformerFactory.newInstance();
            object3 = ((TransformerFactory)object3).newTransformer();
            ((Transformer)object3).setOutputProperty("indent", "yes");
            ((Transformer)object3).setOutputProperty("encoding", "utf-8");
            object = new DOMSource((Node)object);
            object2 = new StreamResult((OutputStream)object2);
            ((Transformer)object3).transform((Source)object, (Result)object2);
            return;
        }
        catch (TransformerException transformerException) {
            throw new RuntimeException(transformerException);
        }
    }

    public static Document createDOMDocument() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            return documentBuilderFactory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException(parserConfigurationException);
        }
    }

    public static Element appendElement(Node node, String string) {
        return XmlUtil.appendElement(node, string, EMPTY_STRINGS);
    }

    public static Element appendElement(Node node, String object, String ... stringArray) {
        Document document = node instanceof Document ? (Document)node : node.getOwnerDocument();
        object = document.createElement((String)object);
        for (int i = 0; i < stringArray.length; i += 2) {
            object.setAttribute(stringArray[i], stringArray[i + 1]);
        }
        node.appendChild((Node)object);
        return object;
    }

    public static Text appendTextNode(Element element, String object) {
        Document document = element instanceof Document ? (Document)((Object)element) : element.getOwnerDocument();
        object = document.createTextNode((String)object);
        element.appendChild((Node)object);
        return object;
    }

    public static Element appendTextElement(Element element, String string, String string2) {
        element = XmlUtil.appendElement(element, string);
        XmlUtil.appendTextNode(element, string2);
        return element;
    }

    public static Document parseToDOM(InputStream inputStream) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            return documentBuilderFactory.newDocumentBuilder().parse(inputStream, null);
        }
        catch (SAXException sAXException) {
            throw new RuntimeException(sAXException);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException(parserConfigurationException);
        }
    }

    private static List<Node> xpathMatches(Node object, String object2, NamespaceContext namespaceContext) {
        XPath xPath = XPathFactory.newInstance().newXPath();
        xPath.setNamespaceContext(namespaceContext);
        try {
            object = (NodeList)xPath.evaluate((String)object2, object, XPathConstants.NODESET);
            object2 = new ArrayList(object.getLength());
            int n = object.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = object.item(i);
                ((ArrayList)object2).add(node);
            }
            return object2;
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new RuntimeException(xPathExpressionException);
        }
    }

    public static List<Node> xpathMatches(Node node, String string) {
        return XmlUtil.xpathMatches(node, string, DEFAULT_NAMESPACES);
    }

    private static Node xpathFirst(Node object, String string, NamespaceContext namespaceContext) {
        XPath xPath = XPathFactory.newInstance().newXPath();
        xPath.setNamespaceContext(namespaceContext);
        try {
            object = (NodeList)xPath.evaluate(string, object, XPathConstants.NODESET);
            if (object.getLength() > 0) {
                return object.item(0);
            }
            return null;
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new RuntimeException(xPathExpressionException);
        }
    }

    public static Node xpathFirst(Node node, String string) {
        return XmlUtil.xpathFirst(node, string, DEFAULT_NAMESPACES);
    }
}

