/*
 * Decompiled with CFR 0.152.
 */
package com.beekeeper.util;

import com.beekeeper.util.ImageUtil;
import com.beekeeper.util.ReferenceManager;
import java.lang.ref.Reference;

public final class StringTable {
    private static final StringTable DEFAULT_TABLE = new StringTable();
    int modMask;
    private int elementCount;
    private int rehashCountThreshold;
    private double loadFactor = 1.5;
    private HashCell[] cells;

    public static StringTable getDefault() {
        return DEFAULT_TABLE;
    }

    public StringTable() {
        int n;
        int n2 = (int)(1024.0 / this.loadFactor);
        for (n = 4; n < n2; n <<= 1) {
        }
        this.rehashCountThreshold = (int)(this.loadFactor * (double)n);
        StringTable stringTable = this;
        this.cells = new HashCell[n];
        stringTable.modMask = n - 1;
    }

    private void incrementSize(int n) {
        this.elementCount += n;
        if (this.elementCount > this.rehashCountThreshold) {
            n = this.cells.length;
            this.rehashCountThreshold = (int)(this.loadFactor * (double)(n <<= 1));
            int n2 = n;
            StringTable stringTable = this;
            HashCell[] hashCellArray = stringTable.cells;
            stringTable.cells = new HashCell[n2];
            stringTable.modMask = n2 - 1;
            for (n2 = 0; n2 < hashCellArray.length; ++n2) {
                HashCell hashCell = hashCellArray[n2];
                while (hashCell != null) {
                    HashCell hashCell2 = hashCell.chain;
                    int n3 = hashCell.hash;
                    n3 = ImageUtil.rehash1(n3);
                    hashCell.chain = stringTable.cells[n3 &= stringTable.modMask];
                    stringTable.cells[n3] = hashCell;
                    hashCell = hashCell2;
                }
            }
        }
    }

    private void auxPut(HashCell hashCell) {
        this.incrementSize(1);
        int n = hashCell.hash;
        n = ImageUtil.rehash1(n);
        hashCell.chain = this.cells[n &= this.modMask];
        this.cells[n] = hashCell;
    }

    public final synchronized String intern(String string, boolean bl) {
        Object object;
        Object object2;
        String string2;
        int n;
        block3: {
            int n2 = n = string.hashCode();
            string2 = string;
            object2 = this;
            int n3 = ImageUtil.rehash1(n2);
            object2 = ((StringTable)object2).cells[n3 &= ((StringTable)object2).modMask];
            while (object2 != null) {
                String string3;
                if (((HashCell)object2).hash == n2 && (string3 = (String)((Reference)object2).get()) != null && string3.equals(string2)) {
                    object = object2;
                    break block3;
                }
                object2 = ((HashCell)object2).chain;
            }
            object = object2 = null;
        }
        if (object != null && (string2 = (String)((Reference)object2).get()) != null) {
            return string2;
        }
        string2 = bl ? new String(string) : string;
        object2 = new HashCell(this, string, n);
        this.auxPut((HashCell)object2);
        return string2;
    }

    public final class HashCell
    extends ReferenceManager.WeakReference<String> {
        private final int hash;
        private HashCell chain;
        private /* synthetic */ StringTable this$0;

        public HashCell(StringTable stringTable, String string, int n) {
            this.this$0 = stringTable;
            super(string);
            this.hash = n;
            this.chain = null;
        }

        @Override
        public final void cleanup() {
            StringTable stringTable = this.this$0;
            synchronized (stringTable) {
                int n = ImageUtil.rehash1(this.hash);
                HashCell hashCell = this.this$0.cells[n &= this.this$0.modMask];
                if (hashCell == null) {
                    throw new IllegalStateException();
                }
                if (hashCell == this) {
                    this.this$0.cells[n] = hashCell.chain;
                } else {
                    while (true) {
                        HashCell hashCell2;
                        if ((hashCell2 = hashCell.chain) == null) {
                            throw new IllegalStateException();
                        }
                        if (hashCell2 == this) {
                            hashCell.chain = hashCell2.chain;
                            break;
                        }
                        hashCell = hashCell2;
                    }
                }
                this.this$0.incrementSize(-1);
                return;
            }
        }
    }
}

