/*
 * Decompiled with CFR 0.152.
 */
package com.beekeeper.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.security.AccessControlException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public class Starlog {
    private static final List<String> ALL_LEVELS = Arrays.asList("ERROR", "WARNING", "TODO", "STATUS", "EXTRA", "DEBUG", "EXTREME");
    private File outFile = null;

    public static Starlog get(int n) {
        try {
            Object object = Thread.currentThread().getStackTrace();
            object = object[2];
            object = ((StackTraceElement)object).getClassName();
            Properties properties = System.getProperties();
            int n2 = ((String)object).lastIndexOf(46);
            String string = ((String)object).substring(n2 + 1);
            String string2 = properties.getProperty("logger", "STATUS");
            if (properties.containsKey("logger." + string)) {
                string2 = properties.getProperty("logger." + string);
            } else {
                while (n2 != -1) {
                    string = ((String)object).substring(0, n2);
                    if (properties.containsKey("logger." + string)) {
                        string2 = properties.getProperty("logger." + string);
                        break;
                    }
                    n2 = ((String)object).lastIndexOf(46, n2 - 1);
                }
            }
            int n3 = ALL_LEVELS.indexOf(string2);
            if (n3 == -1) {
                n3 = 3;
                System.err.println("Warning: Unknown log level: " + string2);
            }
            if (n3 < n) {
                return null;
            }
            return new Starlog(n);
        }
        catch (AccessControlException accessControlException) {
            return null;
        }
        catch (Throwable throwable) {
            System.out.println("Couldn't init logger: ");
            throwable.printStackTrace();
            return null;
        }
    }

    private Starlog(int n) {
        String string = System.getProperty("logfile", null);
        if (string != null && !string.equals("-")) {
            this.outFile = new File(string);
        }
    }

    public final void log(String string) {
        Class<Starlog> clazz = Starlog.class;
        synchronized (Starlog.class) {
            try {
                PrintStream printStream = this.outFile == null ? System.out : new PrintStream(new FileOutputStream(this.outFile, true));
                printStream.println(string);
                if (this.outFile != null) {
                    printStream.close();
                }
            }
            catch (IOException iOException) {
                IOException iOException2 = iOException;
                iOException.printStackTrace();
            }
            return;
        }
    }

    public final void logf(String string, Object ... objectArray) {
        Class<Starlog> clazz = Starlog.class;
        synchronized (Starlog.class) {
            try {
                PrintStream printStream = this.outFile == null ? System.out : new PrintStream(new FileOutputStream(this.outFile, true));
                printStream.printf(string, objectArray);
                if (this.outFile != null) {
                    printStream.close();
                }
            }
            catch (IOException iOException) {
                IOException iOException2 = iOException;
                iOException.printStackTrace();
            }
            return;
        }
    }
}

