/*
 * Decompiled with CFR 0.152.
 */
package com.beekeeper.util;

import com.beekeeper.util.IntSet;
import java.text.BreakIterator;
import java.text.CharacterIterator;
import java.util.Arrays;

public final class SpaceBreakIterator
extends BreakIterator {
    private int[] boundaries;
    private int bi = 0;
    private CharacterIterator text;

    @Override
    public final int current() {
        return this.boundaries[this.bi];
    }

    @Override
    public final int first() {
        this.bi = 0;
        return this.boundaries[0];
    }

    @Override
    public final int last() {
        this.bi = this.boundaries.length - 1;
        return this.boundaries[this.bi];
    }

    @Override
    public final CharacterIterator getText() {
        return this.text;
    }

    @Override
    public final int following(int n) {
        int n2 = this.boundaries.length;
        for (int i = 0; i < n2; ++i) {
            if (this.boundaries[i] <= n) continue;
            this.bi = i;
            return this.boundaries[this.bi];
        }
        return -1;
    }

    @Override
    public final int next() {
        if (this.bi + 1 >= this.boundaries.length) {
            return -1;
        }
        return this.boundaries[++this.bi];
    }

    @Override
    public final int next(int n) {
        if ((n = this.bi + n) >= this.boundaries.length || n < 0) {
            return -1;
        }
        this.bi = n;
        return this.boundaries[this.bi];
    }

    @Override
    public final int previous() {
        if (this.bi <= 0) {
            return -1;
        }
        return this.boundaries[--this.bi];
    }

    @Override
    public final void setText(CharacterIterator object) {
        this.text = object;
        char c = ' ';
        boolean bl = false;
        IntSet intSet = new IntSet();
        intSet.add(object.getBeginIndex());
        intSet.add(object.getEndIndex());
        int n = 0;
        char c2 = object.first();
        while (c2 != '\uffff') {
            if (Character.isWhitespace(c2) || Character.isWhitespace(c) || Character.isLetterOrDigit(c2) && bl || c2 == '\u1806' || c2 == '\u2014') {
                intSet.add(n);
            }
            bl = Character.isLetterOrDigit(c) && (c2 == '-' && !Character.isDigit(c) || c2 == '\u00ad' || c2 == '\u058a' || c2 == '\u2012' || c2 == '\u2013' || c2 == '\u2014');
            c = c2;
            ++n;
            c2 = object.next();
        }
        object = intSet;
        this.boundaries = new int[((IntSet)object).elementCount];
        n = 0;
        IntSet.Iter iter = intSet.getIterator();
        while (iter.advance()) {
            this.boundaries[n++] = iter.getKey();
        }
        Arrays.sort(this.boundaries);
    }
}

