/*
 * Decompiled with CFR 0.152.
 */
package com.beekeeper.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.table.AbstractTableModel;

public final class RecordTableModel<C>
extends AbstractTableModel {
    private static final Class<?>[] PRIMITIVES = new Class[]{Boolean.TYPE, Character.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
    private static final Class<?>[] WRAPPERS = new Class[]{Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class};
    public static Map<Class<?>, Class<?>> wrapMap = Collections.synchronizedMap(new HashMap());
    private final String[] cols;
    private final Getter<C>[] colGetters;
    private ArrayList<C> rows = new ArrayList();

    private static String[] makeFields(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray3 = stringArray[i];
            StringBuilder stringBuilder = new StringBuilder();
            stringArray3 = stringArray3.trim().split(" ++");
            for (int j = 0; j < stringArray3.length; ++j) {
                String string = stringArray3[j];
                if (j == 0) {
                    stringBuilder.append(string.toLowerCase());
                    continue;
                }
                stringBuilder.append(Character.toUpperCase(string.charAt(0))).append(string.substring(1).toLowerCase());
            }
            stringArray2[i] = stringBuilder.toString();
        }
        return stringArray2;
    }

    public static <C> RecordTableModel<C> create(Class<C> clazz, String[] stringArray) {
        return new RecordTableModel<C>(clazz, stringArray, RecordTableModel.makeFields(stringArray));
    }

    private RecordTableModel(Class<C> clazz, String[] stringArray, String[] stringArray2) {
        this.cols = stringArray;
        this.colGetters = new Getter[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            AccessibleObject accessibleObject;
            try {
                String string = stringArray2[i];
                Method method = clazz.getMethod("get" + Character.toUpperCase(string.charAt(0)) + string.substring(1), new Class[0]);
                accessibleObject = null;
                try {
                    string = stringArray2[i];
                    accessibleObject = clazz.getMethod("set" + Character.toUpperCase(string.charAt(0)) + string.substring(1), method.getReturnType());
                }
                catch (NoSuchMethodException noSuchMethodException) {}
                this.colGetters[i] = new MethodGetter(method, (Method)accessibleObject);
                continue;
            }
            catch (SecurityException securityException) {
                throw new RuntimeException(securityException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    accessibleObject = clazz.getField(stringArray2[i]);
                }
                catch (SecurityException securityException) {
                    throw new RuntimeException(securityException);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    throw new RuntimeException(noSuchFieldException);
                }
                this.colGetters[i] = new FieldGetter((Field)accessibleObject);
            }
        }
    }

    @Override
    public final int getColumnCount() {
        return this.cols.length;
    }

    @Override
    public final int getRowCount() {
        return this.rows.size();
    }

    public final C getValueAt(int n) {
        return this.rows.get(n);
    }

    @Override
    public final Object getValueAt(int n, int n2) {
        return this.colGetters[n2].get(this.rows.get(n));
    }

    @Override
    public final Class<?> getColumnClass(int n) {
        return this.colGetters[n].resultClass();
    }

    @Override
    public final String getColumnName(int n) {
        return this.cols[n];
    }

    public final void setData(C[] CArray) {
        this.rows.clear();
        this.rows.addAll(Arrays.asList(CArray));
        this.fireTableDataChanged();
    }

    public final void addRow(C c) {
        int n = this.rows.size();
        this.rows.add(c);
        int n2 = n;
        this.fireTableRowsInserted(n2, n2);
    }

    public final void removeRow(int n) {
        this.rows.remove(n);
        int n2 = n;
        this.fireTableRowsDeleted(n2, n2);
    }

    @Override
    public final boolean isCellEditable(int n, int n2) {
        return this.colGetters[n2].hasSetter();
    }

    @Override
    public final void setValueAt(Object object, int n, int n2) {
        Getter<C> getter = this.colGetters[n2];
        if (!getter.hasSetter()) {
            return;
        }
        getter.set(this.rows.get(n), object);
        this.fireTableCellUpdated(n, n2);
    }

    static {
        for (int i = 0; i < PRIMITIVES.length; ++i) {
            wrapMap.put(PRIMITIVES[i], WRAPPERS[i]);
        }
    }

    static abstract class Getter<C> {
        private Getter() {
        }

        abstract Object get(C var1);

        abstract Class<?> resultClass();

        abstract void set(C var1, Object var2);

        abstract boolean hasSetter();
    }

    static final class MethodGetter<C>
    extends Getter<C> {
        private Method meth;
        private Method setMeth;

        public MethodGetter(Method method, Method method2) {
            this.meth = method;
            this.setMeth = method2;
        }

        @Override
        final Object get(C c) {
            try {
                return this.meth.invoke(c, new Object[0]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException(illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException);
            }
        }

        @Override
        final Class<?> resultClass() {
            Class<?> clazz = this.meth.getReturnType();
            Class<?> clazz2 = wrapMap.get(clazz);
            if (clazz2 != null) {
                return clazz2;
            }
            return clazz;
        }

        @Override
        final void set(C c, Object object) {
            if (this.setMeth != null) {
                try {
                    this.setMeth.invoke(c, object);
                    return;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new RuntimeException(illegalArgumentException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new RuntimeException(illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new RuntimeException(invocationTargetException);
                }
            }
            throw new IllegalStateException("No setter defined for column");
        }

        @Override
        final boolean hasSetter() {
            return this.setMeth != null;
        }
    }

    static final class FieldGetter<C>
    extends Getter<C> {
        private Field field;

        public FieldGetter(Field field) {
            this.field = field;
        }

        @Override
        final Object get(C c) {
            try {
                return this.field.get(c);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException(illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
        }

        @Override
        final Class<?> resultClass() {
            Class<?> clazz = this.field.getType();
            Class<?> clazz2 = wrapMap.get(clazz);
            if (clazz2 != null) {
                return clazz2;
            }
            return clazz;
        }

        @Override
        final void set(C c, Object object) {
            try {
                this.field.set(c, object);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException(illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
        }

        @Override
        final boolean hasSetter() {
            return true;
        }
    }
}

