/*
 * Decompiled with CFR 0.152.
 */
package com.beekeeper.util;

import java.util.Random;

public final class OpenHashUtil {
    private static int[] rehashLookup = new int[128];

    private static int rot(int n, int n2) {
        return n << n2 | n >> 32 - n2;
    }

    public static int rehash1(int n) {
        n += Integer.MIN_VALUE;
        int n2 = 0 - OpenHashUtil.rot(Integer.MIN_VALUE, 14);
        n ^= n2;
        int n3 = Integer.MIN_VALUE ^ (n -= OpenHashUtil.rot(n2, 11));
        n2 ^= (n3 -= OpenHashUtil.rot(n, 25));
        n ^= (n2 -= OpenHashUtil.rot(n3, 16));
        n3 ^= (n -= OpenHashUtil.rot(n2, 4));
        n2 ^= (n3 -= OpenHashUtil.rot(n, 14));
        return n2 -= OpenHashUtil.rot(n3, 24);
    }

    public static int rehash2(int n) {
        n += 1844936704;
        int n2 = 0 - OpenHashUtil.rot(1844936704, 14);
        n ^= n2;
        int n3 = 0x6DF78000 ^ (n -= OpenHashUtil.rot(n2, 11));
        n2 ^= (n3 -= OpenHashUtil.rot(n, 25));
        n ^= (n2 -= OpenHashUtil.rot(n3, 16));
        n3 ^= (n -= OpenHashUtil.rot(n2, 4));
        n2 ^= (n3 -= OpenHashUtil.rot(n, 14));
        return n2 -= OpenHashUtil.rot(n3, 24);
    }

    static {
        Random random = new Random(0L);
        for (int i = 0; i < rehashLookup.length; ++i) {
            OpenHashUtil.rehashLookup[i] = random.nextInt();
        }
        new Object();
    }

    public static abstract class GenericDoubleHash {
        int cellCount;
        private int modMask;
        private int elementCount;
        private int rehashCellThreshold;
        private double loadFactor;

        protected abstract void init(int var1);

        protected abstract void rehash(int var1);

        protected abstract boolean hasNullKey(int var1);

        protected abstract boolean hasDeletedKey(int var1);

        protected abstract boolean matchesCurrentKey(int var1);

        public abstract Iter getIterator();

        private int getSkipStep(int n) {
            return OpenHashUtil.rehash2(n) & this.modMask | 1;
        }

        private int firstCellIndex(int n) {
            return OpenHashUtil.rehash1(n) & this.modMask;
        }

        private int getNextCellIndex(int n, int n2) {
            return n + n2 & this.modMask;
        }

        protected final int findIndex(int n) {
            int n2 = this.getSkipStep(n);
            n = this.firstCellIndex(n);
            while (!this.hasNullKey(n)) {
                if (this.matchesCurrentKey(n)) {
                    return n;
                }
                n = this.getNextCellIndex(n, n2);
            }
            return -1;
        }

        private int findInsertIndex(int n) {
            int n2 = this.getSkipStep(n);
            n = this.firstCellIndex(n);
            while (!this.hasNullKey(n)) {
                if (this.hasDeletedKey(n)) {
                    return n;
                }
                if (this.matchesCurrentKey(n)) {
                    return n;
                }
                n = this.getNextCellIndex(n, n2);
            }
            return n;
        }

        protected final int auxPut(int n) {
            int n2 = this.findIndex(n);
            if (n2 != -1) {
                return n2;
            }
            n2 = this.findInsertIndex(n);
            if (this.hasNullKey(n2)) {
                boolean bl;
                GenericDoubleHash genericDoubleHash = this;
                --genericDoubleHash.rehashCellThreshold;
                if (genericDoubleHash.rehashCellThreshold < 0) {
                    if ((double)genericDoubleHash.elementCount > (double)genericDoubleHash.cellCount * genericDoubleHash.loadFactor / 2.0) {
                        genericDoubleHash.cellCount <<= 1;
                    }
                    genericDoubleHash.modMask = genericDoubleHash.cellCount - 1;
                    genericDoubleHash.rehashCellThreshold = Math.min((int)(genericDoubleHash.loadFactor * (double)genericDoubleHash.cellCount), genericDoubleHash.modMask);
                    genericDoubleHash.elementCount = 0;
                    GenericDoubleHash genericDoubleHash2 = genericDoubleHash;
                    genericDoubleHash2.rehash(genericDoubleHash2.cellCount);
                    --genericDoubleHash.rehashCellThreshold;
                    bl = true;
                } else {
                    bl = false;
                }
                if (bl) {
                    n2 = this.findInsertIndex(n);
                }
            }
            this.incrementSize(1);
            return n2;
        }

        protected final int auxRemove(int n) {
            if ((n = this.findIndex(n)) >= 0) {
                this.incrementSize(-1);
            }
            return n;
        }

        private void incrementSize(int n) {
            this.elementCount += n;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("{");
            Iter iter = this.getIterator();
            while (iter.advance()) {
                if (stringBuilder.length() > 1) {
                    stringBuilder.append(", ");
                }
                iter.appendString(stringBuilder, iter.getIndex());
            }
            stringBuilder.append("}");
            return stringBuilder.toString();
        }

        public abstract class Iter {
            private int index = -1;
            private /* synthetic */ GenericDoubleHash this$0;

            protected Iter(GenericDoubleHash genericDoubleHash) {
                this.this$0 = genericDoubleHash;
            }

            public boolean advance() {
                do {
                    ++this.index;
                    if (this.index < this.this$0.cellCount) continue;
                    return false;
                } while (this.this$0.hasNullKey(this.index) || this.this$0.hasDeletedKey(this.index));
                return true;
            }

            protected final int getIndex() {
                return this.index;
            }

            protected abstract void appendString(StringBuilder var1, int var2);
        }
    }
}

