/*
 * Decompiled with CFR 0.152.
 */
package com.beekeeper.util;

import java.awt.Toolkit;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.text.JTextComponent;

public final class NumberVerifier
extends InputVerifier {
    private boolean checkRange = false;
    private double minValue = 0.0;
    private double maxValue = Double.POSITIVE_INFINITY;
    private boolean dingOnError;
    private boolean allowDecimal;
    private final Object errorName;

    public NumberVerifier(String string, boolean bl, boolean bl2) {
        this.dingOnError = bl;
        this.allowDecimal = bl2;
        this.errorName = string;
    }

    public NumberVerifier(String string, boolean bl, boolean bl2, double d, double d2) {
        this(string, true, false);
        this.checkRange = true;
        this.minValue = d;
        this.maxValue = d2;
    }

    private String getErrorString(JComponent object) {
        double d;
        if (!(object instanceof JTextComponent)) {
            return "Bad GUI configuration.";
        }
        object = (JTextComponent)object;
        object = ((JTextComponent)object).getText();
        if (this.allowDecimal) {
            try {
                d = Double.parseDouble((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                return "Input must be a number";
            }
        }
        try {
            d = Integer.parseInt((String)object);
        }
        catch (NumberFormatException numberFormatException) {
            return "Input must be an integer";
        }
        if (this.checkRange) {
            if (d < this.minValue) {
                if (this.allowDecimal) {
                    return "Value must be at least " + this.minValue;
                }
                return "Value must be at least " + (int)this.minValue;
            }
            if (d > this.maxValue) {
                if (this.allowDecimal) {
                    return "Value must be at most " + this.maxValue;
                }
                return "Value must be at most " + (int)this.maxValue;
            }
        }
        return null;
    }

    @Override
    public final boolean verify(JComponent object) {
        return (object = this.getErrorString((JComponent)object)) == null;
    }

    @Override
    public final boolean shouldYieldFocus(JComponent jComponent) {
        String string = this.getErrorString(jComponent);
        if (string == null) {
            return true;
        }
        if (this.dingOnError) {
            Toolkit.getDefaultToolkit().beep();
        }
        if (this.errorName != null) {
            JOptionPane.showMessageDialog(jComponent, string, "Bad input for " + this.errorName, 0);
        }
        return false;
    }
}

