/*
 * Decompiled with CFR 0.152.
 */
package com.beekeeper.util;

public final class IntSet {
    private int modMask;
    int elementCount;
    private int rehashCountThreshold = 12;
    private double loadFactor = 1.5;
    private IntHashCell[] cells;
    private static final IntHashCell NULL_CELL = new IntHashCell(0);

    public IntSet() {
        this(8, 1.5);
    }

    private IntSet(int n, double d) {
        int n2 = 8;
        IntSet intSet = this;
        this.cells = new IntHashCell[n2];
        intSet.modMask = n2 - 1;
    }

    public final void add(int n) {
        if (this.findCell(n) != null) {
            return;
        }
        IntHashCell intHashCell = new IntHashCell(n);
        IntSet intSet = this;
        boolean bl = true;
        IntSet intSet2 = intSet;
        ++intSet.elementCount;
        if (intSet2.elementCount > intSet2.rehashCountThreshold) {
            int n2 = intSet2.cells.length;
            intSet2.rehashCountThreshold = (int)(intSet2.loadFactor * (double)(n2 <<= 1));
            IntHashCell[] intHashCellArray = intSet2.cells;
            intSet2.cells = new IntHashCell[n2];
            intSet2.modMask = n2 - 1;
            for (n2 = 0; n2 < intHashCellArray.length; ++n2) {
                IntHashCell intHashCell2 = intHashCellArray[n2];
                while (intHashCell2 != null) {
                    IntHashCell intHashCell3 = intHashCell2.chain;
                    int n3 = intHashCell2.key;
                    intHashCell2.chain = intSet2.cells[n3 &= intSet2.modMask];
                    intSet2.cells[n3] = intHashCell2;
                    intHashCell2 = intHashCell3;
                }
            }
        }
        int n4 = intHashCell.key;
        intHashCell.chain = intSet.cells[n4 &= intSet.modMask];
        intSet.cells[n4] = intHashCell;
    }

    public final boolean contains(int n) {
        IntSet intSet = this;
        int n2 = n;
        return intSet.findCell(n2) != null;
    }

    public final Iter getIterator() {
        return new Iter(this);
    }

    private IntHashCell findCell(int n) {
        int n2 = n;
        IntHashCell intHashCell = this.cells[n2 &= this.modMask];
        while (intHashCell != null) {
            if (intHashCell.key == n) {
                return intHashCell;
            }
            intHashCell = intHashCell.chain;
        }
        return null;
    }

    public final int size() {
        return this.elementCount;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        Iter iter = this.getIterator();
        while (iter.advance()) {
            if (stringBuilder.length() > 1) {
                stringBuilder.append(", ");
            }
            StringBuilder stringBuilder2 = stringBuilder;
            Iter iter2 = iter;
            stringBuilder2.append(iter2.getKey());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public static final class IntHashCell {
        protected int key;
        private IntHashCell chain = null;

        public IntHashCell(int n) {
            this.key = n;
        }
    }

    public final class Iter {
        private int nextIndex = -1;
        private IntHashCell currCell = NULL_CELL;
        private /* synthetic */ IntSet this$0;

        public Iter(IntSet intSet) {
            this.this$0 = intSet;
        }

        public final int getKey() {
            Iter iter = this;
            return iter.currCell.key;
        }

        public final boolean advance() {
            this.currCell = this.currCell.chain;
            while (this.currCell == null) {
                ++this.nextIndex;
                if (this.nextIndex >= this.this$0.cells.length) {
                    return false;
                }
                this.currCell = this.this$0.cells[this.nextIndex];
            }
            return true;
        }
    }
}

