/*
 * Decompiled with CFR 0.152.
 */
package com.beekeeper.util;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;

public class ImageUtil {
    public String letters;
    public char inputChar;
    public char displayChar;

    public static BufferedImage buffered(Image image) {
        BufferedImage bufferedImage;
        if (image instanceof BufferedImage) {
            bufferedImage = (BufferedImage)image;
        } else {
            ImageUtil.insureDimensionsAvailable(image);
            bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
            Graphics graphics = bufferedImage.getGraphics();
            graphics.drawImage(image, 0, 0, null);
            graphics.dispose();
        }
        return bufferedImage;
    }

    private static void insureDimensionsAvailable(Image image) {
        if (image instanceof BufferedImage) {
            return;
        }
        boolean[] blArray = new boolean[]{true};
        ImageObserver imageObserver = new ImageObserver(blArray){
            private /* synthetic */ boolean[] val$sync;
            {
                this.val$sync = blArray;
            }

            @Override
            public final boolean imageUpdate(Image object, int n, int n2, int n3, int n4, int n5) {
                if ((n & 0x80) != 0 || (n & 3) == 3) {
                    object = this.val$sync;
                    synchronized (this.val$sync) {
                        this.val$sync[0] = true;
                        this.val$sync.notify();
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return false;
                    }
                }
                return true;
            }
        };
        boolean[] blArray2 = blArray;
        synchronized (blArray) {
            if (image.getWidth(imageObserver) == -1 || image.getHeight(imageObserver) == -1) {
                blArray[0] = false;
                while (!blArray[0]) {
                    try {
                        blArray.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return;
        }
    }

    private static BufferedImage getScaledInstance(BufferedImage bufferedImage, int n, int n2, Object object, boolean bl) {
        int n3;
        int n4;
        int n5 = bufferedImage.getTransparency() == 1 ? 1 : 2;
        BufferedImage bufferedImage2 = bufferedImage;
        if (bl) {
            n4 = bufferedImage.getWidth();
            n3 = bufferedImage.getHeight();
        } else {
            n4 = n;
            n3 = n2;
        }
        do {
            if (bl) {
                if (n4 > n) {
                    n4 /= 2;
                }
                if (n4 < n) {
                    n4 = n;
                }
                if (n3 > n2) {
                    n3 /= 2;
                }
                if (n3 < n2) {
                    n3 = n2;
                }
            }
            BufferedImage bufferedImage3 = new BufferedImage(n4, n3, n5);
            Graphics2D graphics2D = bufferedImage3.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object);
            graphics2D.drawImage(bufferedImage2, 0, 0, n4, n3, null);
            graphics2D.dispose();
            bufferedImage2 = bufferedImage3;
        } while (n4 > n || n3 > n2);
        return bufferedImage2;
    }

    public static BufferedImage scaleBufferedImage(BufferedImage bufferedImage, int n, int n2, ScaleStrategy scaleStrategy) {
        if (n < bufferedImage.getWidth() || n2 < bufferedImage.getHeight()) {
            switch (scaleStrategy) {
                case SYSTEM_SMOOTH: {
                    return ImageUtil.buffered(bufferedImage.getScaledInstance(n, n2, 4));
                }
                case CUSTOM_SMOOTH: {
                    return ImageUtil.downsizeBufferedImage(bufferedImage, n, n2);
                }
                case SMART_INTERP: {
                    return ImageUtil.getScaledInstance(bufferedImage, n, n2, RenderingHints.VALUE_INTERPOLATION_BILINEAR, true);
                }
                case FAST_INTERP: {
                    return ImageUtil.getScaledInstance(bufferedImage, n, n2, RenderingHints.VALUE_INTERPOLATION_BILINEAR, false);
                }
            }
        }
        return ImageUtil.upsizeBufferedImage(bufferedImage, n, n2);
    }

    private static BufferedImage upsizeBufferedImage(BufferedImage bufferedImage, int n, int n2) {
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        graphics2D.drawImage(bufferedImage, 0, 0, n, n2, 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    private static BufferedImage downsizeBufferedImage(BufferedImage bufferedImage, int n, int n2) {
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 3);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        int[] nArray = new int[n3 * n2];
        int[] nArray2 = new int[n4];
        int[] nArray3 = new int[n2];
        for (int i = 0; i < n3; ++i) {
            bufferedImage.getRGB(i, 0, 1, n4, nArray2, 0, 1);
            ImageUtil.rescaleARGBRow(nArray2, nArray3);
            System.arraycopy(nArray3, 0, nArray, i * n2, n2);
        }
        int[] nArray4 = new int[n * n2];
        nArray2 = new int[n3];
        nArray3 = new int[n];
        for (int i = 0; i < n2; ++i) {
            n4 = 0;
            int n5 = i;
            while (n4 < n3) {
                nArray2[n4] = nArray[n5];
                ++n4;
                n5 += n2;
            }
            ImageUtil.rescaleARGBRow(nArray2, nArray3);
            System.arraycopy(nArray3, 0, nArray4, i * n, n);
        }
        bufferedImage2.setRGB(0, 0, n, n2, nArray4, 0, n);
        return bufferedImage2;
    }

    private static void rescaleARGBRow(int[] nArray, int[] nArray2) {
        int n;
        int n2;
        int n3;
        int[][] nArray3 = new int[3][nArray.length];
        int[] nArray4 = new int[nArray.length];
        int[][] nArray5 = new int[3][nArray2.length];
        int[] nArray6 = new int[nArray2.length];
        for (n3 = 0; n3 < nArray2.length; ++n3) {
            nArray2[n3] = 0;
        }
        for (n3 = 0; n3 < nArray.length; ++n3) {
            nArray4[n3] = nArray[n3] >>> 24;
        }
        n3 = 0;
        for (n2 = 0; n2 < 24; n2 += 8) {
            for (n = 0; n < nArray.length; ++n) {
                nArray3[n3][n] = (nArray[n] >> n2 & 0xFF) * nArray4[n];
            }
            ++n3;
        }
        for (n3 = 0; n3 < 3; ++n3) {
            ImageUtil.rescaleBandRow(nArray3[n3], nArray5[n3]);
        }
        ImageUtil.rescaleBandRow(nArray4, nArray6);
        for (n3 = 0; n3 < nArray2.length; ++n3) {
            n2 = nArray6[n3];
            if (n2 > 255) {
                throw new IllegalStateException();
            }
            if (n2 == 0) {
                nArray2[n3] = 0;
                continue;
            }
            int n4 = n3;
            nArray2[n4] = nArray2[n4] | n2 << 24;
            n = 0;
            for (int i = 0; i < 24; i += 8) {
                int n5 = nArray5[n][n3];
                if ((n5 /= n2) > 255) {
                    n5 = 255;
                }
                int n6 = n3;
                nArray2[n6] = nArray2[n6] | n5 << i;
                ++n;
            }
        }
    }

    private static void rescaleBandRow(int[] nArray, int[] nArray2) {
        int n = nArray.length;
        int n2 = nArray2.length;
        int n3 = 0;
        int n4 = n2;
        for (int i = 0; i < nArray2.length; ++i) {
            int n5 = 0;
            int n6 = n;
            while (n4 <= n6) {
                n5 += n4 * nArray[n3];
                n6 -= n4;
                n4 = n2;
                ++n3;
            }
            if (n6 > 0) {
                n5 += n6 * nArray[n3];
            }
            n4 -= n6;
            nArray2[i] = (n5 + (n - 1) / 2) / n;
        }
    }

    private static int rot(int n, int n2) {
        return n << n2 | n >> 32 - n2;
    }

    public static int rehash1(int n) {
        n += Integer.MIN_VALUE;
        int n2 = 0 - ImageUtil.rot(Integer.MIN_VALUE, 14);
        n ^= n2;
        int n3 = Integer.MIN_VALUE ^ (n -= ImageUtil.rot(n2, 11));
        n2 ^= (n3 -= ImageUtil.rot(n, 25));
        n ^= (n2 -= ImageUtil.rot(n3, 16));
        n3 ^= (n -= ImageUtil.rot(n2, 4));
        n2 ^= (n3 -= ImageUtil.rot(n, 14));
        return n2 -= ImageUtil.rot(n3, 24);
    }

    public ImageUtil(String string, char c, char c2) {
        this.letters = string;
        this.inputChar = c;
        this.displayChar = c2;
    }

    public int hashCode() {
        int n = 31 + this.displayChar;
        n = n * 31 + this.inputChar;
        n = n * 31 + (this.letters == null ? 0 : this.letters.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (ImageUtil)object;
        if (this.displayChar != ((ImageUtil)object).displayChar) {
            return false;
        }
        if (this.inputChar != ((ImageUtil)object).inputChar) {
            return false;
        }
        return !(this.letters == null ? ((ImageUtil)object).letters != null : !this.letters.equals(((ImageUtil)object).letters));
    }

    public static enum ScaleStrategy {
        SYSTEM_SMOOTH,
        CUSTOM_SMOOTH,
        SMART_INTERP,
        FAST_INTERP;

    }
}

