/*
 * Decompiled with CFR 0.152.
 */
package com.beekeeper.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JPanel;

public class GridHelper
extends GridBagConstraints {
    private GridLocation location;
    private Container container;
    private int motion = 2;
    private Color borderColor;
    private Color ltBorderColor;
    private boolean debug = false;
    private static boolean defaultDebug = false;
    private static float nextHue = 0.0f;

    public GridHelper(Container object) {
        super(0, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0);
        this.container = object;
        this.location = new GridLocation(0, 0);
        ((Container)object).setLayout(new GridBagLayout());
        object = GridHelper.class;
        synchronized (GridHelper.class) {
            this.ltBorderColor = Color.getHSBColor(nextHue, 1.0f, 1.0f);
            nextHue = (float)((double)nextHue + 0.357);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.borderColor = this.ltBorderColor.darker();
            return;
        }
    }

    public GridHelper() {
        this(new JPanel());
        GridHelper gridHelper = this;
        ((JPanel)gridHelper.container).setOpaque(false);
    }

    public final Container getContainer() {
        return this.container;
    }

    private GridHelper(GridHelper gridHelper) {
        super(0, 0, gridHelper.gridwidth, gridHelper.gridheight, gridHelper.weightx, gridHelper.weighty, gridHelper.anchor, gridHelper.fill, (Insets)gridHelper.insets.clone(), gridHelper.ipadx, gridHelper.ipady);
        this.container = gridHelper.container;
        this.location = gridHelper.location;
        this.motion = gridHelper.motion;
        this.debug = gridHelper.debug;
        this.borderColor = gridHelper.borderColor;
        this.ltBorderColor = gridHelper.ltBorderColor;
    }

    public final GridHelper add(Component component) {
        this.gridx = this.location.x;
        this.gridy = this.location.y;
        if (this.debug) {
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add(component, "Center");
            jPanel.setBorder(BorderFactory.createBevelBorder(0, this.ltBorderColor, this.borderColor));
            component = jPanel;
        }
        this.container.add(component, this);
        if (this.motion == 1 || this.motion == 2) {
            this.location.x += this.gridwidth;
        }
        if (this.motion == 1 || this.motion == 3) {
            this.location.y += this.gridheight;
        }
        return this;
    }

    public final GridHelper space(int n, double d) {
        if (n == 0 && d == 0.0) {
            if (this.motion == 1 || this.motion == 2) {
                this.location.x += this.gridwidth;
            }
            if (this.motion == 1 || this.motion == 3) {
                this.location.y += this.gridheight;
            }
        } else if (this.motion == 2) {
            this.weight(d, 0.0).add(Box.createHorizontalStrut(n));
        } else {
            this.weight(0.0, d).add(Box.createVerticalStrut(n));
        }
        return this;
    }

    public final GridHelper space() {
        return this.space(0, 0.0);
    }

    public final GridHelper space(int n) {
        return this.space(n, 0.0);
    }

    public final GridHelper stretch() {
        return this.space(0, 1.0);
    }

    public final GridHelper advance(int n, double d) {
        if (this.motion == 1) {
            throw new IllegalArgumentException("Can't advance with motion = BOTH");
        }
        if (this.motion == 2) {
            if (n > 0 || d > 0.0) {
                this.weight(0.0, d).add(Box.createVerticalStrut(n));
            }
            ++this.location.y;
            this.location.x = 0;
        } else {
            if (n > 0 || d > 0.0) {
                this.weight(d, 0.0).add(Box.createHorizontalStrut(n));
            }
            this.location.y = 0;
            ++this.location.x;
        }
        return this;
    }

    public final GridHelper advance() {
        return this.advance(0, 0.0);
    }

    public final GridHelper advance(int n) {
        return this.advance(n, 0.0);
    }

    public final GridHelper pos(int n, int n2) {
        this.location.x = n;
        this.location.y = n2;
        return this;
    }

    public final GridHelper size(int n, int n2) {
        int n3 = n2;
        n2 = n;
        GridHelper gridHelper = new GridHelper(this);
        new GridHelper(this).gridwidth = n2;
        gridHelper.gridheight = n3;
        return gridHelper;
    }

    private GridHelper mWeight(double d, double d2) {
        this.weightx = d;
        this.weighty = d2;
        return this;
    }

    public final GridHelper weight(double d, double d2) {
        return new GridHelper(this).mWeight(d, d2);
    }

    public final GridHelper anchor(int n) {
        int n2 = n;
        GridHelper gridHelper = new GridHelper(this);
        new GridHelper(this).anchor = n2;
        return gridHelper;
    }

    public final GridHelper fill(int n) {
        int n2 = n;
        GridHelper gridHelper = new GridHelper(this);
        new GridHelper(this).fill = n2;
        return gridHelper;
    }

    public final GridHelper motion(int n) {
        int n2 = 3;
        GridHelper gridHelper = new GridHelper(this);
        new GridHelper(this).motion = n2;
        return gridHelper;
    }

    public static final class GridLocation {
        int y = 0;
        int x = 0;

        public GridLocation(int n, int n2) {
        }
    }
}

