/*
 * Decompiled with CFR 0.152.
 */
package com.beekeeper.util;

import com.beekeeper.gui.BrowseButton;
import com.beekeeper.util.CompatibilityUtil;
import com.beekeeper.util.GridHelper;
import com.beekeeper.util.ImageUtil;
import com.beekeeper.util.SpaceBreakIterator;
import com.beekeeper.util.SystemUtil;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.FocusManager;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;

public final class GUIUtil {
    private static final int[] ICON_SIZES = new int[]{128, 48, 32, 24, 16};
    static Border outer = BorderFactory.createEmptyBorder(0, 0, 8, 0);

    public static void packDialog(JDialog jDialog, Component component, boolean bl) {
        jDialog.pack();
        jDialog.setResizable(false);
        jDialog.setLocationRelativeTo(component);
    }

    public static void showInDialog(Component component, String string, Component component2, ActionListener actionListener, boolean bl) {
        Object object;
        Component component3;
        block14: {
            boolean bl2;
            component3 = component;
            if (component3 == null) {
                component3 = JOptionPane.getRootFrame();
            } else {
                while (!(component3 instanceof JApplet) && component3.getParent() != null) {
                    component3 = component3.getParent();
                }
            }
            Dimension dimension = component2.getPreferredSize();
            Object object2 = component3.getSize();
            boolean bl3 = bl2 = dimension.width < ((Dimension)object2).width && dimension.height < ((Dimension)object2).height;
            if (component3 instanceof JApplet && bl2 && CompatibilityUtil.HAS_1_4_FEATURES) {
                try {
                    Object object3 = (RootPaneContainer)((Object)component3);
                    object = object3.getGlassPane();
                    PoppableEventQueue poppableEventQueue = EventQueue.isDispatchThread() ? new PoppableEventQueue() : null;
                    if (poppableEventQueue != null) {
                        Toolkit.getDefaultToolkit().getSystemEventQueue();
                    }
                    Object object4 = new Object();
                    AtomicBoolean atomicBoolean = new AtomicBoolean(false);
                    JInternalFrame jInternalFrame = new JInternalFrame(string, false, true, false, false);
                    jInternalFrame.getContentPane().add(component2);
                    jInternalFrame.addInternalFrameListener(new InternalFrameAdapter(actionListener){
                        private /* synthetic */ ActionListener val$closeAction;
                        {
                            this.val$closeAction = actionListener;
                        }

                        @Override
                        public final void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                            this.val$closeAction.actionPerformed(new ActionEvent(internalFrameEvent.getSource(), 0, ""));
                        }
                    });
                    component2.addComponentListener(new ComponentAdapter(jInternalFrame, (RootPaneContainer)object3, (Component)object, poppableEventQueue, object4, atomicBoolean){
                        private /* synthetic */ JInternalFrame val$dialog;
                        private /* synthetic */ RootPaneContainer val$trueRoot;
                        private /* synthetic */ Component val$oldGlassPane;
                        private /* synthetic */ PoppableEventQueue val$newQueue;
                        private /* synthetic */ Object val$syncable;
                        private /* synthetic */ AtomicBoolean val$complete;
                        {
                            this.val$dialog = jInternalFrame;
                            this.val$trueRoot = rootPaneContainer;
                            this.val$oldGlassPane = component;
                            this.val$newQueue = poppableEventQueue;
                            this.val$syncable = object;
                            this.val$complete = atomicBoolean;
                        }

                        @Override
                        public final void componentHidden(ComponentEvent object) {
                            this.val$dialog.setVisible(false);
                            this.val$dialog.dispose();
                            this.val$trueRoot.setGlassPane(this.val$oldGlassPane);
                            if (this.val$newQueue != null) {
                                this.val$newQueue.pop();
                            }
                            object = this.val$syncable;
                            synchronized (object) {
                                this.val$complete.set(true);
                                this.val$syncable.notify();
                                return;
                            }
                        }
                    });
                    jInternalFrame.pack();
                    object = jInternalFrame.getSize();
                    if (((Dimension)object).width >= ((Dimension)object2).width || ((Dimension)object).height >= ((Dimension)object2).height) break block14;
                    object2 = new MouseAdapter(){

                        @Override
                        public final void mousePressed(MouseEvent mouseEvent) {
                            mouseEvent.consume();
                        }

                        @Override
                        public final void mouseReleased(MouseEvent mouseEvent) {
                            mouseEvent.consume();
                        }

                        @Override
                        public final void mouseClicked(MouseEvent mouseEvent) {
                            mouseEvent.consume();
                        }
                    };
                    object = new MouseMotionAdapter(){

                        @Override
                        public final void mouseDragged(MouseEvent mouseEvent) {
                            mouseEvent.consume();
                        }

                        @Override
                        public final void mouseMoved(MouseEvent mouseEvent) {
                            mouseEvent.consume();
                        }
                    };
                    KeyAdapter keyAdapter = new KeyAdapter(){

                        @Override
                        public final void keyPressed(KeyEvent keyEvent) {
                            keyEvent.consume();
                        }

                        @Override
                        public final void keyReleased(KeyEvent keyEvent) {
                            keyEvent.consume();
                        }

                        @Override
                        public final void keyTyped(KeyEvent keyEvent) {
                            keyEvent.consume();
                        }
                    };
                    Component component4 = FocusManager.getCurrentManager().getFocusOwner();
                    JPanel jPanel = new JPanel(null);
                    object3.setGlassPane(jPanel);
                    jPanel.setOpaque(false);
                    jPanel.setVisible(true);
                    jPanel.addMouseListener((MouseListener)object2);
                    jPanel.addMouseMotionListener((MouseMotionListener)object);
                    jPanel.addKeyListener(keyAdapter);
                    jPanel.add(jInternalFrame);
                    object3 = component.getLocationOnScreen();
                    object2 = component.getSize();
                    object = jPanel.getLocationOnScreen();
                    ((Point)object3).translate(-((Point)object).x, -((Point)object).y);
                    ((Point)object3).translate(((Dimension)object2).width / 2, ((Dimension)object2).height / 2);
                    ((Point)object3).translate(-jInternalFrame.getWidth() / 2, -jInternalFrame.getHeight() / 2);
                    jInternalFrame.setLocation((Point)object3);
                    jInternalFrame.setVisible(true);
                    if (poppableEventQueue != null) {
                        Toolkit.getDefaultToolkit().getSystemEventQueue().push(poppableEventQueue);
                    }
                    object3 = object4;
                    synchronized (object3) {
                        while (!atomicBoolean.get()) {
                            try {
                                object4.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    component4.requestFocus();
                    return;
                }
                catch (RuntimeException runtimeException) {
                    RuntimeException runtimeException2 = runtimeException;
                    runtimeException.printStackTrace();
                }
            }
        }
        JDialog jDialog = component3 instanceof Dialog ? new JDialog((Dialog)component3, string, true) : new JDialog(JOptionPane.getFrameForComponent(component), string, true);
        jDialog.getContentPane().add(component2);
        jDialog.addWindowListener(new WindowAdapter(actionListener){
            private /* synthetic */ ActionListener val$closeAction;
            {
                this.val$closeAction = actionListener;
            }

            @Override
            public final void windowClosing(WindowEvent windowEvent) {
                this.val$closeAction.actionPerformed(new ActionEvent(windowEvent.getSource(), 0, ""));
            }
        });
        object = jDialog;
        component2.addComponentListener(new ComponentAdapter((JDialog)object){
            private /* synthetic */ JDialog val$dd;
            {
                this.val$dd = jDialog;
            }

            @Override
            public final void componentHidden(ComponentEvent componentEvent) {
                this.val$dd.dispose();
            }
        });
        jDialog.pack();
        jDialog.setResizable(false);
        jDialog.setLocationRelativeTo(component);
        jDialog.setVisible(true);
    }

    private static void setWindowIcons(Window window, Class<?> clazz, String ... object) {
        try {
            Object object2;
            ArrayList<Object> arrayList = new ArrayList<Object>(((String[])object).length);
            for (String string : object) {
                try {
                    object2 = clazz.getResource(string);
                    if (object2 == null) {
                        throw new IllegalArgumentException("Unknown resource: " + string);
                    }
                    arrayList.add(ImageIO.read((URL)object2));
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
            if (arrayList.size() == 1) {
                object = (BufferedImage)arrayList.get(0);
                int n = Math.max(((BufferedImage)object).getWidth(), ((BufferedImage)object).getHeight());
                for (int i = 0; i < ICON_SIZES.length; ++i) {
                    int n2 = ICON_SIZES[i];
                    if (n2 >= n) continue;
                    object2 = ImageUtil.scaleBufferedImage((BufferedImage)object, n2 * ((BufferedImage)object).getWidth() / n, n2 * ((BufferedImage)object).getHeight() / n, ImageUtil.ScaleStrategy.CUSTOM_SMOOTH);
                    arrayList.add(object2);
                }
            }
            window.setIconImages(arrayList);
            return;
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return;
        }
    }

    public static void showStackTraceDialog(Component component, Throwable throwable) {
        try {
            Appendable appendable = new StringWriter();
            throwable.printStackTrace(new PrintWriter((Writer)appendable));
            ((StringWriter)appendable).close();
            appendable = ((StringWriter)appendable).getBuffer();
            StringBuffer stringBuffer = new StringBuffer("<html><pre>");
            int n = ((StringBuffer)appendable).length();
            for (int i = 0; i < n; ++i) {
                char c = ((StringBuffer)appendable).charAt(i);
                if (c == '\r') continue;
                if (c == '\n') {
                    stringBuffer.append("<br>");
                    continue;
                }
                if (c == '\t') {
                    stringBuffer.append("    ");
                    continue;
                }
                stringBuffer.append(c);
            }
            stringBuffer.append("</pre></html>");
            JOptionPane.showMessageDialog(component, stringBuffer.toString(), "Error", 0);
            return;
        }
        catch (Throwable throwable2) {
            throw new RuntimeException(throwable);
        }
    }

    public static Graphics2D setHighQualityHints(Graphics graphics) {
        graphics = (Graphics2D)graphics;
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        if (CompatibilityUtil.HAS_1_4_FEATURES) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        } else {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        }
        return graphics;
    }

    public static void initGUI(JFrame jFrame, Class<?> clazz, String ... stringArray) {
        Object object;
        try {
            object = UIManager.getSystemLookAndFeelClassName();
            UIManager.setLookAndFeel((String)object);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (SystemUtil.isMacintosh()) {
            BrowseButton.setUseAWTChooser(true);
        }
        GUIUtil.setWindowIcons(jFrame, clazz, stringArray);
        object = jFrame;
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler((Component)object){
            private /* synthetic */ Component val$component;
            {
                this.val$component = component;
            }

            @Override
            public final void uncaughtException(Thread thread, Throwable throwable) {
                GUIUtil.showStackTraceDialog(this.val$component, throwable);
            }
        });
    }

    public static JPanel createButtonBox(AbstractButton ... abstractButtonArray) {
        GridHelper gridHelper;
        JPanel jPanel = new JPanel();
        GridHelper gridHelper2 = gridHelper = new GridHelper(jPanel);
        gridHelper.space(0, 1.0);
        for (int i = 0; i < abstractButtonArray.length; ++i) {
            if (i != 0) {
                int n = 5;
                gridHelper2 = gridHelper;
                gridHelper2.space(n, 0.0);
            }
            gridHelper.add(abstractButtonArray[i]);
        }
        return jPanel;
    }

    public static JButton makeButton(String object, ActionListener actionListener) {
        object = new JButton((String)object);
        ((AbstractButton)object).addActionListener(actionListener);
        return object;
    }

    public static ButtonGroup groupButtons(AbstractButton ... abstractButtonArray) {
        ButtonGroup buttonGroup = new ButtonGroup();
        for (AbstractButton abstractButton : abstractButtonArray) {
            buttonGroup.add(abstractButton);
        }
        return buttonGroup;
    }

    public static void centerDialog(JDialog jDialog) {
        JDialog jDialog2 = jDialog;
        jDialog2.setLocationRelativeTo(jDialog2.getOwner());
    }

    public static void operationDialog(Component component, String runtimeExceptionArray, String object, Runnable runnable) {
        object = new JOptionPane(object, 1, -1, null, new Object[0]);
        component = ((JOptionPane)object).createDialog(component, (String)runtimeExceptionArray);
        runtimeExceptionArray = new RuntimeException[1];
        object = new Thread(runnable, runtimeExceptionArray, (JDialog)component){
            private /* synthetic */ Runnable val$op;
            private /* synthetic */ RuntimeException[] val$excep;
            private /* synthetic */ JDialog val$dialog;
            {
                this.val$op = runnable;
                this.val$excep = runtimeExceptionArray;
                this.val$dialog = jDialog;
            }

            @Override
            public final void run() {
                try {
                    this.val$op.run();
                }
                catch (RuntimeException runtimeException) {
                    this.val$excep[0] = runtimeException;
                }
                catch (Throwable throwable) {
                    this.val$excep[0] = new RuntimeException(throwable);
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
                while (!this.val$dialog.isShowing()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.val$dialog.dispose();
            }
        };
        ((Thread)object).start();
        ((Dialog)component).setVisible(true);
        if (runtimeExceptionArray[0] != null) {
            throw runtimeExceptionArray[0];
        }
    }

    public static float getTrueFontHeight(Graphics graphics, Font font) {
        return GUIUtil.getTrueFontHeight(graphics, font, "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789");
    }

    public static float getTrueFontHeight(Graphics object, Font object2, String string) {
        object = (Graphics2D)object;
        object = ((Graphics2D)object).getFontRenderContext();
        object = ((Font)object2).createGlyphVector((FontRenderContext)object, string);
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < string.length(); ++i) {
            double d5;
            GlyphMetrics glyphMetrics = ((GlyphVector)object).getGlyphMetrics(i);
            object2 = glyphMetrics.getBounds2D();
            double d6 = ((RectangularShape)object2).getY();
            double d7 = d6 + ((RectangularShape)object2).getHeight();
            if (d5 < d6) {
                double d8 = d7;
                d7 = d6;
                d6 = d8;
            }
            if (d7 < 0.0) {
                d7 = 0.0;
            }
            if (d6 > 0.0) {
                d6 = 0.0;
            }
            d = Math.max(d7, d);
            d2 = Math.min(d6, d2);
            d4 += d6;
            d3 += d7;
        }
        double d9 = d3 > -d4 ? d - d4 * 1.5 / (double)string.length() : -(d2 - d3 * 1.5 / (double)string.length());
        return (float)d9;
    }

    public static int doTextWrapping(Graphics2D graphics2D, Font font, String string, int n, FontRenderContext fontRenderContext, FontMetrics fontMetrics, int n2) {
        return GUIUtil.doTextWrapping(false, 0, 0, graphics2D, font, string, n, fontRenderContext, fontMetrics, n2);
    }

    public static int doTextWrapping(int n, int n2, Graphics2D graphics2D, Font font, String string, int n3, FontRenderContext fontRenderContext, FontMetrics fontMetrics, int n4) {
        return GUIUtil.doTextWrapping(true, n, n2, graphics2D, font, string, n3, fontRenderContext, fontMetrics, n4);
    }

    public static int textWrapFontHeight(Font font, Graphics graphics, FontMetrics fontMetrics) {
        if (fontMetrics == null) {
            fontMetrics = graphics.getFontMetrics(font);
        }
        int n = fontMetrics.getAscent();
        int n2 = fontMetrics.getDescent();
        int n3 = fontMetrics.getLeading();
        return n += (n2 + n3) / 2;
    }

    private static int doTextWrapping(boolean bl, int n, int n2, Graphics2D graphics2D, Font object, String string, int n3, FontRenderContext object2, FontMetrics fontMetrics, int n4) {
        int n5;
        if (object2 == null) {
            object2 = graphics2D.getFontRenderContext();
        }
        if (fontMetrics == null) {
            fontMetrics = graphics2D.getFontMetrics((Font)object);
        }
        int n6 = fontMetrics.getAscent();
        if (n4 == -1) {
            n5 = fontMetrics.getDescent();
            int n7 = fontMetrics.getLeading();
            n4 = n6 + (n5 + n7) / 2;
        }
        if (string.length() == 0) {
            return n4;
        }
        n5 = 0;
        AttributedString attributedString = new AttributedString(string);
        attributedString.addAttribute(TextAttribute.FONT, object);
        object = new LineBreakMeasurer(attributedString.getIterator(), new SpaceBreakIterator(), (FontRenderContext)object2);
        while (((LineBreakMeasurer)object).getPosition() < string.length()) {
            object2 = ((LineBreakMeasurer)object).nextLayout(n3);
            if (bl) {
                ((TextLayout)object2).draw(graphics2D, n, n5 + n2 + n6);
            }
            n5 += n4;
        }
        return n5;
    }

    public static final class PoppableEventQueue
    extends EventQueue {
        @Override
        public final void pop() throws EmptyStackException {
            super.pop();
        }
    }

    public static final class RightLabel
    extends JLabel {
        public RightLabel(String string) {
            super(string, 4);
        }
    }

    public static final class DialogHeaderLabel
    extends JLabel {
        public DialogHeaderLabel(String string) {
            super(string);
            DialogHeaderLabel dialogHeaderLabel = this;
            dialogHeaderLabel.setFont(dialogHeaderLabel.getFont().deriveFont(1));
            if (this.getBorder() != null) {
                this.setBorder(BorderFactory.createCompoundBorder(outer, this.getBorder()));
                return;
            }
            this.setBorder(outer);
        }
    }

    public static class SelectAllFocusAdapter
    extends FocusAdapter {
        @Override
        public void focusGained(FocusEvent serializable) {
            serializable = serializable.getComponent();
            ((JTextComponent)serializable).selectAll();
        }
    }

    public static final class FileNameExtensionFilter
    extends FileFilter {
        private final String[] exts;
        private final String filterDesc;

        public FileNameExtensionFilter(String string, String ... stringArray) {
            this.filterDesc = string;
            this.exts = stringArray;
        }

        @Override
        public final boolean accept(File file) {
            if (file == null) {
                return false;
            }
            if (file.isDirectory()) {
                return true;
            }
            for (int i = 0; i < this.exts.length; ++i) {
                int n;
                String string = file.getName();
                String string2 = this.exts[i];
                int n2 = string.length();
                if (n2 <= (n = string2.length()) || string.charAt(n2 - n - 1) != '.' || !string.substring(n2 - n).equalsIgnoreCase(string2)) continue;
                return true;
            }
            return false;
        }

        @Override
        public final String getDescription() {
            return this.filterDesc;
        }
    }
}

