/*
 * Decompiled with CFR 0.152.
 */
package com.beekeeper.util;

import com.beekeeper.util.GUIUtil;
import com.beekeeper.util.ImageUtil;
import com.beekeeper.util.SystemUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.table.TableModel;

public final class DPIUtil {
    private static final JLabel LABEL = new JLabel("This is a great test");
    private static final JTextField FIELD = new JTextField("Testing");
    public static final boolean RESCALED = SystemUtil.isWindows() && LABEL.getFont().getSize() > 12;
    public static final double ESTIMATED_SCALING = RESCALED ? (double)LABEL.getFont().getSize() / 12.0 : 1.0;

    public static class JTable
    extends javax.swing.JTable {
        private JComponent[] sizeModels = new JComponent[]{LABEL};

        public final JTable setSizeModels(JComponent ... jComponentArray) {
            this.sizeModels = jComponentArray;
            if (this.isShowing()) {
                this.initSize();
            }
            return this;
        }

        private void initSize() {
            if (RESCALED) {
                JTable jTable = this;
                jTable.setRowHeight(Arrays.stream(jTable.sizeModels).mapToInt(jComponent -> jComponent.getPreferredSize().height).reduce(16, Integer::max));
            }
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.initSize();
        }

        public JTable() {
        }

        public JTable(TableModel tableModel) {
            super(tableModel);
        }
    }

    public static final class JTextArea
    extends javax.swing.JTextArea {
        public JTextArea(String string, int n, int n2) {
            super(string, 3, n2);
            this.setFont(FIELD.getFont());
        }
    }

    public static final class ImageIcon
    extends javax.swing.ImageIcon {
        public ImageIcon(URL uRL) {
            super(uRL);
        }

        @Override
        public final int getIconWidth() {
            int n = super.getIconWidth();
            if (!RESCALED) {
                return n;
            }
            if (n < 0) {
                return n;
            }
            return (int)((double)n * ESTIMATED_SCALING + 0.5);
        }

        @Override
        public final int getIconHeight() {
            int n = super.getIconHeight();
            if (!RESCALED) {
                return n;
            }
            if (n < 0) {
                return n;
            }
            return (int)((double)n * ESTIMATED_SCALING + 0.5);
        }

        @Override
        public final Image getImage() {
            Image image = super.getImage();
            if (image == null || !RESCALED) {
                return image;
            }
            int n = this.getIconHeight();
            int n2 = this.getIconWidth();
            image = ImageUtil.buffered(image);
            return ImageUtil.scaleBufferedImage((BufferedImage)image, n2, n, ImageUtil.ScaleStrategy.SMART_INTERP);
        }

        @Override
        public final synchronized void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (!RESCALED) {
                super.paintIcon(component, graphics, n, n2);
                return;
            }
            graphics = (Graphics2D)graphics.create();
            GUIUtil.setHighQualityHints(graphics);
            ((Graphics2D)graphics).translate(n, n2);
            double d = ESTIMATED_SCALING;
            ((Graphics2D)graphics).scale(d, d);
            super.paintIcon(component, graphics, 0, 0);
        }
    }
}

