/*
 * Copyright (c) 2017, 2025 Arm Limited.
 *
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
#ifndef ACL_TESTS_FRAMEWORK_FIXTURE_H
#define ACL_TESTS_FRAMEWORK_FIXTURE_H

namespace arm_compute
{
namespace test
{
namespace framework
{
/** Abstract fixture class.
 *
 * All custom fixtures have to inherit from this class.
 */
class Fixture
{
public:
    /** Setup function.
     *
     * This function is only invoked by non-data fixture test cases. Fixture
     * data test cases implement a setup function with arguments matching the
     * dataset.
     *
     * The function is called before the test case is executed.
     */
    void setup(){};

    /** Teardown function.
     *
     * The function is called after the test case finished.
     */
    void teardown(){};

protected:
    Fixture()          = default;
    virtual ~Fixture() = default;
};
} // namespace framework
} // namespace test
} // namespace arm_compute
#endif // ACL_TESTS_FRAMEWORK_FIXTURE_H
