/*
 * Copyright (c) 2025-2026 Arm Limited.
 *
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
#pragma once

#if defined(ARM_COMPUTE_ENABLE_SVE) && defined(__aarch64__)
template<>
void MergeResults<3, 8, true>(
    uint32_t *out_ptr,
    const uint32_t * in_ptr,
    const int ldout,
    const int y0, const int ymax,
    const int x0, const int xmax,
    const uint32_t *bias,
    Activation,
    bool accumulate)
{

    size_t rows = ymax-y0;
    size_t cols = xmax-x0;

    out_ptr += (y0 * ldout) + x0;
    bias = (bias == nullptr) ? nullptr : bias + x0;

    __asm__ __volatile__(
      "ptrue p8.b\n"
      "cbz %x[cols], 52f\n"
      "cbz %x[rows], 52f\n"
      "mov x12, #0x20\n"
      "mul x12, %x[ldout], x12\n"
      "cbnz %x[accumulate], 34f\n"
      "1:"  // Initial: Row loop
      "cmp %x[rows], #0x7\n"
      "bgt 30f\n"
      "beq 26f\n"
      "cmp %x[rows], #0x5\n"
      "bgt 22f\n"
      "beq 18f\n"
      "cmp %x[rows], #0x3\n"
      "bgt 14f\n"
      "beq 10f\n"
      "cmp %x[rows], #0x1\n"
      "bgt 6f\n"
      "mov x11, %x[cols]\n"
      "mov x10, %x[out_ptr]\n"
      "mov x9, %x[bias]\n"
      "3:"  // Initial: Height 1: Block loop
      "mov x21, #0\n"
      "addvl x20, %x[in_ptr], #16\n"
      "whilelt p2.s, x21, x11\n"
      "incw x21\n"
      "whilelt p1.s, x21, x11\n"
      "incw x21\n"
      "whilelt p0.s, x21, x11\n"
      "incw x21\n"
      "cbnz %x[bias], 4f\n"
      "mov z21.b, #0\n"
      "mov z20.b, #0\n"
      "mov z19.b, #0\n"
      "b 5f\n"
      "4:"  // Initial: Height 1: Width 3: bias
      "ld1w { z21.s }, p2/Z, [x9]\n"
      "ld1w { z20.s }, p1/Z, [x9, #1, MUL VL]\n"
      "ld1w { z19.s }, p0/Z, [x9, #2, MUL VL]\n"
      "5:"  // Initial: Height 1: Width 3: init done
      "decw x11, ALL, MUL #3\n"
      "ld1w { z18.s }, p2/Z, [%x[in_ptr]]\n"
      "ld1w { z17.s }, p1/Z, [%x[in_ptr], #1, MUL VL]\n"
      "incb x9, ALL, MUL #3\n"
      "ld1w { z16.s }, p0/Z, [%x[in_ptr], #2, MUL VL]\n"
      "addvl %x[in_ptr], %x[in_ptr], #24\n"
      "cmp x11, XZR\n"
      "add z18.s, z18.s, z21.s\n"
      "add z17.s, z17.s, z20.s\n"
      "st1w { z18.s }, p2, [x10]\n"
      "add z16.s, z16.s, z19.s\n"
      "st1w { z17.s }, p1, [x10, #1, MUL VL]\n"
      "st1w { z16.s }, p0, [x10, #2, MUL VL]\n"
      "incb x10, ALL, MUL #3\n"
      "bgt 3b\n"
      "b 52f\n"
      "6:"  // Initial: Height 2
      "mov x10, %x[out_ptr]\n"
      "mov x11, %x[cols]\n"
      "mov x9, %x[bias]\n"
      "add x28, x10, %x[ldout], LSL #2\n"
      "7:"  // Initial: Height 2: Block loop
      "mov x21, #0\n"
      "addvl x20, %x[in_ptr], #16\n"
      "whilelt p2.s, x21, x11\n"
      "incw x21\n"
      "whilelt p1.s, x21, x11\n"
      "incw x21\n"
      "whilelt p0.s, x21, x11\n"
      "incw x21\n"
      "cbnz %x[bias], 8f\n"
      "mov z24.b, #0\n"
      "mov z23.b, #0\n"
      "mov z22.b, #0\n"
      "b 9f\n"
      "8:"  // Initial: Height 2: Width 3: bias
      "ld1w { z24.s }, p2/Z, [x9]\n"
      "ld1w { z23.s }, p1/Z, [x9, #1, MUL VL]\n"
      "ld1w { z22.s }, p0/Z, [x9, #2, MUL VL]\n"
      "9:"  // Initial: Height 2: Width 3: init done
      "decw x11, ALL, MUL #3\n"
      "ld1w { z21.s }, p2/Z, [%x[in_ptr]]\n"
      "ld1w { z20.s }, p1/Z, [%x[in_ptr], #1, MUL VL]\n"
      "incb x9, ALL, MUL #3\n"
      "ld1w { z19.s }, p0/Z, [%x[in_ptr], #2, MUL VL]\n"
      "ld1w { z18.s }, p2/Z, [%x[in_ptr], #3, MUL VL]\n"
      "ld1w { z17.s }, p1/Z, [%x[in_ptr], #4, MUL VL]\n"
      "ld1w { z16.s }, p0/Z, [%x[in_ptr], #5, MUL VL]\n"
      "addvl %x[in_ptr], %x[in_ptr], #24\n"
      "cmp x11, XZR\n"
      "add z21.s, z21.s, z24.s\n"
      "add z20.s, z20.s, z23.s\n"
      "add z19.s, z19.s, z22.s\n"
      "add z18.s, z18.s, z24.s\n"
      "add z17.s, z17.s, z23.s\n"
      "add z16.s, z16.s, z22.s\n"
      "st1w { z21.s }, p2, [x10]\n"
      "st1w { z20.s }, p1, [x10, #1, MUL VL]\n"
      "st1w { z19.s }, p0, [x10, #2, MUL VL]\n"
      "incb x10, ALL, MUL #3\n"
      "st1w { z18.s }, p2, [x28]\n"
      "st1w { z17.s }, p1, [x28, #1, MUL VL]\n"
      "st1w { z16.s }, p0, [x28, #2, MUL VL]\n"
      "incb x28, ALL, MUL #3\n"
      "bgt 7b\n"
      "b 52f\n"
      "10:"  // Initial: Height 3
      "mov x10, %x[out_ptr]\n"
      "mov x11, %x[cols]\n"
      "mov x9, %x[bias]\n"
      "add x28, x10, %x[ldout], LSL #2\n"
      "add x27, x28, %x[ldout], LSL #2\n"
      "11:"  // Initial: Height 3: Block loop
      "mov x21, #0\n"
      "addvl x20, %x[in_ptr], #16\n"
      "whilelt p2.s, x21, x11\n"
      "incw x21\n"
      "whilelt p1.s, x21, x11\n"
      "incw x21\n"
      "whilelt p0.s, x21, x11\n"
      "incw x21\n"
      "cbnz %x[bias], 12f\n"
      "mov z27.b, #0\n"
      "mov z26.b, #0\n"
      "mov z25.b, #0\n"
      "b 13f\n"
      "12:"  // Initial: Height 3: Width 3: bias
      "ld1w { z27.s }, p2/Z, [x9]\n"
      "ld1w { z26.s }, p1/Z, [x9, #1, MUL VL]\n"
      "ld1w { z25.s }, p0/Z, [x9, #2, MUL VL]\n"
      "13:"  // Initial: Height 3: Width 3: init done
      "decw x11, ALL, MUL #3\n"
      "ld1w { z24.s }, p2/Z, [%x[in_ptr]]\n"
      "ld1w { z23.s }, p1/Z, [%x[in_ptr], #1, MUL VL]\n"
      "incb x9, ALL, MUL #3\n"
      "ld1w { z22.s }, p0/Z, [%x[in_ptr], #2, MUL VL]\n"
      "ld1w { z21.s }, p2/Z, [%x[in_ptr], #3, MUL VL]\n"
      "ld1w { z20.s }, p1/Z, [%x[in_ptr], #4, MUL VL]\n"
      "ld1w { z19.s }, p0/Z, [%x[in_ptr], #5, MUL VL]\n"
      "ld1w { z18.s }, p2/Z, [%x[in_ptr], #6, MUL VL]\n"
      "ld1w { z17.s }, p1/Z, [%x[in_ptr], #7, MUL VL]\n"
      "cmp x11, XZR\n"
      "add z24.s, z24.s, z27.s\n"
      "ld1w { z16.s }, p0/Z, [x20, #-8, MUL VL]\n"
      "add z23.s, z23.s, z26.s\n"
      "add z22.s, z22.s, z25.s\n"
      "addvl %x[in_ptr], %x[in_ptr], #24\n"
      "add z21.s, z21.s, z27.s\n"
      "add z20.s, z20.s, z26.s\n"
      "st1w { z24.s }, p2, [x10]\n"
      "add z19.s, z19.s, z25.s\n"
      "add z18.s, z18.s, z27.s\n"
      "st1w { z23.s }, p1, [x10, #1, MUL VL]\n"
      "st1w { z22.s }, p0, [x10, #2, MUL VL]\n"
      "add z17.s, z17.s, z26.s\n"
      "add z16.s, z16.s, z25.s\n"
      "incb x10, ALL, MUL #3\n"
      "st1w { z21.s }, p2, [x28]\n"
      "st1w { z20.s }, p1, [x28, #1, MUL VL]\n"
      "st1w { z19.s }, p0, [x28, #2, MUL VL]\n"
      "incb x28, ALL, MUL #3\n"
      "st1w { z18.s }, p2, [x27]\n"
      "st1w { z17.s }, p1, [x27, #1, MUL VL]\n"
      "st1w { z16.s }, p0, [x27, #2, MUL VL]\n"
      "incb x27, ALL, MUL #3\n"
      "bgt 11b\n"
      "b 52f\n"
      "14:"  // Initial: Height 4
      "mov x10, %x[out_ptr]\n"
      "mov x11, %x[cols]\n"
      "mov x9, %x[bias]\n"
      "add x28, x10, %x[ldout], LSL #2\n"
      "add x27, x28, %x[ldout], LSL #2\n"
      "add x26, x27, %x[ldout], LSL #2\n"
      "15:"  // Initial: Height 4: Block loop
      "mov x21, #0\n"
      "addvl x20, %x[in_ptr], #16\n"
      "whilelt p2.s, x21, x11\n"
      "incw x21\n"
      "whilelt p1.s, x21, x11\n"
      "incw x21\n"
      "whilelt p0.s, x21, x11\n"
      "incw x21\n"
      "cbnz %x[bias], 16f\n"
      "mov z30.b, #0\n"
      "mov z29.b, #0\n"
      "mov z28.b, #0\n"
      "b 17f\n"
      "16:"  // Initial: Height 4: Width 3: bias
      "ld1w { z30.s }, p2/Z, [x9]\n"
      "ld1w { z29.s }, p1/Z, [x9, #1, MUL VL]\n"
      "ld1w { z28.s }, p0/Z, [x9, #2, MUL VL]\n"
      "17:"  // Initial: Height 4: Width 3: init done
      "decw x11, ALL, MUL #3\n"
      "ld1w { z27.s }, p2/Z, [%x[in_ptr]]\n"
      "ld1w { z26.s }, p1/Z, [%x[in_ptr], #1, MUL VL]\n"
      "incb x9, ALL, MUL #3\n"
      "ld1w { z25.s }, p0/Z, [%x[in_ptr], #2, MUL VL]\n"
      "ld1w { z24.s }, p2/Z, [%x[in_ptr], #3, MUL VL]\n"
      "ld1w { z23.s }, p1/Z, [%x[in_ptr], #4, MUL VL]\n"
      "ld1w { z22.s }, p0/Z, [%x[in_ptr], #5, MUL VL]\n"
      "ld1w { z21.s }, p2/Z, [%x[in_ptr], #6, MUL VL]\n"
      "ld1w { z20.s }, p1/Z, [%x[in_ptr], #7, MUL VL]\n"
      "cmp x11, XZR\n"
      "add z27.s, z27.s, z30.s\n"
      "ld1w { z19.s }, p0/Z, [x20, #-8, MUL VL]\n"
      "ld1w { z18.s }, p2/Z, [x20, #-7, MUL VL]\n"
      "add z26.s, z26.s, z29.s\n"
      "add z25.s, z25.s, z28.s\n"
      "ld1w { z17.s }, p1/Z, [x20, #-6, MUL VL]\n"
      "ld1w { z16.s }, p0/Z, [x20, #-5, MUL VL]\n"
      "add z24.s, z24.s, z30.s\n"
      "add z23.s, z23.s, z29.s\n"
      "st1w { z27.s }, p2, [x10]\n"
      "add z22.s, z22.s, z28.s\n"
      "add z21.s, z21.s, z30.s\n"
      "addvl %x[in_ptr], %x[in_ptr], #24\n"
      "st1w { z26.s }, p1, [x10, #1, MUL VL]\n"
      "add z20.s, z20.s, z29.s\n"
      "add z19.s, z19.s, z28.s\n"
      "st1w { z25.s }, p0, [x10, #2, MUL VL]\n"
      "add z18.s, z18.s, z30.s\n"
      "add z17.s, z17.s, z29.s\n"
      "incb x10, ALL, MUL #3\n"
      "st1w { z24.s }, p2, [x28]\n"
      "add z16.s, z16.s, z28.s\n"
      "st1w { z23.s }, p1, [x28, #1, MUL VL]\n"
      "st1w { z22.s }, p0, [x28, #2, MUL VL]\n"
      "incb x28, ALL, MUL #3\n"
      "st1w { z21.s }, p2, [x27]\n"
      "st1w { z20.s }, p1, [x27, #1, MUL VL]\n"
      "st1w { z19.s }, p0, [x27, #2, MUL VL]\n"
      "incb x27, ALL, MUL #3\n"
      "st1w { z18.s }, p2, [x26]\n"
      "st1w { z17.s }, p1, [x26, #1, MUL VL]\n"
      "st1w { z16.s }, p0, [x26, #2, MUL VL]\n"
      "incb x26, ALL, MUL #3\n"
      "bgt 15b\n"
      "b 52f\n"
      "18:"  // Initial: Height 5
      "mov x10, %x[out_ptr]\n"
      "mov x11, %x[cols]\n"
      "mov x9, %x[bias]\n"
      "add x28, x10, %x[ldout], LSL #2\n"
      "add x27, x28, %x[ldout], LSL #2\n"
      "add x26, x27, %x[ldout], LSL #2\n"
      "add x25, x26, %x[ldout], LSL #2\n"
      "19:"  // Initial: Height 5: Block loop
      "mov x21, #0\n"
      "addvl x20, %x[in_ptr], #16\n"
      "whilelt p2.s, x21, x11\n"
      "incw x21\n"
      "whilelt p1.s, x21, x11\n"
      "incw x21\n"
      "whilelt p0.s, x21, x11\n"
      "incw x21\n"
      "cbnz %x[bias], 20f\n"
      "mov z0.b, #0\n"
      "mov z31.b, #0\n"
      "mov z30.b, #0\n"
      "b 21f\n"
      "20:"  // Initial: Height 5: Width 3: bias
      "ld1w { z0.s }, p2/Z, [x9]\n"
      "ld1w { z31.s }, p1/Z, [x9, #1, MUL VL]\n"
      "ld1w { z30.s }, p0/Z, [x9, #2, MUL VL]\n"
      "21:"  // Initial: Height 5: Width 3: init done
      "decw x11, ALL, MUL #3\n"
      "ld1w { z16.s }, p2/Z, [%x[in_ptr]]\n"
      "ld1w { z29.s }, p1/Z, [%x[in_ptr], #1, MUL VL]\n"
      "incb x9, ALL, MUL #3\n"
      "ld1w { z28.s }, p0/Z, [%x[in_ptr], #2, MUL VL]\n"
      "ld1w { z27.s }, p2/Z, [%x[in_ptr], #3, MUL VL]\n"
      "ld1w { z26.s }, p1/Z, [%x[in_ptr], #4, MUL VL]\n"
      "ld1w { z25.s }, p0/Z, [%x[in_ptr], #5, MUL VL]\n"
      "ld1w { z24.s }, p2/Z, [%x[in_ptr], #6, MUL VL]\n"
      "ld1w { z23.s }, p1/Z, [%x[in_ptr], #7, MUL VL]\n"
      "cmp x11, XZR\n"
      "add z16.s, z16.s, z0.s\n"
      "ld1w { z22.s }, p0/Z, [x20, #-8, MUL VL]\n"
      "ld1w { z21.s }, p2/Z, [x20, #-7, MUL VL]\n"
      "add z29.s, z29.s, z31.s\n"
      "add z28.s, z28.s, z30.s\n"
      "ld1w { z20.s }, p1/Z, [x20, #-6, MUL VL]\n"
      "ld1w { z19.s }, p0/Z, [x20, #-5, MUL VL]\n"
      "add z27.s, z27.s, z0.s\n"
      "add z26.s, z26.s, z31.s\n"
      "ld1w { z18.s }, p2/Z, [x20, #-4, MUL VL]\n"
      "ld1w { z17.s }, p1/Z, [x20, #-3, MUL VL]\n"
      "st1w { z16.s }, p2, [x10]\n"
      "add z25.s, z25.s, z30.s\n"
      "ld1w { z16.s }, p0/Z, [x20, #-2, MUL VL]\n"
      "st1w { z29.s }, p1, [x10, #1, MUL VL]\n"
      "add z24.s, z24.s, z0.s\n"
      "add z23.s, z23.s, z31.s\n"
      "st1w { z28.s }, p0, [x10, #2, MUL VL]\n"
      "add z22.s, z22.s, z30.s\n"
      "add z21.s, z21.s, z0.s\n"
      "incb x10, ALL, MUL #3\n"
      "st1w { z27.s }, p2, [x28]\n"
      "add z20.s, z20.s, z31.s\n"
      "add z19.s, z19.s, z30.s\n"
      "addvl %x[in_ptr], %x[in_ptr], #24\n"
      "st1w { z26.s }, p1, [x28, #1, MUL VL]\n"
      "add z18.s, z18.s, z0.s\n"
      "add z17.s, z17.s, z31.s\n"
      "st1w { z25.s }, p0, [x28, #2, MUL VL]\n"
      "add z16.s, z16.s, z30.s\n"
      "incb x28, ALL, MUL #3\n"
      "st1w { z24.s }, p2, [x27]\n"
      "st1w { z23.s }, p1, [x27, #1, MUL VL]\n"
      "st1w { z22.s }, p0, [x27, #2, MUL VL]\n"
      "incb x27, ALL, MUL #3\n"
      "st1w { z21.s }, p2, [x26]\n"
      "st1w { z20.s }, p1, [x26, #1, MUL VL]\n"
      "st1w { z19.s }, p0, [x26, #2, MUL VL]\n"
      "incb x26, ALL, MUL #3\n"
      "st1w { z18.s }, p2, [x25]\n"
      "st1w { z17.s }, p1, [x25, #1, MUL VL]\n"
      "st1w { z16.s }, p0, [x25, #2, MUL VL]\n"
      "incb x25, ALL, MUL #3\n"
      "bgt 19b\n"
      "b 52f\n"
      "22:"  // Initial: Height 6
      "mov x10, %x[out_ptr]\n"
      "mov x11, %x[cols]\n"
      "mov x9, %x[bias]\n"
      "add x28, x10, %x[ldout], LSL #2\n"
      "add x27, x28, %x[ldout], LSL #2\n"
      "add x26, x27, %x[ldout], LSL #2\n"
      "add x25, x26, %x[ldout], LSL #2\n"
      "add x24, x25, %x[ldout], LSL #2\n"
      "23:"  // Initial: Height 6: Block loop
      "mov x21, #0\n"
      "addvl x20, %x[in_ptr], #16\n"
      "whilelt p2.s, x21, x11\n"
      "incw x21\n"
      "whilelt p1.s, x21, x11\n"
      "incw x21\n"
      "whilelt p0.s, x21, x11\n"
      "incw x21\n"
      "cbnz %x[bias], 24f\n"
      "mov z2.b, #0\n"
      "mov z1.b, #0\n"
      "mov z0.b, #0\n"
      "b 25f\n"
      "24:"  // Initial: Height 6: Width 3: bias
      "ld1w { z2.s }, p2/Z, [x9]\n"
      "ld1w { z1.s }, p1/Z, [x9, #1, MUL VL]\n"
      "ld1w { z0.s }, p0/Z, [x9, #2, MUL VL]\n"
      "25:"  // Initial: Height 6: Width 3: init done
      "decw x11, ALL, MUL #3\n"
      "ld1w { z17.s }, p2/Z, [%x[in_ptr]]\n"
      "ld1w { z16.s }, p1/Z, [%x[in_ptr], #1, MUL VL]\n"
      "incb x9, ALL, MUL #3\n"
      "ld1w { z31.s }, p0/Z, [%x[in_ptr], #2, MUL VL]\n"
      "ld1w { z30.s }, p2/Z, [%x[in_ptr], #3, MUL VL]\n"
      "ld1w { z29.s }, p1/Z, [%x[in_ptr], #4, MUL VL]\n"
      "ld1w { z28.s }, p0/Z, [%x[in_ptr], #5, MUL VL]\n"
      "ld1w { z27.s }, p2/Z, [%x[in_ptr], #6, MUL VL]\n"
      "ld1w { z26.s }, p1/Z, [%x[in_ptr], #7, MUL VL]\n"
      "cmp x11, XZR\n"
      "add z17.s, z17.s, z2.s\n"
      "ld1w { z25.s }, p0/Z, [x20, #-8, MUL VL]\n"
      "ld1w { z24.s }, p2/Z, [x20, #-7, MUL VL]\n"
      "add z16.s, z16.s, z1.s\n"
      "add z31.s, z31.s, z0.s\n"
      "ld1w { z23.s }, p1/Z, [x20, #-6, MUL VL]\n"
      "ld1w { z22.s }, p0/Z, [x20, #-5, MUL VL]\n"
      "add z30.s, z30.s, z2.s\n"
      "add z29.s, z29.s, z1.s\n"
      "ld1w { z21.s }, p2/Z, [x20, #-4, MUL VL]\n"
      "ld1w { z20.s }, p1/Z, [x20, #-3, MUL VL]\n"
      "st1w { z17.s }, p2, [x10]\n"
      "add z28.s, z28.s, z0.s\n"
      "ld1w { z19.s }, p0/Z, [x20, #-2, MUL VL]\n"
      "ld1w { z18.s }, p2/Z, [x20, #-1, MUL VL]\n"
      "st1w { z16.s }, p1, [x10, #1, MUL VL]\n"
      "add z27.s, z27.s, z2.s\n"
      "ld1w { z17.s }, p1/Z, [x20]\n"
      "ld1w { z16.s }, p0/Z, [x20, #1, MUL VL]\n"
      "st1w { z31.s }, p0, [x10, #2, MUL VL]\n"
      "add z26.s, z26.s, z1.s\n"
      "st1w { z30.s }, p2, [x28]\n"
      "add z25.s, z25.s, z0.s\n"
      "add z24.s, z24.s, z2.s\n"
      "incb x10, ALL, MUL #3\n"
      "st1w { z29.s }, p1, [x28, #1, MUL VL]\n"
      "add z23.s, z23.s, z1.s\n"
      "add z22.s, z22.s, z0.s\n"
      "addvl %x[in_ptr], %x[in_ptr], #24\n"
      "st1w { z28.s }, p0, [x28, #2, MUL VL]\n"
      "add z21.s, z21.s, z2.s\n"
      "add z20.s, z20.s, z1.s\n"
      "incb x28, ALL, MUL #3\n"
      "st1w { z27.s }, p2, [x27]\n"
      "add z19.s, z19.s, z0.s\n"
      "add z18.s, z18.s, z2.s\n"
      "st1w { z26.s }, p1, [x27, #1, MUL VL]\n"
      "add z17.s, z17.s, z1.s\n"
      "add z16.s, z16.s, z0.s\n"
      "st1w { z25.s }, p0, [x27, #2, MUL VL]\n"
      "incb x27, ALL, MUL #3\n"
      "st1w { z24.s }, p2, [x26]\n"
      "st1w { z23.s }, p1, [x26, #1, MUL VL]\n"
      "st1w { z22.s }, p0, [x26, #2, MUL VL]\n"
      "incb x26, ALL, MUL #3\n"
      "st1w { z21.s }, p2, [x25]\n"
      "st1w { z20.s }, p1, [x25, #1, MUL VL]\n"
      "st1w { z19.s }, p0, [x25, #2, MUL VL]\n"
      "incb x25, ALL, MUL #3\n"
      "st1w { z18.s }, p2, [x24]\n"
      "st1w { z17.s }, p1, [x24, #1, MUL VL]\n"
      "st1w { z16.s }, p0, [x24, #2, MUL VL]\n"
      "incb x24, ALL, MUL #3\n"
      "bgt 23b\n"
      "b 52f\n"
      "26:"  // Initial: Height 7
      "mov x10, %x[out_ptr]\n"
      "mov x11, %x[cols]\n"
      "mov x9, %x[bias]\n"
      "add x28, x10, %x[ldout], LSL #2\n"
      "add x27, x28, %x[ldout], LSL #2\n"
      "add x26, x27, %x[ldout], LSL #2\n"
      "add x25, x26, %x[ldout], LSL #2\n"
      "add x24, x25, %x[ldout], LSL #2\n"
      "add x23, x24, %x[ldout], LSL #2\n"
      "27:"  // Initial: Height 7: Block loop
      "mov x21, #0\n"
      "addvl x20, %x[in_ptr], #16\n"
      "whilelt p2.s, x21, x11\n"
      "incw x21\n"
      "whilelt p1.s, x21, x11\n"
      "incw x21\n"
      "whilelt p0.s, x21, x11\n"
      "incw x21\n"
      "cbnz %x[bias], 28f\n"
      "mov z3.b, #0\n"
      "mov z2.b, #0\n"
      "mov z1.b, #0\n"
      "b 29f\n"
      "28:"  // Initial: Height 7: Width 3: bias
      "ld1w { z3.s }, p2/Z, [x9]\n"
      "ld1w { z2.s }, p1/Z, [x9, #1, MUL VL]\n"
      "ld1w { z1.s }, p0/Z, [x9, #2, MUL VL]\n"
      "29:"  // Initial: Height 7: Width 3: init done
      "decw x11, ALL, MUL #3\n"
      "ld1w { z19.s }, p2/Z, [%x[in_ptr]]\n"
      "ld1w { z18.s }, p1/Z, [%x[in_ptr], #1, MUL VL]\n"
      "incb x9, ALL, MUL #3\n"
      "ld1w { z17.s }, p0/Z, [%x[in_ptr], #2, MUL VL]\n"
      "ld1w { z16.s }, p2/Z, [%x[in_ptr], #3, MUL VL]\n"
      "ld1w { z0.s }, p1/Z, [%x[in_ptr], #4, MUL VL]\n"
      "ld1w { z31.s }, p0/Z, [%x[in_ptr], #5, MUL VL]\n"
      "ld1w { z30.s }, p2/Z, [%x[in_ptr], #6, MUL VL]\n"
      "ld1w { z29.s }, p1/Z, [%x[in_ptr], #7, MUL VL]\n"
      "cmp x11, XZR\n"
      "add z19.s, z19.s, z3.s\n"
      "ld1w { z28.s }, p0/Z, [x20, #-8, MUL VL]\n"
      "ld1w { z27.s }, p2/Z, [x20, #-7, MUL VL]\n"
      "add z18.s, z18.s, z2.s\n"
      "add z17.s, z17.s, z1.s\n"
      "ld1w { z26.s }, p1/Z, [x20, #-6, MUL VL]\n"
      "ld1w { z25.s }, p0/Z, [x20, #-5, MUL VL]\n"
      "add z16.s, z16.s, z3.s\n"
      "add z0.s, z0.s, z2.s\n"
      "ld1w { z24.s }, p2/Z, [x20, #-4, MUL VL]\n"
      "ld1w { z23.s }, p1/Z, [x20, #-3, MUL VL]\n"
      "st1w { z19.s }, p2, [x10]\n"
      "add z31.s, z31.s, z1.s\n"
      "ld1w { z22.s }, p0/Z, [x20, #-2, MUL VL]\n"
      "ld1w { z21.s }, p2/Z, [x20, #-1, MUL VL]\n"
      "st1w { z18.s }, p1, [x10, #1, MUL VL]\n"
      "add z30.s, z30.s, z3.s\n"
      "ld1w { z20.s }, p1/Z, [x20]\n"
      "ld1w { z19.s }, p0/Z, [x20, #1, MUL VL]\n"
      "st1w { z17.s }, p0, [x10, #2, MUL VL]\n"
      "add z29.s, z29.s, z2.s\n"
      "ld1w { z18.s }, p2/Z, [x20, #2, MUL VL]\n"
      "ld1w { z17.s }, p1/Z, [x20, #3, MUL VL]\n"
      "st1w { z16.s }, p2, [x28]\n"
      "add z28.s, z28.s, z1.s\n"
      "ld1w { z16.s }, p0/Z, [x20, #4, MUL VL]\n"
      "st1w { z0.s }, p1, [x28, #1, MUL VL]\n"
      "add z27.s, z27.s, z3.s\n"
      "add z26.s, z26.s, z2.s\n"
      "st1w { z31.s }, p0, [x28, #2, MUL VL]\n"
      "add z25.s, z25.s, z1.s\n"
      "add z24.s, z24.s, z3.s\n"
      "incb x10, ALL, MUL #3\n"
      "st1w { z30.s }, p2, [x27]\n"
      "add z23.s, z23.s, z2.s\n"
      "add z22.s, z22.s, z1.s\n"
      "incb x28, ALL, MUL #3\n"
      "st1w { z29.s }, p1, [x27, #1, MUL VL]\n"
      "add z21.s, z21.s, z3.s\n"
      "add z20.s, z20.s, z2.s\n"
      "addvl %x[in_ptr], %x[in_ptr], #24\n"
      "st1w { z28.s }, p0, [x27, #2, MUL VL]\n"
      "add z19.s, z19.s, z1.s\n"
      "add z18.s, z18.s, z3.s\n"
      "incb x27, ALL, MUL #3\n"
      "st1w { z27.s }, p2, [x26]\n"
      "add z17.s, z17.s, z2.s\n"
      "add z16.s, z16.s, z1.s\n"
      "st1w { z26.s }, p1, [x26, #1, MUL VL]\n"
      "st1w { z25.s }, p0, [x26, #2, MUL VL]\n"
      "incb x26, ALL, MUL #3\n"
      "st1w { z24.s }, p2, [x25]\n"
      "st1w { z23.s }, p1, [x25, #1, MUL VL]\n"
      "st1w { z22.s }, p0, [x25, #2, MUL VL]\n"
      "incb x25, ALL, MUL #3\n"
      "st1w { z21.s }, p2, [x24]\n"
      "st1w { z20.s }, p1, [x24, #1, MUL VL]\n"
      "st1w { z19.s }, p0, [x24, #2, MUL VL]\n"
      "incb x24, ALL, MUL #3\n"
      "st1w { z18.s }, p2, [x23]\n"
      "st1w { z17.s }, p1, [x23, #1, MUL VL]\n"
      "st1w { z16.s }, p0, [x23, #2, MUL VL]\n"
      "incb x23, ALL, MUL #3\n"
      "bgt 27b\n"
      "b 52f\n"
      "30:"  // Initial: Height 8
      "mov x10, %x[out_ptr]\n"
      "mov x11, %x[cols]\n"
      "mov x9, %x[bias]\n"
      "add x28, x10, %x[ldout], LSL #2\n"
      "add x27, x28, %x[ldout], LSL #2\n"
      "add x26, x27, %x[ldout], LSL #2\n"
      "add x25, x26, %x[ldout], LSL #2\n"
      "add x24, x25, %x[ldout], LSL #2\n"
      "add x23, x24, %x[ldout], LSL #2\n"
      "add x22, x23, %x[ldout], LSL #2\n"
      "31:"  // Initial: Height 8: Block loop
      "mov x21, #0\n"
      "addvl x20, %x[in_ptr], #16\n"
      "whilelt p2.s, x21, x11\n"
      "incw x21\n"
      "whilelt p1.s, x21, x11\n"
      "incw x21\n"
      "whilelt p0.s, x21, x11\n"
      "incw x21\n"
      "cbnz %x[bias], 32f\n"
      "mov z5.b, #0\n"
      "mov z4.b, #0\n"
      "mov z3.b, #0\n"
      "b 33f\n"
      "32:"  // Initial: Height 8: Width 3: bias
      "ld1w { z5.s }, p2/Z, [x9]\n"
      "ld1w { z4.s }, p1/Z, [x9, #1, MUL VL]\n"
      "ld1w { z3.s }, p0/Z, [x9, #2, MUL VL]\n"
      "33:"  // Initial: Height 8: Width 3: init done
      "decw x11, ALL, MUL #3\n"
      "ld1w { z20.s }, p2/Z, [%x[in_ptr]]\n"
      "ld1w { z19.s }, p1/Z, [%x[in_ptr], #1, MUL VL]\n"
      "incb x9, ALL, MUL #3\n"
      "ld1w { z18.s }, p0/Z, [%x[in_ptr], #2, MUL VL]\n"
      "ld1w { z17.s }, p2/Z, [%x[in_ptr], #3, MUL VL]\n"
      "ld1w { z16.s }, p1/Z, [%x[in_ptr], #4, MUL VL]\n"
      "ld1w { z2.s }, p0/Z, [%x[in_ptr], #5, MUL VL]\n"
      "ld1w { z1.s }, p2/Z, [%x[in_ptr], #6, MUL VL]\n"
      "ld1w { z0.s }, p1/Z, [%x[in_ptr], #7, MUL VL]\n"
      "cmp x11, XZR\n"
      "add z20.s, z20.s, z5.s\n"
      "ld1w { z31.s }, p0/Z, [x20, #-8, MUL VL]\n"
      "ld1w { z30.s }, p2/Z, [x20, #-7, MUL VL]\n"
      "add z19.s, z19.s, z4.s\n"
      "add z18.s, z18.s, z3.s\n"
      "ld1w { z29.s }, p1/Z, [x20, #-6, MUL VL]\n"
      "ld1w { z28.s }, p0/Z, [x20, #-5, MUL VL]\n"
      "add z17.s, z17.s, z5.s\n"
      "add z16.s, z16.s, z4.s\n"
      "ld1w { z27.s }, p2/Z, [x20, #-4, MUL VL]\n"
      "ld1w { z26.s }, p1/Z, [x20, #-3, MUL VL]\n"
      "st1w { z20.s }, p2, [x10]\n"
      "add z2.s, z2.s, z3.s\n"
      "ld1w { z25.s }, p0/Z, [x20, #-2, MUL VL]\n"
      "ld1w { z24.s }, p2/Z, [x20, #-1, MUL VL]\n"
      "st1w { z19.s }, p1, [x10, #1, MUL VL]\n"
      "add z1.s, z1.s, z5.s\n"
      "ld1w { z23.s }, p1/Z, [x20]\n"
      "ld1w { z22.s }, p0/Z, [x20, #1, MUL VL]\n"
      "st1w { z18.s }, p0, [x10, #2, MUL VL]\n"
      "add z0.s, z0.s, z4.s\n"
      "ld1w { z21.s }, p2/Z, [x20, #2, MUL VL]\n"
      "ld1w { z20.s }, p1/Z, [x20, #3, MUL VL]\n"
      "st1w { z17.s }, p2, [x28]\n"
      "add z31.s, z31.s, z3.s\n"
      "ld1w { z19.s }, p0/Z, [x20, #4, MUL VL]\n"
      "ld1w { z18.s }, p2/Z, [x20, #5, MUL VL]\n"
      "st1w { z16.s }, p1, [x28, #1, MUL VL]\n"
      "add z30.s, z30.s, z5.s\n"
      "ld1w { z17.s }, p1/Z, [x20, #6, MUL VL]\n"
      "ld1w { z16.s }, p0/Z, [x20, #7, MUL VL]\n"
      "st1w { z2.s }, p0, [x28, #2, MUL VL]\n"
      "add z29.s, z29.s, z4.s\n"
      "st1w { z1.s }, p2, [x27]\n"
      "add z28.s, z28.s, z3.s\n"
      "add z27.s, z27.s, z5.s\n"
      "incb x10, ALL, MUL #3\n"
      "st1w { z0.s }, p1, [x27, #1, MUL VL]\n"
      "add z26.s, z26.s, z4.s\n"
      "add z25.s, z25.s, z3.s\n"
      "incb x28, ALL, MUL #3\n"
      "st1w { z31.s }, p0, [x27, #2, MUL VL]\n"
      "add z24.s, z24.s, z5.s\n"
      "add z23.s, z23.s, z4.s\n"
      "incb x27, ALL, MUL #3\n"
      "st1w { z30.s }, p2, [x26]\n"
      "add z22.s, z22.s, z3.s\n"
      "add z21.s, z21.s, z5.s\n"
      "addvl %x[in_ptr], %x[in_ptr], #24\n"
      "st1w { z29.s }, p1, [x26, #1, MUL VL]\n"
      "add z20.s, z20.s, z4.s\n"
      "add z19.s, z19.s, z3.s\n"
      "st1w { z28.s }, p0, [x26, #2, MUL VL]\n"
      "add z18.s, z18.s, z5.s\n"
      "add z17.s, z17.s, z4.s\n"
      "incb x26, ALL, MUL #3\n"
      "st1w { z27.s }, p2, [x25]\n"
      "add z16.s, z16.s, z3.s\n"
      "st1w { z26.s }, p1, [x25, #1, MUL VL]\n"
      "st1w { z25.s }, p0, [x25, #2, MUL VL]\n"
      "incb x25, ALL, MUL #3\n"
      "st1w { z24.s }, p2, [x24]\n"
      "st1w { z23.s }, p1, [x24, #1, MUL VL]\n"
      "st1w { z22.s }, p0, [x24, #2, MUL VL]\n"
      "incb x24, ALL, MUL #3\n"
      "st1w { z21.s }, p2, [x23]\n"
      "st1w { z20.s }, p1, [x23, #1, MUL VL]\n"
      "st1w { z19.s }, p0, [x23, #2, MUL VL]\n"
      "incb x23, ALL, MUL #3\n"
      "st1w { z18.s }, p2, [x22]\n"
      "st1w { z17.s }, p1, [x22, #1, MUL VL]\n"
      "st1w { z16.s }, p0, [x22, #2, MUL VL]\n"
      "incb x22, ALL, MUL #3\n"
      "bgt 31b\n"
      "subs %x[rows], %x[rows], #0x8\n"
      "add %x[out_ptr], %x[out_ptr], x12\n"
      "bgt 1b\n"
      "b 52f\n"
      "34:"  // Accumulate
      "35:"  // Accumulate: Row loop
      "cmp %x[rows], #0x7\n"
      "bgt 50f\n"
      "beq 48f\n"
      "cmp %x[rows], #0x5\n"
      "bgt 46f\n"
      "beq 44f\n"
      "cmp %x[rows], #0x3\n"
      "bgt 42f\n"
      "beq 40f\n"
      "cmp %x[rows], #0x1\n"
      "bgt 38f\n"
      "mov x11, %x[cols]\n"
      "mov x10, %x[out_ptr]\n"
      "37:"  // Accumulate: Height 1: Block loop
      "mov x21, #0\n"
      "addvl x20, %x[in_ptr], #16\n"
      "whilelt p0.s, x21, x11\n"
      "incw x21\n"
      "ld1w { z17.s }, p0/Z, [%x[in_ptr]]\n"
      "ld1w { z16.s }, p0/Z, [x10]\n"
      "whilelt p1.s, x21, x11\n"
      "add z17.s, z17.s, z16.s\n"
      "incw x21\n"
      "st1w { z17.s }, p0, [x10]\n"
      "ld1w { z18.s }, p1/Z, [%x[in_ptr], #1, MUL VL]\n"
      "ld1w { z16.s }, p1/Z, [x10, #1, MUL VL]\n"
      "whilelt p0.s, x21, x11\n"
      "decw x11, ALL, MUL #3\n"
      "incw x21\n"
      "add z18.s, z18.s, z16.s\n"
      "ld1w { z17.s }, p0/Z, [%x[in_ptr], #2, MUL VL]\n"
      "addvl %x[in_ptr], %x[in_ptr], #24\n"
      "cmp x11, XZR\n"
      "st1w { z18.s }, p1, [x10, #1, MUL VL]\n"
      "ld1w { z16.s }, p0/Z, [x10, #2, MUL VL]\n"
      "add z17.s, z17.s, z16.s\n"
      "st1w { z17.s }, p0, [x10, #2, MUL VL]\n"
      "incb x10, ALL, MUL #3\n"
      "bgt 37b\n"
      "b 52f\n"
      "38:"  // Accumulate: Height 2
      "mov x10, %x[out_ptr]\n"
      "mov x11, %x[cols]\n"
      "add x28, x10, %x[ldout], LSL #2\n"
      "39:"  // Accumulate: Height 2: Block loop
      "mov x21, #0\n"
      "addvl x20, %x[in_ptr], #16\n"
      "whilelt p0.s, x21, x11\n"
      "incw x21\n"
      "ld1w { z19.s }, p0/Z, [%x[in_ptr]]\n"
      "ld1w { z18.s }, p0/Z, [x10]\n"
      "ld1w { z17.s }, p0/Z, [%x[in_ptr], #3, MUL VL]\n"
      "ld1w { z16.s }, p0/Z, [x28]\n"
      "whilelt p1.s, x21, x11\n"
      "add z19.s, z19.s, z18.s\n"
      "incw x21\n"
      "st1w { z19.s }, p0, [x10]\n"
      "add z17.s, z17.s, z16.s\n"
      "ld1w { z21.s }, p1/Z, [%x[in_ptr], #1, MUL VL]\n"
      "ld1w { z20.s }, p1/Z, [%x[in_ptr], #4, MUL VL]\n"
      "st1w { z17.s }, p0, [x28]\n"
      "ld1w { z17.s }, p1/Z, [x10, #1, MUL VL]\n"
      "whilelt p0.s, x21, x11\n"
      "decw x11, ALL, MUL #3\n"
      "incw x21\n"
      "ld1w { z16.s }, p1/Z, [x28, #1, MUL VL]\n"
      "add z21.s, z21.s, z17.s\n"
      "ld1w { z19.s }, p0/Z, [%x[in_ptr], #2, MUL VL]\n"
      "ld1w { z18.s }, p0/Z, [%x[in_ptr], #5, MUL VL]\n"
      "addvl %x[in_ptr], %x[in_ptr], #24\n"
      "st1w { z21.s }, p1, [x10, #1, MUL VL]\n"
      "add z20.s, z20.s, z16.s\n"
      "cmp x11, XZR\n"
      "ld1w { z17.s }, p0/Z, [x10, #2, MUL VL]\n"
      "st1w { z20.s }, p1, [x28, #1, MUL VL]\n"
      "ld1w { z16.s }, p0/Z, [x28, #2, MUL VL]\n"
      "add z19.s, z19.s, z17.s\n"
      "st1w { z19.s }, p0, [x10, #2, MUL VL]\n"
      "incb x10, ALL, MUL #3\n"
      "add z18.s, z18.s, z16.s\n"
      "st1w { z18.s }, p0, [x28, #2, MUL VL]\n"
      "incb x28, ALL, MUL #3\n"
      "bgt 39b\n"
      "b 52f\n"
      "40:"  // Accumulate: Height 3
      "mov x10, %x[out_ptr]\n"
      "mov x11, %x[cols]\n"
      "add x28, x10, %x[ldout], LSL #2\n"
      "add x27, x28, %x[ldout], LSL #2\n"
      "41:"  // Accumulate: Height 3: Block loop
      "mov x21, #0\n"
      "addvl x20, %x[in_ptr], #16\n"
      "whilelt p0.s, x21, x11\n"
      "incw x21\n"
      "ld1w { z21.s }, p0/Z, [%x[in_ptr]]\n"
      "ld1w { z20.s }, p0/Z, [x10]\n"
      "ld1w { z19.s }, p0/Z, [%x[in_ptr], #3, MUL VL]\n"
      "ld1w { z18.s }, p0/Z, [x28]\n"
      "ld1w { z17.s }, p0/Z, [%x[in_ptr], #6, MUL VL]\n"
      "ld1w { z16.s }, p0/Z, [x27]\n"
      "whilelt p1.s, x21, x11\n"
      "add z21.s, z21.s, z20.s\n"
      "incw x21\n"
      "add z19.s, z19.s, z18.s\n"
      "st1w { z21.s }, p0, [x10]\n"
      "add z17.s, z17.s, z16.s\n"
      "ld1w { z23.s }, p1/Z, [%x[in_ptr], #1, MUL VL]\n"
      "ld1w { z22.s }, p1/Z, [%x[in_ptr], #4, MUL VL]\n"
      "ld1w { z21.s }, p1/Z, [%x[in_ptr], #7, MUL VL]\n"
      "st1w { z19.s }, p0, [x28]\n"
      "st1w { z17.s }, p0, [x27]\n"
      "ld1w { z18.s }, p1/Z, [x10, #1, MUL VL]\n"
      "whilelt p0.s, x21, x11\n"
      "decw x11, ALL, MUL #3\n"
      "incw x21\n"
      "ld1w { z17.s }, p1/Z, [x28, #1, MUL VL]\n"
      "ld1w { z16.s }, p1/Z, [x27, #1, MUL VL]\n"
      "add z23.s, z23.s, z18.s\n"
      "ld1w { z20.s }, p0/Z, [%x[in_ptr], #2, MUL VL]\n"
      "ld1w { z19.s }, p0/Z, [%x[in_ptr], #5, MUL VL]\n"
      "addvl %x[in_ptr], %x[in_ptr], #24\n"
      "ld1w { z18.s }, p0/Z, [x20, #-8, MUL VL]\n"
      "cmp x11, XZR\n"
      "st1w { z23.s }, p1, [x10, #1, MUL VL]\n"
      "add z22.s, z22.s, z17.s\n"
      "add z21.s, z21.s, z16.s\n"
      "st1w { z22.s }, p1, [x28, #1, MUL VL]\n"
      "ld1w { z16.s }, p0/Z, [x10, #2, MUL VL]\n"
      "st1w { z21.s }, p1, [x27, #1, MUL VL]\n"
      "ld1w { z17.s }, p0/Z, [x28, #2, MUL VL]\n"
      "add z20.s, z20.s, z16.s\n"
      "ld1w { z16.s }, p0/Z, [x27, #2, MUL VL]\n"
      "st1w { z20.s }, p0, [x10, #2, MUL VL]\n"
      "incb x10, ALL, MUL #3\n"
      "add z19.s, z19.s, z17.s\n"
      "add z18.s, z18.s, z16.s\n"
      "st1w { z19.s }, p0, [x28, #2, MUL VL]\n"
      "incb x28, ALL, MUL #3\n"
      "st1w { z18.s }, p0, [x27, #2, MUL VL]\n"
      "incb x27, ALL, MUL #3\n"
      "bgt 41b\n"
      "b 52f\n"
      "42:"  // Accumulate: Height 4
      "mov x10, %x[out_ptr]\n"
      "mov x11, %x[cols]\n"
      "add x28, x10, %x[ldout], LSL #2\n"
      "add x27, x28, %x[ldout], LSL #2\n"
      "add x26, x27, %x[ldout], LSL #2\n"
      "43:"  // Accumulate: Height 4: Block loop
      "mov x21, #0\n"
      "addvl x20, %x[in_ptr], #16\n"
      "whilelt p2.s, x21, x11\n"
      "incw x21\n"
      "ld1w { z23.s }, p2/Z, [%x[in_ptr]]\n"
      "ld1w { z22.s }, p2/Z, [x10]\n"
      "ld1w { z21.s }, p2/Z, [%x[in_ptr], #3, MUL VL]\n"
      "ld1w { z20.s }, p2/Z, [x28]\n"
      "ld1w { z19.s }, p2/Z, [%x[in_ptr], #6, MUL VL]\n"
      "ld1w { z18.s }, p2/Z, [x27]\n"
      "ld1w { z17.s }, p2/Z, [x20, #-7, MUL VL]\n"
      "ld1w { z16.s }, p2/Z, [x26]\n"
      "whilelt p1.s, x21, x11\n"
      "add z23.s, z23.s, z22.s\n"
      "add z21.s, z21.s, z20.s\n"
      "incw x21\n"
      "add z19.s, z19.s, z18.s\n"
      "st1w { z23.s }, p2, [x10]\n"
      "add z17.s, z17.s, z16.s\n"
      "ld1w { z26.s }, p1/Z, [%x[in_ptr], #1, MUL VL]\n"
      "ld1w { z25.s }, p1/Z, [%x[in_ptr], #4, MUL VL]\n"
      "ld1w { z24.s }, p1/Z, [%x[in_ptr], #7, MUL VL]\n"
      "ld1w { z23.s }, p1/Z, [x20, #-6, MUL VL]\n"
      "st1w { z21.s }, p2, [x28]\n"
      "st1w { z19.s }, p2, [x27]\n"
      "ld1w { z16.s }, p1/Z, [x10, #1, MUL VL]\n"
      "whilelt p0.s, x21, x11\n"
      "decw x11, ALL, MUL #3\n"
      "st1w { z17.s }, p2, [x26]\n"
      "incw x21\n"
      "ld1w { z18.s }, p1/Z, [x28, #1, MUL VL]\n"
      "ld1w { z17.s }, p1/Z, [x27, #1, MUL VL]\n"
      "add z26.s, z26.s, z16.s\n"
      "ld1w { z22.s }, p0/Z, [%x[in_ptr], #2, MUL VL]\n"
      "ld1w { z21.s }, p0/Z, [%x[in_ptr], #5, MUL VL]\n"
      "addvl %x[in_ptr], %x[in_ptr], #24\n"
      "ld1w { z20.s }, p0/Z, [x20, #-8, MUL VL]\n"
      "ld1w { z19.s }, p0/Z, [x20, #-5, MUL VL]\n"
      "cmp x11, XZR\n"
      "ld1w { z16.s }, p1/Z, [x26, #1, MUL VL]\n"
      "add z25.s, z25.s, z18.s\n"
      "add z24.s, z24.s, z17.s\n"
      "st1w { z26.s }, p1, [x10, #1, MUL VL]\n"
      "st1w { z25.s }, p1, [x28, #1, MUL VL]\n"
      "st1w { z24.s }, p1, [x27, #1, MUL VL]\n"
      "add z23.s, z23.s, z16.s\n"
      "ld1w { z18.s }, p0/Z, [x10, #2, MUL VL]\n"
      "ld1w { z16.s }, p0/Z, [x28, #2, MUL VL]\n"
      "st1w { z23.s }, p1, [x26, #1, MUL VL]\n"
      "ld1w { z17.s }, p0/Z, [x27, #2, MUL VL]\n"
      "add z22.s, z22.s, z18.s\n"
      "add z21.s, z21.s, z16.s\n"
      "ld1w { z16.s }, p0/Z, [x26, #2, MUL VL]\n"
      "st1w { z22.s }, p0, [x10, #2, MUL VL]\n"
      "incb x10, ALL, MUL #3\n"
      "st1w { z21.s }, p0, [x28, #2, MUL VL]\n"
      "incb x28, ALL, MUL #3\n"
      "add z20.s, z20.s, z17.s\n"
      "add z19.s, z19.s, z16.s\n"
      "st1w { z20.s }, p0, [x27, #2, MUL VL]\n"
      "incb x27, ALL, MUL #3\n"
      "st1w { z19.s }, p0, [x26, #2, MUL VL]\n"
      "incb x26, ALL, MUL #3\n"
      "bgt 43b\n"
      "b 52f\n"
      "44:"  // Accumulate: Height 5
      "mov x10, %x[out_ptr]\n"
      "mov x11, %x[cols]\n"
      "add x28, x10, %x[ldout], LSL #2\n"
      "add x27, x28, %x[ldout], LSL #2\n"
      "add x26, x27, %x[ldout], LSL #2\n"
      "add x25, x26, %x[ldout], LSL #2\n"
      "45:"  // Accumulate: Height 5: Block loop
      "mov x21, #0\n"
      "addvl x20, %x[in_ptr], #16\n"
      "whilelt p2.s, x21, x11\n"
      "incw x21\n"
      "ld1w { z24.s }, p2/Z, [%x[in_ptr]]\n"
      "ld1w { z16.s }, p2/Z, [x10]\n"
      "ld1w { z23.s }, p2/Z, [%x[in_ptr], #3, MUL VL]\n"
      "ld1w { z22.s }, p2/Z, [x28]\n"
      "ld1w { z21.s }, p2/Z, [%x[in_ptr], #6, MUL VL]\n"
      "ld1w { z20.s }, p2/Z, [x27]\n"
      "ld1w { z19.s }, p2/Z, [x20, #-7, MUL VL]\n"
      "ld1w { z17.s }, p2/Z, [x26]\n"
      "whilelt p1.s, x21, x11\n"
      "add z24.s, z24.s, z16.s\n"
      "ld1w { z18.s }, p2/Z, [x20, #-4, MUL VL]\n"
      "ld1w { z16.s }, p2/Z, [x25]\n"
      "add z23.s, z23.s, z22.s\n"
      "incw x21\n"
      "add z21.s, z21.s, z20.s\n"
      "st1w { z24.s }, p2, [x10]\n"
      "add z19.s, z19.s, z17.s\n"
      "ld1w { z28.s }, p1/Z, [%x[in_ptr], #1, MUL VL]\n"
      "ld1w { z27.s }, p1/Z, [%x[in_ptr], #4, MUL VL]\n"
      "ld1w { z26.s }, p1/Z, [%x[in_ptr], #7, MUL VL]\n"
      "st1w { z23.s }, p2, [x28]\n"
      "add z18.s, z18.s, z16.s\n"
      "ld1w { z25.s }, p1/Z, [x20, #-6, MUL VL]\n"
      "ld1w { z24.s }, p1/Z, [x20, #-3, MUL VL]\n"
      "whilelt p0.s, x21, x11\n"
      "decw x11, ALL, MUL #3\n"
      "st1w { z21.s }, p2, [x27]\n"
      "ld1w { z17.s }, p1/Z, [x10, #1, MUL VL]\n"
      "incw x21\n"
      "st1w { z19.s }, p2, [x26]\n"
      "ld1w { z16.s }, p1/Z, [x28, #1, MUL VL]\n"
      "st1w { z18.s }, p2, [x25]\n"
      "ld1w { z23.s }, p0/Z, [%x[in_ptr], #2, MUL VL]\n"
      "ld1w { z22.s }, p0/Z, [%x[in_ptr], #5, MUL VL]\n"
      "cmp x11, XZR\n"
      "ld1w { z18.s }, p1/Z, [x27, #1, MUL VL]\n"
      "add z28.s, z28.s, z17.s\n"
      "ld1w { z21.s }, p0/Z, [x20, #-8, MUL VL]\n"
      "addvl %x[in_ptr], %x[in_ptr], #24\n"
      "ld1w { z17.s }, p1/Z, [x26, #1, MUL VL]\n"
      "add z27.s, z27.s, z16.s\n"
      "ld1w { z20.s }, p0/Z, [x20, #-5, MUL VL]\n"
      "ld1w { z16.s }, p1/Z, [x25, #1, MUL VL]\n"
      "ld1w { z19.s }, p0/Z, [x20, #-2, MUL VL]\n"
      "st1w { z28.s }, p1, [x10, #1, MUL VL]\n"
      "add z26.s, z26.s, z18.s\n"
      "st1w { z27.s }, p1, [x28, #1, MUL VL]\n"
      "add z25.s, z25.s, z17.s\n"
      "st1w { z26.s }, p1, [x27, #1, MUL VL]\n"
      "add z24.s, z24.s, z16.s\n"
      "ld1w { z17.s }, p0/Z, [x10, #2, MUL VL]\n"
      "st1w { z25.s }, p1, [x26, #1, MUL VL]\n"
      "ld1w { z16.s }, p0/Z, [x28, #2, MUL VL]\n"
      "st1w { z24.s }, p1, [x25, #1, MUL VL]\n"
      "ld1w { z18.s }, p0/Z, [x27, #2, MUL VL]\n"
      "add z23.s, z23.s, z17.s\n"
      "ld1w { z17.s }, p0/Z, [x26, #2, MUL VL]\n"
      "add z22.s, z22.s, z16.s\n"
      "ld1w { z16.s }, p0/Z, [x25, #2, MUL VL]\n"
      "st1w { z23.s }, p0, [x10, #2, MUL VL]\n"
      "incb x10, ALL, MUL #3\n"
      "add z21.s, z21.s, z18.s\n"
      "add z20.s, z20.s, z17.s\n"
      "st1w { z22.s }, p0, [x28, #2, MUL VL]\n"
      "incb x28, ALL, MUL #3\n"
      "add z19.s, z19.s, z16.s\n"
      "st1w { z21.s }, p0, [x27, #2, MUL VL]\n"
      "incb x27, ALL, MUL #3\n"
      "st1w { z20.s }, p0, [x26, #2, MUL VL]\n"
      "incb x26, ALL, MUL #3\n"
      "st1w { z19.s }, p0, [x25, #2, MUL VL]\n"
      "incb x25, ALL, MUL #3\n"
      "bgt 45b\n"
      "b 52f\n"
      "46:"  // Accumulate: Height 6
      "mov x10, %x[out_ptr]\n"
      "mov x11, %x[cols]\n"
      "add x28, x10, %x[ldout], LSL #2\n"
      "add x27, x28, %x[ldout], LSL #2\n"
      "add x26, x27, %x[ldout], LSL #2\n"
      "add x25, x26, %x[ldout], LSL #2\n"
      "add x24, x25, %x[ldout], LSL #2\n"
      "47:"  // Accumulate: Height 6: Block loop
      "mov x21, #0\n"
      "addvl x20, %x[in_ptr], #16\n"
      "whilelt p2.s, x21, x11\n"
      "incw x21\n"
      "ld1w { z25.s }, p2/Z, [%x[in_ptr]]\n"
      "ld1w { z17.s }, p2/Z, [x10]\n"
      "ld1w { z24.s }, p2/Z, [%x[in_ptr], #3, MUL VL]\n"
      "ld1w { z16.s }, p2/Z, [x28]\n"
      "ld1w { z23.s }, p2/Z, [%x[in_ptr], #6, MUL VL]\n"
      "ld1w { z22.s }, p2/Z, [x27]\n"
      "ld1w { z21.s }, p2/Z, [x20, #-7, MUL VL]\n"
      "ld1w { z20.s }, p2/Z, [x26]\n"
      "whilelt p1.s, x21, x11\n"
      "add z25.s, z25.s, z17.s\n"
      "ld1w { z19.s }, p2/Z, [x20, #-4, MUL VL]\n"
      "ld1w { z17.s }, p2/Z, [x25]\n"
      "add z24.s, z24.s, z16.s\n"
      "incw x21\n"
      "ld1w { z18.s }, p2/Z, [x20, #-1, MUL VL]\n"
      "ld1w { z16.s }, p2/Z, [x24]\n"
      "add z23.s, z23.s, z22.s\n"
      "st1w { z25.s }, p2, [x10]\n"
      "add z21.s, z21.s, z20.s\n"
      "ld1w { z20.s }, p1/Z, [%x[in_ptr], #1, MUL VL]\n"
      "ld1w { z30.s }, p1/Z, [%x[in_ptr], #4, MUL VL]\n"
      "st1w { z24.s }, p2, [x28]\n"
      "add z19.s, z19.s, z17.s\n"
      "ld1w { z29.s }, p1/Z, [%x[in_ptr], #7, MUL VL]\n"
      "ld1w { z28.s }, p1/Z, [x20, #-6, MUL VL]\n"
      "whilelt p0.s, x21, x11\n"
      "st1w { z23.s }, p2, [x27]\n"
      "add z18.s, z18.s, z16.s\n"
      "ld1w { z17.s }, p1/Z, [x10, #1, MUL VL]\n"
      "ld1w { z27.s }, p1/Z, [x20, #-3, MUL VL]\n"
      "st1w { z21.s }, p2, [x26]\n"
      "ld1w { z16.s }, p1/Z, [x28, #1, MUL VL]\n"
      "ld1w { z26.s }, p1/Z, [x20]\n"
      "decw x11, ALL, MUL #3\n"
      "st1w { z19.s }, p2, [x25]\n"
      "ld1w { z25.s }, p0/Z, [%x[in_ptr], #2, MUL VL]\n"
      "ld1w { z24.s }, p0/Z, [%x[in_ptr], #5, MUL VL]\n"
      "incw x21\n"
      "st1w { z18.s }, p2, [x24]\n"
      "ld1w { z19.s }, p1/Z, [x27, #1, MUL VL]\n"
      "add z20.s, z20.s, z17.s\n"
      "ld1w { z23.s }, p0/Z, [x20, #-8, MUL VL]\n"
      "ld1w { z18.s }, p1/Z, [x26, #1, MUL VL]\n"
      "add z30.s, z30.s, z16.s\n"
      "ld1w { z22.s }, p0/Z, [x20, #-5, MUL VL]\n"
      "cmp x11, XZR\n"
      "ld1w { z17.s }, p1/Z, [x25, #1, MUL VL]\n"
      "ld1w { z21.s }, p0/Z, [x20, #-2, MUL VL]\n"
      "addvl %x[in_ptr], %x[in_ptr], #24\n"
      "ld1w { z16.s }, p1/Z, [x24, #1, MUL VL]\n"
      "st1w { z20.s }, p1, [x10, #1, MUL VL]\n"
      "add z29.s, z29.s, z19.s\n"
      "ld1w { z20.s }, p0/Z, [x20, #1, MUL VL]\n"
      "st1w { z30.s }, p1, [x28, #1, MUL VL]\n"
      "add z28.s, z28.s, z18.s\n"
      "add z27.s, z27.s, z17.s\n"
      "st1w { z29.s }, p1, [x27, #1, MUL VL]\n"
      "add z26.s, z26.s, z16.s\n"
      "ld1w { z17.s }, p0/Z, [x10, #2, MUL VL]\n"
      "st1w { z28.s }, p1, [x26, #1, MUL VL]\n"
      "st1w { z27.s }, p1, [x25, #1, MUL VL]\n"
      "ld1w { z16.s }, p0/Z, [x28, #2, MUL VL]\n"
      "st1w { z26.s }, p1, [x24, #1, MUL VL]\n"
      "ld1w { z19.s }, p0/Z, [x27, #2, MUL VL]\n"
      "add z25.s, z25.s, z17.s\n"
      "ld1w { z18.s }, p0/Z, [x26, #2, MUL VL]\n"
      "ld1w { z17.s }, p0/Z, [x25, #2, MUL VL]\n"
      "add z24.s, z24.s, z16.s\n"
      "ld1w { z16.s }, p0/Z, [x24, #2, MUL VL]\n"
      "st1w { z25.s }, p0, [x10, #2, MUL VL]\n"
      "incb x10, ALL, MUL #3\n"
      "add z23.s, z23.s, z19.s\n"
      "add z22.s, z22.s, z18.s\n"
      "st1w { z24.s }, p0, [x28, #2, MUL VL]\n"
      "incb x28, ALL, MUL #3\n"
      "add z21.s, z21.s, z17.s\n"
      "add z20.s, z20.s, z16.s\n"
      "st1w { z23.s }, p0, [x27, #2, MUL VL]\n"
      "incb x27, ALL, MUL #3\n"
      "st1w { z22.s }, p0, [x26, #2, MUL VL]\n"
      "incb x26, ALL, MUL #3\n"
      "st1w { z21.s }, p0, [x25, #2, MUL VL]\n"
      "incb x25, ALL, MUL #3\n"
      "st1w { z20.s }, p0, [x24, #2, MUL VL]\n"
      "incb x24, ALL, MUL #3\n"
      "bgt 47b\n"
      "b 52f\n"
      "48:"  // Accumulate: Height 7
      "mov x10, %x[out_ptr]\n"
      "mov x11, %x[cols]\n"
      "add x28, x10, %x[ldout], LSL #2\n"
      "add x27, x28, %x[ldout], LSL #2\n"
      "add x26, x27, %x[ldout], LSL #2\n"
      "add x25, x26, %x[ldout], LSL #2\n"
      "add x24, x25, %x[ldout], LSL #2\n"
      "add x23, x24, %x[ldout], LSL #2\n"
      "49:"  // Accumulate: Height 7: Block loop
      "mov x21, #0\n"
      "addvl x20, %x[in_ptr], #16\n"
      "whilelt p2.s, x21, x11\n"
      "incw x21\n"
      "ld1w { z22.s }, p2/Z, [%x[in_ptr]]\n"
      "ld1w { z18.s }, p2/Z, [x10]\n"
      "ld1w { z21.s }, p2/Z, [%x[in_ptr], #3, MUL VL]\n"
      "ld1w { z17.s }, p2/Z, [x28]\n"
      "ld1w { z26.s }, p2/Z, [%x[in_ptr], #6, MUL VL]\n"
      "ld1w { z16.s }, p2/Z, [x27]\n"
      "ld1w { z25.s }, p2/Z, [x20, #-7, MUL VL]\n"
      "ld1w { z20.s }, p2/Z, [x26]\n"
      "whilelt p1.s, x21, x11\n"
      "add z22.s, z22.s, z18.s\n"
      "ld1w { z24.s }, p2/Z, [x20, #-4, MUL VL]\n"
      "ld1w { z18.s }, p2/Z, [x25]\n"
      "add z21.s, z21.s, z17.s\n"
      "incw x21\n"
      "ld1w { z23.s }, p2/Z, [x20, #-1, MUL VL]\n"
      "ld1w { z17.s }, p2/Z, [x24]\n"
      "add z26.s, z26.s, z16.s\n"
      "ld1w { z19.s }, p2/Z, [x20, #2, MUL VL]\n"
      "ld1w { z16.s }, p2/Z, [x23]\n"
      "st1w { z22.s }, p2, [x10]\n"
      "add z25.s, z25.s, z20.s\n"
      "st1w { z21.s }, p2, [x28]\n"
      "add z24.s, z24.s, z18.s\n"
      "ld1w { z22.s }, p1/Z, [%x[in_ptr], #1, MUL VL]\n"
      "ld1w { z21.s }, p1/Z, [%x[in_ptr], #4, MUL VL]\n"
      "st1w { z26.s }, p2, [x27]\n"
      "add z23.s, z23.s, z17.s\n"
      "ld1w { z20.s }, p1/Z, [%x[in_ptr], #7, MUL VL]\n"
      "ld1w { z30.s }, p1/Z, [x20, #-6, MUL VL]\n"
      "st1w { z25.s }, p2, [x26]\n"
      "add z19.s, z19.s, z16.s\n"
      "ld1w { z18.s }, p1/Z, [x10, #1, MUL VL]\n"
      "ld1w { z29.s }, p1/Z, [x20, #-3, MUL VL]\n"
      "st1w { z24.s }, p2, [x25]\n"
      "ld1w { z17.s }, p1/Z, [x28, #1, MUL VL]\n"
      "ld1w { z28.s }, p1/Z, [x20]\n"
      "whilelt p0.s, x21, x11\n"
      "st1w { z23.s }, p2, [x24]\n"
      "ld1w { z16.s }, p1/Z, [x27, #1, MUL VL]\n"
      "ld1w { z27.s }, p1/Z, [x20, #3, MUL VL]\n"
      "decw x11, ALL, MUL #3\n"
      "st1w { z19.s }, p2, [x23]\n"
      "ld1w { z19.s }, p1/Z, [x26, #1, MUL VL]\n"
      "add z22.s, z22.s, z18.s\n"
      "incw x21\n"
      "ld1w { z18.s }, p1/Z, [x25, #1, MUL VL]\n"
      "add z21.s, z21.s, z17.s\n"
      "ld1w { z26.s }, p0/Z, [%x[in_ptr], #2, MUL VL]\n"
      "ld1w { z17.s }, p1/Z, [x24, #1, MUL VL]\n"
      "add z20.s, z20.s, z16.s\n"
      "ld1w { z25.s }, p0/Z, [%x[in_ptr], #5, MUL VL]\n"
      "cmp x11, XZR\n"
      "ld1w { z16.s }, p1/Z, [x23, #1, MUL VL]\n"
      "st1w { z22.s }, p1, [x10, #1, MUL VL]\n"
      "add z30.s, z30.s, z19.s\n"
      "ld1w { z24.s }, p0/Z, [x20, #-8, MUL VL]\n"
      "st1w { z21.s }, p1, [x28, #1, MUL VL]\n"
      "add z29.s, z29.s, z18.s\n"
      "ld1w { z23.s }, p0/Z, [x20, #-5, MUL VL]\n"
      "ld1w { z22.s }, p0/Z, [x20, #-2, MUL VL]\n"
      "st1w { z20.s }, p1, [x27, #1, MUL VL]\n"
      "add z28.s, z28.s, z17.s\n"
      "ld1w { z21.s }, p0/Z, [x20, #1, MUL VL]\n"
      "ld1w { z20.s }, p0/Z, [x20, #4, MUL VL]\n"
      "st1w { z30.s }, p1, [x26, #1, MUL VL]\n"
      "add z27.s, z27.s, z16.s\n"
      "ld1w { z18.s }, p0/Z, [x10, #2, MUL VL]\n"
      "addvl %x[in_ptr], %x[in_ptr], #24\n"
      "st1w { z29.s }, p1, [x25, #1, MUL VL]\n"
      "ld1w { z17.s }, p0/Z, [x28, #2, MUL VL]\n"
      "st1w { z28.s }, p1, [x24, #1, MUL VL]\n"
      "ld1w { z16.s }, p0/Z, [x27, #2, MUL VL]\n"
      "st1w { z27.s }, p1, [x23, #1, MUL VL]\n"
      "ld1w { z19.s }, p0/Z, [x26, #2, MUL VL]\n"
      "add z26.s, z26.s, z18.s\n"
      "ld1w { z18.s }, p0/Z, [x25, #2, MUL VL]\n"
      "add z25.s, z25.s, z17.s\n"
      "ld1w { z17.s }, p0/Z, [x24, #2, MUL VL]\n"
      "add z24.s, z24.s, z16.s\n"
      "ld1w { z16.s }, p0/Z, [x23, #2, MUL VL]\n"
      "st1w { z26.s }, p0, [x10, #2, MUL VL]\n"
      "incb x10, ALL, MUL #3\n"
      "add z23.s, z23.s, z19.s\n"
      "add z22.s, z22.s, z18.s\n"
      "st1w { z25.s }, p0, [x28, #2, MUL VL]\n"
      "incb x28, ALL, MUL #3\n"
      "st1w { z24.s }, p0, [x27, #2, MUL VL]\n"
      "add z21.s, z21.s, z17.s\n"
      "add z20.s, z20.s, z16.s\n"
      "incb x27, ALL, MUL #3\n"
      "st1w { z23.s }, p0, [x26, #2, MUL VL]\n"
      "incb x26, ALL, MUL #3\n"
      "st1w { z22.s }, p0, [x25, #2, MUL VL]\n"
      "incb x25, ALL, MUL #3\n"
      "st1w { z21.s }, p0, [x24, #2, MUL VL]\n"
      "incb x24, ALL, MUL #3\n"
      "st1w { z20.s }, p0, [x23, #2, MUL VL]\n"
      "incb x23, ALL, MUL #3\n"
      "bgt 49b\n"
      "b 52f\n"
      "50:"  // Accumulate: Height 8
      "mov x10, %x[out_ptr]\n"
      "mov x11, %x[cols]\n"
      "add x28, x10, %x[ldout], LSL #2\n"
      "add x27, x28, %x[ldout], LSL #2\n"
      "add x26, x27, %x[ldout], LSL #2\n"
      "add x25, x26, %x[ldout], LSL #2\n"
      "add x24, x25, %x[ldout], LSL #2\n"
      "add x23, x24, %x[ldout], LSL #2\n"
      "add x22, x23, %x[ldout], LSL #2\n"
      "51:"  // Accumulate: Height 8: Block loop
      "mov x21, #0\n"
      "addvl x20, %x[in_ptr], #16\n"
      "whilelt p2.s, x21, x11\n"
      "incw x21\n"
      "ld1w { z20.s }, p2/Z, [%x[in_ptr]]\n"
      "ld1w { z19.s }, p2/Z, [x10]\n"
      "ld1w { z26.s }, p2/Z, [%x[in_ptr], #3, MUL VL]\n"
      "ld1w { z18.s }, p2/Z, [x28]\n"
      "ld1w { z25.s }, p2/Z, [%x[in_ptr], #6, MUL VL]\n"
      "ld1w { z17.s }, p2/Z, [x27]\n"
      "ld1w { z24.s }, p2/Z, [x20, #-7, MUL VL]\n"
      "ld1w { z16.s }, p2/Z, [x26]\n"
      "whilelt p1.s, x21, x11\n"
      "add z20.s, z20.s, z19.s\n"
      "ld1w { z23.s }, p2/Z, [x20, #-4, MUL VL]\n"
      "ld1w { z19.s }, p2/Z, [x25]\n"
      "add z26.s, z26.s, z18.s\n"
      "incw x21\n"
      "ld1w { z22.s }, p2/Z, [x20, #-1, MUL VL]\n"
      "ld1w { z18.s }, p2/Z, [x24]\n"
      "add z25.s, z25.s, z17.s\n"
      "ld1w { z21.s }, p2/Z, [x20, #2, MUL VL]\n"
      "ld1w { z17.s }, p2/Z, [x23]\n"
      "st1w { z20.s }, p2, [x10]\n"
      "add z24.s, z24.s, z16.s\n"
      "ld1w { z20.s }, p2/Z, [x20, #5, MUL VL]\n"
      "ld1w { z16.s }, p2/Z, [x22]\n"
      "st1w { z26.s }, p2, [x28]\n"
      "add z23.s, z23.s, z19.s\n"
      "st1w { z25.s }, p2, [x27]\n"
      "add z22.s, z22.s, z18.s\n"
      "ld1w { z26.s }, p1/Z, [%x[in_ptr], #1, MUL VL]\n"
      "ld1w { z25.s }, p1/Z, [%x[in_ptr], #4, MUL VL]\n"
      "st1w { z24.s }, p2, [x26]\n"
      "add z21.s, z21.s, z17.s\n"
      "ld1w { z19.s }, p1/Z, [x10, #1, MUL VL]\n"
      "ld1w { z24.s }, p1/Z, [%x[in_ptr], #7, MUL VL]\n"
      "st1w { z23.s }, p2, [x25]\n"
      "add z20.s, z20.s, z16.s\n"
      "ld1w { z18.s }, p1/Z, [x28, #1, MUL VL]\n"
      "ld1w { z23.s }, p1/Z, [x20, #-6, MUL VL]\n"
      "st1w { z22.s }, p2, [x24]\n"
      "ld1w { z17.s }, p1/Z, [x27, #1, MUL VL]\n"
      "ld1w { z22.s }, p1/Z, [x20, #-3, MUL VL]\n"
      "whilelt p0.s, x21, x11\n"
      "st1w { z21.s }, p2, [x23]\n"
      "ld1w { z16.s }, p1/Z, [x26, #1, MUL VL]\n"
      "ld1w { z29.s }, p1/Z, [x20]\n"
      "add z26.s, z26.s, z19.s\n"
      "st1w { z20.s }, p2, [x22]\n"
      "ld1w { z21.s }, p1/Z, [x25, #1, MUL VL]\n"
      "ld1w { z20.s }, p1/Z, [x20, #3, MUL VL]\n"
      "add z25.s, z25.s, z18.s\n"
      "ld1w { z18.s }, p1/Z, [x24, #1, MUL VL]\n"
      "ld1w { z19.s }, p1/Z, [x20, #6, MUL VL]\n"
      "add z24.s, z24.s, z17.s\n"
      "decw x11, ALL, MUL #3\n"
      "ld1w { z17.s }, p1/Z, [x23, #1, MUL VL]\n"
      "st1w { z26.s }, p1, [x10, #1, MUL VL]\n"
      "add z23.s, z23.s, z16.s\n"
      "ld1w { z28.s }, p0/Z, [%x[in_ptr], #2, MUL VL]\n"
      "ld1w { z16.s }, p1/Z, [x22, #1, MUL VL]\n"
      "st1w { z25.s }, p1, [x28, #1, MUL VL]\n"
      "add z22.s, z22.s, z21.s\n"
      "ld1w { z27.s }, p0/Z, [%x[in_ptr], #5, MUL VL]\n"
      "st1w { z24.s }, p1, [x27, #1, MUL VL]\n"
      "add z29.s, z29.s, z18.s\n"
      "ld1w { z26.s }, p0/Z, [x20, #-8, MUL VL]\n"
      "ld1w { z25.s }, p0/Z, [x20, #-5, MUL VL]\n"
      "st1w { z23.s }, p1, [x26, #1, MUL VL]\n"
      "add z20.s, z20.s, z17.s\n"
      "ld1w { z24.s }, p0/Z, [x10, #2, MUL VL]\n"
      "ld1w { z23.s }, p0/Z, [x20, #-2, MUL VL]\n"
      "st1w { z22.s }, p1, [x25, #1, MUL VL]\n"
      "add z19.s, z19.s, z16.s\n"
      "ld1w { z18.s }, p0/Z, [x28, #2, MUL VL]\n"
      "ld1w { z22.s }, p0/Z, [x20, #1, MUL VL]\n"
      "st1w { z29.s }, p1, [x24, #1, MUL VL]\n"
      "ld1w { z17.s }, p0/Z, [x27, #2, MUL VL]\n"
      "ld1w { z21.s }, p0/Z, [x20, #4, MUL VL]\n"
      "cmp x11, XZR\n"
      "st1w { z20.s }, p1, [x23, #1, MUL VL]\n"
      "ld1w { z16.s }, p0/Z, [x26, #2, MUL VL]\n"
      "ld1w { z20.s }, p0/Z, [x20, #7, MUL VL]\n"
      "incw x21\n"
      "st1w { z19.s }, p1, [x22, #1, MUL VL]\n"
      "ld1w { z19.s }, p0/Z, [x25, #2, MUL VL]\n"
      "add z28.s, z28.s, z24.s\n"
      "add z27.s, z27.s, z18.s\n"
      "ld1w { z18.s }, p0/Z, [x24, #2, MUL VL]\n"
      "add z26.s, z26.s, z17.s\n"
      "addvl %x[in_ptr], %x[in_ptr], #24\n"
      "ld1w { z17.s }, p0/Z, [x23, #2, MUL VL]\n"
      "add z25.s, z25.s, z16.s\n"
      "ld1w { z16.s }, p0/Z, [x22, #2, MUL VL]\n"
      "st1w { z28.s }, p0, [x10, #2, MUL VL]\n"
      "incb x10, ALL, MUL #3\n"
      "st1w { z27.s }, p0, [x28, #2, MUL VL]\n"
      "add z23.s, z23.s, z19.s\n"
      "incb x28, ALL, MUL #3\n"
      "st1w { z26.s }, p0, [x27, #2, MUL VL]\n"
      "add z22.s, z22.s, z18.s\n"
      "add z21.s, z21.s, z17.s\n"
      "incb x27, ALL, MUL #3\n"
      "st1w { z25.s }, p0, [x26, #2, MUL VL]\n"
      "add z20.s, z20.s, z16.s\n"
      "incb x26, ALL, MUL #3\n"
      "st1w { z23.s }, p0, [x25, #2, MUL VL]\n"
      "incb x25, ALL, MUL #3\n"
      "st1w { z22.s }, p0, [x24, #2, MUL VL]\n"
      "incb x24, ALL, MUL #3\n"
      "st1w { z21.s }, p0, [x23, #2, MUL VL]\n"
      "incb x23, ALL, MUL #3\n"
      "st1w { z20.s }, p0, [x22, #2, MUL VL]\n"
      "incb x22, ALL, MUL #3\n"
      "bgt 51b\n"
      "subs %x[rows], %x[rows], #0x8\n"
      "add %x[out_ptr], %x[out_ptr], x12\n"
      "bgt 35b\n"
      "52:"  // Exit
      : [in_ptr] "+&r" (in_ptr), [out_ptr] "+&r" (out_ptr), [rows] "+&r" (rows)
      : [accumulate] "r" (accumulate), [bias] "r" (bias), [cols] "r" (cols), [ldout] "r" (ldout)
      : "cc", "memory", "p0", "p1", "p2", "p8", "x9", "x10", "x11", "x12", "x20", "x21", "x22", "x23", "x24", "x25", "x26", "x27", "x28", "z0", "z1", "z2", "z3", "z4", "z5", "z16", "z17", "z18", "z19", "z20", "z21", "z22", "z23", "z24", "z25", "z26", "z27", "z28", "z29", "z30", "z31"
    );
}

#endif // defined(ARM_COMPUTE_ENABLE_SVE) && defined(__aarch64__)

