/*
 * Copyright (c) 2025-2026 Arm Limited.
 *
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
#pragma once

#ifdef __aarch64__
template<>
void MergeResults<4, 4, false>(
    uint32_t *out_ptr,
    const uint32_t * in_ptr,
    const int ldout,
    const int y0, const int ymax,
    const int x0, const int xmax,
    const uint32_t *bias,
    Activation,
    bool accumulate)
{

    size_t rows = ymax-y0;
    size_t cols = xmax-x0;

    out_ptr += (y0 * ldout) + x0;
    bias = (bias == nullptr) ? nullptr : bias + x0;

    __asm__ __volatile__(
      "cbz %x[cols], 56f\n"
      "cbz %x[rows], 56f\n"
      "mov x27, #0x10\n"
      "mul x27, %x[ldout], x27\n"
      "cbnz %x[accumulate], 34f\n"
      "1:"  // Initial: Row loop
      "cmp %x[rows], #0x3\n"
      "bgt 26f\n"
      "beq 18f\n"
      "cmp %x[rows], #0x1\n"
      "bgt 10f\n"
      "mov x26, %x[cols]\n"
      "mov x25, %x[out_ptr]\n"
      "mov x24, %x[bias]\n"
      "cmp x26, #0x4\n"
      "blt 6f\n"
      "3:"  // Initial: Height 1: Block loop
      "cbnz %x[bias], 4f\n"
      "movi v17.16b, #0\n"
      "b 5f\n"
      "4:"  // Initial: Height 1: Width 1: bias
      "ldr q17, [x24, #0]\n"
      "5:"  // Initial: Height 1: Width 1: init done
      "ldr q16, [%x[in_ptr], #0]\n"
      "sub x26, x26, #0x4\n"
      "add x24, x24, #0x10\n"
      "cmp x26, #0x4\n"
      "add %x[in_ptr], %x[in_ptr], #0x40\n"
      "add v16.4s, v16.4s, v17.4s\n"
      "str q16, [x25, #0]\n"
      "add x25, x25, #0x10\n"
      "bge 3b\n"
      "6:"  // Initial: Height 1: no full blocks
      "cbz x26, 9f\n"
      "mov x20, %x[in_ptr]\n"
      "7:"  // Initial: Height 1: Single loop
      "movi v17.16b, #0\n"
      "cbz %x[bias], 8f\n"
      "ldr s17, [x24, #0]\n"
      "8:"  // Initial: Height 1: Scalar: no bias
      "ldr s16, [%x[in_ptr], #0]\n"
      "subs x26, x26, #0x1\n"
      "add x24, x24, #0x4\n"
      "add %x[in_ptr], %x[in_ptr], #0x4\n"
      "add v16.4s, v16.4s, v17.4s\n"
      "str s16, [x25, #0]\n"
      "add x25, x25, #0x4\n"
      "bne 7b\n"
      "add %x[in_ptr], x20, #0x40\n"
      "9:"  // Initial: Height 1: no oddments
      "b 56f\n"
      "10:"  // Initial: Height 2
      "mov x26, %x[cols]\n"
      "mov x25, %x[out_ptr]\n"
      "mov x24, %x[bias]\n"
      "cmp x26, #0x4\n"
      "add x23, x25, %x[ldout], LSL #2\n"
      "blt 14f\n"
      "11:"  // Initial: Height 2: Block loop
      "cbnz %x[bias], 12f\n"
      "movi v18.16b, #0\n"
      "b 13f\n"
      "12:"  // Initial: Height 2: Width 1: bias
      "ldr q18, [x24, #0]\n"
      "13:"  // Initial: Height 2: Width 1: init done
      "ldr q17, [%x[in_ptr], #0]\n"
      "ldr q16, [%x[in_ptr], #0x10]\n"
      "sub x26, x26, #0x4\n"
      "add x24, x24, #0x10\n"
      "cmp x26, #0x4\n"
      "add %x[in_ptr], %x[in_ptr], #0x40\n"
      "add v17.4s, v17.4s, v18.4s\n"
      "add v16.4s, v16.4s, v18.4s\n"
      "str q17, [x25, #0]\n"
      "add x25, x25, #0x10\n"
      "str q16, [x23, #0]\n"
      "add x23, x23, #0x10\n"
      "bge 11b\n"
      "14:"  // Initial: Height 2: no full blocks
      "cbz x26, 17f\n"
      "mov x20, %x[in_ptr]\n"
      "15:"  // Initial: Height 2: Single loop
      "movi v18.16b, #0\n"
      "cbz %x[bias], 16f\n"
      "ldr s18, [x24, #0]\n"
      "16:"  // Initial: Height 2: Scalar: no bias
      "ldr s17, [%x[in_ptr], #0]\n"
      "ldr s16, [%x[in_ptr], #0x10]\n"
      "subs x26, x26, #0x1\n"
      "add x24, x24, #0x4\n"
      "add %x[in_ptr], %x[in_ptr], #0x4\n"
      "add v17.4s, v17.4s, v18.4s\n"
      "add v16.4s, v16.4s, v18.4s\n"
      "str s17, [x25, #0]\n"
      "add x25, x25, #0x4\n"
      "str s16, [x23, #0]\n"
      "add x23, x23, #0x4\n"
      "bne 15b\n"
      "add %x[in_ptr], x20, #0x40\n"
      "17:"  // Initial: Height 2: no oddments
      "b 56f\n"
      "18:"  // Initial: Height 3
      "mov x26, %x[cols]\n"
      "mov x25, %x[out_ptr]\n"
      "mov x24, %x[bias]\n"
      "add x23, x25, %x[ldout], LSL #2\n"
      "add x22, x23, %x[ldout], LSL #2\n"
      "cmp x26, #0x4\n"
      "blt 22f\n"
      "19:"  // Initial: Height 3: Block loop
      "cbnz %x[bias], 20f\n"
      "movi v19.16b, #0\n"
      "b 21f\n"
      "20:"  // Initial: Height 3: Width 1: bias
      "ldr q19, [x24, #0]\n"
      "21:"  // Initial: Height 3: Width 1: init done
      "ldr q18, [%x[in_ptr], #0]\n"
      "ldr q17, [%x[in_ptr], #0x10]\n"
      "sub x26, x26, #0x4\n"
      "add x24, x24, #0x10\n"
      "ldr q16, [%x[in_ptr], #0x20]\n"
      "cmp x26, #0x4\n"
      "add %x[in_ptr], %x[in_ptr], #0x40\n"
      "add v18.4s, v18.4s, v19.4s\n"
      "add v17.4s, v17.4s, v19.4s\n"
      "str q18, [x25, #0]\n"
      "add x25, x25, #0x10\n"
      "add v16.4s, v16.4s, v19.4s\n"
      "str q17, [x23, #0]\n"
      "add x23, x23, #0x10\n"
      "str q16, [x22, #0]\n"
      "add x22, x22, #0x10\n"
      "bge 19b\n"
      "22:"  // Initial: Height 3: no full blocks
      "cbz x26, 25f\n"
      "mov x20, %x[in_ptr]\n"
      "23:"  // Initial: Height 3: Single loop
      "movi v19.16b, #0\n"
      "cbz %x[bias], 24f\n"
      "ldr s19, [x24, #0]\n"
      "24:"  // Initial: Height 3: Scalar: no bias
      "ldr s18, [%x[in_ptr], #0]\n"
      "ldr s17, [%x[in_ptr], #0x10]\n"
      "subs x26, x26, #0x1\n"
      "add x24, x24, #0x4\n"
      "ldr s16, [%x[in_ptr], #0x20]\n"
      "add %x[in_ptr], %x[in_ptr], #0x4\n"
      "add v18.4s, v18.4s, v19.4s\n"
      "add v17.4s, v17.4s, v19.4s\n"
      "str s18, [x25, #0]\n"
      "add x25, x25, #0x4\n"
      "str s17, [x23, #0]\n"
      "add x23, x23, #0x4\n"
      "add v16.4s, v16.4s, v19.4s\n"
      "str s16, [x22, #0]\n"
      "add x22, x22, #0x4\n"
      "bne 23b\n"
      "add %x[in_ptr], x20, #0x40\n"
      "25:"  // Initial: Height 3: no oddments
      "b 56f\n"
      "26:"  // Initial: Height 4
      "mov x25, %x[out_ptr]\n"
      "mov x26, %x[cols]\n"
      "mov x24, %x[bias]\n"
      "add x23, x25, %x[ldout], LSL #2\n"
      "add x22, x23, %x[ldout], LSL #2\n"
      "cmp x26, #0x4\n"
      "add x21, x22, %x[ldout], LSL #2\n"
      "blt 30f\n"
      "27:"  // Initial: Height 4: Block loop
      "cbnz %x[bias], 28f\n"
      "movi v20.16b, #0\n"
      "b 29f\n"
      "28:"  // Initial: Height 4: Width 1: bias
      "ldr q20, [x24, #0]\n"
      "29:"  // Initial: Height 4: Width 1: init done
      "ldr q19, [%x[in_ptr], #0]\n"
      "ldr q18, [%x[in_ptr], #0x10]\n"
      "sub x26, x26, #0x4\n"
      "add x24, x24, #0x10\n"
      "ldr q17, [%x[in_ptr], #0x20]\n"
      "ldr q16, [%x[in_ptr], #0x30]\n"
      "cmp x26, #0x4\n"
      "add %x[in_ptr], %x[in_ptr], #0x40\n"
      "add v19.4s, v19.4s, v20.4s\n"
      "add v18.4s, v18.4s, v20.4s\n"
      "add v17.4s, v17.4s, v20.4s\n"
      "add v16.4s, v16.4s, v20.4s\n"
      "str q19, [x25, #0]\n"
      "add x25, x25, #0x10\n"
      "str q18, [x23, #0]\n"
      "add x23, x23, #0x10\n"
      "str q17, [x22, #0]\n"
      "add x22, x22, #0x10\n"
      "str q16, [x21, #0]\n"
      "add x21, x21, #0x10\n"
      "bge 27b\n"
      "30:"  // Initial: Height 4: no full blocks
      "cbz x26, 33f\n"
      "mov x20, %x[in_ptr]\n"
      "31:"  // Initial: Height 4: Single loop
      "movi v20.16b, #0\n"
      "cbz %x[bias], 32f\n"
      "ldr s20, [x24, #0]\n"
      "32:"  // Initial: Height 4: Scalar: no bias
      "ldr s19, [%x[in_ptr], #0]\n"
      "ldr s18, [%x[in_ptr], #0x10]\n"
      "subs x26, x26, #0x1\n"
      "add x24, x24, #0x4\n"
      "ldr s17, [%x[in_ptr], #0x20]\n"
      "ldr s16, [%x[in_ptr], #0x30]\n"
      "add %x[in_ptr], %x[in_ptr], #0x4\n"
      "add v19.4s, v19.4s, v20.4s\n"
      "add v18.4s, v18.4s, v20.4s\n"
      "str s19, [x25, #0]\n"
      "add x25, x25, #0x4\n"
      "add v17.4s, v17.4s, v20.4s\n"
      "add v16.4s, v16.4s, v20.4s\n"
      "str s18, [x23, #0]\n"
      "add x23, x23, #0x4\n"
      "str s17, [x22, #0]\n"
      "add x22, x22, #0x4\n"
      "str s16, [x21, #0]\n"
      "add x21, x21, #0x4\n"
      "bne 31b\n"
      "add %x[in_ptr], x20, #0x40\n"
      "33:"  // Initial: Height 4: no oddments
      "subs %x[rows], %x[rows], #0x4\n"
      "add %x[out_ptr], %x[out_ptr], x27\n"
      "bgt 1b\n"
      "b 56f\n"
      "34:"  // Accumulate
      "35:"  // Accumulate: Row loop
      "cmp %x[rows], #0x3\n"
      "bgt 51f\n"
      "beq 46f\n"
      "cmp %x[rows], #0x1\n"
      "bgt 41f\n"
      "mov x26, %x[cols]\n"
      "mov x25, %x[out_ptr]\n"
      "cmp x26, #0x4\n"
      "blt 38f\n"
      "37:"  // Accumulate: Height 1: Block loop
      "ldr q17, [%x[in_ptr], #0]\n"
      "ldr q16, [x25, #0]\n"
      "sub x26, x26, #0x4\n"
      "add %x[in_ptr], %x[in_ptr], #0x40\n"
      "cmp x26, #0x4\n"
      "add v17.4s, v17.4s, v16.4s\n"
      "str q17, [x25, #0]\n"
      "add x25, x25, #0x10\n"
      "bge 37b\n"
      "38:"  // Accumulate: Height 1: no full blocks
      "cbz x26, 40f\n"
      "mov x20, %x[in_ptr]\n"
      "39:"  // Accumulate: Height 1: Single loop
      "ldr s17, [%x[in_ptr], #0]\n"
      "ldr s16, [x25, #0]\n"
      "subs x26, x26, #0x1\n"
      "add %x[in_ptr], %x[in_ptr], #0x4\n"
      "add v17.4s, v17.4s, v16.4s\n"
      "str s17, [x25, #0]\n"
      "add x25, x25, #0x4\n"
      "bne 39b\n"
      "add %x[in_ptr], x20, #0x40\n"
      "40:"  // Accumulate: Height 1: no oddments
      "b 56f\n"
      "41:"  // Accumulate: Height 2
      "mov x26, %x[cols]\n"
      "mov x25, %x[out_ptr]\n"
      "cmp x26, #0x4\n"
      "add x23, x25, %x[ldout], LSL #2\n"
      "blt 43f\n"
      "42:"  // Accumulate: Height 2: Block loop
      "ldr q19, [%x[in_ptr], #0]\n"
      "ldr q18, [x25, #0]\n"
      "sub x26, x26, #0x4\n"
      "ldr q17, [%x[in_ptr], #0x10]\n"
      "ldr q16, [x23, #0]\n"
      "cmp x26, #0x4\n"
      "add %x[in_ptr], %x[in_ptr], #0x40\n"
      "add v19.4s, v19.4s, v18.4s\n"
      "add v17.4s, v17.4s, v16.4s\n"
      "str q19, [x25, #0]\n"
      "add x25, x25, #0x10\n"
      "str q17, [x23, #0]\n"
      "add x23, x23, #0x10\n"
      "bge 42b\n"
      "43:"  // Accumulate: Height 2: no full blocks
      "cbz x26, 45f\n"
      "mov x20, %x[in_ptr]\n"
      "44:"  // Accumulate: Height 2: Single loop
      "ldr s19, [%x[in_ptr], #0]\n"
      "ldr s18, [x25, #0]\n"
      "subs x26, x26, #0x1\n"
      "ldr s17, [%x[in_ptr], #0x10]\n"
      "ldr s16, [x23, #0]\n"
      "add %x[in_ptr], %x[in_ptr], #0x4\n"
      "add v19.4s, v19.4s, v18.4s\n"
      "str s19, [x25, #0]\n"
      "add x25, x25, #0x4\n"
      "add v17.4s, v17.4s, v16.4s\n"
      "str s17, [x23, #0]\n"
      "add x23, x23, #0x4\n"
      "bne 44b\n"
      "add %x[in_ptr], x20, #0x40\n"
      "45:"  // Accumulate: Height 2: no oddments
      "b 56f\n"
      "46:"  // Accumulate: Height 3
      "mov x26, %x[cols]\n"
      "mov x25, %x[out_ptr]\n"
      "add x23, x25, %x[ldout], LSL #2\n"
      "add x22, x23, %x[ldout], LSL #2\n"
      "cmp x26, #0x4\n"
      "blt 48f\n"
      "47:"  // Accumulate: Height 3: Block loop
      "ldr q21, [%x[in_ptr], #0]\n"
      "ldr q20, [x25, #0]\n"
      "sub x26, x26, #0x4\n"
      "ldr q19, [%x[in_ptr], #0x10]\n"
      "ldr q18, [x23, #0]\n"
      "cmp x26, #0x4\n"
      "ldr q17, [%x[in_ptr], #0x20]\n"
      "ldr q16, [x22, #0]\n"
      "add %x[in_ptr], %x[in_ptr], #0x40\n"
      "add v21.4s, v21.4s, v20.4s\n"
      "add v19.4s, v19.4s, v18.4s\n"
      "str q21, [x25, #0]\n"
      "add x25, x25, #0x10\n"
      "add v17.4s, v17.4s, v16.4s\n"
      "str q19, [x23, #0]\n"
      "add x23, x23, #0x10\n"
      "str q17, [x22, #0]\n"
      "add x22, x22, #0x10\n"
      "bge 47b\n"
      "48:"  // Accumulate: Height 3: no full blocks
      "cbz x26, 50f\n"
      "mov x20, %x[in_ptr]\n"
      "49:"  // Accumulate: Height 3: Single loop
      "ldr s21, [%x[in_ptr], #0]\n"
      "ldr s20, [x25, #0]\n"
      "subs x26, x26, #0x1\n"
      "ldr s19, [%x[in_ptr], #0x10]\n"
      "ldr s18, [x23, #0]\n"
      "ldr s17, [%x[in_ptr], #0x20]\n"
      "ldr s16, [x22, #0]\n"
      "add %x[in_ptr], %x[in_ptr], #0x4\n"
      "add v21.4s, v21.4s, v20.4s\n"
      "add v19.4s, v19.4s, v18.4s\n"
      "str s21, [x25, #0]\n"
      "add x25, x25, #0x4\n"
      "add v17.4s, v17.4s, v16.4s\n"
      "str s19, [x23, #0]\n"
      "add x23, x23, #0x4\n"
      "str s17, [x22, #0]\n"
      "add x22, x22, #0x4\n"
      "bne 49b\n"
      "add %x[in_ptr], x20, #0x40\n"
      "50:"  // Accumulate: Height 3: no oddments
      "b 56f\n"
      "51:"  // Accumulate: Height 4
      "mov x25, %x[out_ptr]\n"
      "mov x26, %x[cols]\n"
      "add x23, x25, %x[ldout], LSL #2\n"
      "add x22, x23, %x[ldout], LSL #2\n"
      "add x21, x22, %x[ldout], LSL #2\n"
      "cmp x26, #0x4\n"
      "blt 53f\n"
      "52:"  // Accumulate: Height 4: Block loop
      "ldr q23, [%x[in_ptr], #0]\n"
      "ldr q22, [x25, #0]\n"
      "sub x26, x26, #0x4\n"
      "ldr q21, [%x[in_ptr], #0x10]\n"
      "ldr q20, [x23, #0]\n"
      "cmp x26, #0x4\n"
      "ldr q19, [%x[in_ptr], #0x20]\n"
      "ldr q18, [x22, #0]\n"
      "ldr q17, [%x[in_ptr], #0x30]\n"
      "ldr q16, [x21, #0]\n"
      "add v23.4s, v23.4s, v22.4s\n"
      "add %x[in_ptr], %x[in_ptr], #0x40\n"
      "add v21.4s, v21.4s, v20.4s\n"
      "add v19.4s, v19.4s, v18.4s\n"
      "str q23, [x25, #0]\n"
      "add x25, x25, #0x10\n"
      "add v17.4s, v17.4s, v16.4s\n"
      "str q21, [x23, #0]\n"
      "add x23, x23, #0x10\n"
      "str q19, [x22, #0]\n"
      "add x22, x22, #0x10\n"
      "str q17, [x21, #0]\n"
      "add x21, x21, #0x10\n"
      "bge 52b\n"
      "53:"  // Accumulate: Height 4: no full blocks
      "cbz x26, 55f\n"
      "mov x20, %x[in_ptr]\n"
      "54:"  // Accumulate: Height 4: Single loop
      "ldr s23, [%x[in_ptr], #0]\n"
      "ldr s22, [x25, #0]\n"
      "subs x26, x26, #0x1\n"
      "ldr s21, [%x[in_ptr], #0x10]\n"
      "ldr s20, [x23, #0]\n"
      "ldr s19, [%x[in_ptr], #0x20]\n"
      "ldr s18, [x22, #0]\n"
      "ldr s17, [%x[in_ptr], #0x30]\n"
      "ldr s16, [x21, #0]\n"
      "add v23.4s, v23.4s, v22.4s\n"
      "add %x[in_ptr], %x[in_ptr], #0x4\n"
      "add v21.4s, v21.4s, v20.4s\n"
      "add v19.4s, v19.4s, v18.4s\n"
      "str s23, [x25, #0]\n"
      "add x25, x25, #0x4\n"
      "add v17.4s, v17.4s, v16.4s\n"
      "str s21, [x23, #0]\n"
      "add x23, x23, #0x4\n"
      "str s19, [x22, #0]\n"
      "add x22, x22, #0x4\n"
      "str s17, [x21, #0]\n"
      "add x21, x21, #0x4\n"
      "bne 54b\n"
      "add %x[in_ptr], x20, #0x40\n"
      "55:"  // Accumulate: Height 4: no oddments
      "subs %x[rows], %x[rows], #0x4\n"
      "add %x[out_ptr], %x[out_ptr], x27\n"
      "bgt 35b\n"
      "56:"  // Exit
      : [in_ptr] "+&r" (in_ptr), [out_ptr] "+&r" (out_ptr), [rows] "+&r" (rows)
      : [accumulate] "r" (accumulate), [bias] "r" (bias), [cols] "r" (cols), [ldout] "r" (ldout)
      : "cc", "memory", "v16", "v17", "v18", "v19", "v20", "v21", "v22", "v23", "x20", "x21", "x22", "x23", "x24", "x25", "x26", "x27"
    );
}

#endif // __aarch64__

