/*
 * Copyright (c) 2024-2026 Arm Limited.
 *
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#if defined(ARM_COMPUTE_ENABLE_SME) && defined(__aarch64__)

#include "arm_gemm/arm_gemm.hpp"
#include "arm_common/internal/utils.hpp"

#include <cassert>
#include <cstdint>

namespace arm_gemm {

void sme_gemv_u8qa_dot_8VL (
    const uint8_t *A_ptr, const uint8_t *B_ptr, uint8_t *output_ptr,
    size_t N, size_t K,
    const Requantize32 *qp, const int32_t *col_bias, unsigned int
)
{
    struct KernelArgs {
        const uint8_t *B_ptr = {};
        size_t output_offset = {};
        unsigned int input_initial_col = {};
    } args;

    unsigned long flags=0;
    args.B_ptr = B_ptr;
    __asm__ __volatile__(
      ".inst 0xd503477f  // SMSTART ZA\n"
      "mov x27, %x[col_bias]\n"
      "bic %x[flags], %x[flags], #0x80000000\n"
      "cntw x26\n"
      "ptrue p2.b\n"
      "mov z22.s, #0\n"
      "mov z23.b, #0x1\n"
      "add x25, %x[N], x26\n"
      "sub x25, x25, #0x1\n"
      "udiv x25, x25, x26\n"
      "1:"  // Column loop
      "cmp x25, #0x8\n"
      "bge 57f\n"
      "cmp x25, #0x6\n"
      "bgt 49f\n"
      "beq 41f\n"
      "cmp x25, #0x4\n"
      "bgt 33f\n"
      "beq 25f\n"
      "cmp x25, #0x2\n"
      "bgt 17f\n"
      "beq 9f\n"
      "mov x22, %x[K]\n"
      "mov x21, %x[A_ptr]\n"
      "mov z24.s, #0\n"
      "whilelt p1.b, XZR, %x[N]\n"
      "cmp x22, #0x10\n"
      "ble 5f\n"
      "3:"  // Width 1: Multiply loop: Main loop head
      "whilelt p0.b, XZR, x22\n"
      "ldnt1b { z1.b }, p2/Z, [%x[B_ptr]]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "ld1rqb { z0.b }, p0/Z, [x21]\n"
      "add x21, x21, #0x10\n"
      "ldnt1b { z2.b }, p2/Z, [%x[B_ptr]]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "ldnt1b { z3.b }, p2/Z, [%x[B_ptr]]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z24.s, z1.b, z0.b[0]\n"
      "ldnt1b { z4.b }, p2/Z, [%x[B_ptr]]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z24.s, z2.b, z0.b[1]\n"
      "udot z24.s, z3.b, z0.b[2]\n"
      "udot z24.s, z4.b, z0.b[3]\n"
      "tbnz %x[flags], #31, 4f\n"
      "udot z22.s, z0.b, z23.b\n"
      "4:"  // Width 1: Multiply loop: unique 1: skip row sum
      "sub x22, x22, #0x10\n"
      "cmp x22, #0x10\n"
      "bgt 3b\n"
      "5:"  // Width 1: Multiply loop: Single iteration only
      "whilelt p0.b, XZR, x22\n"
      "ldnt1b { z5.b }, p2/Z, [%x[B_ptr]]\n"
      "subs x22, x22, #0x4\n"
      "ld1rqb { z0.b }, p0/Z, [x21]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z24.s, z5.b, z0.b[0]\n"
      "ble 6f\n"
      "ldnt1b { z6.b }, p2/Z, [%x[B_ptr]]\n"
      "subs x22, x22, #0x4\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z24.s, z6.b, z0.b[1]\n"
      "ble 6f\n"
      "ldnt1b { z7.b }, p2/Z, [%x[B_ptr]]\n"
      "subs x22, x22, #0x4\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z24.s, z7.b, z0.b[2]\n"
      "ble 6f\n"
      "ldnt1b { z8.b }, p2/Z, [%x[B_ptr]]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z24.s, z8.b, z0.b[3]\n"
      "6:"  // Width 1: Multiply loop: multiply skip
      "tbnz %x[flags], #31, 7f\n"
      "udot z22.s, z0.b, z23.b\n"
      "7:"  // Width 1: Multiply loop: unique 2: skip row sum
      "tbnz %x[flags], #31, 8f\n"
      "add x21, %x[qp], %[b_offset]\n"
      "mov x20, #0x4\n"
      "ld1rw { z1.s }, p2/Z, [x21]\n"
      "whilelt p0.s, XZR, x20\n"
      "uaddv d22, p0, z22.s\n"
      "mov z22.s, z22.s[0]\n"
      "neg z1.s, p2/M, z1.s\n"
      "mul z22.s, p2/M, z22.s, z1.s\n"
      "8:"  // Width 1: skip row sum fixup
      "add z24.s, z24.s, z22.s\n"
      "ld1w { z0.s }, p2/Z, [x27]\n"
      "add x20, %x[qp], %[per_layer_mul]\n"
      "add x23, %x[qp], %[per_layer_right_shift]\n"
      "ld1rw { z8.s }, p2/Z, [x20]\n"
      "add x22, %x[qp], %[c_offset]\n"
      "add x21, %x[qp], %[minval]\n"
      "add x20, %x[qp], %[maxval]\n"
      "ld1rw { z9.s }, p2/Z, [x21]\n"
      "orr %x[flags], %x[flags], #0x80000000\n"
      "ld1rw { z10.s }, p2/Z, [x20]\n"
      "add z24.s, z24.s, z0.s\n"
      "ld1rw { z0.s }, p2/Z, [x23]\n"
      ".inst 0x04a87318  // sqdmulh z24.s, z24.s, z8.s\n"
      "ld1rw { z8.s }, p2/Z, [x22]\n"
      ".inst 0x44828818  // srshl z24.s, p2/M, z24.s, z0.s\n"
      "add z24.s, z24.s, z8.s\n"
      ".inst 0x448ac138  // sclamp z24.s, z9.s, z10.s\n"
      "uzp1 z24.h, z24.h, z25.h\n"
      "uzp1 z24.b, z24.b, z25.b\n"
      "st1b { z24.b }, p1, [%x[output_ptr]]\n"
      "addvl %x[output_ptr], %x[output_ptr], #1\n"
      "b 65f\n"
      "9:"  // Width 2
      "mov x22, %x[K]\n"
      "mov x21, %x[A_ptr]\n"
      "mov z24.s, #0\n"
      "mov z25.s, #0\n"
      "whilelt p1.b, XZR, %x[N]\n"
      "cmp x22, #0x10\n"
      "ble 13f\n"
      "11:"  // Width 2: Multiply loop: Main loop head
      "whilelt p0.b, XZR, x22\n"
      "ldnt1b { z1.b }, p2/Z, [%x[B_ptr]]\n"
      "ld1rqb { z0.b }, p0/Z, [x21]\n"
      "add x21, x21, #0x10\n"
      "ldnt1b { z2.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "ldnt1b { z3.b }, p2/Z, [%x[B_ptr]]\n"
      "udot z24.s, z1.b, z0.b[0]\n"
      "ldnt1b { z4.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z25.s, z2.b, z0.b[0]\n"
      "ldnt1b { z5.b }, p2/Z, [%x[B_ptr]]\n"
      "ldnt1b { z6.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "ldnt1b { z7.b }, p2/Z, [%x[B_ptr]]\n"
      "udot z24.s, z3.b, z0.b[1]\n"
      "ldnt1b { z8.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z25.s, z4.b, z0.b[1]\n"
      "udot z24.s, z5.b, z0.b[2]\n"
      "udot z25.s, z6.b, z0.b[2]\n"
      "udot z24.s, z7.b, z0.b[3]\n"
      "udot z25.s, z8.b, z0.b[3]\n"
      "tbnz %x[flags], #31, 12f\n"
      "udot z22.s, z0.b, z23.b\n"
      "12:"  // Width 2: Multiply loop: unique 3: skip row sum
      "sub x22, x22, #0x10\n"
      "cmp x22, #0x10\n"
      "bgt 11b\n"
      "13:"  // Width 2: Multiply loop: Single iteration only
      "whilelt p0.b, XZR, x22\n"
      "ldnt1b { z9.b }, p2/Z, [%x[B_ptr]]\n"
      "subs x22, x22, #0x4\n"
      "ld1rqb { z0.b }, p0/Z, [x21]\n"
      "ldnt1b { z10.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z24.s, z9.b, z0.b[0]\n"
      "udot z25.s, z10.b, z0.b[0]\n"
      "ble 14f\n"
      "ldnt1b { z11.b }, p2/Z, [%x[B_ptr]]\n"
      "subs x22, x22, #0x4\n"
      "ldnt1b { z12.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z24.s, z11.b, z0.b[1]\n"
      "udot z25.s, z12.b, z0.b[1]\n"
      "ble 14f\n"
      "ldnt1b { z13.b }, p2/Z, [%x[B_ptr]]\n"
      "subs x22, x22, #0x4\n"
      "ldnt1b { z14.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z24.s, z13.b, z0.b[2]\n"
      "udot z25.s, z14.b, z0.b[2]\n"
      "ble 14f\n"
      "ldnt1b { z15.b }, p2/Z, [%x[B_ptr]]\n"
      "ldnt1b { z16.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z24.s, z15.b, z0.b[3]\n"
      "udot z25.s, z16.b, z0.b[3]\n"
      "14:"  // Width 2: Multiply loop: multiply skip
      "tbnz %x[flags], #31, 15f\n"
      "udot z22.s, z0.b, z23.b\n"
      "15:"  // Width 2: Multiply loop: unique 4: skip row sum
      "tbnz %x[flags], #31, 16f\n"
      "add x21, %x[qp], %[b_offset]\n"
      "mov x20, #0x4\n"
      "ld1rw { z2.s }, p2/Z, [x21]\n"
      "whilelt p0.s, XZR, x20\n"
      "uaddv d22, p0, z22.s\n"
      "mov z22.s, z22.s[0]\n"
      "neg z2.s, p2/M, z2.s\n"
      "mul z22.s, p2/M, z22.s, z2.s\n"
      "16:"  // Width 2: skip row sum fixup
      "add z24.s, z24.s, z22.s\n"
      "add z25.s, z25.s, z22.s\n"
      "ld1w { z0.s }, p2/Z, [x27]\n"
      "add x20, %x[qp], %[per_layer_mul]\n"
      "ld1w { z1.s }, p2/Z, [x27, #1, MUL VL]\n"
      "add x23, %x[qp], %[per_layer_right_shift]\n"
      "add x22, %x[qp], %[c_offset]\n"
      "ld1rw { z8.s }, p2/Z, [x20]\n"
      "add x21, %x[qp], %[minval]\n"
      "add x20, %x[qp], %[maxval]\n"
      "ld1rw { z9.s }, p2/Z, [x21]\n"
      "orr %x[flags], %x[flags], #0x80000000\n"
      "add z24.s, z24.s, z0.s\n"
      "add z25.s, z25.s, z1.s\n"
      "ld1rw { z0.s }, p2/Z, [x23]\n"
      "ld1rw { z10.s }, p2/Z, [x20]\n"
      ".inst 0x04a87318  // sqdmulh z24.s, z24.s, z8.s\n"
      ".inst 0x04a87339  // sqdmulh z25.s, z25.s, z8.s\n"
      "ld1rw { z8.s }, p2/Z, [x22]\n"
      ".inst 0x44828818  // srshl z24.s, p2/M, z24.s, z0.s\n"
      ".inst 0x44828819  // srshl z25.s, p2/M, z25.s, z0.s\n"
      "add z24.s, z24.s, z8.s\n"
      "add z25.s, z25.s, z8.s\n"
      ".inst 0x448ac138  // sclamp z24.s, z9.s, z10.s\n"
      ".inst 0x448ac139  // sclamp z25.s, z9.s, z10.s\n"
      "uzp1 z24.h, z24.h, z25.h\n"
      "uzp1 z24.b, z24.b, z25.b\n"
      "st1b { z24.b }, p1, [%x[output_ptr]]\n"
      "addvl %x[output_ptr], %x[output_ptr], #1\n"
      "b 65f\n"
      "17:"  // Width 3
      "mov x22, %x[K]\n"
      "mov x21, %x[A_ptr]\n"
      "mov z24.s, #0\n"
      "mov z25.s, #0\n"
      "whilelt p1.b, XZR, %x[N]\n"
      "mov z26.s, #0\n"
      "cmp x22, #0x10\n"
      "ble 21f\n"
      "19:"  // Width 3: Multiply loop: Main loop head
      "whilelt p0.b, XZR, x22\n"
      "ldnt1b { z1.b }, p2/Z, [%x[B_ptr]]\n"
      "ld1rqb { z0.b }, p0/Z, [x21]\n"
      "add x21, x21, #0x10\n"
      "ldnt1b { z2.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "ldnt1b { z3.b }, p2/Z, [%x[B_ptr], #2, MUL VL]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z24.s, z1.b, z0.b[0]\n"
      "ldnt1b { z4.b }, p2/Z, [%x[B_ptr]]\n"
      "udot z25.s, z2.b, z0.b[0]\n"
      "ldnt1b { z5.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "udot z26.s, z3.b, z0.b[0]\n"
      "ldnt1b { z6.b }, p2/Z, [%x[B_ptr], #2, MUL VL]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "ldnt1b { z7.b }, p2/Z, [%x[B_ptr]]\n"
      "udot z24.s, z4.b, z0.b[1]\n"
      "ldnt1b { z8.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "udot z25.s, z5.b, z0.b[1]\n"
      "ldnt1b { z9.b }, p2/Z, [%x[B_ptr], #2, MUL VL]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z26.s, z6.b, z0.b[1]\n"
      "ldnt1b { z10.b }, p2/Z, [%x[B_ptr]]\n"
      "ldnt1b { z11.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "udot z24.s, z7.b, z0.b[2]\n"
      "ldnt1b { z12.b }, p2/Z, [%x[B_ptr], #2, MUL VL]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z25.s, z8.b, z0.b[2]\n"
      "udot z26.s, z9.b, z0.b[2]\n"
      "udot z24.s, z10.b, z0.b[3]\n"
      "udot z25.s, z11.b, z0.b[3]\n"
      "udot z26.s, z12.b, z0.b[3]\n"
      "tbnz %x[flags], #31, 20f\n"
      "udot z22.s, z0.b, z23.b\n"
      "20:"  // Width 3: Multiply loop: unique 5: skip row sum
      "sub x22, x22, #0x10\n"
      "cmp x22, #0x10\n"
      "bgt 19b\n"
      "21:"  // Width 3: Multiply loop: Single iteration only
      "whilelt p0.b, XZR, x22\n"
      "ldnt1b { z13.b }, p2/Z, [%x[B_ptr]]\n"
      "subs x22, x22, #0x4\n"
      "ld1rqb { z0.b }, p0/Z, [x21]\n"
      "ldnt1b { z14.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "ldnt1b { z15.b }, p2/Z, [%x[B_ptr], #2, MUL VL]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z24.s, z13.b, z0.b[0]\n"
      "udot z25.s, z14.b, z0.b[0]\n"
      "udot z26.s, z15.b, z0.b[0]\n"
      "ble 22f\n"
      "ldnt1b { z16.b }, p2/Z, [%x[B_ptr]]\n"
      "subs x22, x22, #0x4\n"
      "ldnt1b { z17.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "ldnt1b { z18.b }, p2/Z, [%x[B_ptr], #2, MUL VL]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z24.s, z16.b, z0.b[1]\n"
      "udot z25.s, z17.b, z0.b[1]\n"
      "udot z26.s, z18.b, z0.b[1]\n"
      "ble 22f\n"
      "ldnt1b { z19.b }, p2/Z, [%x[B_ptr]]\n"
      "subs x22, x22, #0x4\n"
      "ldnt1b { z20.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "ldnt1b { z21.b }, p2/Z, [%x[B_ptr], #2, MUL VL]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z24.s, z19.b, z0.b[2]\n"
      "udot z25.s, z20.b, z0.b[2]\n"
      "udot z26.s, z21.b, z0.b[2]\n"
      "ble 22f\n"
      "ldnt1b { z1.b }, p2/Z, [%x[B_ptr]]\n"
      "ldnt1b { z2.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "ldnt1b { z3.b }, p2/Z, [%x[B_ptr], #2, MUL VL]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z24.s, z1.b, z0.b[3]\n"
      "udot z25.s, z2.b, z0.b[3]\n"
      "udot z26.s, z3.b, z0.b[3]\n"
      "22:"  // Width 3: Multiply loop: multiply skip
      "tbnz %x[flags], #31, 23f\n"
      "udot z22.s, z0.b, z23.b\n"
      "23:"  // Width 3: Multiply loop: unique 6: skip row sum
      "tbnz %x[flags], #31, 24f\n"
      "add x21, %x[qp], %[b_offset]\n"
      "mov x20, #0x4\n"
      "ld1rw { z3.s }, p2/Z, [x21]\n"
      "whilelt p0.s, XZR, x20\n"
      "uaddv d22, p0, z22.s\n"
      "mov z22.s, z22.s[0]\n"
      "neg z3.s, p2/M, z3.s\n"
      "mul z22.s, p2/M, z22.s, z3.s\n"
      "24:"  // Width 3: skip row sum fixup
      "add z24.s, z24.s, z22.s\n"
      "add z25.s, z25.s, z22.s\n"
      "ld1w { z0.s }, p2/Z, [x27]\n"
      "add x24, %x[qp], %[per_layer_mul]\n"
      "add z26.s, z26.s, z22.s\n"
      "ld1w { z1.s }, p2/Z, [x27, #1, MUL VL]\n"
      "add x23, %x[qp], %[per_layer_right_shift]\n"
      "add x22, %x[qp], %[c_offset]\n"
      "ld1w { z2.s }, p2/Z, [x27, #2, MUL VL]\n"
      "add x21, %x[qp], %[minval]\n"
      "add x20, %x[qp], %[maxval]\n"
      "ld1rw { z8.s }, p2/Z, [x24]\n"
      "orr %x[flags], %x[flags], #0x80000000\n"
      "add z24.s, z24.s, z0.s\n"
      "add z25.s, z25.s, z1.s\n"
      "ld1rw { z0.s }, p2/Z, [x23]\n"
      "add z26.s, z26.s, z2.s\n"
      "ld1rw { z9.s }, p2/Z, [x21]\n"
      "ld1rw { z10.s }, p2/Z, [x20]\n"
      ".inst 0x04a87318  // sqdmulh z24.s, z24.s, z8.s\n"
      ".inst 0x04a87339  // sqdmulh z25.s, z25.s, z8.s\n"
      ".inst 0x04a8735a  // sqdmulh z26.s, z26.s, z8.s\n"
      "ld1rw { z8.s }, p2/Z, [x22]\n"
      ".inst 0x44828818  // srshl z24.s, p2/M, z24.s, z0.s\n"
      ".inst 0x44828819  // srshl z25.s, p2/M, z25.s, z0.s\n"
      ".inst 0x4482881a  // srshl z26.s, p2/M, z26.s, z0.s\n"
      "add z24.s, z24.s, z8.s\n"
      "add z25.s, z25.s, z8.s\n"
      "add z26.s, z26.s, z8.s\n"
      ".inst 0x448ac138  // sclamp z24.s, z9.s, z10.s\n"
      ".inst 0x448ac139  // sclamp z25.s, z9.s, z10.s\n"
      ".inst 0x448ac13a  // sclamp z26.s, z9.s, z10.s\n"
      "uzp1 z24.h, z24.h, z25.h\n"
      "uzp1 z25.h, z26.h, z27.h\n"
      "uzp1 z24.b, z24.b, z25.b\n"
      "st1b { z24.b }, p1, [%x[output_ptr]]\n"
      "addvl %x[output_ptr], %x[output_ptr], #1\n"
      "b 65f\n"
      "25:"  // Width 4
      "mov x22, %x[K]\n"
      "mov x21, %x[A_ptr]\n"
      "mov z24.s, #0\n"
      "mov z25.s, #0\n"
      "whilelt p1.b, XZR, %x[N]\n"
      "mov z26.s, #0\n"
      "mov z27.s, #0\n"
      "cmp x22, #0x10\n"
      "ble 29f\n"
      "27:"  // Width 4: Multiply loop: Main loop head
      "whilelt p0.b, XZR, x22\n"
      "ldnt1b { z1.b }, p2/Z, [%x[B_ptr]]\n"
      "ld1rqb { z0.b }, p0/Z, [x21]\n"
      "add x21, x21, #0x10\n"
      "ldnt1b { z2.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "ldnt1b { z3.b }, p2/Z, [%x[B_ptr], #2, MUL VL]\n"
      "ldnt1b { z4.b }, p2/Z, [%x[B_ptr], #3, MUL VL]\n"
      "udot z24.s, z1.b, z0.b[0]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z25.s, z2.b, z0.b[0]\n"
      "ldnt1b { z5.b }, p2/Z, [%x[B_ptr]]\n"
      "udot z26.s, z3.b, z0.b[0]\n"
      "ldnt1b { z6.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "udot z27.s, z4.b, z0.b[0]\n"
      "ldnt1b { z7.b }, p2/Z, [%x[B_ptr], #2, MUL VL]\n"
      "ldnt1b { z8.b }, p2/Z, [%x[B_ptr], #3, MUL VL]\n"
      "udot z24.s, z5.b, z0.b[1]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z25.s, z6.b, z0.b[1]\n"
      "ldnt1b { z9.b }, p2/Z, [%x[B_ptr]]\n"
      "udot z26.s, z7.b, z0.b[1]\n"
      "ldnt1b { z10.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "udot z27.s, z8.b, z0.b[1]\n"
      "ldnt1b { z11.b }, p2/Z, [%x[B_ptr], #2, MUL VL]\n"
      "ldnt1b { z12.b }, p2/Z, [%x[B_ptr], #3, MUL VL]\n"
      "udot z24.s, z9.b, z0.b[2]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z25.s, z10.b, z0.b[2]\n"
      "ldnt1b { z13.b }, p2/Z, [%x[B_ptr]]\n"
      "udot z26.s, z11.b, z0.b[2]\n"
      "ldnt1b { z14.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "udot z27.s, z12.b, z0.b[2]\n"
      "ldnt1b { z15.b }, p2/Z, [%x[B_ptr], #2, MUL VL]\n"
      "ldnt1b { z16.b }, p2/Z, [%x[B_ptr], #3, MUL VL]\n"
      "udot z24.s, z13.b, z0.b[3]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z25.s, z14.b, z0.b[3]\n"
      "udot z26.s, z15.b, z0.b[3]\n"
      "udot z27.s, z16.b, z0.b[3]\n"
      "tbnz %x[flags], #31, 28f\n"
      "udot z22.s, z0.b, z23.b\n"
      "28:"  // Width 4: Multiply loop: unique 7: skip row sum
      "sub x22, x22, #0x10\n"
      "cmp x22, #0x10\n"
      "bgt 27b\n"
      "29:"  // Width 4: Multiply loop: Single iteration only
      "whilelt p0.b, XZR, x22\n"
      "ldnt1b { z17.b }, p2/Z, [%x[B_ptr]]\n"
      "subs x22, x22, #0x4\n"
      "ld1rqb { z0.b }, p0/Z, [x21]\n"
      "ldnt1b { z18.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "ldnt1b { z19.b }, p2/Z, [%x[B_ptr], #2, MUL VL]\n"
      "ldnt1b { z20.b }, p2/Z, [%x[B_ptr], #3, MUL VL]\n"
      "udot z24.s, z17.b, z0.b[0]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z25.s, z18.b, z0.b[0]\n"
      "udot z26.s, z19.b, z0.b[0]\n"
      "udot z27.s, z20.b, z0.b[0]\n"
      "ble 30f\n"
      "ldnt1b { z21.b }, p2/Z, [%x[B_ptr]]\n"
      "subs x22, x22, #0x4\n"
      "ldnt1b { z1.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "ldnt1b { z2.b }, p2/Z, [%x[B_ptr], #2, MUL VL]\n"
      "ldnt1b { z3.b }, p2/Z, [%x[B_ptr], #3, MUL VL]\n"
      "udot z24.s, z21.b, z0.b[1]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z25.s, z1.b, z0.b[1]\n"
      "udot z26.s, z2.b, z0.b[1]\n"
      "udot z27.s, z3.b, z0.b[1]\n"
      "ble 30f\n"
      "ldnt1b { z4.b }, p2/Z, [%x[B_ptr]]\n"
      "subs x22, x22, #0x4\n"
      "ldnt1b { z5.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "ldnt1b { z6.b }, p2/Z, [%x[B_ptr], #2, MUL VL]\n"
      "ldnt1b { z7.b }, p2/Z, [%x[B_ptr], #3, MUL VL]\n"
      "udot z24.s, z4.b, z0.b[2]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z25.s, z5.b, z0.b[2]\n"
      "udot z26.s, z6.b, z0.b[2]\n"
      "udot z27.s, z7.b, z0.b[2]\n"
      "ble 30f\n"
      "ldnt1b { z8.b }, p2/Z, [%x[B_ptr]]\n"
      "ldnt1b { z9.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "ldnt1b { z10.b }, p2/Z, [%x[B_ptr], #2, MUL VL]\n"
      "ldnt1b { z11.b }, p2/Z, [%x[B_ptr], #3, MUL VL]\n"
      "udot z24.s, z8.b, z0.b[3]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z25.s, z9.b, z0.b[3]\n"
      "udot z26.s, z10.b, z0.b[3]\n"
      "udot z27.s, z11.b, z0.b[3]\n"
      "30:"  // Width 4: Multiply loop: multiply skip
      "tbnz %x[flags], #31, 31f\n"
      "udot z22.s, z0.b, z23.b\n"
      "31:"  // Width 4: Multiply loop: unique 8: skip row sum
      "tbnz %x[flags], #31, 32f\n"
      "add x21, %x[qp], %[b_offset]\n"
      "mov x20, #0x4\n"
      "ld1rw { z4.s }, p2/Z, [x21]\n"
      "whilelt p0.s, XZR, x20\n"
      "uaddv d22, p0, z22.s\n"
      "mov z22.s, z22.s[0]\n"
      "neg z4.s, p2/M, z4.s\n"
      "mul z22.s, p2/M, z22.s, z4.s\n"
      "32:"  // Width 4: skip row sum fixup
      "add z24.s, z24.s, z22.s\n"
      "add z25.s, z25.s, z22.s\n"
      "ld1w { z0.s }, p2/Z, [x27]\n"
      "add x24, %x[qp], %[per_layer_mul]\n"
      "add z26.s, z26.s, z22.s\n"
      "add z27.s, z27.s, z22.s\n"
      "ld1w { z1.s }, p2/Z, [x27, #1, MUL VL]\n"
      "add x23, %x[qp], %[per_layer_right_shift]\n"
      "ld1w { z2.s }, p2/Z, [x27, #2, MUL VL]\n"
      "add x22, %x[qp], %[c_offset]\n"
      "add x21, %x[qp], %[minval]\n"
      "ld1w { z3.s }, p2/Z, [x27, #3, MUL VL]\n"
      "add x20, %x[qp], %[maxval]\n"
      "orr %x[flags], %x[flags], #0x80000000\n"
      "add z24.s, z24.s, z0.s\n"
      "add z25.s, z25.s, z1.s\n"
      "ld1rw { z8.s }, p2/Z, [x24]\n"
      "add z26.s, z26.s, z2.s\n"
      "ld1rw { z0.s }, p2/Z, [x23]\n"
      "add z27.s, z27.s, z3.s\n"
      "ld1rw { z9.s }, p2/Z, [x21]\n"
      "ld1rw { z10.s }, p2/Z, [x20]\n"
      ".inst 0x04a87318  // sqdmulh z24.s, z24.s, z8.s\n"
      ".inst 0x04a87339  // sqdmulh z25.s, z25.s, z8.s\n"
      ".inst 0x04a8735a  // sqdmulh z26.s, z26.s, z8.s\n"
      ".inst 0x04a8737b  // sqdmulh z27.s, z27.s, z8.s\n"
      "ld1rw { z8.s }, p2/Z, [x22]\n"
      ".inst 0x44828818  // srshl z24.s, p2/M, z24.s, z0.s\n"
      ".inst 0x44828819  // srshl z25.s, p2/M, z25.s, z0.s\n"
      ".inst 0x4482881a  // srshl z26.s, p2/M, z26.s, z0.s\n"
      ".inst 0x4482881b  // srshl z27.s, p2/M, z27.s, z0.s\n"
      "add z24.s, z24.s, z8.s\n"
      "add z25.s, z25.s, z8.s\n"
      "add z26.s, z26.s, z8.s\n"
      "add z27.s, z27.s, z8.s\n"
      ".inst 0x448ac138  // sclamp z24.s, z9.s, z10.s\n"
      ".inst 0x448ac139  // sclamp z25.s, z9.s, z10.s\n"
      ".inst 0x448ac13a  // sclamp z26.s, z9.s, z10.s\n"
      ".inst 0x448ac13b  // sclamp z27.s, z9.s, z10.s\n"
      "uzp1 z24.h, z24.h, z25.h\n"
      "uzp1 z25.h, z26.h, z27.h\n"
      "uzp1 z24.b, z24.b, z25.b\n"
      "st1b { z24.b }, p1, [%x[output_ptr]]\n"
      "addvl %x[output_ptr], %x[output_ptr], #1\n"
      "b 65f\n"
      "33:"  // Width 5
      "lsl x20, x26, #0x2\n"
      "mov x22, %x[K]\n"
      "mov z24.s, #0\n"
      "mov z25.s, #0\n"
      "sub x20, %x[N], x20\n"
      "mov x21, %x[A_ptr]\n"
      "mov z26.s, #0\n"
      "mov z27.s, #0\n"
      "whilelt p1.b, XZR, x20\n"
      "mov z28.s, #0\n"
      "cmp x22, #0x10\n"
      "ble 37f\n"
      "35:"  // Width 5: Multiply loop: Main loop head
      "whilelt p0.b, XZR, x22\n"
      "ldnt1b { z1.b }, p2/Z, [%x[B_ptr]]\n"
      "ld1rqb { z0.b }, p0/Z, [x21]\n"
      "add x21, x21, #0x10\n"
      "ldnt1b { z2.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "ldnt1b { z3.b }, p2/Z, [%x[B_ptr], #2, MUL VL]\n"
      "ldnt1b { z4.b }, p2/Z, [%x[B_ptr], #3, MUL VL]\n"
      "udot z24.s, z1.b, z0.b[0]\n"
      "ldnt1b { z5.b }, p2/Z, [%x[B_ptr], #4, MUL VL]\n"
      "udot z25.s, z2.b, z0.b[0]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z26.s, z3.b, z0.b[0]\n"
      "ldnt1b { z6.b }, p2/Z, [%x[B_ptr]]\n"
      "udot z27.s, z4.b, z0.b[0]\n"
      "ldnt1b { z7.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "udot z28.s, z5.b, z0.b[0]\n"
      "ldnt1b { z8.b }, p2/Z, [%x[B_ptr], #2, MUL VL]\n"
      "ldnt1b { z9.b }, p2/Z, [%x[B_ptr], #3, MUL VL]\n"
      "udot z24.s, z6.b, z0.b[1]\n"
      "ldnt1b { z10.b }, p2/Z, [%x[B_ptr], #4, MUL VL]\n"
      "udot z25.s, z7.b, z0.b[1]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z26.s, z8.b, z0.b[1]\n"
      "ldnt1b { z11.b }, p2/Z, [%x[B_ptr]]\n"
      "udot z27.s, z9.b, z0.b[1]\n"
      "ldnt1b { z12.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "udot z28.s, z10.b, z0.b[1]\n"
      "ldnt1b { z13.b }, p2/Z, [%x[B_ptr], #2, MUL VL]\n"
      "ldnt1b { z14.b }, p2/Z, [%x[B_ptr], #3, MUL VL]\n"
      "udot z24.s, z11.b, z0.b[2]\n"
      "ldnt1b { z15.b }, p2/Z, [%x[B_ptr], #4, MUL VL]\n"
      "udot z25.s, z12.b, z0.b[2]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z26.s, z13.b, z0.b[2]\n"
      "ldnt1b { z16.b }, p2/Z, [%x[B_ptr]]\n"
      "udot z27.s, z14.b, z0.b[2]\n"
      "ldnt1b { z17.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "udot z28.s, z15.b, z0.b[2]\n"
      "ldnt1b { z18.b }, p2/Z, [%x[B_ptr], #2, MUL VL]\n"
      "ldnt1b { z19.b }, p2/Z, [%x[B_ptr], #3, MUL VL]\n"
      "udot z24.s, z16.b, z0.b[3]\n"
      "ldnt1b { z20.b }, p2/Z, [%x[B_ptr], #4, MUL VL]\n"
      "udot z25.s, z17.b, z0.b[3]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z26.s, z18.b, z0.b[3]\n"
      "udot z27.s, z19.b, z0.b[3]\n"
      "udot z28.s, z20.b, z0.b[3]\n"
      "tbnz %x[flags], #31, 36f\n"
      "udot z22.s, z0.b, z23.b\n"
      "36:"  // Width 5: Multiply loop: unique 9: skip row sum
      "sub x22, x22, #0x10\n"
      "cmp x22, #0x10\n"
      "bgt 35b\n"
      "37:"  // Width 5: Multiply loop: Single iteration only
      "whilelt p0.b, XZR, x22\n"
      "ldnt1b { z21.b }, p2/Z, [%x[B_ptr]]\n"
      "subs x22, x22, #0x4\n"
      "ld1rqb { z0.b }, p0/Z, [x21]\n"
      "ldnt1b { z1.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "ldnt1b { z2.b }, p2/Z, [%x[B_ptr], #2, MUL VL]\n"
      "ldnt1b { z3.b }, p2/Z, [%x[B_ptr], #3, MUL VL]\n"
      "udot z24.s, z21.b, z0.b[0]\n"
      "ldnt1b { z4.b }, p2/Z, [%x[B_ptr], #4, MUL VL]\n"
      "udot z25.s, z1.b, z0.b[0]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z26.s, z2.b, z0.b[0]\n"
      "udot z27.s, z3.b, z0.b[0]\n"
      "udot z28.s, z4.b, z0.b[0]\n"
      "ble 38f\n"
      "ldnt1b { z5.b }, p2/Z, [%x[B_ptr]]\n"
      "subs x22, x22, #0x4\n"
      "ldnt1b { z6.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "ldnt1b { z7.b }, p2/Z, [%x[B_ptr], #2, MUL VL]\n"
      "ldnt1b { z8.b }, p2/Z, [%x[B_ptr], #3, MUL VL]\n"
      "udot z24.s, z5.b, z0.b[1]\n"
      "ldnt1b { z9.b }, p2/Z, [%x[B_ptr], #4, MUL VL]\n"
      "udot z25.s, z6.b, z0.b[1]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z26.s, z7.b, z0.b[1]\n"
      "udot z27.s, z8.b, z0.b[1]\n"
      "udot z28.s, z9.b, z0.b[1]\n"
      "ble 38f\n"
      "ldnt1b { z10.b }, p2/Z, [%x[B_ptr]]\n"
      "subs x22, x22, #0x4\n"
      "ldnt1b { z11.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "ldnt1b { z12.b }, p2/Z, [%x[B_ptr], #2, MUL VL]\n"
      "ldnt1b { z13.b }, p2/Z, [%x[B_ptr], #3, MUL VL]\n"
      "udot z24.s, z10.b, z0.b[2]\n"
      "ldnt1b { z14.b }, p2/Z, [%x[B_ptr], #4, MUL VL]\n"
      "udot z25.s, z11.b, z0.b[2]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z26.s, z12.b, z0.b[2]\n"
      "udot z27.s, z13.b, z0.b[2]\n"
      "udot z28.s, z14.b, z0.b[2]\n"
      "ble 38f\n"
      "ldnt1b { z15.b }, p2/Z, [%x[B_ptr]]\n"
      "ldnt1b { z16.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "ldnt1b { z17.b }, p2/Z, [%x[B_ptr], #2, MUL VL]\n"
      "ldnt1b { z18.b }, p2/Z, [%x[B_ptr], #3, MUL VL]\n"
      "udot z24.s, z15.b, z0.b[3]\n"
      "ldnt1b { z19.b }, p2/Z, [%x[B_ptr], #4, MUL VL]\n"
      "udot z25.s, z16.b, z0.b[3]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z26.s, z17.b, z0.b[3]\n"
      "udot z27.s, z18.b, z0.b[3]\n"
      "udot z28.s, z19.b, z0.b[3]\n"
      "38:"  // Width 5: Multiply loop: multiply skip
      "tbnz %x[flags], #31, 39f\n"
      "udot z22.s, z0.b, z23.b\n"
      "39:"  // Width 5: Multiply loop: unique 10: skip row sum
      "tbnz %x[flags], #31, 40f\n"
      "add x21, %x[qp], %[b_offset]\n"
      "mov x20, #0x4\n"
      "ld1rw { z5.s }, p2/Z, [x21]\n"
      "whilelt p0.s, XZR, x20\n"
      "uaddv d22, p0, z22.s\n"
      "mov z22.s, z22.s[0]\n"
      "neg z5.s, p2/M, z5.s\n"
      "mul z22.s, p2/M, z22.s, z5.s\n"
      "40:"  // Width 5: skip row sum fixup
      "add z24.s, z24.s, z22.s\n"
      "add z25.s, z25.s, z22.s\n"
      "ld1w { z0.s }, p2/Z, [x27]\n"
      "add x24, %x[qp], %[per_layer_mul]\n"
      "add z26.s, z26.s, z22.s\n"
      "add z27.s, z27.s, z22.s\n"
      "ld1w { z1.s }, p2/Z, [x27, #1, MUL VL]\n"
      "add x23, %x[qp], %[per_layer_right_shift]\n"
      "add z28.s, z28.s, z22.s\n"
      "ld1w { z2.s }, p2/Z, [x27, #2, MUL VL]\n"
      "add x22, %x[qp], %[c_offset]\n"
      "add x21, %x[qp], %[minval]\n"
      "ld1w { z3.s }, p2/Z, [x27, #3, MUL VL]\n"
      "add x20, %x[qp], %[maxval]\n"
      "orr %x[flags], %x[flags], #0x80000000\n"
      "ld1w { z4.s }, p2/Z, [x27, #4, MUL VL]\n"
      "add z24.s, z24.s, z0.s\n"
      "add z25.s, z25.s, z1.s\n"
      "add z26.s, z26.s, z2.s\n"
      "ld1rw { z8.s }, p2/Z, [x24]\n"
      "add z27.s, z27.s, z3.s\n"
      "ld1rw { z0.s }, p2/Z, [x23]\n"
      "add z28.s, z28.s, z4.s\n"
      "ld1rw { z9.s }, p2/Z, [x21]\n"
      ".inst 0x04a87318  // sqdmulh z24.s, z24.s, z8.s\n"
      ".inst 0x04a87339  // sqdmulh z25.s, z25.s, z8.s\n"
      "ld1rw { z10.s }, p2/Z, [x20]\n"
      ".inst 0x04a8735a  // sqdmulh z26.s, z26.s, z8.s\n"
      ".inst 0x04a8737b  // sqdmulh z27.s, z27.s, z8.s\n"
      ".inst 0x04a8739c  // sqdmulh z28.s, z28.s, z8.s\n"
      "ld1rw { z8.s }, p2/Z, [x22]\n"
      ".inst 0x44828818  // srshl z24.s, p2/M, z24.s, z0.s\n"
      ".inst 0x44828819  // srshl z25.s, p2/M, z25.s, z0.s\n"
      ".inst 0x4482881a  // srshl z26.s, p2/M, z26.s, z0.s\n"
      ".inst 0x4482881b  // srshl z27.s, p2/M, z27.s, z0.s\n"
      ".inst 0x4482881c  // srshl z28.s, p2/M, z28.s, z0.s\n"
      "add z24.s, z24.s, z8.s\n"
      "add z25.s, z25.s, z8.s\n"
      "add z26.s, z26.s, z8.s\n"
      "add z27.s, z27.s, z8.s\n"
      "add z28.s, z28.s, z8.s\n"
      ".inst 0x448ac138  // sclamp z24.s, z9.s, z10.s\n"
      ".inst 0x448ac139  // sclamp z25.s, z9.s, z10.s\n"
      ".inst 0x448ac13a  // sclamp z26.s, z9.s, z10.s\n"
      ".inst 0x448ac13b  // sclamp z27.s, z9.s, z10.s\n"
      ".inst 0x448ac13c  // sclamp z28.s, z9.s, z10.s\n"
      "uzp1 z24.h, z24.h, z25.h\n"
      "uzp1 z25.h, z26.h, z27.h\n"
      "uzp1 z26.h, z28.h, z29.h\n"
      "uzp1 z24.b, z24.b, z25.b\n"
      "uzp1 z25.b, z26.b, z27.b\n"
      "st1b { z24.b }, p2, [%x[output_ptr]]\n"
      "st1b { z25.b }, p1, [%x[output_ptr], #1, MUL VL]\n"
      "addvl %x[output_ptr], %x[output_ptr], #2\n"
      "b 65f\n"
      "41:"  // Width 6
      "lsl x20, x26, #0x2\n"
      "mov x22, %x[K]\n"
      "mov z24.s, #0\n"
      "mov z25.s, #0\n"
      "sub x20, %x[N], x20\n"
      "mov x21, %x[A_ptr]\n"
      "mov z26.s, #0\n"
      "mov z27.s, #0\n"
      "whilelt p1.b, XZR, x20\n"
      "mov z28.s, #0\n"
      "mov z29.s, #0\n"
      "cmp x22, #0x10\n"
      "ble 45f\n"
      "43:"  // Width 6: Multiply loop: Main loop head
      "whilelt p0.b, XZR, x22\n"
      "ldnt1b { z1.b }, p2/Z, [%x[B_ptr]]\n"
      "ld1rqb { z0.b }, p0/Z, [x21]\n"
      "add x21, x21, #0x10\n"
      "ldnt1b { z2.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "ldnt1b { z3.b }, p2/Z, [%x[B_ptr], #2, MUL VL]\n"
      "ldnt1b { z4.b }, p2/Z, [%x[B_ptr], #3, MUL VL]\n"
      "udot z24.s, z1.b, z0.b[0]\n"
      "ldnt1b { z5.b }, p2/Z, [%x[B_ptr], #4, MUL VL]\n"
      "udot z25.s, z2.b, z0.b[0]\n"
      "ldnt1b { z6.b }, p2/Z, [%x[B_ptr], #5, MUL VL]\n"
      "udot z26.s, z3.b, z0.b[0]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z27.s, z4.b, z0.b[0]\n"
      "ldnt1b { z7.b }, p2/Z, [%x[B_ptr]]\n"
      "udot z28.s, z5.b, z0.b[0]\n"
      "ldnt1b { z8.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "udot z29.s, z6.b, z0.b[0]\n"
      "ldnt1b { z9.b }, p2/Z, [%x[B_ptr], #2, MUL VL]\n"
      "ldnt1b { z10.b }, p2/Z, [%x[B_ptr], #3, MUL VL]\n"
      "udot z24.s, z7.b, z0.b[1]\n"
      "ldnt1b { z11.b }, p2/Z, [%x[B_ptr], #4, MUL VL]\n"
      "udot z25.s, z8.b, z0.b[1]\n"
      "ldnt1b { z12.b }, p2/Z, [%x[B_ptr], #5, MUL VL]\n"
      "udot z26.s, z9.b, z0.b[1]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z27.s, z10.b, z0.b[1]\n"
      "ldnt1b { z13.b }, p2/Z, [%x[B_ptr]]\n"
      "udot z28.s, z11.b, z0.b[1]\n"
      "ldnt1b { z14.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "udot z29.s, z12.b, z0.b[1]\n"
      "ldnt1b { z15.b }, p2/Z, [%x[B_ptr], #2, MUL VL]\n"
      "ldnt1b { z16.b }, p2/Z, [%x[B_ptr], #3, MUL VL]\n"
      "udot z24.s, z13.b, z0.b[2]\n"
      "ldnt1b { z17.b }, p2/Z, [%x[B_ptr], #4, MUL VL]\n"
      "udot z25.s, z14.b, z0.b[2]\n"
      "ldnt1b { z18.b }, p2/Z, [%x[B_ptr], #5, MUL VL]\n"
      "udot z26.s, z15.b, z0.b[2]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z27.s, z16.b, z0.b[2]\n"
      "ldnt1b { z19.b }, p2/Z, [%x[B_ptr]]\n"
      "udot z28.s, z17.b, z0.b[2]\n"
      "ldnt1b { z20.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "udot z29.s, z18.b, z0.b[2]\n"
      "ldnt1b { z21.b }, p2/Z, [%x[B_ptr], #2, MUL VL]\n"
      "ldnt1b { z1.b }, p2/Z, [%x[B_ptr], #3, MUL VL]\n"
      "udot z24.s, z19.b, z0.b[3]\n"
      "ldnt1b { z2.b }, p2/Z, [%x[B_ptr], #4, MUL VL]\n"
      "udot z25.s, z20.b, z0.b[3]\n"
      "ldnt1b { z3.b }, p2/Z, [%x[B_ptr], #5, MUL VL]\n"
      "udot z26.s, z21.b, z0.b[3]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z27.s, z1.b, z0.b[3]\n"
      "udot z28.s, z2.b, z0.b[3]\n"
      "udot z29.s, z3.b, z0.b[3]\n"
      "tbnz %x[flags], #31, 44f\n"
      "udot z22.s, z0.b, z23.b\n"
      "44:"  // Width 6: Multiply loop: unique 11: skip row sum
      "sub x22, x22, #0x10\n"
      "cmp x22, #0x10\n"
      "bgt 43b\n"
      "45:"  // Width 6: Multiply loop: Single iteration only
      "whilelt p0.b, XZR, x22\n"
      "ldnt1b { z4.b }, p2/Z, [%x[B_ptr]]\n"
      "subs x22, x22, #0x4\n"
      "ld1rqb { z0.b }, p0/Z, [x21]\n"
      "ldnt1b { z5.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "ldnt1b { z6.b }, p2/Z, [%x[B_ptr], #2, MUL VL]\n"
      "ldnt1b { z7.b }, p2/Z, [%x[B_ptr], #3, MUL VL]\n"
      "udot z24.s, z4.b, z0.b[0]\n"
      "ldnt1b { z8.b }, p2/Z, [%x[B_ptr], #4, MUL VL]\n"
      "udot z25.s, z5.b, z0.b[0]\n"
      "ldnt1b { z9.b }, p2/Z, [%x[B_ptr], #5, MUL VL]\n"
      "udot z26.s, z6.b, z0.b[0]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z27.s, z7.b, z0.b[0]\n"
      "udot z28.s, z8.b, z0.b[0]\n"
      "udot z29.s, z9.b, z0.b[0]\n"
      "ble 46f\n"
      "ldnt1b { z10.b }, p2/Z, [%x[B_ptr]]\n"
      "subs x22, x22, #0x4\n"
      "ldnt1b { z11.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "ldnt1b { z12.b }, p2/Z, [%x[B_ptr], #2, MUL VL]\n"
      "ldnt1b { z13.b }, p2/Z, [%x[B_ptr], #3, MUL VL]\n"
      "udot z24.s, z10.b, z0.b[1]\n"
      "ldnt1b { z14.b }, p2/Z, [%x[B_ptr], #4, MUL VL]\n"
      "udot z25.s, z11.b, z0.b[1]\n"
      "ldnt1b { z15.b }, p2/Z, [%x[B_ptr], #5, MUL VL]\n"
      "udot z26.s, z12.b, z0.b[1]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z27.s, z13.b, z0.b[1]\n"
      "udot z28.s, z14.b, z0.b[1]\n"
      "udot z29.s, z15.b, z0.b[1]\n"
      "ble 46f\n"
      "ldnt1b { z16.b }, p2/Z, [%x[B_ptr]]\n"
      "subs x22, x22, #0x4\n"
      "ldnt1b { z17.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "ldnt1b { z18.b }, p2/Z, [%x[B_ptr], #2, MUL VL]\n"
      "ldnt1b { z19.b }, p2/Z, [%x[B_ptr], #3, MUL VL]\n"
      "udot z24.s, z16.b, z0.b[2]\n"
      "ldnt1b { z20.b }, p2/Z, [%x[B_ptr], #4, MUL VL]\n"
      "udot z25.s, z17.b, z0.b[2]\n"
      "ldnt1b { z21.b }, p2/Z, [%x[B_ptr], #5, MUL VL]\n"
      "udot z26.s, z18.b, z0.b[2]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z27.s, z19.b, z0.b[2]\n"
      "udot z28.s, z20.b, z0.b[2]\n"
      "udot z29.s, z21.b, z0.b[2]\n"
      "ble 46f\n"
      "ldnt1b { z1.b }, p2/Z, [%x[B_ptr]]\n"
      "ldnt1b { z2.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "ldnt1b { z3.b }, p2/Z, [%x[B_ptr], #2, MUL VL]\n"
      "ldnt1b { z4.b }, p2/Z, [%x[B_ptr], #3, MUL VL]\n"
      "udot z24.s, z1.b, z0.b[3]\n"
      "ldnt1b { z5.b }, p2/Z, [%x[B_ptr], #4, MUL VL]\n"
      "udot z25.s, z2.b, z0.b[3]\n"
      "ldnt1b { z6.b }, p2/Z, [%x[B_ptr], #5, MUL VL]\n"
      "udot z26.s, z3.b, z0.b[3]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z27.s, z4.b, z0.b[3]\n"
      "udot z28.s, z5.b, z0.b[3]\n"
      "udot z29.s, z6.b, z0.b[3]\n"
      "46:"  // Width 6: Multiply loop: multiply skip
      "tbnz %x[flags], #31, 47f\n"
      "udot z22.s, z0.b, z23.b\n"
      "47:"  // Width 6: Multiply loop: unique 12: skip row sum
      "tbnz %x[flags], #31, 48f\n"
      "add x21, %x[qp], %[b_offset]\n"
      "mov x20, #0x4\n"
      "ld1rw { z6.s }, p2/Z, [x21]\n"
      "whilelt p0.s, XZR, x20\n"
      "uaddv d22, p0, z22.s\n"
      "mov z22.s, z22.s[0]\n"
      "neg z6.s, p2/M, z6.s\n"
      "mul z22.s, p2/M, z22.s, z6.s\n"
      "48:"  // Width 6: skip row sum fixup
      "add z24.s, z24.s, z22.s\n"
      "add z25.s, z25.s, z22.s\n"
      "ld1w { z0.s }, p2/Z, [x27]\n"
      "add x24, %x[qp], %[per_layer_mul]\n"
      "add z26.s, z26.s, z22.s\n"
      "add z27.s, z27.s, z22.s\n"
      "ld1w { z1.s }, p2/Z, [x27, #1, MUL VL]\n"
      "add x23, %x[qp], %[per_layer_right_shift]\n"
      "add z28.s, z28.s, z22.s\n"
      "add z29.s, z29.s, z22.s\n"
      "ld1w { z2.s }, p2/Z, [x27, #2, MUL VL]\n"
      "add x22, %x[qp], %[c_offset]\n"
      "ld1w { z3.s }, p2/Z, [x27, #3, MUL VL]\n"
      "add x21, %x[qp], %[minval]\n"
      "add x20, %x[qp], %[maxval]\n"
      "ld1w { z4.s }, p2/Z, [x27, #4, MUL VL]\n"
      "add z24.s, z24.s, z0.s\n"
      "add z25.s, z25.s, z1.s\n"
      "orr %x[flags], %x[flags], #0x80000000\n"
      "ld1w { z5.s }, p2/Z, [x27, #5, MUL VL]\n"
      "add z26.s, z26.s, z2.s\n"
      "add z27.s, z27.s, z3.s\n"
      "ld1rw { z8.s }, p2/Z, [x24]\n"
      "add z28.s, z28.s, z4.s\n"
      "ld1rw { z0.s }, p2/Z, [x23]\n"
      "add z29.s, z29.s, z5.s\n"
      "ld1rw { z9.s }, p2/Z, [x21]\n"
      ".inst 0x04a87318  // sqdmulh z24.s, z24.s, z8.s\n"
      ".inst 0x04a87339  // sqdmulh z25.s, z25.s, z8.s\n"
      "ld1rw { z10.s }, p2/Z, [x20]\n"
      ".inst 0x04a8735a  // sqdmulh z26.s, z26.s, z8.s\n"
      ".inst 0x04a8737b  // sqdmulh z27.s, z27.s, z8.s\n"
      ".inst 0x04a8739c  // sqdmulh z28.s, z28.s, z8.s\n"
      ".inst 0x04a873bd  // sqdmulh z29.s, z29.s, z8.s\n"
      "ld1rw { z8.s }, p2/Z, [x22]\n"
      ".inst 0x44828818  // srshl z24.s, p2/M, z24.s, z0.s\n"
      ".inst 0x44828819  // srshl z25.s, p2/M, z25.s, z0.s\n"
      ".inst 0x4482881a  // srshl z26.s, p2/M, z26.s, z0.s\n"
      ".inst 0x4482881b  // srshl z27.s, p2/M, z27.s, z0.s\n"
      ".inst 0x4482881c  // srshl z28.s, p2/M, z28.s, z0.s\n"
      ".inst 0x4482881d  // srshl z29.s, p2/M, z29.s, z0.s\n"
      "add z24.s, z24.s, z8.s\n"
      "add z25.s, z25.s, z8.s\n"
      "add z26.s, z26.s, z8.s\n"
      "add z27.s, z27.s, z8.s\n"
      "add z28.s, z28.s, z8.s\n"
      "add z29.s, z29.s, z8.s\n"
      ".inst 0x448ac138  // sclamp z24.s, z9.s, z10.s\n"
      ".inst 0x448ac139  // sclamp z25.s, z9.s, z10.s\n"
      ".inst 0x448ac13a  // sclamp z26.s, z9.s, z10.s\n"
      ".inst 0x448ac13b  // sclamp z27.s, z9.s, z10.s\n"
      ".inst 0x448ac13c  // sclamp z28.s, z9.s, z10.s\n"
      ".inst 0x448ac13d  // sclamp z29.s, z9.s, z10.s\n"
      "uzp1 z24.h, z24.h, z25.h\n"
      "uzp1 z25.h, z26.h, z27.h\n"
      "uzp1 z26.h, z28.h, z29.h\n"
      "uzp1 z24.b, z24.b, z25.b\n"
      "uzp1 z25.b, z26.b, z27.b\n"
      "st1b { z24.b }, p2, [%x[output_ptr]]\n"
      "st1b { z25.b }, p1, [%x[output_ptr], #1, MUL VL]\n"
      "addvl %x[output_ptr], %x[output_ptr], #2\n"
      "b 65f\n"
      "49:"  // Width 7
      "lsl x20, x26, #0x2\n"
      "mov x22, %x[K]\n"
      "mov z24.s, #0\n"
      "mov z25.s, #0\n"
      "sub x20, %x[N], x20\n"
      "mov x21, %x[A_ptr]\n"
      "mov z26.s, #0\n"
      "mov z27.s, #0\n"
      "whilelt p1.b, XZR, x20\n"
      "mov z28.s, #0\n"
      "mov z29.s, #0\n"
      "mov z30.s, #0\n"
      "cmp x22, #0x10\n"
      "ble 53f\n"
      "51:"  // Width 7: Multiply loop: Main loop head
      "whilelt p0.b, XZR, x22\n"
      "ldnt1b { z1.b }, p2/Z, [%x[B_ptr]]\n"
      "ld1rqb { z0.b }, p0/Z, [x21]\n"
      "add x21, x21, #0x10\n"
      "ldnt1b { z2.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "ldnt1b { z3.b }, p2/Z, [%x[B_ptr], #2, MUL VL]\n"
      "ldnt1b { z4.b }, p2/Z, [%x[B_ptr], #3, MUL VL]\n"
      "udot z24.s, z1.b, z0.b[0]\n"
      "ldnt1b { z5.b }, p2/Z, [%x[B_ptr], #4, MUL VL]\n"
      "udot z25.s, z2.b, z0.b[0]\n"
      "ldnt1b { z6.b }, p2/Z, [%x[B_ptr], #5, MUL VL]\n"
      "udot z26.s, z3.b, z0.b[0]\n"
      "ldnt1b { z7.b }, p2/Z, [%x[B_ptr], #6, MUL VL]\n"
      "udot z27.s, z4.b, z0.b[0]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z28.s, z5.b, z0.b[0]\n"
      "ldnt1b { z8.b }, p2/Z, [%x[B_ptr]]\n"
      "udot z29.s, z6.b, z0.b[0]\n"
      "ldnt1b { z9.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "udot z30.s, z7.b, z0.b[0]\n"
      "ldnt1b { z10.b }, p2/Z, [%x[B_ptr], #2, MUL VL]\n"
      "ldnt1b { z11.b }, p2/Z, [%x[B_ptr], #3, MUL VL]\n"
      "udot z24.s, z8.b, z0.b[1]\n"
      "ldnt1b { z12.b }, p2/Z, [%x[B_ptr], #4, MUL VL]\n"
      "udot z25.s, z9.b, z0.b[1]\n"
      "ldnt1b { z13.b }, p2/Z, [%x[B_ptr], #5, MUL VL]\n"
      "udot z26.s, z10.b, z0.b[1]\n"
      "ldnt1b { z14.b }, p2/Z, [%x[B_ptr], #6, MUL VL]\n"
      "udot z27.s, z11.b, z0.b[1]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z28.s, z12.b, z0.b[1]\n"
      "ldnt1b { z15.b }, p2/Z, [%x[B_ptr]]\n"
      "udot z29.s, z13.b, z0.b[1]\n"
      "ldnt1b { z16.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "udot z30.s, z14.b, z0.b[1]\n"
      "ldnt1b { z17.b }, p2/Z, [%x[B_ptr], #2, MUL VL]\n"
      "ldnt1b { z18.b }, p2/Z, [%x[B_ptr], #3, MUL VL]\n"
      "udot z24.s, z15.b, z0.b[2]\n"
      "ldnt1b { z19.b }, p2/Z, [%x[B_ptr], #4, MUL VL]\n"
      "udot z25.s, z16.b, z0.b[2]\n"
      "ldnt1b { z20.b }, p2/Z, [%x[B_ptr], #5, MUL VL]\n"
      "udot z26.s, z17.b, z0.b[2]\n"
      "ldnt1b { z21.b }, p2/Z, [%x[B_ptr], #6, MUL VL]\n"
      "udot z27.s, z18.b, z0.b[2]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z28.s, z19.b, z0.b[2]\n"
      "ldnt1b { z1.b }, p2/Z, [%x[B_ptr]]\n"
      "udot z29.s, z20.b, z0.b[2]\n"
      "ldnt1b { z2.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "udot z30.s, z21.b, z0.b[2]\n"
      "ldnt1b { z3.b }, p2/Z, [%x[B_ptr], #2, MUL VL]\n"
      "ldnt1b { z4.b }, p2/Z, [%x[B_ptr], #3, MUL VL]\n"
      "udot z24.s, z1.b, z0.b[3]\n"
      "ldnt1b { z5.b }, p2/Z, [%x[B_ptr], #4, MUL VL]\n"
      "udot z25.s, z2.b, z0.b[3]\n"
      "ldnt1b { z6.b }, p2/Z, [%x[B_ptr], #5, MUL VL]\n"
      "udot z26.s, z3.b, z0.b[3]\n"
      "ldnt1b { z7.b }, p2/Z, [%x[B_ptr], #6, MUL VL]\n"
      "udot z27.s, z4.b, z0.b[3]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z28.s, z5.b, z0.b[3]\n"
      "udot z29.s, z6.b, z0.b[3]\n"
      "udot z30.s, z7.b, z0.b[3]\n"
      "tbnz %x[flags], #31, 52f\n"
      "udot z22.s, z0.b, z23.b\n"
      "52:"  // Width 7: Multiply loop: unique 13: skip row sum
      "sub x22, x22, #0x10\n"
      "cmp x22, #0x10\n"
      "bgt 51b\n"
      "53:"  // Width 7: Multiply loop: Single iteration only
      "whilelt p0.b, XZR, x22\n"
      "ldnt1b { z8.b }, p2/Z, [%x[B_ptr]]\n"
      "subs x22, x22, #0x4\n"
      "ld1rqb { z0.b }, p0/Z, [x21]\n"
      "ldnt1b { z9.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "ldnt1b { z10.b }, p2/Z, [%x[B_ptr], #2, MUL VL]\n"
      "ldnt1b { z11.b }, p2/Z, [%x[B_ptr], #3, MUL VL]\n"
      "udot z24.s, z8.b, z0.b[0]\n"
      "ldnt1b { z12.b }, p2/Z, [%x[B_ptr], #4, MUL VL]\n"
      "udot z25.s, z9.b, z0.b[0]\n"
      "ldnt1b { z13.b }, p2/Z, [%x[B_ptr], #5, MUL VL]\n"
      "udot z26.s, z10.b, z0.b[0]\n"
      "ldnt1b { z14.b }, p2/Z, [%x[B_ptr], #6, MUL VL]\n"
      "udot z27.s, z11.b, z0.b[0]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z28.s, z12.b, z0.b[0]\n"
      "udot z29.s, z13.b, z0.b[0]\n"
      "udot z30.s, z14.b, z0.b[0]\n"
      "ble 54f\n"
      "ldnt1b { z15.b }, p2/Z, [%x[B_ptr]]\n"
      "subs x22, x22, #0x4\n"
      "ldnt1b { z16.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "ldnt1b { z17.b }, p2/Z, [%x[B_ptr], #2, MUL VL]\n"
      "ldnt1b { z18.b }, p2/Z, [%x[B_ptr], #3, MUL VL]\n"
      "udot z24.s, z15.b, z0.b[1]\n"
      "ldnt1b { z19.b }, p2/Z, [%x[B_ptr], #4, MUL VL]\n"
      "udot z25.s, z16.b, z0.b[1]\n"
      "ldnt1b { z20.b }, p2/Z, [%x[B_ptr], #5, MUL VL]\n"
      "udot z26.s, z17.b, z0.b[1]\n"
      "ldnt1b { z21.b }, p2/Z, [%x[B_ptr], #6, MUL VL]\n"
      "udot z27.s, z18.b, z0.b[1]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z28.s, z19.b, z0.b[1]\n"
      "udot z29.s, z20.b, z0.b[1]\n"
      "udot z30.s, z21.b, z0.b[1]\n"
      "ble 54f\n"
      "ldnt1b { z1.b }, p2/Z, [%x[B_ptr]]\n"
      "subs x22, x22, #0x4\n"
      "ldnt1b { z2.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "ldnt1b { z3.b }, p2/Z, [%x[B_ptr], #2, MUL VL]\n"
      "ldnt1b { z4.b }, p2/Z, [%x[B_ptr], #3, MUL VL]\n"
      "udot z24.s, z1.b, z0.b[2]\n"
      "ldnt1b { z5.b }, p2/Z, [%x[B_ptr], #4, MUL VL]\n"
      "udot z25.s, z2.b, z0.b[2]\n"
      "ldnt1b { z6.b }, p2/Z, [%x[B_ptr], #5, MUL VL]\n"
      "udot z26.s, z3.b, z0.b[2]\n"
      "ldnt1b { z7.b }, p2/Z, [%x[B_ptr], #6, MUL VL]\n"
      "udot z27.s, z4.b, z0.b[2]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z28.s, z5.b, z0.b[2]\n"
      "udot z29.s, z6.b, z0.b[2]\n"
      "udot z30.s, z7.b, z0.b[2]\n"
      "ble 54f\n"
      "ldnt1b { z8.b }, p2/Z, [%x[B_ptr]]\n"
      "ldnt1b { z9.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "ldnt1b { z10.b }, p2/Z, [%x[B_ptr], #2, MUL VL]\n"
      "ldnt1b { z11.b }, p2/Z, [%x[B_ptr], #3, MUL VL]\n"
      "udot z24.s, z8.b, z0.b[3]\n"
      "ldnt1b { z12.b }, p2/Z, [%x[B_ptr], #4, MUL VL]\n"
      "udot z25.s, z9.b, z0.b[3]\n"
      "ldnt1b { z13.b }, p2/Z, [%x[B_ptr], #5, MUL VL]\n"
      "udot z26.s, z10.b, z0.b[3]\n"
      "ldnt1b { z14.b }, p2/Z, [%x[B_ptr], #6, MUL VL]\n"
      "udot z27.s, z11.b, z0.b[3]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z28.s, z12.b, z0.b[3]\n"
      "udot z29.s, z13.b, z0.b[3]\n"
      "udot z30.s, z14.b, z0.b[3]\n"
      "54:"  // Width 7: Multiply loop: multiply skip
      "tbnz %x[flags], #31, 55f\n"
      "udot z22.s, z0.b, z23.b\n"
      "55:"  // Width 7: Multiply loop: unique 14: skip row sum
      "tbnz %x[flags], #31, 56f\n"
      "add x21, %x[qp], %[b_offset]\n"
      "mov x20, #0x4\n"
      "ld1rw { z7.s }, p2/Z, [x21]\n"
      "whilelt p0.s, XZR, x20\n"
      "uaddv d22, p0, z22.s\n"
      "mov z22.s, z22.s[0]\n"
      "neg z7.s, p2/M, z7.s\n"
      "mul z22.s, p2/M, z22.s, z7.s\n"
      "56:"  // Width 7: skip row sum fixup
      "add z24.s, z24.s, z22.s\n"
      "add z25.s, z25.s, z22.s\n"
      "ld1w { z0.s }, p2/Z, [x27]\n"
      "add x24, %x[qp], %[per_layer_mul]\n"
      "add z26.s, z26.s, z22.s\n"
      "add z27.s, z27.s, z22.s\n"
      "ld1w { z1.s }, p2/Z, [x27, #1, MUL VL]\n"
      "add x23, %x[qp], %[per_layer_right_shift]\n"
      "add z28.s, z28.s, z22.s\n"
      "add z29.s, z29.s, z22.s\n"
      "ld1w { z2.s }, p2/Z, [x27, #2, MUL VL]\n"
      "add x22, %x[qp], %[c_offset]\n"
      "add z30.s, z30.s, z22.s\n"
      "ld1w { z3.s }, p2/Z, [x27, #3, MUL VL]\n"
      "add x21, %x[qp], %[minval]\n"
      "add x20, %x[qp], %[maxval]\n"
      "ld1w { z4.s }, p2/Z, [x27, #4, MUL VL]\n"
      "add z24.s, z24.s, z0.s\n"
      "add z25.s, z25.s, z1.s\n"
      "orr %x[flags], %x[flags], #0x80000000\n"
      "ld1w { z5.s }, p2/Z, [x27, #5, MUL VL]\n"
      "add z26.s, z26.s, z2.s\n"
      "ld1w { z6.s }, p2/Z, [x27, #6, MUL VL]\n"
      "add z27.s, z27.s, z3.s\n"
      "add z28.s, z28.s, z4.s\n"
      "ld1rw { z8.s }, p2/Z, [x24]\n"
      "add z29.s, z29.s, z5.s\n"
      "ld1rw { z0.s }, p2/Z, [x23]\n"
      "add z30.s, z30.s, z6.s\n"
      "ld1rw { z9.s }, p2/Z, [x21]\n"
      ".inst 0x04a87318  // sqdmulh z24.s, z24.s, z8.s\n"
      ".inst 0x04a87339  // sqdmulh z25.s, z25.s, z8.s\n"
      "ld1rw { z10.s }, p2/Z, [x20]\n"
      ".inst 0x04a8735a  // sqdmulh z26.s, z26.s, z8.s\n"
      ".inst 0x04a8737b  // sqdmulh z27.s, z27.s, z8.s\n"
      ".inst 0x04a8739c  // sqdmulh z28.s, z28.s, z8.s\n"
      ".inst 0x04a873bd  // sqdmulh z29.s, z29.s, z8.s\n"
      ".inst 0x04a873de  // sqdmulh z30.s, z30.s, z8.s\n"
      "ld1rw { z8.s }, p2/Z, [x22]\n"
      ".inst 0x44828818  // srshl z24.s, p2/M, z24.s, z0.s\n"
      ".inst 0x44828819  // srshl z25.s, p2/M, z25.s, z0.s\n"
      ".inst 0x4482881a  // srshl z26.s, p2/M, z26.s, z0.s\n"
      ".inst 0x4482881b  // srshl z27.s, p2/M, z27.s, z0.s\n"
      ".inst 0x4482881c  // srshl z28.s, p2/M, z28.s, z0.s\n"
      ".inst 0x4482881d  // srshl z29.s, p2/M, z29.s, z0.s\n"
      ".inst 0x4482881e  // srshl z30.s, p2/M, z30.s, z0.s\n"
      "add z24.s, z24.s, z8.s\n"
      "add z25.s, z25.s, z8.s\n"
      "add z26.s, z26.s, z8.s\n"
      "add z27.s, z27.s, z8.s\n"
      "add z28.s, z28.s, z8.s\n"
      "add z29.s, z29.s, z8.s\n"
      "add z30.s, z30.s, z8.s\n"
      ".inst 0x448ac138  // sclamp z24.s, z9.s, z10.s\n"
      ".inst 0x448ac139  // sclamp z25.s, z9.s, z10.s\n"
      ".inst 0x448ac13a  // sclamp z26.s, z9.s, z10.s\n"
      ".inst 0x448ac13b  // sclamp z27.s, z9.s, z10.s\n"
      ".inst 0x448ac13c  // sclamp z28.s, z9.s, z10.s\n"
      ".inst 0x448ac13d  // sclamp z29.s, z9.s, z10.s\n"
      ".inst 0x448ac13e  // sclamp z30.s, z9.s, z10.s\n"
      "uzp1 z24.h, z24.h, z25.h\n"
      "uzp1 z25.h, z26.h, z27.h\n"
      "uzp1 z26.h, z28.h, z29.h\n"
      "uzp1 z27.h, z30.h, z31.h\n"
      "uzp1 z24.b, z24.b, z25.b\n"
      "uzp1 z25.b, z26.b, z27.b\n"
      "st1b { z24.b }, p2, [%x[output_ptr]]\n"
      "st1b { z25.b }, p1, [%x[output_ptr], #1, MUL VL]\n"
      "addvl %x[output_ptr], %x[output_ptr], #2\n"
      "b 65f\n"
      "57:"  // Width 8
      "lsl x20, x26, #0x2\n"
      "mov x22, %x[K]\n"
      "mov z24.s, #0\n"
      "mov z25.s, #0\n"
      "sub x20, %x[N], x20\n"
      "mov x21, %x[A_ptr]\n"
      "mov z26.s, #0\n"
      "mov z27.s, #0\n"
      "whilelt p1.b, XZR, x20\n"
      "mov z28.s, #0\n"
      "mov z29.s, #0\n"
      "mov z30.s, #0\n"
      "mov z31.s, #0\n"
      "cmp x22, #0x10\n"
      "ble 61f\n"
      "59:"  // Width 8: Multiply loop: Main loop head
      "whilelt p0.b, XZR, x22\n"
      "ldnt1b { z1.b }, p2/Z, [%x[B_ptr]]\n"
      "ld1rqb { z0.b }, p0/Z, [x21]\n"
      "add x21, x21, #0x10\n"
      "ldnt1b { z2.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "ldnt1b { z3.b }, p2/Z, [%x[B_ptr], #2, MUL VL]\n"
      "ldnt1b { z4.b }, p2/Z, [%x[B_ptr], #3, MUL VL]\n"
      "udot z24.s, z1.b, z0.b[0]\n"
      "ldnt1b { z5.b }, p2/Z, [%x[B_ptr], #4, MUL VL]\n"
      "udot z25.s, z2.b, z0.b[0]\n"
      "ldnt1b { z6.b }, p2/Z, [%x[B_ptr], #5, MUL VL]\n"
      "udot z26.s, z3.b, z0.b[0]\n"
      "ldnt1b { z7.b }, p2/Z, [%x[B_ptr], #6, MUL VL]\n"
      "udot z27.s, z4.b, z0.b[0]\n"
      "ldnt1b { z8.b }, p2/Z, [%x[B_ptr], #7, MUL VL]\n"
      "udot z28.s, z5.b, z0.b[0]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z29.s, z6.b, z0.b[0]\n"
      "ldnt1b { z9.b }, p2/Z, [%x[B_ptr]]\n"
      "udot z30.s, z7.b, z0.b[0]\n"
      "ldnt1b { z10.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "udot z31.s, z8.b, z0.b[0]\n"
      "ldnt1b { z11.b }, p2/Z, [%x[B_ptr], #2, MUL VL]\n"
      "ldnt1b { z12.b }, p2/Z, [%x[B_ptr], #3, MUL VL]\n"
      "udot z24.s, z9.b, z0.b[1]\n"
      "ldnt1b { z13.b }, p2/Z, [%x[B_ptr], #4, MUL VL]\n"
      "udot z25.s, z10.b, z0.b[1]\n"
      "ldnt1b { z14.b }, p2/Z, [%x[B_ptr], #5, MUL VL]\n"
      "udot z26.s, z11.b, z0.b[1]\n"
      "ldnt1b { z15.b }, p2/Z, [%x[B_ptr], #6, MUL VL]\n"
      "udot z27.s, z12.b, z0.b[1]\n"
      "ldnt1b { z16.b }, p2/Z, [%x[B_ptr], #7, MUL VL]\n"
      "udot z28.s, z13.b, z0.b[1]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z29.s, z14.b, z0.b[1]\n"
      "ldnt1b { z17.b }, p2/Z, [%x[B_ptr]]\n"
      "udot z30.s, z15.b, z0.b[1]\n"
      "ldnt1b { z18.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "udot z31.s, z16.b, z0.b[1]\n"
      "ldnt1b { z19.b }, p2/Z, [%x[B_ptr], #2, MUL VL]\n"
      "ldnt1b { z20.b }, p2/Z, [%x[B_ptr], #3, MUL VL]\n"
      "udot z24.s, z17.b, z0.b[2]\n"
      "ldnt1b { z21.b }, p2/Z, [%x[B_ptr], #4, MUL VL]\n"
      "udot z25.s, z18.b, z0.b[2]\n"
      "ldnt1b { z1.b }, p2/Z, [%x[B_ptr], #5, MUL VL]\n"
      "udot z26.s, z19.b, z0.b[2]\n"
      "ldnt1b { z2.b }, p2/Z, [%x[B_ptr], #6, MUL VL]\n"
      "udot z27.s, z20.b, z0.b[2]\n"
      "ldnt1b { z3.b }, p2/Z, [%x[B_ptr], #7, MUL VL]\n"
      "udot z28.s, z21.b, z0.b[2]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z29.s, z1.b, z0.b[2]\n"
      "ldnt1b { z4.b }, p2/Z, [%x[B_ptr]]\n"
      "udot z30.s, z2.b, z0.b[2]\n"
      "ldnt1b { z5.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "udot z31.s, z3.b, z0.b[2]\n"
      "ldnt1b { z6.b }, p2/Z, [%x[B_ptr], #2, MUL VL]\n"
      "ldnt1b { z7.b }, p2/Z, [%x[B_ptr], #3, MUL VL]\n"
      "udot z24.s, z4.b, z0.b[3]\n"
      "ldnt1b { z8.b }, p2/Z, [%x[B_ptr], #4, MUL VL]\n"
      "udot z25.s, z5.b, z0.b[3]\n"
      "ldnt1b { z9.b }, p2/Z, [%x[B_ptr], #5, MUL VL]\n"
      "udot z26.s, z6.b, z0.b[3]\n"
      "ldnt1b { z10.b }, p2/Z, [%x[B_ptr], #6, MUL VL]\n"
      "udot z27.s, z7.b, z0.b[3]\n"
      "ldnt1b { z11.b }, p2/Z, [%x[B_ptr], #7, MUL VL]\n"
      "udot z28.s, z8.b, z0.b[3]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z29.s, z9.b, z0.b[3]\n"
      "udot z30.s, z10.b, z0.b[3]\n"
      "udot z31.s, z11.b, z0.b[3]\n"
      "tbnz %x[flags], #31, 60f\n"
      "udot z22.s, z0.b, z23.b\n"
      "60:"  // Width 8: Multiply loop: unique 15: skip row sum
      "sub x22, x22, #0x10\n"
      "cmp x22, #0x10\n"
      "bgt 59b\n"
      "61:"  // Width 8: Multiply loop: Single iteration only
      "whilelt p0.b, XZR, x22\n"
      "ldnt1b { z12.b }, p2/Z, [%x[B_ptr]]\n"
      "subs x22, x22, #0x4\n"
      "ld1rqb { z0.b }, p0/Z, [x21]\n"
      "ldnt1b { z13.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "ldnt1b { z14.b }, p2/Z, [%x[B_ptr], #2, MUL VL]\n"
      "ldnt1b { z15.b }, p2/Z, [%x[B_ptr], #3, MUL VL]\n"
      "udot z24.s, z12.b, z0.b[0]\n"
      "ldnt1b { z16.b }, p2/Z, [%x[B_ptr], #4, MUL VL]\n"
      "udot z25.s, z13.b, z0.b[0]\n"
      "ldnt1b { z17.b }, p2/Z, [%x[B_ptr], #5, MUL VL]\n"
      "udot z26.s, z14.b, z0.b[0]\n"
      "ldnt1b { z18.b }, p2/Z, [%x[B_ptr], #6, MUL VL]\n"
      "udot z27.s, z15.b, z0.b[0]\n"
      "ldnt1b { z19.b }, p2/Z, [%x[B_ptr], #7, MUL VL]\n"
      "udot z28.s, z16.b, z0.b[0]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z29.s, z17.b, z0.b[0]\n"
      "udot z30.s, z18.b, z0.b[0]\n"
      "udot z31.s, z19.b, z0.b[0]\n"
      "ble 62f\n"
      "ldnt1b { z20.b }, p2/Z, [%x[B_ptr]]\n"
      "subs x22, x22, #0x4\n"
      "ldnt1b { z21.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "ldnt1b { z1.b }, p2/Z, [%x[B_ptr], #2, MUL VL]\n"
      "ldnt1b { z2.b }, p2/Z, [%x[B_ptr], #3, MUL VL]\n"
      "udot z24.s, z20.b, z0.b[1]\n"
      "ldnt1b { z3.b }, p2/Z, [%x[B_ptr], #4, MUL VL]\n"
      "udot z25.s, z21.b, z0.b[1]\n"
      "ldnt1b { z4.b }, p2/Z, [%x[B_ptr], #5, MUL VL]\n"
      "udot z26.s, z1.b, z0.b[1]\n"
      "ldnt1b { z5.b }, p2/Z, [%x[B_ptr], #6, MUL VL]\n"
      "udot z27.s, z2.b, z0.b[1]\n"
      "ldnt1b { z6.b }, p2/Z, [%x[B_ptr], #7, MUL VL]\n"
      "udot z28.s, z3.b, z0.b[1]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z29.s, z4.b, z0.b[1]\n"
      "udot z30.s, z5.b, z0.b[1]\n"
      "udot z31.s, z6.b, z0.b[1]\n"
      "ble 62f\n"
      "ldnt1b { z7.b }, p2/Z, [%x[B_ptr]]\n"
      "subs x22, x22, #0x4\n"
      "ldnt1b { z8.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "ldnt1b { z9.b }, p2/Z, [%x[B_ptr], #2, MUL VL]\n"
      "ldnt1b { z10.b }, p2/Z, [%x[B_ptr], #3, MUL VL]\n"
      "udot z24.s, z7.b, z0.b[2]\n"
      "ldnt1b { z11.b }, p2/Z, [%x[B_ptr], #4, MUL VL]\n"
      "udot z25.s, z8.b, z0.b[2]\n"
      "ldnt1b { z12.b }, p2/Z, [%x[B_ptr], #5, MUL VL]\n"
      "udot z26.s, z9.b, z0.b[2]\n"
      "ldnt1b { z13.b }, p2/Z, [%x[B_ptr], #6, MUL VL]\n"
      "udot z27.s, z10.b, z0.b[2]\n"
      "ldnt1b { z14.b }, p2/Z, [%x[B_ptr], #7, MUL VL]\n"
      "udot z28.s, z11.b, z0.b[2]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z29.s, z12.b, z0.b[2]\n"
      "udot z30.s, z13.b, z0.b[2]\n"
      "udot z31.s, z14.b, z0.b[2]\n"
      "ble 62f\n"
      "ldnt1b { z15.b }, p2/Z, [%x[B_ptr]]\n"
      "ldnt1b { z16.b }, p2/Z, [%x[B_ptr], #1, MUL VL]\n"
      "ldnt1b { z17.b }, p2/Z, [%x[B_ptr], #2, MUL VL]\n"
      "ldnt1b { z18.b }, p2/Z, [%x[B_ptr], #3, MUL VL]\n"
      "udot z24.s, z15.b, z0.b[3]\n"
      "ldnt1b { z19.b }, p2/Z, [%x[B_ptr], #4, MUL VL]\n"
      "udot z25.s, z16.b, z0.b[3]\n"
      "ldnt1b { z20.b }, p2/Z, [%x[B_ptr], #5, MUL VL]\n"
      "udot z26.s, z17.b, z0.b[3]\n"
      "ldnt1b { z21.b }, p2/Z, [%x[B_ptr], #6, MUL VL]\n"
      "udot z27.s, z18.b, z0.b[3]\n"
      "ldnt1b { z1.b }, p2/Z, [%x[B_ptr], #7, MUL VL]\n"
      "udot z28.s, z19.b, z0.b[3]\n"
      "addvl %x[B_ptr], %x[B_ptr], #8\n"
      "udot z29.s, z20.b, z0.b[3]\n"
      "udot z30.s, z21.b, z0.b[3]\n"
      "udot z31.s, z1.b, z0.b[3]\n"
      "62:"  // Width 8: Multiply loop: multiply skip
      "tbnz %x[flags], #31, 63f\n"
      "udot z22.s, z0.b, z23.b\n"
      "63:"  // Width 8: Multiply loop: unique 16: skip row sum
      "tbnz %x[flags], #31, 64f\n"
      "add x21, %x[qp], %[b_offset]\n"
      "mov x20, #0x4\n"
      "ld1rw { z8.s }, p2/Z, [x21]\n"
      "whilelt p0.s, XZR, x20\n"
      "uaddv d22, p0, z22.s\n"
      "mov z22.s, z22.s[0]\n"
      "neg z8.s, p2/M, z8.s\n"
      "mul z22.s, p2/M, z22.s, z8.s\n"
      "64:"  // Width 8: skip row sum fixup
      "add z24.s, z24.s, z22.s\n"
      "add z25.s, z25.s, z22.s\n"
      "ld1w { z0.s }, p2/Z, [x27]\n"
      "add x24, %x[qp], %[per_layer_mul]\n"
      "add z26.s, z26.s, z22.s\n"
      "add z27.s, z27.s, z22.s\n"
      "ld1w { z1.s }, p2/Z, [x27, #1, MUL VL]\n"
      "add x23, %x[qp], %[per_layer_right_shift]\n"
      "add z28.s, z28.s, z22.s\n"
      "add z29.s, z29.s, z22.s\n"
      "ld1w { z2.s }, p2/Z, [x27, #2, MUL VL]\n"
      "add x22, %x[qp], %[c_offset]\n"
      "add z30.s, z30.s, z22.s\n"
      "add z31.s, z31.s, z22.s\n"
      "ld1w { z3.s }, p2/Z, [x27, #3, MUL VL]\n"
      "add x21, %x[qp], %[minval]\n"
      "ld1w { z4.s }, p2/Z, [x27, #4, MUL VL]\n"
      "add z24.s, z24.s, z0.s\n"
      "add z25.s, z25.s, z1.s\n"
      "add x20, %x[qp], %[maxval]\n"
      "ld1w { z5.s }, p2/Z, [x27, #5, MUL VL]\n"
      "add z26.s, z26.s, z2.s\n"
      "subs x25, x25, #0x8\n"
      "orr %x[flags], %x[flags], #0x80000000\n"
      "ld1w { z6.s }, p2/Z, [x27, #6, MUL VL]\n"
      "add z27.s, z27.s, z3.s\n"
      "sub %x[N], %x[N], x26, LSL #3\n"
      "ld1w { z7.s }, p2/Z, [x27, #7, MUL VL]\n"
      "add z28.s, z28.s, z4.s\n"
      "addvl x27, x27, #8\n"
      "add z29.s, z29.s, z5.s\n"
      "ld1rw { z8.s }, p2/Z, [x24]\n"
      "add z30.s, z30.s, z6.s\n"
      "ld1rw { z0.s }, p2/Z, [x23]\n"
      "add z31.s, z31.s, z7.s\n"
      "ld1rw { z9.s }, p2/Z, [x21]\n"
      ".inst 0x04a87318  // sqdmulh z24.s, z24.s, z8.s\n"
      ".inst 0x04a87339  // sqdmulh z25.s, z25.s, z8.s\n"
      "ld1rw { z10.s }, p2/Z, [x20]\n"
      ".inst 0x04a8735a  // sqdmulh z26.s, z26.s, z8.s\n"
      ".inst 0x04a8737b  // sqdmulh z27.s, z27.s, z8.s\n"
      ".inst 0x04a8739c  // sqdmulh z28.s, z28.s, z8.s\n"
      ".inst 0x04a873bd  // sqdmulh z29.s, z29.s, z8.s\n"
      ".inst 0x04a873de  // sqdmulh z30.s, z30.s, z8.s\n"
      ".inst 0x04a873ff  // sqdmulh z31.s, z31.s, z8.s\n"
      "ld1rw { z8.s }, p2/Z, [x22]\n"
      ".inst 0x44828818  // srshl z24.s, p2/M, z24.s, z0.s\n"
      ".inst 0x44828819  // srshl z25.s, p2/M, z25.s, z0.s\n"
      ".inst 0x4482881a  // srshl z26.s, p2/M, z26.s, z0.s\n"
      ".inst 0x4482881b  // srshl z27.s, p2/M, z27.s, z0.s\n"
      ".inst 0x4482881c  // srshl z28.s, p2/M, z28.s, z0.s\n"
      ".inst 0x4482881d  // srshl z29.s, p2/M, z29.s, z0.s\n"
      ".inst 0x4482881e  // srshl z30.s, p2/M, z30.s, z0.s\n"
      ".inst 0x4482881f  // srshl z31.s, p2/M, z31.s, z0.s\n"
      "add z24.s, z24.s, z8.s\n"
      "add z25.s, z25.s, z8.s\n"
      "add z26.s, z26.s, z8.s\n"
      "add z27.s, z27.s, z8.s\n"
      "add z28.s, z28.s, z8.s\n"
      "add z29.s, z29.s, z8.s\n"
      "add z30.s, z30.s, z8.s\n"
      "add z31.s, z31.s, z8.s\n"
      ".inst 0x448ac138  // sclamp z24.s, z9.s, z10.s\n"
      ".inst 0x448ac139  // sclamp z25.s, z9.s, z10.s\n"
      ".inst 0x448ac13a  // sclamp z26.s, z9.s, z10.s\n"
      ".inst 0x448ac13b  // sclamp z27.s, z9.s, z10.s\n"
      ".inst 0x448ac13c  // sclamp z28.s, z9.s, z10.s\n"
      ".inst 0x448ac13d  // sclamp z29.s, z9.s, z10.s\n"
      ".inst 0x448ac13e  // sclamp z30.s, z9.s, z10.s\n"
      ".inst 0x448ac13f  // sclamp z31.s, z9.s, z10.s\n"
      "uzp1 z24.h, z24.h, z25.h\n"
      "uzp1 z25.h, z26.h, z27.h\n"
      "uzp1 z26.h, z28.h, z29.h\n"
      "uzp1 z27.h, z30.h, z31.h\n"
      "uzp1 z24.b, z24.b, z25.b\n"
      "uzp1 z25.b, z26.b, z27.b\n"
      "st1b { z24.b }, p2, [%x[output_ptr]]\n"
      "st1b { z25.b }, p1, [%x[output_ptr], #1, MUL VL]\n"
      "addvl %x[output_ptr], %x[output_ptr], #2\n"
      "bgt 1b\n"
      "65:"  // Exit
      ".inst 0xd503467f  // SMSTOP\n"
      : [B_ptr] "+&r" (B_ptr), [N] "+&r" (N), [flags] "+&r" (flags), [output_ptr] "+&r" (output_ptr)
      : [A_ptr] "r" (A_ptr), [K] "r" (K), [b_offset] "I" (offsetof(Requantize32, b_offset)), [c_offset] "I" (offsetof(Requantize32, c_offset)), [col_bias] "r" (col_bias), [maxval] "I" (offsetof(Requantize32, maxval)), [minval] "I" (offsetof(Requantize32, minval)), [per_layer_mul] "I" (offsetof(Requantize32, per_layer_mul)), [per_layer_right_shift] "I" (offsetof(Requantize32, per_layer_right_shift)), [qp] "r" (qp)
      : "cc", "memory", "p0", "p1", "p2", "p3", "p4", "p5", "p6", "p7", "p8", "p9", "p10", "p11", "p12", "p13", "p14", "p15", "x20", "x21", "x22", "x23", "x24", "x25", "x26", "x27", "z0", "z1", "z2", "z3", "z4", "z5", "z6", "z7", "z8", "z9", "z10", "z11", "z12", "z13", "z14", "z15", "z16", "z17", "z18", "z19", "z20", "z21", "z22", "z23", "z24", "z25", "z26", "z27", "z28", "z29", "z30", "z31"
    );
}

} // namespace arm_gemm

#endif // defined(ARM_COMPUTE_ENABLE_SME) && defined(__aarch64__)

