/*
 * Copyright (c) 2019, 2020, 2025-2026 Arm Limited.
 *
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
#ifdef __aarch64__

#include <algorithm>

#include "arm_gemm/arm_gemm.hpp"

#include <cstdint>
#include "asmlib.hpp"
#include "arm_common/internal/utils.hpp"

namespace arm_gemm {

void a64_smallK_hybrid_u8u32_dot_6x4_a55(const uint8_t *A, int lda, const uint8_t *B, uint32_t *C, int ldc, int M, int N, int K, const uint32_t *, Activation, bool) {
    const long loops_count = iceildiv(N, (int)4) - 1;
    const long ldab = lda * sizeof(uint8_t);
    const long ldcb = ldc * sizeof(uint32_t);
    const long odds_count = K % 4;
    K = (K + 3) / 4;

    for (int y0=0; y0<M; y0+=6) {
        long loops = loops_count;
        long oob_rows = std::max(6 - (M-y0), 0);
        long odds = odds_count;
        const uint8_t *b_ptr0 = B;
        const uint8_t *a_ptr0 = A + (y0 * lda);

        uint32_t *c_ptr0 = C + (y0 * ldc);

        switch(K) {
            case 9:
                __asm __volatile (
                    "a_ptr1 .req X0\n"
                    "a_ptr2 .req X1\n"
                    "a_ptr3 .req X2\n"
                    "a_ptr4 .req X3\n"
                    "a_ptr5 .req X4\n"
                    "c_ptr1 .req X5\n"
                    "c_ptr2 .req X6\n"
                    "c_ptr3 .req X7\n"
                    "c_ptr4 .req X8\n"
                    "c_ptr5 .req X9\n"
                    "temploadreg0 .req X10\n"
                    "temploadreg1 .req X11\n"
                    "temploadreg2 .req X12\n"
                    "temploadreg3 .req X13\n"
                    "add a_ptr1, %[a_ptr0], %[lda]\n"
                    "add c_ptr1, %[c_ptr0], %[ldc]\n"
                    "add a_ptr2, a_ptr1, %[lda]\n"
                    "add c_ptr2, c_ptr1, %[ldc]\n"
                    "add a_ptr3, a_ptr2, %[lda]\n"
                    "add c_ptr3, c_ptr2, %[ldc]\n"
                    "add a_ptr4, a_ptr3, %[lda]\n"
                    "add c_ptr4, c_ptr3, %[ldc]\n"
                    "add a_ptr5, a_ptr4, %[lda]\n"
                    "add c_ptr5, c_ptr4, %[ldc]\n"
                    "cbz %[oob_rows], 1f\n"
                    "subs %[oob_rows], %[oob_rows], #0x1\n"
                    "add c_ptr5, %[c_ptr0], #0x0\n"
                    "add a_ptr5, %[a_ptr0], #0x0\n"
                    "b.eq 1f\n"
                    "subs %[oob_rows], %[oob_rows], #0x1\n"
                    "add c_ptr4, %[c_ptr0], #0x0\n"
                    "add a_ptr4, %[a_ptr0], #0x0\n"
                    "b.eq 1f\n"
                    "subs %[oob_rows], %[oob_rows], #0x1\n"
                    "add c_ptr3, %[c_ptr0], #0x0\n"
                    "add a_ptr3, %[a_ptr0], #0x0\n"
                    "b.eq 1f\n"
                    "subs %[oob_rows], %[oob_rows], #0x1\n"
                    "add c_ptr2, %[c_ptr0], #0x0\n"
                    "add a_ptr2, %[a_ptr0], #0x0\n"
                    "b.eq 1f\n"
                    "subs %[oob_rows], %[oob_rows], #0x1\n"
                    "add c_ptr1, %[c_ptr0], #0x0\n"
                    "add a_ptr1, %[a_ptr0], #0x0\n"
                    "1:\n"
                    "cbnz %[odds], 2f\n"
                    "ldr q0, [%[a_ptr0]], #0x10\n"
                    "ldr q3, [a_ptr1], #0x10\n"
                    "ldr q6, [a_ptr2], #0x10\n"
                    "ldr q9, [a_ptr3], #0x10\n"
                    "ldr q12, [a_ptr4], #0x10\n"
                    "ldr q15, [a_ptr5], #0x10\n"
                    "ldr q1, [%[a_ptr0]], #0x10\n"
                    "ldr q4, [a_ptr1], #0x10\n"
                    "ldr q7, [a_ptr2], #0x10\n"
                    "ldr q10, [a_ptr3], #0x10\n"
                    "ldr s2, [%[a_ptr0]]\n"
                    "ldr q13, [a_ptr4], #0x10\n"
                    "ldr s5, [a_ptr1]\n"
                    "ldr q16, [a_ptr5], #0x10\n"
                    "ldr s8, [a_ptr2]\n"
                    "ldr s11, [a_ptr3]\n"
                    "ldr s14, [a_ptr4]\n"
                    "ldr s17, [a_ptr5]\n"
                    "b 3f\n"
                    "2:\n"
                    "ldr q0, [%[a_ptr0]], #0x10\n"
                    "subs %[odds], %[odds], #0x1\n"
                    "ldr q3, [a_ptr1], #0x10\n"
                    "ldr q6, [a_ptr2], #0x10\n"
                    "ldr q9, [a_ptr3], #0x10\n"
                    "ldr q12, [a_ptr4], #0x10\n"
                    "ldr q15, [a_ptr5], #0x10\n"
                    "ldr q1, [%[a_ptr0]], #0x10\n"
                    "ldr q4, [a_ptr1], #0x10\n"
                    "ldr q7, [a_ptr2], #0x10\n"
                    "ldr q10, [a_ptr3], #0x10\n"
                    "ldr q13, [a_ptr4], #0x10\n"
                    "ldr q16, [a_ptr5], #0x10\n"
                    "b.ne 4f\n"
                    "ldr b2, [%[a_ptr0]]\n"
                    "ldr b5, [a_ptr1]\n"
                    "ldr b8, [a_ptr2]\n"
                    "ldr b11, [a_ptr3]\n"
                    "ldr b14, [a_ptr4]\n"
                    "ldr b17, [a_ptr5]\n"
                    "b 3f\n"
                    "4:\n"
                    "ldr h2, [%[a_ptr0]], #0x2\n"
                    "ldr h5, [a_ptr1], #0x2\n"
                    "ldr h8, [a_ptr2], #0x2\n"
                    "ldr h11, [a_ptr3], #0x2\n"
                    "ldr h14, [a_ptr4], #0x2\n"
                    "ldr h17, [a_ptr5], #0x2\n"
                    "subs %[odds], %[odds], #0x1\n"
                    "b.ne 5f\n"
                    "b 3f\n"
                    "5:\n"
                    "ld1 {v2.b}[2], [%[a_ptr0]]\n"
                    "ld1 {v5.b}[2], [a_ptr1]\n"
                    "ld1 {v8.b}[2], [a_ptr2]\n"
                    "ld1 {v11.b}[2], [a_ptr3]\n"
                    "ld1 {v14.b}[2], [a_ptr4]\n"
                    "ld1 {v17.b}[2], [a_ptr5]\n"
                    "3:\n"
                    "ldr q18, [%[b_ptr0]]\n"
                    "prfm PLDL1KEEP, [a_ptr5, #0x40]\n"
                    "ldr q19, [%[b_ptr0], #0x10]\n"
                    "prfm PLDL1KEEP, [a_ptr5, #0x80]\n"
                    "ldr q20, [%[b_ptr0], #0x20]\n"
                    "prfm PLDL1KEEP, [a_ptr5, #0xc0]\n"
                    "ldr q21, [%[b_ptr0], #0x30]\n"
                    "prfm PLDL1KEEP, [a_ptr5, #0x100]\n"
                    "ldr q22, [%[b_ptr0], #0x40]\n"
                    "prfm PLDL1KEEP, [a_ptr5, #0x140]\n"
                    "ldr q23, [%[b_ptr0], #0x50]\n"
                    "prfm PLDL1KEEP, [a_ptr5, #0x180]\n"
                    "ldr q24, [%[b_ptr0], #0x60]\n"
                    "ldr q25, [%[b_ptr0], #0x70]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x80\n"
                    "cbz %[loops], 6f\n"
                    "movi v26.4s, #0\n"
                    "subs %[loops], %[loops], #0x1\n"
                    "movi v27.4s, #0\n"
                    "movi v28.4s, #0\n"
                    "movi v29.4s, #0\n"
                    "movi v30.4s, #0\n"
                    "movi v31.4s, #0\n"
                    ".inst 0x6f80e25a // udot v26.4s, v18.16b, v0.4b[0]\n"
                    ".inst 0x6f83e25b // udot v27.4s, v18.16b, v3.4b[0]\n"
                    ".inst 0x6f86e25c // udot v28.4s, v18.16b, v6.4b[0]\n"
                    ".inst 0x6f89e25d // udot v29.4s, v18.16b, v9.4b[0]\n"
                    ".inst 0x6f8ce25e // udot v30.4s, v18.16b, v12.4b[0]\n"
                    ".inst 0x6f8fe25f // udot v31.4s, v18.16b, v15.4b[0]\n"
                    "ldr q18, [%[b_ptr0]]\n"
                    ".inst 0x6fa0e27a // udot v26.4s, v19.16b, v0.4b[1]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x10\n"
                    ".inst 0x6fa3e27b // udot v27.4s, v19.16b, v3.4b[1]\n"
                    ".inst 0x6fa6e27c // udot v28.4s, v19.16b, v6.4b[1]\n"
                    ".inst 0x6fa9e27d // udot v29.4s, v19.16b, v9.4b[1]\n"
                    ".inst 0x6face27e // udot v30.4s, v19.16b, v12.4b[1]\n"
                    ".inst 0x6fafe27f // udot v31.4s, v19.16b, v15.4b[1]\n"
                    ".inst 0x6f80ea9a // udot v26.4s, v20.16b, v0.4b[2]\n"
                    ".inst 0x6f83ea9b // udot v27.4s, v20.16b, v3.4b[2]\n"
                    ".inst 0x6f86ea9c // udot v28.4s, v20.16b, v6.4b[2]\n"
                    ".inst 0x6f89ea9d // udot v29.4s, v20.16b, v9.4b[2]\n"
                    ".inst 0x6f8cea9e // udot v30.4s, v20.16b, v12.4b[2]\n"
                    ".inst 0x6f8fea9f // udot v31.4s, v20.16b, v15.4b[2]\n"
                    ".inst 0x6fa0eaba // udot v26.4s, v21.16b, v0.4b[3]\n"
                    ".inst 0x6fa3eabb // udot v27.4s, v21.16b, v3.4b[3]\n"
                    ".inst 0x6fa6eabc // udot v28.4s, v21.16b, v6.4b[3]\n"
                    ".inst 0x6fa9eabd // udot v29.4s, v21.16b, v9.4b[3]\n"
                    ".inst 0x6faceabe // udot v30.4s, v21.16b, v12.4b[3]\n"
                    ".inst 0x6fafeabf // udot v31.4s, v21.16b, v15.4b[3]\n"
                    ".inst 0x6f81e2da // udot v26.4s, v22.16b, v1.4b[0]\n"
                    ".inst 0x6f84e2db // udot v27.4s, v22.16b, v4.4b[0]\n"
                    ".inst 0x6f87e2dc // udot v28.4s, v22.16b, v7.4b[0]\n"
                    ".inst 0x6f8ae2dd // udot v29.4s, v22.16b, v10.4b[0]\n"
                    ".inst 0x6f8de2de // udot v30.4s, v22.16b, v13.4b[0]\n"
                    ".inst 0x6f90e2df // udot v31.4s, v22.16b, v16.4b[0]\n"
                    ".inst 0x6fa1e2fa // udot v26.4s, v23.16b, v1.4b[1]\n"
                    ".inst 0x6fa4e2fb // udot v27.4s, v23.16b, v4.4b[1]\n"
                    ".inst 0x6fa7e2fc // udot v28.4s, v23.16b, v7.4b[1]\n"
                    ".inst 0x6faae2fd // udot v29.4s, v23.16b, v10.4b[1]\n"
                    ".inst 0x6fade2fe // udot v30.4s, v23.16b, v13.4b[1]\n"
                    ".inst 0x6fb0e2ff // udot v31.4s, v23.16b, v16.4b[1]\n"
                    ".inst 0x6f81eb1a // udot v26.4s, v24.16b, v1.4b[2]\n"
                    ".inst 0x6f84eb1b // udot v27.4s, v24.16b, v4.4b[2]\n"
                    ".inst 0x6f87eb1c // udot v28.4s, v24.16b, v7.4b[2]\n"
                    ".inst 0x6f8aeb1d // udot v29.4s, v24.16b, v10.4b[2]\n"
                    ".inst 0x6f8deb1e // udot v30.4s, v24.16b, v13.4b[2]\n"
                    ".inst 0x6f90eb1f // udot v31.4s, v24.16b, v16.4b[2]\n"
                    ".inst 0x6fa1eb3a // udot v26.4s, v25.16b, v1.4b[3]\n"
                    ".inst 0x6fa4eb3b // udot v27.4s, v25.16b, v4.4b[3]\n"
                    ".inst 0x6fa7eb3c // udot v28.4s, v25.16b, v7.4b[3]\n"
                    ".inst 0x6faaeb3d // udot v29.4s, v25.16b, v10.4b[3]\n"
                    ".inst 0x6fadeb3e // udot v30.4s, v25.16b, v13.4b[3]\n"
                    ".inst 0x6fb0eb3f // udot v31.4s, v25.16b, v16.4b[3]\n"
                    ".inst 0x6f82e25a // udot v26.4s, v18.16b, v2.4b[0]\n"
                    ".inst 0x6f85e25b // udot v27.4s, v18.16b, v5.4b[0]\n"
                    ".inst 0x6f88e25c // udot v28.4s, v18.16b, v8.4b[0]\n"
                    ".inst 0x6f8be25d // udot v29.4s, v18.16b, v11.4b[0]\n"
                    ".inst 0x6f8ee25e // udot v30.4s, v18.16b, v14.4b[0]\n"
                    ".inst 0x6f91e25f // udot v31.4s, v18.16b, v17.4b[0]\n"
                    "b.eq 7f\n"
                    "8:\n"
                    "str q26, [%[c_ptr0]]\n"
                    "subs %[loops], %[loops], #0x1\n"
                    "movi v26.4s, #0\n"
                    "ldr d18, [%[b_ptr0]]\n"
                    "ldr temploadreg2, [%[b_ptr0], #0x8]\n"
                    "add %[c_ptr0], %[c_ptr0], #0x10\n"
                    "str q27, [c_ptr1]\n"
                    "add c_ptr1, c_ptr1, #0x10\n"
                    "movi v27.4s, #0\n"
                    "ldr d19, [%[b_ptr0], #0x10]\n"
                    "ldr temploadreg3, [%[b_ptr0], #0x18]\n"
                    "prfm PSTL1KEEP, [%[c_ptr0], #0x40]\n"
                    "str q28, [c_ptr2]\n"
                    "add c_ptr2, c_ptr2, #0x10\n"
                    "movi v28.4s, #0\n"
                    "ldr d20, [%[b_ptr0], #0x20]\n"
                    "ldr temploadreg0, [%[b_ptr0], #0x28]\n"
                    "prfm PSTL1KEEP, [c_ptr1, #0x40]\n"
                    "str q29, [c_ptr3]\n"
                    "add c_ptr3, c_ptr3, #0x10\n"
                    "movi v29.4s, #0\n"
                    "ldr d21, [%[b_ptr0], #0x30]\n"
                    "ldr temploadreg1, [%[b_ptr0], #0x38]\n"
                    "prfm PSTL1KEEP, [c_ptr2, #0x40]\n"
                    "str q30, [c_ptr4]\n"
                    "add c_ptr4, c_ptr4, #0x10\n"
                    "movi v30.4s, #0\n"
                    "ldr d22, [%[b_ptr0], #0x40]\n"
                    "ins v18.d[1], temploadreg2\n"
                    "prfm PSTL1KEEP, [c_ptr3, #0x40]\n"
                    "str q31, [c_ptr5]\n"
                    "add c_ptr5, c_ptr5, #0x10\n"
                    "movi v31.4s, #0\n"
                    "ldr temploadreg2, [%[b_ptr0], #0x48]\n"
                    ".inst 0x6f80e25a // udot v26.4s, v18.16b, v0.4b[0]\n"
                    "ldr d23, [%[b_ptr0], #0x50]\n"
                    ".inst 0x6f83e25b // udot v27.4s, v18.16b, v3.4b[0]\n"
                    "ins v19.d[1], temploadreg3\n"
                    ".inst 0x6f86e25c // udot v28.4s, v18.16b, v6.4b[0]\n"
                    "ldr temploadreg3, [%[b_ptr0], #0x58]\n"
                    ".inst 0x6f89e25d // udot v29.4s, v18.16b, v9.4b[0]\n"
                    "ldr d24, [%[b_ptr0], #0x60]\n"
                    ".inst 0x6f8ce25e // udot v30.4s, v18.16b, v12.4b[0]\n"
                    "ins v20.d[1], temploadreg0\n"
                    ".inst 0x6f8fe25f // udot v31.4s, v18.16b, v15.4b[0]\n"
                    "ldr temploadreg0, [%[b_ptr0], #0x68]\n"
                    ".inst 0x6fa0e27a // udot v26.4s, v19.16b, v0.4b[1]\n"
                    "ldr d25, [%[b_ptr0], #0x70]\n"
                    ".inst 0x6fa3e27b // udot v27.4s, v19.16b, v3.4b[1]\n"
                    "ins v21.d[1], temploadreg1\n"
                    ".inst 0x6fa6e27c // udot v28.4s, v19.16b, v6.4b[1]\n"
                    "ldr temploadreg1, [%[b_ptr0], #0x78]\n"
                    ".inst 0x6fa9e27d // udot v29.4s, v19.16b, v9.4b[1]\n"
                    "ins v22.d[1], temploadreg2\n"
                    ".inst 0x6face27e // udot v30.4s, v19.16b, v12.4b[1]\n"
                    "ins v23.d[1], temploadreg3\n"
                    ".inst 0x6fafe27f // udot v31.4s, v19.16b, v15.4b[1]\n"
                    "ins v24.d[1], temploadreg0\n"
                    ".inst 0x6f80ea9a // udot v26.4s, v20.16b, v0.4b[2]\n"
                    "ins v25.d[1], temploadreg1\n"
                    ".inst 0x6f83ea9b // udot v27.4s, v20.16b, v3.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x80\n"
                    ".inst 0x6f86ea9c // udot v28.4s, v20.16b, v6.4b[2]\n"
                    "ldr d18, [%[b_ptr0]]\n"
                    ".inst 0x6f89ea9d // udot v29.4s, v20.16b, v9.4b[2]\n"
                    "ldr temploadreg2, [%[b_ptr0], #0x8]\n"
                    ".inst 0x6f8cea9e // udot v30.4s, v20.16b, v12.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x10\n"
                    ".inst 0x6f8fea9f // udot v31.4s, v20.16b, v15.4b[2]\n"
                    "ins v18.d[1], temploadreg2\n"
                    ".inst 0x6fa0eaba // udot v26.4s, v21.16b, v0.4b[3]\n"
                    "prfm PSTL1KEEP, [c_ptr4, #0x40]\n"
                    ".inst 0x6fa3eabb // udot v27.4s, v21.16b, v3.4b[3]\n"
                    "prfm PSTL1KEEP, [c_ptr5, #0x40]\n"
                    ".inst 0x6fa6eabc // udot v28.4s, v21.16b, v6.4b[3]\n"
                    ".inst 0x6fa9eabd // udot v29.4s, v21.16b, v9.4b[3]\n"
                    ".inst 0x6faceabe // udot v30.4s, v21.16b, v12.4b[3]\n"
                    ".inst 0x6fafeabf // udot v31.4s, v21.16b, v15.4b[3]\n"
                    ".inst 0x6f81e2da // udot v26.4s, v22.16b, v1.4b[0]\n"
                    ".inst 0x6f84e2db // udot v27.4s, v22.16b, v4.4b[0]\n"
                    ".inst 0x6f87e2dc // udot v28.4s, v22.16b, v7.4b[0]\n"
                    ".inst 0x6f8ae2dd // udot v29.4s, v22.16b, v10.4b[0]\n"
                    ".inst 0x6f8de2de // udot v30.4s, v22.16b, v13.4b[0]\n"
                    ".inst 0x6f90e2df // udot v31.4s, v22.16b, v16.4b[0]\n"
                    ".inst 0x6fa1e2fa // udot v26.4s, v23.16b, v1.4b[1]\n"
                    ".inst 0x6fa4e2fb // udot v27.4s, v23.16b, v4.4b[1]\n"
                    ".inst 0x6fa7e2fc // udot v28.4s, v23.16b, v7.4b[1]\n"
                    ".inst 0x6faae2fd // udot v29.4s, v23.16b, v10.4b[1]\n"
                    ".inst 0x6fade2fe // udot v30.4s, v23.16b, v13.4b[1]\n"
                    ".inst 0x6fb0e2ff // udot v31.4s, v23.16b, v16.4b[1]\n"
                    ".inst 0x6f81eb1a // udot v26.4s, v24.16b, v1.4b[2]\n"
                    ".inst 0x6f84eb1b // udot v27.4s, v24.16b, v4.4b[2]\n"
                    ".inst 0x6f87eb1c // udot v28.4s, v24.16b, v7.4b[2]\n"
                    ".inst 0x6f8aeb1d // udot v29.4s, v24.16b, v10.4b[2]\n"
                    ".inst 0x6f8deb1e // udot v30.4s, v24.16b, v13.4b[2]\n"
                    ".inst 0x6f90eb1f // udot v31.4s, v24.16b, v16.4b[2]\n"
                    ".inst 0x6fa1eb3a // udot v26.4s, v25.16b, v1.4b[3]\n"
                    ".inst 0x6fa4eb3b // udot v27.4s, v25.16b, v4.4b[3]\n"
                    ".inst 0x6fa7eb3c // udot v28.4s, v25.16b, v7.4b[3]\n"
                    ".inst 0x6faaeb3d // udot v29.4s, v25.16b, v10.4b[3]\n"
                    ".inst 0x6fadeb3e // udot v30.4s, v25.16b, v13.4b[3]\n"
                    ".inst 0x6fb0eb3f // udot v31.4s, v25.16b, v16.4b[3]\n"
                    ".inst 0x6f82e25a // udot v26.4s, v18.16b, v2.4b[0]\n"
                    ".inst 0x6f85e25b // udot v27.4s, v18.16b, v5.4b[0]\n"
                    ".inst 0x6f88e25c // udot v28.4s, v18.16b, v8.4b[0]\n"
                    ".inst 0x6f8be25d // udot v29.4s, v18.16b, v11.4b[0]\n"
                    ".inst 0x6f8ee25e // udot v30.4s, v18.16b, v14.4b[0]\n"
                    ".inst 0x6f91e25f // udot v31.4s, v18.16b, v17.4b[0]\n"
                    "b.ne 8b\n"
                    "7:\n"
                    "str q26, [%[c_ptr0]]\n"
                    "add %[c_ptr0], %[c_ptr0], #0x10\n"
                    "movi v26.4s, #0\n"
                    "ldr q18, [%[b_ptr0]]\n"
                    "ldr q19, [%[b_ptr0], #0x10]\n"
                    "str q27, [c_ptr1]\n"
                    "add c_ptr1, c_ptr1, #0x10\n"
                    "movi v27.4s, #0\n"
                    "ldr q20, [%[b_ptr0], #0x20]\n"
                    ".inst 0x6f80e25a // udot v26.4s, v18.16b, v0.4b[0]\n"
                    "str q28, [c_ptr2]\n"
                    "movi v28.4s, #0\n"
                    "ldr q21, [%[b_ptr0], #0x30]\n"
                    "ldr q22, [%[b_ptr0], #0x40]\n"
                    "add c_ptr2, c_ptr2, #0x10\n"
                    ".inst 0x6f83e25b // udot v27.4s, v18.16b, v3.4b[0]\n"
                    "str q29, [c_ptr3]\n"
                    "movi v29.4s, #0\n"
                    "ldr q23, [%[b_ptr0], #0x50]\n"
                    ".inst 0x6f86e25c // udot v28.4s, v18.16b, v6.4b[0]\n"
                    "ldr q24, [%[b_ptr0], #0x60]\n"
                    ".inst 0x6fa0e27a // udot v26.4s, v19.16b, v0.4b[1]\n"
                    "str q30, [c_ptr4]\n"
                    "movi v30.4s, #0\n"
                    "ldr q25, [%[b_ptr0], #0x70]\n"
                    ".inst 0x6f89e25d // udot v29.4s, v18.16b, v9.4b[0]\n"
                    "add c_ptr3, c_ptr3, #0x10\n"
                    ".inst 0x6fa3e27b // udot v27.4s, v19.16b, v3.4b[1]\n"
                    "str q31, [c_ptr5]\n"
                    "movi v31.4s, #0\n"
                    "add c_ptr4, c_ptr4, #0x10\n"
                    ".inst 0x6f8ce25e // udot v30.4s, v18.16b, v12.4b[0]\n"
                    "add c_ptr5, c_ptr5, #0x10\n"
                    ".inst 0x6f8fe25f // udot v31.4s, v18.16b, v15.4b[0]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x80\n"
                    ".inst 0x6fa6e27c // udot v28.4s, v19.16b, v6.4b[1]\n"
                    "ldr q18, [%[b_ptr0]]\n"
                    ".inst 0x6fa9e27d // udot v29.4s, v19.16b, v9.4b[1]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x10\n"
                    ".inst 0x6face27e // udot v30.4s, v19.16b, v12.4b[1]\n"
                    ".inst 0x6fafe27f // udot v31.4s, v19.16b, v15.4b[1]\n"
                    ".inst 0x6f80ea9a // udot v26.4s, v20.16b, v0.4b[2]\n"
                    ".inst 0x6f83ea9b // udot v27.4s, v20.16b, v3.4b[2]\n"
                    ".inst 0x6f86ea9c // udot v28.4s, v20.16b, v6.4b[2]\n"
                    ".inst 0x6f89ea9d // udot v29.4s, v20.16b, v9.4b[2]\n"
                    ".inst 0x6f8cea9e // udot v30.4s, v20.16b, v12.4b[2]\n"
                    ".inst 0x6f8fea9f // udot v31.4s, v20.16b, v15.4b[2]\n"
                    ".inst 0x6fa0eaba // udot v26.4s, v21.16b, v0.4b[3]\n"
                    ".inst 0x6fa3eabb // udot v27.4s, v21.16b, v3.4b[3]\n"
                    ".inst 0x6fa6eabc // udot v28.4s, v21.16b, v6.4b[3]\n"
                    ".inst 0x6fa9eabd // udot v29.4s, v21.16b, v9.4b[3]\n"
                    ".inst 0x6faceabe // udot v30.4s, v21.16b, v12.4b[3]\n"
                    ".inst 0x6fafeabf // udot v31.4s, v21.16b, v15.4b[3]\n"
                    ".inst 0x6f81e2da // udot v26.4s, v22.16b, v1.4b[0]\n"
                    ".inst 0x6f84e2db // udot v27.4s, v22.16b, v4.4b[0]\n"
                    ".inst 0x6f87e2dc // udot v28.4s, v22.16b, v7.4b[0]\n"
                    ".inst 0x6f8ae2dd // udot v29.4s, v22.16b, v10.4b[0]\n"
                    ".inst 0x6f8de2de // udot v30.4s, v22.16b, v13.4b[0]\n"
                    ".inst 0x6f90e2df // udot v31.4s, v22.16b, v16.4b[0]\n"
                    ".inst 0x6fa1e2fa // udot v26.4s, v23.16b, v1.4b[1]\n"
                    ".inst 0x6fa4e2fb // udot v27.4s, v23.16b, v4.4b[1]\n"
                    ".inst 0x6fa7e2fc // udot v28.4s, v23.16b, v7.4b[1]\n"
                    ".inst 0x6faae2fd // udot v29.4s, v23.16b, v10.4b[1]\n"
                    ".inst 0x6fade2fe // udot v30.4s, v23.16b, v13.4b[1]\n"
                    ".inst 0x6fb0e2ff // udot v31.4s, v23.16b, v16.4b[1]\n"
                    ".inst 0x6f81eb1a // udot v26.4s, v24.16b, v1.4b[2]\n"
                    ".inst 0x6f84eb1b // udot v27.4s, v24.16b, v4.4b[2]\n"
                    ".inst 0x6f87eb1c // udot v28.4s, v24.16b, v7.4b[2]\n"
                    ".inst 0x6f8aeb1d // udot v29.4s, v24.16b, v10.4b[2]\n"
                    ".inst 0x6f8deb1e // udot v30.4s, v24.16b, v13.4b[2]\n"
                    ".inst 0x6f90eb1f // udot v31.4s, v24.16b, v16.4b[2]\n"
                    ".inst 0x6fa1eb3a // udot v26.4s, v25.16b, v1.4b[3]\n"
                    ".inst 0x6fa4eb3b // udot v27.4s, v25.16b, v4.4b[3]\n"
                    ".inst 0x6fa7eb3c // udot v28.4s, v25.16b, v7.4b[3]\n"
                    ".inst 0x6faaeb3d // udot v29.4s, v25.16b, v10.4b[3]\n"
                    ".inst 0x6fadeb3e // udot v30.4s, v25.16b, v13.4b[3]\n"
                    ".inst 0x6fb0eb3f // udot v31.4s, v25.16b, v16.4b[3]\n"
                    ".inst 0x6f82e25a // udot v26.4s, v18.16b, v2.4b[0]\n"
                    ".inst 0x6f85e25b // udot v27.4s, v18.16b, v5.4b[0]\n"
                    ".inst 0x6f88e25c // udot v28.4s, v18.16b, v8.4b[0]\n"
                    ".inst 0x6f8be25d // udot v29.4s, v18.16b, v11.4b[0]\n"
                    ".inst 0x6f8ee25e // udot v30.4s, v18.16b, v14.4b[0]\n"
                    ".inst 0x6f91e25f // udot v31.4s, v18.16b, v17.4b[0]\n"
                    "b 9f\n"
                    "6:\n"
                    "movi v26.4s, #0\n"
                    "movi v27.4s, #0\n"
                    "movi v28.4s, #0\n"
                    "movi v29.4s, #0\n"
                    "movi v30.4s, #0\n"
                    "movi v31.4s, #0\n"
                    ".inst 0x6f80e25a // udot v26.4s, v18.16b, v0.4b[0]\n"
                    ".inst 0x6f83e25b // udot v27.4s, v18.16b, v3.4b[0]\n"
                    ".inst 0x6f86e25c // udot v28.4s, v18.16b, v6.4b[0]\n"
                    ".inst 0x6f89e25d // udot v29.4s, v18.16b, v9.4b[0]\n"
                    ".inst 0x6f8ce25e // udot v30.4s, v18.16b, v12.4b[0]\n"
                    ".inst 0x6f8fe25f // udot v31.4s, v18.16b, v15.4b[0]\n"
                    "ldr q18, [%[b_ptr0]]\n"
                    ".inst 0x6fa0e27a // udot v26.4s, v19.16b, v0.4b[1]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x10\n"
                    ".inst 0x6fa3e27b // udot v27.4s, v19.16b, v3.4b[1]\n"
                    ".inst 0x6fa6e27c // udot v28.4s, v19.16b, v6.4b[1]\n"
                    ".inst 0x6fa9e27d // udot v29.4s, v19.16b, v9.4b[1]\n"
                    ".inst 0x6face27e // udot v30.4s, v19.16b, v12.4b[1]\n"
                    ".inst 0x6fafe27f // udot v31.4s, v19.16b, v15.4b[1]\n"
                    ".inst 0x6f80ea9a // udot v26.4s, v20.16b, v0.4b[2]\n"
                    ".inst 0x6f83ea9b // udot v27.4s, v20.16b, v3.4b[2]\n"
                    ".inst 0x6f86ea9c // udot v28.4s, v20.16b, v6.4b[2]\n"
                    ".inst 0x6f89ea9d // udot v29.4s, v20.16b, v9.4b[2]\n"
                    ".inst 0x6f8cea9e // udot v30.4s, v20.16b, v12.4b[2]\n"
                    ".inst 0x6f8fea9f // udot v31.4s, v20.16b, v15.4b[2]\n"
                    ".inst 0x6fa0eaba // udot v26.4s, v21.16b, v0.4b[3]\n"
                    ".inst 0x6fa3eabb // udot v27.4s, v21.16b, v3.4b[3]\n"
                    ".inst 0x6fa6eabc // udot v28.4s, v21.16b, v6.4b[3]\n"
                    ".inst 0x6fa9eabd // udot v29.4s, v21.16b, v9.4b[3]\n"
                    ".inst 0x6faceabe // udot v30.4s, v21.16b, v12.4b[3]\n"
                    ".inst 0x6fafeabf // udot v31.4s, v21.16b, v15.4b[3]\n"
                    ".inst 0x6f81e2da // udot v26.4s, v22.16b, v1.4b[0]\n"
                    ".inst 0x6f84e2db // udot v27.4s, v22.16b, v4.4b[0]\n"
                    ".inst 0x6f87e2dc // udot v28.4s, v22.16b, v7.4b[0]\n"
                    ".inst 0x6f8ae2dd // udot v29.4s, v22.16b, v10.4b[0]\n"
                    ".inst 0x6f8de2de // udot v30.4s, v22.16b, v13.4b[0]\n"
                    ".inst 0x6f90e2df // udot v31.4s, v22.16b, v16.4b[0]\n"
                    ".inst 0x6fa1e2fa // udot v26.4s, v23.16b, v1.4b[1]\n"
                    ".inst 0x6fa4e2fb // udot v27.4s, v23.16b, v4.4b[1]\n"
                    ".inst 0x6fa7e2fc // udot v28.4s, v23.16b, v7.4b[1]\n"
                    ".inst 0x6faae2fd // udot v29.4s, v23.16b, v10.4b[1]\n"
                    ".inst 0x6fade2fe // udot v30.4s, v23.16b, v13.4b[1]\n"
                    ".inst 0x6fb0e2ff // udot v31.4s, v23.16b, v16.4b[1]\n"
                    ".inst 0x6f81eb1a // udot v26.4s, v24.16b, v1.4b[2]\n"
                    ".inst 0x6f84eb1b // udot v27.4s, v24.16b, v4.4b[2]\n"
                    ".inst 0x6f87eb1c // udot v28.4s, v24.16b, v7.4b[2]\n"
                    ".inst 0x6f8aeb1d // udot v29.4s, v24.16b, v10.4b[2]\n"
                    ".inst 0x6f8deb1e // udot v30.4s, v24.16b, v13.4b[2]\n"
                    ".inst 0x6f90eb1f // udot v31.4s, v24.16b, v16.4b[2]\n"
                    ".inst 0x6fa1eb3a // udot v26.4s, v25.16b, v1.4b[3]\n"
                    ".inst 0x6fa4eb3b // udot v27.4s, v25.16b, v4.4b[3]\n"
                    ".inst 0x6fa7eb3c // udot v28.4s, v25.16b, v7.4b[3]\n"
                    ".inst 0x6faaeb3d // udot v29.4s, v25.16b, v10.4b[3]\n"
                    ".inst 0x6fadeb3e // udot v30.4s, v25.16b, v13.4b[3]\n"
                    ".inst 0x6fb0eb3f // udot v31.4s, v25.16b, v16.4b[3]\n"
                    ".inst 0x6f82e25a // udot v26.4s, v18.16b, v2.4b[0]\n"
                    ".inst 0x6f85e25b // udot v27.4s, v18.16b, v5.4b[0]\n"
                    ".inst 0x6f88e25c // udot v28.4s, v18.16b, v8.4b[0]\n"
                    ".inst 0x6f8be25d // udot v29.4s, v18.16b, v11.4b[0]\n"
                    ".inst 0x6f8ee25e // udot v30.4s, v18.16b, v14.4b[0]\n"
                    ".inst 0x6f91e25f // udot v31.4s, v18.16b, v17.4b[0]\n"
                    "9:\n"
                    "str q26, [%[c_ptr0]]\n"
                    "add %[c_ptr0], %[c_ptr0], #0x10\n"
                    "str q27, [c_ptr1]\n"
                    "str q28, [c_ptr2]\n"
                    "str q29, [c_ptr3]\n"
                    "str q30, [c_ptr4]\n"
                    "str q31, [c_ptr5]\n"
                    ".unreq a_ptr1\n"
                    ".unreq a_ptr2\n"
                    ".unreq a_ptr3\n"
                    ".unreq a_ptr4\n"
                    ".unreq a_ptr5\n"
                    ".unreq c_ptr1\n"
                    ".unreq c_ptr2\n"
                    ".unreq c_ptr3\n"
                    ".unreq c_ptr4\n"
                    ".unreq c_ptr5\n"
                    ".unreq temploadreg0\n"
                    ".unreq temploadreg1\n"
                    ".unreq temploadreg2\n"
                    ".unreq temploadreg3\n"
                    : [a_ptr0] "+r" (a_ptr0), [b_ptr0] "+r" (b_ptr0), [c_ptr0] "+r" (c_ptr0), [loops] "+r" (loops), [oob_rows] "+r" (oob_rows), [odds] "+r" (odds)
                    : [lda] "r" (ldab), [ldc] "r" (ldcb)
                    : "x0", "x1", "x2", "x3", "x4", "x5", "x6", "x7", "x8", "x9", "x10", "x11", "x12", "x13", "v0", "v1", "v2", "v3", "v4", "v5", "v6", "v7", "v8", "v9", "v10", "v11", "v12", "v13", "v14", "v15", "v16", "v17", "v18", "v19", "v20", "v21", "v22", "v23", "v24", "v25", "v26", "v27", "v28", "v29", "v30", "v31", "cc", "memory"
                );
                break;
            case 10:
                __asm __volatile (
                    "a_ptr1 .req X0\n"
                    "a_ptr2 .req X1\n"
                    "a_ptr3 .req X2\n"
                    "a_ptr4 .req X3\n"
                    "a_ptr5 .req X4\n"
                    "c_ptr1 .req X5\n"
                    "c_ptr2 .req X6\n"
                    "c_ptr3 .req X7\n"
                    "c_ptr4 .req X8\n"
                    "c_ptr5 .req X9\n"
                    "temploadreg0 .req X10\n"
                    "temploadreg1 .req X11\n"
                    "temploadreg2 .req X12\n"
                    "temploadreg3 .req X13\n"
                    "add a_ptr1, %[a_ptr0], %[lda]\n"
                    "add c_ptr1, %[c_ptr0], %[ldc]\n"
                    "add a_ptr2, a_ptr1, %[lda]\n"
                    "add c_ptr2, c_ptr1, %[ldc]\n"
                    "add a_ptr3, a_ptr2, %[lda]\n"
                    "add c_ptr3, c_ptr2, %[ldc]\n"
                    "add a_ptr4, a_ptr3, %[lda]\n"
                    "add c_ptr4, c_ptr3, %[ldc]\n"
                    "add a_ptr5, a_ptr4, %[lda]\n"
                    "add c_ptr5, c_ptr4, %[ldc]\n"
                    "cbz %[oob_rows], 1f\n"
                    "subs %[oob_rows], %[oob_rows], #0x1\n"
                    "add c_ptr5, %[c_ptr0], #0x0\n"
                    "add a_ptr5, %[a_ptr0], #0x0\n"
                    "b.eq 1f\n"
                    "subs %[oob_rows], %[oob_rows], #0x1\n"
                    "add c_ptr4, %[c_ptr0], #0x0\n"
                    "add a_ptr4, %[a_ptr0], #0x0\n"
                    "b.eq 1f\n"
                    "subs %[oob_rows], %[oob_rows], #0x1\n"
                    "add c_ptr3, %[c_ptr0], #0x0\n"
                    "add a_ptr3, %[a_ptr0], #0x0\n"
                    "b.eq 1f\n"
                    "subs %[oob_rows], %[oob_rows], #0x1\n"
                    "add c_ptr2, %[c_ptr0], #0x0\n"
                    "add a_ptr2, %[a_ptr0], #0x0\n"
                    "b.eq 1f\n"
                    "subs %[oob_rows], %[oob_rows], #0x1\n"
                    "add c_ptr1, %[c_ptr0], #0x0\n"
                    "add a_ptr1, %[a_ptr0], #0x0\n"
                    "1:\n"
                    "cbnz %[odds], 2f\n"
                    "ldr q0, [%[a_ptr0]], #0x10\n"
                    "ldr q3, [a_ptr1], #0x10\n"
                    "ldr q6, [a_ptr2], #0x10\n"
                    "ldr q9, [a_ptr3], #0x10\n"
                    "ldr q12, [a_ptr4], #0x10\n"
                    "ldr q15, [a_ptr5], #0x10\n"
                    "ldr q1, [%[a_ptr0]], #0x10\n"
                    "ldr q4, [a_ptr1], #0x10\n"
                    "ldr q7, [a_ptr2], #0x10\n"
                    "ldr q10, [a_ptr3], #0x10\n"
                    "ldr d2, [%[a_ptr0]]\n"
                    "ldr q13, [a_ptr4], #0x10\n"
                    "ldr d5, [a_ptr1]\n"
                    "ldr q16, [a_ptr5], #0x10\n"
                    "ldr d8, [a_ptr2]\n"
                    "ldr d11, [a_ptr3]\n"
                    "ldr d14, [a_ptr4]\n"
                    "ldr d17, [a_ptr5]\n"
                    "b 3f\n"
                    "2:\n"
                    "ldr q0, [%[a_ptr0]], #0x10\n"
                    "subs %[odds], %[odds], #0x1\n"
                    "ldr q3, [a_ptr1], #0x10\n"
                    "ldr q6, [a_ptr2], #0x10\n"
                    "ldr q9, [a_ptr3], #0x10\n"
                    "ldr q12, [a_ptr4], #0x10\n"
                    "ldr q15, [a_ptr5], #0x10\n"
                    "ldr q1, [%[a_ptr0]], #0x10\n"
                    "ldr q4, [a_ptr1], #0x10\n"
                    "ldr q7, [a_ptr2], #0x10\n"
                    "ldr q10, [a_ptr3], #0x10\n"
                    "ldr s2, [%[a_ptr0]], #0x4\n"
                    "ldr q13, [a_ptr4], #0x10\n"
                    "ldr s5, [a_ptr1], #0x4\n"
                    "ldr q16, [a_ptr5], #0x10\n"
                    "ldr s8, [a_ptr2], #0x4\n"
                    "ldr s11, [a_ptr3], #0x4\n"
                    "ldr s14, [a_ptr4], #0x4\n"
                    "ldr s17, [a_ptr5], #0x4\n"
                    "b.ne 4f\n"
                    "ld1 {v2.b}[4], [%[a_ptr0]]\n"
                    "ld1 {v5.b}[4], [a_ptr1]\n"
                    "ld1 {v8.b}[4], [a_ptr2]\n"
                    "ld1 {v11.b}[4], [a_ptr3]\n"
                    "ld1 {v14.b}[4], [a_ptr4]\n"
                    "ld1 {v17.b}[4], [a_ptr5]\n"
                    "b 3f\n"
                    "4:\n"
                    "ld1 {v2.h}[2], [%[a_ptr0]], #2\n"
                    "ld1 {v5.h}[2], [a_ptr1], #2\n"
                    "ld1 {v8.h}[2], [a_ptr2], #2\n"
                    "ld1 {v11.h}[2], [a_ptr3], #2\n"
                    "ld1 {v14.h}[2], [a_ptr4], #2\n"
                    "ld1 {v17.h}[2], [a_ptr5], #2\n"
                    "subs %[odds], %[odds], #0x1\n"
                    "b.ne 5f\n"
                    "b 3f\n"
                    "5:\n"
                    "ld1 {v2.b}[6], [%[a_ptr0]]\n"
                    "ld1 {v5.b}[6], [a_ptr1]\n"
                    "ld1 {v8.b}[6], [a_ptr2]\n"
                    "ld1 {v11.b}[6], [a_ptr3]\n"
                    "ld1 {v14.b}[6], [a_ptr4]\n"
                    "ld1 {v17.b}[6], [a_ptr5]\n"
                    "3:\n"
                    "ldr q18, [%[b_ptr0]]\n"
                    "prfm PLDL1KEEP, [a_ptr5, #0x40]\n"
                    "ldr q19, [%[b_ptr0], #0x10]\n"
                    "prfm PLDL1KEEP, [a_ptr5, #0x80]\n"
                    "ldr q20, [%[b_ptr0], #0x20]\n"
                    "prfm PLDL1KEEP, [a_ptr5, #0xc0]\n"
                    "ldr q21, [%[b_ptr0], #0x30]\n"
                    "prfm PLDL1KEEP, [a_ptr5, #0x100]\n"
                    "ldr q22, [%[b_ptr0], #0x40]\n"
                    "prfm PLDL1KEEP, [a_ptr5, #0x140]\n"
                    "ldr q23, [%[b_ptr0], #0x50]\n"
                    "prfm PLDL1KEEP, [a_ptr5, #0x180]\n"
                    "ldr q24, [%[b_ptr0], #0x60]\n"
                    "ldr q25, [%[b_ptr0], #0x70]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x80\n"
                    "cbz %[loops], 6f\n"
                    "movi v26.4s, #0\n"
                    "subs %[loops], %[loops], #0x1\n"
                    "movi v27.4s, #0\n"
                    "movi v28.4s, #0\n"
                    "movi v29.4s, #0\n"
                    "movi v30.4s, #0\n"
                    "movi v31.4s, #0\n"
                    ".inst 0x6f80e25a // udot v26.4s, v18.16b, v0.4b[0]\n"
                    ".inst 0x6f83e25b // udot v27.4s, v18.16b, v3.4b[0]\n"
                    ".inst 0x6f86e25c // udot v28.4s, v18.16b, v6.4b[0]\n"
                    ".inst 0x6f89e25d // udot v29.4s, v18.16b, v9.4b[0]\n"
                    ".inst 0x6f8ce25e // udot v30.4s, v18.16b, v12.4b[0]\n"
                    ".inst 0x6f8fe25f // udot v31.4s, v18.16b, v15.4b[0]\n"
                    "ldr q18, [%[b_ptr0]]\n"
                    ".inst 0x6fa0e27a // udot v26.4s, v19.16b, v0.4b[1]\n"
                    ".inst 0x6fa3e27b // udot v27.4s, v19.16b, v3.4b[1]\n"
                    ".inst 0x6fa6e27c // udot v28.4s, v19.16b, v6.4b[1]\n"
                    ".inst 0x6fa9e27d // udot v29.4s, v19.16b, v9.4b[1]\n"
                    ".inst 0x6face27e // udot v30.4s, v19.16b, v12.4b[1]\n"
                    ".inst 0x6fafe27f // udot v31.4s, v19.16b, v15.4b[1]\n"
                    "ldr q19, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f80ea9a // udot v26.4s, v20.16b, v0.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f83ea9b // udot v27.4s, v20.16b, v3.4b[2]\n"
                    ".inst 0x6f86ea9c // udot v28.4s, v20.16b, v6.4b[2]\n"
                    ".inst 0x6f89ea9d // udot v29.4s, v20.16b, v9.4b[2]\n"
                    ".inst 0x6f8cea9e // udot v30.4s, v20.16b, v12.4b[2]\n"
                    ".inst 0x6f8fea9f // udot v31.4s, v20.16b, v15.4b[2]\n"
                    ".inst 0x6fa0eaba // udot v26.4s, v21.16b, v0.4b[3]\n"
                    ".inst 0x6fa3eabb // udot v27.4s, v21.16b, v3.4b[3]\n"
                    ".inst 0x6fa6eabc // udot v28.4s, v21.16b, v6.4b[3]\n"
                    ".inst 0x6fa9eabd // udot v29.4s, v21.16b, v9.4b[3]\n"
                    ".inst 0x6faceabe // udot v30.4s, v21.16b, v12.4b[3]\n"
                    ".inst 0x6fafeabf // udot v31.4s, v21.16b, v15.4b[3]\n"
                    ".inst 0x6f81e2da // udot v26.4s, v22.16b, v1.4b[0]\n"
                    ".inst 0x6f84e2db // udot v27.4s, v22.16b, v4.4b[0]\n"
                    ".inst 0x6f87e2dc // udot v28.4s, v22.16b, v7.4b[0]\n"
                    ".inst 0x6f8ae2dd // udot v29.4s, v22.16b, v10.4b[0]\n"
                    ".inst 0x6f8de2de // udot v30.4s, v22.16b, v13.4b[0]\n"
                    ".inst 0x6f90e2df // udot v31.4s, v22.16b, v16.4b[0]\n"
                    ".inst 0x6fa1e2fa // udot v26.4s, v23.16b, v1.4b[1]\n"
                    ".inst 0x6fa4e2fb // udot v27.4s, v23.16b, v4.4b[1]\n"
                    ".inst 0x6fa7e2fc // udot v28.4s, v23.16b, v7.4b[1]\n"
                    ".inst 0x6faae2fd // udot v29.4s, v23.16b, v10.4b[1]\n"
                    ".inst 0x6fade2fe // udot v30.4s, v23.16b, v13.4b[1]\n"
                    ".inst 0x6fb0e2ff // udot v31.4s, v23.16b, v16.4b[1]\n"
                    ".inst 0x6f81eb1a // udot v26.4s, v24.16b, v1.4b[2]\n"
                    ".inst 0x6f84eb1b // udot v27.4s, v24.16b, v4.4b[2]\n"
                    ".inst 0x6f87eb1c // udot v28.4s, v24.16b, v7.4b[2]\n"
                    ".inst 0x6f8aeb1d // udot v29.4s, v24.16b, v10.4b[2]\n"
                    ".inst 0x6f8deb1e // udot v30.4s, v24.16b, v13.4b[2]\n"
                    ".inst 0x6f90eb1f // udot v31.4s, v24.16b, v16.4b[2]\n"
                    ".inst 0x6fa1eb3a // udot v26.4s, v25.16b, v1.4b[3]\n"
                    ".inst 0x6fa4eb3b // udot v27.4s, v25.16b, v4.4b[3]\n"
                    ".inst 0x6fa7eb3c // udot v28.4s, v25.16b, v7.4b[3]\n"
                    ".inst 0x6faaeb3d // udot v29.4s, v25.16b, v10.4b[3]\n"
                    ".inst 0x6fadeb3e // udot v30.4s, v25.16b, v13.4b[3]\n"
                    ".inst 0x6fb0eb3f // udot v31.4s, v25.16b, v16.4b[3]\n"
                    ".inst 0x6f82e25a // udot v26.4s, v18.16b, v2.4b[0]\n"
                    ".inst 0x6f85e25b // udot v27.4s, v18.16b, v5.4b[0]\n"
                    ".inst 0x6f88e25c // udot v28.4s, v18.16b, v8.4b[0]\n"
                    ".inst 0x6f8be25d // udot v29.4s, v18.16b, v11.4b[0]\n"
                    ".inst 0x6f8ee25e // udot v30.4s, v18.16b, v14.4b[0]\n"
                    ".inst 0x6f91e25f // udot v31.4s, v18.16b, v17.4b[0]\n"
                    ".inst 0x6fa2e27a // udot v26.4s, v19.16b, v2.4b[1]\n"
                    ".inst 0x6fa5e27b // udot v27.4s, v19.16b, v5.4b[1]\n"
                    ".inst 0x6fa8e27c // udot v28.4s, v19.16b, v8.4b[1]\n"
                    ".inst 0x6fabe27d // udot v29.4s, v19.16b, v11.4b[1]\n"
                    ".inst 0x6faee27e // udot v30.4s, v19.16b, v14.4b[1]\n"
                    ".inst 0x6fb1e27f // udot v31.4s, v19.16b, v17.4b[1]\n"
                    "b.eq 7f\n"
                    "8:\n"
                    "str q26, [%[c_ptr0]]\n"
                    "subs %[loops], %[loops], #0x1\n"
                    "movi v26.4s, #0\n"
                    "ldr d18, [%[b_ptr0]]\n"
                    "ldr temploadreg2, [%[b_ptr0], #0x8]\n"
                    "add %[c_ptr0], %[c_ptr0], #0x10\n"
                    "str q27, [c_ptr1]\n"
                    "add c_ptr1, c_ptr1, #0x10\n"
                    "movi v27.4s, #0\n"
                    "ldr d19, [%[b_ptr0], #0x10]\n"
                    "ldr temploadreg3, [%[b_ptr0], #0x18]\n"
                    "prfm PSTL1KEEP, [%[c_ptr0], #0x40]\n"
                    "str q28, [c_ptr2]\n"
                    "add c_ptr2, c_ptr2, #0x10\n"
                    "movi v28.4s, #0\n"
                    "ldr d20, [%[b_ptr0], #0x20]\n"
                    "ldr temploadreg0, [%[b_ptr0], #0x28]\n"
                    "prfm PSTL1KEEP, [c_ptr1, #0x40]\n"
                    "str q29, [c_ptr3]\n"
                    "add c_ptr3, c_ptr3, #0x10\n"
                    "movi v29.4s, #0\n"
                    "ldr d21, [%[b_ptr0], #0x30]\n"
                    "ldr temploadreg1, [%[b_ptr0], #0x38]\n"
                    "prfm PSTL1KEEP, [c_ptr2, #0x40]\n"
                    "str q30, [c_ptr4]\n"
                    "add c_ptr4, c_ptr4, #0x10\n"
                    "movi v30.4s, #0\n"
                    "ldr d22, [%[b_ptr0], #0x40]\n"
                    "ins v18.d[1], temploadreg2\n"
                    "prfm PSTL1KEEP, [c_ptr3, #0x40]\n"
                    "str q31, [c_ptr5]\n"
                    "add c_ptr5, c_ptr5, #0x10\n"
                    "movi v31.4s, #0\n"
                    "ldr temploadreg2, [%[b_ptr0], #0x48]\n"
                    ".inst 0x6f80e25a // udot v26.4s, v18.16b, v0.4b[0]\n"
                    "ldr d23, [%[b_ptr0], #0x50]\n"
                    ".inst 0x6f83e25b // udot v27.4s, v18.16b, v3.4b[0]\n"
                    "ins v19.d[1], temploadreg3\n"
                    ".inst 0x6f86e25c // udot v28.4s, v18.16b, v6.4b[0]\n"
                    "ldr temploadreg3, [%[b_ptr0], #0x58]\n"
                    ".inst 0x6f89e25d // udot v29.4s, v18.16b, v9.4b[0]\n"
                    "ldr d24, [%[b_ptr0], #0x60]\n"
                    ".inst 0x6f8ce25e // udot v30.4s, v18.16b, v12.4b[0]\n"
                    "ins v20.d[1], temploadreg0\n"
                    ".inst 0x6f8fe25f // udot v31.4s, v18.16b, v15.4b[0]\n"
                    "ldr temploadreg0, [%[b_ptr0], #0x68]\n"
                    ".inst 0x6fa0e27a // udot v26.4s, v19.16b, v0.4b[1]\n"
                    "ldr d25, [%[b_ptr0], #0x70]\n"
                    ".inst 0x6fa3e27b // udot v27.4s, v19.16b, v3.4b[1]\n"
                    "ins v21.d[1], temploadreg1\n"
                    ".inst 0x6fa6e27c // udot v28.4s, v19.16b, v6.4b[1]\n"
                    "ldr temploadreg1, [%[b_ptr0], #0x78]\n"
                    ".inst 0x6fa9e27d // udot v29.4s, v19.16b, v9.4b[1]\n"
                    "ins v22.d[1], temploadreg2\n"
                    ".inst 0x6face27e // udot v30.4s, v19.16b, v12.4b[1]\n"
                    "ins v23.d[1], temploadreg3\n"
                    ".inst 0x6fafe27f // udot v31.4s, v19.16b, v15.4b[1]\n"
                    "ins v24.d[1], temploadreg0\n"
                    ".inst 0x6f80ea9a // udot v26.4s, v20.16b, v0.4b[2]\n"
                    "ins v25.d[1], temploadreg1\n"
                    ".inst 0x6f83ea9b // udot v27.4s, v20.16b, v3.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x80\n"
                    ".inst 0x6f86ea9c // udot v28.4s, v20.16b, v6.4b[2]\n"
                    "ldr d18, [%[b_ptr0]]\n"
                    ".inst 0x6f89ea9d // udot v29.4s, v20.16b, v9.4b[2]\n"
                    "ldr temploadreg2, [%[b_ptr0], #0x8]\n"
                    ".inst 0x6f8cea9e // udot v30.4s, v20.16b, v12.4b[2]\n"
                    "ldr d19, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f8fea9f // udot v31.4s, v20.16b, v15.4b[2]\n"
                    "ldr temploadreg3, [%[b_ptr0], #0x18]\n"
                    ".inst 0x6fa0eaba // udot v26.4s, v21.16b, v0.4b[3]\n"
                    "ins v18.d[1], temploadreg2\n"
                    ".inst 0x6fa3eabb // udot v27.4s, v21.16b, v3.4b[3]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6fa6eabc // udot v28.4s, v21.16b, v6.4b[3]\n"
                    "ins v19.d[1], temploadreg3\n"
                    ".inst 0x6fa9eabd // udot v29.4s, v21.16b, v9.4b[3]\n"
                    "prfm PSTL1KEEP, [c_ptr4, #0x40]\n"
                    ".inst 0x6faceabe // udot v30.4s, v21.16b, v12.4b[3]\n"
                    "prfm PSTL1KEEP, [c_ptr5, #0x40]\n"
                    ".inst 0x6fafeabf // udot v31.4s, v21.16b, v15.4b[3]\n"
                    ".inst 0x6f81e2da // udot v26.4s, v22.16b, v1.4b[0]\n"
                    ".inst 0x6f84e2db // udot v27.4s, v22.16b, v4.4b[0]\n"
                    ".inst 0x6f87e2dc // udot v28.4s, v22.16b, v7.4b[0]\n"
                    ".inst 0x6f8ae2dd // udot v29.4s, v22.16b, v10.4b[0]\n"
                    ".inst 0x6f8de2de // udot v30.4s, v22.16b, v13.4b[0]\n"
                    ".inst 0x6f90e2df // udot v31.4s, v22.16b, v16.4b[0]\n"
                    ".inst 0x6fa1e2fa // udot v26.4s, v23.16b, v1.4b[1]\n"
                    ".inst 0x6fa4e2fb // udot v27.4s, v23.16b, v4.4b[1]\n"
                    ".inst 0x6fa7e2fc // udot v28.4s, v23.16b, v7.4b[1]\n"
                    ".inst 0x6faae2fd // udot v29.4s, v23.16b, v10.4b[1]\n"
                    ".inst 0x6fade2fe // udot v30.4s, v23.16b, v13.4b[1]\n"
                    ".inst 0x6fb0e2ff // udot v31.4s, v23.16b, v16.4b[1]\n"
                    ".inst 0x6f81eb1a // udot v26.4s, v24.16b, v1.4b[2]\n"
                    ".inst 0x6f84eb1b // udot v27.4s, v24.16b, v4.4b[2]\n"
                    ".inst 0x6f87eb1c // udot v28.4s, v24.16b, v7.4b[2]\n"
                    ".inst 0x6f8aeb1d // udot v29.4s, v24.16b, v10.4b[2]\n"
                    ".inst 0x6f8deb1e // udot v30.4s, v24.16b, v13.4b[2]\n"
                    ".inst 0x6f90eb1f // udot v31.4s, v24.16b, v16.4b[2]\n"
                    ".inst 0x6fa1eb3a // udot v26.4s, v25.16b, v1.4b[3]\n"
                    ".inst 0x6fa4eb3b // udot v27.4s, v25.16b, v4.4b[3]\n"
                    ".inst 0x6fa7eb3c // udot v28.4s, v25.16b, v7.4b[3]\n"
                    ".inst 0x6faaeb3d // udot v29.4s, v25.16b, v10.4b[3]\n"
                    ".inst 0x6fadeb3e // udot v30.4s, v25.16b, v13.4b[3]\n"
                    ".inst 0x6fb0eb3f // udot v31.4s, v25.16b, v16.4b[3]\n"
                    ".inst 0x6f82e25a // udot v26.4s, v18.16b, v2.4b[0]\n"
                    ".inst 0x6f85e25b // udot v27.4s, v18.16b, v5.4b[0]\n"
                    ".inst 0x6f88e25c // udot v28.4s, v18.16b, v8.4b[0]\n"
                    ".inst 0x6f8be25d // udot v29.4s, v18.16b, v11.4b[0]\n"
                    ".inst 0x6f8ee25e // udot v30.4s, v18.16b, v14.4b[0]\n"
                    ".inst 0x6f91e25f // udot v31.4s, v18.16b, v17.4b[0]\n"
                    ".inst 0x6fa2e27a // udot v26.4s, v19.16b, v2.4b[1]\n"
                    ".inst 0x6fa5e27b // udot v27.4s, v19.16b, v5.4b[1]\n"
                    ".inst 0x6fa8e27c // udot v28.4s, v19.16b, v8.4b[1]\n"
                    ".inst 0x6fabe27d // udot v29.4s, v19.16b, v11.4b[1]\n"
                    ".inst 0x6faee27e // udot v30.4s, v19.16b, v14.4b[1]\n"
                    ".inst 0x6fb1e27f // udot v31.4s, v19.16b, v17.4b[1]\n"
                    "b.ne 8b\n"
                    "7:\n"
                    "str q26, [%[c_ptr0]]\n"
                    "add %[c_ptr0], %[c_ptr0], #0x10\n"
                    "movi v26.4s, #0\n"
                    "ldr q18, [%[b_ptr0]]\n"
                    "ldr q19, [%[b_ptr0], #0x10]\n"
                    "str q27, [c_ptr1]\n"
                    "add c_ptr1, c_ptr1, #0x10\n"
                    "movi v27.4s, #0\n"
                    "ldr q20, [%[b_ptr0], #0x20]\n"
                    ".inst 0x6f80e25a // udot v26.4s, v18.16b, v0.4b[0]\n"
                    "str q28, [c_ptr2]\n"
                    "movi v28.4s, #0\n"
                    "ldr q21, [%[b_ptr0], #0x30]\n"
                    "ldr q22, [%[b_ptr0], #0x40]\n"
                    "add c_ptr2, c_ptr2, #0x10\n"
                    ".inst 0x6f83e25b // udot v27.4s, v18.16b, v3.4b[0]\n"
                    "str q29, [c_ptr3]\n"
                    "movi v29.4s, #0\n"
                    "ldr q23, [%[b_ptr0], #0x50]\n"
                    ".inst 0x6f86e25c // udot v28.4s, v18.16b, v6.4b[0]\n"
                    "ldr q24, [%[b_ptr0], #0x60]\n"
                    ".inst 0x6fa0e27a // udot v26.4s, v19.16b, v0.4b[1]\n"
                    "str q30, [c_ptr4]\n"
                    "movi v30.4s, #0\n"
                    "ldr q25, [%[b_ptr0], #0x70]\n"
                    ".inst 0x6f89e25d // udot v29.4s, v18.16b, v9.4b[0]\n"
                    "add c_ptr3, c_ptr3, #0x10\n"
                    ".inst 0x6fa3e27b // udot v27.4s, v19.16b, v3.4b[1]\n"
                    "str q31, [c_ptr5]\n"
                    "movi v31.4s, #0\n"
                    "add c_ptr4, c_ptr4, #0x10\n"
                    ".inst 0x6f8ce25e // udot v30.4s, v18.16b, v12.4b[0]\n"
                    "add c_ptr5, c_ptr5, #0x10\n"
                    ".inst 0x6f8fe25f // udot v31.4s, v18.16b, v15.4b[0]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x80\n"
                    ".inst 0x6fa6e27c // udot v28.4s, v19.16b, v6.4b[1]\n"
                    "ldr q18, [%[b_ptr0]]\n"
                    ".inst 0x6fa9e27d // udot v29.4s, v19.16b, v9.4b[1]\n"
                    ".inst 0x6face27e // udot v30.4s, v19.16b, v12.4b[1]\n"
                    ".inst 0x6fafe27f // udot v31.4s, v19.16b, v15.4b[1]\n"
                    "ldr q19, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f80ea9a // udot v26.4s, v20.16b, v0.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f83ea9b // udot v27.4s, v20.16b, v3.4b[2]\n"
                    ".inst 0x6f86ea9c // udot v28.4s, v20.16b, v6.4b[2]\n"
                    ".inst 0x6f89ea9d // udot v29.4s, v20.16b, v9.4b[2]\n"
                    ".inst 0x6f8cea9e // udot v30.4s, v20.16b, v12.4b[2]\n"
                    ".inst 0x6f8fea9f // udot v31.4s, v20.16b, v15.4b[2]\n"
                    ".inst 0x6fa0eaba // udot v26.4s, v21.16b, v0.4b[3]\n"
                    ".inst 0x6fa3eabb // udot v27.4s, v21.16b, v3.4b[3]\n"
                    ".inst 0x6fa6eabc // udot v28.4s, v21.16b, v6.4b[3]\n"
                    ".inst 0x6fa9eabd // udot v29.4s, v21.16b, v9.4b[3]\n"
                    ".inst 0x6faceabe // udot v30.4s, v21.16b, v12.4b[3]\n"
                    ".inst 0x6fafeabf // udot v31.4s, v21.16b, v15.4b[3]\n"
                    ".inst 0x6f81e2da // udot v26.4s, v22.16b, v1.4b[0]\n"
                    ".inst 0x6f84e2db // udot v27.4s, v22.16b, v4.4b[0]\n"
                    ".inst 0x6f87e2dc // udot v28.4s, v22.16b, v7.4b[0]\n"
                    ".inst 0x6f8ae2dd // udot v29.4s, v22.16b, v10.4b[0]\n"
                    ".inst 0x6f8de2de // udot v30.4s, v22.16b, v13.4b[0]\n"
                    ".inst 0x6f90e2df // udot v31.4s, v22.16b, v16.4b[0]\n"
                    ".inst 0x6fa1e2fa // udot v26.4s, v23.16b, v1.4b[1]\n"
                    ".inst 0x6fa4e2fb // udot v27.4s, v23.16b, v4.4b[1]\n"
                    ".inst 0x6fa7e2fc // udot v28.4s, v23.16b, v7.4b[1]\n"
                    ".inst 0x6faae2fd // udot v29.4s, v23.16b, v10.4b[1]\n"
                    ".inst 0x6fade2fe // udot v30.4s, v23.16b, v13.4b[1]\n"
                    ".inst 0x6fb0e2ff // udot v31.4s, v23.16b, v16.4b[1]\n"
                    ".inst 0x6f81eb1a // udot v26.4s, v24.16b, v1.4b[2]\n"
                    ".inst 0x6f84eb1b // udot v27.4s, v24.16b, v4.4b[2]\n"
                    ".inst 0x6f87eb1c // udot v28.4s, v24.16b, v7.4b[2]\n"
                    ".inst 0x6f8aeb1d // udot v29.4s, v24.16b, v10.4b[2]\n"
                    ".inst 0x6f8deb1e // udot v30.4s, v24.16b, v13.4b[2]\n"
                    ".inst 0x6f90eb1f // udot v31.4s, v24.16b, v16.4b[2]\n"
                    ".inst 0x6fa1eb3a // udot v26.4s, v25.16b, v1.4b[3]\n"
                    ".inst 0x6fa4eb3b // udot v27.4s, v25.16b, v4.4b[3]\n"
                    ".inst 0x6fa7eb3c // udot v28.4s, v25.16b, v7.4b[3]\n"
                    ".inst 0x6faaeb3d // udot v29.4s, v25.16b, v10.4b[3]\n"
                    ".inst 0x6fadeb3e // udot v30.4s, v25.16b, v13.4b[3]\n"
                    ".inst 0x6fb0eb3f // udot v31.4s, v25.16b, v16.4b[3]\n"
                    ".inst 0x6f82e25a // udot v26.4s, v18.16b, v2.4b[0]\n"
                    ".inst 0x6f85e25b // udot v27.4s, v18.16b, v5.4b[0]\n"
                    ".inst 0x6f88e25c // udot v28.4s, v18.16b, v8.4b[0]\n"
                    ".inst 0x6f8be25d // udot v29.4s, v18.16b, v11.4b[0]\n"
                    ".inst 0x6f8ee25e // udot v30.4s, v18.16b, v14.4b[0]\n"
                    ".inst 0x6f91e25f // udot v31.4s, v18.16b, v17.4b[0]\n"
                    ".inst 0x6fa2e27a // udot v26.4s, v19.16b, v2.4b[1]\n"
                    ".inst 0x6fa5e27b // udot v27.4s, v19.16b, v5.4b[1]\n"
                    ".inst 0x6fa8e27c // udot v28.4s, v19.16b, v8.4b[1]\n"
                    ".inst 0x6fabe27d // udot v29.4s, v19.16b, v11.4b[1]\n"
                    ".inst 0x6faee27e // udot v30.4s, v19.16b, v14.4b[1]\n"
                    ".inst 0x6fb1e27f // udot v31.4s, v19.16b, v17.4b[1]\n"
                    "b 9f\n"
                    "6:\n"
                    "movi v26.4s, #0\n"
                    "movi v27.4s, #0\n"
                    "movi v28.4s, #0\n"
                    "movi v29.4s, #0\n"
                    "movi v30.4s, #0\n"
                    "movi v31.4s, #0\n"
                    ".inst 0x6f80e25a // udot v26.4s, v18.16b, v0.4b[0]\n"
                    ".inst 0x6f83e25b // udot v27.4s, v18.16b, v3.4b[0]\n"
                    ".inst 0x6f86e25c // udot v28.4s, v18.16b, v6.4b[0]\n"
                    ".inst 0x6f89e25d // udot v29.4s, v18.16b, v9.4b[0]\n"
                    ".inst 0x6f8ce25e // udot v30.4s, v18.16b, v12.4b[0]\n"
                    ".inst 0x6f8fe25f // udot v31.4s, v18.16b, v15.4b[0]\n"
                    "ldr q18, [%[b_ptr0]]\n"
                    ".inst 0x6fa0e27a // udot v26.4s, v19.16b, v0.4b[1]\n"
                    ".inst 0x6fa3e27b // udot v27.4s, v19.16b, v3.4b[1]\n"
                    ".inst 0x6fa6e27c // udot v28.4s, v19.16b, v6.4b[1]\n"
                    ".inst 0x6fa9e27d // udot v29.4s, v19.16b, v9.4b[1]\n"
                    ".inst 0x6face27e // udot v30.4s, v19.16b, v12.4b[1]\n"
                    ".inst 0x6fafe27f // udot v31.4s, v19.16b, v15.4b[1]\n"
                    "ldr q19, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f80ea9a // udot v26.4s, v20.16b, v0.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f83ea9b // udot v27.4s, v20.16b, v3.4b[2]\n"
                    ".inst 0x6f86ea9c // udot v28.4s, v20.16b, v6.4b[2]\n"
                    ".inst 0x6f89ea9d // udot v29.4s, v20.16b, v9.4b[2]\n"
                    ".inst 0x6f8cea9e // udot v30.4s, v20.16b, v12.4b[2]\n"
                    ".inst 0x6f8fea9f // udot v31.4s, v20.16b, v15.4b[2]\n"
                    ".inst 0x6fa0eaba // udot v26.4s, v21.16b, v0.4b[3]\n"
                    ".inst 0x6fa3eabb // udot v27.4s, v21.16b, v3.4b[3]\n"
                    ".inst 0x6fa6eabc // udot v28.4s, v21.16b, v6.4b[3]\n"
                    ".inst 0x6fa9eabd // udot v29.4s, v21.16b, v9.4b[3]\n"
                    ".inst 0x6faceabe // udot v30.4s, v21.16b, v12.4b[3]\n"
                    ".inst 0x6fafeabf // udot v31.4s, v21.16b, v15.4b[3]\n"
                    ".inst 0x6f81e2da // udot v26.4s, v22.16b, v1.4b[0]\n"
                    ".inst 0x6f84e2db // udot v27.4s, v22.16b, v4.4b[0]\n"
                    ".inst 0x6f87e2dc // udot v28.4s, v22.16b, v7.4b[0]\n"
                    ".inst 0x6f8ae2dd // udot v29.4s, v22.16b, v10.4b[0]\n"
                    ".inst 0x6f8de2de // udot v30.4s, v22.16b, v13.4b[0]\n"
                    ".inst 0x6f90e2df // udot v31.4s, v22.16b, v16.4b[0]\n"
                    ".inst 0x6fa1e2fa // udot v26.4s, v23.16b, v1.4b[1]\n"
                    ".inst 0x6fa4e2fb // udot v27.4s, v23.16b, v4.4b[1]\n"
                    ".inst 0x6fa7e2fc // udot v28.4s, v23.16b, v7.4b[1]\n"
                    ".inst 0x6faae2fd // udot v29.4s, v23.16b, v10.4b[1]\n"
                    ".inst 0x6fade2fe // udot v30.4s, v23.16b, v13.4b[1]\n"
                    ".inst 0x6fb0e2ff // udot v31.4s, v23.16b, v16.4b[1]\n"
                    ".inst 0x6f81eb1a // udot v26.4s, v24.16b, v1.4b[2]\n"
                    ".inst 0x6f84eb1b // udot v27.4s, v24.16b, v4.4b[2]\n"
                    ".inst 0x6f87eb1c // udot v28.4s, v24.16b, v7.4b[2]\n"
                    ".inst 0x6f8aeb1d // udot v29.4s, v24.16b, v10.4b[2]\n"
                    ".inst 0x6f8deb1e // udot v30.4s, v24.16b, v13.4b[2]\n"
                    ".inst 0x6f90eb1f // udot v31.4s, v24.16b, v16.4b[2]\n"
                    ".inst 0x6fa1eb3a // udot v26.4s, v25.16b, v1.4b[3]\n"
                    ".inst 0x6fa4eb3b // udot v27.4s, v25.16b, v4.4b[3]\n"
                    ".inst 0x6fa7eb3c // udot v28.4s, v25.16b, v7.4b[3]\n"
                    ".inst 0x6faaeb3d // udot v29.4s, v25.16b, v10.4b[3]\n"
                    ".inst 0x6fadeb3e // udot v30.4s, v25.16b, v13.4b[3]\n"
                    ".inst 0x6fb0eb3f // udot v31.4s, v25.16b, v16.4b[3]\n"
                    ".inst 0x6f82e25a // udot v26.4s, v18.16b, v2.4b[0]\n"
                    ".inst 0x6f85e25b // udot v27.4s, v18.16b, v5.4b[0]\n"
                    ".inst 0x6f88e25c // udot v28.4s, v18.16b, v8.4b[0]\n"
                    ".inst 0x6f8be25d // udot v29.4s, v18.16b, v11.4b[0]\n"
                    ".inst 0x6f8ee25e // udot v30.4s, v18.16b, v14.4b[0]\n"
                    ".inst 0x6f91e25f // udot v31.4s, v18.16b, v17.4b[0]\n"
                    ".inst 0x6fa2e27a // udot v26.4s, v19.16b, v2.4b[1]\n"
                    ".inst 0x6fa5e27b // udot v27.4s, v19.16b, v5.4b[1]\n"
                    ".inst 0x6fa8e27c // udot v28.4s, v19.16b, v8.4b[1]\n"
                    ".inst 0x6fabe27d // udot v29.4s, v19.16b, v11.4b[1]\n"
                    ".inst 0x6faee27e // udot v30.4s, v19.16b, v14.4b[1]\n"
                    ".inst 0x6fb1e27f // udot v31.4s, v19.16b, v17.4b[1]\n"
                    "9:\n"
                    "str q26, [%[c_ptr0]]\n"
                    "add %[c_ptr0], %[c_ptr0], #0x10\n"
                    "str q27, [c_ptr1]\n"
                    "str q28, [c_ptr2]\n"
                    "str q29, [c_ptr3]\n"
                    "str q30, [c_ptr4]\n"
                    "str q31, [c_ptr5]\n"
                    ".unreq a_ptr1\n"
                    ".unreq a_ptr2\n"
                    ".unreq a_ptr3\n"
                    ".unreq a_ptr4\n"
                    ".unreq a_ptr5\n"
                    ".unreq c_ptr1\n"
                    ".unreq c_ptr2\n"
                    ".unreq c_ptr3\n"
                    ".unreq c_ptr4\n"
                    ".unreq c_ptr5\n"
                    ".unreq temploadreg0\n"
                    ".unreq temploadreg1\n"
                    ".unreq temploadreg2\n"
                    ".unreq temploadreg3\n"
                    : [a_ptr0] "+r" (a_ptr0), [b_ptr0] "+r" (b_ptr0), [c_ptr0] "+r" (c_ptr0), [loops] "+r" (loops), [oob_rows] "+r" (oob_rows), [odds] "+r" (odds)
                    : [lda] "r" (ldab), [ldc] "r" (ldcb)
                    : "x0", "x1", "x2", "x3", "x4", "x5", "x6", "x7", "x8", "x9", "x10", "x11", "x12", "x13", "v0", "v1", "v2", "v3", "v4", "v5", "v6", "v7", "v8", "v9", "v10", "v11", "v12", "v13", "v14", "v15", "v16", "v17", "v18", "v19", "v20", "v21", "v22", "v23", "v24", "v25", "v26", "v27", "v28", "v29", "v30", "v31", "cc", "memory"
                );
                break;
            case 11:
                __asm __volatile (
                    "a_ptr1 .req X0\n"
                    "a_ptr2 .req X1\n"
                    "a_ptr3 .req X2\n"
                    "a_ptr4 .req X3\n"
                    "a_ptr5 .req X4\n"
                    "c_ptr1 .req X5\n"
                    "c_ptr2 .req X6\n"
                    "c_ptr3 .req X7\n"
                    "c_ptr4 .req X8\n"
                    "c_ptr5 .req X9\n"
                    "temploadreg0 .req X10\n"
                    "temploadreg1 .req X11\n"
                    "temploadreg2 .req X12\n"
                    "temploadreg3 .req X13\n"
                    "add a_ptr1, %[a_ptr0], %[lda]\n"
                    "add c_ptr1, %[c_ptr0], %[ldc]\n"
                    "add a_ptr2, a_ptr1, %[lda]\n"
                    "add c_ptr2, c_ptr1, %[ldc]\n"
                    "add a_ptr3, a_ptr2, %[lda]\n"
                    "add c_ptr3, c_ptr2, %[ldc]\n"
                    "add a_ptr4, a_ptr3, %[lda]\n"
                    "add c_ptr4, c_ptr3, %[ldc]\n"
                    "add a_ptr5, a_ptr4, %[lda]\n"
                    "add c_ptr5, c_ptr4, %[ldc]\n"
                    "cbz %[oob_rows], 1f\n"
                    "subs %[oob_rows], %[oob_rows], #0x1\n"
                    "add c_ptr5, %[c_ptr0], #0x0\n"
                    "add a_ptr5, %[a_ptr0], #0x0\n"
                    "b.eq 1f\n"
                    "subs %[oob_rows], %[oob_rows], #0x1\n"
                    "add c_ptr4, %[c_ptr0], #0x0\n"
                    "add a_ptr4, %[a_ptr0], #0x0\n"
                    "b.eq 1f\n"
                    "subs %[oob_rows], %[oob_rows], #0x1\n"
                    "add c_ptr3, %[c_ptr0], #0x0\n"
                    "add a_ptr3, %[a_ptr0], #0x0\n"
                    "b.eq 1f\n"
                    "subs %[oob_rows], %[oob_rows], #0x1\n"
                    "add c_ptr2, %[c_ptr0], #0x0\n"
                    "add a_ptr2, %[a_ptr0], #0x0\n"
                    "b.eq 1f\n"
                    "subs %[oob_rows], %[oob_rows], #0x1\n"
                    "add c_ptr1, %[c_ptr0], #0x0\n"
                    "add a_ptr1, %[a_ptr0], #0x0\n"
                    "1:\n"
                    "ldr q0, [%[a_ptr0]], #0x10\n"
                    "ldr q3, [a_ptr1], #0x10\n"
                    "ldr q6, [a_ptr2], #0x10\n"
                    "ldr q9, [a_ptr3], #0x10\n"
                    "ldr q12, [a_ptr4], #0x10\n"
                    "ldr q15, [a_ptr5], #0x10\n"
                    "ldr q1, [%[a_ptr0]], #0x10\n"
                    "ldr q4, [a_ptr1], #0x10\n"
                    "ldr q7, [a_ptr2], #0x10\n"
                    "ldr q10, [a_ptr3], #0x10\n"
                    "ldr d2, [%[a_ptr0]], #0x8\n"
                    "ldr q13, [a_ptr4], #0x10\n"
                    "ldr d5, [a_ptr1], #0x8\n"
                    "ldr q16, [a_ptr5], #0x10\n"
                    "ldr d8, [a_ptr2], #0x8\n"
                    "ldr d11, [a_ptr3], #0x8\n"
                    "ldr d14, [a_ptr4], #0x8\n"
                    "ldr d17, [a_ptr5], #0x8\n"
                    "cbnz %[odds], 2f\n"
                    "ld1 {v2.s}[2], [%[a_ptr0]]\n"
                    "ld1 {v5.s}[2], [a_ptr1]\n"
                    "ld1 {v8.s}[2], [a_ptr2]\n"
                    "ld1 {v11.s}[2], [a_ptr3]\n"
                    "ld1 {v14.s}[2], [a_ptr4]\n"
                    "ld1 {v17.s}[2], [a_ptr5]\n"
                    "b 3f\n"
                    "2:\n"
                    "subs %[odds], %[odds], #0x1\n"
                    "b.ne 4f\n"
                    "ld1 {v2.b}[8], [%[a_ptr0]]\n"
                    "ld1 {v5.b}[8], [a_ptr1]\n"
                    "ld1 {v8.b}[8], [a_ptr2]\n"
                    "ld1 {v11.b}[8], [a_ptr3]\n"
                    "ld1 {v14.b}[8], [a_ptr4]\n"
                    "ld1 {v17.b}[8], [a_ptr5]\n"
                    "b 3f\n"
                    "4:\n"
                    "ld1 {v2.h}[4], [%[a_ptr0]], #2\n"
                    "ld1 {v5.h}[4], [a_ptr1], #2\n"
                    "ld1 {v8.h}[4], [a_ptr2], #2\n"
                    "ld1 {v11.h}[4], [a_ptr3], #2\n"
                    "ld1 {v14.h}[4], [a_ptr4], #2\n"
                    "ld1 {v17.h}[4], [a_ptr5], #2\n"
                    "subs %[odds], %[odds], #0x1\n"
                    "b.ne 5f\n"
                    "b 3f\n"
                    "5:\n"
                    "ld1 {v2.b}[10], [%[a_ptr0]]\n"
                    "ld1 {v5.b}[10], [a_ptr1]\n"
                    "ld1 {v8.b}[10], [a_ptr2]\n"
                    "ld1 {v11.b}[10], [a_ptr3]\n"
                    "ld1 {v14.b}[10], [a_ptr4]\n"
                    "ld1 {v17.b}[10], [a_ptr5]\n"
                    "3:\n"
                    "ldr q18, [%[b_ptr0]]\n"
                    "prfm PLDL1KEEP, [a_ptr5, #0x40]\n"
                    "ldr q19, [%[b_ptr0], #0x10]\n"
                    "prfm PLDL1KEEP, [a_ptr5, #0x80]\n"
                    "ldr q20, [%[b_ptr0], #0x20]\n"
                    "prfm PLDL1KEEP, [a_ptr5, #0xc0]\n"
                    "ldr q21, [%[b_ptr0], #0x30]\n"
                    "prfm PLDL1KEEP, [a_ptr5, #0x100]\n"
                    "ldr q22, [%[b_ptr0], #0x40]\n"
                    "prfm PLDL1KEEP, [a_ptr5, #0x140]\n"
                    "ldr q23, [%[b_ptr0], #0x50]\n"
                    "prfm PLDL1KEEP, [a_ptr5, #0x180]\n"
                    "ldr q24, [%[b_ptr0], #0x60]\n"
                    "ldr q25, [%[b_ptr0], #0x70]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x80\n"
                    "cbz %[loops], 6f\n"
                    "movi v26.4s, #0\n"
                    "subs %[loops], %[loops], #0x1\n"
                    "movi v27.4s, #0\n"
                    "movi v28.4s, #0\n"
                    "movi v29.4s, #0\n"
                    "movi v30.4s, #0\n"
                    "movi v31.4s, #0\n"
                    ".inst 0x6f80e25a // udot v26.4s, v18.16b, v0.4b[0]\n"
                    ".inst 0x6f83e25b // udot v27.4s, v18.16b, v3.4b[0]\n"
                    ".inst 0x6f86e25c // udot v28.4s, v18.16b, v6.4b[0]\n"
                    ".inst 0x6f89e25d // udot v29.4s, v18.16b, v9.4b[0]\n"
                    ".inst 0x6f8ce25e // udot v30.4s, v18.16b, v12.4b[0]\n"
                    ".inst 0x6f8fe25f // udot v31.4s, v18.16b, v15.4b[0]\n"
                    "ldr q18, [%[b_ptr0]]\n"
                    ".inst 0x6fa0e27a // udot v26.4s, v19.16b, v0.4b[1]\n"
                    ".inst 0x6fa3e27b // udot v27.4s, v19.16b, v3.4b[1]\n"
                    ".inst 0x6fa6e27c // udot v28.4s, v19.16b, v6.4b[1]\n"
                    ".inst 0x6fa9e27d // udot v29.4s, v19.16b, v9.4b[1]\n"
                    ".inst 0x6face27e // udot v30.4s, v19.16b, v12.4b[1]\n"
                    ".inst 0x6fafe27f // udot v31.4s, v19.16b, v15.4b[1]\n"
                    "ldr q19, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f80ea9a // udot v26.4s, v20.16b, v0.4b[2]\n"
                    ".inst 0x6f83ea9b // udot v27.4s, v20.16b, v3.4b[2]\n"
                    ".inst 0x6f86ea9c // udot v28.4s, v20.16b, v6.4b[2]\n"
                    ".inst 0x6f89ea9d // udot v29.4s, v20.16b, v9.4b[2]\n"
                    ".inst 0x6f8cea9e // udot v30.4s, v20.16b, v12.4b[2]\n"
                    ".inst 0x6f8fea9f // udot v31.4s, v20.16b, v15.4b[2]\n"
                    "ldr q20, [%[b_ptr0], #0x20]\n"
                    ".inst 0x6fa0eaba // udot v26.4s, v21.16b, v0.4b[3]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x30\n"
                    ".inst 0x6fa3eabb // udot v27.4s, v21.16b, v3.4b[3]\n"
                    ".inst 0x6fa6eabc // udot v28.4s, v21.16b, v6.4b[3]\n"
                    ".inst 0x6fa9eabd // udot v29.4s, v21.16b, v9.4b[3]\n"
                    ".inst 0x6faceabe // udot v30.4s, v21.16b, v12.4b[3]\n"
                    ".inst 0x6fafeabf // udot v31.4s, v21.16b, v15.4b[3]\n"
                    ".inst 0x6f81e2da // udot v26.4s, v22.16b, v1.4b[0]\n"
                    ".inst 0x6f84e2db // udot v27.4s, v22.16b, v4.4b[0]\n"
                    ".inst 0x6f87e2dc // udot v28.4s, v22.16b, v7.4b[0]\n"
                    ".inst 0x6f8ae2dd // udot v29.4s, v22.16b, v10.4b[0]\n"
                    ".inst 0x6f8de2de // udot v30.4s, v22.16b, v13.4b[0]\n"
                    ".inst 0x6f90e2df // udot v31.4s, v22.16b, v16.4b[0]\n"
                    ".inst 0x6fa1e2fa // udot v26.4s, v23.16b, v1.4b[1]\n"
                    ".inst 0x6fa4e2fb // udot v27.4s, v23.16b, v4.4b[1]\n"
                    ".inst 0x6fa7e2fc // udot v28.4s, v23.16b, v7.4b[1]\n"
                    ".inst 0x6faae2fd // udot v29.4s, v23.16b, v10.4b[1]\n"
                    ".inst 0x6fade2fe // udot v30.4s, v23.16b, v13.4b[1]\n"
                    ".inst 0x6fb0e2ff // udot v31.4s, v23.16b, v16.4b[1]\n"
                    ".inst 0x6f81eb1a // udot v26.4s, v24.16b, v1.4b[2]\n"
                    ".inst 0x6f84eb1b // udot v27.4s, v24.16b, v4.4b[2]\n"
                    ".inst 0x6f87eb1c // udot v28.4s, v24.16b, v7.4b[2]\n"
                    ".inst 0x6f8aeb1d // udot v29.4s, v24.16b, v10.4b[2]\n"
                    ".inst 0x6f8deb1e // udot v30.4s, v24.16b, v13.4b[2]\n"
                    ".inst 0x6f90eb1f // udot v31.4s, v24.16b, v16.4b[2]\n"
                    ".inst 0x6fa1eb3a // udot v26.4s, v25.16b, v1.4b[3]\n"
                    ".inst 0x6fa4eb3b // udot v27.4s, v25.16b, v4.4b[3]\n"
                    ".inst 0x6fa7eb3c // udot v28.4s, v25.16b, v7.4b[3]\n"
                    ".inst 0x6faaeb3d // udot v29.4s, v25.16b, v10.4b[3]\n"
                    ".inst 0x6fadeb3e // udot v30.4s, v25.16b, v13.4b[3]\n"
                    ".inst 0x6fb0eb3f // udot v31.4s, v25.16b, v16.4b[3]\n"
                    ".inst 0x6f82e25a // udot v26.4s, v18.16b, v2.4b[0]\n"
                    ".inst 0x6f85e25b // udot v27.4s, v18.16b, v5.4b[0]\n"
                    ".inst 0x6f88e25c // udot v28.4s, v18.16b, v8.4b[0]\n"
                    ".inst 0x6f8be25d // udot v29.4s, v18.16b, v11.4b[0]\n"
                    ".inst 0x6f8ee25e // udot v30.4s, v18.16b, v14.4b[0]\n"
                    ".inst 0x6f91e25f // udot v31.4s, v18.16b, v17.4b[0]\n"
                    ".inst 0x6fa2e27a // udot v26.4s, v19.16b, v2.4b[1]\n"
                    ".inst 0x6fa5e27b // udot v27.4s, v19.16b, v5.4b[1]\n"
                    ".inst 0x6fa8e27c // udot v28.4s, v19.16b, v8.4b[1]\n"
                    ".inst 0x6fabe27d // udot v29.4s, v19.16b, v11.4b[1]\n"
                    ".inst 0x6faee27e // udot v30.4s, v19.16b, v14.4b[1]\n"
                    ".inst 0x6fb1e27f // udot v31.4s, v19.16b, v17.4b[1]\n"
                    ".inst 0x6f82ea9a // udot v26.4s, v20.16b, v2.4b[2]\n"
                    ".inst 0x6f85ea9b // udot v27.4s, v20.16b, v5.4b[2]\n"
                    ".inst 0x6f88ea9c // udot v28.4s, v20.16b, v8.4b[2]\n"
                    ".inst 0x6f8bea9d // udot v29.4s, v20.16b, v11.4b[2]\n"
                    ".inst 0x6f8eea9e // udot v30.4s, v20.16b, v14.4b[2]\n"
                    ".inst 0x6f91ea9f // udot v31.4s, v20.16b, v17.4b[2]\n"
                    "b.eq 7f\n"
                    "8:\n"
                    "str q26, [%[c_ptr0]]\n"
                    "subs %[loops], %[loops], #0x1\n"
                    "movi v26.4s, #0\n"
                    "ldr d18, [%[b_ptr0]]\n"
                    "ldr temploadreg2, [%[b_ptr0], #0x8]\n"
                    "add %[c_ptr0], %[c_ptr0], #0x10\n"
                    "str q27, [c_ptr1]\n"
                    "add c_ptr1, c_ptr1, #0x10\n"
                    "movi v27.4s, #0\n"
                    "ldr d19, [%[b_ptr0], #0x10]\n"
                    "ldr temploadreg3, [%[b_ptr0], #0x18]\n"
                    "prfm PSTL1KEEP, [%[c_ptr0], #0x40]\n"
                    "str q28, [c_ptr2]\n"
                    "add c_ptr2, c_ptr2, #0x10\n"
                    "movi v28.4s, #0\n"
                    "ldr d20, [%[b_ptr0], #0x20]\n"
                    "ldr temploadreg0, [%[b_ptr0], #0x28]\n"
                    "prfm PSTL1KEEP, [c_ptr1, #0x40]\n"
                    "str q29, [c_ptr3]\n"
                    "add c_ptr3, c_ptr3, #0x10\n"
                    "movi v29.4s, #0\n"
                    "ldr d21, [%[b_ptr0], #0x30]\n"
                    "ldr temploadreg1, [%[b_ptr0], #0x38]\n"
                    "prfm PSTL1KEEP, [c_ptr2, #0x40]\n"
                    "str q30, [c_ptr4]\n"
                    "add c_ptr4, c_ptr4, #0x10\n"
                    "movi v30.4s, #0\n"
                    "ldr d22, [%[b_ptr0], #0x40]\n"
                    "ins v18.d[1], temploadreg2\n"
                    "prfm PSTL1KEEP, [c_ptr3, #0x40]\n"
                    "str q31, [c_ptr5]\n"
                    "add c_ptr5, c_ptr5, #0x10\n"
                    "movi v31.4s, #0\n"
                    "ldr temploadreg2, [%[b_ptr0], #0x48]\n"
                    ".inst 0x6f80e25a // udot v26.4s, v18.16b, v0.4b[0]\n"
                    "ldr d23, [%[b_ptr0], #0x50]\n"
                    ".inst 0x6f83e25b // udot v27.4s, v18.16b, v3.4b[0]\n"
                    "ins v19.d[1], temploadreg3\n"
                    ".inst 0x6f86e25c // udot v28.4s, v18.16b, v6.4b[0]\n"
                    "ldr temploadreg3, [%[b_ptr0], #0x58]\n"
                    ".inst 0x6f89e25d // udot v29.4s, v18.16b, v9.4b[0]\n"
                    "ldr d24, [%[b_ptr0], #0x60]\n"
                    ".inst 0x6f8ce25e // udot v30.4s, v18.16b, v12.4b[0]\n"
                    "ins v20.d[1], temploadreg0\n"
                    ".inst 0x6f8fe25f // udot v31.4s, v18.16b, v15.4b[0]\n"
                    "ldr temploadreg0, [%[b_ptr0], #0x68]\n"
                    ".inst 0x6fa0e27a // udot v26.4s, v19.16b, v0.4b[1]\n"
                    "ldr d25, [%[b_ptr0], #0x70]\n"
                    ".inst 0x6fa3e27b // udot v27.4s, v19.16b, v3.4b[1]\n"
                    "ins v21.d[1], temploadreg1\n"
                    ".inst 0x6fa6e27c // udot v28.4s, v19.16b, v6.4b[1]\n"
                    "ldr temploadreg1, [%[b_ptr0], #0x78]\n"
                    ".inst 0x6fa9e27d // udot v29.4s, v19.16b, v9.4b[1]\n"
                    "ins v22.d[1], temploadreg2\n"
                    ".inst 0x6face27e // udot v30.4s, v19.16b, v12.4b[1]\n"
                    "ins v23.d[1], temploadreg3\n"
                    ".inst 0x6fafe27f // udot v31.4s, v19.16b, v15.4b[1]\n"
                    "ins v24.d[1], temploadreg0\n"
                    ".inst 0x6f80ea9a // udot v26.4s, v20.16b, v0.4b[2]\n"
                    "ins v25.d[1], temploadreg1\n"
                    ".inst 0x6f83ea9b // udot v27.4s, v20.16b, v3.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x80\n"
                    ".inst 0x6f86ea9c // udot v28.4s, v20.16b, v6.4b[2]\n"
                    "ldr d18, [%[b_ptr0]]\n"
                    ".inst 0x6f89ea9d // udot v29.4s, v20.16b, v9.4b[2]\n"
                    "ldr temploadreg2, [%[b_ptr0], #0x8]\n"
                    ".inst 0x6f8cea9e // udot v30.4s, v20.16b, v12.4b[2]\n"
                    "ldr d19, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f8fea9f // udot v31.4s, v20.16b, v15.4b[2]\n"
                    "ldr temploadreg3, [%[b_ptr0], #0x18]\n"
                    ".inst 0x6fa0eaba // udot v26.4s, v21.16b, v0.4b[3]\n"
                    "ldr d20, [%[b_ptr0], #0x20]\n"
                    ".inst 0x6fa3eabb // udot v27.4s, v21.16b, v3.4b[3]\n"
                    "ldr temploadreg0, [%[b_ptr0], #0x28]\n"
                    ".inst 0x6fa6eabc // udot v28.4s, v21.16b, v6.4b[3]\n"
                    "ins v18.d[1], temploadreg2\n"
                    ".inst 0x6fa9eabd // udot v29.4s, v21.16b, v9.4b[3]\n"
                    "ins v19.d[1], temploadreg3\n"
                    ".inst 0x6faceabe // udot v30.4s, v21.16b, v12.4b[3]\n"
                    "ins v20.d[1], temploadreg0\n"
                    ".inst 0x6fafeabf // udot v31.4s, v21.16b, v15.4b[3]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x30\n"
                    ".inst 0x6f81e2da // udot v26.4s, v22.16b, v1.4b[0]\n"
                    "prfm PSTL1KEEP, [c_ptr4, #0x40]\n"
                    ".inst 0x6f84e2db // udot v27.4s, v22.16b, v4.4b[0]\n"
                    "prfm PSTL1KEEP, [c_ptr5, #0x40]\n"
                    ".inst 0x6f87e2dc // udot v28.4s, v22.16b, v7.4b[0]\n"
                    ".inst 0x6f8ae2dd // udot v29.4s, v22.16b, v10.4b[0]\n"
                    ".inst 0x6f8de2de // udot v30.4s, v22.16b, v13.4b[0]\n"
                    ".inst 0x6f90e2df // udot v31.4s, v22.16b, v16.4b[0]\n"
                    ".inst 0x6fa1e2fa // udot v26.4s, v23.16b, v1.4b[1]\n"
                    ".inst 0x6fa4e2fb // udot v27.4s, v23.16b, v4.4b[1]\n"
                    ".inst 0x6fa7e2fc // udot v28.4s, v23.16b, v7.4b[1]\n"
                    ".inst 0x6faae2fd // udot v29.4s, v23.16b, v10.4b[1]\n"
                    ".inst 0x6fade2fe // udot v30.4s, v23.16b, v13.4b[1]\n"
                    ".inst 0x6fb0e2ff // udot v31.4s, v23.16b, v16.4b[1]\n"
                    ".inst 0x6f81eb1a // udot v26.4s, v24.16b, v1.4b[2]\n"
                    ".inst 0x6f84eb1b // udot v27.4s, v24.16b, v4.4b[2]\n"
                    ".inst 0x6f87eb1c // udot v28.4s, v24.16b, v7.4b[2]\n"
                    ".inst 0x6f8aeb1d // udot v29.4s, v24.16b, v10.4b[2]\n"
                    ".inst 0x6f8deb1e // udot v30.4s, v24.16b, v13.4b[2]\n"
                    ".inst 0x6f90eb1f // udot v31.4s, v24.16b, v16.4b[2]\n"
                    ".inst 0x6fa1eb3a // udot v26.4s, v25.16b, v1.4b[3]\n"
                    ".inst 0x6fa4eb3b // udot v27.4s, v25.16b, v4.4b[3]\n"
                    ".inst 0x6fa7eb3c // udot v28.4s, v25.16b, v7.4b[3]\n"
                    ".inst 0x6faaeb3d // udot v29.4s, v25.16b, v10.4b[3]\n"
                    ".inst 0x6fadeb3e // udot v30.4s, v25.16b, v13.4b[3]\n"
                    ".inst 0x6fb0eb3f // udot v31.4s, v25.16b, v16.4b[3]\n"
                    ".inst 0x6f82e25a // udot v26.4s, v18.16b, v2.4b[0]\n"
                    ".inst 0x6f85e25b // udot v27.4s, v18.16b, v5.4b[0]\n"
                    ".inst 0x6f88e25c // udot v28.4s, v18.16b, v8.4b[0]\n"
                    ".inst 0x6f8be25d // udot v29.4s, v18.16b, v11.4b[0]\n"
                    ".inst 0x6f8ee25e // udot v30.4s, v18.16b, v14.4b[0]\n"
                    ".inst 0x6f91e25f // udot v31.4s, v18.16b, v17.4b[0]\n"
                    ".inst 0x6fa2e27a // udot v26.4s, v19.16b, v2.4b[1]\n"
                    ".inst 0x6fa5e27b // udot v27.4s, v19.16b, v5.4b[1]\n"
                    ".inst 0x6fa8e27c // udot v28.4s, v19.16b, v8.4b[1]\n"
                    ".inst 0x6fabe27d // udot v29.4s, v19.16b, v11.4b[1]\n"
                    ".inst 0x6faee27e // udot v30.4s, v19.16b, v14.4b[1]\n"
                    ".inst 0x6fb1e27f // udot v31.4s, v19.16b, v17.4b[1]\n"
                    ".inst 0x6f82ea9a // udot v26.4s, v20.16b, v2.4b[2]\n"
                    ".inst 0x6f85ea9b // udot v27.4s, v20.16b, v5.4b[2]\n"
                    ".inst 0x6f88ea9c // udot v28.4s, v20.16b, v8.4b[2]\n"
                    ".inst 0x6f8bea9d // udot v29.4s, v20.16b, v11.4b[2]\n"
                    ".inst 0x6f8eea9e // udot v30.4s, v20.16b, v14.4b[2]\n"
                    ".inst 0x6f91ea9f // udot v31.4s, v20.16b, v17.4b[2]\n"
                    "b.ne 8b\n"
                    "7:\n"
                    "str q26, [%[c_ptr0]]\n"
                    "add %[c_ptr0], %[c_ptr0], #0x10\n"
                    "movi v26.4s, #0\n"
                    "ldr q18, [%[b_ptr0]]\n"
                    "ldr q19, [%[b_ptr0], #0x10]\n"
                    "str q27, [c_ptr1]\n"
                    "add c_ptr1, c_ptr1, #0x10\n"
                    "movi v27.4s, #0\n"
                    "ldr q20, [%[b_ptr0], #0x20]\n"
                    ".inst 0x6f80e25a // udot v26.4s, v18.16b, v0.4b[0]\n"
                    "str q28, [c_ptr2]\n"
                    "movi v28.4s, #0\n"
                    "ldr q21, [%[b_ptr0], #0x30]\n"
                    "ldr q22, [%[b_ptr0], #0x40]\n"
                    "add c_ptr2, c_ptr2, #0x10\n"
                    ".inst 0x6f83e25b // udot v27.4s, v18.16b, v3.4b[0]\n"
                    "str q29, [c_ptr3]\n"
                    "movi v29.4s, #0\n"
                    "ldr q23, [%[b_ptr0], #0x50]\n"
                    ".inst 0x6f86e25c // udot v28.4s, v18.16b, v6.4b[0]\n"
                    "ldr q24, [%[b_ptr0], #0x60]\n"
                    ".inst 0x6fa0e27a // udot v26.4s, v19.16b, v0.4b[1]\n"
                    "str q30, [c_ptr4]\n"
                    "movi v30.4s, #0\n"
                    "ldr q25, [%[b_ptr0], #0x70]\n"
                    ".inst 0x6f89e25d // udot v29.4s, v18.16b, v9.4b[0]\n"
                    "add c_ptr3, c_ptr3, #0x10\n"
                    ".inst 0x6fa3e27b // udot v27.4s, v19.16b, v3.4b[1]\n"
                    "str q31, [c_ptr5]\n"
                    "movi v31.4s, #0\n"
                    "add c_ptr4, c_ptr4, #0x10\n"
                    ".inst 0x6f8ce25e // udot v30.4s, v18.16b, v12.4b[0]\n"
                    "add c_ptr5, c_ptr5, #0x10\n"
                    ".inst 0x6f8fe25f // udot v31.4s, v18.16b, v15.4b[0]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x80\n"
                    ".inst 0x6fa6e27c // udot v28.4s, v19.16b, v6.4b[1]\n"
                    "ldr q18, [%[b_ptr0]]\n"
                    ".inst 0x6fa9e27d // udot v29.4s, v19.16b, v9.4b[1]\n"
                    ".inst 0x6face27e // udot v30.4s, v19.16b, v12.4b[1]\n"
                    ".inst 0x6fafe27f // udot v31.4s, v19.16b, v15.4b[1]\n"
                    "ldr q19, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f80ea9a // udot v26.4s, v20.16b, v0.4b[2]\n"
                    ".inst 0x6f83ea9b // udot v27.4s, v20.16b, v3.4b[2]\n"
                    ".inst 0x6f86ea9c // udot v28.4s, v20.16b, v6.4b[2]\n"
                    ".inst 0x6f89ea9d // udot v29.4s, v20.16b, v9.4b[2]\n"
                    ".inst 0x6f8cea9e // udot v30.4s, v20.16b, v12.4b[2]\n"
                    ".inst 0x6f8fea9f // udot v31.4s, v20.16b, v15.4b[2]\n"
                    "ldr q20, [%[b_ptr0], #0x20]\n"
                    ".inst 0x6fa0eaba // udot v26.4s, v21.16b, v0.4b[3]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x30\n"
                    ".inst 0x6fa3eabb // udot v27.4s, v21.16b, v3.4b[3]\n"
                    ".inst 0x6fa6eabc // udot v28.4s, v21.16b, v6.4b[3]\n"
                    ".inst 0x6fa9eabd // udot v29.4s, v21.16b, v9.4b[3]\n"
                    ".inst 0x6faceabe // udot v30.4s, v21.16b, v12.4b[3]\n"
                    ".inst 0x6fafeabf // udot v31.4s, v21.16b, v15.4b[3]\n"
                    ".inst 0x6f81e2da // udot v26.4s, v22.16b, v1.4b[0]\n"
                    ".inst 0x6f84e2db // udot v27.4s, v22.16b, v4.4b[0]\n"
                    ".inst 0x6f87e2dc // udot v28.4s, v22.16b, v7.4b[0]\n"
                    ".inst 0x6f8ae2dd // udot v29.4s, v22.16b, v10.4b[0]\n"
                    ".inst 0x6f8de2de // udot v30.4s, v22.16b, v13.4b[0]\n"
                    ".inst 0x6f90e2df // udot v31.4s, v22.16b, v16.4b[0]\n"
                    ".inst 0x6fa1e2fa // udot v26.4s, v23.16b, v1.4b[1]\n"
                    ".inst 0x6fa4e2fb // udot v27.4s, v23.16b, v4.4b[1]\n"
                    ".inst 0x6fa7e2fc // udot v28.4s, v23.16b, v7.4b[1]\n"
                    ".inst 0x6faae2fd // udot v29.4s, v23.16b, v10.4b[1]\n"
                    ".inst 0x6fade2fe // udot v30.4s, v23.16b, v13.4b[1]\n"
                    ".inst 0x6fb0e2ff // udot v31.4s, v23.16b, v16.4b[1]\n"
                    ".inst 0x6f81eb1a // udot v26.4s, v24.16b, v1.4b[2]\n"
                    ".inst 0x6f84eb1b // udot v27.4s, v24.16b, v4.4b[2]\n"
                    ".inst 0x6f87eb1c // udot v28.4s, v24.16b, v7.4b[2]\n"
                    ".inst 0x6f8aeb1d // udot v29.4s, v24.16b, v10.4b[2]\n"
                    ".inst 0x6f8deb1e // udot v30.4s, v24.16b, v13.4b[2]\n"
                    ".inst 0x6f90eb1f // udot v31.4s, v24.16b, v16.4b[2]\n"
                    ".inst 0x6fa1eb3a // udot v26.4s, v25.16b, v1.4b[3]\n"
                    ".inst 0x6fa4eb3b // udot v27.4s, v25.16b, v4.4b[3]\n"
                    ".inst 0x6fa7eb3c // udot v28.4s, v25.16b, v7.4b[3]\n"
                    ".inst 0x6faaeb3d // udot v29.4s, v25.16b, v10.4b[3]\n"
                    ".inst 0x6fadeb3e // udot v30.4s, v25.16b, v13.4b[3]\n"
                    ".inst 0x6fb0eb3f // udot v31.4s, v25.16b, v16.4b[3]\n"
                    ".inst 0x6f82e25a // udot v26.4s, v18.16b, v2.4b[0]\n"
                    ".inst 0x6f85e25b // udot v27.4s, v18.16b, v5.4b[0]\n"
                    ".inst 0x6f88e25c // udot v28.4s, v18.16b, v8.4b[0]\n"
                    ".inst 0x6f8be25d // udot v29.4s, v18.16b, v11.4b[0]\n"
                    ".inst 0x6f8ee25e // udot v30.4s, v18.16b, v14.4b[0]\n"
                    ".inst 0x6f91e25f // udot v31.4s, v18.16b, v17.4b[0]\n"
                    ".inst 0x6fa2e27a // udot v26.4s, v19.16b, v2.4b[1]\n"
                    ".inst 0x6fa5e27b // udot v27.4s, v19.16b, v5.4b[1]\n"
                    ".inst 0x6fa8e27c // udot v28.4s, v19.16b, v8.4b[1]\n"
                    ".inst 0x6fabe27d // udot v29.4s, v19.16b, v11.4b[1]\n"
                    ".inst 0x6faee27e // udot v30.4s, v19.16b, v14.4b[1]\n"
                    ".inst 0x6fb1e27f // udot v31.4s, v19.16b, v17.4b[1]\n"
                    ".inst 0x6f82ea9a // udot v26.4s, v20.16b, v2.4b[2]\n"
                    ".inst 0x6f85ea9b // udot v27.4s, v20.16b, v5.4b[2]\n"
                    ".inst 0x6f88ea9c // udot v28.4s, v20.16b, v8.4b[2]\n"
                    ".inst 0x6f8bea9d // udot v29.4s, v20.16b, v11.4b[2]\n"
                    ".inst 0x6f8eea9e // udot v30.4s, v20.16b, v14.4b[2]\n"
                    ".inst 0x6f91ea9f // udot v31.4s, v20.16b, v17.4b[2]\n"
                    "b 9f\n"
                    "6:\n"
                    "movi v26.4s, #0\n"
                    "movi v27.4s, #0\n"
                    "movi v28.4s, #0\n"
                    "movi v29.4s, #0\n"
                    "movi v30.4s, #0\n"
                    "movi v31.4s, #0\n"
                    ".inst 0x6f80e25a // udot v26.4s, v18.16b, v0.4b[0]\n"
                    ".inst 0x6f83e25b // udot v27.4s, v18.16b, v3.4b[0]\n"
                    ".inst 0x6f86e25c // udot v28.4s, v18.16b, v6.4b[0]\n"
                    ".inst 0x6f89e25d // udot v29.4s, v18.16b, v9.4b[0]\n"
                    ".inst 0x6f8ce25e // udot v30.4s, v18.16b, v12.4b[0]\n"
                    ".inst 0x6f8fe25f // udot v31.4s, v18.16b, v15.4b[0]\n"
                    "ldr q18, [%[b_ptr0]]\n"
                    ".inst 0x6fa0e27a // udot v26.4s, v19.16b, v0.4b[1]\n"
                    ".inst 0x6fa3e27b // udot v27.4s, v19.16b, v3.4b[1]\n"
                    ".inst 0x6fa6e27c // udot v28.4s, v19.16b, v6.4b[1]\n"
                    ".inst 0x6fa9e27d // udot v29.4s, v19.16b, v9.4b[1]\n"
                    ".inst 0x6face27e // udot v30.4s, v19.16b, v12.4b[1]\n"
                    ".inst 0x6fafe27f // udot v31.4s, v19.16b, v15.4b[1]\n"
                    "ldr q19, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f80ea9a // udot v26.4s, v20.16b, v0.4b[2]\n"
                    ".inst 0x6f83ea9b // udot v27.4s, v20.16b, v3.4b[2]\n"
                    ".inst 0x6f86ea9c // udot v28.4s, v20.16b, v6.4b[2]\n"
                    ".inst 0x6f89ea9d // udot v29.4s, v20.16b, v9.4b[2]\n"
                    ".inst 0x6f8cea9e // udot v30.4s, v20.16b, v12.4b[2]\n"
                    ".inst 0x6f8fea9f // udot v31.4s, v20.16b, v15.4b[2]\n"
                    "ldr q20, [%[b_ptr0], #0x20]\n"
                    ".inst 0x6fa0eaba // udot v26.4s, v21.16b, v0.4b[3]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x30\n"
                    ".inst 0x6fa3eabb // udot v27.4s, v21.16b, v3.4b[3]\n"
                    ".inst 0x6fa6eabc // udot v28.4s, v21.16b, v6.4b[3]\n"
                    ".inst 0x6fa9eabd // udot v29.4s, v21.16b, v9.4b[3]\n"
                    ".inst 0x6faceabe // udot v30.4s, v21.16b, v12.4b[3]\n"
                    ".inst 0x6fafeabf // udot v31.4s, v21.16b, v15.4b[3]\n"
                    ".inst 0x6f81e2da // udot v26.4s, v22.16b, v1.4b[0]\n"
                    ".inst 0x6f84e2db // udot v27.4s, v22.16b, v4.4b[0]\n"
                    ".inst 0x6f87e2dc // udot v28.4s, v22.16b, v7.4b[0]\n"
                    ".inst 0x6f8ae2dd // udot v29.4s, v22.16b, v10.4b[0]\n"
                    ".inst 0x6f8de2de // udot v30.4s, v22.16b, v13.4b[0]\n"
                    ".inst 0x6f90e2df // udot v31.4s, v22.16b, v16.4b[0]\n"
                    ".inst 0x6fa1e2fa // udot v26.4s, v23.16b, v1.4b[1]\n"
                    ".inst 0x6fa4e2fb // udot v27.4s, v23.16b, v4.4b[1]\n"
                    ".inst 0x6fa7e2fc // udot v28.4s, v23.16b, v7.4b[1]\n"
                    ".inst 0x6faae2fd // udot v29.4s, v23.16b, v10.4b[1]\n"
                    ".inst 0x6fade2fe // udot v30.4s, v23.16b, v13.4b[1]\n"
                    ".inst 0x6fb0e2ff // udot v31.4s, v23.16b, v16.4b[1]\n"
                    ".inst 0x6f81eb1a // udot v26.4s, v24.16b, v1.4b[2]\n"
                    ".inst 0x6f84eb1b // udot v27.4s, v24.16b, v4.4b[2]\n"
                    ".inst 0x6f87eb1c // udot v28.4s, v24.16b, v7.4b[2]\n"
                    ".inst 0x6f8aeb1d // udot v29.4s, v24.16b, v10.4b[2]\n"
                    ".inst 0x6f8deb1e // udot v30.4s, v24.16b, v13.4b[2]\n"
                    ".inst 0x6f90eb1f // udot v31.4s, v24.16b, v16.4b[2]\n"
                    ".inst 0x6fa1eb3a // udot v26.4s, v25.16b, v1.4b[3]\n"
                    ".inst 0x6fa4eb3b // udot v27.4s, v25.16b, v4.4b[3]\n"
                    ".inst 0x6fa7eb3c // udot v28.4s, v25.16b, v7.4b[3]\n"
                    ".inst 0x6faaeb3d // udot v29.4s, v25.16b, v10.4b[3]\n"
                    ".inst 0x6fadeb3e // udot v30.4s, v25.16b, v13.4b[3]\n"
                    ".inst 0x6fb0eb3f // udot v31.4s, v25.16b, v16.4b[3]\n"
                    ".inst 0x6f82e25a // udot v26.4s, v18.16b, v2.4b[0]\n"
                    ".inst 0x6f85e25b // udot v27.4s, v18.16b, v5.4b[0]\n"
                    ".inst 0x6f88e25c // udot v28.4s, v18.16b, v8.4b[0]\n"
                    ".inst 0x6f8be25d // udot v29.4s, v18.16b, v11.4b[0]\n"
                    ".inst 0x6f8ee25e // udot v30.4s, v18.16b, v14.4b[0]\n"
                    ".inst 0x6f91e25f // udot v31.4s, v18.16b, v17.4b[0]\n"
                    ".inst 0x6fa2e27a // udot v26.4s, v19.16b, v2.4b[1]\n"
                    ".inst 0x6fa5e27b // udot v27.4s, v19.16b, v5.4b[1]\n"
                    ".inst 0x6fa8e27c // udot v28.4s, v19.16b, v8.4b[1]\n"
                    ".inst 0x6fabe27d // udot v29.4s, v19.16b, v11.4b[1]\n"
                    ".inst 0x6faee27e // udot v30.4s, v19.16b, v14.4b[1]\n"
                    ".inst 0x6fb1e27f // udot v31.4s, v19.16b, v17.4b[1]\n"
                    ".inst 0x6f82ea9a // udot v26.4s, v20.16b, v2.4b[2]\n"
                    ".inst 0x6f85ea9b // udot v27.4s, v20.16b, v5.4b[2]\n"
                    ".inst 0x6f88ea9c // udot v28.4s, v20.16b, v8.4b[2]\n"
                    ".inst 0x6f8bea9d // udot v29.4s, v20.16b, v11.4b[2]\n"
                    ".inst 0x6f8eea9e // udot v30.4s, v20.16b, v14.4b[2]\n"
                    ".inst 0x6f91ea9f // udot v31.4s, v20.16b, v17.4b[2]\n"
                    "9:\n"
                    "str q26, [%[c_ptr0]]\n"
                    "add %[c_ptr0], %[c_ptr0], #0x10\n"
                    "str q27, [c_ptr1]\n"
                    "str q28, [c_ptr2]\n"
                    "str q29, [c_ptr3]\n"
                    "str q30, [c_ptr4]\n"
                    "str q31, [c_ptr5]\n"
                    ".unreq a_ptr1\n"
                    ".unreq a_ptr2\n"
                    ".unreq a_ptr3\n"
                    ".unreq a_ptr4\n"
                    ".unreq a_ptr5\n"
                    ".unreq c_ptr1\n"
                    ".unreq c_ptr2\n"
                    ".unreq c_ptr3\n"
                    ".unreq c_ptr4\n"
                    ".unreq c_ptr5\n"
                    ".unreq temploadreg0\n"
                    ".unreq temploadreg1\n"
                    ".unreq temploadreg2\n"
                    ".unreq temploadreg3\n"
                    : [a_ptr0] "+r" (a_ptr0), [b_ptr0] "+r" (b_ptr0), [c_ptr0] "+r" (c_ptr0), [loops] "+r" (loops), [oob_rows] "+r" (oob_rows), [odds] "+r" (odds)
                    : [lda] "r" (ldab), [ldc] "r" (ldcb)
                    : "x0", "x1", "x2", "x3", "x4", "x5", "x6", "x7", "x8", "x9", "x10", "x11", "x12", "x13", "v0", "v1", "v2", "v3", "v4", "v5", "v6", "v7", "v8", "v9", "v10", "v11", "v12", "v13", "v14", "v15", "v16", "v17", "v18", "v19", "v20", "v21", "v22", "v23", "v24", "v25", "v26", "v27", "v28", "v29", "v30", "v31", "cc", "memory"
                );
                break;
            case 12:
                __asm __volatile (
                    "a_ptr1 .req X0\n"
                    "a_ptr2 .req X1\n"
                    "a_ptr3 .req X2\n"
                    "a_ptr4 .req X3\n"
                    "a_ptr5 .req X4\n"
                    "c_ptr1 .req X5\n"
                    "c_ptr2 .req X6\n"
                    "c_ptr3 .req X7\n"
                    "c_ptr4 .req X8\n"
                    "c_ptr5 .req X9\n"
                    "temploadreg0 .req X10\n"
                    "temploadreg1 .req X11\n"
                    "temploadreg2 .req X12\n"
                    "temploadreg3 .req X13\n"
                    "add a_ptr1, %[a_ptr0], %[lda]\n"
                    "add c_ptr1, %[c_ptr0], %[ldc]\n"
                    "add a_ptr2, a_ptr1, %[lda]\n"
                    "add c_ptr2, c_ptr1, %[ldc]\n"
                    "add a_ptr3, a_ptr2, %[lda]\n"
                    "add c_ptr3, c_ptr2, %[ldc]\n"
                    "add a_ptr4, a_ptr3, %[lda]\n"
                    "add c_ptr4, c_ptr3, %[ldc]\n"
                    "add a_ptr5, a_ptr4, %[lda]\n"
                    "add c_ptr5, c_ptr4, %[ldc]\n"
                    "cbz %[oob_rows], 1f\n"
                    "subs %[oob_rows], %[oob_rows], #0x1\n"
                    "add c_ptr5, %[c_ptr0], #0x0\n"
                    "add a_ptr5, %[a_ptr0], #0x0\n"
                    "b.eq 1f\n"
                    "subs %[oob_rows], %[oob_rows], #0x1\n"
                    "add c_ptr4, %[c_ptr0], #0x0\n"
                    "add a_ptr4, %[a_ptr0], #0x0\n"
                    "b.eq 1f\n"
                    "subs %[oob_rows], %[oob_rows], #0x1\n"
                    "add c_ptr3, %[c_ptr0], #0x0\n"
                    "add a_ptr3, %[a_ptr0], #0x0\n"
                    "b.eq 1f\n"
                    "subs %[oob_rows], %[oob_rows], #0x1\n"
                    "add c_ptr2, %[c_ptr0], #0x0\n"
                    "add a_ptr2, %[a_ptr0], #0x0\n"
                    "b.eq 1f\n"
                    "subs %[oob_rows], %[oob_rows], #0x1\n"
                    "add c_ptr1, %[c_ptr0], #0x0\n"
                    "add a_ptr1, %[a_ptr0], #0x0\n"
                    "1:\n"
                    "cbnz %[odds], 2f\n"
                    "ldr q0, [%[a_ptr0]], #0x10\n"
                    "ldr q3, [a_ptr1], #0x10\n"
                    "ldr q6, [a_ptr2], #0x10\n"
                    "ldr q9, [a_ptr3], #0x10\n"
                    "ldr q12, [a_ptr4], #0x10\n"
                    "ldr q15, [a_ptr5], #0x10\n"
                    "ldr q1, [%[a_ptr0]], #0x10\n"
                    "ldr q4, [a_ptr1], #0x10\n"
                    "ldr q7, [a_ptr2], #0x10\n"
                    "ldr q10, [a_ptr3], #0x10\n"
                    "ldr q13, [a_ptr4], #0x10\n"
                    "ldr q16, [a_ptr5], #0x10\n"
                    "ldr q2, [%[a_ptr0]]\n"
                    "ldr q5, [a_ptr1]\n"
                    "ldr q8, [a_ptr2]\n"
                    "ldr q11, [a_ptr3]\n"
                    "ldr q14, [a_ptr4]\n"
                    "ldr q17, [a_ptr5]\n"
                    "b 3f\n"
                    "2:\n"
                    "ldr q0, [%[a_ptr0]], #0x10\n"
                    "subs %[odds], %[odds], #0x1\n"
                    "ldr q3, [a_ptr1], #0x10\n"
                    "ldr q6, [a_ptr2], #0x10\n"
                    "ldr q9, [a_ptr3], #0x10\n"
                    "ldr q12, [a_ptr4], #0x10\n"
                    "ldr q15, [a_ptr5], #0x10\n"
                    "ldr q1, [%[a_ptr0]], #0x10\n"
                    "ldr q4, [a_ptr1], #0x10\n"
                    "ldr q7, [a_ptr2], #0x10\n"
                    "ldr q10, [a_ptr3], #0x10\n"
                    "ldr d2, [%[a_ptr0]], #0x8\n"
                    "ldr q13, [a_ptr4], #0x10\n"
                    "ldr d5, [a_ptr1], #0x8\n"
                    "ldr q16, [a_ptr5], #0x10\n"
                    "ldr d8, [a_ptr2], #0x8\n"
                    "ldr d11, [a_ptr3], #0x8\n"
                    "ldr d14, [a_ptr4], #0x8\n"
                    "ldr d17, [a_ptr5], #0x8\n"
                    "ld1 {v2.s}[2], [%[a_ptr0]], #4\n"
                    "ld1 {v5.s}[2], [a_ptr1], #4\n"
                    "ld1 {v8.s}[2], [a_ptr2], #4\n"
                    "ld1 {v11.s}[2], [a_ptr3], #4\n"
                    "ld1 {v14.s}[2], [a_ptr4], #4\n"
                    "ld1 {v17.s}[2], [a_ptr5], #4\n"
                    "b.ne 4f\n"
                    "ld1 {v2.b}[12], [%[a_ptr0]]\n"
                    "ld1 {v5.b}[12], [a_ptr1]\n"
                    "ld1 {v8.b}[12], [a_ptr2]\n"
                    "ld1 {v11.b}[12], [a_ptr3]\n"
                    "ld1 {v14.b}[12], [a_ptr4]\n"
                    "ld1 {v17.b}[12], [a_ptr5]\n"
                    "b 3f\n"
                    "4:\n"
                    "ld1 {v2.h}[6], [%[a_ptr0]], #2\n"
                    "ld1 {v5.h}[6], [a_ptr1], #2\n"
                    "ld1 {v8.h}[6], [a_ptr2], #2\n"
                    "ld1 {v11.h}[6], [a_ptr3], #2\n"
                    "ld1 {v14.h}[6], [a_ptr4], #2\n"
                    "ld1 {v17.h}[6], [a_ptr5], #2\n"
                    "subs %[odds], %[odds], #0x1\n"
                    "b.ne 5f\n"
                    "b 3f\n"
                    "5:\n"
                    "ld1 {v2.b}[14], [%[a_ptr0]]\n"
                    "ld1 {v5.b}[14], [a_ptr1]\n"
                    "ld1 {v8.b}[14], [a_ptr2]\n"
                    "ld1 {v11.b}[14], [a_ptr3]\n"
                    "ld1 {v14.b}[14], [a_ptr4]\n"
                    "ld1 {v17.b}[14], [a_ptr5]\n"
                    "3:\n"
                    "ldr q18, [%[b_ptr0]]\n"
                    "prfm PLDL1KEEP, [a_ptr5, #0x40]\n"
                    "ldr q19, [%[b_ptr0], #0x10]\n"
                    "prfm PLDL1KEEP, [a_ptr5, #0x80]\n"
                    "ldr q20, [%[b_ptr0], #0x20]\n"
                    "prfm PLDL1KEEP, [a_ptr5, #0xc0]\n"
                    "ldr q21, [%[b_ptr0], #0x30]\n"
                    "prfm PLDL1KEEP, [a_ptr5, #0x100]\n"
                    "ldr q22, [%[b_ptr0], #0x40]\n"
                    "prfm PLDL1KEEP, [a_ptr5, #0x140]\n"
                    "ldr q23, [%[b_ptr0], #0x50]\n"
                    "prfm PLDL1KEEP, [a_ptr5, #0x180]\n"
                    "ldr q24, [%[b_ptr0], #0x60]\n"
                    "ldr q25, [%[b_ptr0], #0x70]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x80\n"
                    "cbz %[loops], 6f\n"
                    "movi v26.4s, #0\n"
                    "subs %[loops], %[loops], #0x1\n"
                    "movi v27.4s, #0\n"
                    "movi v28.4s, #0\n"
                    "movi v29.4s, #0\n"
                    "movi v30.4s, #0\n"
                    "movi v31.4s, #0\n"
                    ".inst 0x6f80e25a // udot v26.4s, v18.16b, v0.4b[0]\n"
                    ".inst 0x6f83e25b // udot v27.4s, v18.16b, v3.4b[0]\n"
                    ".inst 0x6f86e25c // udot v28.4s, v18.16b, v6.4b[0]\n"
                    ".inst 0x6f89e25d // udot v29.4s, v18.16b, v9.4b[0]\n"
                    ".inst 0x6f8ce25e // udot v30.4s, v18.16b, v12.4b[0]\n"
                    ".inst 0x6f8fe25f // udot v31.4s, v18.16b, v15.4b[0]\n"
                    "ldr q18, [%[b_ptr0]]\n"
                    ".inst 0x6fa0e27a // udot v26.4s, v19.16b, v0.4b[1]\n"
                    ".inst 0x6fa3e27b // udot v27.4s, v19.16b, v3.4b[1]\n"
                    ".inst 0x6fa6e27c // udot v28.4s, v19.16b, v6.4b[1]\n"
                    ".inst 0x6fa9e27d // udot v29.4s, v19.16b, v9.4b[1]\n"
                    ".inst 0x6face27e // udot v30.4s, v19.16b, v12.4b[1]\n"
                    ".inst 0x6fafe27f // udot v31.4s, v19.16b, v15.4b[1]\n"
                    "ldr q19, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f80ea9a // udot v26.4s, v20.16b, v0.4b[2]\n"
                    ".inst 0x6f83ea9b // udot v27.4s, v20.16b, v3.4b[2]\n"
                    ".inst 0x6f86ea9c // udot v28.4s, v20.16b, v6.4b[2]\n"
                    ".inst 0x6f89ea9d // udot v29.4s, v20.16b, v9.4b[2]\n"
                    ".inst 0x6f8cea9e // udot v30.4s, v20.16b, v12.4b[2]\n"
                    ".inst 0x6f8fea9f // udot v31.4s, v20.16b, v15.4b[2]\n"
                    "ldr q20, [%[b_ptr0], #0x20]\n"
                    ".inst 0x6fa0eaba // udot v26.4s, v21.16b, v0.4b[3]\n"
                    ".inst 0x6fa3eabb // udot v27.4s, v21.16b, v3.4b[3]\n"
                    ".inst 0x6fa6eabc // udot v28.4s, v21.16b, v6.4b[3]\n"
                    ".inst 0x6fa9eabd // udot v29.4s, v21.16b, v9.4b[3]\n"
                    ".inst 0x6faceabe // udot v30.4s, v21.16b, v12.4b[3]\n"
                    ".inst 0x6fafeabf // udot v31.4s, v21.16b, v15.4b[3]\n"
                    "ldr q21, [%[b_ptr0], #0x30]\n"
                    ".inst 0x6f81e2da // udot v26.4s, v22.16b, v1.4b[0]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x40\n"
                    ".inst 0x6f84e2db // udot v27.4s, v22.16b, v4.4b[0]\n"
                    ".inst 0x6f87e2dc // udot v28.4s, v22.16b, v7.4b[0]\n"
                    ".inst 0x6f8ae2dd // udot v29.4s, v22.16b, v10.4b[0]\n"
                    ".inst 0x6f8de2de // udot v30.4s, v22.16b, v13.4b[0]\n"
                    ".inst 0x6f90e2df // udot v31.4s, v22.16b, v16.4b[0]\n"
                    ".inst 0x6fa1e2fa // udot v26.4s, v23.16b, v1.4b[1]\n"
                    ".inst 0x6fa4e2fb // udot v27.4s, v23.16b, v4.4b[1]\n"
                    ".inst 0x6fa7e2fc // udot v28.4s, v23.16b, v7.4b[1]\n"
                    ".inst 0x6faae2fd // udot v29.4s, v23.16b, v10.4b[1]\n"
                    ".inst 0x6fade2fe // udot v30.4s, v23.16b, v13.4b[1]\n"
                    ".inst 0x6fb0e2ff // udot v31.4s, v23.16b, v16.4b[1]\n"
                    ".inst 0x6f81eb1a // udot v26.4s, v24.16b, v1.4b[2]\n"
                    ".inst 0x6f84eb1b // udot v27.4s, v24.16b, v4.4b[2]\n"
                    ".inst 0x6f87eb1c // udot v28.4s, v24.16b, v7.4b[2]\n"
                    ".inst 0x6f8aeb1d // udot v29.4s, v24.16b, v10.4b[2]\n"
                    ".inst 0x6f8deb1e // udot v30.4s, v24.16b, v13.4b[2]\n"
                    ".inst 0x6f90eb1f // udot v31.4s, v24.16b, v16.4b[2]\n"
                    ".inst 0x6fa1eb3a // udot v26.4s, v25.16b, v1.4b[3]\n"
                    ".inst 0x6fa4eb3b // udot v27.4s, v25.16b, v4.4b[3]\n"
                    ".inst 0x6fa7eb3c // udot v28.4s, v25.16b, v7.4b[3]\n"
                    ".inst 0x6faaeb3d // udot v29.4s, v25.16b, v10.4b[3]\n"
                    ".inst 0x6fadeb3e // udot v30.4s, v25.16b, v13.4b[3]\n"
                    ".inst 0x6fb0eb3f // udot v31.4s, v25.16b, v16.4b[3]\n"
                    ".inst 0x6f82e25a // udot v26.4s, v18.16b, v2.4b[0]\n"
                    ".inst 0x6f85e25b // udot v27.4s, v18.16b, v5.4b[0]\n"
                    ".inst 0x6f88e25c // udot v28.4s, v18.16b, v8.4b[0]\n"
                    ".inst 0x6f8be25d // udot v29.4s, v18.16b, v11.4b[0]\n"
                    ".inst 0x6f8ee25e // udot v30.4s, v18.16b, v14.4b[0]\n"
                    ".inst 0x6f91e25f // udot v31.4s, v18.16b, v17.4b[0]\n"
                    ".inst 0x6fa2e27a // udot v26.4s, v19.16b, v2.4b[1]\n"
                    ".inst 0x6fa5e27b // udot v27.4s, v19.16b, v5.4b[1]\n"
                    ".inst 0x6fa8e27c // udot v28.4s, v19.16b, v8.4b[1]\n"
                    ".inst 0x6fabe27d // udot v29.4s, v19.16b, v11.4b[1]\n"
                    ".inst 0x6faee27e // udot v30.4s, v19.16b, v14.4b[1]\n"
                    ".inst 0x6fb1e27f // udot v31.4s, v19.16b, v17.4b[1]\n"
                    ".inst 0x6f82ea9a // udot v26.4s, v20.16b, v2.4b[2]\n"
                    ".inst 0x6f85ea9b // udot v27.4s, v20.16b, v5.4b[2]\n"
                    ".inst 0x6f88ea9c // udot v28.4s, v20.16b, v8.4b[2]\n"
                    ".inst 0x6f8bea9d // udot v29.4s, v20.16b, v11.4b[2]\n"
                    ".inst 0x6f8eea9e // udot v30.4s, v20.16b, v14.4b[2]\n"
                    ".inst 0x6f91ea9f // udot v31.4s, v20.16b, v17.4b[2]\n"
                    ".inst 0x6fa2eaba // udot v26.4s, v21.16b, v2.4b[3]\n"
                    ".inst 0x6fa5eabb // udot v27.4s, v21.16b, v5.4b[3]\n"
                    ".inst 0x6fa8eabc // udot v28.4s, v21.16b, v8.4b[3]\n"
                    ".inst 0x6fabeabd // udot v29.4s, v21.16b, v11.4b[3]\n"
                    ".inst 0x6faeeabe // udot v30.4s, v21.16b, v14.4b[3]\n"
                    ".inst 0x6fb1eabf // udot v31.4s, v21.16b, v17.4b[3]\n"
                    "b.eq 7f\n"
                    "8:\n"
                    "str q26, [%[c_ptr0]]\n"
                    "subs %[loops], %[loops], #0x1\n"
                    "movi v26.4s, #0\n"
                    "ldr d18, [%[b_ptr0]]\n"
                    "ldr temploadreg2, [%[b_ptr0], #0x8]\n"
                    "add %[c_ptr0], %[c_ptr0], #0x10\n"
                    "str q27, [c_ptr1]\n"
                    "add c_ptr1, c_ptr1, #0x10\n"
                    "movi v27.4s, #0\n"
                    "ldr d19, [%[b_ptr0], #0x10]\n"
                    "ldr temploadreg3, [%[b_ptr0], #0x18]\n"
                    "prfm PSTL1KEEP, [%[c_ptr0], #0x40]\n"
                    "str q28, [c_ptr2]\n"
                    "add c_ptr2, c_ptr2, #0x10\n"
                    "movi v28.4s, #0\n"
                    "ldr d20, [%[b_ptr0], #0x20]\n"
                    "ldr temploadreg0, [%[b_ptr0], #0x28]\n"
                    "prfm PSTL1KEEP, [c_ptr1, #0x40]\n"
                    "str q29, [c_ptr3]\n"
                    "add c_ptr3, c_ptr3, #0x10\n"
                    "movi v29.4s, #0\n"
                    "ldr d21, [%[b_ptr0], #0x30]\n"
                    "ldr temploadreg1, [%[b_ptr0], #0x38]\n"
                    "prfm PSTL1KEEP, [c_ptr2, #0x40]\n"
                    "str q30, [c_ptr4]\n"
                    "add c_ptr4, c_ptr4, #0x10\n"
                    "movi v30.4s, #0\n"
                    "ldr d22, [%[b_ptr0], #0x40]\n"
                    "ins v18.d[1], temploadreg2\n"
                    "prfm PSTL1KEEP, [c_ptr3, #0x40]\n"
                    "str q31, [c_ptr5]\n"
                    "add c_ptr5, c_ptr5, #0x10\n"
                    "movi v31.4s, #0\n"
                    "ldr temploadreg2, [%[b_ptr0], #0x48]\n"
                    ".inst 0x6f80e25a // udot v26.4s, v18.16b, v0.4b[0]\n"
                    "ldr d23, [%[b_ptr0], #0x50]\n"
                    ".inst 0x6f83e25b // udot v27.4s, v18.16b, v3.4b[0]\n"
                    "ins v19.d[1], temploadreg3\n"
                    ".inst 0x6f86e25c // udot v28.4s, v18.16b, v6.4b[0]\n"
                    "ldr temploadreg3, [%[b_ptr0], #0x58]\n"
                    ".inst 0x6f89e25d // udot v29.4s, v18.16b, v9.4b[0]\n"
                    "ldr d24, [%[b_ptr0], #0x60]\n"
                    ".inst 0x6f8ce25e // udot v30.4s, v18.16b, v12.4b[0]\n"
                    "ins v20.d[1], temploadreg0\n"
                    ".inst 0x6f8fe25f // udot v31.4s, v18.16b, v15.4b[0]\n"
                    "ldr temploadreg0, [%[b_ptr0], #0x68]\n"
                    ".inst 0x6fa0e27a // udot v26.4s, v19.16b, v0.4b[1]\n"
                    "ldr d25, [%[b_ptr0], #0x70]\n"
                    ".inst 0x6fa3e27b // udot v27.4s, v19.16b, v3.4b[1]\n"
                    "ins v21.d[1], temploadreg1\n"
                    ".inst 0x6fa6e27c // udot v28.4s, v19.16b, v6.4b[1]\n"
                    "ldr temploadreg1, [%[b_ptr0], #0x78]\n"
                    ".inst 0x6fa9e27d // udot v29.4s, v19.16b, v9.4b[1]\n"
                    "ins v22.d[1], temploadreg2\n"
                    ".inst 0x6face27e // udot v30.4s, v19.16b, v12.4b[1]\n"
                    "ins v23.d[1], temploadreg3\n"
                    ".inst 0x6fafe27f // udot v31.4s, v19.16b, v15.4b[1]\n"
                    "ins v24.d[1], temploadreg0\n"
                    ".inst 0x6f80ea9a // udot v26.4s, v20.16b, v0.4b[2]\n"
                    "ins v25.d[1], temploadreg1\n"
                    ".inst 0x6f83ea9b // udot v27.4s, v20.16b, v3.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x80\n"
                    ".inst 0x6f86ea9c // udot v28.4s, v20.16b, v6.4b[2]\n"
                    "ldr d18, [%[b_ptr0]]\n"
                    ".inst 0x6f89ea9d // udot v29.4s, v20.16b, v9.4b[2]\n"
                    "ldr temploadreg2, [%[b_ptr0], #0x8]\n"
                    ".inst 0x6f8cea9e // udot v30.4s, v20.16b, v12.4b[2]\n"
                    "ldr d19, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f8fea9f // udot v31.4s, v20.16b, v15.4b[2]\n"
                    "ldr temploadreg3, [%[b_ptr0], #0x18]\n"
                    ".inst 0x6fa0eaba // udot v26.4s, v21.16b, v0.4b[3]\n"
                    "ldr d20, [%[b_ptr0], #0x20]\n"
                    ".inst 0x6fa3eabb // udot v27.4s, v21.16b, v3.4b[3]\n"
                    "ldr temploadreg0, [%[b_ptr0], #0x28]\n"
                    ".inst 0x6fa6eabc // udot v28.4s, v21.16b, v6.4b[3]\n"
                    "ldr temploadreg1, [%[b_ptr0], #0x38]\n"
                    ".inst 0x6fa9eabd // udot v29.4s, v21.16b, v9.4b[3]\n"
                    "ins v18.d[1], temploadreg2\n"
                    ".inst 0x6faceabe // udot v30.4s, v21.16b, v12.4b[3]\n"
                    "ins v19.d[1], temploadreg3\n"
                    ".inst 0x6fafeabf // udot v31.4s, v21.16b, v15.4b[3]\n"
                    "ldr d21, [%[b_ptr0], #0x30]\n"
                    ".inst 0x6f81e2da // udot v26.4s, v22.16b, v1.4b[0]\n"
                    "ins v20.d[1], temploadreg0\n"
                    ".inst 0x6f84e2db // udot v27.4s, v22.16b, v4.4b[0]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x40\n"
                    ".inst 0x6f87e2dc // udot v28.4s, v22.16b, v7.4b[0]\n"
                    "ins v21.d[1], temploadreg1\n"
                    ".inst 0x6f8ae2dd // udot v29.4s, v22.16b, v10.4b[0]\n"
                    "prfm PSTL1KEEP, [c_ptr4, #0x40]\n"
                    ".inst 0x6f8de2de // udot v30.4s, v22.16b, v13.4b[0]\n"
                    "prfm PSTL1KEEP, [c_ptr5, #0x40]\n"
                    ".inst 0x6f90e2df // udot v31.4s, v22.16b, v16.4b[0]\n"
                    ".inst 0x6fa1e2fa // udot v26.4s, v23.16b, v1.4b[1]\n"
                    ".inst 0x6fa4e2fb // udot v27.4s, v23.16b, v4.4b[1]\n"
                    ".inst 0x6fa7e2fc // udot v28.4s, v23.16b, v7.4b[1]\n"
                    ".inst 0x6faae2fd // udot v29.4s, v23.16b, v10.4b[1]\n"
                    ".inst 0x6fade2fe // udot v30.4s, v23.16b, v13.4b[1]\n"
                    ".inst 0x6fb0e2ff // udot v31.4s, v23.16b, v16.4b[1]\n"
                    ".inst 0x6f81eb1a // udot v26.4s, v24.16b, v1.4b[2]\n"
                    ".inst 0x6f84eb1b // udot v27.4s, v24.16b, v4.4b[2]\n"
                    ".inst 0x6f87eb1c // udot v28.4s, v24.16b, v7.4b[2]\n"
                    ".inst 0x6f8aeb1d // udot v29.4s, v24.16b, v10.4b[2]\n"
                    ".inst 0x6f8deb1e // udot v30.4s, v24.16b, v13.4b[2]\n"
                    ".inst 0x6f90eb1f // udot v31.4s, v24.16b, v16.4b[2]\n"
                    ".inst 0x6fa1eb3a // udot v26.4s, v25.16b, v1.4b[3]\n"
                    ".inst 0x6fa4eb3b // udot v27.4s, v25.16b, v4.4b[3]\n"
                    ".inst 0x6fa7eb3c // udot v28.4s, v25.16b, v7.4b[3]\n"
                    ".inst 0x6faaeb3d // udot v29.4s, v25.16b, v10.4b[3]\n"
                    ".inst 0x6fadeb3e // udot v30.4s, v25.16b, v13.4b[3]\n"
                    ".inst 0x6fb0eb3f // udot v31.4s, v25.16b, v16.4b[3]\n"
                    ".inst 0x6f82e25a // udot v26.4s, v18.16b, v2.4b[0]\n"
                    ".inst 0x6f85e25b // udot v27.4s, v18.16b, v5.4b[0]\n"
                    ".inst 0x6f88e25c // udot v28.4s, v18.16b, v8.4b[0]\n"
                    ".inst 0x6f8be25d // udot v29.4s, v18.16b, v11.4b[0]\n"
                    ".inst 0x6f8ee25e // udot v30.4s, v18.16b, v14.4b[0]\n"
                    ".inst 0x6f91e25f // udot v31.4s, v18.16b, v17.4b[0]\n"
                    ".inst 0x6fa2e27a // udot v26.4s, v19.16b, v2.4b[1]\n"
                    ".inst 0x6fa5e27b // udot v27.4s, v19.16b, v5.4b[1]\n"
                    ".inst 0x6fa8e27c // udot v28.4s, v19.16b, v8.4b[1]\n"
                    ".inst 0x6fabe27d // udot v29.4s, v19.16b, v11.4b[1]\n"
                    ".inst 0x6faee27e // udot v30.4s, v19.16b, v14.4b[1]\n"
                    ".inst 0x6fb1e27f // udot v31.4s, v19.16b, v17.4b[1]\n"
                    ".inst 0x6f82ea9a // udot v26.4s, v20.16b, v2.4b[2]\n"
                    ".inst 0x6f85ea9b // udot v27.4s, v20.16b, v5.4b[2]\n"
                    ".inst 0x6f88ea9c // udot v28.4s, v20.16b, v8.4b[2]\n"
                    ".inst 0x6f8bea9d // udot v29.4s, v20.16b, v11.4b[2]\n"
                    ".inst 0x6f8eea9e // udot v30.4s, v20.16b, v14.4b[2]\n"
                    ".inst 0x6f91ea9f // udot v31.4s, v20.16b, v17.4b[2]\n"
                    ".inst 0x6fa2eaba // udot v26.4s, v21.16b, v2.4b[3]\n"
                    ".inst 0x6fa5eabb // udot v27.4s, v21.16b, v5.4b[3]\n"
                    ".inst 0x6fa8eabc // udot v28.4s, v21.16b, v8.4b[3]\n"
                    ".inst 0x6fabeabd // udot v29.4s, v21.16b, v11.4b[3]\n"
                    ".inst 0x6faeeabe // udot v30.4s, v21.16b, v14.4b[3]\n"
                    ".inst 0x6fb1eabf // udot v31.4s, v21.16b, v17.4b[3]\n"
                    "b.ne 8b\n"
                    "7:\n"
                    "str q26, [%[c_ptr0]]\n"
                    "add %[c_ptr0], %[c_ptr0], #0x10\n"
                    "movi v26.4s, #0\n"
                    "ldr q18, [%[b_ptr0]]\n"
                    "ldr q19, [%[b_ptr0], #0x10]\n"
                    "str q27, [c_ptr1]\n"
                    "add c_ptr1, c_ptr1, #0x10\n"
                    "movi v27.4s, #0\n"
                    "ldr q20, [%[b_ptr0], #0x20]\n"
                    ".inst 0x6f80e25a // udot v26.4s, v18.16b, v0.4b[0]\n"
                    "str q28, [c_ptr2]\n"
                    "movi v28.4s, #0\n"
                    "ldr q21, [%[b_ptr0], #0x30]\n"
                    "ldr q22, [%[b_ptr0], #0x40]\n"
                    "add c_ptr2, c_ptr2, #0x10\n"
                    ".inst 0x6f83e25b // udot v27.4s, v18.16b, v3.4b[0]\n"
                    "str q29, [c_ptr3]\n"
                    "movi v29.4s, #0\n"
                    "ldr q23, [%[b_ptr0], #0x50]\n"
                    ".inst 0x6f86e25c // udot v28.4s, v18.16b, v6.4b[0]\n"
                    "ldr q24, [%[b_ptr0], #0x60]\n"
                    ".inst 0x6fa0e27a // udot v26.4s, v19.16b, v0.4b[1]\n"
                    "str q30, [c_ptr4]\n"
                    "movi v30.4s, #0\n"
                    "ldr q25, [%[b_ptr0], #0x70]\n"
                    ".inst 0x6f89e25d // udot v29.4s, v18.16b, v9.4b[0]\n"
                    "add c_ptr3, c_ptr3, #0x10\n"
                    ".inst 0x6fa3e27b // udot v27.4s, v19.16b, v3.4b[1]\n"
                    "str q31, [c_ptr5]\n"
                    "movi v31.4s, #0\n"
                    "add c_ptr4, c_ptr4, #0x10\n"
                    ".inst 0x6f8ce25e // udot v30.4s, v18.16b, v12.4b[0]\n"
                    "add c_ptr5, c_ptr5, #0x10\n"
                    ".inst 0x6f8fe25f // udot v31.4s, v18.16b, v15.4b[0]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x80\n"
                    ".inst 0x6fa6e27c // udot v28.4s, v19.16b, v6.4b[1]\n"
                    "ldr q18, [%[b_ptr0]]\n"
                    ".inst 0x6fa9e27d // udot v29.4s, v19.16b, v9.4b[1]\n"
                    ".inst 0x6face27e // udot v30.4s, v19.16b, v12.4b[1]\n"
                    ".inst 0x6fafe27f // udot v31.4s, v19.16b, v15.4b[1]\n"
                    "ldr q19, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f80ea9a // udot v26.4s, v20.16b, v0.4b[2]\n"
                    ".inst 0x6f83ea9b // udot v27.4s, v20.16b, v3.4b[2]\n"
                    ".inst 0x6f86ea9c // udot v28.4s, v20.16b, v6.4b[2]\n"
                    ".inst 0x6f89ea9d // udot v29.4s, v20.16b, v9.4b[2]\n"
                    ".inst 0x6f8cea9e // udot v30.4s, v20.16b, v12.4b[2]\n"
                    ".inst 0x6f8fea9f // udot v31.4s, v20.16b, v15.4b[2]\n"
                    "ldr q20, [%[b_ptr0], #0x20]\n"
                    ".inst 0x6fa0eaba // udot v26.4s, v21.16b, v0.4b[3]\n"
                    ".inst 0x6fa3eabb // udot v27.4s, v21.16b, v3.4b[3]\n"
                    ".inst 0x6fa6eabc // udot v28.4s, v21.16b, v6.4b[3]\n"
                    ".inst 0x6fa9eabd // udot v29.4s, v21.16b, v9.4b[3]\n"
                    ".inst 0x6faceabe // udot v30.4s, v21.16b, v12.4b[3]\n"
                    ".inst 0x6fafeabf // udot v31.4s, v21.16b, v15.4b[3]\n"
                    "ldr q21, [%[b_ptr0], #0x30]\n"
                    ".inst 0x6f81e2da // udot v26.4s, v22.16b, v1.4b[0]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x40\n"
                    ".inst 0x6f84e2db // udot v27.4s, v22.16b, v4.4b[0]\n"
                    ".inst 0x6f87e2dc // udot v28.4s, v22.16b, v7.4b[0]\n"
                    ".inst 0x6f8ae2dd // udot v29.4s, v22.16b, v10.4b[0]\n"
                    ".inst 0x6f8de2de // udot v30.4s, v22.16b, v13.4b[0]\n"
                    ".inst 0x6f90e2df // udot v31.4s, v22.16b, v16.4b[0]\n"
                    ".inst 0x6fa1e2fa // udot v26.4s, v23.16b, v1.4b[1]\n"
                    ".inst 0x6fa4e2fb // udot v27.4s, v23.16b, v4.4b[1]\n"
                    ".inst 0x6fa7e2fc // udot v28.4s, v23.16b, v7.4b[1]\n"
                    ".inst 0x6faae2fd // udot v29.4s, v23.16b, v10.4b[1]\n"
                    ".inst 0x6fade2fe // udot v30.4s, v23.16b, v13.4b[1]\n"
                    ".inst 0x6fb0e2ff // udot v31.4s, v23.16b, v16.4b[1]\n"
                    ".inst 0x6f81eb1a // udot v26.4s, v24.16b, v1.4b[2]\n"
                    ".inst 0x6f84eb1b // udot v27.4s, v24.16b, v4.4b[2]\n"
                    ".inst 0x6f87eb1c // udot v28.4s, v24.16b, v7.4b[2]\n"
                    ".inst 0x6f8aeb1d // udot v29.4s, v24.16b, v10.4b[2]\n"
                    ".inst 0x6f8deb1e // udot v30.4s, v24.16b, v13.4b[2]\n"
                    ".inst 0x6f90eb1f // udot v31.4s, v24.16b, v16.4b[2]\n"
                    ".inst 0x6fa1eb3a // udot v26.4s, v25.16b, v1.4b[3]\n"
                    ".inst 0x6fa4eb3b // udot v27.4s, v25.16b, v4.4b[3]\n"
                    ".inst 0x6fa7eb3c // udot v28.4s, v25.16b, v7.4b[3]\n"
                    ".inst 0x6faaeb3d // udot v29.4s, v25.16b, v10.4b[3]\n"
                    ".inst 0x6fadeb3e // udot v30.4s, v25.16b, v13.4b[3]\n"
                    ".inst 0x6fb0eb3f // udot v31.4s, v25.16b, v16.4b[3]\n"
                    ".inst 0x6f82e25a // udot v26.4s, v18.16b, v2.4b[0]\n"
                    ".inst 0x6f85e25b // udot v27.4s, v18.16b, v5.4b[0]\n"
                    ".inst 0x6f88e25c // udot v28.4s, v18.16b, v8.4b[0]\n"
                    ".inst 0x6f8be25d // udot v29.4s, v18.16b, v11.4b[0]\n"
                    ".inst 0x6f8ee25e // udot v30.4s, v18.16b, v14.4b[0]\n"
                    ".inst 0x6f91e25f // udot v31.4s, v18.16b, v17.4b[0]\n"
                    ".inst 0x6fa2e27a // udot v26.4s, v19.16b, v2.4b[1]\n"
                    ".inst 0x6fa5e27b // udot v27.4s, v19.16b, v5.4b[1]\n"
                    ".inst 0x6fa8e27c // udot v28.4s, v19.16b, v8.4b[1]\n"
                    ".inst 0x6fabe27d // udot v29.4s, v19.16b, v11.4b[1]\n"
                    ".inst 0x6faee27e // udot v30.4s, v19.16b, v14.4b[1]\n"
                    ".inst 0x6fb1e27f // udot v31.4s, v19.16b, v17.4b[1]\n"
                    ".inst 0x6f82ea9a // udot v26.4s, v20.16b, v2.4b[2]\n"
                    ".inst 0x6f85ea9b // udot v27.4s, v20.16b, v5.4b[2]\n"
                    ".inst 0x6f88ea9c // udot v28.4s, v20.16b, v8.4b[2]\n"
                    ".inst 0x6f8bea9d // udot v29.4s, v20.16b, v11.4b[2]\n"
                    ".inst 0x6f8eea9e // udot v30.4s, v20.16b, v14.4b[2]\n"
                    ".inst 0x6f91ea9f // udot v31.4s, v20.16b, v17.4b[2]\n"
                    ".inst 0x6fa2eaba // udot v26.4s, v21.16b, v2.4b[3]\n"
                    ".inst 0x6fa5eabb // udot v27.4s, v21.16b, v5.4b[3]\n"
                    ".inst 0x6fa8eabc // udot v28.4s, v21.16b, v8.4b[3]\n"
                    ".inst 0x6fabeabd // udot v29.4s, v21.16b, v11.4b[3]\n"
                    ".inst 0x6faeeabe // udot v30.4s, v21.16b, v14.4b[3]\n"
                    ".inst 0x6fb1eabf // udot v31.4s, v21.16b, v17.4b[3]\n"
                    "b 9f\n"
                    "6:\n"
                    "movi v26.4s, #0\n"
                    "movi v27.4s, #0\n"
                    "movi v28.4s, #0\n"
                    "movi v29.4s, #0\n"
                    "movi v30.4s, #0\n"
                    "movi v31.4s, #0\n"
                    ".inst 0x6f80e25a // udot v26.4s, v18.16b, v0.4b[0]\n"
                    ".inst 0x6f83e25b // udot v27.4s, v18.16b, v3.4b[0]\n"
                    ".inst 0x6f86e25c // udot v28.4s, v18.16b, v6.4b[0]\n"
                    ".inst 0x6f89e25d // udot v29.4s, v18.16b, v9.4b[0]\n"
                    ".inst 0x6f8ce25e // udot v30.4s, v18.16b, v12.4b[0]\n"
                    ".inst 0x6f8fe25f // udot v31.4s, v18.16b, v15.4b[0]\n"
                    "ldr q18, [%[b_ptr0]]\n"
                    ".inst 0x6fa0e27a // udot v26.4s, v19.16b, v0.4b[1]\n"
                    ".inst 0x6fa3e27b // udot v27.4s, v19.16b, v3.4b[1]\n"
                    ".inst 0x6fa6e27c // udot v28.4s, v19.16b, v6.4b[1]\n"
                    ".inst 0x6fa9e27d // udot v29.4s, v19.16b, v9.4b[1]\n"
                    ".inst 0x6face27e // udot v30.4s, v19.16b, v12.4b[1]\n"
                    ".inst 0x6fafe27f // udot v31.4s, v19.16b, v15.4b[1]\n"
                    "ldr q19, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f80ea9a // udot v26.4s, v20.16b, v0.4b[2]\n"
                    ".inst 0x6f83ea9b // udot v27.4s, v20.16b, v3.4b[2]\n"
                    ".inst 0x6f86ea9c // udot v28.4s, v20.16b, v6.4b[2]\n"
                    ".inst 0x6f89ea9d // udot v29.4s, v20.16b, v9.4b[2]\n"
                    ".inst 0x6f8cea9e // udot v30.4s, v20.16b, v12.4b[2]\n"
                    ".inst 0x6f8fea9f // udot v31.4s, v20.16b, v15.4b[2]\n"
                    "ldr q20, [%[b_ptr0], #0x20]\n"
                    ".inst 0x6fa0eaba // udot v26.4s, v21.16b, v0.4b[3]\n"
                    ".inst 0x6fa3eabb // udot v27.4s, v21.16b, v3.4b[3]\n"
                    ".inst 0x6fa6eabc // udot v28.4s, v21.16b, v6.4b[3]\n"
                    ".inst 0x6fa9eabd // udot v29.4s, v21.16b, v9.4b[3]\n"
                    ".inst 0x6faceabe // udot v30.4s, v21.16b, v12.4b[3]\n"
                    ".inst 0x6fafeabf // udot v31.4s, v21.16b, v15.4b[3]\n"
                    "ldr q21, [%[b_ptr0], #0x30]\n"
                    ".inst 0x6f81e2da // udot v26.4s, v22.16b, v1.4b[0]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x40\n"
                    ".inst 0x6f84e2db // udot v27.4s, v22.16b, v4.4b[0]\n"
                    ".inst 0x6f87e2dc // udot v28.4s, v22.16b, v7.4b[0]\n"
                    ".inst 0x6f8ae2dd // udot v29.4s, v22.16b, v10.4b[0]\n"
                    ".inst 0x6f8de2de // udot v30.4s, v22.16b, v13.4b[0]\n"
                    ".inst 0x6f90e2df // udot v31.4s, v22.16b, v16.4b[0]\n"
                    ".inst 0x6fa1e2fa // udot v26.4s, v23.16b, v1.4b[1]\n"
                    ".inst 0x6fa4e2fb // udot v27.4s, v23.16b, v4.4b[1]\n"
                    ".inst 0x6fa7e2fc // udot v28.4s, v23.16b, v7.4b[1]\n"
                    ".inst 0x6faae2fd // udot v29.4s, v23.16b, v10.4b[1]\n"
                    ".inst 0x6fade2fe // udot v30.4s, v23.16b, v13.4b[1]\n"
                    ".inst 0x6fb0e2ff // udot v31.4s, v23.16b, v16.4b[1]\n"
                    ".inst 0x6f81eb1a // udot v26.4s, v24.16b, v1.4b[2]\n"
                    ".inst 0x6f84eb1b // udot v27.4s, v24.16b, v4.4b[2]\n"
                    ".inst 0x6f87eb1c // udot v28.4s, v24.16b, v7.4b[2]\n"
                    ".inst 0x6f8aeb1d // udot v29.4s, v24.16b, v10.4b[2]\n"
                    ".inst 0x6f8deb1e // udot v30.4s, v24.16b, v13.4b[2]\n"
                    ".inst 0x6f90eb1f // udot v31.4s, v24.16b, v16.4b[2]\n"
                    ".inst 0x6fa1eb3a // udot v26.4s, v25.16b, v1.4b[3]\n"
                    ".inst 0x6fa4eb3b // udot v27.4s, v25.16b, v4.4b[3]\n"
                    ".inst 0x6fa7eb3c // udot v28.4s, v25.16b, v7.4b[3]\n"
                    ".inst 0x6faaeb3d // udot v29.4s, v25.16b, v10.4b[3]\n"
                    ".inst 0x6fadeb3e // udot v30.4s, v25.16b, v13.4b[3]\n"
                    ".inst 0x6fb0eb3f // udot v31.4s, v25.16b, v16.4b[3]\n"
                    ".inst 0x6f82e25a // udot v26.4s, v18.16b, v2.4b[0]\n"
                    ".inst 0x6f85e25b // udot v27.4s, v18.16b, v5.4b[0]\n"
                    ".inst 0x6f88e25c // udot v28.4s, v18.16b, v8.4b[0]\n"
                    ".inst 0x6f8be25d // udot v29.4s, v18.16b, v11.4b[0]\n"
                    ".inst 0x6f8ee25e // udot v30.4s, v18.16b, v14.4b[0]\n"
                    ".inst 0x6f91e25f // udot v31.4s, v18.16b, v17.4b[0]\n"
                    ".inst 0x6fa2e27a // udot v26.4s, v19.16b, v2.4b[1]\n"
                    ".inst 0x6fa5e27b // udot v27.4s, v19.16b, v5.4b[1]\n"
                    ".inst 0x6fa8e27c // udot v28.4s, v19.16b, v8.4b[1]\n"
                    ".inst 0x6fabe27d // udot v29.4s, v19.16b, v11.4b[1]\n"
                    ".inst 0x6faee27e // udot v30.4s, v19.16b, v14.4b[1]\n"
                    ".inst 0x6fb1e27f // udot v31.4s, v19.16b, v17.4b[1]\n"
                    ".inst 0x6f82ea9a // udot v26.4s, v20.16b, v2.4b[2]\n"
                    ".inst 0x6f85ea9b // udot v27.4s, v20.16b, v5.4b[2]\n"
                    ".inst 0x6f88ea9c // udot v28.4s, v20.16b, v8.4b[2]\n"
                    ".inst 0x6f8bea9d // udot v29.4s, v20.16b, v11.4b[2]\n"
                    ".inst 0x6f8eea9e // udot v30.4s, v20.16b, v14.4b[2]\n"
                    ".inst 0x6f91ea9f // udot v31.4s, v20.16b, v17.4b[2]\n"
                    ".inst 0x6fa2eaba // udot v26.4s, v21.16b, v2.4b[3]\n"
                    ".inst 0x6fa5eabb // udot v27.4s, v21.16b, v5.4b[3]\n"
                    ".inst 0x6fa8eabc // udot v28.4s, v21.16b, v8.4b[3]\n"
                    ".inst 0x6fabeabd // udot v29.4s, v21.16b, v11.4b[3]\n"
                    ".inst 0x6faeeabe // udot v30.4s, v21.16b, v14.4b[3]\n"
                    ".inst 0x6fb1eabf // udot v31.4s, v21.16b, v17.4b[3]\n"
                    "9:\n"
                    "str q26, [%[c_ptr0]]\n"
                    "add %[c_ptr0], %[c_ptr0], #0x10\n"
                    "str q27, [c_ptr1]\n"
                    "str q28, [c_ptr2]\n"
                    "str q29, [c_ptr3]\n"
                    "str q30, [c_ptr4]\n"
                    "str q31, [c_ptr5]\n"
                    ".unreq a_ptr1\n"
                    ".unreq a_ptr2\n"
                    ".unreq a_ptr3\n"
                    ".unreq a_ptr4\n"
                    ".unreq a_ptr5\n"
                    ".unreq c_ptr1\n"
                    ".unreq c_ptr2\n"
                    ".unreq c_ptr3\n"
                    ".unreq c_ptr4\n"
                    ".unreq c_ptr5\n"
                    ".unreq temploadreg0\n"
                    ".unreq temploadreg1\n"
                    ".unreq temploadreg2\n"
                    ".unreq temploadreg3\n"
                    : [a_ptr0] "+r" (a_ptr0), [b_ptr0] "+r" (b_ptr0), [c_ptr0] "+r" (c_ptr0), [loops] "+r" (loops), [oob_rows] "+r" (oob_rows), [odds] "+r" (odds)
                    : [lda] "r" (ldab), [ldc] "r" (ldcb)
                    : "x0", "x1", "x2", "x3", "x4", "x5", "x6", "x7", "x8", "x9", "x10", "x11", "x12", "x13", "v0", "v1", "v2", "v3", "v4", "v5", "v6", "v7", "v8", "v9", "v10", "v11", "v12", "v13", "v14", "v15", "v16", "v17", "v18", "v19", "v20", "v21", "v22", "v23", "v24", "v25", "v26", "v27", "v28", "v29", "v30", "v31", "cc", "memory"
                );
                break;
            case 13:
                __asm __volatile (
                    "a_ptr1 .req X0\n"
                    "a_ptr2 .req X1\n"
                    "a_ptr3 .req X2\n"
                    "a_ptr4 .req X3\n"
                    "a_ptr5 .req X4\n"
                    "c_ptr1 .req X5\n"
                    "c_ptr2 .req X6\n"
                    "c_ptr3 .req X7\n"
                    "c_ptr4 .req X8\n"
                    "c_ptr5 .req X9\n"
                    "temploadreg0 .req X10\n"
                    "temploadreg1 .req X11\n"
                    "temploadreg2 .req X12\n"
                    "temploadreg3 .req X13\n"
                    "add a_ptr1, %[a_ptr0], %[lda]\n"
                    "add c_ptr1, %[c_ptr0], %[ldc]\n"
                    "add a_ptr2, a_ptr1, %[lda]\n"
                    "add c_ptr2, c_ptr1, %[ldc]\n"
                    "add a_ptr3, a_ptr2, %[lda]\n"
                    "add c_ptr3, c_ptr2, %[ldc]\n"
                    "add a_ptr4, a_ptr3, %[lda]\n"
                    "add c_ptr4, c_ptr3, %[ldc]\n"
                    "add a_ptr5, a_ptr4, %[lda]\n"
                    "add c_ptr5, c_ptr4, %[ldc]\n"
                    "cbz %[oob_rows], 1f\n"
                    "subs %[oob_rows], %[oob_rows], #0x1\n"
                    "add c_ptr5, %[c_ptr0], #0x0\n"
                    "add a_ptr5, %[a_ptr0], #0x0\n"
                    "b.eq 1f\n"
                    "subs %[oob_rows], %[oob_rows], #0x1\n"
                    "add c_ptr4, %[c_ptr0], #0x0\n"
                    "add a_ptr4, %[a_ptr0], #0x0\n"
                    "b.eq 1f\n"
                    "subs %[oob_rows], %[oob_rows], #0x1\n"
                    "add c_ptr3, %[c_ptr0], #0x0\n"
                    "add a_ptr3, %[a_ptr0], #0x0\n"
                    "b.eq 1f\n"
                    "subs %[oob_rows], %[oob_rows], #0x1\n"
                    "add c_ptr2, %[c_ptr0], #0x0\n"
                    "add a_ptr2, %[a_ptr0], #0x0\n"
                    "b.eq 1f\n"
                    "subs %[oob_rows], %[oob_rows], #0x1\n"
                    "add c_ptr1, %[c_ptr0], #0x0\n"
                    "add a_ptr1, %[a_ptr0], #0x0\n"
                    "1:\n"
                    "cbnz %[odds], 2f\n"
                    "ldr q0, [%[a_ptr0]], #0x10\n"
                    "ldr q4, [a_ptr1], #0x10\n"
                    "ldr q8, [a_ptr2], #0x10\n"
                    "ldr q12, [a_ptr3], #0x10\n"
                    "ldr q16, [a_ptr4], #0x10\n"
                    "ldr q20, [a_ptr5], #0x10\n"
                    "ldr q1, [%[a_ptr0]], #0x10\n"
                    "ldr q5, [a_ptr1], #0x10\n"
                    "ldr q9, [a_ptr2], #0x10\n"
                    "ldr q13, [a_ptr3], #0x10\n"
                    "ldr q17, [a_ptr4], #0x10\n"
                    "ldr q21, [a_ptr5], #0x10\n"
                    "ldr q2, [%[a_ptr0]], #0x10\n"
                    "ldr q6, [a_ptr1], #0x10\n"
                    "ldr q10, [a_ptr2], #0x10\n"
                    "ldr q14, [a_ptr3], #0x10\n"
                    "ldr s3, [%[a_ptr0]]\n"
                    "ldr q18, [a_ptr4], #0x10\n"
                    "ldr s7, [a_ptr1]\n"
                    "ldr q22, [a_ptr5], #0x10\n"
                    "ldr s11, [a_ptr2]\n"
                    "ldr s15, [a_ptr3]\n"
                    "ldr s19, [a_ptr4]\n"
                    "ldr s23, [a_ptr5]\n"
                    "b 3f\n"
                    "2:\n"
                    "ldr q0, [%[a_ptr0]], #0x10\n"
                    "subs %[odds], %[odds], #0x1\n"
                    "ldr q4, [a_ptr1], #0x10\n"
                    "ldr q8, [a_ptr2], #0x10\n"
                    "ldr q12, [a_ptr3], #0x10\n"
                    "ldr q16, [a_ptr4], #0x10\n"
                    "ldr q20, [a_ptr5], #0x10\n"
                    "ldr q1, [%[a_ptr0]], #0x10\n"
                    "ldr q5, [a_ptr1], #0x10\n"
                    "ldr q9, [a_ptr2], #0x10\n"
                    "ldr q13, [a_ptr3], #0x10\n"
                    "ldr q17, [a_ptr4], #0x10\n"
                    "ldr q21, [a_ptr5], #0x10\n"
                    "ldr q2, [%[a_ptr0]], #0x10\n"
                    "ldr q6, [a_ptr1], #0x10\n"
                    "ldr q10, [a_ptr2], #0x10\n"
                    "ldr q14, [a_ptr3], #0x10\n"
                    "ldr q18, [a_ptr4], #0x10\n"
                    "ldr q22, [a_ptr5], #0x10\n"
                    "b.ne 4f\n"
                    "ldr b3, [%[a_ptr0]]\n"
                    "ldr b7, [a_ptr1]\n"
                    "ldr b11, [a_ptr2]\n"
                    "ldr b15, [a_ptr3]\n"
                    "ldr b19, [a_ptr4]\n"
                    "ldr b23, [a_ptr5]\n"
                    "b 3f\n"
                    "4:\n"
                    "ldr h3, [%[a_ptr0]], #0x2\n"
                    "ldr h7, [a_ptr1], #0x2\n"
                    "ldr h11, [a_ptr2], #0x2\n"
                    "ldr h15, [a_ptr3], #0x2\n"
                    "ldr h19, [a_ptr4], #0x2\n"
                    "ldr h23, [a_ptr5], #0x2\n"
                    "subs %[odds], %[odds], #0x1\n"
                    "b.ne 5f\n"
                    "b 3f\n"
                    "5:\n"
                    "ld1 {v3.b}[2], [%[a_ptr0]]\n"
                    "ld1 {v7.b}[2], [a_ptr1]\n"
                    "ld1 {v11.b}[2], [a_ptr2]\n"
                    "ld1 {v15.b}[2], [a_ptr3]\n"
                    "ld1 {v19.b}[2], [a_ptr4]\n"
                    "ld1 {v23.b}[2], [a_ptr5]\n"
                    "3:\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    "prfm PLDL1KEEP, [a_ptr5, #0x40]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    "prfm PLDL1KEEP, [a_ptr5, #0x80]\n"
                    "prfm PLDL1KEEP, [a_ptr5, #0xc0]\n"
                    "prfm PLDL1KEEP, [a_ptr5, #0x100]\n"
                    "prfm PLDL1KEEP, [a_ptr5, #0x140]\n"
                    "prfm PLDL1KEEP, [a_ptr5, #0x180]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    "cbz %[loops], 6f\n"
                    "movi v26.4s, #0\n"
                    "subs %[loops], %[loops], #0x1\n"
                    "movi v27.4s, #0\n"
                    "movi v28.4s, #0\n"
                    "movi v29.4s, #0\n"
                    "movi v30.4s, #0\n"
                    "movi v31.4s, #0\n"
                    ".inst 0x6f80e31a // udot v26.4s, v24.16b, v0.4b[0]\n"
                    ".inst 0x6f84e31b // udot v27.4s, v24.16b, v4.4b[0]\n"
                    ".inst 0x6f88e31c // udot v28.4s, v24.16b, v8.4b[0]\n"
                    ".inst 0x6f8ce31d // udot v29.4s, v24.16b, v12.4b[0]\n"
                    ".inst 0x6f90e31e // udot v30.4s, v24.16b, v16.4b[0]\n"
                    ".inst 0x6f94e31f // udot v31.4s, v24.16b, v20.4b[0]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa0e33a // udot v26.4s, v25.16b, v0.4b[1]\n"
                    ".inst 0x6fa4e33b // udot v27.4s, v25.16b, v4.4b[1]\n"
                    ".inst 0x6fa8e33c // udot v28.4s, v25.16b, v8.4b[1]\n"
                    ".inst 0x6face33d // udot v29.4s, v25.16b, v12.4b[1]\n"
                    ".inst 0x6fb0e33e // udot v30.4s, v25.16b, v16.4b[1]\n"
                    ".inst 0x6fb4e33f // udot v31.4s, v25.16b, v20.4b[1]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f80eb1a // udot v26.4s, v24.16b, v0.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f84eb1b // udot v27.4s, v24.16b, v4.4b[2]\n"
                    ".inst 0x6f88eb1c // udot v28.4s, v24.16b, v8.4b[2]\n"
                    ".inst 0x6f8ceb1d // udot v29.4s, v24.16b, v12.4b[2]\n"
                    ".inst 0x6f90eb1e // udot v30.4s, v24.16b, v16.4b[2]\n"
                    ".inst 0x6f94eb1f // udot v31.4s, v24.16b, v20.4b[2]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa0eb3a // udot v26.4s, v25.16b, v0.4b[3]\n"
                    ".inst 0x6fa4eb3b // udot v27.4s, v25.16b, v4.4b[3]\n"
                    ".inst 0x6fa8eb3c // udot v28.4s, v25.16b, v8.4b[3]\n"
                    ".inst 0x6faceb3d // udot v29.4s, v25.16b, v12.4b[3]\n"
                    ".inst 0x6fb0eb3e // udot v30.4s, v25.16b, v16.4b[3]\n"
                    ".inst 0x6fb4eb3f // udot v31.4s, v25.16b, v20.4b[3]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f81e31a // udot v26.4s, v24.16b, v1.4b[0]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f85e31b // udot v27.4s, v24.16b, v5.4b[0]\n"
                    ".inst 0x6f89e31c // udot v28.4s, v24.16b, v9.4b[0]\n"
                    ".inst 0x6f8de31d // udot v29.4s, v24.16b, v13.4b[0]\n"
                    ".inst 0x6f91e31e // udot v30.4s, v24.16b, v17.4b[0]\n"
                    ".inst 0x6f95e31f // udot v31.4s, v24.16b, v21.4b[0]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa1e33a // udot v26.4s, v25.16b, v1.4b[1]\n"
                    ".inst 0x6fa5e33b // udot v27.4s, v25.16b, v5.4b[1]\n"
                    ".inst 0x6fa9e33c // udot v28.4s, v25.16b, v9.4b[1]\n"
                    ".inst 0x6fade33d // udot v29.4s, v25.16b, v13.4b[1]\n"
                    ".inst 0x6fb1e33e // udot v30.4s, v25.16b, v17.4b[1]\n"
                    ".inst 0x6fb5e33f // udot v31.4s, v25.16b, v21.4b[1]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f81eb1a // udot v26.4s, v24.16b, v1.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f85eb1b // udot v27.4s, v24.16b, v5.4b[2]\n"
                    ".inst 0x6f89eb1c // udot v28.4s, v24.16b, v9.4b[2]\n"
                    ".inst 0x6f8deb1d // udot v29.4s, v24.16b, v13.4b[2]\n"
                    ".inst 0x6f91eb1e // udot v30.4s, v24.16b, v17.4b[2]\n"
                    ".inst 0x6f95eb1f // udot v31.4s, v24.16b, v21.4b[2]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa1eb3a // udot v26.4s, v25.16b, v1.4b[3]\n"
                    ".inst 0x6fa5eb3b // udot v27.4s, v25.16b, v5.4b[3]\n"
                    ".inst 0x6fa9eb3c // udot v28.4s, v25.16b, v9.4b[3]\n"
                    ".inst 0x6fadeb3d // udot v29.4s, v25.16b, v13.4b[3]\n"
                    ".inst 0x6fb1eb3e // udot v30.4s, v25.16b, v17.4b[3]\n"
                    ".inst 0x6fb5eb3f // udot v31.4s, v25.16b, v21.4b[3]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f82e31a // udot v26.4s, v24.16b, v2.4b[0]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f86e31b // udot v27.4s, v24.16b, v6.4b[0]\n"
                    ".inst 0x6f8ae31c // udot v28.4s, v24.16b, v10.4b[0]\n"
                    ".inst 0x6f8ee31d // udot v29.4s, v24.16b, v14.4b[0]\n"
                    ".inst 0x6f92e31e // udot v30.4s, v24.16b, v18.4b[0]\n"
                    ".inst 0x6f96e31f // udot v31.4s, v24.16b, v22.4b[0]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa2e33a // udot v26.4s, v25.16b, v2.4b[1]\n"
                    ".inst 0x6fa6e33b // udot v27.4s, v25.16b, v6.4b[1]\n"
                    ".inst 0x6faae33c // udot v28.4s, v25.16b, v10.4b[1]\n"
                    ".inst 0x6faee33d // udot v29.4s, v25.16b, v14.4b[1]\n"
                    ".inst 0x6fb2e33e // udot v30.4s, v25.16b, v18.4b[1]\n"
                    ".inst 0x6fb6e33f // udot v31.4s, v25.16b, v22.4b[1]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f82eb1a // udot v26.4s, v24.16b, v2.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f86eb1b // udot v27.4s, v24.16b, v6.4b[2]\n"
                    ".inst 0x6f8aeb1c // udot v28.4s, v24.16b, v10.4b[2]\n"
                    ".inst 0x6f8eeb1d // udot v29.4s, v24.16b, v14.4b[2]\n"
                    ".inst 0x6f92eb1e // udot v30.4s, v24.16b, v18.4b[2]\n"
                    ".inst 0x6f96eb1f // udot v31.4s, v24.16b, v22.4b[2]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa2eb3a // udot v26.4s, v25.16b, v2.4b[3]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x10\n"
                    ".inst 0x6fa6eb3b // udot v27.4s, v25.16b, v6.4b[3]\n"
                    ".inst 0x6faaeb3c // udot v28.4s, v25.16b, v10.4b[3]\n"
                    ".inst 0x6faeeb3d // udot v29.4s, v25.16b, v14.4b[3]\n"
                    ".inst 0x6fb2eb3e // udot v30.4s, v25.16b, v18.4b[3]\n"
                    ".inst 0x6fb6eb3f // udot v31.4s, v25.16b, v22.4b[3]\n"
                    ".inst 0x6f83e31a // udot v26.4s, v24.16b, v3.4b[0]\n"
                    ".inst 0x6f87e31b // udot v27.4s, v24.16b, v7.4b[0]\n"
                    ".inst 0x6f8be31c // udot v28.4s, v24.16b, v11.4b[0]\n"
                    ".inst 0x6f8fe31d // udot v29.4s, v24.16b, v15.4b[0]\n"
                    ".inst 0x6f93e31e // udot v30.4s, v24.16b, v19.4b[0]\n"
                    ".inst 0x6f97e31f // udot v31.4s, v24.16b, v23.4b[0]\n"
                    "b.eq 7f\n"
                    "8:\n"
                    "str q26, [%[c_ptr0]]\n"
                    "subs %[loops], %[loops], #0x1\n"
                    "movi v26.4s, #0\n"
                    "ldr d24, [%[b_ptr0]]\n"
                    "ldr temploadreg0, [%[b_ptr0], #0x8]\n"
                    "add %[c_ptr0], %[c_ptr0], #0x10\n"
                    "str q27, [c_ptr1]\n"
                    "add c_ptr1, c_ptr1, #0x10\n"
                    "movi v27.4s, #0\n"
                    "ldr d25, [%[b_ptr0], #0x10]\n"
                    "ldr temploadreg1, [%[b_ptr0], #0x18]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    "str q28, [c_ptr2]\n"
                    "add c_ptr2, c_ptr2, #0x10\n"
                    "movi v28.4s, #0\n"
                    "ins v24.d[1], temploadreg0\n"
                    "ins v25.d[1], temploadreg1\n"
                    "prfm PSTL1KEEP, [%[c_ptr0], #0x40]\n"
                    "str q29, [c_ptr3]\n"
                    "add c_ptr3, c_ptr3, #0x10\n"
                    "movi v29.4s, #0\n"
                    "ldr temploadreg0, [%[b_ptr0], #0x8]\n"
                    ".inst 0x6f80e31a // udot v26.4s, v24.16b, v0.4b[0]\n"
                    "str q30, [c_ptr4]\n"
                    "movi v30.4s, #0\n"
                    "ldr temploadreg1, [%[b_ptr0], #0x18]\n"
                    ".inst 0x6f84e31b // udot v27.4s, v24.16b, v4.4b[0]\n"
                    "add c_ptr4, c_ptr4, #0x10\n"
                    ".inst 0x6f88e31c // udot v28.4s, v24.16b, v8.4b[0]\n"
                    "str q31, [c_ptr5]\n"
                    "movi v31.4s, #0\n"
                    "add c_ptr5, c_ptr5, #0x10\n"
                    ".inst 0x6f8ce31d // udot v29.4s, v24.16b, v12.4b[0]\n"
                    "prfm PSTL1KEEP, [c_ptr1, #0x40]\n"
                    ".inst 0x6f90e31e // udot v30.4s, v24.16b, v16.4b[0]\n"
                    "prfm PSTL1KEEP, [c_ptr2, #0x40]\n"
                    ".inst 0x6f94e31f // udot v31.4s, v24.16b, v20.4b[0]\n"
                    "ldr d24, [%[b_ptr0]]\n"
                    ".inst 0x6fa0e33a // udot v26.4s, v25.16b, v0.4b[1]\n"
                    "prfm PSTL1KEEP, [c_ptr3, #0x40]\n"
                    ".inst 0x6fa4e33b // udot v27.4s, v25.16b, v4.4b[1]\n"
                    "ins v24.d[1], temploadreg0\n"
                    ".inst 0x6fa8e33c // udot v28.4s, v25.16b, v8.4b[1]\n"
                    "prfm PSTL1KEEP, [c_ptr4, #0x40]\n"
                    ".inst 0x6face33d // udot v29.4s, v25.16b, v12.4b[1]\n"
                    "prfm PSTL1KEEP, [c_ptr5, #0x40]\n"
                    ".inst 0x6fb0e33e // udot v30.4s, v25.16b, v16.4b[1]\n"
                    ".inst 0x6fb4e33f // udot v31.4s, v25.16b, v20.4b[1]\n"
                    "ldr d25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f80eb1a // udot v26.4s, v24.16b, v0.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f84eb1b // udot v27.4s, v24.16b, v4.4b[2]\n"
                    "ins v25.d[1], temploadreg1\n"
                    ".inst 0x6f88eb1c // udot v28.4s, v24.16b, v8.4b[2]\n"
                    "ldr temploadreg0, [%[b_ptr0], #0x8]\n"
                    ".inst 0x6f8ceb1d // udot v29.4s, v24.16b, v12.4b[2]\n"
                    "ldr temploadreg1, [%[b_ptr0], #0x18]\n"
                    ".inst 0x6f90eb1e // udot v30.4s, v24.16b, v16.4b[2]\n"
                    ".inst 0x6f94eb1f // udot v31.4s, v24.16b, v20.4b[2]\n"
                    "ldr d24, [%[b_ptr0]]\n"
                    ".inst 0x6fa0eb3a // udot v26.4s, v25.16b, v0.4b[3]\n"
                    ".inst 0x6fa4eb3b // udot v27.4s, v25.16b, v4.4b[3]\n"
                    ".inst 0x6fa8eb3c // udot v28.4s, v25.16b, v8.4b[3]\n"
                    "ins v24.d[1], temploadreg0\n"
                    ".inst 0x6faceb3d // udot v29.4s, v25.16b, v12.4b[3]\n"
                    ".inst 0x6fb0eb3e // udot v30.4s, v25.16b, v16.4b[3]\n"
                    ".inst 0x6fb4eb3f // udot v31.4s, v25.16b, v20.4b[3]\n"
                    "ldr d25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f81e31a // udot v26.4s, v24.16b, v1.4b[0]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f85e31b // udot v27.4s, v24.16b, v5.4b[0]\n"
                    "ins v25.d[1], temploadreg1\n"
                    ".inst 0x6f89e31c // udot v28.4s, v24.16b, v9.4b[0]\n"
                    "ldr temploadreg0, [%[b_ptr0], #0x8]\n"
                    ".inst 0x6f8de31d // udot v29.4s, v24.16b, v13.4b[0]\n"
                    "ldr temploadreg1, [%[b_ptr0], #0x18]\n"
                    ".inst 0x6f91e31e // udot v30.4s, v24.16b, v17.4b[0]\n"
                    ".inst 0x6f95e31f // udot v31.4s, v24.16b, v21.4b[0]\n"
                    "ldr d24, [%[b_ptr0]]\n"
                    ".inst 0x6fa1e33a // udot v26.4s, v25.16b, v1.4b[1]\n"
                    ".inst 0x6fa5e33b // udot v27.4s, v25.16b, v5.4b[1]\n"
                    ".inst 0x6fa9e33c // udot v28.4s, v25.16b, v9.4b[1]\n"
                    "ins v24.d[1], temploadreg0\n"
                    ".inst 0x6fade33d // udot v29.4s, v25.16b, v13.4b[1]\n"
                    ".inst 0x6fb1e33e // udot v30.4s, v25.16b, v17.4b[1]\n"
                    ".inst 0x6fb5e33f // udot v31.4s, v25.16b, v21.4b[1]\n"
                    "ldr d25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f81eb1a // udot v26.4s, v24.16b, v1.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f85eb1b // udot v27.4s, v24.16b, v5.4b[2]\n"
                    "ins v25.d[1], temploadreg1\n"
                    ".inst 0x6f89eb1c // udot v28.4s, v24.16b, v9.4b[2]\n"
                    "ldr temploadreg0, [%[b_ptr0], #0x8]\n"
                    ".inst 0x6f8deb1d // udot v29.4s, v24.16b, v13.4b[2]\n"
                    "ldr temploadreg1, [%[b_ptr0], #0x18]\n"
                    ".inst 0x6f91eb1e // udot v30.4s, v24.16b, v17.4b[2]\n"
                    ".inst 0x6f95eb1f // udot v31.4s, v24.16b, v21.4b[2]\n"
                    "ldr d24, [%[b_ptr0]]\n"
                    ".inst 0x6fa1eb3a // udot v26.4s, v25.16b, v1.4b[3]\n"
                    ".inst 0x6fa5eb3b // udot v27.4s, v25.16b, v5.4b[3]\n"
                    ".inst 0x6fa9eb3c // udot v28.4s, v25.16b, v9.4b[3]\n"
                    "ins v24.d[1], temploadreg0\n"
                    ".inst 0x6fadeb3d // udot v29.4s, v25.16b, v13.4b[3]\n"
                    ".inst 0x6fb1eb3e // udot v30.4s, v25.16b, v17.4b[3]\n"
                    ".inst 0x6fb5eb3f // udot v31.4s, v25.16b, v21.4b[3]\n"
                    "ldr d25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f82e31a // udot v26.4s, v24.16b, v2.4b[0]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f86e31b // udot v27.4s, v24.16b, v6.4b[0]\n"
                    "ins v25.d[1], temploadreg1\n"
                    ".inst 0x6f8ae31c // udot v28.4s, v24.16b, v10.4b[0]\n"
                    "ldr temploadreg0, [%[b_ptr0], #0x8]\n"
                    ".inst 0x6f8ee31d // udot v29.4s, v24.16b, v14.4b[0]\n"
                    "ldr temploadreg1, [%[b_ptr0], #0x18]\n"
                    ".inst 0x6f92e31e // udot v30.4s, v24.16b, v18.4b[0]\n"
                    ".inst 0x6f96e31f // udot v31.4s, v24.16b, v22.4b[0]\n"
                    "ldr d24, [%[b_ptr0]]\n"
                    ".inst 0x6fa2e33a // udot v26.4s, v25.16b, v2.4b[1]\n"
                    ".inst 0x6fa6e33b // udot v27.4s, v25.16b, v6.4b[1]\n"
                    ".inst 0x6faae33c // udot v28.4s, v25.16b, v10.4b[1]\n"
                    "ins v24.d[1], temploadreg0\n"
                    ".inst 0x6faee33d // udot v29.4s, v25.16b, v14.4b[1]\n"
                    ".inst 0x6fb2e33e // udot v30.4s, v25.16b, v18.4b[1]\n"
                    ".inst 0x6fb6e33f // udot v31.4s, v25.16b, v22.4b[1]\n"
                    "ldr d25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f82eb1a // udot v26.4s, v24.16b, v2.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f86eb1b // udot v27.4s, v24.16b, v6.4b[2]\n"
                    "ins v25.d[1], temploadreg1\n"
                    ".inst 0x6f8aeb1c // udot v28.4s, v24.16b, v10.4b[2]\n"
                    "ldr temploadreg0, [%[b_ptr0], #0x8]\n"
                    ".inst 0x6f8eeb1d // udot v29.4s, v24.16b, v14.4b[2]\n"
                    ".inst 0x6f92eb1e // udot v30.4s, v24.16b, v18.4b[2]\n"
                    ".inst 0x6f96eb1f // udot v31.4s, v24.16b, v22.4b[2]\n"
                    "ldr d24, [%[b_ptr0]]\n"
                    ".inst 0x6fa2eb3a // udot v26.4s, v25.16b, v2.4b[3]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x10\n"
                    ".inst 0x6fa6eb3b // udot v27.4s, v25.16b, v6.4b[3]\n"
                    "ins v24.d[1], temploadreg0\n"
                    ".inst 0x6faaeb3c // udot v28.4s, v25.16b, v10.4b[3]\n"
                    ".inst 0x6faeeb3d // udot v29.4s, v25.16b, v14.4b[3]\n"
                    ".inst 0x6fb2eb3e // udot v30.4s, v25.16b, v18.4b[3]\n"
                    ".inst 0x6fb6eb3f // udot v31.4s, v25.16b, v22.4b[3]\n"
                    ".inst 0x6f83e31a // udot v26.4s, v24.16b, v3.4b[0]\n"
                    ".inst 0x6f87e31b // udot v27.4s, v24.16b, v7.4b[0]\n"
                    ".inst 0x6f8be31c // udot v28.4s, v24.16b, v11.4b[0]\n"
                    ".inst 0x6f8fe31d // udot v29.4s, v24.16b, v15.4b[0]\n"
                    ".inst 0x6f93e31e // udot v30.4s, v24.16b, v19.4b[0]\n"
                    ".inst 0x6f97e31f // udot v31.4s, v24.16b, v23.4b[0]\n"
                    "b.ne 8b\n"
                    "7:\n"
                    "str q26, [%[c_ptr0]]\n"
                    "add %[c_ptr0], %[c_ptr0], #0x10\n"
                    "movi v26.4s, #0\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    "str q27, [c_ptr1]\n"
                    "add c_ptr1, c_ptr1, #0x10\n"
                    "movi v27.4s, #0\n"
                    ".inst 0x6f80e31a // udot v26.4s, v24.16b, v0.4b[0]\n"
                    "str q28, [c_ptr2]\n"
                    "movi v28.4s, #0\n"
                    "add c_ptr2, c_ptr2, #0x10\n"
                    ".inst 0x6f84e31b // udot v27.4s, v24.16b, v4.4b[0]\n"
                    "str q29, [c_ptr3]\n"
                    "movi v29.4s, #0\n"
                    "add c_ptr3, c_ptr3, #0x10\n"
                    ".inst 0x6f88e31c // udot v28.4s, v24.16b, v8.4b[0]\n"
                    "str q30, [c_ptr4]\n"
                    "movi v30.4s, #0\n"
                    "add c_ptr4, c_ptr4, #0x10\n"
                    ".inst 0x6f8ce31d // udot v29.4s, v24.16b, v12.4b[0]\n"
                    "str q31, [c_ptr5]\n"
                    "movi v31.4s, #0\n"
                    "add c_ptr5, c_ptr5, #0x10\n"
                    ".inst 0x6f90e31e // udot v30.4s, v24.16b, v16.4b[0]\n"
                    ".inst 0x6fa0e33a // udot v26.4s, v25.16b, v0.4b[1]\n"
                    ".inst 0x6f94e31f // udot v31.4s, v24.16b, v20.4b[0]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa4e33b // udot v27.4s, v25.16b, v4.4b[1]\n"
                    ".inst 0x6fa8e33c // udot v28.4s, v25.16b, v8.4b[1]\n"
                    ".inst 0x6face33d // udot v29.4s, v25.16b, v12.4b[1]\n"
                    ".inst 0x6fb0e33e // udot v30.4s, v25.16b, v16.4b[1]\n"
                    ".inst 0x6fb4e33f // udot v31.4s, v25.16b, v20.4b[1]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f80eb1a // udot v26.4s, v24.16b, v0.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f84eb1b // udot v27.4s, v24.16b, v4.4b[2]\n"
                    ".inst 0x6f88eb1c // udot v28.4s, v24.16b, v8.4b[2]\n"
                    ".inst 0x6f8ceb1d // udot v29.4s, v24.16b, v12.4b[2]\n"
                    ".inst 0x6f90eb1e // udot v30.4s, v24.16b, v16.4b[2]\n"
                    ".inst 0x6f94eb1f // udot v31.4s, v24.16b, v20.4b[2]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa0eb3a // udot v26.4s, v25.16b, v0.4b[3]\n"
                    ".inst 0x6fa4eb3b // udot v27.4s, v25.16b, v4.4b[3]\n"
                    ".inst 0x6fa8eb3c // udot v28.4s, v25.16b, v8.4b[3]\n"
                    ".inst 0x6faceb3d // udot v29.4s, v25.16b, v12.4b[3]\n"
                    ".inst 0x6fb0eb3e // udot v30.4s, v25.16b, v16.4b[3]\n"
                    ".inst 0x6fb4eb3f // udot v31.4s, v25.16b, v20.4b[3]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f81e31a // udot v26.4s, v24.16b, v1.4b[0]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f85e31b // udot v27.4s, v24.16b, v5.4b[0]\n"
                    ".inst 0x6f89e31c // udot v28.4s, v24.16b, v9.4b[0]\n"
                    ".inst 0x6f8de31d // udot v29.4s, v24.16b, v13.4b[0]\n"
                    ".inst 0x6f91e31e // udot v30.4s, v24.16b, v17.4b[0]\n"
                    ".inst 0x6f95e31f // udot v31.4s, v24.16b, v21.4b[0]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa1e33a // udot v26.4s, v25.16b, v1.4b[1]\n"
                    ".inst 0x6fa5e33b // udot v27.4s, v25.16b, v5.4b[1]\n"
                    ".inst 0x6fa9e33c // udot v28.4s, v25.16b, v9.4b[1]\n"
                    ".inst 0x6fade33d // udot v29.4s, v25.16b, v13.4b[1]\n"
                    ".inst 0x6fb1e33e // udot v30.4s, v25.16b, v17.4b[1]\n"
                    ".inst 0x6fb5e33f // udot v31.4s, v25.16b, v21.4b[1]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f81eb1a // udot v26.4s, v24.16b, v1.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f85eb1b // udot v27.4s, v24.16b, v5.4b[2]\n"
                    ".inst 0x6f89eb1c // udot v28.4s, v24.16b, v9.4b[2]\n"
                    ".inst 0x6f8deb1d // udot v29.4s, v24.16b, v13.4b[2]\n"
                    ".inst 0x6f91eb1e // udot v30.4s, v24.16b, v17.4b[2]\n"
                    ".inst 0x6f95eb1f // udot v31.4s, v24.16b, v21.4b[2]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa1eb3a // udot v26.4s, v25.16b, v1.4b[3]\n"
                    ".inst 0x6fa5eb3b // udot v27.4s, v25.16b, v5.4b[3]\n"
                    ".inst 0x6fa9eb3c // udot v28.4s, v25.16b, v9.4b[3]\n"
                    ".inst 0x6fadeb3d // udot v29.4s, v25.16b, v13.4b[3]\n"
                    ".inst 0x6fb1eb3e // udot v30.4s, v25.16b, v17.4b[3]\n"
                    ".inst 0x6fb5eb3f // udot v31.4s, v25.16b, v21.4b[3]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f82e31a // udot v26.4s, v24.16b, v2.4b[0]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f86e31b // udot v27.4s, v24.16b, v6.4b[0]\n"
                    ".inst 0x6f8ae31c // udot v28.4s, v24.16b, v10.4b[0]\n"
                    ".inst 0x6f8ee31d // udot v29.4s, v24.16b, v14.4b[0]\n"
                    ".inst 0x6f92e31e // udot v30.4s, v24.16b, v18.4b[0]\n"
                    ".inst 0x6f96e31f // udot v31.4s, v24.16b, v22.4b[0]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa2e33a // udot v26.4s, v25.16b, v2.4b[1]\n"
                    ".inst 0x6fa6e33b // udot v27.4s, v25.16b, v6.4b[1]\n"
                    ".inst 0x6faae33c // udot v28.4s, v25.16b, v10.4b[1]\n"
                    ".inst 0x6faee33d // udot v29.4s, v25.16b, v14.4b[1]\n"
                    ".inst 0x6fb2e33e // udot v30.4s, v25.16b, v18.4b[1]\n"
                    ".inst 0x6fb6e33f // udot v31.4s, v25.16b, v22.4b[1]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f82eb1a // udot v26.4s, v24.16b, v2.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f86eb1b // udot v27.4s, v24.16b, v6.4b[2]\n"
                    ".inst 0x6f8aeb1c // udot v28.4s, v24.16b, v10.4b[2]\n"
                    ".inst 0x6f8eeb1d // udot v29.4s, v24.16b, v14.4b[2]\n"
                    ".inst 0x6f92eb1e // udot v30.4s, v24.16b, v18.4b[2]\n"
                    ".inst 0x6f96eb1f // udot v31.4s, v24.16b, v22.4b[2]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa2eb3a // udot v26.4s, v25.16b, v2.4b[3]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x10\n"
                    ".inst 0x6fa6eb3b // udot v27.4s, v25.16b, v6.4b[3]\n"
                    ".inst 0x6faaeb3c // udot v28.4s, v25.16b, v10.4b[3]\n"
                    ".inst 0x6faeeb3d // udot v29.4s, v25.16b, v14.4b[3]\n"
                    ".inst 0x6fb2eb3e // udot v30.4s, v25.16b, v18.4b[3]\n"
                    ".inst 0x6fb6eb3f // udot v31.4s, v25.16b, v22.4b[3]\n"
                    ".inst 0x6f83e31a // udot v26.4s, v24.16b, v3.4b[0]\n"
                    ".inst 0x6f87e31b // udot v27.4s, v24.16b, v7.4b[0]\n"
                    ".inst 0x6f8be31c // udot v28.4s, v24.16b, v11.4b[0]\n"
                    ".inst 0x6f8fe31d // udot v29.4s, v24.16b, v15.4b[0]\n"
                    ".inst 0x6f93e31e // udot v30.4s, v24.16b, v19.4b[0]\n"
                    ".inst 0x6f97e31f // udot v31.4s, v24.16b, v23.4b[0]\n"
                    "b 9f\n"
                    "6:\n"
                    "movi v26.4s, #0\n"
                    "movi v27.4s, #0\n"
                    "movi v28.4s, #0\n"
                    "movi v29.4s, #0\n"
                    "movi v30.4s, #0\n"
                    "movi v31.4s, #0\n"
                    ".inst 0x6f80e31a // udot v26.4s, v24.16b, v0.4b[0]\n"
                    ".inst 0x6f84e31b // udot v27.4s, v24.16b, v4.4b[0]\n"
                    ".inst 0x6f88e31c // udot v28.4s, v24.16b, v8.4b[0]\n"
                    ".inst 0x6f8ce31d // udot v29.4s, v24.16b, v12.4b[0]\n"
                    ".inst 0x6f90e31e // udot v30.4s, v24.16b, v16.4b[0]\n"
                    ".inst 0x6f94e31f // udot v31.4s, v24.16b, v20.4b[0]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa0e33a // udot v26.4s, v25.16b, v0.4b[1]\n"
                    ".inst 0x6fa4e33b // udot v27.4s, v25.16b, v4.4b[1]\n"
                    ".inst 0x6fa8e33c // udot v28.4s, v25.16b, v8.4b[1]\n"
                    ".inst 0x6face33d // udot v29.4s, v25.16b, v12.4b[1]\n"
                    ".inst 0x6fb0e33e // udot v30.4s, v25.16b, v16.4b[1]\n"
                    ".inst 0x6fb4e33f // udot v31.4s, v25.16b, v20.4b[1]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f80eb1a // udot v26.4s, v24.16b, v0.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f84eb1b // udot v27.4s, v24.16b, v4.4b[2]\n"
                    ".inst 0x6f88eb1c // udot v28.4s, v24.16b, v8.4b[2]\n"
                    ".inst 0x6f8ceb1d // udot v29.4s, v24.16b, v12.4b[2]\n"
                    ".inst 0x6f90eb1e // udot v30.4s, v24.16b, v16.4b[2]\n"
                    ".inst 0x6f94eb1f // udot v31.4s, v24.16b, v20.4b[2]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa0eb3a // udot v26.4s, v25.16b, v0.4b[3]\n"
                    ".inst 0x6fa4eb3b // udot v27.4s, v25.16b, v4.4b[3]\n"
                    ".inst 0x6fa8eb3c // udot v28.4s, v25.16b, v8.4b[3]\n"
                    ".inst 0x6faceb3d // udot v29.4s, v25.16b, v12.4b[3]\n"
                    ".inst 0x6fb0eb3e // udot v30.4s, v25.16b, v16.4b[3]\n"
                    ".inst 0x6fb4eb3f // udot v31.4s, v25.16b, v20.4b[3]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f81e31a // udot v26.4s, v24.16b, v1.4b[0]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f85e31b // udot v27.4s, v24.16b, v5.4b[0]\n"
                    ".inst 0x6f89e31c // udot v28.4s, v24.16b, v9.4b[0]\n"
                    ".inst 0x6f8de31d // udot v29.4s, v24.16b, v13.4b[0]\n"
                    ".inst 0x6f91e31e // udot v30.4s, v24.16b, v17.4b[0]\n"
                    ".inst 0x6f95e31f // udot v31.4s, v24.16b, v21.4b[0]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa1e33a // udot v26.4s, v25.16b, v1.4b[1]\n"
                    ".inst 0x6fa5e33b // udot v27.4s, v25.16b, v5.4b[1]\n"
                    ".inst 0x6fa9e33c // udot v28.4s, v25.16b, v9.4b[1]\n"
                    ".inst 0x6fade33d // udot v29.4s, v25.16b, v13.4b[1]\n"
                    ".inst 0x6fb1e33e // udot v30.4s, v25.16b, v17.4b[1]\n"
                    ".inst 0x6fb5e33f // udot v31.4s, v25.16b, v21.4b[1]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f81eb1a // udot v26.4s, v24.16b, v1.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f85eb1b // udot v27.4s, v24.16b, v5.4b[2]\n"
                    ".inst 0x6f89eb1c // udot v28.4s, v24.16b, v9.4b[2]\n"
                    ".inst 0x6f8deb1d // udot v29.4s, v24.16b, v13.4b[2]\n"
                    ".inst 0x6f91eb1e // udot v30.4s, v24.16b, v17.4b[2]\n"
                    ".inst 0x6f95eb1f // udot v31.4s, v24.16b, v21.4b[2]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa1eb3a // udot v26.4s, v25.16b, v1.4b[3]\n"
                    ".inst 0x6fa5eb3b // udot v27.4s, v25.16b, v5.4b[3]\n"
                    ".inst 0x6fa9eb3c // udot v28.4s, v25.16b, v9.4b[3]\n"
                    ".inst 0x6fadeb3d // udot v29.4s, v25.16b, v13.4b[3]\n"
                    ".inst 0x6fb1eb3e // udot v30.4s, v25.16b, v17.4b[3]\n"
                    ".inst 0x6fb5eb3f // udot v31.4s, v25.16b, v21.4b[3]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f82e31a // udot v26.4s, v24.16b, v2.4b[0]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f86e31b // udot v27.4s, v24.16b, v6.4b[0]\n"
                    ".inst 0x6f8ae31c // udot v28.4s, v24.16b, v10.4b[0]\n"
                    ".inst 0x6f8ee31d // udot v29.4s, v24.16b, v14.4b[0]\n"
                    ".inst 0x6f92e31e // udot v30.4s, v24.16b, v18.4b[0]\n"
                    ".inst 0x6f96e31f // udot v31.4s, v24.16b, v22.4b[0]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa2e33a // udot v26.4s, v25.16b, v2.4b[1]\n"
                    ".inst 0x6fa6e33b // udot v27.4s, v25.16b, v6.4b[1]\n"
                    ".inst 0x6faae33c // udot v28.4s, v25.16b, v10.4b[1]\n"
                    ".inst 0x6faee33d // udot v29.4s, v25.16b, v14.4b[1]\n"
                    ".inst 0x6fb2e33e // udot v30.4s, v25.16b, v18.4b[1]\n"
                    ".inst 0x6fb6e33f // udot v31.4s, v25.16b, v22.4b[1]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f82eb1a // udot v26.4s, v24.16b, v2.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f86eb1b // udot v27.4s, v24.16b, v6.4b[2]\n"
                    ".inst 0x6f8aeb1c // udot v28.4s, v24.16b, v10.4b[2]\n"
                    ".inst 0x6f8eeb1d // udot v29.4s, v24.16b, v14.4b[2]\n"
                    ".inst 0x6f92eb1e // udot v30.4s, v24.16b, v18.4b[2]\n"
                    ".inst 0x6f96eb1f // udot v31.4s, v24.16b, v22.4b[2]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa2eb3a // udot v26.4s, v25.16b, v2.4b[3]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x10\n"
                    ".inst 0x6fa6eb3b // udot v27.4s, v25.16b, v6.4b[3]\n"
                    ".inst 0x6faaeb3c // udot v28.4s, v25.16b, v10.4b[3]\n"
                    ".inst 0x6faeeb3d // udot v29.4s, v25.16b, v14.4b[3]\n"
                    ".inst 0x6fb2eb3e // udot v30.4s, v25.16b, v18.4b[3]\n"
                    ".inst 0x6fb6eb3f // udot v31.4s, v25.16b, v22.4b[3]\n"
                    ".inst 0x6f83e31a // udot v26.4s, v24.16b, v3.4b[0]\n"
                    ".inst 0x6f87e31b // udot v27.4s, v24.16b, v7.4b[0]\n"
                    ".inst 0x6f8be31c // udot v28.4s, v24.16b, v11.4b[0]\n"
                    ".inst 0x6f8fe31d // udot v29.4s, v24.16b, v15.4b[0]\n"
                    ".inst 0x6f93e31e // udot v30.4s, v24.16b, v19.4b[0]\n"
                    ".inst 0x6f97e31f // udot v31.4s, v24.16b, v23.4b[0]\n"
                    "9:\n"
                    "str q26, [%[c_ptr0]]\n"
                    "add %[c_ptr0], %[c_ptr0], #0x10\n"
                    "str q27, [c_ptr1]\n"
                    "str q28, [c_ptr2]\n"
                    "str q29, [c_ptr3]\n"
                    "str q30, [c_ptr4]\n"
                    "str q31, [c_ptr5]\n"
                    ".unreq a_ptr1\n"
                    ".unreq a_ptr2\n"
                    ".unreq a_ptr3\n"
                    ".unreq a_ptr4\n"
                    ".unreq a_ptr5\n"
                    ".unreq c_ptr1\n"
                    ".unreq c_ptr2\n"
                    ".unreq c_ptr3\n"
                    ".unreq c_ptr4\n"
                    ".unreq c_ptr5\n"
                    ".unreq temploadreg0\n"
                    ".unreq temploadreg1\n"
                    ".unreq temploadreg2\n"
                    ".unreq temploadreg3\n"
                    : [a_ptr0] "+r" (a_ptr0), [b_ptr0] "+r" (b_ptr0), [c_ptr0] "+r" (c_ptr0), [loops] "+r" (loops), [oob_rows] "+r" (oob_rows), [odds] "+r" (odds)
                    : [lda] "r" (ldab), [ldc] "r" (ldcb)
                    : "x0", "x1", "x2", "x3", "x4", "x5", "x6", "x7", "x8", "x9", "x10", "x11", "x12", "x13", "v0", "v1", "v2", "v3", "v4", "v5", "v6", "v7", "v8", "v9", "v10", "v11", "v12", "v13", "v14", "v15", "v16", "v17", "v18", "v19", "v20", "v21", "v22", "v23", "v24", "v25", "v26", "v27", "v28", "v29", "v30", "v31", "cc", "memory"
                );
                break;
            case 14:
                __asm __volatile (
                    "a_ptr1 .req X0\n"
                    "a_ptr2 .req X1\n"
                    "a_ptr3 .req X2\n"
                    "a_ptr4 .req X3\n"
                    "a_ptr5 .req X4\n"
                    "c_ptr1 .req X5\n"
                    "c_ptr2 .req X6\n"
                    "c_ptr3 .req X7\n"
                    "c_ptr4 .req X8\n"
                    "c_ptr5 .req X9\n"
                    "temploadreg0 .req X10\n"
                    "temploadreg1 .req X11\n"
                    "temploadreg2 .req X12\n"
                    "temploadreg3 .req X13\n"
                    "add a_ptr1, %[a_ptr0], %[lda]\n"
                    "add c_ptr1, %[c_ptr0], %[ldc]\n"
                    "add a_ptr2, a_ptr1, %[lda]\n"
                    "add c_ptr2, c_ptr1, %[ldc]\n"
                    "add a_ptr3, a_ptr2, %[lda]\n"
                    "add c_ptr3, c_ptr2, %[ldc]\n"
                    "add a_ptr4, a_ptr3, %[lda]\n"
                    "add c_ptr4, c_ptr3, %[ldc]\n"
                    "add a_ptr5, a_ptr4, %[lda]\n"
                    "add c_ptr5, c_ptr4, %[ldc]\n"
                    "cbz %[oob_rows], 1f\n"
                    "subs %[oob_rows], %[oob_rows], #0x1\n"
                    "add c_ptr5, %[c_ptr0], #0x0\n"
                    "add a_ptr5, %[a_ptr0], #0x0\n"
                    "b.eq 1f\n"
                    "subs %[oob_rows], %[oob_rows], #0x1\n"
                    "add c_ptr4, %[c_ptr0], #0x0\n"
                    "add a_ptr4, %[a_ptr0], #0x0\n"
                    "b.eq 1f\n"
                    "subs %[oob_rows], %[oob_rows], #0x1\n"
                    "add c_ptr3, %[c_ptr0], #0x0\n"
                    "add a_ptr3, %[a_ptr0], #0x0\n"
                    "b.eq 1f\n"
                    "subs %[oob_rows], %[oob_rows], #0x1\n"
                    "add c_ptr2, %[c_ptr0], #0x0\n"
                    "add a_ptr2, %[a_ptr0], #0x0\n"
                    "b.eq 1f\n"
                    "subs %[oob_rows], %[oob_rows], #0x1\n"
                    "add c_ptr1, %[c_ptr0], #0x0\n"
                    "add a_ptr1, %[a_ptr0], #0x0\n"
                    "1:\n"
                    "cbnz %[odds], 2f\n"
                    "ldr q0, [%[a_ptr0]], #0x10\n"
                    "ldr q4, [a_ptr1], #0x10\n"
                    "ldr q8, [a_ptr2], #0x10\n"
                    "ldr q12, [a_ptr3], #0x10\n"
                    "ldr q16, [a_ptr4], #0x10\n"
                    "ldr q20, [a_ptr5], #0x10\n"
                    "ldr q1, [%[a_ptr0]], #0x10\n"
                    "ldr q5, [a_ptr1], #0x10\n"
                    "ldr q9, [a_ptr2], #0x10\n"
                    "ldr q13, [a_ptr3], #0x10\n"
                    "ldr q17, [a_ptr4], #0x10\n"
                    "ldr q21, [a_ptr5], #0x10\n"
                    "ldr q2, [%[a_ptr0]], #0x10\n"
                    "ldr q6, [a_ptr1], #0x10\n"
                    "ldr q10, [a_ptr2], #0x10\n"
                    "ldr q14, [a_ptr3], #0x10\n"
                    "ldr d3, [%[a_ptr0]]\n"
                    "ldr q18, [a_ptr4], #0x10\n"
                    "ldr d7, [a_ptr1]\n"
                    "ldr q22, [a_ptr5], #0x10\n"
                    "ldr d11, [a_ptr2]\n"
                    "ldr d15, [a_ptr3]\n"
                    "ldr d19, [a_ptr4]\n"
                    "ldr d23, [a_ptr5]\n"
                    "b 3f\n"
                    "2:\n"
                    "ldr q0, [%[a_ptr0]], #0x10\n"
                    "subs %[odds], %[odds], #0x1\n"
                    "ldr q4, [a_ptr1], #0x10\n"
                    "ldr q8, [a_ptr2], #0x10\n"
                    "ldr q12, [a_ptr3], #0x10\n"
                    "ldr q16, [a_ptr4], #0x10\n"
                    "ldr q20, [a_ptr5], #0x10\n"
                    "ldr q1, [%[a_ptr0]], #0x10\n"
                    "ldr q5, [a_ptr1], #0x10\n"
                    "ldr q9, [a_ptr2], #0x10\n"
                    "ldr q13, [a_ptr3], #0x10\n"
                    "ldr q17, [a_ptr4], #0x10\n"
                    "ldr q21, [a_ptr5], #0x10\n"
                    "ldr q2, [%[a_ptr0]], #0x10\n"
                    "ldr q6, [a_ptr1], #0x10\n"
                    "ldr q10, [a_ptr2], #0x10\n"
                    "ldr q14, [a_ptr3], #0x10\n"
                    "ldr s3, [%[a_ptr0]], #0x4\n"
                    "ldr q18, [a_ptr4], #0x10\n"
                    "ldr s7, [a_ptr1], #0x4\n"
                    "ldr q22, [a_ptr5], #0x10\n"
                    "ldr s11, [a_ptr2], #0x4\n"
                    "ldr s15, [a_ptr3], #0x4\n"
                    "ldr s19, [a_ptr4], #0x4\n"
                    "ldr s23, [a_ptr5], #0x4\n"
                    "b.ne 4f\n"
                    "ld1 {v3.b}[4], [%[a_ptr0]]\n"
                    "ld1 {v7.b}[4], [a_ptr1]\n"
                    "ld1 {v11.b}[4], [a_ptr2]\n"
                    "ld1 {v15.b}[4], [a_ptr3]\n"
                    "ld1 {v19.b}[4], [a_ptr4]\n"
                    "ld1 {v23.b}[4], [a_ptr5]\n"
                    "b 3f\n"
                    "4:\n"
                    "ld1 {v3.h}[2], [%[a_ptr0]], #2\n"
                    "ld1 {v7.h}[2], [a_ptr1], #2\n"
                    "ld1 {v11.h}[2], [a_ptr2], #2\n"
                    "ld1 {v15.h}[2], [a_ptr3], #2\n"
                    "ld1 {v19.h}[2], [a_ptr4], #2\n"
                    "ld1 {v23.h}[2], [a_ptr5], #2\n"
                    "subs %[odds], %[odds], #0x1\n"
                    "b.ne 5f\n"
                    "b 3f\n"
                    "5:\n"
                    "ld1 {v3.b}[6], [%[a_ptr0]]\n"
                    "ld1 {v7.b}[6], [a_ptr1]\n"
                    "ld1 {v11.b}[6], [a_ptr2]\n"
                    "ld1 {v15.b}[6], [a_ptr3]\n"
                    "ld1 {v19.b}[6], [a_ptr4]\n"
                    "ld1 {v23.b}[6], [a_ptr5]\n"
                    "3:\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    "prfm PLDL1KEEP, [a_ptr5, #0x40]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    "prfm PLDL1KEEP, [a_ptr5, #0x80]\n"
                    "prfm PLDL1KEEP, [a_ptr5, #0xc0]\n"
                    "prfm PLDL1KEEP, [a_ptr5, #0x100]\n"
                    "prfm PLDL1KEEP, [a_ptr5, #0x140]\n"
                    "prfm PLDL1KEEP, [a_ptr5, #0x180]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    "cbz %[loops], 6f\n"
                    "movi v26.4s, #0\n"
                    "subs %[loops], %[loops], #0x1\n"
                    "movi v27.4s, #0\n"
                    "movi v28.4s, #0\n"
                    "movi v29.4s, #0\n"
                    "movi v30.4s, #0\n"
                    "movi v31.4s, #0\n"
                    ".inst 0x6f80e31a // udot v26.4s, v24.16b, v0.4b[0]\n"
                    ".inst 0x6f84e31b // udot v27.4s, v24.16b, v4.4b[0]\n"
                    ".inst 0x6f88e31c // udot v28.4s, v24.16b, v8.4b[0]\n"
                    ".inst 0x6f8ce31d // udot v29.4s, v24.16b, v12.4b[0]\n"
                    ".inst 0x6f90e31e // udot v30.4s, v24.16b, v16.4b[0]\n"
                    ".inst 0x6f94e31f // udot v31.4s, v24.16b, v20.4b[0]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa0e33a // udot v26.4s, v25.16b, v0.4b[1]\n"
                    ".inst 0x6fa4e33b // udot v27.4s, v25.16b, v4.4b[1]\n"
                    ".inst 0x6fa8e33c // udot v28.4s, v25.16b, v8.4b[1]\n"
                    ".inst 0x6face33d // udot v29.4s, v25.16b, v12.4b[1]\n"
                    ".inst 0x6fb0e33e // udot v30.4s, v25.16b, v16.4b[1]\n"
                    ".inst 0x6fb4e33f // udot v31.4s, v25.16b, v20.4b[1]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f80eb1a // udot v26.4s, v24.16b, v0.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f84eb1b // udot v27.4s, v24.16b, v4.4b[2]\n"
                    ".inst 0x6f88eb1c // udot v28.4s, v24.16b, v8.4b[2]\n"
                    ".inst 0x6f8ceb1d // udot v29.4s, v24.16b, v12.4b[2]\n"
                    ".inst 0x6f90eb1e // udot v30.4s, v24.16b, v16.4b[2]\n"
                    ".inst 0x6f94eb1f // udot v31.4s, v24.16b, v20.4b[2]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa0eb3a // udot v26.4s, v25.16b, v0.4b[3]\n"
                    ".inst 0x6fa4eb3b // udot v27.4s, v25.16b, v4.4b[3]\n"
                    ".inst 0x6fa8eb3c // udot v28.4s, v25.16b, v8.4b[3]\n"
                    ".inst 0x6faceb3d // udot v29.4s, v25.16b, v12.4b[3]\n"
                    ".inst 0x6fb0eb3e // udot v30.4s, v25.16b, v16.4b[3]\n"
                    ".inst 0x6fb4eb3f // udot v31.4s, v25.16b, v20.4b[3]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f81e31a // udot v26.4s, v24.16b, v1.4b[0]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f85e31b // udot v27.4s, v24.16b, v5.4b[0]\n"
                    ".inst 0x6f89e31c // udot v28.4s, v24.16b, v9.4b[0]\n"
                    ".inst 0x6f8de31d // udot v29.4s, v24.16b, v13.4b[0]\n"
                    ".inst 0x6f91e31e // udot v30.4s, v24.16b, v17.4b[0]\n"
                    ".inst 0x6f95e31f // udot v31.4s, v24.16b, v21.4b[0]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa1e33a // udot v26.4s, v25.16b, v1.4b[1]\n"
                    ".inst 0x6fa5e33b // udot v27.4s, v25.16b, v5.4b[1]\n"
                    ".inst 0x6fa9e33c // udot v28.4s, v25.16b, v9.4b[1]\n"
                    ".inst 0x6fade33d // udot v29.4s, v25.16b, v13.4b[1]\n"
                    ".inst 0x6fb1e33e // udot v30.4s, v25.16b, v17.4b[1]\n"
                    ".inst 0x6fb5e33f // udot v31.4s, v25.16b, v21.4b[1]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f81eb1a // udot v26.4s, v24.16b, v1.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f85eb1b // udot v27.4s, v24.16b, v5.4b[2]\n"
                    ".inst 0x6f89eb1c // udot v28.4s, v24.16b, v9.4b[2]\n"
                    ".inst 0x6f8deb1d // udot v29.4s, v24.16b, v13.4b[2]\n"
                    ".inst 0x6f91eb1e // udot v30.4s, v24.16b, v17.4b[2]\n"
                    ".inst 0x6f95eb1f // udot v31.4s, v24.16b, v21.4b[2]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa1eb3a // udot v26.4s, v25.16b, v1.4b[3]\n"
                    ".inst 0x6fa5eb3b // udot v27.4s, v25.16b, v5.4b[3]\n"
                    ".inst 0x6fa9eb3c // udot v28.4s, v25.16b, v9.4b[3]\n"
                    ".inst 0x6fadeb3d // udot v29.4s, v25.16b, v13.4b[3]\n"
                    ".inst 0x6fb1eb3e // udot v30.4s, v25.16b, v17.4b[3]\n"
                    ".inst 0x6fb5eb3f // udot v31.4s, v25.16b, v21.4b[3]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f82e31a // udot v26.4s, v24.16b, v2.4b[0]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f86e31b // udot v27.4s, v24.16b, v6.4b[0]\n"
                    ".inst 0x6f8ae31c // udot v28.4s, v24.16b, v10.4b[0]\n"
                    ".inst 0x6f8ee31d // udot v29.4s, v24.16b, v14.4b[0]\n"
                    ".inst 0x6f92e31e // udot v30.4s, v24.16b, v18.4b[0]\n"
                    ".inst 0x6f96e31f // udot v31.4s, v24.16b, v22.4b[0]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa2e33a // udot v26.4s, v25.16b, v2.4b[1]\n"
                    ".inst 0x6fa6e33b // udot v27.4s, v25.16b, v6.4b[1]\n"
                    ".inst 0x6faae33c // udot v28.4s, v25.16b, v10.4b[1]\n"
                    ".inst 0x6faee33d // udot v29.4s, v25.16b, v14.4b[1]\n"
                    ".inst 0x6fb2e33e // udot v30.4s, v25.16b, v18.4b[1]\n"
                    ".inst 0x6fb6e33f // udot v31.4s, v25.16b, v22.4b[1]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f82eb1a // udot v26.4s, v24.16b, v2.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f86eb1b // udot v27.4s, v24.16b, v6.4b[2]\n"
                    ".inst 0x6f8aeb1c // udot v28.4s, v24.16b, v10.4b[2]\n"
                    ".inst 0x6f8eeb1d // udot v29.4s, v24.16b, v14.4b[2]\n"
                    ".inst 0x6f92eb1e // udot v30.4s, v24.16b, v18.4b[2]\n"
                    ".inst 0x6f96eb1f // udot v31.4s, v24.16b, v22.4b[2]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa2eb3a // udot v26.4s, v25.16b, v2.4b[3]\n"
                    ".inst 0x6fa6eb3b // udot v27.4s, v25.16b, v6.4b[3]\n"
                    ".inst 0x6faaeb3c // udot v28.4s, v25.16b, v10.4b[3]\n"
                    ".inst 0x6faeeb3d // udot v29.4s, v25.16b, v14.4b[3]\n"
                    ".inst 0x6fb2eb3e // udot v30.4s, v25.16b, v18.4b[3]\n"
                    ".inst 0x6fb6eb3f // udot v31.4s, v25.16b, v22.4b[3]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f83e31a // udot v26.4s, v24.16b, v3.4b[0]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f87e31b // udot v27.4s, v24.16b, v7.4b[0]\n"
                    ".inst 0x6f8be31c // udot v28.4s, v24.16b, v11.4b[0]\n"
                    ".inst 0x6f8fe31d // udot v29.4s, v24.16b, v15.4b[0]\n"
                    ".inst 0x6f93e31e // udot v30.4s, v24.16b, v19.4b[0]\n"
                    ".inst 0x6f97e31f // udot v31.4s, v24.16b, v23.4b[0]\n"
                    ".inst 0x6fa3e33a // udot v26.4s, v25.16b, v3.4b[1]\n"
                    ".inst 0x6fa7e33b // udot v27.4s, v25.16b, v7.4b[1]\n"
                    ".inst 0x6fabe33c // udot v28.4s, v25.16b, v11.4b[1]\n"
                    ".inst 0x6fafe33d // udot v29.4s, v25.16b, v15.4b[1]\n"
                    ".inst 0x6fb3e33e // udot v30.4s, v25.16b, v19.4b[1]\n"
                    ".inst 0x6fb7e33f // udot v31.4s, v25.16b, v23.4b[1]\n"
                    "b.eq 7f\n"
                    "8:\n"
                    "str q26, [%[c_ptr0]]\n"
                    "subs %[loops], %[loops], #0x1\n"
                    "movi v26.4s, #0\n"
                    "ldr d24, [%[b_ptr0]]\n"
                    "ldr temploadreg0, [%[b_ptr0], #0x8]\n"
                    "add %[c_ptr0], %[c_ptr0], #0x10\n"
                    "str q27, [c_ptr1]\n"
                    "add c_ptr1, c_ptr1, #0x10\n"
                    "movi v27.4s, #0\n"
                    "ldr d25, [%[b_ptr0], #0x10]\n"
                    "ldr temploadreg1, [%[b_ptr0], #0x18]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    "str q28, [c_ptr2]\n"
                    "add c_ptr2, c_ptr2, #0x10\n"
                    "movi v28.4s, #0\n"
                    "ins v24.d[1], temploadreg0\n"
                    "ins v25.d[1], temploadreg1\n"
                    "prfm PSTL1KEEP, [%[c_ptr0], #0x40]\n"
                    "str q29, [c_ptr3]\n"
                    "add c_ptr3, c_ptr3, #0x10\n"
                    "movi v29.4s, #0\n"
                    "ldr temploadreg0, [%[b_ptr0], #0x8]\n"
                    ".inst 0x6f80e31a // udot v26.4s, v24.16b, v0.4b[0]\n"
                    "str q30, [c_ptr4]\n"
                    "movi v30.4s, #0\n"
                    "ldr temploadreg1, [%[b_ptr0], #0x18]\n"
                    ".inst 0x6f84e31b // udot v27.4s, v24.16b, v4.4b[0]\n"
                    "add c_ptr4, c_ptr4, #0x10\n"
                    ".inst 0x6f88e31c // udot v28.4s, v24.16b, v8.4b[0]\n"
                    "str q31, [c_ptr5]\n"
                    "movi v31.4s, #0\n"
                    "add c_ptr5, c_ptr5, #0x10\n"
                    ".inst 0x6f8ce31d // udot v29.4s, v24.16b, v12.4b[0]\n"
                    "prfm PSTL1KEEP, [c_ptr1, #0x40]\n"
                    ".inst 0x6f90e31e // udot v30.4s, v24.16b, v16.4b[0]\n"
                    "prfm PSTL1KEEP, [c_ptr2, #0x40]\n"
                    ".inst 0x6f94e31f // udot v31.4s, v24.16b, v20.4b[0]\n"
                    "ldr d24, [%[b_ptr0]]\n"
                    ".inst 0x6fa0e33a // udot v26.4s, v25.16b, v0.4b[1]\n"
                    "prfm PSTL1KEEP, [c_ptr3, #0x40]\n"
                    ".inst 0x6fa4e33b // udot v27.4s, v25.16b, v4.4b[1]\n"
                    "ins v24.d[1], temploadreg0\n"
                    ".inst 0x6fa8e33c // udot v28.4s, v25.16b, v8.4b[1]\n"
                    "prfm PSTL1KEEP, [c_ptr4, #0x40]\n"
                    ".inst 0x6face33d // udot v29.4s, v25.16b, v12.4b[1]\n"
                    "prfm PSTL1KEEP, [c_ptr5, #0x40]\n"
                    ".inst 0x6fb0e33e // udot v30.4s, v25.16b, v16.4b[1]\n"
                    ".inst 0x6fb4e33f // udot v31.4s, v25.16b, v20.4b[1]\n"
                    "ldr d25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f80eb1a // udot v26.4s, v24.16b, v0.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f84eb1b // udot v27.4s, v24.16b, v4.4b[2]\n"
                    "ins v25.d[1], temploadreg1\n"
                    ".inst 0x6f88eb1c // udot v28.4s, v24.16b, v8.4b[2]\n"
                    "ldr temploadreg0, [%[b_ptr0], #0x8]\n"
                    ".inst 0x6f8ceb1d // udot v29.4s, v24.16b, v12.4b[2]\n"
                    "ldr temploadreg1, [%[b_ptr0], #0x18]\n"
                    ".inst 0x6f90eb1e // udot v30.4s, v24.16b, v16.4b[2]\n"
                    ".inst 0x6f94eb1f // udot v31.4s, v24.16b, v20.4b[2]\n"
                    "ldr d24, [%[b_ptr0]]\n"
                    ".inst 0x6fa0eb3a // udot v26.4s, v25.16b, v0.4b[3]\n"
                    ".inst 0x6fa4eb3b // udot v27.4s, v25.16b, v4.4b[3]\n"
                    ".inst 0x6fa8eb3c // udot v28.4s, v25.16b, v8.4b[3]\n"
                    "ins v24.d[1], temploadreg0\n"
                    ".inst 0x6faceb3d // udot v29.4s, v25.16b, v12.4b[3]\n"
                    ".inst 0x6fb0eb3e // udot v30.4s, v25.16b, v16.4b[3]\n"
                    ".inst 0x6fb4eb3f // udot v31.4s, v25.16b, v20.4b[3]\n"
                    "ldr d25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f81e31a // udot v26.4s, v24.16b, v1.4b[0]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f85e31b // udot v27.4s, v24.16b, v5.4b[0]\n"
                    "ins v25.d[1], temploadreg1\n"
                    ".inst 0x6f89e31c // udot v28.4s, v24.16b, v9.4b[0]\n"
                    "ldr temploadreg0, [%[b_ptr0], #0x8]\n"
                    ".inst 0x6f8de31d // udot v29.4s, v24.16b, v13.4b[0]\n"
                    "ldr temploadreg1, [%[b_ptr0], #0x18]\n"
                    ".inst 0x6f91e31e // udot v30.4s, v24.16b, v17.4b[0]\n"
                    ".inst 0x6f95e31f // udot v31.4s, v24.16b, v21.4b[0]\n"
                    "ldr d24, [%[b_ptr0]]\n"
                    ".inst 0x6fa1e33a // udot v26.4s, v25.16b, v1.4b[1]\n"
                    ".inst 0x6fa5e33b // udot v27.4s, v25.16b, v5.4b[1]\n"
                    ".inst 0x6fa9e33c // udot v28.4s, v25.16b, v9.4b[1]\n"
                    "ins v24.d[1], temploadreg0\n"
                    ".inst 0x6fade33d // udot v29.4s, v25.16b, v13.4b[1]\n"
                    ".inst 0x6fb1e33e // udot v30.4s, v25.16b, v17.4b[1]\n"
                    ".inst 0x6fb5e33f // udot v31.4s, v25.16b, v21.4b[1]\n"
                    "ldr d25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f81eb1a // udot v26.4s, v24.16b, v1.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f85eb1b // udot v27.4s, v24.16b, v5.4b[2]\n"
                    "ins v25.d[1], temploadreg1\n"
                    ".inst 0x6f89eb1c // udot v28.4s, v24.16b, v9.4b[2]\n"
                    "ldr temploadreg0, [%[b_ptr0], #0x8]\n"
                    ".inst 0x6f8deb1d // udot v29.4s, v24.16b, v13.4b[2]\n"
                    "ldr temploadreg1, [%[b_ptr0], #0x18]\n"
                    ".inst 0x6f91eb1e // udot v30.4s, v24.16b, v17.4b[2]\n"
                    ".inst 0x6f95eb1f // udot v31.4s, v24.16b, v21.4b[2]\n"
                    "ldr d24, [%[b_ptr0]]\n"
                    ".inst 0x6fa1eb3a // udot v26.4s, v25.16b, v1.4b[3]\n"
                    ".inst 0x6fa5eb3b // udot v27.4s, v25.16b, v5.4b[3]\n"
                    ".inst 0x6fa9eb3c // udot v28.4s, v25.16b, v9.4b[3]\n"
                    "ins v24.d[1], temploadreg0\n"
                    ".inst 0x6fadeb3d // udot v29.4s, v25.16b, v13.4b[3]\n"
                    ".inst 0x6fb1eb3e // udot v30.4s, v25.16b, v17.4b[3]\n"
                    ".inst 0x6fb5eb3f // udot v31.4s, v25.16b, v21.4b[3]\n"
                    "ldr d25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f82e31a // udot v26.4s, v24.16b, v2.4b[0]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f86e31b // udot v27.4s, v24.16b, v6.4b[0]\n"
                    "ins v25.d[1], temploadreg1\n"
                    ".inst 0x6f8ae31c // udot v28.4s, v24.16b, v10.4b[0]\n"
                    "ldr temploadreg0, [%[b_ptr0], #0x8]\n"
                    ".inst 0x6f8ee31d // udot v29.4s, v24.16b, v14.4b[0]\n"
                    "ldr temploadreg1, [%[b_ptr0], #0x18]\n"
                    ".inst 0x6f92e31e // udot v30.4s, v24.16b, v18.4b[0]\n"
                    ".inst 0x6f96e31f // udot v31.4s, v24.16b, v22.4b[0]\n"
                    "ldr d24, [%[b_ptr0]]\n"
                    ".inst 0x6fa2e33a // udot v26.4s, v25.16b, v2.4b[1]\n"
                    ".inst 0x6fa6e33b // udot v27.4s, v25.16b, v6.4b[1]\n"
                    ".inst 0x6faae33c // udot v28.4s, v25.16b, v10.4b[1]\n"
                    "ins v24.d[1], temploadreg0\n"
                    ".inst 0x6faee33d // udot v29.4s, v25.16b, v14.4b[1]\n"
                    ".inst 0x6fb2e33e // udot v30.4s, v25.16b, v18.4b[1]\n"
                    ".inst 0x6fb6e33f // udot v31.4s, v25.16b, v22.4b[1]\n"
                    "ldr d25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f82eb1a // udot v26.4s, v24.16b, v2.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f86eb1b // udot v27.4s, v24.16b, v6.4b[2]\n"
                    "ins v25.d[1], temploadreg1\n"
                    ".inst 0x6f8aeb1c // udot v28.4s, v24.16b, v10.4b[2]\n"
                    "ldr temploadreg0, [%[b_ptr0], #0x8]\n"
                    ".inst 0x6f8eeb1d // udot v29.4s, v24.16b, v14.4b[2]\n"
                    "ldr temploadreg1, [%[b_ptr0], #0x18]\n"
                    ".inst 0x6f92eb1e // udot v30.4s, v24.16b, v18.4b[2]\n"
                    ".inst 0x6f96eb1f // udot v31.4s, v24.16b, v22.4b[2]\n"
                    "ldr d24, [%[b_ptr0]]\n"
                    ".inst 0x6fa2eb3a // udot v26.4s, v25.16b, v2.4b[3]\n"
                    ".inst 0x6fa6eb3b // udot v27.4s, v25.16b, v6.4b[3]\n"
                    ".inst 0x6faaeb3c // udot v28.4s, v25.16b, v10.4b[3]\n"
                    "ins v24.d[1], temploadreg0\n"
                    ".inst 0x6faeeb3d // udot v29.4s, v25.16b, v14.4b[3]\n"
                    ".inst 0x6fb2eb3e // udot v30.4s, v25.16b, v18.4b[3]\n"
                    ".inst 0x6fb6eb3f // udot v31.4s, v25.16b, v22.4b[3]\n"
                    "ldr d25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f83e31a // udot v26.4s, v24.16b, v3.4b[0]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f87e31b // udot v27.4s, v24.16b, v7.4b[0]\n"
                    "ins v25.d[1], temploadreg1\n"
                    ".inst 0x6f8be31c // udot v28.4s, v24.16b, v11.4b[0]\n"
                    ".inst 0x6f8fe31d // udot v29.4s, v24.16b, v15.4b[0]\n"
                    ".inst 0x6f93e31e // udot v30.4s, v24.16b, v19.4b[0]\n"
                    ".inst 0x6f97e31f // udot v31.4s, v24.16b, v23.4b[0]\n"
                    ".inst 0x6fa3e33a // udot v26.4s, v25.16b, v3.4b[1]\n"
                    ".inst 0x6fa7e33b // udot v27.4s, v25.16b, v7.4b[1]\n"
                    ".inst 0x6fabe33c // udot v28.4s, v25.16b, v11.4b[1]\n"
                    ".inst 0x6fafe33d // udot v29.4s, v25.16b, v15.4b[1]\n"
                    ".inst 0x6fb3e33e // udot v30.4s, v25.16b, v19.4b[1]\n"
                    ".inst 0x6fb7e33f // udot v31.4s, v25.16b, v23.4b[1]\n"
                    "b.ne 8b\n"
                    "7:\n"
                    "str q26, [%[c_ptr0]]\n"
                    "add %[c_ptr0], %[c_ptr0], #0x10\n"
                    "movi v26.4s, #0\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    "str q27, [c_ptr1]\n"
                    "add c_ptr1, c_ptr1, #0x10\n"
                    "movi v27.4s, #0\n"
                    ".inst 0x6f80e31a // udot v26.4s, v24.16b, v0.4b[0]\n"
                    "str q28, [c_ptr2]\n"
                    "movi v28.4s, #0\n"
                    "add c_ptr2, c_ptr2, #0x10\n"
                    ".inst 0x6f84e31b // udot v27.4s, v24.16b, v4.4b[0]\n"
                    "str q29, [c_ptr3]\n"
                    "movi v29.4s, #0\n"
                    "add c_ptr3, c_ptr3, #0x10\n"
                    ".inst 0x6f88e31c // udot v28.4s, v24.16b, v8.4b[0]\n"
                    "str q30, [c_ptr4]\n"
                    "movi v30.4s, #0\n"
                    "add c_ptr4, c_ptr4, #0x10\n"
                    ".inst 0x6f8ce31d // udot v29.4s, v24.16b, v12.4b[0]\n"
                    "str q31, [c_ptr5]\n"
                    "movi v31.4s, #0\n"
                    "add c_ptr5, c_ptr5, #0x10\n"
                    ".inst 0x6f90e31e // udot v30.4s, v24.16b, v16.4b[0]\n"
                    ".inst 0x6fa0e33a // udot v26.4s, v25.16b, v0.4b[1]\n"
                    ".inst 0x6f94e31f // udot v31.4s, v24.16b, v20.4b[0]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa4e33b // udot v27.4s, v25.16b, v4.4b[1]\n"
                    ".inst 0x6fa8e33c // udot v28.4s, v25.16b, v8.4b[1]\n"
                    ".inst 0x6face33d // udot v29.4s, v25.16b, v12.4b[1]\n"
                    ".inst 0x6fb0e33e // udot v30.4s, v25.16b, v16.4b[1]\n"
                    ".inst 0x6fb4e33f // udot v31.4s, v25.16b, v20.4b[1]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f80eb1a // udot v26.4s, v24.16b, v0.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f84eb1b // udot v27.4s, v24.16b, v4.4b[2]\n"
                    ".inst 0x6f88eb1c // udot v28.4s, v24.16b, v8.4b[2]\n"
                    ".inst 0x6f8ceb1d // udot v29.4s, v24.16b, v12.4b[2]\n"
                    ".inst 0x6f90eb1e // udot v30.4s, v24.16b, v16.4b[2]\n"
                    ".inst 0x6f94eb1f // udot v31.4s, v24.16b, v20.4b[2]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa0eb3a // udot v26.4s, v25.16b, v0.4b[3]\n"
                    ".inst 0x6fa4eb3b // udot v27.4s, v25.16b, v4.4b[3]\n"
                    ".inst 0x6fa8eb3c // udot v28.4s, v25.16b, v8.4b[3]\n"
                    ".inst 0x6faceb3d // udot v29.4s, v25.16b, v12.4b[3]\n"
                    ".inst 0x6fb0eb3e // udot v30.4s, v25.16b, v16.4b[3]\n"
                    ".inst 0x6fb4eb3f // udot v31.4s, v25.16b, v20.4b[3]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f81e31a // udot v26.4s, v24.16b, v1.4b[0]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f85e31b // udot v27.4s, v24.16b, v5.4b[0]\n"
                    ".inst 0x6f89e31c // udot v28.4s, v24.16b, v9.4b[0]\n"
                    ".inst 0x6f8de31d // udot v29.4s, v24.16b, v13.4b[0]\n"
                    ".inst 0x6f91e31e // udot v30.4s, v24.16b, v17.4b[0]\n"
                    ".inst 0x6f95e31f // udot v31.4s, v24.16b, v21.4b[0]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa1e33a // udot v26.4s, v25.16b, v1.4b[1]\n"
                    ".inst 0x6fa5e33b // udot v27.4s, v25.16b, v5.4b[1]\n"
                    ".inst 0x6fa9e33c // udot v28.4s, v25.16b, v9.4b[1]\n"
                    ".inst 0x6fade33d // udot v29.4s, v25.16b, v13.4b[1]\n"
                    ".inst 0x6fb1e33e // udot v30.4s, v25.16b, v17.4b[1]\n"
                    ".inst 0x6fb5e33f // udot v31.4s, v25.16b, v21.4b[1]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f81eb1a // udot v26.4s, v24.16b, v1.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f85eb1b // udot v27.4s, v24.16b, v5.4b[2]\n"
                    ".inst 0x6f89eb1c // udot v28.4s, v24.16b, v9.4b[2]\n"
                    ".inst 0x6f8deb1d // udot v29.4s, v24.16b, v13.4b[2]\n"
                    ".inst 0x6f91eb1e // udot v30.4s, v24.16b, v17.4b[2]\n"
                    ".inst 0x6f95eb1f // udot v31.4s, v24.16b, v21.4b[2]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa1eb3a // udot v26.4s, v25.16b, v1.4b[3]\n"
                    ".inst 0x6fa5eb3b // udot v27.4s, v25.16b, v5.4b[3]\n"
                    ".inst 0x6fa9eb3c // udot v28.4s, v25.16b, v9.4b[3]\n"
                    ".inst 0x6fadeb3d // udot v29.4s, v25.16b, v13.4b[3]\n"
                    ".inst 0x6fb1eb3e // udot v30.4s, v25.16b, v17.4b[3]\n"
                    ".inst 0x6fb5eb3f // udot v31.4s, v25.16b, v21.4b[3]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f82e31a // udot v26.4s, v24.16b, v2.4b[0]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f86e31b // udot v27.4s, v24.16b, v6.4b[0]\n"
                    ".inst 0x6f8ae31c // udot v28.4s, v24.16b, v10.4b[0]\n"
                    ".inst 0x6f8ee31d // udot v29.4s, v24.16b, v14.4b[0]\n"
                    ".inst 0x6f92e31e // udot v30.4s, v24.16b, v18.4b[0]\n"
                    ".inst 0x6f96e31f // udot v31.4s, v24.16b, v22.4b[0]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa2e33a // udot v26.4s, v25.16b, v2.4b[1]\n"
                    ".inst 0x6fa6e33b // udot v27.4s, v25.16b, v6.4b[1]\n"
                    ".inst 0x6faae33c // udot v28.4s, v25.16b, v10.4b[1]\n"
                    ".inst 0x6faee33d // udot v29.4s, v25.16b, v14.4b[1]\n"
                    ".inst 0x6fb2e33e // udot v30.4s, v25.16b, v18.4b[1]\n"
                    ".inst 0x6fb6e33f // udot v31.4s, v25.16b, v22.4b[1]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f82eb1a // udot v26.4s, v24.16b, v2.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f86eb1b // udot v27.4s, v24.16b, v6.4b[2]\n"
                    ".inst 0x6f8aeb1c // udot v28.4s, v24.16b, v10.4b[2]\n"
                    ".inst 0x6f8eeb1d // udot v29.4s, v24.16b, v14.4b[2]\n"
                    ".inst 0x6f92eb1e // udot v30.4s, v24.16b, v18.4b[2]\n"
                    ".inst 0x6f96eb1f // udot v31.4s, v24.16b, v22.4b[2]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa2eb3a // udot v26.4s, v25.16b, v2.4b[3]\n"
                    ".inst 0x6fa6eb3b // udot v27.4s, v25.16b, v6.4b[3]\n"
                    ".inst 0x6faaeb3c // udot v28.4s, v25.16b, v10.4b[3]\n"
                    ".inst 0x6faeeb3d // udot v29.4s, v25.16b, v14.4b[3]\n"
                    ".inst 0x6fb2eb3e // udot v30.4s, v25.16b, v18.4b[3]\n"
                    ".inst 0x6fb6eb3f // udot v31.4s, v25.16b, v22.4b[3]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f83e31a // udot v26.4s, v24.16b, v3.4b[0]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f87e31b // udot v27.4s, v24.16b, v7.4b[0]\n"
                    ".inst 0x6f8be31c // udot v28.4s, v24.16b, v11.4b[0]\n"
                    ".inst 0x6f8fe31d // udot v29.4s, v24.16b, v15.4b[0]\n"
                    ".inst 0x6f93e31e // udot v30.4s, v24.16b, v19.4b[0]\n"
                    ".inst 0x6f97e31f // udot v31.4s, v24.16b, v23.4b[0]\n"
                    ".inst 0x6fa3e33a // udot v26.4s, v25.16b, v3.4b[1]\n"
                    ".inst 0x6fa7e33b // udot v27.4s, v25.16b, v7.4b[1]\n"
                    ".inst 0x6fabe33c // udot v28.4s, v25.16b, v11.4b[1]\n"
                    ".inst 0x6fafe33d // udot v29.4s, v25.16b, v15.4b[1]\n"
                    ".inst 0x6fb3e33e // udot v30.4s, v25.16b, v19.4b[1]\n"
                    ".inst 0x6fb7e33f // udot v31.4s, v25.16b, v23.4b[1]\n"
                    "b 9f\n"
                    "6:\n"
                    "movi v26.4s, #0\n"
                    "movi v27.4s, #0\n"
                    "movi v28.4s, #0\n"
                    "movi v29.4s, #0\n"
                    "movi v30.4s, #0\n"
                    "movi v31.4s, #0\n"
                    ".inst 0x6f80e31a // udot v26.4s, v24.16b, v0.4b[0]\n"
                    ".inst 0x6f84e31b // udot v27.4s, v24.16b, v4.4b[0]\n"
                    ".inst 0x6f88e31c // udot v28.4s, v24.16b, v8.4b[0]\n"
                    ".inst 0x6f8ce31d // udot v29.4s, v24.16b, v12.4b[0]\n"
                    ".inst 0x6f90e31e // udot v30.4s, v24.16b, v16.4b[0]\n"
                    ".inst 0x6f94e31f // udot v31.4s, v24.16b, v20.4b[0]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa0e33a // udot v26.4s, v25.16b, v0.4b[1]\n"
                    ".inst 0x6fa4e33b // udot v27.4s, v25.16b, v4.4b[1]\n"
                    ".inst 0x6fa8e33c // udot v28.4s, v25.16b, v8.4b[1]\n"
                    ".inst 0x6face33d // udot v29.4s, v25.16b, v12.4b[1]\n"
                    ".inst 0x6fb0e33e // udot v30.4s, v25.16b, v16.4b[1]\n"
                    ".inst 0x6fb4e33f // udot v31.4s, v25.16b, v20.4b[1]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f80eb1a // udot v26.4s, v24.16b, v0.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f84eb1b // udot v27.4s, v24.16b, v4.4b[2]\n"
                    ".inst 0x6f88eb1c // udot v28.4s, v24.16b, v8.4b[2]\n"
                    ".inst 0x6f8ceb1d // udot v29.4s, v24.16b, v12.4b[2]\n"
                    ".inst 0x6f90eb1e // udot v30.4s, v24.16b, v16.4b[2]\n"
                    ".inst 0x6f94eb1f // udot v31.4s, v24.16b, v20.4b[2]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa0eb3a // udot v26.4s, v25.16b, v0.4b[3]\n"
                    ".inst 0x6fa4eb3b // udot v27.4s, v25.16b, v4.4b[3]\n"
                    ".inst 0x6fa8eb3c // udot v28.4s, v25.16b, v8.4b[3]\n"
                    ".inst 0x6faceb3d // udot v29.4s, v25.16b, v12.4b[3]\n"
                    ".inst 0x6fb0eb3e // udot v30.4s, v25.16b, v16.4b[3]\n"
                    ".inst 0x6fb4eb3f // udot v31.4s, v25.16b, v20.4b[3]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f81e31a // udot v26.4s, v24.16b, v1.4b[0]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f85e31b // udot v27.4s, v24.16b, v5.4b[0]\n"
                    ".inst 0x6f89e31c // udot v28.4s, v24.16b, v9.4b[0]\n"
                    ".inst 0x6f8de31d // udot v29.4s, v24.16b, v13.4b[0]\n"
                    ".inst 0x6f91e31e // udot v30.4s, v24.16b, v17.4b[0]\n"
                    ".inst 0x6f95e31f // udot v31.4s, v24.16b, v21.4b[0]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa1e33a // udot v26.4s, v25.16b, v1.4b[1]\n"
                    ".inst 0x6fa5e33b // udot v27.4s, v25.16b, v5.4b[1]\n"
                    ".inst 0x6fa9e33c // udot v28.4s, v25.16b, v9.4b[1]\n"
                    ".inst 0x6fade33d // udot v29.4s, v25.16b, v13.4b[1]\n"
                    ".inst 0x6fb1e33e // udot v30.4s, v25.16b, v17.4b[1]\n"
                    ".inst 0x6fb5e33f // udot v31.4s, v25.16b, v21.4b[1]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f81eb1a // udot v26.4s, v24.16b, v1.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f85eb1b // udot v27.4s, v24.16b, v5.4b[2]\n"
                    ".inst 0x6f89eb1c // udot v28.4s, v24.16b, v9.4b[2]\n"
                    ".inst 0x6f8deb1d // udot v29.4s, v24.16b, v13.4b[2]\n"
                    ".inst 0x6f91eb1e // udot v30.4s, v24.16b, v17.4b[2]\n"
                    ".inst 0x6f95eb1f // udot v31.4s, v24.16b, v21.4b[2]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa1eb3a // udot v26.4s, v25.16b, v1.4b[3]\n"
                    ".inst 0x6fa5eb3b // udot v27.4s, v25.16b, v5.4b[3]\n"
                    ".inst 0x6fa9eb3c // udot v28.4s, v25.16b, v9.4b[3]\n"
                    ".inst 0x6fadeb3d // udot v29.4s, v25.16b, v13.4b[3]\n"
                    ".inst 0x6fb1eb3e // udot v30.4s, v25.16b, v17.4b[3]\n"
                    ".inst 0x6fb5eb3f // udot v31.4s, v25.16b, v21.4b[3]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f82e31a // udot v26.4s, v24.16b, v2.4b[0]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f86e31b // udot v27.4s, v24.16b, v6.4b[0]\n"
                    ".inst 0x6f8ae31c // udot v28.4s, v24.16b, v10.4b[0]\n"
                    ".inst 0x6f8ee31d // udot v29.4s, v24.16b, v14.4b[0]\n"
                    ".inst 0x6f92e31e // udot v30.4s, v24.16b, v18.4b[0]\n"
                    ".inst 0x6f96e31f // udot v31.4s, v24.16b, v22.4b[0]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa2e33a // udot v26.4s, v25.16b, v2.4b[1]\n"
                    ".inst 0x6fa6e33b // udot v27.4s, v25.16b, v6.4b[1]\n"
                    ".inst 0x6faae33c // udot v28.4s, v25.16b, v10.4b[1]\n"
                    ".inst 0x6faee33d // udot v29.4s, v25.16b, v14.4b[1]\n"
                    ".inst 0x6fb2e33e // udot v30.4s, v25.16b, v18.4b[1]\n"
                    ".inst 0x6fb6e33f // udot v31.4s, v25.16b, v22.4b[1]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f82eb1a // udot v26.4s, v24.16b, v2.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f86eb1b // udot v27.4s, v24.16b, v6.4b[2]\n"
                    ".inst 0x6f8aeb1c // udot v28.4s, v24.16b, v10.4b[2]\n"
                    ".inst 0x6f8eeb1d // udot v29.4s, v24.16b, v14.4b[2]\n"
                    ".inst 0x6f92eb1e // udot v30.4s, v24.16b, v18.4b[2]\n"
                    ".inst 0x6f96eb1f // udot v31.4s, v24.16b, v22.4b[2]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa2eb3a // udot v26.4s, v25.16b, v2.4b[3]\n"
                    ".inst 0x6fa6eb3b // udot v27.4s, v25.16b, v6.4b[3]\n"
                    ".inst 0x6faaeb3c // udot v28.4s, v25.16b, v10.4b[3]\n"
                    ".inst 0x6faeeb3d // udot v29.4s, v25.16b, v14.4b[3]\n"
                    ".inst 0x6fb2eb3e // udot v30.4s, v25.16b, v18.4b[3]\n"
                    ".inst 0x6fb6eb3f // udot v31.4s, v25.16b, v22.4b[3]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f83e31a // udot v26.4s, v24.16b, v3.4b[0]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f87e31b // udot v27.4s, v24.16b, v7.4b[0]\n"
                    ".inst 0x6f8be31c // udot v28.4s, v24.16b, v11.4b[0]\n"
                    ".inst 0x6f8fe31d // udot v29.4s, v24.16b, v15.4b[0]\n"
                    ".inst 0x6f93e31e // udot v30.4s, v24.16b, v19.4b[0]\n"
                    ".inst 0x6f97e31f // udot v31.4s, v24.16b, v23.4b[0]\n"
                    ".inst 0x6fa3e33a // udot v26.4s, v25.16b, v3.4b[1]\n"
                    ".inst 0x6fa7e33b // udot v27.4s, v25.16b, v7.4b[1]\n"
                    ".inst 0x6fabe33c // udot v28.4s, v25.16b, v11.4b[1]\n"
                    ".inst 0x6fafe33d // udot v29.4s, v25.16b, v15.4b[1]\n"
                    ".inst 0x6fb3e33e // udot v30.4s, v25.16b, v19.4b[1]\n"
                    ".inst 0x6fb7e33f // udot v31.4s, v25.16b, v23.4b[1]\n"
                    "9:\n"
                    "str q26, [%[c_ptr0]]\n"
                    "add %[c_ptr0], %[c_ptr0], #0x10\n"
                    "str q27, [c_ptr1]\n"
                    "str q28, [c_ptr2]\n"
                    "str q29, [c_ptr3]\n"
                    "str q30, [c_ptr4]\n"
                    "str q31, [c_ptr5]\n"
                    ".unreq a_ptr1\n"
                    ".unreq a_ptr2\n"
                    ".unreq a_ptr3\n"
                    ".unreq a_ptr4\n"
                    ".unreq a_ptr5\n"
                    ".unreq c_ptr1\n"
                    ".unreq c_ptr2\n"
                    ".unreq c_ptr3\n"
                    ".unreq c_ptr4\n"
                    ".unreq c_ptr5\n"
                    ".unreq temploadreg0\n"
                    ".unreq temploadreg1\n"
                    ".unreq temploadreg2\n"
                    ".unreq temploadreg3\n"
                    : [a_ptr0] "+r" (a_ptr0), [b_ptr0] "+r" (b_ptr0), [c_ptr0] "+r" (c_ptr0), [loops] "+r" (loops), [oob_rows] "+r" (oob_rows), [odds] "+r" (odds)
                    : [lda] "r" (ldab), [ldc] "r" (ldcb)
                    : "x0", "x1", "x2", "x3", "x4", "x5", "x6", "x7", "x8", "x9", "x10", "x11", "x12", "x13", "v0", "v1", "v2", "v3", "v4", "v5", "v6", "v7", "v8", "v9", "v10", "v11", "v12", "v13", "v14", "v15", "v16", "v17", "v18", "v19", "v20", "v21", "v22", "v23", "v24", "v25", "v26", "v27", "v28", "v29", "v30", "v31", "cc", "memory"
                );
                break;
            case 15:
                __asm __volatile (
                    "a_ptr1 .req X0\n"
                    "a_ptr2 .req X1\n"
                    "a_ptr3 .req X2\n"
                    "a_ptr4 .req X3\n"
                    "a_ptr5 .req X4\n"
                    "c_ptr1 .req X5\n"
                    "c_ptr2 .req X6\n"
                    "c_ptr3 .req X7\n"
                    "c_ptr4 .req X8\n"
                    "c_ptr5 .req X9\n"
                    "temploadreg0 .req X10\n"
                    "temploadreg1 .req X11\n"
                    "temploadreg2 .req X12\n"
                    "temploadreg3 .req X13\n"
                    "add a_ptr1, %[a_ptr0], %[lda]\n"
                    "add c_ptr1, %[c_ptr0], %[ldc]\n"
                    "add a_ptr2, a_ptr1, %[lda]\n"
                    "add c_ptr2, c_ptr1, %[ldc]\n"
                    "add a_ptr3, a_ptr2, %[lda]\n"
                    "add c_ptr3, c_ptr2, %[ldc]\n"
                    "add a_ptr4, a_ptr3, %[lda]\n"
                    "add c_ptr4, c_ptr3, %[ldc]\n"
                    "add a_ptr5, a_ptr4, %[lda]\n"
                    "add c_ptr5, c_ptr4, %[ldc]\n"
                    "cbz %[oob_rows], 1f\n"
                    "subs %[oob_rows], %[oob_rows], #0x1\n"
                    "add c_ptr5, %[c_ptr0], #0x0\n"
                    "add a_ptr5, %[a_ptr0], #0x0\n"
                    "b.eq 1f\n"
                    "subs %[oob_rows], %[oob_rows], #0x1\n"
                    "add c_ptr4, %[c_ptr0], #0x0\n"
                    "add a_ptr4, %[a_ptr0], #0x0\n"
                    "b.eq 1f\n"
                    "subs %[oob_rows], %[oob_rows], #0x1\n"
                    "add c_ptr3, %[c_ptr0], #0x0\n"
                    "add a_ptr3, %[a_ptr0], #0x0\n"
                    "b.eq 1f\n"
                    "subs %[oob_rows], %[oob_rows], #0x1\n"
                    "add c_ptr2, %[c_ptr0], #0x0\n"
                    "add a_ptr2, %[a_ptr0], #0x0\n"
                    "b.eq 1f\n"
                    "subs %[oob_rows], %[oob_rows], #0x1\n"
                    "add c_ptr1, %[c_ptr0], #0x0\n"
                    "add a_ptr1, %[a_ptr0], #0x0\n"
                    "1:\n"
                    "ldr q0, [%[a_ptr0]], #0x10\n"
                    "ldr q4, [a_ptr1], #0x10\n"
                    "ldr q8, [a_ptr2], #0x10\n"
                    "ldr q12, [a_ptr3], #0x10\n"
                    "ldr q16, [a_ptr4], #0x10\n"
                    "ldr q20, [a_ptr5], #0x10\n"
                    "ldr q1, [%[a_ptr0]], #0x10\n"
                    "ldr q5, [a_ptr1], #0x10\n"
                    "ldr q9, [a_ptr2], #0x10\n"
                    "ldr q13, [a_ptr3], #0x10\n"
                    "ldr q17, [a_ptr4], #0x10\n"
                    "ldr q21, [a_ptr5], #0x10\n"
                    "ldr q2, [%[a_ptr0]], #0x10\n"
                    "ldr q6, [a_ptr1], #0x10\n"
                    "ldr q10, [a_ptr2], #0x10\n"
                    "ldr q14, [a_ptr3], #0x10\n"
                    "ldr d3, [%[a_ptr0]], #0x8\n"
                    "ldr q18, [a_ptr4], #0x10\n"
                    "ldr d7, [a_ptr1], #0x8\n"
                    "ldr q22, [a_ptr5], #0x10\n"
                    "ldr d11, [a_ptr2], #0x8\n"
                    "ldr d15, [a_ptr3], #0x8\n"
                    "ldr d19, [a_ptr4], #0x8\n"
                    "ldr d23, [a_ptr5], #0x8\n"
                    "cbnz %[odds], 2f\n"
                    "ld1 {v3.s}[2], [%[a_ptr0]]\n"
                    "ld1 {v7.s}[2], [a_ptr1]\n"
                    "ld1 {v11.s}[2], [a_ptr2]\n"
                    "ld1 {v15.s}[2], [a_ptr3]\n"
                    "ld1 {v19.s}[2], [a_ptr4]\n"
                    "ld1 {v23.s}[2], [a_ptr5]\n"
                    "b 3f\n"
                    "2:\n"
                    "subs %[odds], %[odds], #0x1\n"
                    "b.ne 4f\n"
                    "ld1 {v3.b}[8], [%[a_ptr0]]\n"
                    "ld1 {v7.b}[8], [a_ptr1]\n"
                    "ld1 {v11.b}[8], [a_ptr2]\n"
                    "ld1 {v15.b}[8], [a_ptr3]\n"
                    "ld1 {v19.b}[8], [a_ptr4]\n"
                    "ld1 {v23.b}[8], [a_ptr5]\n"
                    "b 3f\n"
                    "4:\n"
                    "ld1 {v3.h}[4], [%[a_ptr0]], #2\n"
                    "ld1 {v7.h}[4], [a_ptr1], #2\n"
                    "ld1 {v11.h}[4], [a_ptr2], #2\n"
                    "ld1 {v15.h}[4], [a_ptr3], #2\n"
                    "ld1 {v19.h}[4], [a_ptr4], #2\n"
                    "ld1 {v23.h}[4], [a_ptr5], #2\n"
                    "subs %[odds], %[odds], #0x1\n"
                    "b.ne 5f\n"
                    "b 3f\n"
                    "5:\n"
                    "ld1 {v3.b}[10], [%[a_ptr0]]\n"
                    "ld1 {v7.b}[10], [a_ptr1]\n"
                    "ld1 {v11.b}[10], [a_ptr2]\n"
                    "ld1 {v15.b}[10], [a_ptr3]\n"
                    "ld1 {v19.b}[10], [a_ptr4]\n"
                    "ld1 {v23.b}[10], [a_ptr5]\n"
                    "3:\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    "prfm PLDL1KEEP, [a_ptr5, #0x40]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    "prfm PLDL1KEEP, [a_ptr5, #0x80]\n"
                    "prfm PLDL1KEEP, [a_ptr5, #0xc0]\n"
                    "prfm PLDL1KEEP, [a_ptr5, #0x100]\n"
                    "prfm PLDL1KEEP, [a_ptr5, #0x140]\n"
                    "prfm PLDL1KEEP, [a_ptr5, #0x180]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    "cbz %[loops], 6f\n"
                    "movi v26.4s, #0\n"
                    "subs %[loops], %[loops], #0x1\n"
                    "movi v27.4s, #0\n"
                    "movi v28.4s, #0\n"
                    "movi v29.4s, #0\n"
                    "movi v30.4s, #0\n"
                    "movi v31.4s, #0\n"
                    ".inst 0x6f80e31a // udot v26.4s, v24.16b, v0.4b[0]\n"
                    ".inst 0x6f84e31b // udot v27.4s, v24.16b, v4.4b[0]\n"
                    ".inst 0x6f88e31c // udot v28.4s, v24.16b, v8.4b[0]\n"
                    ".inst 0x6f8ce31d // udot v29.4s, v24.16b, v12.4b[0]\n"
                    ".inst 0x6f90e31e // udot v30.4s, v24.16b, v16.4b[0]\n"
                    ".inst 0x6f94e31f // udot v31.4s, v24.16b, v20.4b[0]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa0e33a // udot v26.4s, v25.16b, v0.4b[1]\n"
                    ".inst 0x6fa4e33b // udot v27.4s, v25.16b, v4.4b[1]\n"
                    ".inst 0x6fa8e33c // udot v28.4s, v25.16b, v8.4b[1]\n"
                    ".inst 0x6face33d // udot v29.4s, v25.16b, v12.4b[1]\n"
                    ".inst 0x6fb0e33e // udot v30.4s, v25.16b, v16.4b[1]\n"
                    ".inst 0x6fb4e33f // udot v31.4s, v25.16b, v20.4b[1]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f80eb1a // udot v26.4s, v24.16b, v0.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f84eb1b // udot v27.4s, v24.16b, v4.4b[2]\n"
                    ".inst 0x6f88eb1c // udot v28.4s, v24.16b, v8.4b[2]\n"
                    ".inst 0x6f8ceb1d // udot v29.4s, v24.16b, v12.4b[2]\n"
                    ".inst 0x6f90eb1e // udot v30.4s, v24.16b, v16.4b[2]\n"
                    ".inst 0x6f94eb1f // udot v31.4s, v24.16b, v20.4b[2]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa0eb3a // udot v26.4s, v25.16b, v0.4b[3]\n"
                    ".inst 0x6fa4eb3b // udot v27.4s, v25.16b, v4.4b[3]\n"
                    ".inst 0x6fa8eb3c // udot v28.4s, v25.16b, v8.4b[3]\n"
                    ".inst 0x6faceb3d // udot v29.4s, v25.16b, v12.4b[3]\n"
                    ".inst 0x6fb0eb3e // udot v30.4s, v25.16b, v16.4b[3]\n"
                    ".inst 0x6fb4eb3f // udot v31.4s, v25.16b, v20.4b[3]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f81e31a // udot v26.4s, v24.16b, v1.4b[0]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f85e31b // udot v27.4s, v24.16b, v5.4b[0]\n"
                    ".inst 0x6f89e31c // udot v28.4s, v24.16b, v9.4b[0]\n"
                    ".inst 0x6f8de31d // udot v29.4s, v24.16b, v13.4b[0]\n"
                    ".inst 0x6f91e31e // udot v30.4s, v24.16b, v17.4b[0]\n"
                    ".inst 0x6f95e31f // udot v31.4s, v24.16b, v21.4b[0]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa1e33a // udot v26.4s, v25.16b, v1.4b[1]\n"
                    ".inst 0x6fa5e33b // udot v27.4s, v25.16b, v5.4b[1]\n"
                    ".inst 0x6fa9e33c // udot v28.4s, v25.16b, v9.4b[1]\n"
                    ".inst 0x6fade33d // udot v29.4s, v25.16b, v13.4b[1]\n"
                    ".inst 0x6fb1e33e // udot v30.4s, v25.16b, v17.4b[1]\n"
                    ".inst 0x6fb5e33f // udot v31.4s, v25.16b, v21.4b[1]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f81eb1a // udot v26.4s, v24.16b, v1.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f85eb1b // udot v27.4s, v24.16b, v5.4b[2]\n"
                    ".inst 0x6f89eb1c // udot v28.4s, v24.16b, v9.4b[2]\n"
                    ".inst 0x6f8deb1d // udot v29.4s, v24.16b, v13.4b[2]\n"
                    ".inst 0x6f91eb1e // udot v30.4s, v24.16b, v17.4b[2]\n"
                    ".inst 0x6f95eb1f // udot v31.4s, v24.16b, v21.4b[2]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa1eb3a // udot v26.4s, v25.16b, v1.4b[3]\n"
                    ".inst 0x6fa5eb3b // udot v27.4s, v25.16b, v5.4b[3]\n"
                    ".inst 0x6fa9eb3c // udot v28.4s, v25.16b, v9.4b[3]\n"
                    ".inst 0x6fadeb3d // udot v29.4s, v25.16b, v13.4b[3]\n"
                    ".inst 0x6fb1eb3e // udot v30.4s, v25.16b, v17.4b[3]\n"
                    ".inst 0x6fb5eb3f // udot v31.4s, v25.16b, v21.4b[3]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f82e31a // udot v26.4s, v24.16b, v2.4b[0]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f86e31b // udot v27.4s, v24.16b, v6.4b[0]\n"
                    ".inst 0x6f8ae31c // udot v28.4s, v24.16b, v10.4b[0]\n"
                    ".inst 0x6f8ee31d // udot v29.4s, v24.16b, v14.4b[0]\n"
                    ".inst 0x6f92e31e // udot v30.4s, v24.16b, v18.4b[0]\n"
                    ".inst 0x6f96e31f // udot v31.4s, v24.16b, v22.4b[0]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa2e33a // udot v26.4s, v25.16b, v2.4b[1]\n"
                    ".inst 0x6fa6e33b // udot v27.4s, v25.16b, v6.4b[1]\n"
                    ".inst 0x6faae33c // udot v28.4s, v25.16b, v10.4b[1]\n"
                    ".inst 0x6faee33d // udot v29.4s, v25.16b, v14.4b[1]\n"
                    ".inst 0x6fb2e33e // udot v30.4s, v25.16b, v18.4b[1]\n"
                    ".inst 0x6fb6e33f // udot v31.4s, v25.16b, v22.4b[1]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f82eb1a // udot v26.4s, v24.16b, v2.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f86eb1b // udot v27.4s, v24.16b, v6.4b[2]\n"
                    ".inst 0x6f8aeb1c // udot v28.4s, v24.16b, v10.4b[2]\n"
                    ".inst 0x6f8eeb1d // udot v29.4s, v24.16b, v14.4b[2]\n"
                    ".inst 0x6f92eb1e // udot v30.4s, v24.16b, v18.4b[2]\n"
                    ".inst 0x6f96eb1f // udot v31.4s, v24.16b, v22.4b[2]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa2eb3a // udot v26.4s, v25.16b, v2.4b[3]\n"
                    ".inst 0x6fa6eb3b // udot v27.4s, v25.16b, v6.4b[3]\n"
                    ".inst 0x6faaeb3c // udot v28.4s, v25.16b, v10.4b[3]\n"
                    ".inst 0x6faeeb3d // udot v29.4s, v25.16b, v14.4b[3]\n"
                    ".inst 0x6fb2eb3e // udot v30.4s, v25.16b, v18.4b[3]\n"
                    ".inst 0x6fb6eb3f // udot v31.4s, v25.16b, v22.4b[3]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f83e31a // udot v26.4s, v24.16b, v3.4b[0]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f87e31b // udot v27.4s, v24.16b, v7.4b[0]\n"
                    ".inst 0x6f8be31c // udot v28.4s, v24.16b, v11.4b[0]\n"
                    ".inst 0x6f8fe31d // udot v29.4s, v24.16b, v15.4b[0]\n"
                    ".inst 0x6f93e31e // udot v30.4s, v24.16b, v19.4b[0]\n"
                    ".inst 0x6f97e31f // udot v31.4s, v24.16b, v23.4b[0]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa3e33a // udot v26.4s, v25.16b, v3.4b[1]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x10\n"
                    ".inst 0x6fa7e33b // udot v27.4s, v25.16b, v7.4b[1]\n"
                    ".inst 0x6fabe33c // udot v28.4s, v25.16b, v11.4b[1]\n"
                    ".inst 0x6fafe33d // udot v29.4s, v25.16b, v15.4b[1]\n"
                    ".inst 0x6fb3e33e // udot v30.4s, v25.16b, v19.4b[1]\n"
                    ".inst 0x6fb7e33f // udot v31.4s, v25.16b, v23.4b[1]\n"
                    ".inst 0x6f83eb1a // udot v26.4s, v24.16b, v3.4b[2]\n"
                    ".inst 0x6f87eb1b // udot v27.4s, v24.16b, v7.4b[2]\n"
                    ".inst 0x6f8beb1c // udot v28.4s, v24.16b, v11.4b[2]\n"
                    ".inst 0x6f8feb1d // udot v29.4s, v24.16b, v15.4b[2]\n"
                    ".inst 0x6f93eb1e // udot v30.4s, v24.16b, v19.4b[2]\n"
                    ".inst 0x6f97eb1f // udot v31.4s, v24.16b, v23.4b[2]\n"
                    "b.eq 7f\n"
                    "8:\n"
                    "str q26, [%[c_ptr0]]\n"
                    "subs %[loops], %[loops], #0x1\n"
                    "movi v26.4s, #0\n"
                    "ldr d24, [%[b_ptr0]]\n"
                    "ldr temploadreg0, [%[b_ptr0], #0x8]\n"
                    "add %[c_ptr0], %[c_ptr0], #0x10\n"
                    "str q27, [c_ptr1]\n"
                    "add c_ptr1, c_ptr1, #0x10\n"
                    "movi v27.4s, #0\n"
                    "ldr d25, [%[b_ptr0], #0x10]\n"
                    "ldr temploadreg1, [%[b_ptr0], #0x18]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    "str q28, [c_ptr2]\n"
                    "add c_ptr2, c_ptr2, #0x10\n"
                    "movi v28.4s, #0\n"
                    "ins v24.d[1], temploadreg0\n"
                    "ins v25.d[1], temploadreg1\n"
                    "prfm PSTL1KEEP, [%[c_ptr0], #0x40]\n"
                    "str q29, [c_ptr3]\n"
                    "add c_ptr3, c_ptr3, #0x10\n"
                    "movi v29.4s, #0\n"
                    "ldr temploadreg0, [%[b_ptr0], #0x8]\n"
                    ".inst 0x6f80e31a // udot v26.4s, v24.16b, v0.4b[0]\n"
                    "str q30, [c_ptr4]\n"
                    "movi v30.4s, #0\n"
                    "ldr temploadreg1, [%[b_ptr0], #0x18]\n"
                    ".inst 0x6f84e31b // udot v27.4s, v24.16b, v4.4b[0]\n"
                    "add c_ptr4, c_ptr4, #0x10\n"
                    ".inst 0x6f88e31c // udot v28.4s, v24.16b, v8.4b[0]\n"
                    "str q31, [c_ptr5]\n"
                    "movi v31.4s, #0\n"
                    "add c_ptr5, c_ptr5, #0x10\n"
                    ".inst 0x6f8ce31d // udot v29.4s, v24.16b, v12.4b[0]\n"
                    "prfm PSTL1KEEP, [c_ptr1, #0x40]\n"
                    ".inst 0x6f90e31e // udot v30.4s, v24.16b, v16.4b[0]\n"
                    "prfm PSTL1KEEP, [c_ptr2, #0x40]\n"
                    ".inst 0x6f94e31f // udot v31.4s, v24.16b, v20.4b[0]\n"
                    "ldr d24, [%[b_ptr0]]\n"
                    ".inst 0x6fa0e33a // udot v26.4s, v25.16b, v0.4b[1]\n"
                    "prfm PSTL1KEEP, [c_ptr3, #0x40]\n"
                    ".inst 0x6fa4e33b // udot v27.4s, v25.16b, v4.4b[1]\n"
                    "ins v24.d[1], temploadreg0\n"
                    ".inst 0x6fa8e33c // udot v28.4s, v25.16b, v8.4b[1]\n"
                    "prfm PSTL1KEEP, [c_ptr4, #0x40]\n"
                    ".inst 0x6face33d // udot v29.4s, v25.16b, v12.4b[1]\n"
                    "prfm PSTL1KEEP, [c_ptr5, #0x40]\n"
                    ".inst 0x6fb0e33e // udot v30.4s, v25.16b, v16.4b[1]\n"
                    ".inst 0x6fb4e33f // udot v31.4s, v25.16b, v20.4b[1]\n"
                    "ldr d25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f80eb1a // udot v26.4s, v24.16b, v0.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f84eb1b // udot v27.4s, v24.16b, v4.4b[2]\n"
                    "ins v25.d[1], temploadreg1\n"
                    ".inst 0x6f88eb1c // udot v28.4s, v24.16b, v8.4b[2]\n"
                    "ldr temploadreg0, [%[b_ptr0], #0x8]\n"
                    ".inst 0x6f8ceb1d // udot v29.4s, v24.16b, v12.4b[2]\n"
                    "ldr temploadreg1, [%[b_ptr0], #0x18]\n"
                    ".inst 0x6f90eb1e // udot v30.4s, v24.16b, v16.4b[2]\n"
                    ".inst 0x6f94eb1f // udot v31.4s, v24.16b, v20.4b[2]\n"
                    "ldr d24, [%[b_ptr0]]\n"
                    ".inst 0x6fa0eb3a // udot v26.4s, v25.16b, v0.4b[3]\n"
                    ".inst 0x6fa4eb3b // udot v27.4s, v25.16b, v4.4b[3]\n"
                    ".inst 0x6fa8eb3c // udot v28.4s, v25.16b, v8.4b[3]\n"
                    "ins v24.d[1], temploadreg0\n"
                    ".inst 0x6faceb3d // udot v29.4s, v25.16b, v12.4b[3]\n"
                    ".inst 0x6fb0eb3e // udot v30.4s, v25.16b, v16.4b[3]\n"
                    ".inst 0x6fb4eb3f // udot v31.4s, v25.16b, v20.4b[3]\n"
                    "ldr d25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f81e31a // udot v26.4s, v24.16b, v1.4b[0]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f85e31b // udot v27.4s, v24.16b, v5.4b[0]\n"
                    "ins v25.d[1], temploadreg1\n"
                    ".inst 0x6f89e31c // udot v28.4s, v24.16b, v9.4b[0]\n"
                    "ldr temploadreg0, [%[b_ptr0], #0x8]\n"
                    ".inst 0x6f8de31d // udot v29.4s, v24.16b, v13.4b[0]\n"
                    "ldr temploadreg1, [%[b_ptr0], #0x18]\n"
                    ".inst 0x6f91e31e // udot v30.4s, v24.16b, v17.4b[0]\n"
                    ".inst 0x6f95e31f // udot v31.4s, v24.16b, v21.4b[0]\n"
                    "ldr d24, [%[b_ptr0]]\n"
                    ".inst 0x6fa1e33a // udot v26.4s, v25.16b, v1.4b[1]\n"
                    ".inst 0x6fa5e33b // udot v27.4s, v25.16b, v5.4b[1]\n"
                    ".inst 0x6fa9e33c // udot v28.4s, v25.16b, v9.4b[1]\n"
                    "ins v24.d[1], temploadreg0\n"
                    ".inst 0x6fade33d // udot v29.4s, v25.16b, v13.4b[1]\n"
                    ".inst 0x6fb1e33e // udot v30.4s, v25.16b, v17.4b[1]\n"
                    ".inst 0x6fb5e33f // udot v31.4s, v25.16b, v21.4b[1]\n"
                    "ldr d25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f81eb1a // udot v26.4s, v24.16b, v1.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f85eb1b // udot v27.4s, v24.16b, v5.4b[2]\n"
                    "ins v25.d[1], temploadreg1\n"
                    ".inst 0x6f89eb1c // udot v28.4s, v24.16b, v9.4b[2]\n"
                    "ldr temploadreg0, [%[b_ptr0], #0x8]\n"
                    ".inst 0x6f8deb1d // udot v29.4s, v24.16b, v13.4b[2]\n"
                    "ldr temploadreg1, [%[b_ptr0], #0x18]\n"
                    ".inst 0x6f91eb1e // udot v30.4s, v24.16b, v17.4b[2]\n"
                    ".inst 0x6f95eb1f // udot v31.4s, v24.16b, v21.4b[2]\n"
                    "ldr d24, [%[b_ptr0]]\n"
                    ".inst 0x6fa1eb3a // udot v26.4s, v25.16b, v1.4b[3]\n"
                    ".inst 0x6fa5eb3b // udot v27.4s, v25.16b, v5.4b[3]\n"
                    ".inst 0x6fa9eb3c // udot v28.4s, v25.16b, v9.4b[3]\n"
                    "ins v24.d[1], temploadreg0\n"
                    ".inst 0x6fadeb3d // udot v29.4s, v25.16b, v13.4b[3]\n"
                    ".inst 0x6fb1eb3e // udot v30.4s, v25.16b, v17.4b[3]\n"
                    ".inst 0x6fb5eb3f // udot v31.4s, v25.16b, v21.4b[3]\n"
                    "ldr d25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f82e31a // udot v26.4s, v24.16b, v2.4b[0]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f86e31b // udot v27.4s, v24.16b, v6.4b[0]\n"
                    "ins v25.d[1], temploadreg1\n"
                    ".inst 0x6f8ae31c // udot v28.4s, v24.16b, v10.4b[0]\n"
                    "ldr temploadreg0, [%[b_ptr0], #0x8]\n"
                    ".inst 0x6f8ee31d // udot v29.4s, v24.16b, v14.4b[0]\n"
                    "ldr temploadreg1, [%[b_ptr0], #0x18]\n"
                    ".inst 0x6f92e31e // udot v30.4s, v24.16b, v18.4b[0]\n"
                    ".inst 0x6f96e31f // udot v31.4s, v24.16b, v22.4b[0]\n"
                    "ldr d24, [%[b_ptr0]]\n"
                    ".inst 0x6fa2e33a // udot v26.4s, v25.16b, v2.4b[1]\n"
                    ".inst 0x6fa6e33b // udot v27.4s, v25.16b, v6.4b[1]\n"
                    ".inst 0x6faae33c // udot v28.4s, v25.16b, v10.4b[1]\n"
                    "ins v24.d[1], temploadreg0\n"
                    ".inst 0x6faee33d // udot v29.4s, v25.16b, v14.4b[1]\n"
                    ".inst 0x6fb2e33e // udot v30.4s, v25.16b, v18.4b[1]\n"
                    ".inst 0x6fb6e33f // udot v31.4s, v25.16b, v22.4b[1]\n"
                    "ldr d25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f82eb1a // udot v26.4s, v24.16b, v2.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f86eb1b // udot v27.4s, v24.16b, v6.4b[2]\n"
                    "ins v25.d[1], temploadreg1\n"
                    ".inst 0x6f8aeb1c // udot v28.4s, v24.16b, v10.4b[2]\n"
                    "ldr temploadreg0, [%[b_ptr0], #0x8]\n"
                    ".inst 0x6f8eeb1d // udot v29.4s, v24.16b, v14.4b[2]\n"
                    "ldr temploadreg1, [%[b_ptr0], #0x18]\n"
                    ".inst 0x6f92eb1e // udot v30.4s, v24.16b, v18.4b[2]\n"
                    ".inst 0x6f96eb1f // udot v31.4s, v24.16b, v22.4b[2]\n"
                    "ldr d24, [%[b_ptr0]]\n"
                    ".inst 0x6fa2eb3a // udot v26.4s, v25.16b, v2.4b[3]\n"
                    ".inst 0x6fa6eb3b // udot v27.4s, v25.16b, v6.4b[3]\n"
                    ".inst 0x6faaeb3c // udot v28.4s, v25.16b, v10.4b[3]\n"
                    "ins v24.d[1], temploadreg0\n"
                    ".inst 0x6faeeb3d // udot v29.4s, v25.16b, v14.4b[3]\n"
                    ".inst 0x6fb2eb3e // udot v30.4s, v25.16b, v18.4b[3]\n"
                    ".inst 0x6fb6eb3f // udot v31.4s, v25.16b, v22.4b[3]\n"
                    "ldr d25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f83e31a // udot v26.4s, v24.16b, v3.4b[0]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f87e31b // udot v27.4s, v24.16b, v7.4b[0]\n"
                    "ins v25.d[1], temploadreg1\n"
                    ".inst 0x6f8be31c // udot v28.4s, v24.16b, v11.4b[0]\n"
                    "ldr temploadreg0, [%[b_ptr0], #0x8]\n"
                    ".inst 0x6f8fe31d // udot v29.4s, v24.16b, v15.4b[0]\n"
                    ".inst 0x6f93e31e // udot v30.4s, v24.16b, v19.4b[0]\n"
                    ".inst 0x6f97e31f // udot v31.4s, v24.16b, v23.4b[0]\n"
                    "ldr d24, [%[b_ptr0]]\n"
                    ".inst 0x6fa3e33a // udot v26.4s, v25.16b, v3.4b[1]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x10\n"
                    ".inst 0x6fa7e33b // udot v27.4s, v25.16b, v7.4b[1]\n"
                    "ins v24.d[1], temploadreg0\n"
                    ".inst 0x6fabe33c // udot v28.4s, v25.16b, v11.4b[1]\n"
                    ".inst 0x6fafe33d // udot v29.4s, v25.16b, v15.4b[1]\n"
                    ".inst 0x6fb3e33e // udot v30.4s, v25.16b, v19.4b[1]\n"
                    ".inst 0x6fb7e33f // udot v31.4s, v25.16b, v23.4b[1]\n"
                    ".inst 0x6f83eb1a // udot v26.4s, v24.16b, v3.4b[2]\n"
                    ".inst 0x6f87eb1b // udot v27.4s, v24.16b, v7.4b[2]\n"
                    ".inst 0x6f8beb1c // udot v28.4s, v24.16b, v11.4b[2]\n"
                    ".inst 0x6f8feb1d // udot v29.4s, v24.16b, v15.4b[2]\n"
                    ".inst 0x6f93eb1e // udot v30.4s, v24.16b, v19.4b[2]\n"
                    ".inst 0x6f97eb1f // udot v31.4s, v24.16b, v23.4b[2]\n"
                    "b.ne 8b\n"
                    "7:\n"
                    "str q26, [%[c_ptr0]]\n"
                    "add %[c_ptr0], %[c_ptr0], #0x10\n"
                    "movi v26.4s, #0\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    "str q27, [c_ptr1]\n"
                    "add c_ptr1, c_ptr1, #0x10\n"
                    "movi v27.4s, #0\n"
                    ".inst 0x6f80e31a // udot v26.4s, v24.16b, v0.4b[0]\n"
                    "str q28, [c_ptr2]\n"
                    "movi v28.4s, #0\n"
                    "add c_ptr2, c_ptr2, #0x10\n"
                    ".inst 0x6f84e31b // udot v27.4s, v24.16b, v4.4b[0]\n"
                    "str q29, [c_ptr3]\n"
                    "movi v29.4s, #0\n"
                    "add c_ptr3, c_ptr3, #0x10\n"
                    ".inst 0x6f88e31c // udot v28.4s, v24.16b, v8.4b[0]\n"
                    "str q30, [c_ptr4]\n"
                    "movi v30.4s, #0\n"
                    "add c_ptr4, c_ptr4, #0x10\n"
                    ".inst 0x6f8ce31d // udot v29.4s, v24.16b, v12.4b[0]\n"
                    "str q31, [c_ptr5]\n"
                    "movi v31.4s, #0\n"
                    "add c_ptr5, c_ptr5, #0x10\n"
                    ".inst 0x6f90e31e // udot v30.4s, v24.16b, v16.4b[0]\n"
                    ".inst 0x6fa0e33a // udot v26.4s, v25.16b, v0.4b[1]\n"
                    ".inst 0x6f94e31f // udot v31.4s, v24.16b, v20.4b[0]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa4e33b // udot v27.4s, v25.16b, v4.4b[1]\n"
                    ".inst 0x6fa8e33c // udot v28.4s, v25.16b, v8.4b[1]\n"
                    ".inst 0x6face33d // udot v29.4s, v25.16b, v12.4b[1]\n"
                    ".inst 0x6fb0e33e // udot v30.4s, v25.16b, v16.4b[1]\n"
                    ".inst 0x6fb4e33f // udot v31.4s, v25.16b, v20.4b[1]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f80eb1a // udot v26.4s, v24.16b, v0.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f84eb1b // udot v27.4s, v24.16b, v4.4b[2]\n"
                    ".inst 0x6f88eb1c // udot v28.4s, v24.16b, v8.4b[2]\n"
                    ".inst 0x6f8ceb1d // udot v29.4s, v24.16b, v12.4b[2]\n"
                    ".inst 0x6f90eb1e // udot v30.4s, v24.16b, v16.4b[2]\n"
                    ".inst 0x6f94eb1f // udot v31.4s, v24.16b, v20.4b[2]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa0eb3a // udot v26.4s, v25.16b, v0.4b[3]\n"
                    ".inst 0x6fa4eb3b // udot v27.4s, v25.16b, v4.4b[3]\n"
                    ".inst 0x6fa8eb3c // udot v28.4s, v25.16b, v8.4b[3]\n"
                    ".inst 0x6faceb3d // udot v29.4s, v25.16b, v12.4b[3]\n"
                    ".inst 0x6fb0eb3e // udot v30.4s, v25.16b, v16.4b[3]\n"
                    ".inst 0x6fb4eb3f // udot v31.4s, v25.16b, v20.4b[3]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f81e31a // udot v26.4s, v24.16b, v1.4b[0]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f85e31b // udot v27.4s, v24.16b, v5.4b[0]\n"
                    ".inst 0x6f89e31c // udot v28.4s, v24.16b, v9.4b[0]\n"
                    ".inst 0x6f8de31d // udot v29.4s, v24.16b, v13.4b[0]\n"
                    ".inst 0x6f91e31e // udot v30.4s, v24.16b, v17.4b[0]\n"
                    ".inst 0x6f95e31f // udot v31.4s, v24.16b, v21.4b[0]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa1e33a // udot v26.4s, v25.16b, v1.4b[1]\n"
                    ".inst 0x6fa5e33b // udot v27.4s, v25.16b, v5.4b[1]\n"
                    ".inst 0x6fa9e33c // udot v28.4s, v25.16b, v9.4b[1]\n"
                    ".inst 0x6fade33d // udot v29.4s, v25.16b, v13.4b[1]\n"
                    ".inst 0x6fb1e33e // udot v30.4s, v25.16b, v17.4b[1]\n"
                    ".inst 0x6fb5e33f // udot v31.4s, v25.16b, v21.4b[1]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f81eb1a // udot v26.4s, v24.16b, v1.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f85eb1b // udot v27.4s, v24.16b, v5.4b[2]\n"
                    ".inst 0x6f89eb1c // udot v28.4s, v24.16b, v9.4b[2]\n"
                    ".inst 0x6f8deb1d // udot v29.4s, v24.16b, v13.4b[2]\n"
                    ".inst 0x6f91eb1e // udot v30.4s, v24.16b, v17.4b[2]\n"
                    ".inst 0x6f95eb1f // udot v31.4s, v24.16b, v21.4b[2]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa1eb3a // udot v26.4s, v25.16b, v1.4b[3]\n"
                    ".inst 0x6fa5eb3b // udot v27.4s, v25.16b, v5.4b[3]\n"
                    ".inst 0x6fa9eb3c // udot v28.4s, v25.16b, v9.4b[3]\n"
                    ".inst 0x6fadeb3d // udot v29.4s, v25.16b, v13.4b[3]\n"
                    ".inst 0x6fb1eb3e // udot v30.4s, v25.16b, v17.4b[3]\n"
                    ".inst 0x6fb5eb3f // udot v31.4s, v25.16b, v21.4b[3]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f82e31a // udot v26.4s, v24.16b, v2.4b[0]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f86e31b // udot v27.4s, v24.16b, v6.4b[0]\n"
                    ".inst 0x6f8ae31c // udot v28.4s, v24.16b, v10.4b[0]\n"
                    ".inst 0x6f8ee31d // udot v29.4s, v24.16b, v14.4b[0]\n"
                    ".inst 0x6f92e31e // udot v30.4s, v24.16b, v18.4b[0]\n"
                    ".inst 0x6f96e31f // udot v31.4s, v24.16b, v22.4b[0]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa2e33a // udot v26.4s, v25.16b, v2.4b[1]\n"
                    ".inst 0x6fa6e33b // udot v27.4s, v25.16b, v6.4b[1]\n"
                    ".inst 0x6faae33c // udot v28.4s, v25.16b, v10.4b[1]\n"
                    ".inst 0x6faee33d // udot v29.4s, v25.16b, v14.4b[1]\n"
                    ".inst 0x6fb2e33e // udot v30.4s, v25.16b, v18.4b[1]\n"
                    ".inst 0x6fb6e33f // udot v31.4s, v25.16b, v22.4b[1]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f82eb1a // udot v26.4s, v24.16b, v2.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f86eb1b // udot v27.4s, v24.16b, v6.4b[2]\n"
                    ".inst 0x6f8aeb1c // udot v28.4s, v24.16b, v10.4b[2]\n"
                    ".inst 0x6f8eeb1d // udot v29.4s, v24.16b, v14.4b[2]\n"
                    ".inst 0x6f92eb1e // udot v30.4s, v24.16b, v18.4b[2]\n"
                    ".inst 0x6f96eb1f // udot v31.4s, v24.16b, v22.4b[2]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa2eb3a // udot v26.4s, v25.16b, v2.4b[3]\n"
                    ".inst 0x6fa6eb3b // udot v27.4s, v25.16b, v6.4b[3]\n"
                    ".inst 0x6faaeb3c // udot v28.4s, v25.16b, v10.4b[3]\n"
                    ".inst 0x6faeeb3d // udot v29.4s, v25.16b, v14.4b[3]\n"
                    ".inst 0x6fb2eb3e // udot v30.4s, v25.16b, v18.4b[3]\n"
                    ".inst 0x6fb6eb3f // udot v31.4s, v25.16b, v22.4b[3]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f83e31a // udot v26.4s, v24.16b, v3.4b[0]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f87e31b // udot v27.4s, v24.16b, v7.4b[0]\n"
                    ".inst 0x6f8be31c // udot v28.4s, v24.16b, v11.4b[0]\n"
                    ".inst 0x6f8fe31d // udot v29.4s, v24.16b, v15.4b[0]\n"
                    ".inst 0x6f93e31e // udot v30.4s, v24.16b, v19.4b[0]\n"
                    ".inst 0x6f97e31f // udot v31.4s, v24.16b, v23.4b[0]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa3e33a // udot v26.4s, v25.16b, v3.4b[1]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x10\n"
                    ".inst 0x6fa7e33b // udot v27.4s, v25.16b, v7.4b[1]\n"
                    ".inst 0x6fabe33c // udot v28.4s, v25.16b, v11.4b[1]\n"
                    ".inst 0x6fafe33d // udot v29.4s, v25.16b, v15.4b[1]\n"
                    ".inst 0x6fb3e33e // udot v30.4s, v25.16b, v19.4b[1]\n"
                    ".inst 0x6fb7e33f // udot v31.4s, v25.16b, v23.4b[1]\n"
                    ".inst 0x6f83eb1a // udot v26.4s, v24.16b, v3.4b[2]\n"
                    ".inst 0x6f87eb1b // udot v27.4s, v24.16b, v7.4b[2]\n"
                    ".inst 0x6f8beb1c // udot v28.4s, v24.16b, v11.4b[2]\n"
                    ".inst 0x6f8feb1d // udot v29.4s, v24.16b, v15.4b[2]\n"
                    ".inst 0x6f93eb1e // udot v30.4s, v24.16b, v19.4b[2]\n"
                    ".inst 0x6f97eb1f // udot v31.4s, v24.16b, v23.4b[2]\n"
                    "b 9f\n"
                    "6:\n"
                    "movi v26.4s, #0\n"
                    "movi v27.4s, #0\n"
                    "movi v28.4s, #0\n"
                    "movi v29.4s, #0\n"
                    "movi v30.4s, #0\n"
                    "movi v31.4s, #0\n"
                    ".inst 0x6f80e31a // udot v26.4s, v24.16b, v0.4b[0]\n"
                    ".inst 0x6f84e31b // udot v27.4s, v24.16b, v4.4b[0]\n"
                    ".inst 0x6f88e31c // udot v28.4s, v24.16b, v8.4b[0]\n"
                    ".inst 0x6f8ce31d // udot v29.4s, v24.16b, v12.4b[0]\n"
                    ".inst 0x6f90e31e // udot v30.4s, v24.16b, v16.4b[0]\n"
                    ".inst 0x6f94e31f // udot v31.4s, v24.16b, v20.4b[0]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa0e33a // udot v26.4s, v25.16b, v0.4b[1]\n"
                    ".inst 0x6fa4e33b // udot v27.4s, v25.16b, v4.4b[1]\n"
                    ".inst 0x6fa8e33c // udot v28.4s, v25.16b, v8.4b[1]\n"
                    ".inst 0x6face33d // udot v29.4s, v25.16b, v12.4b[1]\n"
                    ".inst 0x6fb0e33e // udot v30.4s, v25.16b, v16.4b[1]\n"
                    ".inst 0x6fb4e33f // udot v31.4s, v25.16b, v20.4b[1]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f80eb1a // udot v26.4s, v24.16b, v0.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f84eb1b // udot v27.4s, v24.16b, v4.4b[2]\n"
                    ".inst 0x6f88eb1c // udot v28.4s, v24.16b, v8.4b[2]\n"
                    ".inst 0x6f8ceb1d // udot v29.4s, v24.16b, v12.4b[2]\n"
                    ".inst 0x6f90eb1e // udot v30.4s, v24.16b, v16.4b[2]\n"
                    ".inst 0x6f94eb1f // udot v31.4s, v24.16b, v20.4b[2]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa0eb3a // udot v26.4s, v25.16b, v0.4b[3]\n"
                    ".inst 0x6fa4eb3b // udot v27.4s, v25.16b, v4.4b[3]\n"
                    ".inst 0x6fa8eb3c // udot v28.4s, v25.16b, v8.4b[3]\n"
                    ".inst 0x6faceb3d // udot v29.4s, v25.16b, v12.4b[3]\n"
                    ".inst 0x6fb0eb3e // udot v30.4s, v25.16b, v16.4b[3]\n"
                    ".inst 0x6fb4eb3f // udot v31.4s, v25.16b, v20.4b[3]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f81e31a // udot v26.4s, v24.16b, v1.4b[0]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f85e31b // udot v27.4s, v24.16b, v5.4b[0]\n"
                    ".inst 0x6f89e31c // udot v28.4s, v24.16b, v9.4b[0]\n"
                    ".inst 0x6f8de31d // udot v29.4s, v24.16b, v13.4b[0]\n"
                    ".inst 0x6f91e31e // udot v30.4s, v24.16b, v17.4b[0]\n"
                    ".inst 0x6f95e31f // udot v31.4s, v24.16b, v21.4b[0]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa1e33a // udot v26.4s, v25.16b, v1.4b[1]\n"
                    ".inst 0x6fa5e33b // udot v27.4s, v25.16b, v5.4b[1]\n"
                    ".inst 0x6fa9e33c // udot v28.4s, v25.16b, v9.4b[1]\n"
                    ".inst 0x6fade33d // udot v29.4s, v25.16b, v13.4b[1]\n"
                    ".inst 0x6fb1e33e // udot v30.4s, v25.16b, v17.4b[1]\n"
                    ".inst 0x6fb5e33f // udot v31.4s, v25.16b, v21.4b[1]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f81eb1a // udot v26.4s, v24.16b, v1.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f85eb1b // udot v27.4s, v24.16b, v5.4b[2]\n"
                    ".inst 0x6f89eb1c // udot v28.4s, v24.16b, v9.4b[2]\n"
                    ".inst 0x6f8deb1d // udot v29.4s, v24.16b, v13.4b[2]\n"
                    ".inst 0x6f91eb1e // udot v30.4s, v24.16b, v17.4b[2]\n"
                    ".inst 0x6f95eb1f // udot v31.4s, v24.16b, v21.4b[2]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa1eb3a // udot v26.4s, v25.16b, v1.4b[3]\n"
                    ".inst 0x6fa5eb3b // udot v27.4s, v25.16b, v5.4b[3]\n"
                    ".inst 0x6fa9eb3c // udot v28.4s, v25.16b, v9.4b[3]\n"
                    ".inst 0x6fadeb3d // udot v29.4s, v25.16b, v13.4b[3]\n"
                    ".inst 0x6fb1eb3e // udot v30.4s, v25.16b, v17.4b[3]\n"
                    ".inst 0x6fb5eb3f // udot v31.4s, v25.16b, v21.4b[3]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f82e31a // udot v26.4s, v24.16b, v2.4b[0]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f86e31b // udot v27.4s, v24.16b, v6.4b[0]\n"
                    ".inst 0x6f8ae31c // udot v28.4s, v24.16b, v10.4b[0]\n"
                    ".inst 0x6f8ee31d // udot v29.4s, v24.16b, v14.4b[0]\n"
                    ".inst 0x6f92e31e // udot v30.4s, v24.16b, v18.4b[0]\n"
                    ".inst 0x6f96e31f // udot v31.4s, v24.16b, v22.4b[0]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa2e33a // udot v26.4s, v25.16b, v2.4b[1]\n"
                    ".inst 0x6fa6e33b // udot v27.4s, v25.16b, v6.4b[1]\n"
                    ".inst 0x6faae33c // udot v28.4s, v25.16b, v10.4b[1]\n"
                    ".inst 0x6faee33d // udot v29.4s, v25.16b, v14.4b[1]\n"
                    ".inst 0x6fb2e33e // udot v30.4s, v25.16b, v18.4b[1]\n"
                    ".inst 0x6fb6e33f // udot v31.4s, v25.16b, v22.4b[1]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f82eb1a // udot v26.4s, v24.16b, v2.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f86eb1b // udot v27.4s, v24.16b, v6.4b[2]\n"
                    ".inst 0x6f8aeb1c // udot v28.4s, v24.16b, v10.4b[2]\n"
                    ".inst 0x6f8eeb1d // udot v29.4s, v24.16b, v14.4b[2]\n"
                    ".inst 0x6f92eb1e // udot v30.4s, v24.16b, v18.4b[2]\n"
                    ".inst 0x6f96eb1f // udot v31.4s, v24.16b, v22.4b[2]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa2eb3a // udot v26.4s, v25.16b, v2.4b[3]\n"
                    ".inst 0x6fa6eb3b // udot v27.4s, v25.16b, v6.4b[3]\n"
                    ".inst 0x6faaeb3c // udot v28.4s, v25.16b, v10.4b[3]\n"
                    ".inst 0x6faeeb3d // udot v29.4s, v25.16b, v14.4b[3]\n"
                    ".inst 0x6fb2eb3e // udot v30.4s, v25.16b, v18.4b[3]\n"
                    ".inst 0x6fb6eb3f // udot v31.4s, v25.16b, v22.4b[3]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f83e31a // udot v26.4s, v24.16b, v3.4b[0]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f87e31b // udot v27.4s, v24.16b, v7.4b[0]\n"
                    ".inst 0x6f8be31c // udot v28.4s, v24.16b, v11.4b[0]\n"
                    ".inst 0x6f8fe31d // udot v29.4s, v24.16b, v15.4b[0]\n"
                    ".inst 0x6f93e31e // udot v30.4s, v24.16b, v19.4b[0]\n"
                    ".inst 0x6f97e31f // udot v31.4s, v24.16b, v23.4b[0]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa3e33a // udot v26.4s, v25.16b, v3.4b[1]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x10\n"
                    ".inst 0x6fa7e33b // udot v27.4s, v25.16b, v7.4b[1]\n"
                    ".inst 0x6fabe33c // udot v28.4s, v25.16b, v11.4b[1]\n"
                    ".inst 0x6fafe33d // udot v29.4s, v25.16b, v15.4b[1]\n"
                    ".inst 0x6fb3e33e // udot v30.4s, v25.16b, v19.4b[1]\n"
                    ".inst 0x6fb7e33f // udot v31.4s, v25.16b, v23.4b[1]\n"
                    ".inst 0x6f83eb1a // udot v26.4s, v24.16b, v3.4b[2]\n"
                    ".inst 0x6f87eb1b // udot v27.4s, v24.16b, v7.4b[2]\n"
                    ".inst 0x6f8beb1c // udot v28.4s, v24.16b, v11.4b[2]\n"
                    ".inst 0x6f8feb1d // udot v29.4s, v24.16b, v15.4b[2]\n"
                    ".inst 0x6f93eb1e // udot v30.4s, v24.16b, v19.4b[2]\n"
                    ".inst 0x6f97eb1f // udot v31.4s, v24.16b, v23.4b[2]\n"
                    "9:\n"
                    "str q26, [%[c_ptr0]]\n"
                    "add %[c_ptr0], %[c_ptr0], #0x10\n"
                    "str q27, [c_ptr1]\n"
                    "str q28, [c_ptr2]\n"
                    "str q29, [c_ptr3]\n"
                    "str q30, [c_ptr4]\n"
                    "str q31, [c_ptr5]\n"
                    ".unreq a_ptr1\n"
                    ".unreq a_ptr2\n"
                    ".unreq a_ptr3\n"
                    ".unreq a_ptr4\n"
                    ".unreq a_ptr5\n"
                    ".unreq c_ptr1\n"
                    ".unreq c_ptr2\n"
                    ".unreq c_ptr3\n"
                    ".unreq c_ptr4\n"
                    ".unreq c_ptr5\n"
                    ".unreq temploadreg0\n"
                    ".unreq temploadreg1\n"
                    ".unreq temploadreg2\n"
                    ".unreq temploadreg3\n"
                    : [a_ptr0] "+r" (a_ptr0), [b_ptr0] "+r" (b_ptr0), [c_ptr0] "+r" (c_ptr0), [loops] "+r" (loops), [oob_rows] "+r" (oob_rows), [odds] "+r" (odds)
                    : [lda] "r" (ldab), [ldc] "r" (ldcb)
                    : "x0", "x1", "x2", "x3", "x4", "x5", "x6", "x7", "x8", "x9", "x10", "x11", "x12", "x13", "v0", "v1", "v2", "v3", "v4", "v5", "v6", "v7", "v8", "v9", "v10", "v11", "v12", "v13", "v14", "v15", "v16", "v17", "v18", "v19", "v20", "v21", "v22", "v23", "v24", "v25", "v26", "v27", "v28", "v29", "v30", "v31", "cc", "memory"
                );
                break;
            default:
            case 16:
                __asm __volatile (
                    "a_ptr1 .req X0\n"
                    "a_ptr2 .req X1\n"
                    "a_ptr3 .req X2\n"
                    "a_ptr4 .req X3\n"
                    "a_ptr5 .req X4\n"
                    "c_ptr1 .req X5\n"
                    "c_ptr2 .req X6\n"
                    "c_ptr3 .req X7\n"
                    "c_ptr4 .req X8\n"
                    "c_ptr5 .req X9\n"
                    "temploadreg0 .req X10\n"
                    "temploadreg1 .req X11\n"
                    "temploadreg2 .req X12\n"
                    "temploadreg3 .req X13\n"
                    "add a_ptr1, %[a_ptr0], %[lda]\n"
                    "add c_ptr1, %[c_ptr0], %[ldc]\n"
                    "add a_ptr2, a_ptr1, %[lda]\n"
                    "add c_ptr2, c_ptr1, %[ldc]\n"
                    "add a_ptr3, a_ptr2, %[lda]\n"
                    "add c_ptr3, c_ptr2, %[ldc]\n"
                    "add a_ptr4, a_ptr3, %[lda]\n"
                    "add c_ptr4, c_ptr3, %[ldc]\n"
                    "add a_ptr5, a_ptr4, %[lda]\n"
                    "add c_ptr5, c_ptr4, %[ldc]\n"
                    "cbz %[oob_rows], 1f\n"
                    "subs %[oob_rows], %[oob_rows], #0x1\n"
                    "add c_ptr5, %[c_ptr0], #0x0\n"
                    "add a_ptr5, %[a_ptr0], #0x0\n"
                    "b.eq 1f\n"
                    "subs %[oob_rows], %[oob_rows], #0x1\n"
                    "add c_ptr4, %[c_ptr0], #0x0\n"
                    "add a_ptr4, %[a_ptr0], #0x0\n"
                    "b.eq 1f\n"
                    "subs %[oob_rows], %[oob_rows], #0x1\n"
                    "add c_ptr3, %[c_ptr0], #0x0\n"
                    "add a_ptr3, %[a_ptr0], #0x0\n"
                    "b.eq 1f\n"
                    "subs %[oob_rows], %[oob_rows], #0x1\n"
                    "add c_ptr2, %[c_ptr0], #0x0\n"
                    "add a_ptr2, %[a_ptr0], #0x0\n"
                    "b.eq 1f\n"
                    "subs %[oob_rows], %[oob_rows], #0x1\n"
                    "add c_ptr1, %[c_ptr0], #0x0\n"
                    "add a_ptr1, %[a_ptr0], #0x0\n"
                    "1:\n"
                    "cbnz %[odds], 2f\n"
                    "ldr q0, [%[a_ptr0]], #0x10\n"
                    "ldr q4, [a_ptr1], #0x10\n"
                    "ldr q8, [a_ptr2], #0x10\n"
                    "ldr q12, [a_ptr3], #0x10\n"
                    "ldr q16, [a_ptr4], #0x10\n"
                    "ldr q20, [a_ptr5], #0x10\n"
                    "ldr q1, [%[a_ptr0]], #0x10\n"
                    "ldr q5, [a_ptr1], #0x10\n"
                    "ldr q9, [a_ptr2], #0x10\n"
                    "ldr q13, [a_ptr3], #0x10\n"
                    "ldr q17, [a_ptr4], #0x10\n"
                    "ldr q21, [a_ptr5], #0x10\n"
                    "ldr q2, [%[a_ptr0]], #0x10\n"
                    "ldr q6, [a_ptr1], #0x10\n"
                    "ldr q10, [a_ptr2], #0x10\n"
                    "ldr q14, [a_ptr3], #0x10\n"
                    "ldr q18, [a_ptr4], #0x10\n"
                    "ldr q22, [a_ptr5], #0x10\n"
                    "ldr q3, [%[a_ptr0]]\n"
                    "ldr q7, [a_ptr1]\n"
                    "ldr q11, [a_ptr2]\n"
                    "ldr q15, [a_ptr3]\n"
                    "ldr q19, [a_ptr4]\n"
                    "ldr q23, [a_ptr5]\n"
                    "b 3f\n"
                    "2:\n"
                    "ldr q0, [%[a_ptr0]], #0x10\n"
                    "subs %[odds], %[odds], #0x1\n"
                    "ldr q4, [a_ptr1], #0x10\n"
                    "ldr q8, [a_ptr2], #0x10\n"
                    "ldr q12, [a_ptr3], #0x10\n"
                    "ldr q16, [a_ptr4], #0x10\n"
                    "ldr q20, [a_ptr5], #0x10\n"
                    "ldr q1, [%[a_ptr0]], #0x10\n"
                    "ldr q5, [a_ptr1], #0x10\n"
                    "ldr q9, [a_ptr2], #0x10\n"
                    "ldr q13, [a_ptr3], #0x10\n"
                    "ldr q17, [a_ptr4], #0x10\n"
                    "ldr q21, [a_ptr5], #0x10\n"
                    "ldr q2, [%[a_ptr0]], #0x10\n"
                    "ldr q6, [a_ptr1], #0x10\n"
                    "ldr q10, [a_ptr2], #0x10\n"
                    "ldr q14, [a_ptr3], #0x10\n"
                    "ldr d3, [%[a_ptr0]], #0x8\n"
                    "ldr q18, [a_ptr4], #0x10\n"
                    "ldr d7, [a_ptr1], #0x8\n"
                    "ldr q22, [a_ptr5], #0x10\n"
                    "ldr d11, [a_ptr2], #0x8\n"
                    "ldr d15, [a_ptr3], #0x8\n"
                    "ldr d19, [a_ptr4], #0x8\n"
                    "ldr d23, [a_ptr5], #0x8\n"
                    "ld1 {v3.s}[2], [%[a_ptr0]], #4\n"
                    "ld1 {v7.s}[2], [a_ptr1], #4\n"
                    "ld1 {v11.s}[2], [a_ptr2], #4\n"
                    "ld1 {v15.s}[2], [a_ptr3], #4\n"
                    "ld1 {v19.s}[2], [a_ptr4], #4\n"
                    "ld1 {v23.s}[2], [a_ptr5], #4\n"
                    "b.ne 4f\n"
                    "ld1 {v3.b}[12], [%[a_ptr0]]\n"
                    "ld1 {v7.b}[12], [a_ptr1]\n"
                    "ld1 {v11.b}[12], [a_ptr2]\n"
                    "ld1 {v15.b}[12], [a_ptr3]\n"
                    "ld1 {v19.b}[12], [a_ptr4]\n"
                    "ld1 {v23.b}[12], [a_ptr5]\n"
                    "b 3f\n"
                    "4:\n"
                    "ld1 {v3.h}[6], [%[a_ptr0]], #2\n"
                    "ld1 {v7.h}[6], [a_ptr1], #2\n"
                    "ld1 {v11.h}[6], [a_ptr2], #2\n"
                    "ld1 {v15.h}[6], [a_ptr3], #2\n"
                    "ld1 {v19.h}[6], [a_ptr4], #2\n"
                    "ld1 {v23.h}[6], [a_ptr5], #2\n"
                    "subs %[odds], %[odds], #0x1\n"
                    "b.ne 5f\n"
                    "b 3f\n"
                    "5:\n"
                    "ld1 {v3.b}[14], [%[a_ptr0]]\n"
                    "ld1 {v7.b}[14], [a_ptr1]\n"
                    "ld1 {v11.b}[14], [a_ptr2]\n"
                    "ld1 {v15.b}[14], [a_ptr3]\n"
                    "ld1 {v19.b}[14], [a_ptr4]\n"
                    "ld1 {v23.b}[14], [a_ptr5]\n"
                    "3:\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    "prfm PLDL1KEEP, [a_ptr5, #0x40]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    "prfm PLDL1KEEP, [a_ptr5, #0x80]\n"
                    "prfm PLDL1KEEP, [a_ptr5, #0xc0]\n"
                    "prfm PLDL1KEEP, [a_ptr5, #0x100]\n"
                    "prfm PLDL1KEEP, [a_ptr5, #0x140]\n"
                    "prfm PLDL1KEEP, [a_ptr5, #0x180]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    "cbz %[loops], 6f\n"
                    "movi v26.4s, #0\n"
                    "subs %[loops], %[loops], #0x1\n"
                    "movi v27.4s, #0\n"
                    "movi v28.4s, #0\n"
                    "movi v29.4s, #0\n"
                    "movi v30.4s, #0\n"
                    "movi v31.4s, #0\n"
                    ".inst 0x6f80e31a // udot v26.4s, v24.16b, v0.4b[0]\n"
                    ".inst 0x6f84e31b // udot v27.4s, v24.16b, v4.4b[0]\n"
                    ".inst 0x6f88e31c // udot v28.4s, v24.16b, v8.4b[0]\n"
                    ".inst 0x6f8ce31d // udot v29.4s, v24.16b, v12.4b[0]\n"
                    ".inst 0x6f90e31e // udot v30.4s, v24.16b, v16.4b[0]\n"
                    ".inst 0x6f94e31f // udot v31.4s, v24.16b, v20.4b[0]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa0e33a // udot v26.4s, v25.16b, v0.4b[1]\n"
                    ".inst 0x6fa4e33b // udot v27.4s, v25.16b, v4.4b[1]\n"
                    ".inst 0x6fa8e33c // udot v28.4s, v25.16b, v8.4b[1]\n"
                    ".inst 0x6face33d // udot v29.4s, v25.16b, v12.4b[1]\n"
                    ".inst 0x6fb0e33e // udot v30.4s, v25.16b, v16.4b[1]\n"
                    ".inst 0x6fb4e33f // udot v31.4s, v25.16b, v20.4b[1]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f80eb1a // udot v26.4s, v24.16b, v0.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f84eb1b // udot v27.4s, v24.16b, v4.4b[2]\n"
                    ".inst 0x6f88eb1c // udot v28.4s, v24.16b, v8.4b[2]\n"
                    ".inst 0x6f8ceb1d // udot v29.4s, v24.16b, v12.4b[2]\n"
                    ".inst 0x6f90eb1e // udot v30.4s, v24.16b, v16.4b[2]\n"
                    ".inst 0x6f94eb1f // udot v31.4s, v24.16b, v20.4b[2]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa0eb3a // udot v26.4s, v25.16b, v0.4b[3]\n"
                    ".inst 0x6fa4eb3b // udot v27.4s, v25.16b, v4.4b[3]\n"
                    ".inst 0x6fa8eb3c // udot v28.4s, v25.16b, v8.4b[3]\n"
                    ".inst 0x6faceb3d // udot v29.4s, v25.16b, v12.4b[3]\n"
                    ".inst 0x6fb0eb3e // udot v30.4s, v25.16b, v16.4b[3]\n"
                    ".inst 0x6fb4eb3f // udot v31.4s, v25.16b, v20.4b[3]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f81e31a // udot v26.4s, v24.16b, v1.4b[0]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f85e31b // udot v27.4s, v24.16b, v5.4b[0]\n"
                    ".inst 0x6f89e31c // udot v28.4s, v24.16b, v9.4b[0]\n"
                    ".inst 0x6f8de31d // udot v29.4s, v24.16b, v13.4b[0]\n"
                    ".inst 0x6f91e31e // udot v30.4s, v24.16b, v17.4b[0]\n"
                    ".inst 0x6f95e31f // udot v31.4s, v24.16b, v21.4b[0]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa1e33a // udot v26.4s, v25.16b, v1.4b[1]\n"
                    ".inst 0x6fa5e33b // udot v27.4s, v25.16b, v5.4b[1]\n"
                    ".inst 0x6fa9e33c // udot v28.4s, v25.16b, v9.4b[1]\n"
                    ".inst 0x6fade33d // udot v29.4s, v25.16b, v13.4b[1]\n"
                    ".inst 0x6fb1e33e // udot v30.4s, v25.16b, v17.4b[1]\n"
                    ".inst 0x6fb5e33f // udot v31.4s, v25.16b, v21.4b[1]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f81eb1a // udot v26.4s, v24.16b, v1.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f85eb1b // udot v27.4s, v24.16b, v5.4b[2]\n"
                    ".inst 0x6f89eb1c // udot v28.4s, v24.16b, v9.4b[2]\n"
                    ".inst 0x6f8deb1d // udot v29.4s, v24.16b, v13.4b[2]\n"
                    ".inst 0x6f91eb1e // udot v30.4s, v24.16b, v17.4b[2]\n"
                    ".inst 0x6f95eb1f // udot v31.4s, v24.16b, v21.4b[2]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa1eb3a // udot v26.4s, v25.16b, v1.4b[3]\n"
                    ".inst 0x6fa5eb3b // udot v27.4s, v25.16b, v5.4b[3]\n"
                    ".inst 0x6fa9eb3c // udot v28.4s, v25.16b, v9.4b[3]\n"
                    ".inst 0x6fadeb3d // udot v29.4s, v25.16b, v13.4b[3]\n"
                    ".inst 0x6fb1eb3e // udot v30.4s, v25.16b, v17.4b[3]\n"
                    ".inst 0x6fb5eb3f // udot v31.4s, v25.16b, v21.4b[3]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f82e31a // udot v26.4s, v24.16b, v2.4b[0]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f86e31b // udot v27.4s, v24.16b, v6.4b[0]\n"
                    ".inst 0x6f8ae31c // udot v28.4s, v24.16b, v10.4b[0]\n"
                    ".inst 0x6f8ee31d // udot v29.4s, v24.16b, v14.4b[0]\n"
                    ".inst 0x6f92e31e // udot v30.4s, v24.16b, v18.4b[0]\n"
                    ".inst 0x6f96e31f // udot v31.4s, v24.16b, v22.4b[0]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa2e33a // udot v26.4s, v25.16b, v2.4b[1]\n"
                    ".inst 0x6fa6e33b // udot v27.4s, v25.16b, v6.4b[1]\n"
                    ".inst 0x6faae33c // udot v28.4s, v25.16b, v10.4b[1]\n"
                    ".inst 0x6faee33d // udot v29.4s, v25.16b, v14.4b[1]\n"
                    ".inst 0x6fb2e33e // udot v30.4s, v25.16b, v18.4b[1]\n"
                    ".inst 0x6fb6e33f // udot v31.4s, v25.16b, v22.4b[1]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f82eb1a // udot v26.4s, v24.16b, v2.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f86eb1b // udot v27.4s, v24.16b, v6.4b[2]\n"
                    ".inst 0x6f8aeb1c // udot v28.4s, v24.16b, v10.4b[2]\n"
                    ".inst 0x6f8eeb1d // udot v29.4s, v24.16b, v14.4b[2]\n"
                    ".inst 0x6f92eb1e // udot v30.4s, v24.16b, v18.4b[2]\n"
                    ".inst 0x6f96eb1f // udot v31.4s, v24.16b, v22.4b[2]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa2eb3a // udot v26.4s, v25.16b, v2.4b[3]\n"
                    ".inst 0x6fa6eb3b // udot v27.4s, v25.16b, v6.4b[3]\n"
                    ".inst 0x6faaeb3c // udot v28.4s, v25.16b, v10.4b[3]\n"
                    ".inst 0x6faeeb3d // udot v29.4s, v25.16b, v14.4b[3]\n"
                    ".inst 0x6fb2eb3e // udot v30.4s, v25.16b, v18.4b[3]\n"
                    ".inst 0x6fb6eb3f // udot v31.4s, v25.16b, v22.4b[3]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f83e31a // udot v26.4s, v24.16b, v3.4b[0]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f87e31b // udot v27.4s, v24.16b, v7.4b[0]\n"
                    ".inst 0x6f8be31c // udot v28.4s, v24.16b, v11.4b[0]\n"
                    ".inst 0x6f8fe31d // udot v29.4s, v24.16b, v15.4b[0]\n"
                    ".inst 0x6f93e31e // udot v30.4s, v24.16b, v19.4b[0]\n"
                    ".inst 0x6f97e31f // udot v31.4s, v24.16b, v23.4b[0]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa3e33a // udot v26.4s, v25.16b, v3.4b[1]\n"
                    ".inst 0x6fa7e33b // udot v27.4s, v25.16b, v7.4b[1]\n"
                    ".inst 0x6fabe33c // udot v28.4s, v25.16b, v11.4b[1]\n"
                    ".inst 0x6fafe33d // udot v29.4s, v25.16b, v15.4b[1]\n"
                    ".inst 0x6fb3e33e // udot v30.4s, v25.16b, v19.4b[1]\n"
                    ".inst 0x6fb7e33f // udot v31.4s, v25.16b, v23.4b[1]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f83eb1a // udot v26.4s, v24.16b, v3.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f87eb1b // udot v27.4s, v24.16b, v7.4b[2]\n"
                    ".inst 0x6f8beb1c // udot v28.4s, v24.16b, v11.4b[2]\n"
                    ".inst 0x6f8feb1d // udot v29.4s, v24.16b, v15.4b[2]\n"
                    ".inst 0x6f93eb1e // udot v30.4s, v24.16b, v19.4b[2]\n"
                    ".inst 0x6f97eb1f // udot v31.4s, v24.16b, v23.4b[2]\n"
                    ".inst 0x6fa3eb3a // udot v26.4s, v25.16b, v3.4b[3]\n"
                    ".inst 0x6fa7eb3b // udot v27.4s, v25.16b, v7.4b[3]\n"
                    ".inst 0x6fabeb3c // udot v28.4s, v25.16b, v11.4b[3]\n"
                    ".inst 0x6fafeb3d // udot v29.4s, v25.16b, v15.4b[3]\n"
                    ".inst 0x6fb3eb3e // udot v30.4s, v25.16b, v19.4b[3]\n"
                    ".inst 0x6fb7eb3f // udot v31.4s, v25.16b, v23.4b[3]\n"
                    "b.eq 7f\n"
                    "8:\n"
                    "str q26, [%[c_ptr0]]\n"
                    "subs %[loops], %[loops], #0x1\n"
                    "movi v26.4s, #0\n"
                    "ldr d24, [%[b_ptr0]]\n"
                    "ldr temploadreg0, [%[b_ptr0], #0x8]\n"
                    "add %[c_ptr0], %[c_ptr0], #0x10\n"
                    "str q27, [c_ptr1]\n"
                    "add c_ptr1, c_ptr1, #0x10\n"
                    "movi v27.4s, #0\n"
                    "ldr d25, [%[b_ptr0], #0x10]\n"
                    "ldr temploadreg1, [%[b_ptr0], #0x18]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    "str q28, [c_ptr2]\n"
                    "add c_ptr2, c_ptr2, #0x10\n"
                    "movi v28.4s, #0\n"
                    "ins v24.d[1], temploadreg0\n"
                    "ins v25.d[1], temploadreg1\n"
                    "prfm PSTL1KEEP, [%[c_ptr0], #0x40]\n"
                    "str q29, [c_ptr3]\n"
                    "add c_ptr3, c_ptr3, #0x10\n"
                    "movi v29.4s, #0\n"
                    "ldr temploadreg0, [%[b_ptr0], #0x8]\n"
                    ".inst 0x6f80e31a // udot v26.4s, v24.16b, v0.4b[0]\n"
                    "str q30, [c_ptr4]\n"
                    "movi v30.4s, #0\n"
                    "ldr temploadreg1, [%[b_ptr0], #0x18]\n"
                    ".inst 0x6f84e31b // udot v27.4s, v24.16b, v4.4b[0]\n"
                    "add c_ptr4, c_ptr4, #0x10\n"
                    ".inst 0x6f88e31c // udot v28.4s, v24.16b, v8.4b[0]\n"
                    "str q31, [c_ptr5]\n"
                    "movi v31.4s, #0\n"
                    "add c_ptr5, c_ptr5, #0x10\n"
                    ".inst 0x6f8ce31d // udot v29.4s, v24.16b, v12.4b[0]\n"
                    "prfm PSTL1KEEP, [c_ptr1, #0x40]\n"
                    ".inst 0x6f90e31e // udot v30.4s, v24.16b, v16.4b[0]\n"
                    "prfm PSTL1KEEP, [c_ptr2, #0x40]\n"
                    ".inst 0x6f94e31f // udot v31.4s, v24.16b, v20.4b[0]\n"
                    "ldr d24, [%[b_ptr0]]\n"
                    ".inst 0x6fa0e33a // udot v26.4s, v25.16b, v0.4b[1]\n"
                    "prfm PSTL1KEEP, [c_ptr3, #0x40]\n"
                    ".inst 0x6fa4e33b // udot v27.4s, v25.16b, v4.4b[1]\n"
                    "ins v24.d[1], temploadreg0\n"
                    ".inst 0x6fa8e33c // udot v28.4s, v25.16b, v8.4b[1]\n"
                    "prfm PSTL1KEEP, [c_ptr4, #0x40]\n"
                    ".inst 0x6face33d // udot v29.4s, v25.16b, v12.4b[1]\n"
                    "prfm PSTL1KEEP, [c_ptr5, #0x40]\n"
                    ".inst 0x6fb0e33e // udot v30.4s, v25.16b, v16.4b[1]\n"
                    ".inst 0x6fb4e33f // udot v31.4s, v25.16b, v20.4b[1]\n"
                    "ldr d25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f80eb1a // udot v26.4s, v24.16b, v0.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f84eb1b // udot v27.4s, v24.16b, v4.4b[2]\n"
                    "ins v25.d[1], temploadreg1\n"
                    ".inst 0x6f88eb1c // udot v28.4s, v24.16b, v8.4b[2]\n"
                    "ldr temploadreg0, [%[b_ptr0], #0x8]\n"
                    ".inst 0x6f8ceb1d // udot v29.4s, v24.16b, v12.4b[2]\n"
                    "ldr temploadreg1, [%[b_ptr0], #0x18]\n"
                    ".inst 0x6f90eb1e // udot v30.4s, v24.16b, v16.4b[2]\n"
                    ".inst 0x6f94eb1f // udot v31.4s, v24.16b, v20.4b[2]\n"
                    "ldr d24, [%[b_ptr0]]\n"
                    ".inst 0x6fa0eb3a // udot v26.4s, v25.16b, v0.4b[3]\n"
                    ".inst 0x6fa4eb3b // udot v27.4s, v25.16b, v4.4b[3]\n"
                    ".inst 0x6fa8eb3c // udot v28.4s, v25.16b, v8.4b[3]\n"
                    "ins v24.d[1], temploadreg0\n"
                    ".inst 0x6faceb3d // udot v29.4s, v25.16b, v12.4b[3]\n"
                    ".inst 0x6fb0eb3e // udot v30.4s, v25.16b, v16.4b[3]\n"
                    ".inst 0x6fb4eb3f // udot v31.4s, v25.16b, v20.4b[3]\n"
                    "ldr d25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f81e31a // udot v26.4s, v24.16b, v1.4b[0]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f85e31b // udot v27.4s, v24.16b, v5.4b[0]\n"
                    "ins v25.d[1], temploadreg1\n"
                    ".inst 0x6f89e31c // udot v28.4s, v24.16b, v9.4b[0]\n"
                    "ldr temploadreg0, [%[b_ptr0], #0x8]\n"
                    ".inst 0x6f8de31d // udot v29.4s, v24.16b, v13.4b[0]\n"
                    "ldr temploadreg1, [%[b_ptr0], #0x18]\n"
                    ".inst 0x6f91e31e // udot v30.4s, v24.16b, v17.4b[0]\n"
                    ".inst 0x6f95e31f // udot v31.4s, v24.16b, v21.4b[0]\n"
                    "ldr d24, [%[b_ptr0]]\n"
                    ".inst 0x6fa1e33a // udot v26.4s, v25.16b, v1.4b[1]\n"
                    ".inst 0x6fa5e33b // udot v27.4s, v25.16b, v5.4b[1]\n"
                    ".inst 0x6fa9e33c // udot v28.4s, v25.16b, v9.4b[1]\n"
                    "ins v24.d[1], temploadreg0\n"
                    ".inst 0x6fade33d // udot v29.4s, v25.16b, v13.4b[1]\n"
                    ".inst 0x6fb1e33e // udot v30.4s, v25.16b, v17.4b[1]\n"
                    ".inst 0x6fb5e33f // udot v31.4s, v25.16b, v21.4b[1]\n"
                    "ldr d25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f81eb1a // udot v26.4s, v24.16b, v1.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f85eb1b // udot v27.4s, v24.16b, v5.4b[2]\n"
                    "ins v25.d[1], temploadreg1\n"
                    ".inst 0x6f89eb1c // udot v28.4s, v24.16b, v9.4b[2]\n"
                    "ldr temploadreg0, [%[b_ptr0], #0x8]\n"
                    ".inst 0x6f8deb1d // udot v29.4s, v24.16b, v13.4b[2]\n"
                    "ldr temploadreg1, [%[b_ptr0], #0x18]\n"
                    ".inst 0x6f91eb1e // udot v30.4s, v24.16b, v17.4b[2]\n"
                    ".inst 0x6f95eb1f // udot v31.4s, v24.16b, v21.4b[2]\n"
                    "ldr d24, [%[b_ptr0]]\n"
                    ".inst 0x6fa1eb3a // udot v26.4s, v25.16b, v1.4b[3]\n"
                    ".inst 0x6fa5eb3b // udot v27.4s, v25.16b, v5.4b[3]\n"
                    ".inst 0x6fa9eb3c // udot v28.4s, v25.16b, v9.4b[3]\n"
                    "ins v24.d[1], temploadreg0\n"
                    ".inst 0x6fadeb3d // udot v29.4s, v25.16b, v13.4b[3]\n"
                    ".inst 0x6fb1eb3e // udot v30.4s, v25.16b, v17.4b[3]\n"
                    ".inst 0x6fb5eb3f // udot v31.4s, v25.16b, v21.4b[3]\n"
                    "ldr d25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f82e31a // udot v26.4s, v24.16b, v2.4b[0]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f86e31b // udot v27.4s, v24.16b, v6.4b[0]\n"
                    "ins v25.d[1], temploadreg1\n"
                    ".inst 0x6f8ae31c // udot v28.4s, v24.16b, v10.4b[0]\n"
                    "ldr temploadreg0, [%[b_ptr0], #0x8]\n"
                    ".inst 0x6f8ee31d // udot v29.4s, v24.16b, v14.4b[0]\n"
                    "ldr temploadreg1, [%[b_ptr0], #0x18]\n"
                    ".inst 0x6f92e31e // udot v30.4s, v24.16b, v18.4b[0]\n"
                    ".inst 0x6f96e31f // udot v31.4s, v24.16b, v22.4b[0]\n"
                    "ldr d24, [%[b_ptr0]]\n"
                    ".inst 0x6fa2e33a // udot v26.4s, v25.16b, v2.4b[1]\n"
                    ".inst 0x6fa6e33b // udot v27.4s, v25.16b, v6.4b[1]\n"
                    ".inst 0x6faae33c // udot v28.4s, v25.16b, v10.4b[1]\n"
                    "ins v24.d[1], temploadreg0\n"
                    ".inst 0x6faee33d // udot v29.4s, v25.16b, v14.4b[1]\n"
                    ".inst 0x6fb2e33e // udot v30.4s, v25.16b, v18.4b[1]\n"
                    ".inst 0x6fb6e33f // udot v31.4s, v25.16b, v22.4b[1]\n"
                    "ldr d25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f82eb1a // udot v26.4s, v24.16b, v2.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f86eb1b // udot v27.4s, v24.16b, v6.4b[2]\n"
                    "ins v25.d[1], temploadreg1\n"
                    ".inst 0x6f8aeb1c // udot v28.4s, v24.16b, v10.4b[2]\n"
                    "ldr temploadreg0, [%[b_ptr0], #0x8]\n"
                    ".inst 0x6f8eeb1d // udot v29.4s, v24.16b, v14.4b[2]\n"
                    "ldr temploadreg1, [%[b_ptr0], #0x18]\n"
                    ".inst 0x6f92eb1e // udot v30.4s, v24.16b, v18.4b[2]\n"
                    ".inst 0x6f96eb1f // udot v31.4s, v24.16b, v22.4b[2]\n"
                    "ldr d24, [%[b_ptr0]]\n"
                    ".inst 0x6fa2eb3a // udot v26.4s, v25.16b, v2.4b[3]\n"
                    ".inst 0x6fa6eb3b // udot v27.4s, v25.16b, v6.4b[3]\n"
                    ".inst 0x6faaeb3c // udot v28.4s, v25.16b, v10.4b[3]\n"
                    "ins v24.d[1], temploadreg0\n"
                    ".inst 0x6faeeb3d // udot v29.4s, v25.16b, v14.4b[3]\n"
                    ".inst 0x6fb2eb3e // udot v30.4s, v25.16b, v18.4b[3]\n"
                    ".inst 0x6fb6eb3f // udot v31.4s, v25.16b, v22.4b[3]\n"
                    "ldr d25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f83e31a // udot v26.4s, v24.16b, v3.4b[0]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f87e31b // udot v27.4s, v24.16b, v7.4b[0]\n"
                    "ins v25.d[1], temploadreg1\n"
                    ".inst 0x6f8be31c // udot v28.4s, v24.16b, v11.4b[0]\n"
                    "ldr temploadreg0, [%[b_ptr0], #0x8]\n"
                    ".inst 0x6f8fe31d // udot v29.4s, v24.16b, v15.4b[0]\n"
                    "ldr temploadreg1, [%[b_ptr0], #0x18]\n"
                    ".inst 0x6f93e31e // udot v30.4s, v24.16b, v19.4b[0]\n"
                    ".inst 0x6f97e31f // udot v31.4s, v24.16b, v23.4b[0]\n"
                    "ldr d24, [%[b_ptr0]]\n"
                    ".inst 0x6fa3e33a // udot v26.4s, v25.16b, v3.4b[1]\n"
                    ".inst 0x6fa7e33b // udot v27.4s, v25.16b, v7.4b[1]\n"
                    ".inst 0x6fabe33c // udot v28.4s, v25.16b, v11.4b[1]\n"
                    "ins v24.d[1], temploadreg0\n"
                    ".inst 0x6fafe33d // udot v29.4s, v25.16b, v15.4b[1]\n"
                    ".inst 0x6fb3e33e // udot v30.4s, v25.16b, v19.4b[1]\n"
                    ".inst 0x6fb7e33f // udot v31.4s, v25.16b, v23.4b[1]\n"
                    "ldr d25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f83eb1a // udot v26.4s, v24.16b, v3.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f87eb1b // udot v27.4s, v24.16b, v7.4b[2]\n"
                    "ins v25.d[1], temploadreg1\n"
                    ".inst 0x6f8beb1c // udot v28.4s, v24.16b, v11.4b[2]\n"
                    ".inst 0x6f8feb1d // udot v29.4s, v24.16b, v15.4b[2]\n"
                    ".inst 0x6f93eb1e // udot v30.4s, v24.16b, v19.4b[2]\n"
                    ".inst 0x6f97eb1f // udot v31.4s, v24.16b, v23.4b[2]\n"
                    ".inst 0x6fa3eb3a // udot v26.4s, v25.16b, v3.4b[3]\n"
                    ".inst 0x6fa7eb3b // udot v27.4s, v25.16b, v7.4b[3]\n"
                    ".inst 0x6fabeb3c // udot v28.4s, v25.16b, v11.4b[3]\n"
                    ".inst 0x6fafeb3d // udot v29.4s, v25.16b, v15.4b[3]\n"
                    ".inst 0x6fb3eb3e // udot v30.4s, v25.16b, v19.4b[3]\n"
                    ".inst 0x6fb7eb3f // udot v31.4s, v25.16b, v23.4b[3]\n"
                    "b.ne 8b\n"
                    "7:\n"
                    "str q26, [%[c_ptr0]]\n"
                    "add %[c_ptr0], %[c_ptr0], #0x10\n"
                    "movi v26.4s, #0\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    "str q27, [c_ptr1]\n"
                    "add c_ptr1, c_ptr1, #0x10\n"
                    "movi v27.4s, #0\n"
                    ".inst 0x6f80e31a // udot v26.4s, v24.16b, v0.4b[0]\n"
                    "str q28, [c_ptr2]\n"
                    "movi v28.4s, #0\n"
                    "add c_ptr2, c_ptr2, #0x10\n"
                    ".inst 0x6f84e31b // udot v27.4s, v24.16b, v4.4b[0]\n"
                    "str q29, [c_ptr3]\n"
                    "movi v29.4s, #0\n"
                    "add c_ptr3, c_ptr3, #0x10\n"
                    ".inst 0x6f88e31c // udot v28.4s, v24.16b, v8.4b[0]\n"
                    "str q30, [c_ptr4]\n"
                    "movi v30.4s, #0\n"
                    "add c_ptr4, c_ptr4, #0x10\n"
                    ".inst 0x6f8ce31d // udot v29.4s, v24.16b, v12.4b[0]\n"
                    "str q31, [c_ptr5]\n"
                    "movi v31.4s, #0\n"
                    "add c_ptr5, c_ptr5, #0x10\n"
                    ".inst 0x6f90e31e // udot v30.4s, v24.16b, v16.4b[0]\n"
                    ".inst 0x6fa0e33a // udot v26.4s, v25.16b, v0.4b[1]\n"
                    ".inst 0x6f94e31f // udot v31.4s, v24.16b, v20.4b[0]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa4e33b // udot v27.4s, v25.16b, v4.4b[1]\n"
                    ".inst 0x6fa8e33c // udot v28.4s, v25.16b, v8.4b[1]\n"
                    ".inst 0x6face33d // udot v29.4s, v25.16b, v12.4b[1]\n"
                    ".inst 0x6fb0e33e // udot v30.4s, v25.16b, v16.4b[1]\n"
                    ".inst 0x6fb4e33f // udot v31.4s, v25.16b, v20.4b[1]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f80eb1a // udot v26.4s, v24.16b, v0.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f84eb1b // udot v27.4s, v24.16b, v4.4b[2]\n"
                    ".inst 0x6f88eb1c // udot v28.4s, v24.16b, v8.4b[2]\n"
                    ".inst 0x6f8ceb1d // udot v29.4s, v24.16b, v12.4b[2]\n"
                    ".inst 0x6f90eb1e // udot v30.4s, v24.16b, v16.4b[2]\n"
                    ".inst 0x6f94eb1f // udot v31.4s, v24.16b, v20.4b[2]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa0eb3a // udot v26.4s, v25.16b, v0.4b[3]\n"
                    ".inst 0x6fa4eb3b // udot v27.4s, v25.16b, v4.4b[3]\n"
                    ".inst 0x6fa8eb3c // udot v28.4s, v25.16b, v8.4b[3]\n"
                    ".inst 0x6faceb3d // udot v29.4s, v25.16b, v12.4b[3]\n"
                    ".inst 0x6fb0eb3e // udot v30.4s, v25.16b, v16.4b[3]\n"
                    ".inst 0x6fb4eb3f // udot v31.4s, v25.16b, v20.4b[3]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f81e31a // udot v26.4s, v24.16b, v1.4b[0]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f85e31b // udot v27.4s, v24.16b, v5.4b[0]\n"
                    ".inst 0x6f89e31c // udot v28.4s, v24.16b, v9.4b[0]\n"
                    ".inst 0x6f8de31d // udot v29.4s, v24.16b, v13.4b[0]\n"
                    ".inst 0x6f91e31e // udot v30.4s, v24.16b, v17.4b[0]\n"
                    ".inst 0x6f95e31f // udot v31.4s, v24.16b, v21.4b[0]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa1e33a // udot v26.4s, v25.16b, v1.4b[1]\n"
                    ".inst 0x6fa5e33b // udot v27.4s, v25.16b, v5.4b[1]\n"
                    ".inst 0x6fa9e33c // udot v28.4s, v25.16b, v9.4b[1]\n"
                    ".inst 0x6fade33d // udot v29.4s, v25.16b, v13.4b[1]\n"
                    ".inst 0x6fb1e33e // udot v30.4s, v25.16b, v17.4b[1]\n"
                    ".inst 0x6fb5e33f // udot v31.4s, v25.16b, v21.4b[1]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f81eb1a // udot v26.4s, v24.16b, v1.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f85eb1b // udot v27.4s, v24.16b, v5.4b[2]\n"
                    ".inst 0x6f89eb1c // udot v28.4s, v24.16b, v9.4b[2]\n"
                    ".inst 0x6f8deb1d // udot v29.4s, v24.16b, v13.4b[2]\n"
                    ".inst 0x6f91eb1e // udot v30.4s, v24.16b, v17.4b[2]\n"
                    ".inst 0x6f95eb1f // udot v31.4s, v24.16b, v21.4b[2]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa1eb3a // udot v26.4s, v25.16b, v1.4b[3]\n"
                    ".inst 0x6fa5eb3b // udot v27.4s, v25.16b, v5.4b[3]\n"
                    ".inst 0x6fa9eb3c // udot v28.4s, v25.16b, v9.4b[3]\n"
                    ".inst 0x6fadeb3d // udot v29.4s, v25.16b, v13.4b[3]\n"
                    ".inst 0x6fb1eb3e // udot v30.4s, v25.16b, v17.4b[3]\n"
                    ".inst 0x6fb5eb3f // udot v31.4s, v25.16b, v21.4b[3]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f82e31a // udot v26.4s, v24.16b, v2.4b[0]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f86e31b // udot v27.4s, v24.16b, v6.4b[0]\n"
                    ".inst 0x6f8ae31c // udot v28.4s, v24.16b, v10.4b[0]\n"
                    ".inst 0x6f8ee31d // udot v29.4s, v24.16b, v14.4b[0]\n"
                    ".inst 0x6f92e31e // udot v30.4s, v24.16b, v18.4b[0]\n"
                    ".inst 0x6f96e31f // udot v31.4s, v24.16b, v22.4b[0]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa2e33a // udot v26.4s, v25.16b, v2.4b[1]\n"
                    ".inst 0x6fa6e33b // udot v27.4s, v25.16b, v6.4b[1]\n"
                    ".inst 0x6faae33c // udot v28.4s, v25.16b, v10.4b[1]\n"
                    ".inst 0x6faee33d // udot v29.4s, v25.16b, v14.4b[1]\n"
                    ".inst 0x6fb2e33e // udot v30.4s, v25.16b, v18.4b[1]\n"
                    ".inst 0x6fb6e33f // udot v31.4s, v25.16b, v22.4b[1]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f82eb1a // udot v26.4s, v24.16b, v2.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f86eb1b // udot v27.4s, v24.16b, v6.4b[2]\n"
                    ".inst 0x6f8aeb1c // udot v28.4s, v24.16b, v10.4b[2]\n"
                    ".inst 0x6f8eeb1d // udot v29.4s, v24.16b, v14.4b[2]\n"
                    ".inst 0x6f92eb1e // udot v30.4s, v24.16b, v18.4b[2]\n"
                    ".inst 0x6f96eb1f // udot v31.4s, v24.16b, v22.4b[2]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa2eb3a // udot v26.4s, v25.16b, v2.4b[3]\n"
                    ".inst 0x6fa6eb3b // udot v27.4s, v25.16b, v6.4b[3]\n"
                    ".inst 0x6faaeb3c // udot v28.4s, v25.16b, v10.4b[3]\n"
                    ".inst 0x6faeeb3d // udot v29.4s, v25.16b, v14.4b[3]\n"
                    ".inst 0x6fb2eb3e // udot v30.4s, v25.16b, v18.4b[3]\n"
                    ".inst 0x6fb6eb3f // udot v31.4s, v25.16b, v22.4b[3]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f83e31a // udot v26.4s, v24.16b, v3.4b[0]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f87e31b // udot v27.4s, v24.16b, v7.4b[0]\n"
                    ".inst 0x6f8be31c // udot v28.4s, v24.16b, v11.4b[0]\n"
                    ".inst 0x6f8fe31d // udot v29.4s, v24.16b, v15.4b[0]\n"
                    ".inst 0x6f93e31e // udot v30.4s, v24.16b, v19.4b[0]\n"
                    ".inst 0x6f97e31f // udot v31.4s, v24.16b, v23.4b[0]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa3e33a // udot v26.4s, v25.16b, v3.4b[1]\n"
                    ".inst 0x6fa7e33b // udot v27.4s, v25.16b, v7.4b[1]\n"
                    ".inst 0x6fabe33c // udot v28.4s, v25.16b, v11.4b[1]\n"
                    ".inst 0x6fafe33d // udot v29.4s, v25.16b, v15.4b[1]\n"
                    ".inst 0x6fb3e33e // udot v30.4s, v25.16b, v19.4b[1]\n"
                    ".inst 0x6fb7e33f // udot v31.4s, v25.16b, v23.4b[1]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f83eb1a // udot v26.4s, v24.16b, v3.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f87eb1b // udot v27.4s, v24.16b, v7.4b[2]\n"
                    ".inst 0x6f8beb1c // udot v28.4s, v24.16b, v11.4b[2]\n"
                    ".inst 0x6f8feb1d // udot v29.4s, v24.16b, v15.4b[2]\n"
                    ".inst 0x6f93eb1e // udot v30.4s, v24.16b, v19.4b[2]\n"
                    ".inst 0x6f97eb1f // udot v31.4s, v24.16b, v23.4b[2]\n"
                    ".inst 0x6fa3eb3a // udot v26.4s, v25.16b, v3.4b[3]\n"
                    ".inst 0x6fa7eb3b // udot v27.4s, v25.16b, v7.4b[3]\n"
                    ".inst 0x6fabeb3c // udot v28.4s, v25.16b, v11.4b[3]\n"
                    ".inst 0x6fafeb3d // udot v29.4s, v25.16b, v15.4b[3]\n"
                    ".inst 0x6fb3eb3e // udot v30.4s, v25.16b, v19.4b[3]\n"
                    ".inst 0x6fb7eb3f // udot v31.4s, v25.16b, v23.4b[3]\n"
                    "b 9f\n"
                    "6:\n"
                    "movi v26.4s, #0\n"
                    "movi v27.4s, #0\n"
                    "movi v28.4s, #0\n"
                    "movi v29.4s, #0\n"
                    "movi v30.4s, #0\n"
                    "movi v31.4s, #0\n"
                    ".inst 0x6f80e31a // udot v26.4s, v24.16b, v0.4b[0]\n"
                    ".inst 0x6f84e31b // udot v27.4s, v24.16b, v4.4b[0]\n"
                    ".inst 0x6f88e31c // udot v28.4s, v24.16b, v8.4b[0]\n"
                    ".inst 0x6f8ce31d // udot v29.4s, v24.16b, v12.4b[0]\n"
                    ".inst 0x6f90e31e // udot v30.4s, v24.16b, v16.4b[0]\n"
                    ".inst 0x6f94e31f // udot v31.4s, v24.16b, v20.4b[0]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa0e33a // udot v26.4s, v25.16b, v0.4b[1]\n"
                    ".inst 0x6fa4e33b // udot v27.4s, v25.16b, v4.4b[1]\n"
                    ".inst 0x6fa8e33c // udot v28.4s, v25.16b, v8.4b[1]\n"
                    ".inst 0x6face33d // udot v29.4s, v25.16b, v12.4b[1]\n"
                    ".inst 0x6fb0e33e // udot v30.4s, v25.16b, v16.4b[1]\n"
                    ".inst 0x6fb4e33f // udot v31.4s, v25.16b, v20.4b[1]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f80eb1a // udot v26.4s, v24.16b, v0.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f84eb1b // udot v27.4s, v24.16b, v4.4b[2]\n"
                    ".inst 0x6f88eb1c // udot v28.4s, v24.16b, v8.4b[2]\n"
                    ".inst 0x6f8ceb1d // udot v29.4s, v24.16b, v12.4b[2]\n"
                    ".inst 0x6f90eb1e // udot v30.4s, v24.16b, v16.4b[2]\n"
                    ".inst 0x6f94eb1f // udot v31.4s, v24.16b, v20.4b[2]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa0eb3a // udot v26.4s, v25.16b, v0.4b[3]\n"
                    ".inst 0x6fa4eb3b // udot v27.4s, v25.16b, v4.4b[3]\n"
                    ".inst 0x6fa8eb3c // udot v28.4s, v25.16b, v8.4b[3]\n"
                    ".inst 0x6faceb3d // udot v29.4s, v25.16b, v12.4b[3]\n"
                    ".inst 0x6fb0eb3e // udot v30.4s, v25.16b, v16.4b[3]\n"
                    ".inst 0x6fb4eb3f // udot v31.4s, v25.16b, v20.4b[3]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f81e31a // udot v26.4s, v24.16b, v1.4b[0]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f85e31b // udot v27.4s, v24.16b, v5.4b[0]\n"
                    ".inst 0x6f89e31c // udot v28.4s, v24.16b, v9.4b[0]\n"
                    ".inst 0x6f8de31d // udot v29.4s, v24.16b, v13.4b[0]\n"
                    ".inst 0x6f91e31e // udot v30.4s, v24.16b, v17.4b[0]\n"
                    ".inst 0x6f95e31f // udot v31.4s, v24.16b, v21.4b[0]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa1e33a // udot v26.4s, v25.16b, v1.4b[1]\n"
                    ".inst 0x6fa5e33b // udot v27.4s, v25.16b, v5.4b[1]\n"
                    ".inst 0x6fa9e33c // udot v28.4s, v25.16b, v9.4b[1]\n"
                    ".inst 0x6fade33d // udot v29.4s, v25.16b, v13.4b[1]\n"
                    ".inst 0x6fb1e33e // udot v30.4s, v25.16b, v17.4b[1]\n"
                    ".inst 0x6fb5e33f // udot v31.4s, v25.16b, v21.4b[1]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f81eb1a // udot v26.4s, v24.16b, v1.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f85eb1b // udot v27.4s, v24.16b, v5.4b[2]\n"
                    ".inst 0x6f89eb1c // udot v28.4s, v24.16b, v9.4b[2]\n"
                    ".inst 0x6f8deb1d // udot v29.4s, v24.16b, v13.4b[2]\n"
                    ".inst 0x6f91eb1e // udot v30.4s, v24.16b, v17.4b[2]\n"
                    ".inst 0x6f95eb1f // udot v31.4s, v24.16b, v21.4b[2]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa1eb3a // udot v26.4s, v25.16b, v1.4b[3]\n"
                    ".inst 0x6fa5eb3b // udot v27.4s, v25.16b, v5.4b[3]\n"
                    ".inst 0x6fa9eb3c // udot v28.4s, v25.16b, v9.4b[3]\n"
                    ".inst 0x6fadeb3d // udot v29.4s, v25.16b, v13.4b[3]\n"
                    ".inst 0x6fb1eb3e // udot v30.4s, v25.16b, v17.4b[3]\n"
                    ".inst 0x6fb5eb3f // udot v31.4s, v25.16b, v21.4b[3]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f82e31a // udot v26.4s, v24.16b, v2.4b[0]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f86e31b // udot v27.4s, v24.16b, v6.4b[0]\n"
                    ".inst 0x6f8ae31c // udot v28.4s, v24.16b, v10.4b[0]\n"
                    ".inst 0x6f8ee31d // udot v29.4s, v24.16b, v14.4b[0]\n"
                    ".inst 0x6f92e31e // udot v30.4s, v24.16b, v18.4b[0]\n"
                    ".inst 0x6f96e31f // udot v31.4s, v24.16b, v22.4b[0]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa2e33a // udot v26.4s, v25.16b, v2.4b[1]\n"
                    ".inst 0x6fa6e33b // udot v27.4s, v25.16b, v6.4b[1]\n"
                    ".inst 0x6faae33c // udot v28.4s, v25.16b, v10.4b[1]\n"
                    ".inst 0x6faee33d // udot v29.4s, v25.16b, v14.4b[1]\n"
                    ".inst 0x6fb2e33e // udot v30.4s, v25.16b, v18.4b[1]\n"
                    ".inst 0x6fb6e33f // udot v31.4s, v25.16b, v22.4b[1]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f82eb1a // udot v26.4s, v24.16b, v2.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f86eb1b // udot v27.4s, v24.16b, v6.4b[2]\n"
                    ".inst 0x6f8aeb1c // udot v28.4s, v24.16b, v10.4b[2]\n"
                    ".inst 0x6f8eeb1d // udot v29.4s, v24.16b, v14.4b[2]\n"
                    ".inst 0x6f92eb1e // udot v30.4s, v24.16b, v18.4b[2]\n"
                    ".inst 0x6f96eb1f // udot v31.4s, v24.16b, v22.4b[2]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa2eb3a // udot v26.4s, v25.16b, v2.4b[3]\n"
                    ".inst 0x6fa6eb3b // udot v27.4s, v25.16b, v6.4b[3]\n"
                    ".inst 0x6faaeb3c // udot v28.4s, v25.16b, v10.4b[3]\n"
                    ".inst 0x6faeeb3d // udot v29.4s, v25.16b, v14.4b[3]\n"
                    ".inst 0x6fb2eb3e // udot v30.4s, v25.16b, v18.4b[3]\n"
                    ".inst 0x6fb6eb3f // udot v31.4s, v25.16b, v22.4b[3]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f83e31a // udot v26.4s, v24.16b, v3.4b[0]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f87e31b // udot v27.4s, v24.16b, v7.4b[0]\n"
                    ".inst 0x6f8be31c // udot v28.4s, v24.16b, v11.4b[0]\n"
                    ".inst 0x6f8fe31d // udot v29.4s, v24.16b, v15.4b[0]\n"
                    ".inst 0x6f93e31e // udot v30.4s, v24.16b, v19.4b[0]\n"
                    ".inst 0x6f97e31f // udot v31.4s, v24.16b, v23.4b[0]\n"
                    "ldr q24, [%[b_ptr0]]\n"
                    ".inst 0x6fa3e33a // udot v26.4s, v25.16b, v3.4b[1]\n"
                    ".inst 0x6fa7e33b // udot v27.4s, v25.16b, v7.4b[1]\n"
                    ".inst 0x6fabe33c // udot v28.4s, v25.16b, v11.4b[1]\n"
                    ".inst 0x6fafe33d // udot v29.4s, v25.16b, v15.4b[1]\n"
                    ".inst 0x6fb3e33e // udot v30.4s, v25.16b, v19.4b[1]\n"
                    ".inst 0x6fb7e33f // udot v31.4s, v25.16b, v23.4b[1]\n"
                    "ldr q25, [%[b_ptr0], #0x10]\n"
                    ".inst 0x6f83eb1a // udot v26.4s, v24.16b, v3.4b[2]\n"
                    "add %[b_ptr0], %[b_ptr0], #0x20\n"
                    ".inst 0x6f87eb1b // udot v27.4s, v24.16b, v7.4b[2]\n"
                    ".inst 0x6f8beb1c // udot v28.4s, v24.16b, v11.4b[2]\n"
                    ".inst 0x6f8feb1d // udot v29.4s, v24.16b, v15.4b[2]\n"
                    ".inst 0x6f93eb1e // udot v30.4s, v24.16b, v19.4b[2]\n"
                    ".inst 0x6f97eb1f // udot v31.4s, v24.16b, v23.4b[2]\n"
                    ".inst 0x6fa3eb3a // udot v26.4s, v25.16b, v3.4b[3]\n"
                    ".inst 0x6fa7eb3b // udot v27.4s, v25.16b, v7.4b[3]\n"
                    ".inst 0x6fabeb3c // udot v28.4s, v25.16b, v11.4b[3]\n"
                    ".inst 0x6fafeb3d // udot v29.4s, v25.16b, v15.4b[3]\n"
                    ".inst 0x6fb3eb3e // udot v30.4s, v25.16b, v19.4b[3]\n"
                    ".inst 0x6fb7eb3f // udot v31.4s, v25.16b, v23.4b[3]\n"
                    "9:\n"
                    "str q26, [%[c_ptr0]]\n"
                    "add %[c_ptr0], %[c_ptr0], #0x10\n"
                    "str q27, [c_ptr1]\n"
                    "str q28, [c_ptr2]\n"
                    "str q29, [c_ptr3]\n"
                    "str q30, [c_ptr4]\n"
                    "str q31, [c_ptr5]\n"
                    ".unreq a_ptr1\n"
                    ".unreq a_ptr2\n"
                    ".unreq a_ptr3\n"
                    ".unreq a_ptr4\n"
                    ".unreq a_ptr5\n"
                    ".unreq c_ptr1\n"
                    ".unreq c_ptr2\n"
                    ".unreq c_ptr3\n"
                    ".unreq c_ptr4\n"
                    ".unreq c_ptr5\n"
                    ".unreq temploadreg0\n"
                    ".unreq temploadreg1\n"
                    ".unreq temploadreg2\n"
                    ".unreq temploadreg3\n"
                    : [a_ptr0] "+r" (a_ptr0), [b_ptr0] "+r" (b_ptr0), [c_ptr0] "+r" (c_ptr0), [loops] "+r" (loops), [oob_rows] "+r" (oob_rows), [odds] "+r" (odds)
                    : [lda] "r" (ldab), [ldc] "r" (ldcb)
                    : "x0", "x1", "x2", "x3", "x4", "x5", "x6", "x7", "x8", "x9", "x10", "x11", "x12", "x13", "v0", "v1", "v2", "v3", "v4", "v5", "v6", "v7", "v8", "v9", "v10", "v11", "v12", "v13", "v14", "v15", "v16", "v17", "v18", "v19", "v20", "v21", "v22", "v23", "v24", "v25", "v26", "v27", "v28", "v29", "v30", "v31", "cc", "memory"
                );
                break;
        }
    }
}

} // namespace arm_gemm

#endif // __aarch64__

