/*
 * Copyright (c) 2021-2024, 2026 Arm Limited.
 *
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#if defined(ARM_COMPUTE_ENABLE_SVE)

#include "arm_gemm/arm_gemm.hpp"
#include <cstdint>

namespace arm_conv {
namespace depthwise {

void sve_s8q_nhwc_3x3_s1_output2x2_dot_depthfirst_impl(const unsigned int n_channels, const int8_t *const *const inptrs, const int8_t *params, const int32_t *, const arm_gemm::Requantize32& qp, const int32_t *, const int32_t *, int8_t *const *const outptrs)
{
  __asm__ __volatile__(
    "mov x14, #0x0\n"
    "ldp x27, x26, [%x[inptrs], #0x0]\n"
    "ldp x25, x24, [%x[inptrs], #0x10]\n"
    "mov x28, #0x1\n"
    "ldp x23, x22, [%x[inptrs], #0x20]\n"
    "ldp x21, x20, [%x[inptrs], #0x30]\n"
    "ptrue p2.b\n"
    "mov x13, #0x0\n"
    "ldp x12, x11, [%x[outptrs], #0x0]\n"
    "ldp x10, x9, [%x[outptrs], #0x10]\n"
    "whilelt p0.b, x14, %x[n_channels]\n"
    "orr x28, x28, #0x100\n"
    "ld1rw { z31.s }, p2/Z, [%x[qp], %[offsetof_Requantize32_minval]]\n"
    "ld1rw { z15.s }, p2/Z, [%x[qp], %[offsetof_Requantize32_maxval]]\n"
    "ld1rw { z13.s }, p2/Z, [%x[qp], %[offsetof_Requantize32_b_offset]]\n"
    "ld1rw { z21.s }, p2/Z, [%x[qp], %[offsetof_Requantize32_c_offset]]\n"
    "ld1b { z12.b }, p0/Z, [x27, x14]\n"
    "ld1b { z24.b }, p0/Z, [x26, x14]\n"
    "orr x28, x28, #0x10000\n"
    "ldp x27, x26, [%x[inptrs], #0x40]\n"
    "ld1b { z26.b }, p0/Z, [x25, x14]\n"
    "ld1b { z14.b }, p0/Z, [x24, x14]\n"
    "ldp x25, x24, [%x[inptrs], #0x50]\n"
    "ld1b { z5.b }, p0/Z, [x23, x14]\n"
    "ld1b { z3.b }, p0/Z, [x22, x14]\n"
    "dup z9.s, w28\n"
    "ldp x23, x22, [%x[inptrs], #0x60]\n"
    "ld1b { z19.b }, p0/Z, [x21, x14]\n"
    "zip2 z18.b, z12.b, z26.b\n"
    "zip1 z12.b, z12.b, z26.b\n"
    "ld1b { z30.b }, p0/Z, [x20, x14]\n"
    "ldp x21, x20, [%x[inptrs], #0x70]\n"
    "zip1 z17.b, z24.b, z14.b\n"
    "zip2 z14.b, z24.b, z14.b\n"
    "ld1b { z29.b }, p0/Z, [x27, x14]\n"
    "ld1b { z25.b }, p0/Z, [x26, x14]\n"
    "ld1b { z16.b }, p0/Z, [x25, x14]\n"
    "ld1b { z7.b }, p0/Z, [x24, x14]\n"
    "zip2 z22.b, z5.b, z19.b\n"
    "zip1 z5.b, z5.b, z19.b\n"
    "ld1b { z6.b }, p0/Z, [x23, x14]\n"
    "ld1b { z28.b }, p0/Z, [x22, x14]\n"
    "zip2 z2.b, z12.b, z17.b\n"
    "zip1 z12.b, z12.b, z17.b\n"
    "ld1b { z23.b }, p0/Z, [x21, x14]\n"
    "ld1b { z4.b }, p0/Z, [x20, x14]\n"
    "zip1 z8.b, z18.b, z14.b\n"
    "zip2 z14.b, z18.b, z14.b\n"
    "zip1 z26.b, z3.b, z30.b\n"
    "zip2 z30.b, z3.b, z30.b\n"
    "ld1w { z0.s }, p2/Z, [%x[params]]\n"
    "ldp x28, x27, [%x[inptrs], #0x0]\n"
    "zip2 z24.b, z29.b, z16.b\n"
    "zip1 z29.b, z29.b, z16.b\n"
    "ldp x26, x25, [%x[inptrs], #0x10]\n"
    "ldp x24, x22, [%x[inptrs], #0x20]\n"
    "zip1 z16.b, z25.b, z7.b\n"
    "zip2 z7.b, z25.b, z7.b\n"
    "ldp x21, x20, [%x[inptrs], #0x30]\n"
    "ld1b { z17.b }, p2/Z, [%x[params], #1, MUL VL]\n"
    "zip2 z25.b, z6.b, z23.b\n"
    "zip1 z6.b, z6.b, z23.b\n"
    "ld1b { z20.b }, p2/Z, [%x[params], #2, MUL VL]\n"
    "ld1b { z10.b }, p2/Z, [%x[params], #3, MUL VL]\n"
    "zip1 z19.b, z28.b, z4.b\n"
    "zip2 z4.b, z28.b, z4.b\n"
    "addvl %x[params], %x[params], #4\n"
    "zip2 z23.b, z5.b, z26.b\n"
    "zip1 z5.b, z5.b, z26.b\n"
    "zip1 z3.b, z22.b, z30.b\n"
    "zip2 z30.b, z22.b, z30.b\n"
    "zip2 z11.b, z29.b, z16.b\n"
    "zip1 z29.b, z29.b, z16.b\n"
    "zip1 z16.b, z24.b, z7.b\n"
    "zip2 z7.b, z24.b, z7.b\n"
    "zip2 z1.b, z6.b, z19.b\n"
    "zip1 z6.b, z6.b, z19.b\n"
    "zip1 z27.b, z25.b, z4.b\n"
    "zip2 z4.b, z25.b, z4.b\n"
    "mov z26.d, z0.d\n"
    "mov z25.d, z0.d\n"
    "mov z28.d, z0.d\n"
    "1:"  // Loop
    "mov z24.s, #0x0\n"
    "sdot z0.s, z17.b, z12.b\n"
    "sdot z25.s, z17.b, z5.b\n"
    "whilelt p0.s, x13, %x[n_channels]\n"
    "mov z18.s, #0x0\n"
    "incw x14, ALL, MUL #4\n"
    "sdot z24.s, z9.b, z5.b\n"
    "sdot z0.s, z20.b, z5.b\n"
    "ext z5.b, z5.b, z5.b, #0x1\n"
    "sdot z25.s, z20.b, z29.b\n"
    "sdot z24.s, z9.b, z29.b\n"
    "sdot z18.s, z9.b, z5.b\n"
    "sdot z0.s, z10.b, z29.b\n"
    "ext z29.b, z29.b, z29.b, #0x1\n"
    "sdot z28.s, z17.b, z5.b\n"
    "movprfx z19, z24\n sdot z19.s, z9.b, z6.b\n"
    "sdot z24.s, z9.b, z12.b\n"
    "ext z12.b, z12.b, z12.b, #0x1\n"
    "sdot z25.s, z10.b, z6.b\n"
    "ext z6.b, z6.b, z6.b, #0x1\n"
    "sdot z18.s, z9.b, z29.b\n"
    "sdot z26.s, z17.b, z12.b\n"
    "sdot z28.s, z20.b, z29.b\n"
    "mls z0.s, p2/M, z24.s, z13.s\n"
    "mov z22.s, #0x0\n"
    "mls z25.s, p2/M, z19.s, z13.s\n"
    "sdot z22.s, z9.b, z23.b\n"
    "sdot z26.s, z20.b, z5.b\n"
    "ld1w { z20.s }, p2/Z, [%x[params], #1, MUL VL]\n"
    "movprfx z5, z18\n sdot z5.s, z9.b, z6.b\n"
    "sdot z18.s, z9.b, z12.b\n"
    "ld1w { z19.s }, p2/Z, [%x[params]]\n"
    "sdot z28.s, z10.b, z6.b\n"
    "sdot z22.s, z9.b, z11.b\n"
    "sdot z26.s, z10.b, z29.b\n"
    ".inst 0x04b37400  // sqrdmulh z0.s, z0.s, z19.s\n"
    ".inst 0x04b37739  // sqrdmulh z25.s, z25.s, z19.s\n"
    "mls z28.s, p2/M, z5.s, z13.s\n"
    "and z5.d, z0.d, z20.d\n"
    "mls z26.s, p2/M, z18.s, z13.s\n"
    "mov z18.s, #0x0\n"
    "and z12.d, z25.d, z20.d\n"
    "movprfx z10, z22\n sdot z10.s, z9.b, z1.b\n"
    "sdot z22.s, z9.b, z2.b\n"
    "asr z5.s, z5.s, #0x1f\n"
    ".inst 0x04b3779c  // sqrdmulh z28.s, z28.s, z19.s\n"
    ".inst 0x04b3775a  // sqrdmulh z26.s, z26.s, z19.s\n"
    "ld1w { z24.s }, p2/Z, [%x[params], #6, MUL VL]\n"
    "asr z12.s, z12.s, #0x1f\n"
    "sqadd z0.s, z0.s, z5.s\n"
    "and z19.d, z26.d, z20.d\n"
    "and z6.d, z28.d, z20.d\n"
    ".inst 0x44828a80  // srshl z0.s, p2/M, z0.s, z20.s\n"
    "sqadd z25.s, z25.s, z12.s\n"
    "ld1b { z5.b }, p2/Z, [%x[params], #5, MUL VL]\n"
    "asr z19.s, z19.s, #0x1f\n"
    "asr z6.s, z6.s, #0x1f\n"
    "add z0.s, z0.s, z21.s\n"
    "sqadd z26.s, z26.s, z19.s\n"
    "ld1b { z19.b }, p2/Z, [%x[params], #4, MUL VL]\n"
    ".inst 0x44828a99  // srshl z25.s, p2/M, z25.s, z20.s\n"
    "sqadd z28.s, z28.s, z6.s\n"
    "ld1b { z17.b }, p2/Z, [%x[params], #3, MUL VL]\n"
    "smax z0.s, p2/M, z0.s, z31.s\n"
    ".inst 0x44828a9a  // srshl z26.s, p2/M, z26.s, z20.s\n"
    ".inst 0x44828a9c  // srshl z28.s, p2/M, z28.s, z20.s\n"
    "ld1w { z12.s }, p2/Z, [%x[params], #7, MUL VL]\n"
    "add z25.s, z25.s, z21.s\n"
    "add z26.s, z26.s, z21.s\n"
    "smin z0.s, p2/M, z0.s, z15.s\n"
    "add z28.s, z28.s, z21.s\n"
    "smax z26.s, p2/M, z26.s, z31.s\n"
    "smax z25.s, p2/M, z25.s, z31.s\n"
    "smax z28.s, p2/M, z28.s, z31.s\n"
    "st1b { z0.s }, p0, [x12, x13]\n"
    "ld1w { z29.s }, p2/Z, [%x[params], #2, MUL VL]\n"
    "addvl %x[params], %x[params], #16\n"
    "smin z26.s, p2/M, z26.s, z15.s\n"
    "smin z25.s, p2/M, z25.s, z15.s\n"
    "smin z28.s, p2/M, z28.s, z15.s\n"
    "st1b { z26.s }, p0, [x11, x13]\n"
    "mov z6.d, z29.d\n"
    "st1b { z25.s }, p0, [x10, x13]\n"
    "mov z25.d, z29.d\n"
    "st1b { z28.s }, p0, [x9, x13]\n"
    "mov z0.d, z29.d\n"
    "sdot z29.s, z17.b, z2.b\n"
    "incw x13\n"
    "sdot z25.s, z17.b, z23.b\n"
    "ext z2.b, z2.b, z2.b, #0x1\n"
    "whilelt p0.s, x13, %x[n_channels]\n"
    "sdot z29.s, z19.b, z23.b\n"
    "ext z23.b, z23.b, z23.b, #0x1\n"
    "sdot z6.s, z17.b, z2.b\n"
    "sdot z0.s, z17.b, z23.b\n"
    "sdot z18.s, z9.b, z23.b\n"
    "sdot z25.s, z19.b, z11.b\n"
    "sdot z29.s, z5.b, z11.b\n"
    "ext z11.b, z11.b, z11.b, #0x1\n"
    "sdot z6.s, z19.b, z23.b\n"
    "sdot z0.s, z19.b, z11.b\n"
    "sdot z18.s, z9.b, z11.b\n"
    "sdot z25.s, z5.b, z1.b\n"
    "ext z1.b, z1.b, z1.b, #0x1\n"
    "mls z29.s, p2/M, z22.s, z13.s\n"
    "mov z28.s, #0x0\n"
    "sdot z6.s, z5.b, z11.b\n"
    "sdot z0.s, z5.b, z1.b\n"
    "movprfx z11, z18\n sdot z11.s, z9.b, z1.b\n"
    "sdot z18.s, z9.b, z2.b\n"
    "sdot z28.s, z9.b, z3.b\n"
    ".inst 0x04b877bd  // sqrdmulh z29.s, z29.s, z24.s\n"
    "mls z25.s, p2/M, z10.s, z13.s\n"
    "mls z6.s, p2/M, z18.s, z13.s\n"
    "mov z1.s, #0x0\n"
    "mls z0.s, p2/M, z11.s, z13.s\n"
    "and z11.d, z29.d, z12.d\n"
    ".inst 0x04b87739  // sqrdmulh z25.s, z25.s, z24.s\n"
    "sdot z28.s, z9.b, z16.b\n"
    "asr z11.s, z11.s, #0x1f\n"
    ".inst 0x04b874c6  // sqrdmulh z6.s, z6.s, z24.s\n"
    ".inst 0x04b87400  // sqrdmulh z0.s, z0.s, z24.s\n"
    "ld1w { z5.s }, p2/Z, [%x[params], #-4, MUL VL]\n"
    "and z22.d, z25.d, z12.d\n"
    "sqadd z29.s, z29.s, z11.s\n"
    "and z18.d, z6.d, z12.d\n"
    "movprfx z24, z28\n sdot z24.s, z9.b, z27.b\n"
    "sdot z28.s, z9.b, z8.b\n"
    "and z11.d, z0.d, z12.d\n"
    "asr z22.s, z22.s, #0x1f\n"
    "asr z18.s, z18.s, #0x1f\n"
    ".inst 0x4482899d  // srshl z29.s, p2/M, z29.s, z12.s\n"
    "asr z11.s, z11.s, #0x1f\n"
    "sqadd z6.s, z6.s, z18.s\n"
    "ld1b { z20.b }, p2/Z, [%x[params], #-6, MUL VL]\n"
    "sqadd z25.s, z25.s, z22.s\n"
    "ld1b { z19.b }, p2/Z, [%x[params], #-5, MUL VL]\n"
    "add z29.s, z29.s, z21.s\n"
    "sqadd z0.s, z0.s, z11.s\n"
    "ld1b { z18.b }, p2/Z, [%x[params], #-7, MUL VL]\n"
    ".inst 0x44828986  // srshl z6.s, p2/M, z6.s, z12.s\n"
    ".inst 0x44828999  // srshl z25.s, p2/M, z25.s, z12.s\n"
    "smax z29.s, p2/M, z29.s, z31.s\n"
    ".inst 0x44828980  // srshl z0.s, p2/M, z0.s, z12.s\n"
    "ld1w { z23.s }, p2/Z, [%x[params], #-3, MUL VL]\n"
    "add z6.s, z6.s, z21.s\n"
    "add z25.s, z25.s, z21.s\n"
    "add z0.s, z0.s, z21.s\n"
    "smin z29.s, p2/M, z29.s, z15.s\n"
    "smax z6.s, p2/M, z6.s, z31.s\n"
    "smax z25.s, p2/M, z25.s, z31.s\n"
    "smax z0.s, p2/M, z0.s, z31.s\n"
    "st1b { z29.s }, p0, [x12, x13]\n"
    "ld1w { z29.s }, p2/Z, [%x[params], #-8, MUL VL]\n"
    "smin z6.s, p2/M, z6.s, z15.s\n"
    "smin z25.s, p2/M, z25.s, z15.s\n"
    "smin z0.s, p2/M, z0.s, z15.s\n"
    "st1b { z6.s }, p0, [x11, x13]\n"
    "mov z11.d, z29.d\n"
    "st1b { z25.s }, p0, [x10, x13]\n"
    "mov z26.d, z29.d\n"
    "st1b { z0.s }, p0, [x9, x13]\n"
    "mov z25.d, z29.d\n"
    "sdot z29.s, z18.b, z8.b\n"
    "incw x13\n"
    "sdot z26.s, z18.b, z3.b\n"
    "ext z8.b, z8.b, z8.b, #0x1\n"
    "whilelt p0.s, x13, %x[n_channels]\n"
    "sdot z29.s, z20.b, z3.b\n"
    "ext z3.b, z3.b, z3.b, #0x1\n"
    "sdot z11.s, z18.b, z8.b\n"
    "sdot z25.s, z18.b, z3.b\n"
    "sdot z1.s, z9.b, z3.b\n"
    "sdot z26.s, z20.b, z16.b\n"
    "sdot z29.s, z19.b, z16.b\n"
    "ext z16.b, z16.b, z16.b, #0x1\n"
    "sdot z11.s, z20.b, z3.b\n"
    "sdot z25.s, z20.b, z16.b\n"
    "sdot z1.s, z9.b, z16.b\n"
    "sdot z26.s, z19.b, z27.b\n"
    "ext z27.b, z27.b, z27.b, #0x1\n"
    "mls z29.s, p2/M, z28.s, z13.s\n"
    "mov z22.s, #0x0\n"
    "sdot z11.s, z19.b, z16.b\n"
    "sdot z25.s, z19.b, z27.b\n"
    "movprfx z18, z1\n sdot z18.s, z9.b, z27.b\n"
    "sdot z1.s, z9.b, z8.b\n"
    "sdot z22.s, z9.b, z30.b\n"
    ".inst 0x04a577bd  // sqrdmulh z29.s, z29.s, z5.s\n"
    "mls z26.s, p2/M, z24.s, z13.s\n"
    "mls z11.s, p2/M, z1.s, z13.s\n"
    "mov z10.s, #0x0\n"
    "mls z25.s, p2/M, z18.s, z13.s\n"
    "and z18.d, z29.d, z23.d\n"
    ".inst 0x04a5775a  // sqrdmulh z26.s, z26.s, z5.s\n"
    "sdot z22.s, z9.b, z7.b\n"
    "asr z18.s, z18.s, #0x1f\n"
    ".inst 0x04a5756b  // sqrdmulh z11.s, z11.s, z5.s\n"
    ".inst 0x04a57739  // sqrdmulh z25.s, z25.s, z5.s\n"
    "ld1w { z8.s }, p2/Z, [%x[params], #2, MUL VL]\n"
    "and z19.d, z26.d, z23.d\n"
    "sqadd z29.s, z29.s, z18.s\n"
    "and z18.d, z11.d, z23.d\n"
    "movprfx z6, z22\n sdot z6.s, z9.b, z4.b\n"
    "sdot z22.s, z9.b, z14.b\n"
    "and z20.d, z25.d, z23.d\n"
    "asr z19.s, z19.s, #0x1f\n"
    "asr z18.s, z18.s, #0x1f\n"
    ".inst 0x44828afd  // srshl z29.s, p2/M, z29.s, z23.s\n"
    "asr z20.s, z20.s, #0x1f\n"
    "sqadd z11.s, z11.s, z18.s\n"
    "ld1b { z24.b }, p2/Z, [%x[params]]\n"
    "sqadd z26.s, z26.s, z19.s\n"
    "ld1b { z19.b }, p2/Z, [%x[params], #1, MUL VL]\n"
    "add z29.s, z29.s, z21.s\n"
    "sqadd z25.s, z25.s, z20.s\n"
    "ld1b { z18.b }, p2/Z, [%x[params], #-1, MUL VL]\n"
    ".inst 0x44828aeb  // srshl z11.s, p2/M, z11.s, z23.s\n"
    ".inst 0x44828afa  // srshl z26.s, p2/M, z26.s, z23.s\n"
    "smax z29.s, p2/M, z29.s, z31.s\n"
    ".inst 0x44828af9  // srshl z25.s, p2/M, z25.s, z23.s\n"
    "ld1w { z23.s }, p2/Z, [%x[params], #3, MUL VL]\n"
    "add z11.s, z11.s, z21.s\n"
    "add z26.s, z26.s, z21.s\n"
    "add z25.s, z25.s, z21.s\n"
    "smin z29.s, p2/M, z29.s, z15.s\n"
    "smax z11.s, p2/M, z11.s, z31.s\n"
    "smax z26.s, p2/M, z26.s, z31.s\n"
    "smax z25.s, p2/M, z25.s, z31.s\n"
    "st1b { z29.s }, p0, [x12, x13]\n"
    "ld1w { z2.s }, p2/Z, [%x[params], #-2, MUL VL]\n"
    "smin z11.s, p2/M, z11.s, z15.s\n"
    "smin z26.s, p2/M, z26.s, z15.s\n"
    "smin z25.s, p2/M, z25.s, z15.s\n"
    "st1b { z11.s }, p0, [x11, x13]\n"
    "mov z28.d, z2.d\n"
    "st1b { z26.s }, p0, [x10, x13]\n"
    "mov z1.d, z2.d\n"
    "st1b { z25.s }, p0, [x9, x13]\n"
    "mov z3.d, z2.d\n"
    "sdot z2.s, z18.b, z14.b\n"
    "incw x13\n"
    "sdot z1.s, z18.b, z30.b\n"
    "ext z14.b, z14.b, z14.b, #0x1\n"
    "whilelt p1.s, x13, %x[n_channels]\n"
    "whilelt p0.b, x14, %x[n_channels]\n"
    "sdot z2.s, z24.b, z30.b\n"
    "ext z30.b, z30.b, z30.b, #0x1\n"
    "sdot z28.s, z18.b, z14.b\n"
    "ld1b { z0.b }, p0/Z, [x27, x14]\n"
    "ld1b { z27.b }, p0/Z, [x26, x14]\n"
    "ld1b { z26.b }, p0/Z, [x22, x14]\n"
    "ld1b { z25.b }, p0/Z, [x21, x14]\n"
    "sdot z3.s, z18.b, z30.b\n"
    "sdot z10.s, z9.b, z30.b\n"
    "sdot z1.s, z24.b, z7.b\n"
    "sdot z2.s, z19.b, z7.b\n"
    "ext z7.b, z7.b, z7.b, #0x1\n"
    "sdot z28.s, z24.b, z30.b\n"
    "ld1b { z30.b }, p0/Z, [x20, x14]\n"
    "sdot z3.s, z24.b, z7.b\n"
    "sdot z10.s, z9.b, z7.b\n"
    "sdot z1.s, z19.b, z4.b\n"
    "ext z4.b, z4.b, z4.b, #0x1\n"
    "mls z2.s, p2/M, z22.s, z13.s\n"
    "sdot z28.s, z19.b, z7.b\n"
    "sdot z3.s, z19.b, z4.b\n"
    "movprfx z18, z10\n sdot z18.s, z9.b, z4.b\n"
    "sdot z10.s, z9.b, z14.b\n"
    "ld1b { z14.b }, p0/Z, [x25, x14]\n"
    "mls z1.s, p2/M, z6.s, z13.s\n"
    ".inst 0x04a87442  // sqrdmulh z2.s, z2.s, z8.s\n"
    "mls z3.s, p2/M, z18.s, z13.s\n"
    "and z18.d, z2.d, z23.d\n"
    "mls z28.s, p2/M, z10.s, z13.s\n"
    "asr z18.s, z18.s, #0x1f\n"
    ".inst 0x04a87421  // sqrdmulh z1.s, z1.s, z8.s\n"
    ".inst 0x04a8779c  // sqrdmulh z28.s, z28.s, z8.s\n"
    ".inst 0x04a87463  // sqrdmulh z3.s, z3.s, z8.s\n"
    "ld1b { z12.b }, p0/Z, [x28, x14]\n"
    "ldp x23, x22, [%x[inptrs], #0x40]\n"
    "ldp x21, x20, [%x[inptrs], #0x50]\n"
    "sqadd z2.s, z2.s, z18.s\n"
    "and z22.d, z1.d, z23.d\n"
    "and z18.d, z28.d, z23.d\n"
    "and z19.d, z3.d, z23.d\n"
    "ld1b { z29.b }, p0/Z, [x23, x14]\n"
    "ld1b { z24.b }, p0/Z, [x22, x14]\n"
    "asr z22.s, z22.s, #0x1f\n"
    ".inst 0x44828ae2  // srshl z2.s, p2/M, z2.s, z23.s\n"
    "ld1b { z11.b }, p0/Z, [x21, x14]\n"
    "ld1b { z7.b }, p0/Z, [x20, x14]\n"
    "asr z18.s, z18.s, #0x1f\n"
    "asr z19.s, z19.s, #0x1f\n"
    "sqadd z1.s, z1.s, z22.s\n"
    "ld1b { z10.b }, p2/Z, [%x[params], #7, MUL VL]\n"
    "add z2.s, z2.s, z21.s\n"
    "sqadd z28.s, z28.s, z18.s\n"
    "ld1b { z20.b }, p2/Z, [%x[params], #6, MUL VL]\n"
    "sqadd z3.s, z3.s, z19.s\n"
    "ld1b { z17.b }, p2/Z, [%x[params], #5, MUL VL]\n"
    ".inst 0x44828ae1  // srshl z1.s, p2/M, z1.s, z23.s\n"
    "smax z2.s, p2/M, z2.s, z31.s\n"
    ".inst 0x44828afc  // srshl z28.s, p2/M, z28.s, z23.s\n"
    ".inst 0x44828ae3  // srshl z3.s, p2/M, z3.s, z23.s\n"
    "ld1b { z5.b }, p0/Z, [x24, x14]\n"
    "ldp x23, x22, [%x[inptrs], #0x60]\n"
    "ldp x21, x20, [%x[inptrs], #0x70]\n"
    "ldp x28, x27, [%x[inptrs], #0x0]\n"
    "add z1.s, z1.s, z21.s\n"
    "smin z2.s, p2/M, z2.s, z15.s\n"
    "ldp x26, x25, [%x[inptrs], #0x10]\n"
    "add z28.s, z28.s, z21.s\n"
    "add z3.s, z3.s, z21.s\n"
    "ld1b { z6.b }, p0/Z, [x23, x14]\n"
    "ld1b { z23.b }, p0/Z, [x22, x14]\n"
    "ldp x24, x22, [%x[inptrs], #0x20]\n"
    "smax z1.s, p2/M, z1.s, z31.s\n"
    "st1b { z2.s }, p1, [x12, x13]\n"
    "ld1b { z22.b }, p0/Z, [x21, x14]\n"
    "ld1b { z4.b }, p0/Z, [x20, x14]\n"
    "zip2 z19.b, z12.b, z27.b\n"
    "zip1 z12.b, z12.b, z27.b\n"
    "smax z28.s, p2/M, z28.s, z31.s\n"
    "smax z3.s, p2/M, z3.s, z31.s\n"
    "zip1 z18.b, z0.b, z14.b\n"
    "zip2 z14.b, z0.b, z14.b\n"
    "smin z1.s, p2/M, z1.s, z15.s\n"
    "ldp x21, x20, [%x[inptrs], #0x30]\n"
    "smin z28.s, p2/M, z28.s, z15.s\n"
    "smin z3.s, p2/M, z3.s, z15.s\n"
    "zip2 z2.b, z12.b, z18.b\n"
    "zip1 z12.b, z12.b, z18.b\n"
    "zip1 z8.b, z19.b, z14.b\n"
    "zip2 z14.b, z19.b, z14.b\n"
    "ld1w { z0.s }, p2/Z, [%x[params], #4, MUL VL]\n"
    "addvl %x[params], %x[params], #8\n"
    "st1b { z28.s }, p1, [x11, x13]\n"
    "zip2 z27.b, z5.b, z25.b\n"
    "zip1 z5.b, z5.b, z25.b\n"
    "st1b { z1.s }, p1, [x10, x13]\n"
    "zip1 z18.b, z26.b, z30.b\n"
    "zip2 z30.b, z26.b, z30.b\n"
    "st1b { z3.s }, p1, [x9, x13]\n"
    "zip2 z19.b, z29.b, z11.b\n"
    "zip1 z29.b, z29.b, z11.b\n"
    "incw x13\n"
    "zip1 z28.b, z24.b, z7.b\n"
    "zip2 z7.b, z24.b, z7.b\n"
    "zip2 z25.b, z6.b, z22.b\n"
    "zip1 z6.b, z6.b, z22.b\n"
    "zip1 z22.b, z23.b, z4.b\n"
    "zip2 z4.b, z23.b, z4.b\n"
    "zip2 z23.b, z5.b, z18.b\n"
    "zip1 z5.b, z5.b, z18.b\n"
    "zip1 z3.b, z27.b, z30.b\n"
    "zip2 z30.b, z27.b, z30.b\n"
    "zip2 z11.b, z29.b, z28.b\n"
    "zip1 z29.b, z29.b, z28.b\n"
    "zip1 z16.b, z19.b, z7.b\n"
    "zip2 z7.b, z19.b, z7.b\n"
    "zip2 z1.b, z6.b, z22.b\n"
    "zip1 z6.b, z6.b, z22.b\n"
    "zip1 z27.b, z25.b, z4.b\n"
    "zip2 z4.b, z25.b, z4.b\n"
    "mov z26.d, z0.d\n"
    "mov z25.d, z0.d\n"
    "mov z28.d, z0.d\n"
    "b.any 1b\n"
    : [params] "+&r" (params)
    : [inptrs] "r" (inptrs), [n_channels] "r" (n_channels), [offsetof_Requantize32_b_offset] "I" (offsetof(arm_gemm::Requantize32, b_offset)), [offsetof_Requantize32_c_offset] "I" (offsetof(arm_gemm::Requantize32, c_offset)), [offsetof_Requantize32_maxval] "I" (offsetof(arm_gemm::Requantize32, maxval)), [offsetof_Requantize32_minval] "I" (offsetof(arm_gemm::Requantize32, minval)), [outptrs] "r" (outptrs), [qp] "r" (&qp)
    : "cc", "memory", "p0", "p1", "p2", "x9", "x10", "x11", "x12", "x13", "x14", "x20", "x21", "x22", "x23", "x24", "x25", "x26", "x27", "x28", "z0", "z1", "z2", "z3", "z4", "z5", "z6", "z7", "z8", "z9", "z10", "z11", "z12", "z13", "z14", "z15", "z16", "z17", "z18", "z19", "z20", "z21", "z22", "z23", "z24", "z25", "z26", "z27", "z28", "z29", "z30", "z31"
  );
}

}  // namespace depthwise
}  // namespace arm_conv

#endif  // defined(ARM_COMPUTE_ENABLE_SVE)
