/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.presets;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.data.preferences.sources.PresetPrefHelper;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetItem;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetMenu;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetSeparator;
import org.openstreetmap.josm.gui.tagging.presets.items.Check;
import org.openstreetmap.josm.gui.tagging.presets.items.CheckGroup;
import org.openstreetmap.josm.gui.tagging.presets.items.Combo;
import org.openstreetmap.josm.gui.tagging.presets.items.ComboMultiSelect;
import org.openstreetmap.josm.gui.tagging.presets.items.ItemSeparator;
import org.openstreetmap.josm.gui.tagging.presets.items.Key;
import org.openstreetmap.josm.gui.tagging.presets.items.Label;
import org.openstreetmap.josm.gui.tagging.presets.items.Link;
import org.openstreetmap.josm.gui.tagging.presets.items.MultiSelect;
import org.openstreetmap.josm.gui.tagging.presets.items.Optional;
import org.openstreetmap.josm.gui.tagging.presets.items.PresetLink;
import org.openstreetmap.josm.gui.tagging.presets.items.Roles;
import org.openstreetmap.josm.gui.tagging.presets.items.Space;
import org.openstreetmap.josm.gui.tagging.presets.items.Text;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.io.NetworkManager;
import org.openstreetmap.josm.io.UTFInputStreamReader;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.XmlObjectParser;
import org.xml.sax.SAXException;

public final class TaggingPresetReader {
    public static final String PRESET_MIME_TYPES = "application/xml, text/xml, text/plain; q=0.8, application/zip, application/octet-stream; q=0.5";
    private static volatile File zipIcons;
    private static volatile boolean loadIcons;

    public static Set<String> getPresetSources() {
        return new PresetPrefHelper().getActiveUrls();
    }

    private static XmlObjectParser buildParser() {
        XmlObjectParser parser = new XmlObjectParser();
        parser.mapOnStart("item", TaggingPreset.class);
        parser.mapOnStart("separator", TaggingPresetSeparator.class);
        parser.mapBoth("group", TaggingPresetMenu.class);
        parser.map("text", Text.class);
        parser.map("link", Link.class);
        parser.map("preset_link", PresetLink.class);
        parser.mapOnStart("optional", Optional.class);
        parser.mapOnStart("roles", Roles.class);
        parser.map("role", Roles.Role.class);
        parser.map("checkgroup", CheckGroup.class);
        parser.map("check", Check.class);
        parser.map("combo", Combo.class);
        parser.map("multiselect", MultiSelect.class);
        parser.map("label", Label.class);
        parser.map("space", Space.class);
        parser.map("key", Key.class);
        parser.map("list_entry", ComboMultiSelect.PresetListEntry.class);
        parser.map("item_separator", ItemSeparator.class);
        parser.mapBoth("chunk", Chunk.class);
        parser.map("reference", Reference.class);
        return parser;
    }

    public static Collection<TaggingPreset> readAll(Reader in, boolean validate) throws SAXException {
        return TaggingPresetReader.readAll(in, validate, new HashSetWithLast<TaggingPreset>());
    }

    static Collection<TaggingPreset> readAll(Reader in, boolean validate, HashSetWithLast<TaggingPreset> all) throws SAXException {
        XmlObjectParser parser = TaggingPresetReader.buildParser();
        TaggingPreset lastmenu = null;
        TaggingPreset lastmenuOriginal = null;
        Roles lastrole = null;
        LinkedList<Check> checks = new LinkedList<Check>();
        LinkedList<ComboMultiSelect.PresetListEntry> listEntries = new LinkedList<ComboMultiSelect.PresetListEntry>();
        HashMap byId = new HashMap();
        ArrayDeque<String> lastIds = new ArrayDeque<String>();
        ArrayDeque lastIdIterators = new ArrayDeque();
        if (validate) {
            parser.startWithValidation(in, Config.getUrls().getXMLBase() + "/tagging-preset-1.0", "resource://data/tagging-preset.xsd");
        } else {
            parser.start(in);
        }
        while (parser.hasNext() || !lastIdIterators.isEmpty()) {
            TaggingPreset tp;
            Object o;
            if (!lastIdIterators.isEmpty()) {
                o = ((Iterator)lastIdIterators.peek()).next();
                if (!((Iterator)lastIdIterators.peek()).hasNext()) {
                    lastIdIterators.pop();
                }
            } else {
                o = parser.next();
            }
            Logging.trace("Preset object: {0}", o);
            if (o instanceof Chunk) {
                if (!lastIds.isEmpty() && ((Chunk)o).id.equals(lastIds.peek())) {
                    lastIds.pop();
                    ((Chunk)o).id = null;
                    continue;
                }
                String lastId = ((Chunk)o).id;
                lastIds.push(lastId);
                byId.put(lastId, new ArrayList());
                continue;
            }
            if (!lastIds.isEmpty()) {
                ((List)byId.get(lastIds.peek())).add(o);
                continue;
            }
            if (o instanceof Reference) {
                String ref = ((Reference)o).ref;
                if (byId.get(ref) == null) {
                    throw new SAXException(I18n.tr("Reference {0} is being used before it was defined", ref));
                }
                Iterator it = ((List)byId.get(ref)).iterator();
                if (it.hasNext()) {
                    lastIdIterators.push(it);
                    continue;
                }
                Logging.warn("Ignoring reference '" + ref + "' denoting an empty chunk");
                continue;
            }
            if (!(o instanceof TaggingPresetItem) && !checks.isEmpty()) {
                all.getLast().data.addAll(checks);
                checks.clear();
            }
            if (o instanceof TaggingPresetMenu) {
                tp = (TaggingPresetMenu)o;
                if (tp == lastmenu || tp == lastmenuOriginal) {
                    lastmenu = ((TaggingPresetMenu)tp).group;
                } else {
                    ((TaggingPresetMenu)tp).group = lastmenu;
                    if (all.contains(tp)) {
                        lastmenuOriginal = tp;
                        java.util.Optional<TaggingPreset> val = all.stream().filter(((TaggingPresetMenu)tp)::equals).findFirst();
                        if (val.isPresent()) {
                            tp = (TaggingPresetMenu)val.get();
                        }
                        ((TaggingPresetMenu)lastmenuOriginal).group = null;
                    } else {
                        ((TaggingPresetMenu)tp).setDisplayName();
                        all.add(tp);
                        lastmenuOriginal = null;
                    }
                    lastmenu = tp;
                }
                lastrole = null;
                continue;
            }
            if (o instanceof TaggingPresetSeparator) {
                tp = (TaggingPresetSeparator)o;
                ((TaggingPresetSeparator)tp).group = lastmenu;
                all.add(tp);
                lastrole = null;
                continue;
            }
            if (o instanceof TaggingPreset) {
                tp = (TaggingPreset)o;
                tp.group = lastmenu;
                tp.setDisplayName();
                all.add(tp);
                lastrole = null;
                continue;
            }
            if (!all.isEmpty()) {
                if (o instanceof Roles) {
                    all.getLast().data.add((TaggingPresetItem)o);
                    if (all.getLast().roles != null) {
                        throw new SAXException(I18n.tr("Roles cannot appear more than once", new Object[0]));
                    }
                    all.getLast().roles = (Roles)o;
                    lastrole = (Roles)o;
                    lastrole.roles.clear();
                    continue;
                }
                if (o instanceof Roles.Role) {
                    if (lastrole == null) {
                        throw new SAXException(I18n.tr("Preset role element without parent", new Object[0]));
                    }
                    lastrole.roles.add((Roles.Role)o);
                    continue;
                }
                if (o instanceof Check) {
                    checks.add((Check)o);
                    continue;
                }
                if (o instanceof ComboMultiSelect.PresetListEntry) {
                    listEntries.add((ComboMultiSelect.PresetListEntry)o);
                    continue;
                }
                if (o instanceof CheckGroup) {
                    all.getLast().data.add((TaggingPresetItem)o);
                    ((CheckGroup)o).checks.clear();
                    ((CheckGroup)o).checks.addAll(checks);
                    checks.clear();
                    continue;
                }
                if (!checks.isEmpty()) {
                    all.getLast().data.addAll(checks);
                    checks.clear();
                }
                all.getLast().data.add((TaggingPresetItem)o);
                if (o instanceof ComboMultiSelect) {
                    ((ComboMultiSelect)o).addListEntries(listEntries);
                } else if (o instanceof Key && ((Key)o).value == null) {
                    ((Key)o).value = "";
                }
                listEntries.clear();
                lastrole = null;
                continue;
            }
            throw new SAXException(I18n.tr("Preset sub element without parent", new Object[0]));
        }
        if (!all.isEmpty() && !checks.isEmpty()) {
            all.getLast().data.addAll(checks);
            checks.clear();
        }
        return all;
    }

    public static Collection<TaggingPreset> readAll(String source, boolean validate) throws SAXException, IOException {
        return TaggingPresetReader.readAll(source, validate, new HashSetWithLast<TaggingPreset>());
    }

    static Collection<TaggingPreset> readAll(String source, boolean validate, HashSetWithLast<TaggingPreset> all) throws SAXException, IOException {
        Collection<TaggingPreset> tp;
        Logging.debug("Reading presets from {0}", source);
        long startTime = System.currentTimeMillis();
        try (CachedFile cf = new CachedFile(source).setHttpAccept(PRESET_MIME_TYPES);
             InputStream zip = cf.findZipEntryInputStream("xml", "preset");){
            if (zip != null) {
                zipIcons = cf.getFile();
                I18n.addTexts(zipIcons);
            }
            try (UTFInputStreamReader r = UTFInputStreamReader.create(zip == null ? cf.getInputStream() : zip);){
                tp = TaggingPresetReader.readAll(new BufferedReader(r), validate, all);
            }
        }
        if (Logging.isDebugEnabled()) {
            Logging.debug("Presets read in {0}", Utils.getDurationString(System.currentTimeMillis() - startTime));
        }
        return tp;
    }

    public static Collection<TaggingPreset> readAll(Collection<String> sources, boolean validate) {
        return TaggingPresetReader.readAll(sources, validate, true);
    }

    public static Collection<TaggingPreset> readAll(Collection<String> sources, boolean validate, boolean displayErrMsg) {
        HashSetWithLast<TaggingPreset> allPresets = new HashSetWithLast<TaggingPreset>();
        for (String source : sources) {
            try {
                TaggingPresetReader.readAll(source, validate, allPresets);
            }
            catch (IOException e) {
                Logging.log(Logging.LEVEL_ERROR, e);
                Logging.error(source);
                if (source.startsWith("http")) {
                    NetworkManager.addNetworkError(source, (Throwable)e);
                }
                if (!displayErrMsg) continue;
                JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("Could not read tagging preset source: {0}", source), I18n.tr("Error", new Object[0]), 0);
            }
            catch (IllegalArgumentException | SAXException e) {
                Logging.error(e);
                Logging.error(source);
                if (!displayErrMsg) continue;
                JOptionPane.showMessageDialog(MainApplication.getMainFrame(), "<html>" + I18n.tr("Error parsing {0}: ", source) + "<br><br><table width=600>" + Utils.escapeReservedCharactersHTML(e.getMessage()) + "</table></html>", I18n.tr("Error", new Object[0]), 0);
            }
        }
        return allPresets;
    }

    public static Collection<TaggingPreset> readFromPreferences(boolean validate, boolean displayErrMsg) {
        return TaggingPresetReader.readAll(TaggingPresetReader.getPresetSources(), validate, displayErrMsg);
    }

    public static File getZipIcons() {
        return zipIcons;
    }

    public static boolean isLoadIcons() {
        return loadIcons;
    }

    public static void setLoadIcons(boolean loadIcons) {
        TaggingPresetReader.loadIcons = loadIcons;
    }

    private TaggingPresetReader() {
    }

    static {
        loadIcons = true;
    }

    static class HashSetWithLast<E>
    extends LinkedHashSet<E> {
        private static final long serialVersionUID = 1L;
        protected transient E last;

        HashSetWithLast() {
        }

        @Override
        public boolean add(E e) {
            this.last = e;
            return super.add(e);
        }

        @Override
        public E getLast() {
            return this.last;
        }
    }

    public static class Reference {
        public String ref;

        public String toString() {
            return "Reference [ref=" + this.ref + ']';
        }
    }

    public static class Chunk {
        public String id;

        public String toString() {
            return "Chunk [id=" + this.id + ']';
        }
    }
}

