/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (dvec3(-1.3333333333333333lf, -0.85lf, -0.94lf) + dvec3(-1.3333333333333333lf, -0.85lf, -0.94lf)) => dvec3(-2.6666666666666665lf, -1.7lf, -1.88lf)
 * (dvec3(-1.3333333333333333lf, -0.85lf, -0.94lf) + dvec3(1.67lf, 0.66lf, 1.87lf)) => dvec3(0.33666666666666667lf, -0.18999999999999995lf, 0.9300000000000002lf)
 * (dvec3(1.67lf, 0.66lf, 1.87lf) + dvec3(-1.3333333333333333lf, -0.85lf, -0.94lf)) => dvec3(0.33666666666666667lf, -0.18999999999999995lf, 0.9300000000000002lf)
 * (dvec3(1.67lf, 0.66lf, 1.87lf) + dvec3(1.67lf, 0.66lf, 1.87lf)) => dvec3(3.34lf, 1.32lf, 3.74lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance((dvec3(-1.3333333333333333lf, -0.85lf, -0.94lf) + dvec3(-1.3333333333333333lf, -0.85lf, -0.94lf)), dvec3(-2.6666666666666665lf, -1.7lf, -1.88lf)) <= 3.679063890599226e-05lf ? 1 : -1] array0;
  double[distance((dvec3(-1.3333333333333333lf, -0.85lf, -0.94lf) + dvec3(1.67lf, 0.66lf, 1.87lf)), dvec3(0.33666666666666667lf, -0.18999999999999995lf, 0.9300000000000002lf)) <= 1.0071466846713267e-05lf ? 1 : -1] array1;
  double[distance((dvec3(1.67lf, 0.66lf, 1.87lf) + dvec3(-1.3333333333333333lf, -0.85lf, -0.94lf)), dvec3(0.33666666666666667lf, -0.18999999999999995lf, 0.9300000000000002lf)) <= 1.0071466846713267e-05lf ? 1 : -1] array2;
  double[distance((dvec3(1.67lf, 0.66lf, 1.87lf) + dvec3(1.67lf, 0.66lf, 1.87lf)), dvec3(3.34lf, 1.32lf, 3.74lf)) <= 5.185132592325871e-05lf ? 1 : -1] array3;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
