/*
 * Decompiled with CFR 0.152.
 */
package org.xeustechnologies.jcl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xeustechnologies.jcl.AbstractClassLoader;
import org.xeustechnologies.jcl.ClasspathResources;
import org.xeustechnologies.jcl.Configuration;
import org.xeustechnologies.jcl.ProxyClassLoader;
import org.xeustechnologies.jcl.exception.JclException;
import org.xeustechnologies.jcl.exception.ResourceNotFoundException;

public class JarClassLoader
extends AbstractClassLoader {
    protected final Map<String, Class> classes;
    protected final ClasspathResources classpathResources;
    private char classNameReplacementChar;
    private final ProxyClassLoader localLoader = new LocalLoader();
    private final transient Logger logger = LoggerFactory.getLogger(JarClassLoader.class);

    public JarClassLoader() {
        this.classpathResources = new ClasspathResources();
        this.classes = Collections.synchronizedMap(new HashMap());
        this.initialize();
    }

    public JarClassLoader(ClassLoader parent) {
        super(parent);
        this.classpathResources = new ClasspathResources();
        this.classes = Collections.synchronizedMap(new HashMap());
        this.initialize();
    }

    public void initialize() {
        this.addLoader(this.localLoader);
    }

    public JarClassLoader(Object[] sources) {
        this();
        this.addAll(sources);
    }

    public JarClassLoader(List sources) {
        this();
        this.addAll(sources);
    }

    public void addAll(Object[] sources) {
        for (Object source : sources) {
            this.add(source);
        }
    }

    public void addAll(List sources) {
        for (Object source : sources) {
            this.add(source);
        }
    }

    public void add(Object source) {
        if (source instanceof InputStream) {
            this.add((InputStream)source);
        } else if (source instanceof URL) {
            this.add((URL)source);
        } else if (source instanceof String) {
            this.add((String)source);
        } else {
            throw new JclException("Unknown Resource type");
        }
    }

    public void add(String resourceName) {
        this.classpathResources.loadResource(resourceName);
    }

    public void add(InputStream jarStream) {
        this.classpathResources.loadJar(null, jarStream, false);
    }

    public void add(URL url) {
        this.classpathResources.loadResource(url);
    }

    protected byte[] loadClassBytes(String className) {
        className = this.formatClassName(className);
        return this.classpathResources.getResource(className);
    }

    public void unloadClass(String className) {
        this.logger.debug("Unloading class {}", (Object)className);
        if (this.classes.containsKey(className)) {
            this.logger.debug("Removing loaded class {}", (Object)className);
            this.classes.remove(className);
            try {
                this.classpathResources.unload(this.formatClassName(className));
            }
            catch (ResourceNotFoundException e) {
                throw new JclException("Something is very wrong!!!The locally loaded classes must be in synch with ClasspathResources", e);
            }
        }
        try {
            this.classpathResources.unload(this.formatClassName(className));
        }
        catch (ResourceNotFoundException e) {
            throw new JclException("Class could not be unloaded [Possible reason: Class belongs to the system]", e);
        }
    }

    protected String formatClassName(String className) {
        className = className.replace('/', '~');
        className = this.classNameReplacementChar == '\u0000' ? className.replace('.', '/') + ".class" : className.replace('.', this.classNameReplacementChar) + ".class";
        className = className.replace('~', '/');
        return className;
    }

    public char getClassNameReplacementChar() {
        return this.classNameReplacementChar;
    }

    public void setClassNameReplacementChar(char classNameReplacementChar) {
        this.classNameReplacementChar = classNameReplacementChar;
    }

    public Map<String, byte[]> getLoadedResources() {
        return this.classpathResources.getResources();
    }

    public ProxyClassLoader getLocalLoader() {
        return this.localLoader;
    }

    public Map<String, Class> getLoadedClasses() {
        return Collections.unmodifiableMap(this.classes);
    }

    class LocalLoader
    extends ProxyClassLoader {
        private final transient Logger logger = LoggerFactory.getLogger(LocalLoader.class);

        public LocalLoader() {
            this.order = 10;
            this.enabled = Configuration.isLocalLoaderEnabled();
        }

        @Override
        public Class loadClass(String className, boolean resolveIt) {
            Class result = null;
            result = JarClassLoader.this.classes.get(className);
            if (result != null) {
                this.logger.debug("Returning local loaded class [{}] from cache", (Object)className);
                return result;
            }
            byte[] classBytes = JarClassLoader.this.loadClassBytes(className);
            if (classBytes == null) {
                return null;
            }
            result = JarClassLoader.this.defineClass(className, classBytes, 0, classBytes.length);
            if (result == null) {
                return null;
            }
            if (result.getPackage() == null) {
                int lastDotIndex = className.lastIndexOf(46);
                String packageName = lastDotIndex >= 0 ? className.substring(0, lastDotIndex) : "";
                JarClassLoader.this.definePackage(packageName, null, null, null, null, null, null, null);
            }
            if (resolveIt) {
                JarClassLoader.this.resolveClass(result);
            }
            JarClassLoader.this.classes.put(className, result);
            this.logger.debug("Return new local loaded class {}", (Object)className);
            return result;
        }

        @Override
        public InputStream loadResource(String name) {
            byte[] arr = JarClassLoader.this.classpathResources.getResource(name);
            if (arr != null) {
                this.logger.debug("Returning newly loaded resource {}", (Object)name);
                return new ByteArrayInputStream(arr);
            }
            return null;
        }

        @Override
        public URL findResource(String name) {
            URL url = JarClassLoader.this.classpathResources.getResourceURL(name);
            if (url != null) {
                this.logger.debug("Returning newly loaded resource {}", (Object)name);
                return url;
            }
            return null;
        }
    }
}

