/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.record;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.minidns.dnsname.DnsName;
import org.minidns.record.Data;
import org.minidns.record.Record;

public class SOA
extends Data {
    public final DnsName mname;
    public final DnsName rname;
    public final long serial;
    public final int refresh;
    public final int retry;
    public final int expire;
    public final long minimum;

    public static SOA parse(DataInputStream dis, byte[] data) throws IOException {
        DnsName mname = DnsName.parse(dis, data);
        DnsName rname = DnsName.parse(dis, data);
        long serial = (long)dis.readInt() & 0xFFFFFFFFL;
        int refresh = dis.readInt();
        int retry = dis.readInt();
        int expire = dis.readInt();
        long minimum = (long)dis.readInt() & 0xFFFFFFFFL;
        return new SOA(mname, rname, serial, refresh, retry, expire, minimum);
    }

    public SOA(String mname, String rname, long serial, int refresh, int retry, int expire, long minimum) {
        this(DnsName.from(mname), DnsName.from(rname), serial, refresh, retry, expire, minimum);
    }

    public SOA(DnsName mname, DnsName rname, long serial, int refresh, int retry, int expire, long minimum) {
        this.mname = mname;
        this.rname = rname;
        this.serial = serial;
        this.refresh = refresh;
        this.retry = retry;
        this.expire = expire;
        this.minimum = minimum;
    }

    @Override
    public Record.TYPE getType() {
        return Record.TYPE.SOA;
    }

    @Override
    public void serialize(DataOutputStream dos) throws IOException {
        this.mname.writeToStream(dos);
        this.rname.writeToStream(dos);
        dos.writeInt((int)this.serial);
        dos.writeInt(this.refresh);
        dos.writeInt(this.retry);
        dos.writeInt(this.expire);
        dos.writeInt((int)this.minimum);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append(this.mname).append(". ").append(this.rname).append(". ").append(this.serial).append(' ').append(this.refresh).append(' ').append(this.retry).append(' ').append(this.expire).append(' ').append(this.minimum);
        return sb.toString();
    }
}

