/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse.model.internal;

import com.google.common.base.Objects;
import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.plugins.ide.eclipse.model.ResourceFilterMatcher;
import org.gradle.util.internal.ClosureBackedAction;

public final class DefaultResourceFilterMatcher
implements ResourceFilterMatcher {
    private String id;
    private String arguments;
    private Set<ResourceFilterMatcher> children = new LinkedHashSet<ResourceFilterMatcher>();

    public DefaultResourceFilterMatcher() {
    }

    public DefaultResourceFilterMatcher(String id, String arguments, Set<ResourceFilterMatcher> children) {
        this();
        this.id = id;
        this.arguments = arguments;
        this.children = children;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    @Nullable
    public String getArguments() {
        return this.arguments;
    }

    @Override
    public void setArguments(String arguments) {
        this.arguments = arguments;
    }

    @Override
    public Set<ResourceFilterMatcher> getChildren() {
        return this.children;
    }

    public void setChildren(Set<ResourceFilterMatcher> children) {
        if (children == null) {
            throw new InvalidUserDataException("children must not be null");
        }
        this.children = children;
    }

    public ResourceFilterMatcher matcher(@DelegatesTo(value=ResourceFilterMatcher.class, strategy=1) Closure configureClosure) {
        return this.matcher((Action<? super ResourceFilterMatcher>)new ClosureBackedAction(configureClosure));
    }

    @Override
    public ResourceFilterMatcher matcher(Action<? super ResourceFilterMatcher> configureAction) {
        DefaultResourceFilterMatcher m = new DefaultResourceFilterMatcher();
        configureAction.execute((Object)m);
        this.children.add(m);
        return m;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        DefaultResourceFilterMatcher resourceFilterMatcher = (DefaultResourceFilterMatcher)o;
        return Objects.equal((Object)this.id, (Object)resourceFilterMatcher.id) && Objects.equal((Object)this.arguments, (Object)resourceFilterMatcher.arguments) && Objects.equal(this.children, resourceFilterMatcher.children);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.arguments != null ? this.arguments.hashCode() : 0);
        result = 31 * result + (this.children != null ? this.children.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ResourceFilterMatcher{id='" + this.id + '\'' + ", arguments='" + this.arguments + '\'' + ", children='" + this.children + '\'' + '}';
    }
}

