/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Stance;

public class NationSummary
extends FreeColObject {
    public static final String TAG = "nationSummary";
    private Stance stance;
    private int numberOfSettlements;
    private int numberOfUnits;
    private int militaryStrength;
    private int navalStrength;
    private int gold;
    private int soL;
    private int foundingFathers;
    private int tax;
    private static final String FOUNDING_FATHERS_TAG = "foundingFathers";
    private static final String GOLD_TAG = "gold";
    private static final String MILITARY_STRENGTH_TAG = "militaryStrength";
    private static final String NAVAL_STRENGTH_TAG = "navalStrength";
    private static final String NUMBER_OF_SETTLEMENTS_TAG = "numberOfSettlements";
    private static final String NUMBER_OF_UNITS_TAG = "numberOfUnits";
    private static final String SOL_TAG = "SoL";
    private static final String STANCE_TAG = "stance";
    private static final String TAX_TAG = "tax";

    public NationSummary() {
        this.setId("");
    }

    public NationSummary(Player player, Player requester) {
        this();
        this.stance = player.getStance(requester);
        if (this.stance == Stance.UNCONTACTED) {
            this.stance = Stance.PEACE;
        }
        this.numberOfSettlements = player.getSettlementCount();
        if (player.isEuropean()) {
            this.numberOfUnits = player.getUnitCount();
            this.militaryStrength = player.calculateStrength(false);
            this.navalStrength = player.calculateStrength(true);
            this.gold = player.getGold();
            if (player == requester || requester.hasAbility("model.ability.betterForeignAffairsReport")) {
                this.soL = player.getSoL();
                this.foundingFathers = player.getFatherCount();
                this.tax = player.getTax();
            } else {
                this.tax = -1;
                this.foundingFathers = -1;
                this.soL = -1;
            }
        } else {
            this.tax = -1;
            this.foundingFathers = -1;
            this.soL = -1;
            this.gold = -1;
            this.navalStrength = -1;
            this.militaryStrength = -1;
            this.numberOfUnits = -1;
        }
    }

    public Stance getStance() {
        return this.stance;
    }

    public int getNumberOfSettlements() {
        return this.numberOfSettlements;
    }

    public int getNumberOfUnits() {
        return this.numberOfUnits;
    }

    public int getMilitaryStrength() {
        return this.militaryStrength;
    }

    public int getNavalStrength() {
        return this.navalStrength;
    }

    public int getGold() {
        return this.gold;
    }

    public int getFoundingFathers() {
        return this.foundingFathers;
    }

    public int getSoL() {
        return this.soL;
    }

    public int getTax() {
        return this.tax;
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        NationSummary o = this.copyInCast(other, NationSummary.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        this.stance = o.getStance();
        this.numberOfSettlements = o.getNumberOfSettlements();
        this.numberOfUnits = o.getNumberOfUnits();
        this.militaryStrength = o.getMilitaryStrength();
        this.navalStrength = o.getNavalStrength();
        this.gold = o.getGold();
        this.soL = o.getSoL();
        this.foundingFathers = o.getFoundingFathers();
        this.tax = o.getTax();
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(NUMBER_OF_SETTLEMENTS_TAG, this.numberOfSettlements);
        xw.writeAttribute(NUMBER_OF_UNITS_TAG, this.numberOfUnits);
        xw.writeAttribute(MILITARY_STRENGTH_TAG, this.militaryStrength);
        xw.writeAttribute(NAVAL_STRENGTH_TAG, this.navalStrength);
        xw.writeAttribute(STANCE_TAG, this.stance);
        xw.writeAttribute(GOLD_TAG, this.gold);
        if (this.soL >= 0) {
            xw.writeAttribute(SOL_TAG, this.soL);
        }
        if (this.foundingFathers >= 0) {
            xw.writeAttribute(FOUNDING_FATHERS_TAG, this.foundingFathers);
        }
        if (this.tax >= 0) {
            xw.writeAttribute(TAX_TAG, this.tax);
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.stance = xr.getAttribute(STANCE_TAG, Stance.class, Stance.PEACE);
        this.numberOfSettlements = xr.getAttribute(NUMBER_OF_SETTLEMENTS_TAG, -1);
        this.numberOfUnits = xr.getAttribute(NUMBER_OF_UNITS_TAG, -1);
        this.militaryStrength = xr.getAttribute(MILITARY_STRENGTH_TAG, -1);
        this.navalStrength = xr.getAttribute(NAVAL_STRENGTH_TAG, -1);
        this.gold = xr.getAttribute(GOLD_TAG, -1);
        this.soL = xr.getAttribute(SOL_TAG, -1);
        this.foundingFathers = xr.getAttribute(FOUNDING_FATHERS_TAG, -1);
        this.tax = xr.getAttribute(TAX_TAG, -1);
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }
}

