# Globular clusters
# Extracted by Elvis O. Mendes from "Fundamental parameters of Galactic
# globular clusters" by Holger Baumgardt, Antonio Sollima, Michael Hilker,
# Andrea Bellini, Eugene Vasiliev, Vincent Henault-Brunet & Nolan Dickson,
# March 2023, Monthly Notices of the Royal Astronomical Society, availiable
# at http://people.smp.uq.edu.au/HolgerBaumgardt/globular/index.html.
#
#
# For extragalactic clusters, the tidal radius was calculated with
# Equation 1 from "The Influence of Orbital Eccentricity on Tidal
# Radii of Star Clusters" by Webb, Jeremy J., Harris, William E.,
# Sills, Alison, Hurley, Jarrod R., The Astrophysical Journal,
# Volume 764, Issue 2, article id. 124, 12 pp. (2013).
#
#
# Since no galaxy mass values were given, different references were
# used for the masses of Fornax Dwarf and the Magellanic Clouds:
#
# - Fornax Dwarf: 1.6e8 MSun, "The Morphology and Structure of
# Stellar Populations in the Fornax Dwarf Spheroidal Galaxy
# from Dark Energy Survey Data", M. Y. Wang et al. 2019 ApJ 881 118.
#
# - SMC: 6.5e9 MSun, "The total mass and dark halo properties of
# the Small Magellanic Cloud", Kenji Bekki, Snežana Stanimirović
# Monthly Notices of the Royal Astronomical Society, Volume 395,
# Issue 1, pp. 342-350.
#
# - LMC: 1.38e11 MSun, "The total mass of the Large Magellanic Cloud
# from its perturbation on the Orphan stream", D. Erkal et al. 2019,
# Monthly Notices of the Royal Astronomical Society, Volume 487,
# Issue 2, p.2685-2700.

Globular "Lindsay 1:ESO 28-8:OGLE-CL SMC 313"
{
	RA 0.065122
	Dec -73.47186
	Distance 185582.979
	Radius 233.486
	CoreRadius 0.83
	KingConcentration 0.717
	AbsMag -7.326
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Lindsay 1"
}

Globular "47 Tuc:NGC 104:Melotte 1:HD 2051:RBS 55:GCl 1:C 0021-723:XI Tuc"
{
	RA 0.401586
	Dec -72.08131
	Distance 14742.268
	Radius 406.489
	CoreRadius 0.464
	KingConcentration 2.31
	AbsMag -9.196
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=47 Tuc"
}

Globular "Kron 3:Lindsay 8:ESO 28-19:OGLE-CL SMC 319"
{
	RA 0.412953
	Dec -72.79361
	Distance 197650.765
	Radius 145.326
	CoreRadius 0.409
	KingConcentration 0.791
	AbsMag -7.502
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Kron 3"
}

Globular "NGC 121:Kron 2:Lindsay 10:ESO 50-12:OGLE-CL SMC 311"
{
	RA 0.446928
	Dec -71.53594
	Distance 211675.489
	Radius 205.794
	CoreRadius 0.14
	KingConcentration 1.377
	AbsMag -8.451
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 121"
}

Globular "Lindsay 38:ESO 51-3:OGLE-CL SMC 308"
{
	RA 0.813833
	Dec -69.87017
	Distance 217546.304
	Radius 92.908
	CoreRadius 0.363
	KingConcentration 0.606
	AbsMag -5.041
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Lindsay 38"
}

Globular "NGC 288:Melotte 3:GCl 2:C 0050-268"
{
	RA 0.879233
	Dec -26.58261
	Distance 29321.458
	Radius 310.37
	CoreRadius 1.338
	KingConcentration 1.434
	AbsMag -6.669
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 288"
}

Globular "NGC 330:Kron 35:Lindsay 54:ESO 29-24:OGLE-CL SMC 107:[RZ2005] 98"
{
	RA 0.938397
	Dec -72.45897
	Distance 196346.139
	Radius 19.434
	CoreRadius 0.151
	KingConcentration 0.352
	AbsMag -9.348
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 330"
}

Globular "NGC 339:Kron 36:Lindsay 59:ESO 29-25:[RZ2005] 104"
{
	RA 0.962933
	Dec -74.47033
	Distance 187866.074
	Radius 96.146
	CoreRadius 0.517
	KingConcentration 0.531
	AbsMag -6.682
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 339"
}

Globular "NGC 362:Melotte 4:LI-SMC 158:GCl 3:C 0100-711"
{
	RA 1.053961
	Dec -70.84878
	Distance 28799.608
	Radius 283.56
	CoreRadius 0.167
	KingConcentration 2.306
	AbsMag -8.25
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 362"
}

Globular "NGC 416:Kron 59:Lindsay 83:ESO 29-32:OGLE-CL SMC 158:[RZ2005] 171"
{
	RA 1.133103
	Dec -72.35547
	Distance 196998.452
	Radius 100.478
	CoreRadius 0.16
	KingConcentration 1.04
	AbsMag -7.795
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 416"
}

Globular "NGC 419:Kron 58:Lindsay 85:ESO 29-33:LI-SMC 182:[RZ2005] 174"
{
	RA 1.138214
	Dec -72.88439
	Distance 191779.95
	Radius 79.996
	CoreRadius 0.216
	KingConcentration 0.823
	AbsMag -9.007
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 419"
}

Globular "Lindsay 113:ESO 30-4:OGLE-CL MBR 47"
{
	RA 1.824914
	Dec -73.72783
	Distance 187539.917
	Radius 203.203
	CoreRadius 0.6
	KingConcentration 0.793
	AbsMag -5.188
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Lindsay 113"
}

Globular "Whiting 1:WHI B0200-03"
{
	RA 2.049167
	Dec -3.25278
	Distance 99771.236
	Radius 143.248
	CoreRadius 0.211
	KingConcentration 1.369
	AbsMag -2.808
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Whiting 1"
}

Globular "Fornax 1:C 0235-344:ESO 355-29"
{
	RA 2.61725
	Dec -34.18333
	Distance 456618.929
	Radius 238.115
	CoreRadius 0.231
	KingConcentration 0.89
	AbsMag -5.541
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Fornax 1"
}

Globular "Fornax 3:NGC 1049:C 0237-345:ESO 356-3:MCG-06-06-017"
{
	RA 2.663378
	Dec -34.25794
	Distance 456618.929
	Radius 114.926
	CoreRadius 0.035
	KingConcentration 1.395
	AbsMag -7.551
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Fornax 3"
}

Globular "NGC 1261:GCl 5:C 0310-554"
{
	RA 3.204503
	Dec -55.21622
	Distance 53489.646
	Radius 450.487
	CoreRadius 0.22
	KingConcentration 2.119
	AbsMag -7.764
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1261"
}

Globular "Pal 1:ZW VII 7:LEDA 13165:C 0325+794"
{
	RA 3.555567
	Dec 79.58105
	Distance 36464.283
	Radius 74.494
	CoreRadius 0.141
	KingConcentration 1.696
	AbsMag -1.292
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Pal 1"
}

Globular "AM 1:E1:LEDA 14098:ESO 201-10:C 0354-498:C 0353-497"
{
	RA 3.917306
	Dec -49.61528
	Distance 387832.549
	Radius 856.519
	CoreRadius 0.2
	KingConcentration 1.579
	AbsMag -5.306
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=AM 1"
}

Globular "Eridanus:ERI star cluster:CL ERID 1:C 0422-213"
{
	RA 4.412374
	Dec -21.18678
	Distance 276189.221
	Radius 513.044
	CoreRadius 0.375
	KingConcentration 1.232
	AbsMag -4.619
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Eridanus"
}

Globular "Reticulum:Sersic Cluster:C 0435-590:KMHK 10"
{
	RA 4.603053
	Dec -58.86264
	Distance 155250.436
	Radius 168.611
	CoreRadius 0.942
	KingConcentration 0.598
	AbsMag -6.138
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Reticulum"
}

Globular "NGC 1651:KMHK 20:[SL63] 7:ESO 55-30:LW 12:[WZ2011] 142"
{
	RA 4.625619
	Dec -70.58633
	Distance 160142.781
	Radius 44.669
	CoreRadius 0.306
	KingConcentration 0.496
	AbsMag -6.325
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1651"
}

Globular "Pal 2:C 0443+313"
{
	RA 4.768308
	Dec 31.3815
	Distance 85355.124
	Radius 395.726
	CoreRadius 0.221
	KingConcentration 1.859
	AbsMag -4.449
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Pal 2"
}

Globular "NGC 1755:KMHK 272:[WZ2011] 672:ESO 56-28:[SL63] 99"
{
	RA 4.920925
	Dec -68.2056
	Distance 152641.185
	Radius 23.307
	CoreRadius 0.152
	KingConcentration 0.538
	AbsMag -8.501
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1755"
}

Globular "NGC 1783:HD 270921:CD-66 283:KMHK 383:ESO 85-29"
{
	RA 4.985825
	Dec -65.98716
	Distance 160468.938
	Radius 77.094
	CoreRadius 0.328
	KingConcentration 0.701
	AbsMag -8.07
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1783"
}

Globular "NGC 1806:KMHK 462:[WZ2011] 702:ESO 56-47:[SL63] 184"
{
	RA 5.036389
	Dec -67.98805
	Distance 160468.938
	Radius 27.21
	CoreRadius 0.428
	KingConcentration 0.135
	AbsMag -7.46
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1806"
}

Globular "NGC 1846:KMHK 557:[SL63] 243:ESO 56-67:OGLE-CL LMC 128:[WZ2011] 780"
{
	RA 5.126389
	Dec -67.46083
	Distance 160468.938
	Radius 30.412
	CoreRadius 0.521
	KingConcentration 0.097
	AbsMag -7.78
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1846"
}

Globular "NGC 1850:HD 34039:BRHT 5a"
{
	RA 5.1459
	Dec -68.76242
	Distance 152315.028
	Radius 11.668
	CoreRadius 0.266
	KingConcentration -0.004
	AbsMag -8.777
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1850"
}

Globular "NGC 1856:OGLE-CL LMC 157:[WZ2011] 483:ESO 56-73:[SL63] 271"
{
	RA 5.158356
	Dec -69.12886
	Distance 159164.312
	Radius 8.903
	CoreRadius 0.154
	KingConcentration 0.096
	AbsMag -8.382
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1856"
}

Globular "NGC 1866:HD 34574:KMHK 664:LW 163:CD-65 314"
{
	RA 5.227403
	Dec -65.46466
	Distance 163404.345
	Radius 57.973
	CoreRadius 0.257
	KingConcentration 0.677
	AbsMag -8.969
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1866"
}

Globular "NGC 1851:GCl 9:C 0512-400"
{
	RA 5.235211
	Dec -40.04655
	Distance 38975.687
	Radius 403.423
	CoreRadius 0.04
	KingConcentration 2.946
	AbsMag -8.317
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1851"
}

Globular "M 79:NGC 1904:GCl 10:C 0522-245"
{
	RA 5.403056
	Dec -24.52442
	Distance 42661.254
	Radius 215.948
	CoreRadius 0.087
	KingConcentration 2.302
	AbsMag -7.643
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=M 79"
}

Globular "NGC 1978:KMHK 944:[WZ2011] 946:ESO 85-90:[SL63] 501"
{
	RA 5.479086
	Dec -66.23636
	Distance 156228.905
	Radius 71.057
	CoreRadius 0.291
	KingConcentration 0.731
	AbsMag -8.202
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1978"
}

Globular "Hodge 301:M-OB 1"
{
	RA 5.63813
	Dec -69.06668
	Distance 163404.345
	Radius 14.953
	CoreRadius 0.165
	KingConcentration 0.281
	AbsMag -7.759
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Hodge 301"
}

Globular "R 136:RMC 136:HD 38268:TYC 9163-1014-1:Brey 82"
{
	RA 5.645111
	Dec -69.10094
	Distance 163404.345
	Radius 38.756
	CoreRadius 0.056
	KingConcentration 1.166
	AbsMag -10.409
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=R 136"
}

Globular "SL 639:M-OB 3"
{
	RA 5.661009
	Dec -69.19778
	Distance 163404.345
	Radius 12.779
	CoreRadius 0.079
	KingConcentration 0.532
	AbsMag -6.969
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=SL 639"
}

Globular "Hodge 6:LW 274:ESO 57-30"
{
	RA 5.704805
	Dec -71.59097
	Distance 163404.345
	Radius 47.762
	CoreRadius 0.289
	KingConcentration 0.541
	AbsMag -6.409
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Hodge 6"
}

Globular "NGC 2121:KMHK 1398:[SL63] 725:ESO 57-40:LW 303:[WZ2011] 67"
{
	RA 5.803672
	Dec -71.4797
	Distance 149379.621
	Radius 69.359
	CoreRadius 0.489
	KingConcentration 0.513
	AbsMag -5.934
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2121"
}

Globular "NGC 2173:KMHK 1570:[SL63] 807:ESO 33-34:LW 348"
{
	RA 5.966221
	Dec -72.97867
	Distance 158838.156
	Radius 51.752
	CoreRadius 0.268
	KingConcentration 0.621
	AbsMag -6.558
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2173"
}

Globular "NGC 2155:KMHK 1563:[SL63] 803:ESO 86-45:LW 347:[WZ2011] 999"
{
	RA 5.975583
	Dec -65.47739
	Distance 149053.465
	Radius 55.655
	CoreRadius 0.272
	KingConcentration 0.673
	AbsMag -5.71
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2155"
}

Globular "NGC 2203:KMHK 1639:[SL63] 836:ESO 34-4:LW 380"
{
	RA 6.078505
	Dec -75.43781
	Distance 156881.218
	Radius 96.181
	CoreRadius 0.345
	KingConcentration 0.786
	AbsMag -7.121
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2203"
}

Globular "NGC 2298:C 0647-359"
{
	RA 6.816503
	Dec -36.00531
	Distance 32061.172
	Radius 238.453
	CoreRadius 0.15
	KingConcentration 2.231
	AbsMag -5.903
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2298"
}

Globular "NGC 2419:GCl 12:C 0734+390"
{
	RA 7.635686
	Dec 38.88194
	Distance 288550.547
	Radius 2397.152
	CoreRadius 0.323
	KingConcentration 1.946
	AbsMag -9.174
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2419"
}

Globular "Pyxis:C J0908-373:C J0907-372"
{
	RA 9.13246
	Dec -37.2266
	Distance 119144.925
	Radius 433.07
	CoreRadius 1.267
	KingConcentration 0.994
	AbsMag -4.613
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Pyxis"
}

Globular "NGC 2808:GCl 13:C 0911-646"
{
	RA 9.200861
	Dec -64.86349
	Distance 32811.332
	Radius 523.579
	CoreRadius 0.253
	KingConcentration 2.336
	AbsMag -8.883
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2808"
}

Globular "E 3:E3:ESO 37-1:C 0921-770"
{
	RA 9.349186
	Dec -77.28189
	Distance 25701.123
	Radius 65.101
	CoreRadius 0.55
	KingConcentration 1.2
	AbsMag -2.633
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=E 3"
}

Globular "Pal 3:SEX C:SPB 132:UGC 5439:C 1003+00315"
{
	RA 10.092108
	Dec 0.07167
	Distance 309326.709
	Radius 749.116
	CoreRadius 0.552
	KingConcentration 1.178
	AbsMag -5.325
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Pal 3"
}

Globular "NGC 3201:GCl 15:C 1015-461"
{
	RA 10.293562
	Dec -46.41248
	Distance 15459.812
	Radius 268.557
	CoreRadius 1.204
	KingConcentration 1.695
	AbsMag -6.609
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3201"
}

Globular "Pal 4:UGCA 237:GCl 17:C 1126+292"
{
	RA 11.487889
	Dec 28.97337
	Distance 330689.951
	Radius 676.905
	CoreRadius 0.372
	KingConcentration 1.277
	AbsMag -5.8
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Pal 4"
}

Globular "Crater:Laevens 1:PSO J174.0675-10.8774"
{
	RA 11.604583
	Dec -10.87697
	Distance 480200.035
	Radius 801.627
	CoreRadius 0.319
	KingConcentration 1.255
	AbsMag -5.1
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Crater"
}

Globular "NGC 4147:GCl 18:C 1207+188"
{
	RA 12.168417
	Dec 18.54264
	Distance 60469.392
	Radius 305.706
	CoreRadius 0.08
	KingConcentration 2.338
	AbsMag -6.051
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 4147"
}

Globular "NGC 4372:GCl 19:C 1223-724"
{
	RA 12.429273
	Dec -72.65908
	Distance 18623.529
	Radius 241.388
	CoreRadius 2.137
	KingConcentration 1.319
	AbsMag -6.413
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 4372"
}

Globular "Ruprecht 106:C 1236-508:C 1235-509"
{
	RA 12.6445
	Dec -51.15028
	Distance 67546.986
	Radius 239.66
	CoreRadius 0.835
	KingConcentration 1.165
	AbsMag -5.531
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Rup 106"
}

Globular "M 68:NGC 4590:HD 110032:GCl 20:C 1236-264"
{
	RA 12.657772
	Dec -26.74406
	Distance 33920.263
	Radius 255.315
	CoreRadius 0.615
	KingConcentration 1.624
	AbsMag -7.095
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=M 68"
}

Globular "BH 140:VDBH 140:C 1250-669:IRAS 12498-6654"
{
	RA 12.898195
	Dec -67.17728
	Distance 15688.122
	Radius 168.851
	CoreRadius 3.438
	KingConcentration 1.032
	AbsMag -4.271
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=BH 140"
}

Globular "NGC 4833:GCl 21:C 1256-7066"
{
	RA 12.992756
	Dec -70.8765
	Distance 21134.933
	Radius 251.336
	CoreRadius 0.674
	KingConcentration 1.783
	AbsMag -6.868
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 4833"
}

Globular "M 53:NGC 5024:GCl 22:C 1310+184"
{
	RA 13.215347
	Dec 18.16817
	Distance 60338.93
	Radius 596.997
	CoreRadius 0.347
	KingConcentration 1.991
	AbsMag -8.636
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=M 53"
}

Globular "NGC 5053:GCl 23:C 1313+179"
{
	RA 13.274192
	Dec 17.70025
	Distance 57207.829
	Radius 298.89
	CoreRadius 1.803
	KingConcentration 0.998
	AbsMag -6.3
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 5053"
}

# Coordinates using the center from the below citation:
# "New Limits on an Intermediate-Mass Black Hole in Omega
# Centauri. I. Hubble Space Telescope Photometry and Proper
# Motions" - Table 7
# Jay Anderson and Roeland P. van der Marel 2010 ApJ 710 1032
# DOI 10.1088/0004-637X/710/2/1032
Globular "OME Cen:NGC 5139:HD 116790:GCl 24:C 1323-472"
{
	RA 13.446456
	Dec -47.4795694
	Distance 17710.291
	Radius 680.362
	CoreRadius 2.722
	KingConcentration 1.686
	AbsMag -10.174
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=ω Cen"
}

Globular "M 3:NGC 5272:GCl 25:C 1339+286"
{
	RA 13.703228
	Dec 28.37728
	Distance 33202.719
	Radius 421.557
	CoreRadius 0.331
	KingConcentration 2.12
	AbsMag -8.649
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=M 3"
}

Globular "NGC 5286:GCl 26:C 1343-511"
{
	RA 13.774114
	Dec -51.37425
	Distance 36203.358
	Radius 311.414
	CoreRadius 0.152
	KingConcentration 2.29
	AbsMag -7.877
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 5286"
}

Globular "AM 4:C 1353-269"
{
	RA 13.939271
	Dec -27.16517
	Distance 94617.965
	Radius 94.096
	CoreRadius 0.251
	KingConcentration 1.134
	AbsMag -0.823
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=AM 4"
}

Globular "NGC 5466:GCl 27:C 1403+287"
{
	RA 14.090914
	Dec 28.53444
	Distance 52576.408
	Radius 250.162
	CoreRadius 1.312
	KingConcentration 1.096
	AbsMag -6.717
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 5466"
}

Globular "NGC 5634:GCl 28:C 1427-057"
{
	RA 14.493689
	Dec -5.97643
	Distance 84670.196
	Radius 627.949
	CoreRadius 0.081
	KingConcentration 2.499
	AbsMag -7.562
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 5634"
}

Globular "NGC 5694:GCl 29:C 1436-263"
{
	RA 14.660083
	Dec -26.53878
	Distance 113632.882
	Radius 745.659
	CoreRadius 0.002
	KingConcentration 4.058
	AbsMag -7.85
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 5694"
}

Globular "IC 4499:GCl 30:C 1452-820"
{
	RA 15.005146
	Dec -82.21379
	Distance 61610.94
	Radius 359.816
	CoreRadius 0.914
	KingConcentration 1.342
	AbsMag -6.541
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=IC 4499"
}

Globular "NGC 5824:GCl 31:C 1500-328"
{
	RA 15.066277
	Dec -33.06814
	Distance 103424.187
	Radius 831.242
	CoreRadius 0.066
	KingConcentration 2.621
	AbsMag -8.646
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 5824"
}

Globular "Pal 5:Serpens Dwarf:UGC 9792:GCl 32:C 1513+000"
{
	RA 15.267945
	Dec -0.121
	Distance 71558.709
	Radius 162.198
	CoreRadius 2.405
	KingConcentration 0.511
	AbsMag -4.846
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Pal 5"
}

Globular "NGC 5897:GCl 33:C 1514-208"
{
	RA 15.290111
	Dec -21.01012
	Distance 40932.625
	Radius 234.963
	CoreRadius 1.37
	KingConcentration 1.159
	AbsMag -7.013
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 5897"
}

Globular "M 5:NGC 5904:GCl 34:C 1516+022"
{
	RA 15.309227
	Dec 2.08103
	Distance 24396.497
	Radius 265.133
	CoreRadius 0.519
	KingConcentration 1.857
	AbsMag -8.42
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=M 5"
}

Globular "NGC 5927:VDBH 173:GCl 35:C 1524-505"
{
	RA 15.466858
	Dec -50.67303
	Distance 26973.132
	Radius 210.371
	CoreRadius 0.553
	KingConcentration 1.686
	AbsMag -6.848
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 5927"
}

Globular "NGC 5946:VDBH 175:GCl 36:C 1531-504"
{
	RA 15.59127
	Dec -50.65971
	Distance 31441.475
	Radius 153.554
	CoreRadius 0.132
	KingConcentration 2.105
	AbsMag -5.43
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 5946"
}

Globular "NGC 5986:GCl 37:ESO 329-18:C 1542-376"
{
	RA 15.7675
	Dec -37.78642
	Distance 34376.882
	Radius 223.841
	CoreRadius 0.245
	KingConcentration 1.961
	AbsMag -7.414
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 5986"
}

Globular "FSR 1716"
{
	RA 16.175
	Dec -53.74889
	Distance 24233.419
	Radius 111.285
	CoreRadius 0.824
	KingConcentration 1.283
	AbsMag -1.295
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=FSR 1716"
}

Globular "Pal 14:Arp 1:GCl 38:C 1608+150"
{
	RA 16.1835
	Dec 14.95778
	Distance 239985.863
	Radius 149.412
	CoreRadius 0.741
	KingConcentration 0.461
	AbsMag -5.204
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Pal 14"
}

Globular "Lynga 7:VDBH 184:ESO 178-11:C 1607-551"
{
	RA 16.184347
	Dec -55.31778
	Distance 25766.354
	Radius 125.309
	CoreRadius 0.574
	KingConcentration 1.464
	AbsMag -4.618
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Lynga 7"
}

Globular "M 80:NGC 6093:GCl 39:C 1614-228"
{
	RA 16.284003
	Dec -22.97608
	Distance 33724.569
	Radius 205.022
	CoreRadius 0.07
	KingConcentration 2.476
	AbsMag -7.643
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=M 80"
}

Globular "RLGC 1:Ryu 059"
{
	RA 16.285669
	Dec -44.59406
	Distance 94063.499
	Radius 555.934
	CoreRadius 0.312
	KingConcentration 1.813
	AbsMag -4.2
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Ryu 059"
}

Globular "M 4:NGC 6121:GCl 41:C 1620-264"
{
	RA 16.393116
	Dec -26.52575
	Distance 6033.893
	Radius 175.929
	CoreRadius 0.836
	KingConcentration 2.079
	AbsMag -5.686156
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=M 4"
}

Globular "NGC 6101:GCl 40:C 1620-720:GCl 40:C 1620-720"
{
	RA 16.430033
	Dec -72.20219
	Distance 47129.597
	Radius 290.116
	CoreRadius 1.313
	KingConcentration 1.207
	AbsMag -7.119
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6101"
}

Globular "NGC 6144:GCl 42:C 1624-259"
{
	RA 16.453851
	Dec -26.0235
	Distance 26581.745
	Radius 93.998
	CoreRadius 0.422
	KingConcentration 1.46
	AbsMag -5.316
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6144"
}

Globular "NGC 6139:GCl 43:C 1624-387"
{
	RA 16.461231
	Dec -38.84878
	Distance 32746.1
	Radius 191.486
	CoreRadius 0.099
	KingConcentration 2.306
	AbsMag -6.039
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6139"
}

Globular "Terzan 3:GCl 43.1:ESO 390-6:C 1625-352"
{
	RA 16.477499
	Dec -35.33983
	Distance 24918.347
	Radius 68.819
	CoreRadius 1.066
	KingConcentration 0.95
	AbsMag -3.825
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Ter 3"
}

Globular "M 107:NGC 6171:GCl 44:C 1629-129"
{
	RA 16.542183
	Dec -13.05378
	Distance 18362.604
	Radius 114.611
	CoreRadius 0.318
	KingConcentration 1.83
	AbsMag -5.473
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=M 107"
}

Globular "ESO 452-SC11:ESO 452-11:C 1636-283"
{
	RA 16.656945
	Dec -28.39917
	Distance 24102.956
	Radius 34.409
	CoreRadius 0.293
	KingConcentration 1.224
	AbsMag -2.583
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=ESO 452-SC11"
}

Globular "M 13:NGC 6205:GCl 45:C 1639+365"
{
	RA 16.694787
	Dec 36.45986
	Distance 24200.803
	Radius 424.884
	CoreRadius 0.811
	KingConcentration 1.872
	AbsMag -8.542
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=M 13"
}

Globular "NGC 6229:GCl 47:C 1645+476"
{
	RA 16.783017
	Dec 47.5278
	Distance 98205.685
	Radius 624.72
	CoreRadius 0.127
	KingConcentration 2.237
	AbsMag -8.064
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6229"
}

Globular "M 12:NGC 6218:GCl 46:C 1644-018"
{
	RA 16.787271
	Dec -1.94853
	Distance 16666.591
	Radius 148.793
	CoreRadius 0.78
	KingConcentration 1.595
	AbsMag -6.452
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=M 12"
}

Globular "FSR 1735"
{
	RA 16.869611
	Dec -47.05806
	Distance 29614.999
	Radius 115.198
	CoreRadius 0.197
	KingConcentration 1.832
	AbsMag -0.41
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=FSR 1735"
}

Globular "NGC 6235:GCl 48:C 1650-220"
{
	RA 16.890379
	Dec -22.17745
	Distance 38943.071
	Radius 120.45
	CoreRadius 0.334
	KingConcentration 1.503
	AbsMag -5.765
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6235"
}

Globular "M 10:NGC 6254:GCl 49:C 1654-040"
{
	RA 16.952515
	Dec -4.10031
	Distance 16536.128
	Radius 175.342
	CoreRadius 0.502
	KingConcentration 1.861
	AbsMag -6.915
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=M 10"
}

Globular "NGC 6256:VDBH 208:GCl 49.1:ESO 391-6:C 1656-370"
{
	RA 16.992407
	Dec -37.12097
	Distance 23613.722
	Radius 88.975
	CoreRadius 0.033
	KingConcentration 2.591
	AbsMag -3.739
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6256"
}

Globular "Pal 15:Zwicky 1:UGC 10642:LEDA 59400:K73 781:GCl 50:C 1657-004"
{
	RA 16.997507
	Dec -0.539
	Distance 143834.963
	Radius 340.866
	CoreRadius 1.158
	KingConcentration 0.847
	AbsMag -4.532
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Pal 15"
}

Globular "M 62:NGC 6266:VDBH 210:GCl 51:C 1658-300"
{
	RA 17.020277
	Dec -30.11339
	Distance 19667.23
	Radius 167.677
	CoreRadius 0.131
	KingConcentration 2.349
	AbsMag -7.302
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=M 62"
}

Globular "M 19:NGC 6273:HD 153799:GCl 52:C 1659-262"
{
	RA 17.043833
	Dec -26.26797
	Distance 27201.442
	Radius 129.419
	CoreRadius 0.408
	KingConcentration 1.603
	AbsMag -7.726
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=M 19"
}

Globular "NGC 6284:GCl 53:C 1701-246"
{
	RA 17.074674
	Dec -24.7648
	Distance 46346.821
	Radius 239.007
	CoreRadius 0.065
	KingConcentration 2.434
	AbsMag -6.773
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6284"
}

Globular "Patchick 125:Gran 3"
{
	RA 17.083733
	Dec -35.496
	Distance 37410.137
	Radius 98.532
	CoreRadius 1.118
	KingConcentration 0.908
	AbsMag -2.668
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Patchick 125"
}

Globular "NGC 6287:GCl 54:C 1702-226"
{
	RA 17.085927
	Dec -22.70801
	Distance 25864.201
	Radius 73.744
	CoreRadius 0.139
	KingConcentration 1.849
	AbsMag -5.096
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6287"
}

Globular "Patchick 126"
{
	RA 17.094055
	Dec -47.34222
	Distance 26092.51
	Radius 41.944
	CoreRadius 0.056
	KingConcentration 1.995
	AbsMag -0.095
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Patchick 126"
}

Globular "NGC 6293:VDBH 215:GCl 55:C 1707-265"
{
	RA 17.1695
	Dec -26.58208
	Distance 29973.771
	Radius 78.897
	CoreRadius 0.022
	KingConcentration 2.605
	AbsMag -6.417
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6293"
}

Globular "Gran 2"
{
	RA 17.192667
	Dec -24.849
	Distance 51663.17
	Radius 180.364
	CoreRadius 0.616
	KingConcentration 1.289
	AbsMag -3.439
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Gran 2"
}

Globular "NGC 6304:VDBH 216:GCl 56:ESO 454-2:C 1711-294"
{
	RA 17.242293
	Dec -29.46203
	Distance 20058.617
	Radius 88.943
	CoreRadius 0.218
	KingConcentration 1.845
	AbsMag -5.764
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6304"
}

Globular "NGC 6316:VDBH 219:GCl 57:C 1713-280"
{
	RA 17.277028
	Dec -28.14011
	Distance 36366.436
	Radius 154.859
	CoreRadius 0.228
	KingConcentration 1.807
	AbsMag -6.226
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6316"
}

Globular "M 92:NGC 6341:GCl 59:C 1715+432"
{
	RA 17.285384
	Dec 43.13594
	Distance 27723.292
	Radius 368.557
	CoreRadius 0.117
	KingConcentration 2.591
	AbsMag -8.137
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=M 92"
}

Globular "NGC 6325:GCl 58:ESO 519-11:C 1714-237"
{
	RA 17.299755
	Dec -23.76768
	Distance 24559.575
	Radius 66.601
	CoreRadius 0.05
	KingConcentration 2.269
	AbsMag -3.484
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6325"
}

Globular "M 9:NGC 6333:HD 156587:GCl 60:C 1716-184"
{
	RA 17.319939
	Dec -18.51626
	Distance 27070.979
	Radius 108.48
	CoreRadius 0.335
	KingConcentration 1.613
	AbsMag -6.945
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=M 9"
}

Globular "NGC 6342:GCl 61:C 1718-195"
{
	RA 17.352771
	Dec -19.58766
	Distance 26125.126
	Radius 48.826
	CoreRadius 0.073
	KingConcentration 1.945
	AbsMag -4.658
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6342"
}

Globular "NGC 6356:HD 157361:GCl 62:C 1720-177"
{
	RA 17.393053
	Dec -17.81303
	Distance 51076.089
	Radius 385.517
	CoreRadius 0.336
	KingConcentration 1.888
	AbsMag -7.654
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6356"
}

Globular "NGC 6355:GCl 63:ESO 519-15:C 1720-263"
{
	RA 17.399569
	Dec -26.35283
	Distance 28212.527
	Radius 47.521
	CoreRadius 0.079
	KingConcentration 1.862
	AbsMag -4.645
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6355"
}

Globular "NGC 6352:VDBH 226:GCl 64:C 1721-484"
{
	RA 17.424752
	Dec -48.42217
	Distance 18069.063
	Radius 102.87
	CoreRadius 0.527
	KingConcentration 1.569
	AbsMag -5.658
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6352"
}

Globular "IC 1257:C 1724-070"
{
	RA 17.452362
	Dec -7.09306
	Distance 86724.981
	Radius 194.944
	CoreRadius 0.128
	KingConcentration 1.781
	AbsMag -3.314
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=IC 1257"
}

Globular "Haute-Provence 3:Terzan 2:VDBH 228:GCl 64.1:ESO 454-29:C 1724-307"
{
	RA 17.459195
	Dec -30.80233
	Distance 25277.119
	Radius 40.606
	CoreRadius 0.204
	KingConcentration 1.432
	AbsMag -1.337
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Ter 2"
}

Globular "NGC 6366:GCl 65:C 1725-050"
{
	RA 17.462291
	Dec -5.07986
	Distance 11219.779
	Radius 123.45
	CoreRadius 2.338
	KingConcentration 1.209
	AbsMag -3.833
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6366"
}

Globular "Haute-Provence 4:Terzan 4:GCl 66.1:C 1727-315"
{
	RA 17.510834
	Dec -31.59553
	Distance 24755.269
	Radius 51.207
	CoreRadius 0.177
	KingConcentration 1.605
	AbsMag -0.971
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Ter 4"
}

Globular "HP 1"
{
	RA 17.518111
	Dec -29.98167
	Distance 22830.946
	Radius 60.535
	CoreRadius 0.486
	KingConcentration 1.273
	AbsMag -3.155
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=HP 1"
}

Globular "FSR 1758"
{
	RA 17.52
	Dec -39.808
	Distance 36170.742
	Radius 358.772
	CoreRadius 3.137
	KingConcentration 1.036
	AbsMag -6.085
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=FSR 1758"
}

Globular "NGC 6362:GCl 66:C 1726-670"
{
	RA 17.53194
	Dec -67.04833
	Distance 24950.963
	Radius 164.611
	CoreRadius 1.303
	KingConcentration 1.241
	AbsMag -6.968
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6362"
}

Globular "Liller 1:Liller I:C 1730-333"
{
	RA 17.556822
	Dec -33.38956
	Distance 26288.204
	Radius 126.777
	CoreRadius 0.077
	KingConcentration 2.334
	AbsMag 1.198
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Liller 1"
}

Globular "Ton 1:NGC 6380:Pismis 25:VDBH 233:Tonantzintla 1:GCl 68:ESO 333-14:C 1731-390"
{
	RA 17.574574
	Dec -39.06953
	Distance 31343.628
	Radius 131.245
	CoreRadius 0.34
	KingConcentration 1.627
	AbsMag -4.214
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6380"
}

Globular "Haute-Provence 2:Terzan 1:VDBH 235:GCl 69:ESO 455-23:C 1732-304"
{
	RA 17.596445
	Dec -30.48178
	Distance 18493.067
	Radius 124.657
	CoreRadius 0.218
	KingConcentration 2.026
	AbsMag -1.368
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Ter 1"
}

Globular "Ton 2:Pismis 26:VDBH 236:Tonantzintla 2:GCl 71:C 1732-385"
{
	RA 17.6028
	Dec -38.5561
	Distance 22798.331
	Radius 70.287
	CoreRadius 0.487
	KingConcentration 1.338
	AbsMag -2.562
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Ton 2"
}

Globular "NGC 6388:VDBH 234:C 1732-447:GCl 70"
{
	RA 17.604785
	Dec -44.7355
	Distance 36431.667
	Radius 315.882
	CoreRadius 0.148
	KingConcentration 2.305
	AbsMag -8.42
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6388"
}

Globular "M 14:NGC 6402:GCl 72:C 1735-032"
{
	RA 17.62671
	Dec -3.24592
	Distance 29810.693
	Radius 241.193
	CoreRadius 0.752
	KingConcentration 1.568
	AbsMag -6.935
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=M 14"
}

Globular "NGC 6401:GCl 73:ESO 520-11:C 1735-238"
{
	RA 17.643479
	Dec -23.9096
	Distance 24266.035
	Radius 51.565
	CoreRadius 0.166
	KingConcentration 1.643
	AbsMag -4.388
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6401"
}

Globular "NGC 6397:GCl 74:C 1736-536"
{
	RA 17.678359
	Dec -53.67434
	Distance 8088.678
	Radius 161.904
	CoreRadius 0.194
	KingConcentration 2.55
	AbsMag -6.522
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6397"
}

Globular "Pal 6:GCl 75:ESO 520-21:C 1740-262"
{
	RA 17.728387
	Dec -26.22499
	Distance 22994.025
	Radius 34.018
	CoreRadius 0.297
	KingConcentration 1.233
	AbsMag -2.641
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Pal 6"
}

Globular "NGC 6426:GCl 76:C 1742+031"
{
	RA 17.748531
	Dec 3.17014
	Distance 67546.986
	Radius 289.268
	CoreRadius 0.435
	KingConcentration 1.53
	AbsMag -5.451
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6426"
}

Globular "Djor 1"
{
	RA 17.791305
	Dec -33.06639
	Distance 32224.25
	Radius 82.713
	CoreRadius 0.278
	KingConcentration 1.501
	AbsMag -1.894
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Djor 1"
}

Globular "Terzan 5:GCl 76.1:ESO 520-27:C 1745-247"
{
	RA 17.801347
	Dec -24.77906
	Distance 21591.552
	Radius 167.188
	CoreRadius 0.348
	KingConcentration 1.884
	AbsMag -1.744
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Ter 5"
}

Globular "NGC 6440:MXB 1746-20:GCl 77:C 1746-203"
{
	RA 17.814678
	Dec -20.36042
	Distance 26907.901
	Radius 110.502
	CoreRadius 0.154
	KingConcentration 1.962
	AbsMag -5.612
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6440"
}

Globular "Gran 5"
{
	RA 17.8152
	Dec -24.17
	Distance 16014.278
	Radius 70.156
	CoreRadius 0.301
	KingConcentration 1.699
	AbsMag -1.345
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Gran 5"
}

Globular "NGC 6441:VDBH 248:GCl 78:C 1746-370"
{
	RA 17.836961
	Dec -37.05145
	Distance 41519.707
	Radius 353.26
	CoreRadius 0.173
	KingConcentration 2.228
	AbsMag -8.404
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6441"
}

Globular "Haute-Provence 5:Terzan 6:VDBH 249:GCl 78.1:ESO 455-49:C 1747-313:C 1747-312"
{
	RA 17.846217
	Dec -31.27539
	Distance 23711.569
	Radius 45.303
	CoreRadius 0.184
	KingConcentration 1.552
	AbsMag 0.162
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Ter 6"
}

Globular "NGC 6453:VDBH 251:GCl 79:C 1748-346"
{
	RA 17.847701
	Dec -34.59848
	Distance 32843.947
	Radius 107.371
	CoreRadius 0.044
	KingConcentration 2.404
	AbsMag -5.825
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6453"
}

Globular "UKS 1:UKS 1751-24.1:C 1751-241"
{
	RA 17.907554
	Dec -24.14528
	Distance 50815.164
	Radius 156.653
	CoreRadius 0.225
	KingConcentration 1.673
	AbsMag 1.327
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=UKS 1"
}

Globular "VVV-CL001"
{
	RA 17.911805
	Dec -24.01472
	Distance 26353.435
	Radius 118.786
	CoreRadius 0.238
	KingConcentration 1.813
	AbsMag -0.337
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=VVV-CL001"
}

Globular "ESO 456-SC29:Gran 1"
{
	RA 17.976733
	Dec -32.02
	Distance 26973.132
	Radius 62.133
	CoreRadius 0.569
	KingConcentration 1.143
	AbsMag -2.178
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=ESO 456-SC29"
}

Globular "NGC 6496:GCl 80:C 1755-442"
{
	RA 17.984357
	Dec -44.26595
	Distance 31441.475
	Radius 94.977
	CoreRadius 0.909
	KingConcentration 1.058
	AbsMag -6.27
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6496"
}

Globular "Terzan 9:GCl 80.1:C 1758-268"
{
	RA 18.027445
	Dec -26.83972
	Distance 18819.223
	Radius 103.098
	CoreRadius 0.167
	KingConcentration 2.053
	AbsMag -1.076
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Ter 9"
}

Globular "ESO456-SC38:Djorg 2:ESO 456-38:C 1758-278"
{
	RA 18.030292
	Dec -27.82582
	Distance 28571.299
	Radius 50.326
	CoreRadius 0.514
	KingConcentration 1.071
	AbsMag -4.013
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=ESO 456-SC38"
}

Globular "NGC 6517:GCl 81:C 1759-089"
{
	RA 18.030717
	Dec -8.95878
	Distance 30104.234
	Radius 154.468
	CoreRadius 0.052
	KingConcentration 2.529
	AbsMag -4.136
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6517"
}

Globular "Terzan 10:GCl 82.1:ESO 521-16:C 1800-260"
{
	RA 18.049389
	Dec -26.06694
	Distance 33300.566
	Radius 135.518
	CoreRadius 0.101
	KingConcentration 2.141
	AbsMag -0.315
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Ter 10"
}

Globular "NGC 6522:VDBH 256:GCl 82:C 1800-300"
{
	RA 18.059464
	Dec -30.03397
	Distance 23776.8
	Radius 50.098
	CoreRadius 0.184
	KingConcentration 1.595
	AbsMag -6.034
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6522"
}

Globular "NGC 6535:GCl 83:C 1801-003"
{
	RA 18.06403
	Dec -0.29764
	Distance 20743.546
	Radius 80.561
	CoreRadius 0.108
	KingConcentration 2.092
	AbsMag -3.917
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6535"
}

Globular "NGC 6528:VDBH 257:GCl 84:ESO 456-48:C 1801-300"
{
	RA 18.080447
	Dec -30.05578
	Distance 25538.044
	Radius 35.812
	CoreRadius 0.119
	KingConcentration 1.609
	AbsMag -4.759
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6528"
}

Globular "NGC 6539:GCl 85:C 1802-075"
{
	RA 18.080485
	Dec -7.58586
	Distance 26614.36
	Radius 146.314
	CoreRadius 0.586
	KingConcentration 1.509
	AbsMag -4.618
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6539"
}

Globular "Djorg 3:NGC 6540:VDBH 258:C 1803-278"
{
	RA 18.102377
	Dec -27.76529
	Distance 19275.842
	Radius 74.07
	CoreRadius 0.052
	KingConcentration 2.402
	AbsMag -4.118
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6540"
}

Globular "VVV-CL160"
{
	RA 18.115833
	Dec -20.01111
	Distance 22178.634
	Radius 63.666
	CoreRadius 0.409
	KingConcentration 1.382
	AbsMag 1.437
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=VVV-CL160"
}

Globular "NGC 6544:GCl 87:C 1804-250"
{
	RA 18.122255
	Dec -24.99822
	Distance 8414.835
	Radius 155.74
	CoreRadius 0.266
	KingConcentration 2.378
	AbsMag -4.198
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6544"
}

Globular "NGC 6541:GCl 86:C 1804-437"
{
	RA 18.133989
	Dec -43.71489
	Distance 24820.5
	Radius 122.048
	CoreRadius 0.05
	KingConcentration 2.532
	AbsMag -7.797
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6541"
}

Globular "2MASS-GC01:Hurt 1:[HJK2000] GC01"
{
	RA 18.13939
	Dec -19.82972
	Distance 10991.47
	Radius 99.282
	CoreRadius 0.184
	KingConcentration 2.228
	AbsMag -6.11 # From http://spider.seds.org/spider/MWGC/2mass-gc01.html
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=2MASS-GC01"
}

Globular "ESO 280-SC06:ESO 280-6"
{
	RA 18.151667
	Dec -46.42333
	Distance 68329.761
	Radius 248.042
	CoreRadius 0.404
	KingConcentration 1.49
	AbsMag -4.376
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=ESO 280-SC06"
}

Globular "NGC 6553:GCl 88:C 1806-259"
{
	RA 18.154866
	Dec -25.90807
	Distance 17384.135
	Radius 156.001
	CoreRadius 0.335
	KingConcentration 1.964
	AbsMag -5.594
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6553"
}

Globular "2MASS-GC02:Hurt 2:[HJK2000] GC02"

{
	RA 18.16014
	Dec -20.77889
	Distance 17938.601
	Radius 51.207
	CoreRadius 0.388
	KingConcentration 1.404
	AbsMag -4.86 # From http://spider.seds.org/spider/MWGC/2mass-gc02.html
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=2MASS-GC02"
}

Globular "NGC 6558:VDBH 259:GCl 89:ESO 456-62:C 1807-317"
{
	RA 18.171598
	Dec -31.76451
	Distance 25407.582
	Radius 29.158
	CoreRadius 0.066
	KingConcentration 1.775
	AbsMag -4.798
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6558"
}

Globular "Pal 7:IC 1276:GCl 90:C 1808-072"
{
	RA 18.178963
	Dec -7.2076
	Distance 14840.115
	Radius 123.124
	CoreRadius 0.657
	KingConcentration 1.637
	AbsMag -3.37
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=IC 1276"
}

Globular "Terzan 11:Terzan 12:GCl 90.1:ESO 522-1:C 1809-227"
{
	RA 18.204389
	Dec -22.74194
	Distance 16862.285
	Radius 81.18
	CoreRadius 0.439
	KingConcentration 1.576
	AbsMag 0.253
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Ter 12"
}

Globular "NGC 6569:VDBH 260:GCl 91:ESO 456-77:C 1810-318"
{
	RA 18.227445
	Dec -31.82689
	Distance 34344.267
	Radius 139.954
	CoreRadius 0.291
	KingConcentration 1.683
	AbsMag -6.212
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6569"
}

Globular "AL 3:BH 261"
{
	RA 18.235167
	Dec -28.635
	Distance 19960.77
	Radius 67.286
	CoreRadius 0.202
	KingConcentration 1.758
	AbsMag -2.674
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=AL 3"
}

Globular "NGC 6584:GCl 92:C 1814-522"
{
	RA 18.310443
	Dec -52.21578
	Distance 44389.883
	Radius 193.9
	CoreRadius 0.293
	KingConcentration 1.71
	AbsMag -6.909
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6584"
}

Globular "NGC 6624:VDBH 262:KOHX 13:GCl 93:ESO 457-11:C 1820-303"
{
	RA 18.394586
	Dec -30.36103
	Distance 26157.741
	Radius 54.86
	CoreRadius 0.081
	KingConcentration 1.947
	AbsMag -6.491
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6624"
}

Globular "M 28:NGC 6626:GCl 94:C 1821-249"
{
	RA 18.409136
	Dec -24.86985
	Distance 17514.597
	Radius 154.663
	CoreRadius 0.205
	KingConcentration 2.171
	AbsMag -6.8
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=M 28"
}

Globular "NGC 6638:GCl 95:C 1827-255"
{
	RA 18.515582
	Dec -25.49747
	Distance 31898.094
	Radius 94.748
	CoreRadius 0.169
	KingConcentration 1.782
	AbsMag -6.162
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6638"
}

Globular "M 69:NGC 6637:HD 170534:GCl 96:C 1828-323"
{
	RA 18.523083
	Dec -32.34808
	Distance 29027.918
	Radius 78.93
	CoreRadius 0.22
	KingConcentration 1.628
	AbsMag -7.127
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=M 69"
}

Globular "NGC 6642:GCl 97:ESO 522-32:C 1828-235"
{
	RA 18.531731
	Dec -23.4756
	Distance 26255.588
	Radius 52.903
	CoreRadius 0.047
	KingConcentration 2.169
	AbsMag -4.879
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6642"
}

Globular "NGC 6652:GCl 98:C 1832-330"
{
	RA 18.596008
	Dec -32.99072
	Distance 30854.393
	Radius 57.73
	CoreRadius 0.062
	KingConcentration 2.018
	AbsMag -5.959
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6652"
}

Globular "M 22:NGC 6656:HD 171560:GCl 99:C 1833-239"
{
	RA 18.606651
	Dec -23.90475
	Distance 10763.16
	Radius 250.553
	CoreRadius 0.917
	KingConcentration 1.941
	AbsMag -7.533
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=M 22"
}

Globular "Pal 8:GCl 100:ESO 591-12:C 1838-198"
{
	RA 18.691819
	Dec -19.82886
	Distance 36920.902
	Radius 120.58
	CoreRadius 0.571
	KingConcentration 1.294
	AbsMag -5.159
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Pal 8"
}

Globular "M 70:NGC 6681:GCl 101:C 1840-323"
{
	RA 18.720211
	Dec -32.29211
	Distance 30528.237
	Radius 89.595
	CoreRadius 0.026
	KingConcentration 2.594
	AbsMag -6.946
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=M 70"
}

Globular "RLGC 2:Ryu 879"
{
	RA 18.757825
	Dec -5.19258
	Distance 51695.786
	Radius 313.306
	CoreRadius 0.069
	KingConcentration 2.477
	AbsMag -2.14
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=RLGC 2"
}

Globular "NGC 6712:OCl 72.0:GCl 103:C 1850-087:AO 1850-08"
{
	RA 18.884535
	Dec -8.70596
	Distance 24070.341
	Radius 108.447
	CoreRadius 0.312
	KingConcentration 1.696
	AbsMag -5.74
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6712"
}

Globular "M 54:NGC 6715:GCl 104:C 1851-305"
{
	RA 18.91759
	Dec -30.47986
	Distance 85713.896
	Radius 910.466
	CoreRadius 0.072
	KingConcentration 2.705
	AbsMag -9.528
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=M 54"
}

Globular "Pal 9:NGC 6717:GCl 105:ESO 523-14:C 1852-227"
{
	RA 18.918345
	Dec -22.70147
	Distance 24526.96
	Radius 58.121
	CoreRadius 0.133
	KingConcentration 1.789
	AbsMag -5.401
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6717"
}

Globular "NGC 6723:GCl 106:C 1856-367"
{
	RA 18.992541
	Dec -36.63225
	Distance 26973.132
	Radius 125.701
	CoreRadius 0.615
	KingConcentration 1.416
	AbsMag -7.378
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6723"
}

Globular "NGC 6749:Berkeley 42:GCl 107:C 1902+018"
{
	RA 19.087604
	Dec 1.89976
	Distance 24755.269
	Radius 205.348
	CoreRadius 0.67
	KingConcentration 1.629
	AbsMag -3.491
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6749"
}

Globular "NGC 6752:GCl 108:C 1906-600"
{
	RA 19.18114
	Dec -59.98455
	Distance 13437.643
	Radius 216.6
	CoreRadius 0.25
	KingConcentration 2.345
	AbsMag -7.724
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6752"
}

Globular "NGC 6760:GCl 109:C 1908+009"
{
	RA 19.186685
	Dec 1.03047
	Distance 27429.751
	Radius 239.464
	CoreRadius 0.441
	KingConcentration 1.832
	AbsMag -5.734
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6760"
}

Globular "M 56:NGC 6779:GCl 110:C 1914+300"
{
	RA 19.276546
	Dec 30.18347
	Distance 34018.11
	Radius 300.618
	CoreRadius 0.323
	KingConcentration 1.973
	AbsMag -6.941
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=M 56"
}

Globular "Terzan 7:GCl 109.1:C 1914-347"
{
	RA 19.295532
	Dec -34.65772
	Distance 79190.769
	Radius 202.347
	CoreRadius 0.561
	KingConcentration 1.195
	AbsMag -5.076
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Ter 7"
}

Globular "Pal 10:GCl 111:C 1916+184"
{
	RA 19.300582
	Dec 18.57167
	Distance 29158.38
	Radius 206.718
	CoreRadius 0.858
	KingConcentration 1.454
	AbsMag -2.387
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Pal 10"
}

Globular "Arp 2:GCl 112:C 1925-304"
{
	RA 19.478921
	Dec -30.35564
	Distance 93704.727
	Radius 283.887
	CoreRadius 0.997
	KingConcentration 1.019
	AbsMag -5.642
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Arp 2"
}

Globular "M 55:NGC 6809:GCl 113:C 1936-310"
{
	RA 19.666585
	Dec -30.96475
	Distance 17449.366
	Radius 169.699
	CoreRadius 1.6
	KingConcentration 1.32
	AbsMag -7.352
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=M 55"
}

Globular "Terzan 8:GCl 113.1:C 1938-341"
{
	RA 19.695669
	Dec -33.99947
	Distance 89823.466
	Radius 352.934
	CoreRadius 1.253
	KingConcentration 1.033
	AbsMag -6.15
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Ter 8"
}

Globular "Pal 11:GCl 114:C 1942-081"
{
	RA 19.754
	Dec -8.00722
	Distance 45727.124
	Radius 106.914
	CoreRadius 1.005
	KingConcentration 0.903
	AbsMag -3.874
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Pal 11"
}

Globular "Sagittarius II:Sgr II:Laevens 5"
{
	RA 19.877647
	Dec -22.06525
	Distance 216991.838
	Radius 1252.93
	CoreRadius 1.062
	KingConcentration 1.272
	AbsMag -5.075
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Sagittarius II"
}

Globular "M 71:NGC 6838:GCl 115:C 1951+186"
{
	RA 19.896249
	Dec 18.77919
	Distance 13046.255
	Radius 133.561
	CoreRadius 0.92
	KingConcentration 1.583
	AbsMag -5.85
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=M 71"
}

Globular "M 75:NGC 6864:GCl 116:C 2003-220"
{
	RA 20.101319
	Dec -21.92116
	Distance 66927.289
	Radius 508.869
	CoreRadius 0.069
	KingConcentration 2.58
	AbsMag -8.051
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=M 75"
}

Globular "NGC 6934:GCl 117:C 2031+072"
{
	RA 20.569826
	Dec 7.40447
	Distance 51271.783
	Radius 290.899
	CoreRadius 0.155
	KingConcentration 2.099
	AbsMag -7.242
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6934"
}

Globular "M 72:NGC 6981:GCl 118:C 2050-127"
{
	RA 20.891028
	Dec -12.53731
	Distance 54337.653
	Radius 176.092
	CoreRadius 0.433
	KingConcentration 1.41
	AbsMag -6.788
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=M 72"
}

Globular "NGC 7006:GCl 119:C 2059+160"
{
	RA 21.024842
	Dec 16.18732
	Distance 128244.688
	Radius 549.769
	CoreRadius 0.149
	KingConcentration 1.996
	AbsMag -7.283
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 7006"
}

Globular "Laevens 3"
{
	RA 21.115113
	Dec 14.9805
	Distance 201466.795
	Radius 169.536
	CoreRadius 0.124
	KingConcentration 1.369
	AbsMag -2.854
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Laevens 3"
}

Globular "M 15:NGC 7078:GCl 120:C 2127+119"
{
	RA 21.499536
	Dec 12.167
	Distance 34931.3479999999
	Radius 430.95
	CoreRadius 0.019
	KingConcentration 3.343
	AbsMag -8.869
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=M 15"
}

Globular "M 2:NGC 7089:HD 205146:GCl 121:C 2130-010"
{
	RA 21.557505
	Dec -0.82325
	Distance 38127.681
	Radius 361.283
	CoreRadius 0.209
	KingConcentration 2.193
	AbsMag -8.859
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=M 2"
}

Globular "M 30:NGC 7099:GCl 122:C 2137-234"
{
	RA 21.672809
	Dec -23.17986
	Distance 27592.83
	Radius 232.223
	CoreRadius 0.037
	KingConcentration 2.898
	AbsMag -7.267
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=M 30"
}

Globular "Pal 12:GCl 123:C 2143-214"
{
	RA 21.777453
	Dec -21.25261
	Distance 60306.314
	Radius 208.577
	CoreRadius 0.589
	KingConcentration 1.305
	AbsMag -4.345
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Pal 12"
}

Globular "Pal 13:UGCA 435:TC 408:GCl 124:C 2304+124"
{
	RA 23.112346
	Dec 12.77154
	Distance 76581.517
	Radius 122.798
	CoreRadius 0.048
	KingConcentration 2.057
	AbsMag -2.963
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Pal 13"
}

Globular "NGC 7492:GCl 125:C 2305-159"
{
	RA 23.140745
	Dec -15.61147
	Distance 79549.541
	Radius 279.483
	CoreRadius 0.598
	KingConcentration 1.306
	AbsMag -5.796
	InfoURL "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 7492"
}
