/*
 * Decompiled with CFR 0.152.
 */
package ch.csnc.extension.ui;

import ch.csnc.extension.util.DriverConfiguration;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class DriverTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -9114670362713975727L;
    private DriverConfiguration driverConfig;
    private Vector<String> names;
    private Vector<String> paths;
    private Vector<Integer> slots;
    private Vector<Integer> slotListIndexes;

    public DriverTableModel(DriverConfiguration driverConfig) {
        this.driverConfig = driverConfig;
        this.driverConfig.addChangeListener(e -> this.fireTableDataChanged());
        this.names = driverConfig.getNames();
        this.paths = driverConfig.getPaths();
        this.slots = driverConfig.getSlots();
        this.slotListIndexes = driverConfig.getSlotIndexes();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public int getRowCount() {
        return this.names.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (column == 0) {
            return this.names.get(row);
        }
        if (column == 1) {
            return this.paths.get(row);
        }
        if (column == 2) {
            return this.slots.get(row);
        }
        if (column == 3) {
            return this.slotListIndexes.get(row);
        }
        return "";
    }

    int getPreferredWith(int column) {
        if (column == 0) {
            return 75;
        }
        if (column == 1) {
            return 300;
        }
        if (column == 2) {
            return 15;
        }
        if (column == 3) {
            return 15;
        }
        return 0;
    }

    void addDriver(String name, String path, int slot, int slotListIndex) {
        this.names.add(name);
        this.paths.add(path);
        this.slots.add(slot);
        this.slotListIndexes.add(slotListIndex);
        this.updateConfiguration();
    }

    void deleteDriver(int index) {
        this.names.remove(index);
        this.paths.remove(index);
        this.slots.remove(index);
        this.slotListIndexes.remove(index);
        this.updateConfiguration();
    }

    private void updateConfiguration() {
        this.driverConfig.setNames(this.names);
        this.driverConfig.setPaths(this.paths);
        this.driverConfig.setSlots(this.slots);
        this.driverConfig.setSlotListIndexes(this.slotListIndexes);
        this.driverConfig.write();
    }

    @Override
    public String getColumnName(int columnNumber) {
        if (columnNumber == 0) {
            return "Name";
        }
        if (columnNumber == 1) {
            return "Path";
        }
        if (columnNumber == 2) {
            return "Slot";
        }
        if (columnNumber == 3) {
            return "SlotListIndex";
        }
        throw new IllegalArgumentException("Invalid column number: " + columnNumber);
    }
}

