/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import org.lwjgl.cuda.CU;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class CUDAProfiler {
    public static final int CU_OUT_KEY_VALUE_PAIR = 0;
    public static final int CU_OUT_CSV = 1;

    protected CUDAProfiler() {
        throw new UnsupportedOperationException();
    }

    public static int ncuProfilerInitialize(long configFile, long outputFile, int outputMode) {
        long __functionAddress = Functions.ProfilerInitialize;
        return JNI.callPPI((long)configFile, (long)outputFile, (int)outputMode, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuProfilerInitialize(@NativeType(value="char const *") ByteBuffer configFile, @NativeType(value="char const *") ByteBuffer outputFile, @NativeType(value="CUoutput_mode") int outputMode) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)configFile);
            Checks.checkNT1((ByteBuffer)outputFile);
        }
        return CUDAProfiler.ncuProfilerInitialize(MemoryUtil.memAddress((ByteBuffer)configFile), MemoryUtil.memAddress((ByteBuffer)outputFile), outputMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="CUresult")
    public static int cuProfilerInitialize(@NativeType(value="char const *") CharSequence configFile, @NativeType(value="char const *") CharSequence outputFile, @NativeType(value="CUoutput_mode") int outputMode) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(configFile, true);
            long configFileEncoded = stack.getPointerAddress();
            stack.nASCII(outputFile, true);
            long outputFileEncoded = stack.getPointerAddress();
            int n = CUDAProfiler.ncuProfilerInitialize(configFileEncoded, outputFileEncoded, outputMode);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="CUresult")
    public static int cuProfilerStart() {
        long __functionAddress = Functions.ProfilerStart;
        return JNI.callI((long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuProfilerStop() {
        long __functionAddress = Functions.ProfilerStop;
        return JNI.callI((long)__functionAddress);
    }

    public static final class Functions {
        public static final long ProfilerInitialize = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuProfilerInitialize");
        public static final long ProfilerStart = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuProfilerStart");
        public static final long ProfilerStop = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuProfilerStop");

        private Functions() {
        }
    }
}

