/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.derby.catalog.types.DefaultInfoImpl;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.OptimizerFactory;
import org.apache.derby.iapi.sql.compile.Parser;
import org.apache.derby.iapi.sql.compile.RequiredRowOrdering;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.DefaultDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.AllResultColumn;
import org.apache.derby.impl.sql.compile.BaseColumnNode;
import org.apache.derby.impl.sql.compile.BooleanConstantNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.CursorNode;
import org.apache.derby.impl.sql.compile.DMLStatementNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.InsertNode;
import org.apache.derby.impl.sql.compile.OptimizerImpl;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ProjectRestrictNode;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.RowResultSetNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.UntypedNullConstantNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public abstract class ResultSetNode
extends QueryTreeNode {
    private int resultSetNumber;
    private JBitSet referencedTableMap;
    private ResultColumnList resultColumns;
    private boolean statementResultSet;
    private boolean cursorTargetTable;
    private boolean insertSource;
    private CostEstimate costEstimate;
    private CostEstimate scratchCostEstimate;
    private Optimizer optimizer;
    private CostEstimate candidateFinalCostEstimate;

    ResultSetNode(ContextManager cm) {
        super(cm);
    }

    @Override
    public String toString() {
        return "resultSetNumber: " + this.resultSetNumber + "\nreferencedTableMap: " + (this.referencedTableMap != null ? this.referencedTableMap.toString() : "null") + "\nstatementResultSet: " + this.statementResultSet + "\n" + super.toString();
    }

    @Override
    void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.resultColumns != null) {
            this.printLabel(depth, "resultColumns: ");
            this.resultColumns.treePrint(depth + 1);
        }
    }

    boolean isStatementResultSet() {
        return this.statementResultSet;
    }

    boolean isCursorTargetTable() {
        return this.cursorTargetTable;
    }

    void setCursorTargetTable(boolean yesOrNo) {
        this.cursorTargetTable = yesOrNo;
    }

    CostEstimate getScratchCostEstimate() {
        return this.scratchCostEstimate;
    }

    void setScratchCostEstimate(CostEstimate ce) {
        this.scratchCostEstimate = ce;
    }

    public int getResultSetNumber() {
        return this.resultSetNumber;
    }

    void setResultSetNumber(int rsn) {
        this.resultSetNumber = rsn;
    }

    CostEstimate getCostEstimate() {
        return this.costEstimate;
    }

    void setCostEstimate(CostEstimate ce) {
        this.costEstimate = ce;
    }

    CostEstimate getFinalCostEstimate() throws StandardException {
        if (this.candidateFinalCostEstimate == null) {
            SanityManager.THROWASSERT((String)("candidateFinalCostEstimate is not expected to be null for " + this.getClass().getName()));
        }
        return this.candidateFinalCostEstimate;
    }

    CostEstimate getCandidateFinalCostEstimate() {
        return this.candidateFinalCostEstimate;
    }

    void setCandidateFinalCostEstimate(CostEstimate ce) {
        this.candidateFinalCostEstimate = ce;
    }

    void assignResultSetNumber() throws StandardException {
        this.resultSetNumber = this.getCompilerContext().getNextResultSetNumber();
        this.resultColumns.setResultSetNumber(this.resultSetNumber);
    }

    ResultSetNode bindNonVTITables(DataDictionary dataDictionary, FromList fromListParam) throws StandardException {
        return this;
    }

    ResultSetNode bindVTITables(FromList fromListParam) throws StandardException {
        return this;
    }

    void bindExpressions(FromList fromListParam) throws StandardException {
        SanityManager.ASSERT((boolean)false, (String)("bindExpressions() is not expected to be called for " + this.getClass().toString()));
    }

    void bindExpressionsWithTables(FromList fromListParam) throws StandardException {
        SanityManager.ASSERT((boolean)false, (String)("bindExpressionsWithTables() is not expected to be called for " + this.getClass().toString()));
    }

    void bindTargetExpressions(FromList fromListParam) throws StandardException {
        SanityManager.ASSERT((boolean)false, (String)("bindTargetExpressions() is not expected to be called for " + this.getClass().toString()));
    }

    void setTableConstructorTypes(ResultColumnList typeColumns) throws StandardException {
        for (int i = 0; i < this.resultColumns.size(); ++i) {
            ResultColumn rc = (ResultColumn)this.resultColumns.elementAt(i);
            ValueNode re = rc.getExpression();
            if (re == null || !re.requiresTypeFromContext()) continue;
            ResultColumn typeCol = (ResultColumn)typeColumns.elementAt(i);
            re.setType(typeCol.getTypeServices());
        }
    }

    void setInsertSource() {
        this.insertSource = true;
    }

    boolean isInsertSource() {
        return this.insertSource;
    }

    void verifySelectStarSubquery(FromList outerFromList, int subqueryType) throws StandardException {
        SanityManager.ASSERT((boolean)false, (String)("verifySelectStarSubquery() is not expected to be called for " + this.getClass().toString()));
    }

    ResultColumnList getAllResultColumns(TableName allTableName) throws StandardException {
        SanityManager.THROWASSERT((String)("getAllResultColumns() not expected to be called for " + this.getClass().getName() + String.valueOf(this)));
        return null;
    }

    ResultColumn getMatchingColumn(ColumnReference columnReference) throws StandardException {
        SanityManager.THROWASSERT((String)("getMatchingColumn() not expected to be called for " + String.valueOf(this)));
        return null;
    }

    ResultSetNode setResultToBooleanTrueNode(boolean onlyConvertAlls) throws StandardException {
        ResultColumn resultColumn;
        if (this.resultColumns.elementAt(0) instanceof AllResultColumn) {
            resultColumn = new ResultColumn("", null, this.getContextManager());
        } else {
            if (onlyConvertAlls) {
                return this;
            }
            resultColumn = (ResultColumn)this.resultColumns.elementAt(0);
            if (resultColumn.getExpression().isBooleanTrue() && this.resultColumns.size() == 1) {
                return this;
            }
        }
        BooleanConstantNode booleanNode = new BooleanConstantNode(true, this.getContextManager());
        resultColumn.setExpression(booleanNode);
        resultColumn.setType(booleanNode.getTypeServices());
        resultColumn.setVirtualColumnId(1);
        this.resultColumns.setElementAt(resultColumn, 0);
        return this;
    }

    FromList getFromList() throws StandardException {
        return new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager());
    }

    void bindResultColumns(FromList fromListParam) throws StandardException {
        this.resultColumns.bindResultColumnsToExpressions();
    }

    void bindResultColumns(TableDescriptor targetTableDescriptor, FromVTI targetVTI, ResultColumnList targetColumnList, DMLStatementNode statement, FromList fromListParam) throws StandardException {
        if (this instanceof SelectNode) {
            this.resultColumns.expandAllsAndNameColumns(((SelectNode)this).fromList);
        }
        if (targetColumnList != null) {
            this.resultColumns.copyResultColumnNames(targetColumnList);
        }
        if (targetColumnList != null) {
            if (targetTableDescriptor != null) {
                this.resultColumns.bindResultColumnsByName(targetTableDescriptor, statement);
            } else {
                this.resultColumns.bindResultColumnsByName(targetVTI.getResultColumns(), targetVTI, statement);
            }
        } else {
            this.resultColumns.bindResultColumnsByPosition(targetTableDescriptor);
        }
    }

    void bindUntypedNullsToResultColumns(ResultColumnList rcl) throws StandardException {
    }

    ResultSetNode preprocess(int numTables, GroupByList gbl, FromList fromList) throws StandardException {
        SanityManager.THROWASSERT((String)("preprocess() not expected to be called for " + this.getClass().toString()));
        return null;
    }

    void projectResultColumns() throws StandardException {
    }

    ResultSetNode ensurePredicateList(int numTables) throws StandardException {
        SanityManager.THROWASSERT((String)("ensurePredicateList() not expected to be called for " + this.getClass().toString()));
        return null;
    }

    ResultSetNode addNewPredicate(Predicate predicate) throws StandardException {
        SanityManager.THROWASSERT((String)("addNewPredicate() not expected to be called for " + this.getClass().toString()));
        return null;
    }

    boolean flattenableInFromSubquery(FromList fromList) {
        SanityManager.THROWASSERT((String)("flattenableInFromSubquery() not expected to be called for " + this.getClass().toString()));
        return false;
    }

    ResultSetNode genProjectRestrictForReordering() throws StandardException {
        ResultColumnList prRCList = this.resultColumns;
        this.resultColumns = this.resultColumns.copyListAndObjects();
        prRCList.genVirtualColumnNodes(this, this.resultColumns, false);
        return new ProjectRestrictNode(this, prRCList, null, null, null, null, null, this.getContextManager());
    }

    ResultSetNode optimize(DataDictionary dataDictionary, PredicateList predicates, double outerRows) throws StandardException {
        SanityManager.ASSERT((boolean)false, (String)("optimize() is not expected to be called for " + this.getClass().toString()));
        return null;
    }

    ResultSetNode modifyAccessPaths() throws StandardException {
        return this;
    }

    ResultSetNode modifyAccessPaths(PredicateList predList) throws StandardException {
        return this.modifyAccessPaths();
    }

    ResultColumnDescriptor[] makeResultDescriptors() {
        return this.resultColumns.makeResultDescriptors();
    }

    boolean columnTypesAndLengthsMatch() throws StandardException {
        return this.resultColumns.columnTypesAndLengthsMatch();
    }

    void setResultColumns(ResultColumnList newRCL) {
        this.resultColumns = newRCL;
    }

    ResultColumnList getResultColumns() {
        return this.resultColumns;
    }

    void setReferencedTableMap(JBitSet newRTM) {
        this.referencedTableMap = newRTM;
    }

    public JBitSet getReferencedTableMap() {
        return this.referencedTableMap;
    }

    void fillInReferencedTableMap(JBitSet passedMap) {
    }

    void rejectParameters() throws StandardException {
        if (this.resultColumns != null) {
            this.resultColumns.rejectParameters();
        }
    }

    void rejectXMLValues() throws StandardException {
        if (this.resultColumns != null) {
            this.resultColumns.rejectXMLValues();
        }
    }

    void renameGeneratedResultNames() throws StandardException {
        for (int i = 0; i < this.resultColumns.size(); ++i) {
            ResultColumn rc = (ResultColumn)this.resultColumns.elementAt(i);
            if (!rc.isNameGenerated()) continue;
            rc.setName(Integer.toString(i + 1));
        }
    }

    void markStatementResultSet() {
        this.statementResultSet = true;
    }

    ResultSetNode enhanceRCLForInsert(InsertNode target, boolean inOrder, int[] colMap) throws StandardException {
        if (!inOrder || this.resultColumns.visibleSize() < target.resultColumnList.size()) {
            return this.generateProjectRestrictForInsert(target, colMap);
        }
        return this;
    }

    ResultColumnList getRCLForInsert(InsertNode target, int[] colMap) throws StandardException {
        ResultColumnList newResultCols = new ResultColumnList(this.getContextManager());
        int numTargetColumns = target.resultColumnList.size();
        for (int index = 0; index < numTargetColumns; ++index) {
            ResultColumn newResultColumn = colMap[index] != -1 ? this.resultColumns.getResultColumn(colMap[index] + 1) : this.genNewRCForInsert(target.targetTableDescriptor, target.targetVTI, index + 1, target.getDataDictionary());
            newResultCols.addResultColumn(newResultColumn);
        }
        return newResultCols;
    }

    private ResultColumn genNewRCForInsert(TableDescriptor targetTD, FromVTI targetVTI, int columnNumber, DataDictionary dataDictionary) throws StandardException {
        ResultColumn newResultColumn;
        if (targetVTI != null) {
            newResultColumn = targetVTI.getResultColumns().getResultColumn(columnNumber);
            newResultColumn = newResultColumn.cloneMe();
            newResultColumn.setExpressionToNullNode();
        } else {
            ColumnDescriptor colDesc = targetTD.getColumnDescriptor(columnNumber);
            DataTypeDescriptor colType = colDesc.getType();
            DefaultInfoImpl defaultInfo = (DefaultInfoImpl)colDesc.getDefaultInfo();
            if (defaultInfo != null && !colDesc.isAutoincrement()) {
                if (colDesc.hasGenerationClause()) {
                    newResultColumn = this.createGeneratedColumn(targetTD, colDesc);
                } else {
                    String defaultText = defaultInfo.getDefaultText();
                    ValueNode defaultTree = this.parseDefault(defaultText);
                    defaultTree = defaultTree.bindExpression(this.getFromList(), null, null);
                    newResultColumn = new ResultColumn(defaultTree.getTypeServices(), defaultTree, this.getContextManager());
                }
                DefaultDescriptor defaultDescriptor = colDesc.getDefaultDescriptor(dataDictionary);
                SanityManager.ASSERT((defaultDescriptor != null ? 1 : 0) != 0, (String)"defaultDescriptor expected to be non-null");
                this.getCompilerContext().createDependency(defaultDescriptor);
            } else if (colDesc.isAutoincrement()) {
                newResultColumn = new ResultColumn(colDesc, null, this.getContextManager());
                newResultColumn.setAutoincrementGenerated();
            } else {
                newResultColumn = new ResultColumn(colType, (ValueNode)this.getNullNode(colType), this.getContextManager());
            }
        }
        newResultColumn.markGeneratedForUnmatchedColumnInInsert();
        return newResultColumn;
    }

    private ResultSetNode generateProjectRestrictForInsert(InsertNode target, int[] colMap) throws StandardException {
        ResultColumnList newResultCols = new ResultColumnList(this.getContextManager());
        int numTargetColumns = target.resultColumnList.size();
        for (int index = 0; index < numTargetColumns; ++index) {
            ResultColumn newResultColumn;
            if (colMap[index] != -1) {
                ResultColumn oldResultColumn = this.resultColumns.getResultColumn(colMap[index] + 1);
                ColumnReference newColumnReference = new ColumnReference(oldResultColumn.getName(), null, this.getContextManager());
                DataTypeDescriptor dtd = oldResultColumn.getType();
                if (dtd == null) {
                    ColumnDescriptor cd = target.targetTableDescriptor.getColumnDescriptor(index + 1);
                    dtd = cd.getType();
                }
                newColumnReference.setSource(oldResultColumn);
                newColumnReference.setType(dtd);
                newColumnReference.setNestingLevel(0);
                newColumnReference.setSourceLevel(0);
                newResultColumn = new ResultColumn(dtd, (ValueNode)newColumnReference, this.getContextManager());
            } else {
                newResultColumn = this.genNewRCForInsert(target.targetTableDescriptor, target.targetVTI, index + 1, target.getDataDictionary());
            }
            newResultCols.addResultColumn(newResultColumn);
        }
        return new ProjectRestrictNode(this, newResultCols, null, null, null, null, null, this.getContextManager());
    }

    private ResultColumn createGeneratedColumn(TableDescriptor targetTD, ColumnDescriptor colDesc) throws StandardException {
        UntypedNullConstantNode dummy = new UntypedNullConstantNode(this.getContextManager());
        ResultColumn newResultColumn = new ResultColumn(colDesc.getType(), (ValueNode)dummy, this.getContextManager());
        newResultColumn.setColumnDescriptor(targetTD, colDesc);
        return newResultColumn;
    }

    public ValueNode parseDefault(String defaultText) throws StandardException {
        CursorNode cn;
        LanguageConnectionContext lcc = this.getLanguageConnectionContext();
        String values = "VALUES " + defaultText;
        CompilerContext newCC = lcc.pushCompilerContext();
        Parser p = newCC.getParser();
        Visitable qt = p.parseStatement(values);
        if (!(qt instanceof CursorNode)) {
            SanityManager.THROWASSERT((String)("qt expected to be instanceof CursorNode, not " + qt.getClass().getName()));
        }
        if (!((cn = (CursorNode)qt).getResultSetNode() instanceof RowResultSetNode)) {
            SanityManager.THROWASSERT((String)("cn.getResultSetNode() expected to be instanceof RowResultSetNode, not " + cn.getResultSetNode().getClass().getName()));
        }
        ValueNode defaultTree = ((ResultColumn)((CursorNode)qt).getResultSetNode().getResultColumns().elementAt(0)).getExpression();
        lcc.popCompilerContext(newCC);
        return defaultTree;
    }

    public ResultDescription makeResultDescription() {
        ResultColumnDescriptor[] colDescs = this.makeResultDescriptors();
        return this.getExecutionFactory().getResultDescription(colDescs, null);
    }

    boolean isUpdatableCursor(DataDictionary dd) throws StandardException {
        SanityManager.DEBUG((String)"DumpUpdateCheck", (String)"cursor is not a select result set");
        return false;
    }

    FromTable getCursorTargetTable() {
        return null;
    }

    boolean markAsCursorTargetTable() {
        return false;
    }

    void notCursorTargetTable() {
        this.cursorTargetTable = false;
    }

    ResultSetNode genProjectRestrict() throws StandardException {
        ResultColumnList prRCList = this.resultColumns;
        this.resultColumns = this.resultColumns.copyListAndObjects();
        prRCList.genVirtualColumnNodes(this, this.resultColumns);
        return new ProjectRestrictNode(this, prRCList, null, null, null, null, null, this.getContextManager());
    }

    ResultSetNode genProjectRestrict(int numTables) throws StandardException {
        return this.genProjectRestrict();
    }

    void generateNormalizationResultSet(ActivationClassBuilder acb, MethodBuilder mb, int resultSetNumber, ResultDescription resultDescription) throws StandardException {
        int erdNumber = acb.addItem(resultDescription);
        mb.push(resultSetNumber);
        mb.push(erdNumber);
        mb.push(this.getCostEstimate().rowCount());
        mb.push(this.getCostEstimate().getEstimatedCost());
        mb.push(false);
        mb.callMethod((short)185, null, "getNormalizeResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 6);
    }

    ResultSetNode changeAccessPath() throws StandardException {
        return this;
    }

    boolean referencesTarget(String name, boolean baseTable) throws StandardException {
        return false;
    }

    boolean subqueryReferencesTarget(String name, boolean baseTable) throws StandardException {
        return false;
    }

    boolean isOneRowResultSet() throws StandardException {
        return false;
    }

    boolean isNotExists() {
        return false;
    }

    protected OptimizerImpl getOptimizerImpl() {
        return (OptimizerImpl)this.optimizer;
    }

    Optimizer getOptimizer() {
        return this.optimizer;
    }

    void setOptimizer(Optimizer opt) {
        this.optimizer = opt;
    }

    protected CostEstimate getNewCostEstimate() throws StandardException {
        OptimizerFactory optimizerFactory = this.getLanguageConnectionContext().getOptimizerFactory();
        return optimizerFactory.getCostEstimate();
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.resultColumns != null) {
            this.resultColumns = (ResultColumnList)this.resultColumns.accept(v);
        }
    }

    ResultSetNode considerMaterialization(JBitSet outerTables) throws StandardException {
        return this;
    }

    boolean performMaterialization(JBitSet outerTables) throws StandardException {
        return false;
    }

    FromTable getFromTableByName(String name, String schemaName, boolean exactMatch) throws StandardException {
        SanityManager.THROWASSERT((String)("getFromTableByName() not expected to be called for " + this.getClass().getName()));
        return null;
    }

    abstract void decrementLevel(int var1);

    void pushOrderByList(OrderByList orderByList) {
        SanityManager.THROWASSERT((String)("pushOrderByList() not expected to be called for " + this.getClass().getName()));
    }

    void pushOffsetFetchFirst(ValueNode offset, ValueNode fetchFirst, boolean hasJDBClimitClause) {
        SanityManager.THROWASSERT((String)("pushOffsetFetchFirst() not expected to be called for " + this.getClass().getName()));
    }

    void generateResultSet(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        SanityManager.THROWASSERT((String)("generateResultSet() not expected to be called for " + this.getClass().getName()));
    }

    int updateTargetLockMode() {
        return 7;
    }

    void notFlattenableJoin() {
    }

    boolean isOrderedOn(ColumnReference[] crs, boolean permuteOrdering, List<FromBaseTable> fbtHolder) throws StandardException {
        return false;
    }

    boolean returnsAtMostOneRow() {
        return false;
    }

    void replaceOrForbidDefaults(TableDescriptor ttd, ResultColumnList tcl, boolean allowDefaults) throws StandardException {
        SanityManager.THROWASSERT((String)("replaceOrForbidDefaults() not expected to be called for " + this.getClass().getName()));
    }

    boolean isPossibleDistinctScan(Set<BaseColumnNode> distinctColumns) {
        return false;
    }

    void markForDistinctScan() {
        SanityManager.THROWASSERT((String)("markForDistinctScan() not expected to be called for " + this.getClass().getName()));
    }

    void adjustForSortElimination() {
        SanityManager.THROWASSERT((String)("adjustForSortElimination() not expected to be called for " + this.getClass().getName()));
    }

    void adjustForSortElimination(RequiredRowOrdering rowOrdering) throws StandardException {
        this.adjustForSortElimination();
    }

    static int numDistinctAggregates(List<AggregateNode> aggregates) {
        int count = 0;
        int size = aggregates.size();
        for (int index = 0; index < size; ++index) {
            if (!aggregates.get(index).isDistinct()) continue;
            ++count;
        }
        return count;
    }

    JBitSet LOJgetReferencedTables(int numTables) throws StandardException {
        if (this instanceof FromTable && ((FromTable)this).tableNumber != -1) {
            JBitSet map = new JBitSet(numTables);
            map.set(((FromTable)this).tableNumber);
            return map;
        }
        return null;
    }

    void pushQueryExpressionSuffix() {
        SanityManager.NOTREACHED();
    }

    void printQueryExpressionSuffixClauses(int depth, QueryExpressionClauses qec) {
        for (int i = 0; i < qec.size(); ++i) {
            Boolean hasJDBCLimitClause;
            ValueNode fetchFirst;
            ValueNode offset;
            OrderByList obl = qec.getOrderByList(i);
            if (obl != null) {
                this.printLabel(depth, "orderByLists[" + i + "]:");
                obl.treePrint(depth + 1);
            }
            if ((offset = qec.getOffset(i)) != null) {
                this.printLabel(depth, "offset:");
                offset.treePrint(depth + 1);
            }
            if ((fetchFirst = qec.getFetchFirst(i)) != null) {
                this.printLabel(depth, "fetch first/next:");
                fetchFirst.treePrint(depth + 1);
            }
            if ((hasJDBCLimitClause = qec.getHasJDBCLimitClause()[i]) == null) continue;
            this.printLabel(depth, "hasJDBCLimitClause:" + hasJDBCLimitClause + "\n");
        }
    }

    static class QueryExpressionClauses {
        private final List<OrderByList> obl = new ArrayList<OrderByList>();
        private final List<ValueNode> offset = new ArrayList<ValueNode>();
        private final List<ValueNode> fetchFirst = new ArrayList<ValueNode>();
        private final List<Boolean> hasJDBCLimitClause = new ArrayList<Boolean>();

        public QueryExpressionClauses() {
            this.push();
        }

        int size() {
            return this.obl.size();
        }

        void push() {
            int s = this.size();
            if (s > 0 && this.obl.get(s - 1) == null && this.offset.get(s - 1) == null && this.fetchFirst.get(s - 1) == null) {
                SanityManager.ASSERT((this.hasJDBCLimitClause.get(s - 1) == null ? 1 : 0) != 0);
            } else {
                this.obl.add(null);
                this.offset.add(null);
                this.fetchFirst.add(null);
                this.hasJDBCLimitClause.add(null);
            }
        }

        void setOrderByList(OrderByList obl) {
            this.obl.set(this.size() - 1, obl);
        }

        void setOffset(ValueNode v) {
            this.offset.set(this.size() - 1, v);
        }

        void setFetchFirst(ValueNode v) {
            this.fetchFirst.set(this.size() - 1, v);
        }

        void setHasJDBCLimitClause(Boolean b) {
            this.hasJDBCLimitClause.set(this.size() - 1, b);
        }

        OrderByList getOrderByList(int i) {
            return this.obl.get(i);
        }

        void setOrderByList(int i, OrderByList obl) {
            this.obl.set(i, obl);
        }

        ValueNode getOffset(int i) {
            return this.offset.get(i);
        }

        void setOffset(int i, ValueNode v) {
            this.offset.set(i, v);
        }

        ValueNode getFetchFirst(int i) {
            return this.fetchFirst.get(i);
        }

        void setFetchFirst(int i, ValueNode v) {
            this.fetchFirst.set(i, v);
        }

        Boolean[] getHasJDBCLimitClause() {
            return this.hasJDBCLimitClause.toArray(new Boolean[1]);
        }

        boolean hasOffsetFetchFirst() {
            for (ValueNode o : this.offset) {
                if (o == null) continue;
                return true;
            }
            for (ValueNode ff : this.fetchFirst) {
                if (ff == null) continue;
                return true;
            }
            return false;
        }
    }
}

