/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.configuration.filters;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Filter;
import java.util.logging.Level;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.filters.AcceptAllFilter;
import org.jboss.logmanager.filters.AllFilter;
import org.jboss.logmanager.filters.AnyFilter;
import org.jboss.logmanager.filters.DenyAllFilter;
import org.jboss.logmanager.filters.InvertFilter;
import org.jboss.logmanager.filters.LevelChangingFilter;
import org.jboss.logmanager.filters.LevelFilter;
import org.jboss.logmanager.filters.LevelRangeFilter;
import org.jboss.logmanager.filters.RegexFilter;
import org.jboss.logmanager.filters.SubstituteFilter;

public class FilterExpressions {
    private static final String ACCEPT = "accept";
    private static final String ALL = "all";
    private static final String ANY = "any";
    private static final String DENY = "deny";
    private static final String LEVELS = "levels";
    private static final String LEVEL_CHANGE = "levelChange";
    private static final String LEVEL_RANGE = "levelRange";
    private static final String MATCH = "match";
    private static final String NOT = "not";
    private static final String SUBSTITUTE = "substitute";
    private static final String SUBSTITUTE_ALL = "substituteAll";

    public static Filter parse(LogContext logContext, String expression) {
        Iterator<String> iterator = FilterExpressions.tokens(expression).iterator();
        return FilterExpressions.parseFilterExpression(logContext, iterator, true);
    }

    private static Filter parseFilterExpression(LogContext logContext, Iterator<String> iterator, boolean outermost) {
        if (!iterator.hasNext()) {
            if (outermost) {
                return null;
            }
            throw FilterExpressions.endOfExpression();
        }
        String token = iterator.next();
        if (ACCEPT.equals(token)) {
            return AcceptAllFilter.getInstance();
        }
        if (DENY.equals(token)) {
            return DenyAllFilter.getInstance();
        }
        if (NOT.equals(token)) {
            FilterExpressions.expect("(", iterator);
            Filter nested = FilterExpressions.parseFilterExpression(logContext, iterator, false);
            FilterExpressions.expect(")", iterator);
            return new InvertFilter(nested);
        }
        if (ALL.equals(token)) {
            FilterExpressions.expect("(", iterator);
            ArrayList<Filter> filters = new ArrayList<Filter>();
            do {
                filters.add(FilterExpressions.parseFilterExpression(logContext, iterator, false));
            } while (FilterExpressions.expect(",", ")", iterator));
            return new AllFilter(filters);
        }
        if (ANY.equals(token)) {
            FilterExpressions.expect("(", iterator);
            ArrayList<Filter> filters = new ArrayList<Filter>();
            do {
                filters.add(FilterExpressions.parseFilterExpression(logContext, iterator, false));
            } while (FilterExpressions.expect(",", ")", iterator));
            return new AnyFilter(filters);
        }
        if (LEVEL_CHANGE.equals(token)) {
            FilterExpressions.expect("(", iterator);
            Level level = logContext.getLevelForName(FilterExpressions.expectName(iterator));
            FilterExpressions.expect(")", iterator);
            return new LevelChangingFilter(level);
        }
        if (LEVELS.equals(token)) {
            FilterExpressions.expect("(", iterator);
            HashSet<Level> levels = new HashSet<Level>();
            do {
                levels.add(logContext.getLevelForName(FilterExpressions.expectName(iterator)));
            } while (FilterExpressions.expect(",", ")", iterator));
            return new LevelFilter(levels);
        }
        if (LEVEL_RANGE.equals(token)) {
            boolean minInclusive = FilterExpressions.expect("[", "(", iterator);
            Level minLevel = logContext.getLevelForName(FilterExpressions.expectName(iterator));
            FilterExpressions.expect(",", iterator);
            Level maxLevel = logContext.getLevelForName(FilterExpressions.expectName(iterator));
            boolean maxInclusive = FilterExpressions.expect("]", ")", iterator);
            return new LevelRangeFilter(minLevel, minInclusive, maxLevel, maxInclusive);
        }
        if (MATCH.equals(token)) {
            FilterExpressions.expect("(", iterator);
            String pattern = FilterExpressions.expectString(iterator);
            FilterExpressions.expect(")", iterator);
            return new RegexFilter(pattern);
        }
        if (SUBSTITUTE.equals(token)) {
            FilterExpressions.expect("(", iterator);
            String pattern = FilterExpressions.expectString(iterator);
            FilterExpressions.expect(",", iterator);
            String replacement = FilterExpressions.expectString(iterator);
            FilterExpressions.expect(")", iterator);
            return new SubstituteFilter(pattern, replacement, false);
        }
        if (SUBSTITUTE_ALL.equals(token)) {
            FilterExpressions.expect("(", iterator);
            String pattern = FilterExpressions.expectString(iterator);
            FilterExpressions.expect(",", iterator);
            String replacement = FilterExpressions.expectString(iterator);
            FilterExpressions.expect(")", iterator);
            return new SubstituteFilter(pattern, replacement, true);
        }
        String name = FilterExpressions.expectName(iterator);
        throw new IllegalArgumentException(String.format("No filter named \"%s\" is defined", name));
    }

    private static String expectName(Iterator<String> iterator) {
        String next;
        if (iterator.hasNext() && Character.isJavaIdentifierStart((next = iterator.next()).codePointAt(0))) {
            return next;
        }
        throw new IllegalArgumentException("Expected identifier next in filter expression");
    }

    private static String expectString(Iterator<String> iterator) {
        String next;
        if (iterator.hasNext() && (next = iterator.next()).codePointAt(0) == 34) {
            return next.substring(1);
        }
        throw new IllegalArgumentException("Expected string next in filter expression");
    }

    private static boolean expect(String trueToken, String falseToken, Iterator<String> iterator) {
        boolean result;
        String next;
        boolean hasNext = iterator.hasNext();
        String string = next = hasNext ? iterator.next() : null;
        if (!hasNext || !(result = trueToken.equals(next)) && !falseToken.equals(next)) {
            throw new IllegalArgumentException("Expected '" + trueToken + "' or '" + falseToken + "' next in filter expression");
        }
        return result;
    }

    private static void expect(String token, Iterator<String> iterator) {
        if (!iterator.hasNext() || !token.equals(iterator.next())) {
            throw new IllegalArgumentException("Expected '" + token + "' next in filter expression");
        }
    }

    private static IllegalArgumentException endOfExpression() {
        return new IllegalArgumentException("Unexpected end of filter expression");
    }

    private static List<String> tokens(String source) {
        ArrayList<String> tokens = new ArrayList<String>();
        int length = source.length();
        int idx = 0;
        while (idx < length) {
            int start;
            block16: {
                int ch = source.codePointAt(idx);
                if (Character.isWhitespace(ch)) {
                    ch = source.codePointAt(idx);
                    idx = source.offsetByCodePoints(idx, 1);
                    continue;
                }
                if (Character.isJavaIdentifierStart(ch)) {
                    start = idx;
                    while ((idx = source.offsetByCodePoints(idx, 1)) < length && Character.isJavaIdentifierPart(ch = source.codePointAt(idx))) {
                    }
                    tokens.add(source.substring(start, idx));
                    continue;
                }
                if (ch != 34) break block16;
                StringBuilder b = new StringBuilder();
                b.append('\"');
                idx = source.offsetByCodePoints(idx, 1);
                while (idx < length && (ch = source.codePointAt(idx)) != 34) {
                    block18: {
                        block17: {
                            ch = source.codePointAt(idx);
                            if (ch != 92) break block17;
                            if ((idx = source.offsetByCodePoints(idx, 1)) == length) {
                                throw new IllegalArgumentException("Truncated filter expression string");
                            }
                            ch = source.codePointAt(idx);
                            switch (ch) {
                                case 92: {
                                    b.append('\\');
                                    break block18;
                                }
                                case 39: {
                                    b.append('\'');
                                    break block18;
                                }
                                case 34: {
                                    b.append('\"');
                                    break block18;
                                }
                                case 98: {
                                    b.append('\b');
                                    break block18;
                                }
                                case 102: {
                                    b.append('\f');
                                    break block18;
                                }
                                case 110: {
                                    b.append('\n');
                                    break block18;
                                }
                                case 114: {
                                    b.append('\r');
                                    break block18;
                                }
                                case 116: {
                                    b.append('\t');
                                    break block18;
                                }
                                default: {
                                    throw new IllegalArgumentException("Invalid escape found in filter expression string");
                                }
                            }
                        }
                        b.appendCodePoint(ch);
                    }
                    idx = source.offsetByCodePoints(idx, 1);
                }
                idx = source.offsetByCodePoints(idx, 1);
                tokens.add(b.toString());
                continue;
            }
            start = idx;
            idx = source.offsetByCodePoints(idx, 1);
            tokens.add(source.substring(start, idx));
        }
        return tokens;
    }
}

