/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.message.header;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jupnp.model.message.header.InvalidHeaderException;
import org.jupnp.model.message.header.UpnpHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallbackHeader
extends UpnpHeader<List<URL>> {
    private final Logger logger = LoggerFactory.getLogger(CallbackHeader.class);

    public CallbackHeader() {
        this.setValue(new ArrayList());
    }

    public CallbackHeader(List<URL> urls) {
        this();
        ((List)this.getValue()).addAll(urls);
    }

    public CallbackHeader(URL url) {
        this();
        ((List)this.getValue()).add(url);
    }

    @Override
    public void setString(String s) throws InvalidHeaderException {
        if (s.isEmpty()) {
            return;
        }
        if (!s.contains("<") || !s.contains(">")) {
            throw new InvalidHeaderException("URLs not in brackets: " + s);
        }
        s = s.replaceAll("<", "");
        String[] split = s.split(">");
        try {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (String sp : split) {
                if (!(sp = sp.trim()).startsWith("http://")) {
                    this.logger.warn("Discarding non-http callback URL: {}", (Object)sp);
                    continue;
                }
                URL url = new URL(sp);
                try {
                    url.toURI();
                }
                catch (URISyntaxException e) {
                    this.logger.warn("Discarding callback URL, not a valid URI on this platform: {}", (Object)url, (Object)e);
                    continue;
                }
                urls.add(url);
            }
            this.setValue(urls);
        }
        catch (MalformedURLException e) {
            throw new InvalidHeaderException("Can't parse callback URLs from '" + s + "'", e);
        }
    }

    @Override
    public String getString() {
        StringBuilder s = new StringBuilder();
        for (URL url : (List)this.getValue()) {
            s.append("<").append(url.toString()).append(">");
        }
        return s.toString();
    }
}

