/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.deployment.BeanDiscoveryFinishedBuildItem;
import io.quarkus.arc.deployment.ReflectiveBeanClassBuildItem;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.runtime.annotations.RegisterForReflection;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

public class ReflectiveBeanClassesProcessor {
    @BuildStep
    void implicitReflectiveBeanClasses(BuildProducer<ReflectiveBeanClassBuildItem> reflectiveBeanClasses, BeanDiscoveryFinishedBuildItem beanDiscoveryFinished) {
        DotName registerForReflection = DotName.createSimple((String)RegisterForReflection.class.getName());
        for (BeanInfo classBean : beanDiscoveryFinished.beanStream().classBeans()) {
            String[] classNames;
            ClassInfo beanClass = ((AnnotationTarget)classBean.getTarget().get()).asClass();
            AnnotationInstance annotation = beanClass.declaredAnnotation(registerForReflection);
            if (annotation == null) continue;
            Type[] targets = annotation.value("targets") != null ? annotation.value("targets").asClassArray() : new Type[]{};
            String[] stringArray = classNames = annotation.value("classNames") != null ? annotation.value("classNames").asStringArray() : new String[]{};
            if (targets.length != 0 || classNames.length != 0) continue;
            reflectiveBeanClasses.produce((BuildItem)new ReflectiveBeanClassBuildItem(beanClass));
        }
    }
}

