/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.xml;

import brut.util.Duo;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public final class ResXmlEncoders {
    public static String escapeXmlChars(String str) {
        return StringUtils.replace(StringUtils.replace(str, "&", "&amp;"), "<", "&lt;");
    }

    public static String encodeAsResXmlAttr(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        char[] chars = str.toCharArray();
        StringBuilder out = new StringBuilder(str.length() + 10);
        switch (chars[0]) {
            case '#': 
            case '?': 
            case '@': {
                out.append('\\');
            }
        }
        block8: for (char c : chars) {
            switch (c) {
                case '\\': {
                    out.append('\\');
                    break;
                }
                case '\"': {
                    out.append("&quot;");
                    continue block8;
                }
                case '\n': {
                    out.append("\\n");
                    continue block8;
                }
                default: {
                    if (ResXmlEncoders.isPrintableChar(c)) break;
                    out.append(String.format("\\u%04x", c));
                    continue block8;
                }
            }
            out.append(c);
        }
        return out.toString();
    }

    public static String encodeAsXmlValue(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        char[] chars = str.toCharArray();
        StringBuilder out = new StringBuilder(str.length() + 10);
        switch (chars[0]) {
            case '#': 
            case '?': 
            case '@': {
                out.append('\\');
            }
        }
        boolean isInStyleTag = false;
        int startPos = 0;
        boolean enclose = false;
        boolean wasSpace = true;
        block8: for (char c : chars) {
            if (isInStyleTag) {
                if (c == '>') {
                    isInStyleTag = false;
                    startPos = out.length() + 1;
                    enclose = false;
                }
            } else if (c == ' ') {
                if (wasSpace) {
                    enclose = true;
                }
                wasSpace = true;
            } else {
                wasSpace = false;
                switch (c) {
                    case '\"': 
                    case '\\': {
                        out.append('\\');
                        break;
                    }
                    case '\n': 
                    case '\'': {
                        enclose = true;
                        break;
                    }
                    case '<': {
                        isInStyleTag = true;
                        if (!enclose) break;
                        out.insert(startPos, '\"').append('\"');
                        break;
                    }
                    default: {
                        if (ResXmlEncoders.isPrintableChar(c)) break;
                        if (out.length() + 1 == str.length() && c == '\u0000') continue block8;
                        out.append(String.format("\\u%04x", c));
                        continue block8;
                    }
                }
            }
            out.append(c);
        }
        if (enclose || wasSpace) {
            out.insert(startPos, '\"').append('\"');
        }
        return out.toString();
    }

    public static boolean hasMultipleNonPositionalSubstitutions(String str) {
        Duo<List<Integer>, List<Integer>> tuple = ResXmlEncoders.findSubstitutions(str, 4);
        return !((List)tuple.m1).isEmpty() && ((List)tuple.m1).size() + ((List)tuple.m2).size() > 1;
    }

    public static String enumerateNonPositionalSubstitutionsIfRequired(String str) {
        Duo<List<Integer>, List<Integer>> tuple = ResXmlEncoders.findSubstitutions(str, 4);
        if (((List)tuple.m1).isEmpty() || ((List)tuple.m1).size() + ((List)tuple.m2).size() < 2) {
            return str;
        }
        List subs = (List)tuple.m1;
        StringBuilder out = new StringBuilder();
        int pos = 0;
        int count = 0;
        for (Integer sub : subs) {
            sub = sub + 1;
            out.append(str, pos, (int)sub).append(++count).append('$');
            pos = sub;
        }
        out.append(str.substring(pos));
        return out.toString();
    }

    private static Duo<List<Integer>, List<Integer>> findSubstitutions(String str, int nonPosMax) {
        int pos;
        if (nonPosMax == -1) {
            nonPosMax = Integer.MAX_VALUE;
        }
        int pos2 = 0;
        ArrayList<Integer> nonPositional = new ArrayList<Integer>();
        ArrayList<Integer> positional = new ArrayList<Integer>();
        if (str == null) {
            return new Duo<List<Integer>, List<Integer>>(nonPositional, positional);
        }
        int length = str.length();
        while ((pos = str.indexOf(37, pos2)) != -1) {
            char c;
            pos2 = pos + 1;
            if (pos2 == length) {
                nonPositional.add(pos);
                break;
            }
            if ((c = str.charAt(pos2++)) == '%') continue;
            if (c >= '0' && c <= '9' && pos2 < length) {
                while ((c = str.charAt(pos2++)) >= '0' && c <= '9' && pos2 < length) {
                }
                if (c == '$') {
                    positional.add(pos);
                    continue;
                }
            }
            nonPositional.add(pos);
            if (nonPositional.size() < nonPosMax) continue;
            break;
        }
        return new Duo<List<Integer>, List<Integer>>(nonPositional, positional);
    }

    private static boolean isPrintableChar(char c) {
        Character.UnicodeBlock block = Character.UnicodeBlock.of(c);
        return !Character.isISOControl(c) && c != '\uffff' && block != null && block != Character.UnicodeBlock.SPECIALS;
    }
}

