/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.util;

import java.net.URI;
import java.net.URISyntaxException;

public class UriNormalizationUtil {
    private UriNormalizationUtil() {
    }

    public static URI toURI(String path, boolean trailingSlash) {
        try {
            path = path.replaceAll("//", "/");
            if (!trailingSlash && path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            if (path.contains("..") || path.contains("%")) {
                throw new IllegalArgumentException("Specified path can not contain '..' or '%'. Path was " + path);
            }
            URI uri = new URI(path).normalize();
            if (uri.getPath().equals("")) {
                return trailingSlash ? new URI("/") : new URI("");
            }
            if (trailingSlash && !path.endsWith("/")) {
                uri = new URI(uri.getPath() + "/");
            }
            return uri;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Specified path is an invalid URI. Path was " + path, e);
        }
    }

    public static URI normalizeWithBase(URI base, String segment, boolean trailingSlash) {
        if (segment == null || segment.trim().isEmpty()) {
            if ("/".equals(base.getPath())) {
                return base;
            }
            return UriNormalizationUtil.toURI(base.getPath(), trailingSlash);
        }
        URI segmentUri = UriNormalizationUtil.toURI(segment, trailingSlash);
        URI resolvedUri = base.resolve(segmentUri);
        return resolvedUri;
    }

    public static String relativize(String rootPath, String leafPath) {
        if (leafPath.startsWith(rootPath)) {
            return leafPath.substring(rootPath.length());
        }
        return null;
    }
}

