/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.v1;

import java.io.Serializable;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class Paging
implements Serializable {
    private static final long serialVersionUID = -7226113618341047983L;
    public final int page;
    public final int count;
    public final long sinceId;
    public final long maxId;

    @NotNull
    public static Paging ofPage(int page) {
        if (page < 1) {
            throw new IllegalArgumentException("page should be positive integer. passed:" + page);
        }
        return new Paging(page, -1, -1L, -1L);
    }

    @NotNull
    public Paging withPage(int page) {
        if (page < 1) {
            throw new IllegalArgumentException("page should be positive integer. passed:" + page);
        }
        return new Paging(page, this.count, this.sinceId, this.maxId);
    }

    @NotNull
    public static Paging ofCount(int count) {
        if (count < 1) {
            throw new IllegalArgumentException("count should be positive integer. passed:" + count);
        }
        return new Paging(-1, count, -1L, -1L);
    }

    @NotNull
    public Paging count(int count) {
        if (count < 1) {
            throw new IllegalArgumentException("count should be positive integer. passed:" + count);
        }
        return new Paging(this.page, count, this.sinceId, this.maxId);
    }

    @NotNull
    public static Paging ofSinceId(long sinceId) {
        if (sinceId < 1L) {
            throw new IllegalArgumentException("since_id should be positive integer. passed:" + sinceId);
        }
        return new Paging(-1, -1, sinceId, -1L);
    }

    @NotNull
    public Paging sinceId(long sinceId) {
        if (sinceId < 1L) {
            throw new IllegalArgumentException("since_id should be positive integer. passed:" + sinceId);
        }
        return new Paging(this.page, this.count, sinceId, this.maxId);
    }

    @NotNull
    public static Paging ofMaxId(long maxId) {
        if (maxId < 1L) {
            throw new IllegalArgumentException("max_id should be positive integer. passed:" + maxId);
        }
        return new Paging(-1, -1, -1L, maxId);
    }

    @NotNull
    public Paging maxId(long maxId) {
        if (maxId < 1L) {
            throw new IllegalArgumentException("max_id should be positive integer. passed:" + maxId);
        }
        return new Paging(this.page, this.count, this.sinceId, maxId);
    }

    private Paging(int page, int count, long sinceId, long maxId) {
        this.page = page;
        this.count = count;
        this.sinceId = sinceId;
        this.maxId = maxId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Paging paging = (Paging)o;
        return this.page == paging.page && this.count == paging.count && this.sinceId == paging.sinceId && this.maxId == paging.maxId;
    }

    public int hashCode() {
        return Objects.hash(this.page, this.count, this.sinceId, this.maxId);
    }

    public String toString() {
        return "Paging{page=" + this.page + ", count=" + this.count + ", sinceId=" + this.sinceId + ", maxId=" + this.maxId + '}';
    }
}

