/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.initializer;

import java.util.BitSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.jboss.logging.Logger;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;

@ProtoTypeId(value=65554)
public class InitializerState
extends SessionEntity {
    private static final Logger log = Logger.getLogger(InitializerState.class);
    private final int segmentsCount;
    private final BitSet segments;

    public InitializerState(int segmentsCount) {
        this.segmentsCount = segmentsCount;
        this.segments = new BitSet(segmentsCount);
        log.debugf("segmentsCount: %d", segmentsCount);
    }

    @ProtoFactory
    InitializerState(String realmId, int segmentsCount, BitSet segments) {
        super(realmId);
        this.segmentsCount = segmentsCount;
        this.segments = segments;
        log.debugf("segmentsCount: %d", segmentsCount);
    }

    @ProtoField(value=2)
    public int getSegmentsCount() {
        return this.segmentsCount;
    }

    @ProtoField(value=3)
    BitSet getSegments() {
        return this.segments;
    }

    public boolean isFinished() {
        return this.segments.cardinality() == this.segmentsCount;
    }

    public int getProgressIndicator() {
        return this.segments.hashCode();
    }

    public List<Integer> getSegmentsToLoad(int segmentToLoad, int maxSegmentCount) {
        LinkedList<Integer> result = new LinkedList<Integer>();
        for (int i = segmentToLoad; i < segmentToLoad + maxSegmentCount && i < this.segmentsCount; ++i) {
            if (this.segments.get(i)) continue;
            result.add(i);
        }
        return result;
    }

    public void markSegmentFinished(int index) {
        this.segments.set(index);
    }

    public String toString() {
        int finished = this.segments.cardinality();
        int nonFinished = this.segmentsCount - finished;
        return "finished segments count: " + finished + ", non-finished segments count: " + nonFinished;
    }

    @Override
    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + this.segmentsCount;
        hash = 97 * hash + Objects.hashCode(this.segments);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InitializerState other = (InitializerState)obj;
        return this.segmentsCount == other.segmentsCount && Objects.equals(this.segments, other.segments);
    }
}

