/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.authorization.stream;

import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.keycloak.models.cache.infinispan.authorization.entities.InResourceServer;
import org.keycloak.models.cache.infinispan.entities.Revisioned;

@ProtoTypeId(value=65560)
public class InResourceServerPredicate
implements Predicate<Map.Entry<String, Revisioned>> {
    private final String serverId;

    private InResourceServerPredicate(String serverId) {
        this.serverId = Objects.requireNonNull(serverId);
    }

    @ProtoFactory
    public static InResourceServerPredicate create(String serverId) {
        return new InResourceServerPredicate(serverId);
    }

    @ProtoField(value=1)
    String getServerId() {
        return this.serverId;
    }

    @Override
    public boolean test(Map.Entry<String, Revisioned> entry) {
        InResourceServer inResourceServer;
        Revisioned revisioned = entry.getValue();
        return revisioned instanceof InResourceServer && this.serverId.equals((inResourceServer = (InResourceServer)((Object)revisioned)).getResourceServerId());
    }
}

