/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.deployment;

import io.quarkus.builder.item.SimpleBuildItem;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Set;

public final class ThemeVarsBuildItem
extends SimpleBuildItem {
    private final Set<String> themeVars;
    private final String defaultValue;

    public ThemeVarsBuildItem(Set<String> themeVars, String defaultValue) {
        this.themeVars = themeVars;
        this.defaultValue = defaultValue;
    }

    public Set<String> getThemeVars() {
        return this.themeVars;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getTemplateValue() {
        String string;
        StringWriter sw = new StringWriter();
        try {
            for (String line : this.themeVars) {
                sw.write(line + ": " + this.defaultValue + ";");
                sw.write("\n");
            }
            string = sw.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    sw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        sw.close();
        return string;
    }
}

