/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.events.log;

import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.HttpHeaders;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.common.util.StackUtil;
import org.keycloak.events.Event;
import org.keycloak.events.EventListenerProvider;
import org.keycloak.events.EventListenerTransaction;
import org.keycloak.events.admin.AdminEvent;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.KeycloakUriInfo;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.utils.StringUtil;

public class JBossLoggingEventListenerProvider
implements EventListenerProvider {
    private final KeycloakSession session;
    private final Logger logger;
    private final Logger.Level successLevel;
    private final Logger.Level errorLevel;
    private final boolean sanitize;
    private final Character quotes;
    private final EventListenerTransaction tx = new EventListenerTransaction(this::logAdminEvent, this::logEvent);

    public JBossLoggingEventListenerProvider(KeycloakSession session, Logger logger2, Logger.Level successLevel, Logger.Level errorLevel, Character quotes, boolean sanitize) {
        this.session = session;
        this.logger = logger2;
        this.successLevel = successLevel;
        this.errorLevel = errorLevel;
        this.sanitize = sanitize;
        this.quotes = quotes;
        this.session.getTransactionManager().enlistAfterCompletion((KeycloakTransaction)this.tx);
    }

    public void onEvent(Event event) {
        this.tx.addEvent(event);
    }

    public void onEvent(AdminEvent adminEvent, boolean includeRepresentation) {
        this.tx.addAdminEvent(adminEvent, includeRepresentation);
    }

    private void sanitize(StringBuilder sb, String str) {
        if (this.quotes != null) {
            sb.append(this.quotes);
        }
        if (this.sanitize) {
            str = StringUtil.sanitizeSpacesAndQuotes((String)str, (Character)this.quotes);
        }
        sb.append(str);
        if (this.quotes != null) {
            sb.append(this.quotes);
        }
    }

    private void logEvent(Event event) {
        Logger.Level level;
        Logger.Level level2 = level = event.getError() != null ? this.errorLevel : this.successLevel;
        if (this.logger.isEnabled(level)) {
            AuthenticationSessionModel authSession;
            StringBuilder sb = new StringBuilder();
            sb.append("type=");
            this.sanitize(sb, event.getType().toString());
            sb.append(", realmId=");
            this.sanitize(sb, event.getRealmId());
            sb.append(", realmName=");
            this.sanitize(sb, event.getRealmName());
            sb.append(", clientId=");
            this.sanitize(sb, event.getClientId());
            sb.append(", userId=");
            this.sanitize(sb, event.getUserId());
            if (event.getSessionId() != null) {
                sb.append(", sessionId=");
                this.sanitize(sb, event.getSessionId());
            }
            sb.append(", ipAddress=");
            this.sanitize(sb, event.getIpAddress());
            if (event.getError() != null) {
                sb.append(", error=");
                this.sanitize(sb, event.getError());
            }
            if (event.getDetails() != null) {
                for (Map.Entry e : event.getDetails().entrySet()) {
                    sb.append(", ");
                    sb.append(StringUtil.sanitizeSpacesAndQuotes((String)((String)e.getKey()), null));
                    sb.append("=");
                    this.sanitize(sb, (String)e.getValue());
                }
            }
            if ((authSession = this.session.getContext().getAuthenticationSession()) != null) {
                sb.append(", authSessionParentId=");
                this.sanitize(sb, authSession.getParentSession().getId());
                sb.append(", authSessionTabId=");
                this.sanitize(sb, authSession.getTabId());
            }
            if (this.logger.isTraceEnabled()) {
                this.setKeycloakContext(sb);
                if (StackUtil.isShortStackTraceEnabled()) {
                    sb.append(", stackTrace=").append(StackUtil.getShortStackTrace());
                }
            }
            this.logger.log(this.logger.isTraceEnabled() ? Logger.Level.TRACE : level, (Object)sb.toString());
        }
    }

    private void logAdminEvent(AdminEvent adminEvent, boolean includeRepresentation) {
        Logger.Level level;
        Logger.Level level2 = level = adminEvent.getError() != null ? this.errorLevel : this.successLevel;
        if (this.logger.isEnabled(level)) {
            StringBuilder sb = new StringBuilder();
            sb.append("operationType=");
            this.sanitize(sb, adminEvent.getOperationType().toString());
            sb.append(", realmId=");
            this.sanitize(sb, adminEvent.getAuthDetails().getRealmId());
            sb.append(", realmName=");
            this.sanitize(sb, adminEvent.getAuthDetails().getRealmName());
            sb.append(", clientId=");
            this.sanitize(sb, adminEvent.getAuthDetails().getClientId());
            sb.append(", userId=");
            this.sanitize(sb, adminEvent.getAuthDetails().getUserId());
            sb.append(", ipAddress=");
            this.sanitize(sb, adminEvent.getAuthDetails().getIpAddress());
            sb.append(", resourceType=");
            this.sanitize(sb, adminEvent.getResourceTypeAsString());
            sb.append(", resourcePath=");
            this.sanitize(sb, adminEvent.getResourcePath());
            if (adminEvent.getError() != null) {
                sb.append(", error=");
                this.sanitize(sb, adminEvent.getError());
            }
            if (adminEvent.getDetails() != null) {
                for (Map.Entry e : adminEvent.getDetails().entrySet()) {
                    sb.append(", ");
                    sb.append(StringUtil.sanitizeSpacesAndQuotes((String)((String)e.getKey()), null));
                    sb.append("=");
                    this.sanitize(sb, (String)e.getValue());
                }
            }
            if (this.logger.isTraceEnabled()) {
                this.setKeycloakContext(sb);
            }
            this.logger.log(this.logger.isTraceEnabled() ? Logger.Level.TRACE : level, (Object)sb.toString());
        }
    }

    public void close() {
    }

    private void setKeycloakContext(StringBuilder sb) {
        KeycloakContext context = this.session.getContext();
        KeycloakUriInfo uriInfo = context.getUri();
        HttpHeaders headers = context.getRequestHeaders();
        if (uriInfo != null) {
            sb.append(", requestUri=");
            this.sanitize(sb, uriInfo.getRequestUri().toString());
        }
        if (headers != null) {
            sb.append(", cookies=[");
            boolean f = true;
            for (Map.Entry e : headers.getCookies().entrySet()) {
                if (f) {
                    f = false;
                } else {
                    sb.append(", ");
                }
                sb.append(StringUtil.sanitizeSpacesAndQuotes((String)((Cookie)e.getValue()).toString(), null));
            }
            sb.append("]");
        }
    }
}

