/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.forms;

import jakarta.ws.rs.core.MultivaluedMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.authentication.FormAction;
import org.keycloak.authentication.FormActionFactory;
import org.keycloak.authentication.FormContext;
import org.keycloak.authentication.ValidationContext;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.services.validation.Validation;
import org.keycloak.utils.StringUtil;

public abstract class AbstractRegistrationRecaptcha
implements FormAction,
FormActionFactory {
    public static final String G_RECAPTCHA_RESPONSE = "g-recaptcha-response";
    public static final String RECAPTCHA_REFERENCE_CATEGORY = "recaptcha";
    public static final String SITE_KEY = "site.key";
    public static final String ACTION = "action";
    public static final String INVISIBLE = "recaptcha.v3";
    public static final String USE_RECAPTCHA_NET = "useRecaptchaNet";
    private static final Logger LOGGER = Logger.getLogger(AbstractRegistrationRecaptcha.class);

    public String getReferenceCategory() {
        return RECAPTCHA_REFERENCE_CATEGORY;
    }

    public boolean isConfigurable() {
        return true;
    }

    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return new AuthenticationExecutionModel.Requirement[]{AuthenticationExecutionModel.Requirement.REQUIRED, AuthenticationExecutionModel.Requirement.DISABLED};
    }

    protected String getRecaptchaDomain(Map<String, String> config) {
        return Boolean.parseBoolean(config.get(USE_RECAPTCHA_NET)) ? "recaptcha.net" : "google.com";
    }

    public void buildPage(FormContext context, LoginFormsProvider form) {
        LOGGER.trace((Object)"Building page with reCAPTCHA");
        Map config = context.getAuthenticatorConfig().getConfig();
        if (config == null) {
            form.addError(new FormMessage(null, "recaptchaNotConfigured"));
            return;
        }
        if (!this.validateConfig(config)) {
            form.addError(new FormMessage(null, "recaptchaNotConfigured"));
            return;
        }
        String userLanguageTag = context.getSession().getContext().resolveLocale(context.getUser()).toLanguageTag();
        boolean invisible = Boolean.parseBoolean((String)config.get(INVISIBLE));
        String action = StringUtil.isNullOrEmpty((String)((String)config.get(ACTION))) ? "register" : (String)config.get(ACTION);
        form.setAttribute("recaptchaRequired", (Object)true);
        form.setAttribute("recaptchaSiteKey", config.get(SITE_KEY));
        form.setAttribute("recaptchaAction", (Object)action);
        form.setAttribute("recaptchaVisible", (Object)(!invisible ? 1 : 0));
        form.addScript(this.getScriptUrl(config, userLanguageTag));
    }

    protected abstract String getScriptUrl(Map<String, String> var1, String var2);

    protected abstract boolean validateConfig(Map<String, String> var1);

    public void validate(ValidationContext context) {
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        String captcha = (String)formData.getFirst((Object)G_RECAPTCHA_RESPONSE);
        LOGGER.trace((Object)("Got captcha: " + captcha));
        Map config = context.getAuthenticatorConfig().getConfig();
        if (!Validation.isBlank(captcha) && this.validate(context, captcha, config)) {
            context.success();
            return;
        }
        ArrayList<FormMessage> errors = new ArrayList<FormMessage>();
        errors.add(new FormMessage(null, "recaptchaFailed"));
        formData.remove((Object)G_RECAPTCHA_RESPONSE);
        context.error("invalid_registration");
        context.validationError(formData, errors);
        context.excludeOtherErrors();
    }

    protected abstract boolean validate(ValidationContext var1, String var2, Map<String, String> var3);

    public void success(FormContext context) {
    }

    public boolean requiresUser() {
        return false;
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return true;
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
    }

    public boolean isUserSetupAllowed() {
        return false;
    }

    public void close() {
    }

    public FormAction create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return ProviderConfigurationBuilder.create().property().name(ACTION).label("Action Name").helpText("A meaningful name for this reCAPTCHA context (e.g. login, register). An action name can only contain alphanumeric characters, slashes and underscores and is not case-sensitive.").type("String").defaultValue((Object)"register").add().property().name(USE_RECAPTCHA_NET).label("Use recaptcha.net").helpText("Whether to use recaptcha.net instead of google.com, which may have other cookies set.").type("boolean").defaultValue((Object)false).add().property().name(INVISIBLE).label("reCAPTCHA v3").helpText("Whether the site key belongs to a v3 (invisible, score-based reCAPTCHA) or v2 site (visible, checkbox-based).").type("boolean").defaultValue((Object)false).add().build();
    }
}

