/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.browser;

import java.util.List;
import org.keycloak.Config;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorFactory;
import org.keycloak.authentication.ConfigurableAuthenticatorFactory;
import org.keycloak.authentication.authenticators.browser.RecoveryAuthnCodesFormAuthenticator;
import org.keycloak.common.Profile;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.ProviderConfigProperty;

public class RecoveryAuthnCodesFormAuthenticatorFactory
implements AuthenticatorFactory,
EnvironmentDependentProviderFactory {
    public static final String PROVIDER_ID = "auth-recovery-authn-code-form";

    public String getId() {
        return PROVIDER_ID;
    }

    public String getDisplayType() {
        return "Recovery Authentication Code Form";
    }

    public String getReferenceCategory() {
        return "recovery-authn-codes";
    }

    public boolean isConfigurable() {
        return false;
    }

    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return ConfigurableAuthenticatorFactory.REQUIREMENT_CHOICES;
    }

    public boolean isUserSetupAllowed() {
        return true;
    }

    public String getHelpText() {
        return "Validates a Recovery Authentication Code";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return null;
    }

    public Authenticator create(KeycloakSession keycloakSession) {
        return new RecoveryAuthnCodesFormAuthenticator(keycloakSession);
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public boolean isSupported(Config.Scope config) {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.RECOVERY_CODES);
    }
}

